; *************************************************************************
;
;  Program to reboot your computer if it has been up for more than 2-days
;  straight...  Original Code Written on Dec 21, 2001.  Program Revised to
;  Allow user to adjust Auto-Start properties in registry, and to display
;  an new "About Program" box.  This new box shows the current system 
;  uptime, since this is more appropriate than the MSShellAbout Dialogs
;  contents.  This revision was made on January 22, 2002.
;
;            Program works on Win9x and Win/NT type Platforms.
;
;       Source Donated to Public Domain by Summit Computer Networks.
;
; *************************************************************************
;
;       Compile this source with Hutch's MASM32 from www.movesd.com
;
; *************************************************************************

    .486
    .model flat, stdcall
    option casemap :none


    ;=================
    ; Include Files
    ;=================
    
    include \masm32\include\windows.inc
    include \masm32\include\user32.inc
    include \masm32\include\kernel32.inc
    include \masm32\include\gdi32.inc
    include \masm32\include\shell32.inc
    include \masm32\include\masm32.inc
    include \masm32\include\advapi32.inc

    ;====================
    ; Include Libraries
    ;====================
    
    includelib \masm32\lib\user32.lib
    includelib \masm32\lib\kernel32.lib
    includelib \masm32\lib\gdi32.lib
    includelib \masm32\lib\shell32.lib
    includelib \masm32\lib\masm32.lib
    includelib \masm32\lib\advapi32.lib

    ;=================
    ; Structures
    ;=================
    
    OSVINFO STRUCT
      dwOSVersionInfoSize   DWORD      ?
      dwMajorVersion        DWORD      ?
      dwMinorVersion        DWORD      ?
      dwBuildNumber         DWORD      ?
      dwPlatformId          DWORD      ?
      szCSDVersion          BYTE 128 dup (?)
    OSVINFO ENDS

    LUIDCUST STRUCT
      usedpart              DWORD      ?
      ignorehigh32bitpart   DWORD      ?
    LUIDCUST ENDS

    TOKEN_PRIVS STRUCT
      privilegecount        DWORD      ?
      theluid               LUIDCUST   <>
      attributes            DWORD      ?
    TOKEN_PRIVS ENDS

    ;=================
    ; Local prototypes
    ;=================
    
    WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
    WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
    AbtProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
    UpTime  PROTO :DWORD
    ChkReg  PROTO
    SetRegVal PROTO
    KillRegVal PROTO
    IsWinNt PROTO
    AdjustToken PROTO

    ;=================
    ; Equates
    ;=================
    
    WM_TRAYICON  equ WM_USER+400   ; For Tray Icon Calls
    WM_AUTOBOOT  equ WM_USER+500   ; For Initial Hide State
    WARNTIME     equ 172200000     ; 10 minutes less than BOOTTIME
    BOOTTIME     equ 172800000     ; 2-Days (1000ms x 3600 x 48)
    MS_ONEDAY    equ  86400000     ; Number of miliseconds in one day
    MS_ONEHOUR   equ  3600000      ; Number of miliseconds in one hour
    MS_ONEMIN    equ  60000        ; Number of miliseconds in one minute
    MS_ONESEC    equ  1000         ; Number of miliseconds in one second
    
    ;=================
    ; Macros
    ;=================

      szText MACRO Name, Text:VARARG
        LOCAL lbl
          jmp lbl
            Name db Text,0
          lbl:
        ENDM

      literal MACRO quoted_text:VARARG
        LOCAL local_text
        .data
          local_text db quoted_text,0
        .code
        EXITM <local_text>
      ENDM
      
      SADD MACRO quoted_text:VARARG
        EXITM <ADDR literal(quoted_text)>
      ENDM
      
; *************************************************************************

; GLOBAL Variables

    .data
        AboutDialog   dd 0   ; About Dialog In View Flag
        CommandLine   dd 0   ; Commandline Ptr
        hWnd          dd 0   ; Main Window Handle
        hInstance     dd 0   ; Instance Handle
        hIcon         dd 0   ; Program Icon Handle
        hTimer        dd 0   ; Timer Handle
        hMenu         dd 0   ; Popup Menu Handle
        lpIconData    dd 0   ; ICONDATA Pointer
        lpPntApi      dd 0   ; POINT Pointer
        iBootTime     dd 0   ; Boot Time in ms since last reboot
        iWarnTime     dd 0   ; Warn Time in ms since last reboot
        iDelays       dd 0   ; Number of time user delayed boot
        iWarned       dd 0   ; User has been Warned Flag, Countdown in prog
        wKey          dd 0   ; Key Location for Registry Key
        
        Period DB ".",0              ; String for Uptime Display
        RValue DB "AutoBoot",0       ; Registry Value
        RSectn DB "Software\Microsoft\Windows\CurrentVersion\Run",0
        
; *************************************************************************

    .code

start:

    invoke GetModuleHandle, NULL
    mov hInstance, eax

    invoke GetCommandLine
    mov CommandLine, eax

    invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
    invoke ExitProcess,eax


; *************************************************************************
; Main Entry Proc

WinMain proc hInst     :DWORD,
             hPrevInst :DWORD,
             CmdLine   :DWORD,
             CmdShow   :DWORD


      LOCAL tta:NOTIFYICONDATA     ; Tray Icon Info
      LOCAL pta:POINT              ; Popup Menu Info
      LOCAL tmd:DWORD              ; TEST MODE Flag

      ; First See if program is already running...

      invoke FindWindow,0,SADD("Auto Reboot Program")
      .if eax != 0
        invoke MessageBox,0,SADD("Program Already Running!"),\
                   SADD("Auto Reboot"),MB_ICONEXCLAMATION
        xor eax, eax    ; Return Zero
        ret
      .endif

      ; Set the Global wKey value.  Win/NT will default to CURRENT_USER
      ; and Win9x platforms will default to LOCAL_MACHINE.

      ; ALL Platforms to use HKLM, Un-comment below to change...

      ;invoke IsWinNt
      ;.if eax == 0
         mov eax, HKEY_LOCAL_MACHINE
         mov wKey, eax
      ;.else
      ;   mov eax, HKEY_CURRENT_USER
      ;   mov wKey, eax
      ;.endif
    
      invoke LoadIcon,hInst,500    ; Program icon ID
      mov hIcon, eax

      lea eax, tta                 ; Address of Structure into eax
      mov lpIconData, eax          ; pointer to structure
      lea eax, pta                 ; Address of Structure into eax
      mov lpPntApi, eax            ; pointer to structure

      ; See if we're running in "TEST MODE"
      
      invoke InString,1,CmdLine,SADD("/test")
         
      .if eax != 0
         invoke MessageBox,0,SADD("Running In Test Mode!"),\
             SADD("Will Begin Process in 5 Min"),MB_OK
         xor eax, eax   ; Zero eax
         inc eax        ; set eax to 1
         mov tmd, eax   ; set test mode flag to on
      .else
         xor eax, eax   ; Zero eax
         mov tmd, eax   ; set test mode flag to off
      .endif

      .if tmd != 0                 ; we're running in test mode
         invoke GetTickCount       ; get the tick count for now
         add eax, 300000           ; Set Warn Time 5 min from now
         mov iWarnTime, eax        ; save it to global
         add eax, 600000           ; set boot time to 10 after warn time
         mov iBootTime, eax        ; save it to global
      .else                        ; We're running in "Normal" mode
         mov eax, BOOTTIME         ; Starting Boot Time
         mov iBootTime, eax        ; Save it to Global var
         mov eax, WARNTIME         ; Starting Warn Time
         mov iWarnTime, eax        ; Save it to Global var
      .endif
      
      invoke DialogBoxParam,hInstance,100,HWND_DESKTOP,ADDR WndProc,NULL

      .if hIcon != 0
         invoke DeleteObject,hIcon ; Free up resources used
      .endif

      xor eax, eax                 ; return nothing
      ret

WinMain endp

; *************************************************************************
; Main Dialog proceedure

WndProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    LOCAL wParamL   :DWORD    ; wParam Low Word
    LOCAL wParamH   :DWORD    ; wParam High Word
    LOCAL lParamL   :DWORD    ; lParam Low Word
    LOCAL iWork     :DWORD    ; Work Variable
    LOCAL x         :DWORD    ; Menu x coord.
    LOCAL y         :DWORD    ; Menu y coord.
    
    mov eax, wParam        ; wParam to eax
    and eax, 0000FFFFh     ; strip off the low word
    mov wParamL, eax       ; save it to wParamL
    mov eax, wParam        ; wParam to eax
    shr eax, 16            ; get hiword
    mov wParamH, eax       ; save it to wParamH
    mov eax, lParam        ; lParam to eax
    and eax, 0000FFFFh     ; stip off the low word
    mov lParamL, eax       ; save it to lParamL

    .if uMsg == WM_COMMAND
    
        .if wParamL == 1000      ; Wait Button
           .if wParamH == BN_CLICKED
              inc iDelays        ; increment the number of delays
              cmp iDelays, 3     ; has it been more than 3 times?
              jg @F              ; if so no more delays...
              mov iWarned, 0     ; if not reset warned flag
              mov eax, iBootTime ; Boot Time into eax
              add eax, 600000    ; Add 10 More Minutes to original boot time
              mov iBootTime, eax ; Save it back to var
              mov eax, iWarnTime ; Warn Time into eax
              add eax, 600000    ; Add 10 More Minutes to it also
              mov iWarnTime, eax ; Save it Back
              invoke SetWindowPos,hWin,HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE Or SWP_NOMOVE
              invoke ShowWindow,hWin,SW_HIDE  ; Finally, Hide the window.
              xor eax, eax
              ret
              @@:
              szText ToomanyMsg,"System Will Reboot Anyway"
              szText ToomanyCap,"Cannot Delay Reboot Any Longer!"
              invoke MessageBox,hWin,ADDR ToomanyMsg,ADDR ToomanyCap,MB_ICONEXCLAMATION
              invoke SetWindowPos,hWin,HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE Or SWP_NOMOVE
              invoke ShowWindow,hWin,SW_HIDE
           .endif
        .elseif wParamL == 1001  ; Continue Button
           .if wParamH == BN_CLICKED
              invoke ShowWindow,hWin,SW_HIDE
           .endif
        .elseif wParamL == IDCANCEL
           szText CloseMsg,"Shutdown Auto Reboot Program ?"
           szText CloseCap,"Auto Reboot Program"
           invoke MessageBox,hWin,ADDR CloseMsg,ADDR CloseCap, MB_YESNO Or MB_DEFBUTTON2
           mov iWork, eax
           .if iWork == IDYES
              invoke EndDialog,hWin,0
           .endif
        .elseif wParamL == IDOK
           .if AboutDialog == 0
             mov eax, 1              ; Show that we're in View
             mov AboutDialog, eax    ; Set the Flag
             invoke DialogBoxParam,hInstance,200,HWND_DESKTOP,ADDR AbtProc,NULL
           .else
             invoke MessageBeep,MB_ICONEXCLAMATION
           .endif
        .endif    
    .elseif uMsg == WM_TIMER
       .if iWarned == 0
          invoke GetTickCount      ; Get the current run time in tics API call
          cmp eax, iWarnTime       ; Give a 10 minute warning...
          jg @F                    ; if we exceeded our time jump
          xor eax, eax             ; Clear eax because its a return value
          ret                      ; return
          @@:
          mov iWarned, 1           ; set iWarned Flag to True
          ; *** SET AS TOP MOST RIGHT AFTER YOU SHOW IT! ***
          invoke ShowWindow,hWin,SW_SHOW  ; Show Warning Window
          invoke SetWindowPos,hWin,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE Or SWP_NOMOVE
       .else
          invoke GetTickCount      ; Get the current run time in tics API call
          cmp eax, iBootTime       ; See if its time to reboot
          jg @F                    ; if we exceeded our time jump
          xor eax, eax             ; Clear eax because its a return value
          ret                      ; return
          @@:
          invoke AdjustToken       ; Get rights to restart on NT platforms
          mov wParamL, 6           ; 6 (4 or 2)  Force and Reboot
          mov wParamH, 00FFFFh     ; -1 
          invoke ExitWindowsEx,wParamL,wParamH  ; Restart the machine API Call
          invoke ExitProcess,0                  ; shutdown this process API Call    
       .endif
    .elseif uMsg == WM_AUTOBOOT

        invoke ShowWindow,hWin,SW_HIDE
    
    .elseif uMsg == WM_INITDIALOG
    
        .if hIcon != 0
           invoke SendMessage,hWin,WM_SETICON,ICON_BIG,hIcon
        .endif

        invoke LoadMenu,hInstance,1200   ; load the menu from the resource
        mov iWork, eax                   ; save the handle in iWork
        invoke GetSubMenu,iWork,NULL     ; get the submenu handle for it
        mov hMenu, eax                   ; save it in hMenu

        mov eax, lpIconData
        
        ASSUME eax:PTR NOTIFYICONDATA

        mov [eax].cbSize, 88
        mov edx, hWin
        mov [eax].hwnd, edx
        mov edx, hInstance
        mov [eax].uID, edx
        mov [eax].uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP
        mov [eax].uCallbackMessage, WM_TRAYICON
        mov edx, hIcon
        mov [eax].hIcon, edx
        mov [eax].szTip, 0
        
        ASSUME eax:nothing

        szText ToolTip,"Auto Reboot"  ; Set our desired tool tip
        mov edx, lpIconData           ; pointer to struct into edx
        add edx, 24                   ; offset to tip string
        mov iWork, edx                ; save it in iWork
        invoke szCatStr,iWork,ADDR ToolTip  ; Add it to the tool tip string

        invoke Shell_NotifyIcon,NIM_ADD,lpIconData
        
        invoke SetTimer,hWin,410,10000, ADDR WndProc   ; Poll every 10 secs
        mov hTimer, eax                              ; Save timer handle

        invoke PostMessage,hWin,WM_AUTOBOOT,0,0

    .elseif uMsg == WM_TRAYICON
        .if lParamL == WM_RBUTTONDOWN
           invoke IsWindowVisible,hWin
           .if eax == 0
              invoke SetForegroundWindow,hWin
              invoke GetCursorPos,lpPntApi
              mov eax, lpPntApi
              mov ecx, (POINT PTR [eax]).x
              mov x, ecx
              mov ecx, (POINT PTR [eax]).y
              mov y, ecx
              invoke TrackPopupMenu,hMenu,0,x,y,0,hWin,NULL
              invoke PostMessage,hWin,WM_NULL,0,0
           .endif
        .elseif lParamL == WM_LBUTTONDBLCLK
           invoke SetForegroundWindow,hWin
           invoke PostMessage,hWin,WM_COMMAND,IDOK,0
        .endif 
    .elseif uMsg == WM_SIZE

    .elseif uMsg == WM_PAINT

    .elseif uMsg == WM_CLOSE
        invoke EndDialog,hWin,0
        
    .elseif uMsg == WM_DESTROY

        .if hTimer != 0
           invoke KillTimer,hWin,hTimer
        .endif
        
        invoke Shell_NotifyIcon,NIM_DELETE,lpIconData
        
    .elseif uMsg == WM_SYSCOMMAND
    
        .if wParamL == SC_CLOSE
        
           invoke SetWindowPos,hWin,HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE Or SWP_NOMOVE
           invoke ShowWindow,hWin,SW_HIDE
           
        .elseif wParamL == SC_MINIMIZE
        
        .endif
        
    .endif

    xor eax, eax   ; Insure that default proc grabs it from here...

    ret

WndProc endp

; *************************************************************************
; About Window Dialog Proceedure

AbtProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    LOCAL wParamL:DWORD
    LOCAL iWork:DWORD
    LOCAL utstr[64]:BYTE

    mov eax, wParam        ; wParam to eax
    and eax, 0000FFFFh     ; strip off the low word
    mov wParamL, eax       ; save it to wParamL

    .if uMsg == WM_COMMAND
    
        .if wParamL == 206      ; Command 206 (OK BUTTON)

           invoke GetDlgItem,hWin,204    ; get handle to checkbox
           mov iWork, eax                ; save it in iWork
           invoke SendMessage,iWork,BM_GETCHECK,0,0  ; See if its checked
           mov iWork, eax

           .if iWork == 0              ; No check in checkbox so remove
              invoke ChkReg            ; the registry value if it is set
              .if eax != 0
                 invoke KillRegVal
              .endif
           .else                       ; Checkbox is checked so add the
              invoke ChkReg            ; registry value if it is not
              .if eax == 0             ; already there...
                 invoke SetRegVal
              .endif
           .endif   
        
           invoke EndDialog,hWin,0     ; close the window
           xor eax, eax                ; zero eax
           mov AboutDialog, eax        ; set Dialog Show Flag to FALSE (0)
        
        .elseif wParamL == 205  ; Command 205 (REFRESH BUTTON)

           invoke UpTime,ADDR utstr               ; get uptime to string
           invoke GetDlgItem,hWin,203             ; get label id
           mov iWork, eax                         ; save it to iWork
           invoke SetWindowText,iWork,ADDR utstr  ; set label text

        .elseif wParamL == 299  ; Custom Message to Set CheckBox

           invoke ChkReg                  ; See if Value in Reg is set
           .if eax != 0                   ; if so then set the checkbox
              invoke GetDlgItem,hWin,204  ; to show a check in it.
              mov iWork, eax
              invoke SendMessage,iWork,BM_SETCHECK,1,0
           .endif

        .endif
    
    .elseif uMsg == WM_INITDIALOG

        invoke PostMessage,hWin,WM_COMMAND,205,0  ; post a refresh label msg
        invoke PostMessage,hWin,WM_COMMAND,299,0  ; custom msg for checkbox
        
    .elseif uMsg == WM_CLOSE
        invoke EndDialog,hWin,0
        xor eax, eax
        mov AboutDialog, eax        
    .endif

    xor eax, eax   ; Insure that default proc grabs it from here...

    ret

AbtProc endp

; *************************************************************************
; Get the current system uptime to a Formatted String

UpTime proc lpBuffer:DWORD

    LOCAL msnow:DWORD           ; # of ms
    LOCAL days:DWORD            ; # of days
    LOCAL hours:DWORD           ; # of hours
    LOCAL mins:DWORD            ; # of minutes
    LOCAL secs:DWORD            ; # of seconds
    LOCAL lmsec[32]:BYTE        ; ms string
    LOCAL lsecs[32]:BYTE        ; secs string
    LOCAL lmins[32]:BYTE        ; mins string
    LOCAL lhour[32]:BYTE        ; hours string
    LOCAL ldays[32]:BYTE        ; days string


    mov eax, lpBuffer           ; Buffer Pointer into eax
    cmp eax, 0                  ; See if its a NULL pointer
    je UTDone                   ; if so get out

    ; Initialize All Variables!!
    
    xor eax, eax                ; zero eax
    mov days, eax               ; zero days
    mov hours, eax              ; zero hours
    mov mins, eax               ; zero minutes
    mov secs, eax               ; zero seconds
    
    mov eax, lpBuffer           ; address of Buffer into eax
    mov BYTE PTR [eax], 0       ; Initialize the Buffer

    invoke GetTickCount         ; Get the current run time in ms API call
    mov msnow, eax              ; save them in msnow

    @@:
    cmp eax, MS_ONEDAY          ; see if we're over a day
    jl  @F                      ; If not get hours
    inc days                    ; Increase the number of days
    sub eax, MS_ONEDAY          ; subtract one day from tics
    mov msnow, eax              ; Save it back to msnow
    jmp @B                      ; See if more days exist

    @@:
    cmp eax, MS_ONEHOUR         ; see if we're over an hour
    jl  @F                      ; if not get minutes
    inc hours                   ; up the number of hours
    sub eax, MS_ONEHOUR         ; subtract one hour from tics
    mov msnow, eax              ; save it back to msnow
    jmp @B                      ; check it for more hours

    @@:
    cmp eax, MS_ONEMIN          ; see if we're over a minute
    jl  @F                      ; if not get seconds
    inc mins                    ; up the number of minutes
    sub eax, MS_ONEMIN          ; subtract one minute from tics
    mov msnow, eax              ; save it back to msnow
    jmp @B                      ; see if there's more...

    @@:
    cmp eax, MS_ONESEC          ; see if we're over a second
    jl  @F                      ; if not we're done
    inc secs                    ; up the number of seconds
    sub eax, MS_ONESEC          ; decrease tics by one seconds worth
    mov msnow, eax              ; save remaining ms
    jmp @B                      ; see if there's more...
    
    @@:                         ; Check is done, now create the output str
       
    invoke dwtoa,days,ADDR ldays   ; * CONVERT THE DWORDS TO STRINGS
    invoke dwtoa,hours,ADDR lhour  ; * FOR ALL FIELDS
    invoke dwtoa,mins,ADDR lmins   ; *
    invoke dwtoa,secs,ADDR lsecs   ; *
    invoke dwtoa,msnow,ADDR lmsec  ; *

    ; Next Fix up Digit Lengths...

    invoke StrLen,ADDR lhour    ; get the string length of hours into eax
    cmp eax, 1                  ; see if its only 1 char long
    jg  @F                      ; if we're already 2 digits move on
    lea eax, lhour              ; address of string into eax
    mov cl, BYTE PTR [eax]      ; get char into cl
    mov BYTE PTR [eax], "0"     ; add the leading Zero
    mov BYTE PTR [eax+1], cl    ; put the original char in 2nd position
    mov BYTE PTR [eax+2], 0     ; Zero terminate it
    @@:
    invoke StrLen,ADDR lmins    ; get the string len of mins into eax
    cmp eax, 1                  ; see if its only one digit long
    jg @F                       ; if its 2 digits move on
    lea eax, lmins              ; address of string into eax
    mov cl, BYTE PTR [eax]      ; 1st char into cl
    mov BYTE PTR [eax], "0"     ; add the leading Zero
    mov BYTE PTR [eax+1], cl    ; move original char to position 2
    mov BYTE PTR [eax+2], 0     ; zero terminate the string
    @@:
    invoke StrLen,ADDR lsecs    ; get the string len of secs into eax
    cmp eax, 1                  ; see if its only one digit long
    jg @F                       ; if its 2 then move on
    lea eax, lsecs              ; address of lsecs into eax
    mov cl, BYTE PTR [eax]      ; save 1st digit in cl
    mov BYTE PTR [eax], "0"     ; put a zero in first position
    mov BYTE PTR [eax+1], cl    ; put original char in 2nd position
    mov BYTE PTR [eax+2], 0     ; zero terminate the string
    @@:
    invoke StrLen,ADDR lmsec    ; get the string len of milisecs into eax
    cmp eax, 1                  ; see if we're at one digit
    jg @F                       ; if its more than one, next check
    lea eax, lmsec              ; address of lmsec into eax
    mov cl, BYTE PTR [eax]      ; get digit into cl
    mov BYTE PTR [eax], "0"     ; 1st leading Zero
    mov BYTE PTR [eax+1], "0"   ; 2nd leading Zero
    mov BYTE PTR [eax+2], cl    ; original char
    mov BYTE PTR [eax+3], 0     ; Zero Terminator
    jmp UTBuildStr              ; Build the String Next
    @@:
    cmp eax, 2                  ; see if we're at 2 digits
    jg UTBuildStr               ; if its more than 2 move on
    lea eax, lmsec              ; address of lmsec into eax
    mov cl, BYTE PTR [eax]      ; 1st Digit into cl
    mov ch, BYTE PTR [eax+1]    ; 2nd Digit into ch
    mov BYTE PTR [eax], "0"     ; Leading Zero at pos 1
    mov BYTE PTR [eax+1], cl    ; 1st Digit at pos 2
    mov BYTE PTR [eax+2], ch    ; 2nd Digit at pos 3
    mov BYTE PTR [eax+3], 0     ; Zero Terminator

    UTBuildStr:    
    
    .if days == 0
      invoke szCatStr,ADDR ldays,SADD(" Days ")
    .else
      invoke szCatStr,ADDR ldays,SADD(" Day ")
    .endif

    .if hours == 1
      invoke szCatStr,ADDR lhour,SADD(" Hour ")
    .else
      invoke szCatStr,ADDR lhour,SADD(" Hours ")
    .endif

    .if mins == 1
      invoke szCatStr,ADDR lmins,SADD(" Min ")
    .else
      invoke szCatStr,ADDR lmins,SADD(" Mins ")
    .endif

    ; Build Main String
    
    invoke szCatStr,lpBuffer,ADDR ldays  ; start building our output string
    invoke szCatStr,lpBuffer,ADDR lhour  ; to the main string
    invoke szCatStr,lpBuffer,ADDR lmins  ; to make the final
    invoke szCatStr,lpBuffer,ADDR lsecs  ;
    invoke szCatStr,lpBuffer,ADDR Period ;
    invoke szCatStr,lpBuffer,ADDR lmsec  ;
    invoke szCatStr,lpBuffer,SADD(" Secs")
    
    UTDone:
    xor eax, eax                ; zero the eax since there's no rtn value
    ret

UpTime endp

; *************************************************************************
; Check the Registry to see of we have a value set in the AutoStart key

ChkReg proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE  ; MUST BE 300 Minimum for NT!

    invoke RegCreateKeyEx,wKey,ADDR RSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result
           
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry!"),\
           SADD("ERROR!"),16
       ret
    .endif

    mov eax, SizeOf zBuf
    mov rslt, eax         ; SizeOf zBuf in rslt

    invoke RegQueryValueEx,hReg,ADDR RValue,0,0,ADDR zBuf,ADDR rslt
    
    mov rslt, eax
    
    invoke RegCloseKey,hReg
    xor eax, eax

    .if rslt == ERROR_SUCCESS
       inc eax
    .endif
       
    ret
    
ChkReg endp

; *************************************************************************
; Set an AutoStart Value in the registry

SetRegVal proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE
    LOCAL Path[OFS_MAXPATHNAME]:BYTE

    invoke RegCreateKeyEx,wKey,ADDR RSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result
           
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry!"),\
           SADD("ERROR!"),16
       ret
    .endif

    invoke GetModuleFileName,0,ADDR Path,OFS_MAXPATHNAME
    
    invoke RegSetValueEx,hReg,ADDR RValue,0,REG_SZ,ADDR Path,SizeOf Path
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Registry Error!"),\
           SADD("ERROR!"),16
    .endif

    invoke RegCloseKey,hReg
    xor eax, eax
    ret
    
SetRegVal endp

; *************************************************************************
; Remove our AutoStart value from the registry

KillRegVal proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE
    
    invoke RegCreateKeyEx,wKey,ADDR RSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result
           
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry!"),\
           SADD("ERROR!"),16
       ret
    .endif

    invoke RegDeleteValue,hReg,ADDR RValue

    invoke RegCloseKey,hReg
    xor eax, eax
    ret
    
KillRegVal endp

; *************************************************************************
; Return 1 if the OS is an NT Based Platform, othrwise return 0

IsWinNt proc

    LOCAL vi:OSVINFO     ; Version Info Struct
    LOCAL pvi:DWORD      ; Pointer To vi


    lea eax, vi                         ; vi's address into eax
    mov ecx, SizeOf vi                  ; sizeof vi struct into ecx
    mov (OSVINFO PTR [eax]).dwOSVersionInfoSize, ecx    ; copy size to element
    mov pvi, eax                        ; ptr to vi into pvi
    invoke GetVersionEx,pvi             ; get version API call
    cmp eax, 0                          ; See if we got an error
    je  IsWinNtError
    
    mov eax, pvi                        ; address back into eax
    mov ecx, (OSVINFO PTR [eax]).dwPlatformId  ; Platform ID into ecx
    cmp ecx, VER_PLATFORM_WIN32_NT      ; see if its an NT platform
    je  IsWinNtTrue

    mov eax, 0                          ; Return a Zero since its NOT NT
    ret
    
    IsWinNtTrue:
    mov eax, 1                          ; Return 1 since it IS NT
    ret

    IsWinNtError:
    mov eax, 2                          ; Return 2 indicating an Error
    
    ret

IsWinNt endp

; *************************************************************************
; For NT Type Platforms get the privilege for a Shutdown/Restart.

AdjustToken proc

    LOCAL hdlProcessHandle:DWORD
    LOCAL hdlTokenHandle:DWORD
    LOCAL tmpLuid:LUIDCUST
    LOCAL tkp:TOKEN_PRIVS
    LOCAL tkpNewButIgnored:TOKEN_PRIVS
    LOCAL lBufferNeeded:DWORD
    LOCAL tBuff[32]:BYTE
    LOCAL ptBuff:DWORD

    invoke IsWinNt                 ; see if we're on an NT platform
    cmp eax, 1                     ; a return of 1 means NT platform.
    jne AdjTokDone

    invoke GetCurrentProcess       ; get the current process handle
    mov hdlProcessHandle,eax       ; save it to hdlProcessHandle

    lea eax, tBuff                 ; address of temp buffer into eax
    mov ptBuff, eax                ; set pointer to temp buffer
    mov BYTE PTR [eax], 0          ; initialize the buffer

    invoke OpenProcessToken,hdlProcessHandle,40,ADDR hdlTokenHandle
    invoke LookupPrivilegeValue,ptBuff,SADD("SeShutdownPrivilege"),ADDR tmpLuid

    lea eax, tmpLuid               ; address of tmpLuid into eax

    ; Contents of tmpLuid into ecx:edx
    mov ecx, (LUIDCUST PTR [eax]).usedpart
    mov edx, (LUIDCUST PTR [eax]).ignorehigh32bitpart
    
    lea eax, tkp                   ; address of tkp into eax
    
    mov (TOKEN_PRIVS PTR [eax]).privilegecount, 1
    mov (TOKEN_PRIVS PTR [eax]).theluid.usedpart, ecx
    mov (TOKEN_PRIVS PTR [eax]).theluid.ignorehigh32bitpart, edx
    mov (TOKEN_PRIVS PTR [eax]).attributes, 2

    invoke AdjustTokenPrivileges,hdlTokenHandle,0,ADDR tkp,\
        SizeOf tkpNewButIgnored,ADDR tkpNewButIgnored,ADDR lBufferNeeded

    AdjTokDone:

    ret

AdjustToken endp

; *************************************************************************

end start
