title   Base64 Decoder
; 	Author:	Jamie Graham
;	Date: 2/4/2002
;	Name:  test.asm
;	Description:  Base64 Decoder Program
;	Input Parameters:  Base64 encoded text
;	Output Parameters: Decoded ASCII text
;	Destroys:
;	Version:  1.0
;	Compiler:  MASM 6.14.8444
;	Linker:  Link.exe 5.12.8078
;	Linked Source Code:  windows.inc,kernel32.*, user32.*,gdi32.*,comdlg32.*
		
.386
.model flat,stdcall
option casemap:none

WinMain proto :DWORD,:DWORD,:DWORD,:DWORD
Base64	proto	:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
ClearBuffer proto :DWORD
DlgProc PROTO :DWORD, :DWORD, :DWORD, :DWORD

include windows.inc
include user32.inc
include kernel32.inc
include gdi32.inc
include comdlg32.inc
includelib user32.lib
includelib kernel32.lib
includelib gdi32.lib
includelib comdlg32.lib

RGB macro red,green,blue 
        xor eax,eax 
        mov ah,blue 
        shl eax,8 
        mov ah,green 
        mov al,red 
endm 

.const
IDM_CLEAR	equ	01h
IDM_EXIT	equ	02h                ; ID of the edit control
IDI_ICON	equ	03h
IDB_MAIN	equ	100
IDM_ABOUT	equ	101
IDD_ABOUT	equ	102
IDM_HELPTOPICS	equ	103
EditID		equ	11h
ButtonID 	equ 	12h               ; The control ID of the button control
UserNameID	equ	13h
PasswordID	equ	14h

.data
ClassName 	db 	"Win32ASMEditClass",0 
AppName  	db 	"Base64 Decoder",0 
MenuName	db	"MyMenu",0
EditClassName 	db 	"edit",0
ButtonClassName db 	"button",0
StaticClassName	db	"static",0 
ButtonText 	db 	"Decode",0
UserNameText	db	"Username:"
PasswordText	db	"Password:"
FontName 	db 	"script",0
XTable		db	'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U'
		db	'V','W','X','Y','Z','a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q'
		db	'r','s','t','u','v','w','x','y','z','0','1','2','3','4','5','6','7','8','9','+','/'

.data?
hInstance 	HINSTANCE 	? 
CommandLine 	LPSTR 	? 
hwndEdit	HWND	?
hwndButton	HWND	?
hwndUserName	HWND	?
hwndPassword	HWND	?
Buffer	db	512 dup(?)
User	db	512 dup(?)
Pass	db	512 dup(?)
Base64Buff	db	512 dup(?)
ASCIIBuff	db	512 dup(?)
hBitmap		HWND	?


 
.code
start:
	invoke 	GetModuleHandle, NULL
	mov    	hInstance,eax
	invoke 	GetCommandLine
	mov 	CommandLine,eax
	invoke 	WinMain, hInstance,NULL,CommandLine, SW_SHOWDEFAULT
	invoke 	ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL	wc:WNDCLASSEX
	LOCAL 	msg:MSG
	LOCAL 	hwnd:HWND
	mov   	wc.cbSize,SIZEOF WNDCLASSEX
	mov   	wc.style, CS_HREDRAW or CS_VREDRAW
	mov   	wc.lpfnWndProc, OFFSET WndProc
	mov   	wc.cbClsExtra,NULL
	mov   	wc.cbWndExtra,NULL
	push  	hInst
	pop   	wc.hInstance
	mov   	wc.hbrBackground,COLOR_WINDOW+1
	mov   	wc.lpszMenuName,OFFSET MenuName
	mov   	wc.lpszClassName,OFFSET ClassName
	invoke 	LoadIcon,hInst,IDI_ICON
	mov   	wc.hIcon,eax
	invoke 	LoadCursor,NULL,IDC_ARROW
	mov   	wc.hCursor,eax
	invoke	LoadImage, hInst, IDI_ICON, IMAGE_ICON, 16, 16, NULL
	mov	wc.hIconSm, eax
	invoke 	RegisterClassEx, addr wc
	invoke CreateWindowEx,NULL,\ 
                ADDR ClassName,\ 
                ADDR AppName,\ 
                WS_OVERLAPPEDWINDOW,\ 
                CW_USEDEFAULT,\ 
                CW_USEDEFAULT,\ 
                300,\ 
                350,\ 
                NULL,\ 
                NULL,\ 
                hInst,\ 
                NULL 
 
    	mov   hwnd,eax 
	INVOKE 	ShowWindow, hwnd,SW_SHOWNORMAL
	INVOKE 	UpdateWindow, hwnd
	.WHILE 	TRUE
        	INVOKE GetMessage, ADDR msg,NULL,0,0
                .BREAK .IF (!eax)
              	invoke TranslateMessage, ADDR msg
                INVOKE DispatchMessage, ADDR msg
	.ENDW
	mov    	eax,msg.wParam
	ret
WinMain endp

WndProc proc hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
 	LOCAL hdc:HDC 
    	LOCAL ps:PAINTSTRUCT 
    	LOCAL hfont:HFONT 
	LOCAL hMemDC:HDC 
   	LOCAL rect:RECT 

	.IF (uMsg==WM_DESTROY)                           	; if the user closes our window 
		invoke DeleteObject,hBitmap
        	invoke PostQuitMessage,NULL             	; quit our application 
  	.ELSEIF (uMsg == WM_CREATE) 
        	invoke 	CreateWindowEx,WS_EX_CLIENTEDGE, ADDR EditClassName,NULL,\ 
                        WS_CHILD or WS_VISIBLE or WS_BORDER or ES_LEFT or\ 
                        ES_AUTOHSCROLL,\ 
                        50,35,200,25,hWnd,EditID,hInstance,NULL 
        	mov  	hwndEdit,eax 
        	invoke 	SetFocus, hwndEdit 
		invoke 	CreateWindowEx,NULL, ADDR ButtonClassName,ADDR ButtonText,\ 
                        WS_CHILD or WS_VISIBLE or BS_DEFPUSHBUTTON,\ 
                        75,70,140,25,hWnd,ButtonID,hInstance,NULL 
        	mov  	hwndButton,eax 
		invoke 	CreateWindowEx,WS_EX_CLIENTEDGE, ADDR EditClassName,NULL,\ 
                        WS_CHILD or WS_VISIBLE or WS_BORDER or ES_LEFT or\ 
                        ES_AUTOHSCROLL,\  
                        50,140,200,25,hWnd,UserNameID,hInstance,NULL 
        	mov  	hwndUserName,eax
		invoke 	CreateWindowEx,WS_EX_CLIENTEDGE, ADDR EditClassName,NULL,\ 
                        WS_CHILD or WS_VISIBLE or WS_BORDER or ES_LEFT or\ 
                        ES_AUTOHSCROLL,\  
                        50,200,200,25,hWnd,PasswordID,hInstance,NULL 
        	mov  	hwndPassword,eax
		invoke 	LoadBitmap,hInstance,IDB_MAIN 
      		mov 	hBitmap,eax 

	.ELSEIF (uMsg == WM_COMMAND)
		mov	eax,wParam
		.IF (lParam == 0)
			.IF (AX == IDM_CLEAR)
				invoke 	SetWindowText,hwndEdit,NULL
				invoke 	SetWindowText,hwndUserName,NULL
				invoke 	SetWindowText,hwndPassword,NULL
				invoke 	ClearBuffer,ADDR User
				invoke 	ClearBuffer,ADDR Pass
				invoke 	ClearBuffer,ADDR Buffer
			.ELSEIF (AX == IDM_ABOUT)
				invoke 	DialogBoxParam,hInstance, IDD_ABOUT,hWnd,OFFSET DlgProc,NULL
			.ELSEIF (AX == IDM_HELPTOPICS)
				invoke DefWindowProc,hWnd,uMsg,wParam,lParam     ; Default message processing
			.ELSE
				invoke	DestroyWindow,hWnd
			.ENDIF
		.ELSE 
            		.IF (ax == ButtonID) 
                		shr 	eax,16 
                		.IF (ax == BN_CLICKED)
					invoke 	GetWindowText,hwndEdit,ADDR Buffer,512
					invoke	Base64,ADDR Buffer, ADDR User, ADDR XTable, ADDR Pass, ADDR Base64Buff,\
					ADDR ASCIIBuff
					invoke SetWindowText,hwndUserName,ADDR User
					invoke SetWindowText,hwndPassword,ADDR Pass
				.ELSE
					invoke DefWindowProc,hWnd,uMsg,wParam,lParam     ; Default message processing 
				.ENDIF
			.ELSE
				invoke DefWindowProc,hWnd,uMsg,wParam,lParam     ; Default message processing 
			.ENDIF

		.ENDIF
	.ELSEIF (uMsg == WM_PAINT) 
        	invoke 	BeginPaint,hWnd,ADDR ps 
        	mov    	hdc,eax 
		invoke 	TextOut,hdc,50,120,ADDR UserNameText,SIZEOF UserNameText
		invoke 	TextOut,hdc,50,180,ADDR PasswordText,SIZEOF PasswordText
		invoke 	CreateCompatibleDC,hdc 
      		mov    	hMemDC,eax 
      		invoke 	SelectObject,hMemDC,hBitmap 
      		invoke 	GetClientRect,hWnd,addr rect 
      		invoke 	BitBlt,hdc,100,250,rect.right,rect.bottom,hMemDC,0,0,SRCCOPY 
      		invoke 	DeleteDC,hMemDC 
		invoke 	EndPaint,hWnd, ADDR ps
	.ELSE 
        	invoke DefWindowProc,hWnd,uMsg,wParam,lParam     ; Default message processing 
        	ret 
    	.ENDIF 
    xor eax,eax 
    ret 

WndProc endp

Base64 proc Source:DWORD, Dest1:DWORD, Table:DWORD, Dest2:DWORD, RAW:DWORD, DECODE:DWORD
	
	pushad
	
	xor	ecx,ecx
	mov	esi,Source
	mov	ebx,RAW
	cld
	

L0:	mov	edi,Table
	push	edi
	mov	ecx,64
	mov	al,[esi]
	repnz	scasb
	jnz	L1

	dec	edi
	mov	edx,edi
	pop	ecx
	sub	edx,ecx
	mov	[ebx],dl
	inc	esi
	inc	ebx
	jmp	L0

L1:	pop	edi
	inc	ebx
	mov	al,'@'
	mov	[ebx],al
	mov	esi,RAW
	mov	edi,DECODE
	
	

	.WHILE (TRUE)
		mov	ax,[esi]	; Phase 1 (6:2)
		.IF (AL == '@') || (AH == '@')
			.BREAK
		.ENDIF
		shl	ah,2
		clc
		rol	ax,2	
		mov	[edi],al
		
		
		add	esi,2		; Phase 2 (4:4)
		inc	edi
		xor	al,al
		mov	al,[esi]
		.IF (AL == '@')
			.BREAK
		.ENDIF
		shl	al,2
		shr	ah,4
		shl	ax,4
		mov	[edi],ah
		
		inc	esi		; Phase 3 (2:6)
		inc	edi
		shl	ax,8
		mov	al,[esi]
		.IF (AL == '@')
			.BREAK
		.ENDIF
		shr	ah,6
		shl	al,2
		shl	ax,6
		mov	[edi],ah
		inc	esi
		inc	edi
	.ENDW

	mov	edi,DECODE		; Phase 4 (Parse Scratch Buffer and populate Username and Password Buffers)
	push	edi
	mov	al,':'			
	xor	ecx,ecx
	mov	ecx,1024
	repnz	scasb
	.IF (ZERO?)
		dec	edi
		mov	ecx,edi
		pop	edi
		sub	ecx,edi
		mov	edi,Dest1
		mov	esi,DECODE
		rep	movsb
		inc	esi
		mov	edi,Dest2
		mov	ecx,1024
		rep	movsb
	.ELSE
		add	esp,4
	.ENDIF
	
	
Exit:	popad
	ret
Base64 endp

ClearBuffer proc TEMPVAR:DWORD
	pushad

	xor	ecx,ecx
	xor	eax,eax
	mov	ecx,512
	mov	edi,TEMPVAR
	cld
	mov	eax,20202020h
	rep	stosd
	

	popad
	ret

ClearBuffer endp

DlgProc PROC hWnd:HWND,iMsg:DWORD,wParam:WPARAM, lParam:LPARAM
	.IF (iMsg == WM_INITDIALOG)
		invoke GetDlgItem,hWnd,IDOK
		invoke SetFocus,eax
	.ELSEIF (iMsg == WM_COMMAND)
		mov eax,wParam
		mov edx,eax
		shr edx,16
		.IF (dx == BN_CLICKED)
			.IF (eax == IDOK) || (eax== IDCANCEL)
				invoke	EndDialog, hWnd, TRUE
			.ENDIF
		.ENDIF
	.ELSE
		mov eax,FALSE
		ret
	.ENDIF
	mov  eax,TRUE
	ret
DlgProc endp

end start
