;
; CelFah v1.0
; Dee-Jon Bryce, Jan 2001
;
; The basic Win32 program skeleton.
;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; USUAL ASSEMBLER DIRECTIVES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.686
.MODEL FLAT, STDCALL
OPTION CASEMAP :NONE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; INCLUDES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
INCLUDE macros.inc

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FUNCTION PROTOTYPES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DlgProc		PROTO :DWORD,:DWORD,:DWORD,:DWORD
ZeroMemory	PROTO :DWORD,:DWORD
CheckText	PROTO :DWORD
StrCopy		PROTO :DWORD,:DWORD,:DWORD
Cel2Fah		PROTO :DWORD,:DWORD
Fah2Cel		PROTO :DWORD,:DWORD

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; EQUATES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
IDD_DIALOG			EQU 100
IDC_CEL				EQU 101
IDC_FAH				EQU 102
IDI_BIG				EQU 200
IDI_SMALL			EQU 201
IDB_TOPON			EQU 300
IDB_TOPOFF			EQU 301
IDB_TRAY			EQU	302
IDB_RESTORE			EQU 303
IDB_EXIT			EQU 304
IDM_MENU			EQU 400
IDM_RESTORE			EQU 401
IDM_EXIT			EQU	402
MENU_TOP			EQU 1
MENU_TRAY			EQU 2
WM_TRAY				EQU WM_APP+1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; INITIALISED DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.DATA
szTop	BYTE '&Always on top',0
szTray	BYTE '&Tray icon',0
szTip	BYTE 'Temperature Converter',0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; UNINITIALISED DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.DATA?
hInstance			HINSTANCE ?
szBuffer			BYTE 24 DUP (?)			; Buffer to store user input
szValid				BYTE 24 DUP (?)			; Stores the previous valid input
bCheckFlag			DWORD ?					; Flag to determine if input needs to be checked for validity
bTopFlag			DWORD ?					; Flag to determine whether window is topmost
dwNum5				DWORD ?					; The number 5 (used for FPU)
dwNum9				DWORD ?					; The number 9 (used for FPU)
dwNum32				DWORD ?					; The number 32 (used for FPU)
hBig				HICON ?					; ||  The rest are handles to menus, icons & bitmaps
hSmall				HICON ?					; \/
hMenu				HMENU ?
hPopup				HMENU ?
hTopOn				HBITMAP ?
hTopOff				HBITMAP ?
hTray				HBITMAP ?
hRestore			HBITMAP ?
hExit				HBITMAP ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.CODE

Start:

	invoke GetModuleHandle, NULL
	mov hInstance, eax
	invoke DialogBoxParam, eax, IDD_DIALOG, NULL, OFFSET DlgProc, 0
	invoke ExitProcess, eax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FUNCTIONS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DlgProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
LOCAL IconData	:NOTIFYICONDATA
LOCAL pnt		:POINT

	.IF uMsg==WM_CLOSE

		; Delete handles
		invoke DeleteObject, hTopOn
		invoke DeleteObject, hTopOff
		invoke DeleteObject, hTray
		invoke DeleteObject, hRestore
		invoke DeleteObject, hExit
		invoke DestroyIcon, hSmall
		invoke DestroyIcon, hBig
		invoke DestroyMenu, hPopup

		; Destroy dialog
		invoke EndDialog, hWnd, 0

	.ELSEIF uMsg==WM_INITDIALOG

		; Load bitmaps
		invoke LoadBitmap, hInstance, IDB_TOPON
		mov hTopOn, eax
		invoke LoadBitmap, hInstance, IDB_TOPOFF
		mov hTopOff, eax
		invoke LoadBitmap, hInstance, IDB_TRAY
		mov hTray, eax
		invoke LoadBitmap, hInstance, IDB_RESTORE
		mov hRestore, eax
		invoke LoadBitmap, hInstance, IDB_EXIT
		mov hExit, eax

		; Load icons
		invoke LoadIcon, hInstance, IDI_SMALL
		mov hSmall, eax
		invoke LoadIcon, hInstance, IDI_BIG
		mov hBig, eax

		; Get system menu and popup menu
		invoke GetSystemMenu, hWnd, FALSE
		mov hMenu, eax
		invoke LoadMenu, hInstance, IDM_MENU
		mov hPopup, eax

		; Append menu items to system menu
		invoke AppendMenu, hMenu, MF_SEPARATOR, 0, 0
		invoke AppendMenu, hMenu, MF_UNCHECKED or MF_STRING, MENU_TOP, OFFSET szTop
		invoke AppendMenu, hMenu, MF_UNCHECKED or MF_STRING, MENU_TRAY, OFFSET szTray

		; Set the bitmaps for menu items
		invoke SetMenuItemBitmaps, hMenu, MENU_TOP, 0, hTopOff, hTopOn
		invoke SetMenuItemBitmaps, hMenu, MENU_TRAY, 0, hTray, hTray
		invoke SetMenuItemBitmaps, hPopup, IDM_RESTORE, 0, hRestore, hRestore
		invoke SetMenuItemBitmaps, hPopup, IDM_EXIT, 0, hExit, hExit

		; Set the icons for the application
		invoke SendMessage, hWnd, WM_SETICON, ICON_SMALL, hSmall
		invoke SendMessage, hWnd, WM_SETICON, ICON_BIG, hBig

		; Initialise variables
		invoke ZeroMemory, OFFSET szBuffer, 24
		invoke ZeroMemory, OFFSET szValid, 24
		mov bCheckFlag, TRUE
		mov bTopFlag, FALSE
		mov dwNum5, 5
		mov dwNum9, 9
		mov dwNum32, 32

		; SetFocus on the Celsius edit control
		invoke GetDlgItem, hWnd, IDC_CEL
		invoke SetFocus, eax

		; Must return FALSE since we've used SetFocus
		return FALSE

	.ELSEIF uMsg==WM_SYSCOMMAND ; User clicked an item on the system menu

		loWord wParam
		.IF ax==MENU_TOP ; User clicked 'Always on top'

			.IF bTopFlag ; If window is already topmost, reset flag, uncheck menu item, and set to notopmost
				mov bTopFlag, FALSE
				invoke CheckMenuItem, hMenu, MENU_TOP, MF_UNCHECKED
				invoke SetWindowPos, hWnd, HWND_NOTOPMOST, 0,0,0,0, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE

			.ELSE ; If window is not topmost, set flag, check menu item, and set to topmost
				mov bTopFlag, TRUE
				invoke CheckMenuItem, hMenu, MENU_TOP, MF_CHECKED
				invoke SetWindowPos, hWnd, HWND_TOPMOST, 0,0,0,0, SWP_NOACTIVATE or SWP_NOMOVE or SWP_NOSIZE

			.ENDIF

		.ELSEIF ax==MENU_TRAY ; User clicked 'Tray icon'

			; Fill the required fields
			mov IconData.cbSize, SIZEOF NOTIFYICONDATA
			m2m IconData.hwnd, hWnd
			mov IconData.uID, IDB_TRAY
			mov IconData.uCallbackMessage, WM_TRAY
			m2m IconData.hIcon, hSmall
			mov IconData.uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP
			invoke StrCopy, ADDR IconData.szTip, OFFSET szTip, 24

			; Add an icon to system tray, hide main window
			invoke Shell_NotifyIcon, NIM_ADD, ADDR IconData
			invoke ShowWindow, hWnd, SW_HIDE

		.ELSE
			; Let Windows handle the rest (Close, Move)
			return FALSE
		.ENDIF

	.ELSEIF uMsg==WM_TRAY ; Icon on system tray recieved a message

		.IF lParam==WM_RBUTTONDOWN ; Check if the user has right-clicked

			; Display popup menu to the correct alignment with the mouse position
			invoke GetCursorPos, ADDR pnt
			invoke SetForegroundWindow, hWnd
			invoke GetSubMenu, hPopup, 0
			invoke TrackPopupMenu, eax, TPM_BOTTOMALIGN or TPM_RIGHTALIGN, pnt.x, pnt.y, 0, hWnd, 0

		.ENDIF

	.ELSEIF uMsg==WM_COMMAND

		loWord wParam ; Check menu item clicks
		.IF ax==IDM_RESTORE ; Restore main window

			; Fill required fields
			mov IconData.cbSize, SIZEOF NOTIFYICONDATA
			m2m IconData.hwnd, hWnd
			mov IconData.uID, IDB_TRAY
			mov IconData.uCallbackMessage, WM_TRAY
			m2m IconData.hIcon, hSmall
			mov IconData.uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP

			; Remove tray icon, display main window
			invoke Shell_NotifyIcon, NIM_DELETE, ADDR IconData
			invoke ShowWindow, hWnd, SW_SHOWNORMAL

		.ELSEIF ax==IDM_EXIT ; Exit program

			; Fill required fields
			mov IconData.cbSize, SIZEOF NOTIFYICONDATA
			m2m IconData.hwnd, hWnd
			mov IconData.uID, IDB_TRAY
			mov IconData.uCallbackMessage, WM_TRAY
			m2m IconData.hIcon, hSmall
			mov IconData.uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP

			; Remove tray icon, send close message to main window
			invoke Shell_NotifyIcon, NIM_DELETE, ADDR IconData
			invoke PostMessage, hWnd, WM_CLOSE, 0, 0

		.ENDIF

		hiWord wParam ; Check edit control messages
		.IF ax==EN_SETFOCUS

			; Organise buffers
			invoke SendMessage, lParam, WM_GETTEXT, 24, OFFSET szValid

		.ELSEIF (ax==EN_UPDATE) && (bCheckFlag)

			; Get text from edit control
			invoke SendMessage, lParam, WM_GETTEXT, 24, OFFSET szBuffer

			.IF !eax ; No text

				invoke ZeroMemory, OFFSET szBuffer, 24
				invoke ZeroMemory, OFFSET szValid, 24
				mov bCheckFlag, FALSE
				invoke SetDlgItemText, hWnd, IDC_CEL, OFFSET szValid
				invoke SetDlgItemText, hWnd, IDC_FAH, OFFSET szValid
				mov bCheckFlag, TRUE
				return TRUE

			.ENDIF

			; Check for validity
			invoke CheckText, OFFSET szBuffer

			.IF !eax ; Invalid, so replace with the previous valid text

				mov bCheckFlag, FALSE
				invoke SendMessage, lParam, WM_SETTEXT, 0, OFFSET szValid
				mov bCheckFlag, TRUE

			.ELSE ; Valid, copy to valid buffer, and convert input

				invoke StrCopy, OFFSET szValid, OFFSET szBuffer, 24

				loWord wParam
				.IF ax==IDC_CEL ; Convert from Celsius to Fahrenheit

					invoke Cel2Fah, OFFSET szBuffer, OFFSET szValid
					mov bCheckFlag, FALSE
					invoke SetDlgItemText, hWnd, IDC_FAH, OFFSET szBuffer
					mov bCheckFlag, TRUE

				.ELSE ; Convert from Fahrenheit to Celsius

					invoke Fah2Cel, OFFSET szBuffer, OFFSET szValid
					mov bCheckFlag, FALSE
					invoke SetDlgItemText, hWnd, IDC_CEL, OFFSET szBuffer
					mov bCheckFlag, TRUE

				.ENDIF

			.ENDIF

		.ENDIF

	.ELSE

		return FALSE ; Message wasnt handled, return FALSE so the default dialog procedure handles it

	.ENDIF

	return TRUE ; Message was handled, so return TRUE

DlgProc ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ZeroMemory PROC szPtr:DWORD, dwSize:DWORD ; Zero fill a memory location

	mov ecx, dwSize
	shr ecx, 2

	push edi
	mov eax, szPtr
	mov edi, eax

	xor eax, eax
	rep stosd

	mov ecx, dwSize
	and ecx, 3
	rep stosb

	pop edi
	ret

ZeroMemory ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CheckText PROC szPtr:DWORD ; Determine whether input is a valid floatin-point number

	push esi
	mov eax, szPtr
	mov esi, eax

	xor ecx, ecx  ; Floating-point dot flag
	mov edx, TRUE ; Validity flag (assume TRUE)

	lodsb
	cmp al, 0
	je finished

	.IF (al == '.') ; First character can be '-', '0'-'9', '.'
		not ecx
	.ELSEIF (al != '-') && ((al < '0') || (al > '9'))
		xor edx, edx
		jmp finished
	.ENDIF

again:
	lodsb
	cmp al, 0
	je finished

	.IF al=='.'
		.IF ecx ; Check if the dot has already been used
			xor edx, edx
			jmp finished
		.ELSE
			not ecx
		.ENDIF
	.ELSEIF (al < '0') || (al > '9')
		xor edx, edx
		jmp finished
	.ENDIF
	jmp again

finished:
	pop esi
	mov eax, edx
	ret

CheckText ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

StrCopy PROC szDest:DWORD, szSrc:DWORD, dwSize:DWORD ; Copy a string to another

	push esi
	push edi

	mov eax, szDest
	mov edi, eax
	mov eax, szSrc
	mov esi, eax

	mov ecx, dwSize
	shr ecx, 2

	rep movsd

	mov ecx, dwSize
	and ecx, 3

	rep movsb

	pop edi
	pop esi
	ret

StrCopy ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Cel2Fah PROC szDest:DWORD, szSrc:DWORD ; Celsius to Fahrenheit
LOCAL qwCel:QWORD
LOCAL qwFah:QWORD

	invoke StrToFloat, szSrc, ADDR qwCel

	finit
	fild dwNum32
	fild dwNum5
	fild dwNum9
	fld qwCel

	fmul st(0), st(1)
	fdiv st(0), st(2)
	fadd st(0), st(3)

	fst qwFah

	invoke FloatToStr, qwFah, szDest
	ret

Cel2Fah ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

Fah2Cel PROC szDest:DWORD, szSrc:DWORD ; Fahrenheit to Celsius
LOCAL qwCel:QWORD
LOCAL qwFah:QWORD

	invoke StrToFloat, szSrc, ADDR qwFah

	finit
	fild dwNum9
	fild dwNum5
	fild dwNum32
	fld qwFah

	fsub st(0), st(1)
	fmul st(0), st(2)
	fdiv st(0), st(3)

	fst qwCel

	invoke FloatToStr, qwCel, szDest
	ret

Fah2Cel ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

End Start

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
