; #########################################################################

      .386
      .model flat, stdcall
      option casemap :none   ; case sensitive

; #########################################################################

      include D:\masm32\include\windows.inc

      include D:\masm32\include\user32.inc
      include D:\masm32\include\kernel32.inc
      include D:\masm32\include\comctl32.inc
      include  D:\MASM32\include\masm32.inc
      ;include  D:\MASM32\include\perso32.inc

      includelib D:\masm32\lib\user32.lib
      includelib D:\masm32\lib\kernel32.lib
      includelib D:\masm32\lib\comctl32.lib      
      includelib  D:\MASM32\lib\masm32.lib
      ;includelib  D:\MASM32\lib\perso32.lib

; #########################################################################

      ;=============
      ; Local macros
      ;=============

      InsTxt MACRO Name, Text:VARARG
        LOCAL lbl
          jmp lbl
            Name db Text,0
          lbl:
        ENDM

      PuPo MACRO M1, M2
        push M2
        pop  M1
      ENDM

      return MACRO arg
        mov eax, arg
        ret
      ENDM

        ;=================
        ; Local prototypes
        ;=================
        WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
        WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
        TopXY PROTO   :DWORD,:DWORD
        Paint_Proc PROTO :DWORD,:DWORD
        debug PROTO :DWORD,:DWORD
        chercherChaine PROTO :DWORD,:DWORD,:DWORD,:DWORD
	 LongZtexte PROTO :DWORD,:DWORD
        CallBackDDE PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD						 
	 InitDDEML PROTO 
	 InitDDE PROTO 
	 DlgClientDDE PROTO :DWORD,:DWORD,:DWORD,:DWORD
	 ConversationDDEML PROTO 

    .const
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
     Xfenetre = 300                         ;pour conserver les proportions de la fenetre
     Yfenetre = 300 			          ;quelque soit la resolution	
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	
     XresolutionDeBase  = 800	          ;a ne pas changer
     YresolutionDeBase = 600

    .data
        szDisplayName db "Client DDE et DDEML",0
        szClassName   db  "DDE_Class",0

        CommandLine   dd 0
        hWnd          dd 0
        hInstance     dd 0
        hStatus       dd 0
        hToolBar      dd 0
        Xresolution   dd 0
        Yresolution   dd 0

    .code

start:
        invoke GetModuleHandle, NULL
        mov hInstance, eax

        invoke GetCommandLine
        mov CommandLine, eax

        invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
        invoke ExitProcess,eax

; #########################################################################

WinMain proc hInst:DWORD,hPrevInst:DWORD,CmdLine :DWORD,CmdShow:DWORD
        LOCAL wc   :WNDCLASSEX
        LOCAL msg  :MSG

        LOCAL largFen  :DWORD
        LOCAL HautFen  :DWORD
        LOCAL Xpos  :DWORD
        LOCAL Ypos  :DWORD

        invoke InitCommonControls

        ;==================================================
        ; Fill WNDCLASSEX structure with required variables
        ;==================================================

        mov wc.cbSize,         sizeof WNDCLASSEX
        mov wc.style,          CS_HREDRAW or CS_VREDRAW \
                               or CS_BYTEALIGNWINDOW
        mov wc.lpfnWndProc,    offset WndProc        ;prend un nom indifferent
        mov wc.cbClsExtra,     NULL
        mov wc.cbWndExtra,     NULL
        PuPo wc.hInstance,      hInst   ;<< NOTE: macro not mnemonic
        mov wc.hbrBackground,  COLOR_BTNFACE+1
        mov wc.lpszMenuName,   NULL
        mov wc.lpszClassName,  offset szClassName
          invoke LoadIcon,hInst,500    ; icon ID
        mov wc.hIcon,          eax
          invoke LoadCursor,NULL,IDC_ARROW
        mov wc.hCursor,        eax
        mov wc.hIconSm,        0

        invoke RegisterClassEx, ADDR wc
       
        ;---------------------------------------------------------------------------
        ;conserve les proportions de la fenetre en fonction de la resolution d'ecran
        ;----------------------------------------------------------------------------
        invoke GetSystemMetrics,SM_CXSCREEN     ;max X de l'ecran
	 mov Xresolution,eax
        mov ecx,eax
        mov eax,Xfenetre				;constante longueueur de la fenetre	
        mul ecx                                  ;si 800x600 inchang
        xor edx,edx        
        mov ecx,XresolutionDeBase
        div ecx
        xor edx,edx
        mov largFen,eax                            ;resolution ?

        invoke GetSystemMetrics,SM_CYSCREEN      ;max Y de L'ecran
        mov Yresolution,eax
        mov ecx,eax
        mov eax,Yfenetre				;constante largeur        
        mul ecx
        xor edx,edx        
        mov ecx,YresolutionDeBase
        div ecx
        xor edx,edx
        mov HautFen,eax

        ;================================
        ; Centre window at following size
        ;================================


        invoke TopXY,largFen,Xresolution
        mov Xpos, eax

        invoke TopXY,HautFen,Yresolution
        mov Ypos, eax
       
	;-------------------------------
	;cre la fentre
	;--------------------------------
        invoke CreateWindowEx,WS_EX_LEFT,
                              ADDR szClassName,
                              ADDR szDisplayName,
                              WS_OVERLAPPEDWINDOW,
                              Xpos,Ypos,largFen,HautFen,
                              NULL,NULL,
                              hInst,NULL
        mov   hWnd,eax

        invoke LoadMenu,hInst,600  ; menu ID
        invoke SetMenu,hWnd,eax

        invoke ShowWindow,hWnd,SW_SHOWNORMAL
        invoke UpdateWindow,hWnd

      ;===================================
      ; Loop until PostQuitMessage is sent
      ;===================================

    StartLoop:
      invoke GetMessage,ADDR msg,NULL,0,0
      cmp eax, 0
      je ExitLoop
      invoke TranslateMessage, ADDR msg
      invoke DispatchMessage,  ADDR msg
      jmp StartLoop
    ExitLoop:

      return msg.wParam

WinMain endp

; #########################################################################

WndProc proc hWndParent:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    LOCAL caW   :DWORD
    LOCAL caH   :DWORD
    LOCAL hDC   :DWORD
    LOCAL Rct   :RECT
    LOCAL tbb   :TBBUTTON
    LOCAL Tba   :TBADDBITMAP
    LOCAL Ps    :PAINTSTRUCT

    InsTxt tbSelect,"You have selected"
    ;DDE messages
    .if uMsg == WM_DDE_ACK
   	invoke DlgClientDDE ,hWndParent,uMsg,wParam,lParam   ;***************
    .endif

    .if uMsg == WM_COMMAND
    ;======== toolbar commands ========

        .if wParam == 50
            invoke InitDDE   ;***************
        .elseif wParam == 1001
            invoke InitDDE   ;***************
        .elseif wParam == 1902
	     invoke ConversationDDEML	
        .elseif wParam == 1901
            invoke InitDDEML   ;***************

        .elseif wParam == 51
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		invoke InitDDEML 

        .elseif wParam == 52
            InsTxt tb52,"Envoyer le paquet au serveur"
            invoke SendMessage,hStatus,SB_SETTEXT,0,ADDR tb52
	     invoke ConversationDDEML	
    ;======== menu commands ========
        .elseif wParam == 1000
            invoke SendMessage,hWndParent,WM_SYSCOMMAND,SC_CLOSE,NULL
        .elseif wParam == 1900
            InsTxt TheMsg,"Standard Sdi"
            invoke MessageBox,hWndParent,ADDR TheMsg,ADDR szDisplayName,MB_OK
        .endif
    ;====== end menu commands ======

    .elseif uMsg == WM_CREATE

        ;--------------------
        ; Create the tool bar
        ;--------------------

        mov tbb.iBitmap,   0
        mov tbb.idCommand, 0
        mov tbb.fsState,   TBSTATE_ENABLED
        mov tbb.fsStyle,   TBSTYLE_SEP
        mov tbb.dwData,    0
        mov tbb.iString,   0

        invoke CreateToolbarEx,hWndParent,WS_CHILD or WS_CLIPSIBLINGS,
                               300,1,0,0,ADDR tbb,
                               1,16,16,0,0,sizeof TBBUTTON
        mov hToolBar, eax
        invoke ShowWindow,hToolBar,SW_SHOW

        ;-----------------------------------------
        ; Select tool bar bitmap from commctrl DLL
        ;-----------------------------------------

        mov Tba.hInst, HINST_COMMCTRL
        mov Tba.nID, 1   ; btnsize 1=big 2=small

        invoke SendMessage,hToolBar,TB_ADDBITMAP,1,ADDR Tba

        ;------------------------
        ; Add buttons to tool bar
        ;------------------------

        mov tbb.iBitmap,   STD_FILENEW
        mov tbb.fsStyle,   TBSTYLE_BUTTON
        mov tbb.idCommand, 50
        invoke SendMessage,hToolBar,TB_ADDBUTTONS,1,ADDR tbb

        mov tbb.iBitmap,   STD_FILEOPEN
        mov tbb.idCommand, 51
        mov tbb.fsStyle,   TBSTYLE_BUTTON
        invoke SendMessage,hToolBar,TB_ADDBUTTONS,1,ADDR tbb

        mov tbb.iBitmap,   STD_FILESAVE
        mov tbb.idCommand, 52
        mov tbb.fsStyle,   TBSTYLE_BUTTON
        invoke SendMessage,hToolBar,TB_ADDBUTTONS,1,ADDR tbb


        ;----------------------
        ; Create the status bar
        ;----------------------

        invoke CreateStatusWindow,WS_CHILD or WS_VISIBLE or \
                                   SBS_SIZEGRIP,0, hWndParent, 200
        mov hStatus, eax

    .elseif uMsg == WM_SIZE

        invoke SendMessage,hToolBar,TB_AUTOSIZE,0,0

        PuPo caW, lParam[0]  ; client area width
        PuPo caH, lParam[2]  ; client area height

        invoke GetWindowRect,hStatus,ADDR Rct
        mov eax, Rct.bottom
        sub eax, Rct.top
        sub caH, eax

        invoke MoveWindow,hStatus,0,caH,caW,caH,TRUE

    .elseif uMsg == WM_PAINT
        invoke BeginPaint,hWndParent,ADDR Ps
          mov hDC, eax
          invoke Paint_Proc,hWndParent,hDC
        invoke EndPaint,hWndParent,ADDR Ps
        return 0

    .elseif uMsg == WM_CLOSE
        InsTxt TheText,"Please Confirm Exit"
        invoke MessageBox,hWndParent,ADDR TheText,ADDR szDisplayName,MB_YESNO
          .if eax == IDNO
            return 0
          .endif
    .elseif uMsg == WM_DESTROY
        invoke PostQuitMessage,NULL
        return 0 
    .endif

    invoke DefWindowProc,hWndParent,uMsg,wParam,lParam

    ret

WndProc endp

; ########################################################################

TopXY proc wDim:DWORD, sDim:DWORD

    shr sDim, 1      ; divide screen dimension by 2
    shr wDim, 1      ; divide window dimension by 2
    mov eax, wDim    ; copy window dimension into eax
    sub sDim, eax    ; sub half win dimension from half screen dimension

    return sDim

TopXY endp

; ########################################################################

Paint_Proc proc hWndParent:DWORD, hDC:DWORD

    LOCAL caW :DWORD
    LOCAL caH :DWORD
    LOCAL tbH :DWORD
    LOCAL sbH :DWORD
    LOCAL Rct :RECT

    invoke GetClientRect,hWndParent,ADDR Rct
    PuPo caW, Rct.right
    PuPo caH, Rct.bottom

    invoke GetWindowRect,hToolBar,ADDR Rct
    mov eax, Rct.bottom
    sub eax, Rct.top
    mov tbH, eax

    invoke GetWindowRect,hStatus,ADDR Rct
    mov eax, Rct.bottom
    sub eax, Rct.top
    mov sbH, eax

    mov eax, caH
    sub eax, sbH
    mov caH, eax

    mov Rct.left, 0
    PuPo Rct.top, tbH
    PuPo Rct.right, caW
    PuPo Rct.bottom, caH

    invoke DrawEdge,hDC,ADDR Rct,EDGE_SUNKEN,BF_RECT

    return 0

Paint_Proc endp


include ddeclnt.inc
end start
