;-----------------------------------------------------------------------
; Dockable toolbar/rebar by Cive Crous [ Entro-P ] : CliveCrous@asmz.com
;-----------------------------------------------------------------------
; sources are dirty, meant as an initial quick example
; for those with a bit of experience to play with.
; This was my code i wrote when figuring out how it all could work,
; so it's very basic, and not how i would implement it in a
; "real life" scenario, but i think it's does ok as an example ;)
;-----------------------------------------------------------------------
.386
.model flat, stdcall
option casemap :none
include windows.inc

incboth	MACRO	incl
	include		incl.inc
	includelib	incl.lib
ENDM

m2m		MACRO	m1, m2
	push m2
	pop m1
ENDM

incboth kernel32
incboth user32
incboth gdi32
incboth comctl32

.const
	IDM_FILE_NEW			EQU						101
	IDM_FILE_OPEN			EQU						102
	IDM_FILE_SAVE			EQU						103
	IDM_FILE_SAVEALL		EQU						104

	IDM_EDIT_CUT			EQU						201
	IDM_EDIT_COPY			EQU						202
	IDM_EDIT_PASTE			EQU						203
 
	cAppName				EQU						"DockRebar"

	DOCKINGBORDER			EQU						10

.data?
	hInstance				HINSTANCE				?
	hWnd_MainWindow			HANDLE					?
	hWnd_Rebar				HANDLE					?
	
	hBrushMainBack			HANDLE					?
	
	OldRebar_WndProc		DWORD					?
	
	hWndDraggingRebarBand	HANDLE					?
	BandDraggingRebarBand	DWORD					?
	
	OldToolBarFrameProc		DWORD					?
	
	hCursorSize				HANDLE					?
	hCursorArrow			HANDLE					?


.data
	szMainWindow_Class		db						"wc"
	szApplicationName		db						cAppName,0
	szRebar_Class			db						"ReBarWindow32",0
	szDefaultClass			db						"#32768",0
	
	szToolBarFile			db						"File Operations",0
	szToolBarEdit			db						"Edit Operations",0
	
.code

MainWindow_WndProc	PROTO	hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
Rebar_WndProc	PROTO	hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD

MainWindow_Init	PROC
	local	icce			:INITCOMMONCONTROLSEX
	local	wc				:WNDCLASSEX
	
;Get hInstance                                 
	invoke GetModuleHandle	,NULL
	mov hInstance, eax
	
;Initialise Common Controls
	invoke InitCommonControls
	mov icce.dwSize, sizeof INITCOMMONCONTROLSEX
	mov icce.dwICC, ICC_COOL_CLASSES
	invoke InitCommonControlsEx, addr icce

;Load Cursors
	invoke LoadCursor, NULL,  IDC_SIZEWE	
	mov hCursorSize, eax ; Temporary cursor until we can get the correct one.
	invoke LoadCursor, NULL,  IDC_ARROW	
	mov hCursorArrow, eax

;Register MainWindow Class
	mov	wc.cbSize, SIZEOF WNDCLASSEX
	mov	wc.style, CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW
	mov	wc.lpfnWndProc, OFFSET MainWindow_WndProc
	mov	wc.cbClsExtra, NULL
	mov	wc.cbWndExtra, NULL
	m2m	wc.hInstance, hInstance
	invoke LoadIcon, NULL, IDI_APPLICATION
	mov	wc.hIcon,eax
	m2m	wc.hCursor,hCursorArrow
	mov	wc.hbrBackground, NULL
	mov	wc.lpszMenuName, NULL
	mov	wc.lpszClassName, OFFSET szMainWindow_Class
	mov	wc.hIconSm,NULL
	invoke RegisterClassEx, ADDR wc

;Get Back Brush
	invoke GetSysColorBrush	,COLOR_APPWORKSPACE
	mov hBrushMainBack, eax
	
	ret
MainWindow_Init	ENDP

.const
tbToolBarFile	TBBUTTON <0, IDM_FILE_NEW, TBSTATE_ENABLED,TBSTYLE_BUTTON>
				TBBUTTON <0, 0, TBSTATE_ENABLED, TBSTYLE_SEP>
				TBBUTTON <1, IDM_FILE_OPEN, TBSTATE_ENABLED, TBSTYLE_BUTTON>
				TBBUTTON <2, IDM_FILE_SAVE, TBSTATE_ENABLED, TBSTYLE_BUTTON>
				TBBUTTON <3, IDM_FILE_SAVEALL, TBSTATE_ENABLED, TBSTYLE_BUTTON>
.code
ToolBarFile_Init	PROC
	invoke CreateToolbarEx,	hWnd_MainWindow,
				WS_CHILD or WS_VISIBLE or WS_CLIPCHILDREN or TBSTYLE_TOOLTIPS or CCS_NORESIZE or CCS_NODIVIDER or CCS_ADJUSTABLE or TBSTYLE_FLAT, 
				1001,
				4,
				hInstance,
				101,
				addr tbToolBarFile,
				5,
				16,
				16,
				16,
				16,
				sizeof TBBUTTON
	push eax
	invoke SetWindowText, eax, addr szToolBarFile
	pop eax				
	ret
ToolBarFile_Init	ENDP

.const
tbToolBarEdit	TBBUTTON <0, IDM_EDIT_CUT, TBSTATE_ENABLED,TBSTYLE_BUTTON>
				TBBUTTON <1, IDM_EDIT_COPY, TBSTATE_ENABLED, TBSTYLE_BUTTON>
				TBBUTTON <0, 0, TBSTATE_ENABLED, TBSTYLE_SEP>
				TBBUTTON <2, IDM_EDIT_PASTE, TBSTATE_ENABLED, TBSTYLE_BUTTON>
.code
ToolBarEdit_Init	PROC
	invoke CreateToolbarEx,	hWnd_MainWindow,
				WS_CHILD or WS_VISIBLE or WS_CLIPCHILDREN or TBSTYLE_TOOLTIPS or CCS_NORESIZE or CCS_NODIVIDER or CCS_ADJUSTABLE or TBSTYLE_FLAT, 
				1002,
				3,
				hInstance,
				102,
				addr tbToolBarEdit,
				4,
				16,
				16,
				16,
				16,
				sizeof TBBUTTON
	push eax
	invoke SetWindowText, eax, addr szToolBarEdit
	pop eax				
	ret
ToolBarEdit_Init	ENDP

Rebar_Init	PROC
	local	r				:RECT
	local	rbi				:REBARBANDINFO 
	
	invoke GetClientRect	,hWnd_MainWindow, addr r
	invoke CreateWindowEx,NULL,
			   addr szRebar_Class,
			   NULL,
			   WS_VISIBLE or WS_BORDER or WS_CHILD or WS_CLIPCHILDREN or WS_CLIPSIBLINGS or CCS_NODIVIDER or CCS_NOPARENTALIGN or RBS_VARHEIGHT or RBS_BANDBORDERS or CCS_ADJUSTABLE or RBS_DBLCLKTOGGLE,
			   0,
			   0,
			   r.right,
			   20,
			   hWnd_MainWindow,
		 	   NULL,
			   hInstance,
			   NULL
	mov hWnd_Rebar, eax
	
;Subclass Rebar
	invoke SetWindowLong,hWnd_Rebar,GWL_WNDPROC,addr Rebar_WndProc
	mov OldRebar_WndProc, eax	
	
	mov rbi.cbSize, sizeof REBARBANDINFO
	mov rbi.fMask, RBBIM_STYLE or RBBIM_COLORS or RBBIM_SIZE or RBBIM_CHILD or RBBIM_CHILDSIZE
	mov rbi.fStyle, RBBS_CHILDEDGE + RBBS_GRIPPERALWAYS
	invoke GetSysColor, COLOR_BTNTEXT
	mov rbi.clrFore, eax
	invoke GetSysColor, COLOR_BTNFACE
	mov rbi.clrBack, eax
	mov rbi.lx, 220
	mov rbi.cyMinChild, 22

	invoke ToolBarFile_Init
	mov rbi.hwndChild, eax
	mov rbi.cxMinChild, 20*5
	m2m rbi.lx, rbi.cxMinChild
	invoke SendMessage, hWnd_Rebar, RB_INSERTBAND, 0,ADDR rbi
	invoke ToolBarEdit_Init
	mov rbi.hwndChild, eax
	mov rbi.cxMinChild, 20*4
	m2m rbi.lx, rbi.cxMinChild
	invoke SendMessage, hWnd_Rebar, RB_INSERTBAND, 1,ADDR rbi

	ret
Rebar_Init	ENDP

MainWindow_Run	PROC
	local	msg				:MSG
	
	invoke CreateWindowEx,WS_EX_LEFT,
				ADDR szMainWindow_Class,
				ADDR szApplicationName,
				WS_OVERLAPPEDWINDOW,
				0,
				0,
				CW_USEDEFAULT,
				CW_USEDEFAULT,
				NULL,
				NULL,
				hInstance,
				NULL
	mov	hWnd_MainWindow,eax
	
	invoke Rebar_Init

	invoke ShowWindow,hWnd_MainWindow,SW_SHOWNORMAL
	invoke UpdateWindow,hWnd_MainWindow

	.WHILE TRUE
		invoke GetMessage, ADDR msg,NULL,0,0
		.BREAK .IF (!eax)
		invoke TranslateMessage, ADDR msg
		invoke DispatchMessage, ADDR msg
	.ENDW

	mov eax, msg.wParam
 	ret
MainWindow_Run	ENDP

.data?
	hToolBarMoving				DWORD				?
	pToolBarMoving				POINT				<>
.code
ToolBarFrameProc	PROC	USES edi esi ebx	hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	local	p				:POINT
	local	cp1				:POINT
	local	cp2				:POINT
	local	r				:RECT
	local	ps				:PAINTSTRUCT
	local	rbi				:REBARBANDINFO 
	
	.IF uMsg == WM_NCLBUTTONDOWN
		mov eax, wParam
		and eax, HTCAPTION 
		.IF (! hToolBarMoving) && (eax)
			invoke SetCapture, hWnd
			m2m hToolBarMoving, hWnd
			mov eax, lParam
			and eax, 0FFFFh
			mov pToolBarMoving.x,eax 
			mov eax, lParam
			shr eax, 16
			mov pToolBarMoving.y,eax 
			invoke SetFocus	,hWnd
			mov eax, TRUE
			ret
		.ENDIF
	.ELSEIF (uMsg == WM_NCLBUTTONUP) || (uMsg == WM_LBUTTONUP)
		.IF hToolBarMoving
			invoke ReleaseCapture	
			mov hToolBarMoving, NULL
			mov eax, TRUE
			ret
		.ENDIF
	.ELSEIF uMsg == WM_SYSCOMMAND
		.IF wParam == SC_CLOSE		
			mov eax, TRUE
			ret
		.ENDIF	
	.ELSEIF uMsg == WM_MOUSEMOVE
		.IF hToolBarMoving
			invoke GetCursorPos	,addr p
;Check If Should Dock
			invoke GetClientRect, hWnd_Rebar, addr r
			m2m cp1.x, r.left
			m2m cp1.y, r.top
			m2m cp2.x, r.right
			m2m cp2.y, r.bottom
			invoke ClientToScreen, hWnd_Rebar, addr cp1
			invoke ClientToScreen, hWnd_Rebar, addr cp2

			mov eax, p.x
			.IF ((eax >= cp1.x) || (cp1.x > 80000000h)) && (eax <= cp2.x) && (cp2.x <= 80000000h)
				mov eax, p.y
				.IF ((eax >= cp1.y) || (cp1.y > 80000000h)) && (eax <= cp2.y) && (cp2.y <= 80000000h)
;Dock Window ...

					mov rbi.cbSize, sizeof REBARBANDINFO
					mov rbi.fMask, RBBIM_STYLE or RBBIM_COLORS or RBBIM_SIZE or RBBIM_CHILD or RBBIM_CHILDSIZE
					mov rbi.fStyle, RBBS_CHILDEDGE or RBBS_GRIPPERALWAYS
					invoke GetSysColor, COLOR_BTNTEXT
					mov rbi.clrFore, eax
					invoke GetSysColor, COLOR_BTNFACE
					mov rbi.clrBack, eax

					mov hToolBarMoving, FALSE
					invoke ReleaseCapture	

					invoke GetClientRect	,hWnd, addr r
					m2m rbi.cyMinChild, r.bottom
					m2m rbi.cxMinChild, r.right
					invoke GetTopWindow	,hWnd
					mov rbi.hwndChild, eax
					m2m rbi.lx, rbi.cxMinChild
					invoke SendMessage, hWnd_Rebar, RB_INSERTBAND, 0,ADDR rbi

					invoke SetParent ,rbi.hwndChild, hWnd_Rebar
					invoke SetFocus	, hWnd_Rebar
					invoke SetCursorPos	,p.x, p.y
					xor eax, eax
					invoke PostMessage, hWnd_Rebar, WM_LBUTTONDOWN, MK_LBUTTON, eax

					invoke SetCursor	,hCursorSize

					invoke PostMessage	,hWnd, WM_CLOSE, NULL, NULL
					mov eax, TRUE
					ret
				.ENDIF
			.ENDIF			
;DrawNormally
			invoke GetWindowRect, hWnd, addr r
			mov eax, r.left
			sub r.right, eax
			mov eax, r.top
			sub r.bottom, eax
			mov eax, p.x
			sub eax, pToolBarMoving.x
			add r.left, eax
			mov eax, p.y
			sub eax, pToolBarMoving.y
			add r.top, eax
			m2m pToolBarMoving.x, p.x 
			m2m pToolBarMoving.y, p.y 
			invoke MoveWindow	,hWnd, r.left, r.top, r.right, r.bottom, TRUE
			
			mov eax, TRUE
			ret
		.ENDIF
	.ENDIF
	invoke CallWindowProc	,OldToolBarFrameProc, hWnd, uMsg, wParam, lParam
	ret
ToolBarFrameProc	ENDP

CreateToolBarFrame	PROC	px:DWORD, py:DWORD, w:DWORD, h:DWORD
	local	hFrame			:HANDLE
	local	p				:POINT
	
	mov p.x, 10
	mov p.y, 10
	invoke ClientToScreen	,hWnd_MainWindow, addr p
	
	mov eax, p.y
	sub py, eax
	mov eax, p.x
	sub px, eax
	invoke CreateWindowEx	,WS_EX_TOOLWINDOW,
		addr szDefaultClass,
		NULL,
		NULL,
		px, py, w, h,
		hWnd_MainWindow, NULL, hInstance, NULL 
	mov hFrame, eax
	
	invoke SetWindowLong, hFrame, GWL_WNDPROC, addr ToolBarFrameProc
	mov OldToolBarFrameProc, eax

 	mov eax, hFrame
	ret
CreateToolBarFrame	ENDP

RebarGetuBand	PROC	USES ecx	hRebar:DWORD, hWnd:HANDLE
	local	rbi			:REBARBANDINFO
	
	invoke SendMessage	,hRebar,RB_GETBANDCOUNT,NULL,NULL
	mov ecx, eax
	
	mov rbi.cbSize, sizeof REBARBANDINFO
	mov rbi.fMask, RBBIM_CHILD
	.WHILE ecx
		dec ecx
		push ecx
		invoke SendMessage, hRebar, RB_GETBANDINFO, ecx, addr rbi
		mov eax, rbi.hwndChild
		.IF eax == hWnd
			pop eax
			ret
		.ENDIF
		pop ecx
	.ENDW
	ret
RebarGetuBand	ENDP

.data?
	szTextGetCaption		db			4096			dup(?)
	szTextGetRBI			db			4096			dup(?)
.code
Rebar_WndProc	PROC	USES edi esi ebx	hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	local	r				:RECT
	local	rc				:RECT
	local	p				:POINT
	local	hToolWnd		:HANDLE
	local	UseBand			:DWORD
	local	rbi				:REBARBANDINFO

	.IF uMsg == WM_MOUSEMOVE
		invoke CallWindowProc	,OldRebar_WndProc, hWnd, uMsg, wParam, lParam
		invoke GetCapture	
		.IF (eax != hWnd) || ( hWndDraggingRebarBand == NULL )
			jmp @Rebar_WndProc_Cont
		.ENDIF
		mov eax, lParam
		shr eax, 16
		mov p.y, eax
		mov eax, lParam
		and eax, 0FFFFh
		mov p.x, eax
		add p.x, DOCKINGBORDER
		add p.y, DOCKINGBORDER
		invoke GetClientRect ,hWnd, addr r
		add r.right, DOCKINGBORDER*2 
		add r.bottom, DOCKINGBORDER*2 
		mov eax, p.x
		sub r.right, eax
		mov eax, p.y
		sub r.bottom, eax
		.IF (r.right < 80000000h) && (r.bottom < 80000000h)
			ret
		.ENDIF
;At this point we want to rip the toolbar from the rebar
		invoke RebarGetuBand, hWnd, hWndDraggingRebarBand
		mov UseBand, eax 

		mov rbi.cbSize, sizeof REBARBANDINFO
		mov rbi.fMask, RBBIM_BACKGROUND or RBBIM_CHILDSIZE or RBBIM_COLORS or RBBIM_HEADERSIZE or RBBIM_IDEALSIZE or RBBIM_ID or RBBIM_IMAGE or RBBIM_LPARAM or RBBIM_SIZE or RBBIM_STYLE or RBBIM_TEXT or RBBIM_CHILD
		mov rbi.cch, sizeof szTextGetRBI
		mov rbi.lpText, offset szTextGetRBI
		invoke SendMessage, hWnd, RB_GETBANDINFO, UseBand, addr rbi

		invoke SendMessage	,hWnd, RB_SHOWBAND, UseBand, FALSE
		invoke SendMessage	,hWnd, RB_DELETEBAND, UseBand, NULL

		invoke ReleaseCapture
		invoke GetCursorPos	, addr p
		invoke CreateToolBarFrame, p.x, p.y, 300, 50
		mov hToolWnd, eax
		invoke SetParent ,hWndDraggingRebarBand, hToolWnd
		invoke ShowWindow	,hWndDraggingRebarBand, SW_SHOW
		invoke SetFocus	, hToolWnd
		invoke GetWindowText, hWndDraggingRebarBand, addr szTextGetCaption, 4096  
		invoke SetWindowText ,hToolWnd, addr szTextGetCaption
  		
		invoke MoveWindow, hWndDraggingRebarBand, 0, 0, 100, 100, TRUE

		invoke GetWindowRect, hToolWnd, addr r
		invoke GetClientRect, hToolWnd, addr rc
		mov eax, r.right
		sub eax, r.left
		sub eax, rc.right
		add eax, rbi.cxMinChild
		mov r.right, eax
		mov eax, r.bottom
		sub eax, r.top
		sub eax, rc.bottom
		add eax, rbi.cyMinChild
		mov r.bottom, eax
		m2m p.x, r.left
		m2m p.y, r.top
		invoke ClientToScreen	,hWnd_MainWindow, addr p
		invoke MoveWindow, hToolWnd, r.left, r.top, r.right, r.bottom, TRUE
		invoke SetCursorPos	,p.x, p.y 

		invoke SetCursor, hCursorArrow
		mov hCursorSize, eax ; ah, correct cursor
		invoke ShowWindow	,hWndDraggingRebarBand, SW_SHOW
		invoke GetWindowRect, hWnd_MainWindow, addr r
		mov eax, r.left
		sub p.x, eax
		mov eax, r.top
		sub p.y, eax
		mov eax, p.y
		sub eax, 10
		shl eax, 16
		or eax, p.x
		invoke PostMessage, hToolWnd, WM_NCLBUTTONDOWN, HTCAPTION, eax
		invoke ShowWindow	,hToolWnd, SW_SHOW
		mov eax, TRUE
		ret
	.ELSE	
		invoke CallWindowProc	,OldRebar_WndProc, hWnd, uMsg, wParam, lParam
	.ENDIF
@Rebar_WndProc_Cont:
	ret
Rebar_WndProc	ENDP

_MessageBox	MACRO	szText:VARARG
	local	@szText
	.data
		@szText	db	szText,0
	.code
		invoke MessageBox, hWnd, addr @szText, addr szApplicationName, MB_OK + MB_ICONINFORMATION
ENDM

MainWindow_WndProc	PROC	USES edi esi ebx	hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	local	r			:RECT
	local	rbi			:REBARBANDINFO
	local	ps			:PAINTSTRUCT
	local	hdc			:DWORD
	
	.IF uMsg == WM_CLOSE
		invoke PostQuitMessage	,NULL
	.ELSEIF uMsg == WM_NOTIFY
		push edi
		push eax
		mov edi, lParam
assume edi: PTR NMHDR
		mov eax, [edi].hwndFrom
		.IF (eax == hWnd_Rebar) && ([edi].code == RBN_BEGINDRAG)
assume edi: PTR NMREBAR
			mov rbi.cbSize, sizeof REBARBANDINFO
			mov rbi.fMask, RBBIM_CHILD
			m2m BandDraggingRebarBand, [edi].uBand 
			invoke SendMessage, hWnd_Rebar, RB_GETBANDINFO, [edi].uBand, addr rbi
			m2m hWndDraggingRebarBand, rbi.hwndChild
assume edi: PTR NMHDR
		.ELSEIF (eax == hWnd_Rebar) && ([edi].code == RBN_HEIGHTCHANGE)
			invoke GetClientRect	,hWnd, addr r
			invoke InvalidateRect	,hWnd, addr r, TRUE
		.ENDIF
assume edi: NOTHING
		pop eax
		pop edi
	.ELSEIF uMsg == WM_PAINT
        invoke BeginPaint,hWnd, addr ps
        mov hdc, eax

		invoke GetWindowRect, hWnd_Rebar, addr r
		mov eax, r.bottom
		sub eax, r.top
		push eax
		invoke GetClientRect, hWnd, addr r
		pop r.top
		invoke DrawEdge	,hdc, addr r, EDGE_SUNKEN, BF_RECT
		inc r.top
		inc r.left
		dec r.right
		dec r.bottom
		inc r.top
		inc r.left
		dec r.right
		dec r.bottom
		invoke FillRect	,hdc, addr r, hBrushMainBack

		invoke EndPaint	,hWnd, addr ps
		mov eax, TRUE
		ret
	.ELSEIF uMsg == WM_COMMAND
		mov eax, wParam
		and eax, 0FFFFh
		.IF eax ==  IDM_FILE_NEW
			_MessageBox "File->New"
		.ELSEIF eax ==  IDM_FILE_OPEN
			_MessageBox "File->Open"
		.ELSEIF eax ==  IDM_FILE_SAVE
			_MessageBox "File->Save"
		.ELSEIF eax ==  IDM_FILE_SAVEALL
			_MessageBox "File->Save All"
		.ELSEIF eax ==  IDM_EDIT_CUT
			_MessageBox "Edit->Cut"
		.ELSEIF eax ==  IDM_EDIT_COPY
			_MessageBox "Edit->Copy"
		.ELSEIF eax ==  IDM_EDIT_PASTE
			_MessageBox "Edit->Paste"
		.ENDIF
	.ELSEIF uMsg == WM_SIZE
		invoke DefWindowProc ,hWnd,uMsg,wParam,lParam
		pushad
		invoke GetClientRect	,hWnd, addr r
		invoke MoveWindow	,hWnd_Rebar, 0, 0, r.right, r.bottom, TRUE
		popad
		ret
	.ENDIF
	invoke DefWindowProc ,hWnd,uMsg,wParam,lParam
	ret
MainWindow_WndProc	ENDP

start:
	invoke MainWindow_Init
	invoke MainWindow_Run
	invoke ExitProcess, eax
End start