;
; Dont Sleep v1.0
; Dee-Jon Bryce, Jan 2001
;
; Moves the mouse so that Windows wont fall asleep. The next position of the
; mouse is on a circle with the formula:
;
;		Mouse X Position  := Radius of circle * COS(Q) + Centre X Position
;		Mouse Y Position  := Radius of circle * SIN(Q) + Centre Y Position
;
; where Q is in radians, and is increased a small amount each time. You can
; see the translation of this formula into FPU instructions in the WM_TIMER
; message.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; USUAL ASSEMBLER DIRECTIVES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.686
.MODEL FLAT, STDCALL
OPTION CASEMAP :NONE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; INCLUDES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
INCLUDE macros.inc

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; EQUATES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
IDD_DIALOG			EQU 100
IDC_SCROLLBAR		EQU 200
IDI_ICON			EQU 300
TIMER_MAX			EQU 10000
TIMER_MUL			EQU 100
ID_TIMER			EQU 1
RADIUS				EQU 50

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; PROTOTYPES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DlgProc			PROTO :DWORD,:DWORD,:DWORD,:DWORD
KeyboardProc 	PROTO :DWORD,:DWORD,:DWORD

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; UNINITIALISED DATA
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.DATA?
hInstance				HINSTANCE ?
hwnd					HWND ?
hKeyboard				HANDLE ?
hScrollBar				HWND ?
iScrollPos				DWORD ?
iTimer					DWORD ?
pntMouse				POINT <?>
xMouse					DWORD ?
yMouse					DWORD ?
iRadius 				DWORD ?
fCurrent				QWORD ?
fInc					QWORD ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; CODE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
.CODE

Start:
	invoke GetModuleHandle, 0
	mov hInstance, eax
	invoke DialogBoxParam, eax, IDD_DIALOG, NULL, DlgProc, 0
	invoke ExitProcess, eax

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; FUNCTIONS
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

DlgProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
LOCAL rect:RECT
LOCAL icon:HICON

	.IF uMsg==WM_CLOSE
		invoke EndDialog, hWnd, 0

	.ELSEIF uMsg==WM_INITDIALOG

		; Make window topmost
		invoke SetWindowPos, hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOMOVE

		; Change window icons
		invoke LoadIcon, hInstance, IDI_ICON
		mov icon, eax
		invoke SendMessage, hWnd, WM_SETICON, ICON_BIG, eax
		invoke SendMessage, hWnd, WM_SETICON, ICON_SMALL, icon
		invoke DestroyIcon, icon

		; Initialise scroll bar
		invoke GetDlgItem, hWnd, IDC_SCROLLBAR
		mov hScrollBar, eax
		invoke SetScrollRange, hScrollBar, SB_CTL, 0, 100, TRUE
		invoke SetScrollPos, hScrollBar, SB_CTL, 0, TRUE

		; Initialise variables
		mov iScrollPos, 8
		mov iTimer, 1
		finit
		fild iScrollPos
		fild iTimer
		fdiv st(0), st(1)
		fst fInc
		fst fCurrent
		mov iScrollPos, 0
		mov iTimer, 0
		mov iRadius, RADIUS
		m2m hwnd, hWnd

	.ELSEIF uMsg==WM_HSCROLL

		loWord wParam ; Update scroll position variable
		.IF ax==SB_THUMBPOSITION
			hiWord wParam
			mov iScrollPos, eax
		.ELSEIF ax==SB_LINELEFT && iScrollPos >= 2
			sub iScrollPos, 2
		.ELSEIF ax==SB_LINERIGHT && iScrollPos <= 98
			add iScrollPos, 2
		.ELSEIF ax==SB_PAGELEFT && iScrollPos >= 10
			sub iScrollPos, 10
		.ELSEIF ax==SB_PAGERIGHT && iScrollPos <= 90
			add iScrollPos, 10
		.ELSE
			return FALSE
		.ENDIF

		; Update position of scrollbar
		invoke SetScrollPos, hScrollBar, SB_CTL, iScrollPos, TRUE

		.IF !iTimer ; Kill timer if it exists
			invoke KillTimer, hWnd, iTimer
		.ENDIF

		; Calculate new timer settings
		mov eax, TIMER_MUL
		mul iScrollPos
		mov ecx, TIMER_MAX
		sub ecx, eax

		; Set new timer
		invoke SetTimer, hWnd, ID_TIMER, ecx, NULL
		mov iTimer, eax

		; Position the mouse in the new position
		invoke GetWindowRect, hWnd, ADDR rect
		mov eax, rect.right
		mov ecx, rect.left
		sub eax, ecx
		shr eax, 1
		add eax, ecx
		mov pntMouse.x, eax
		mov eax, rect.bottom
		mov ecx, rect.top
		sub eax, ecx
		shr eax, 1
		add eax, ecx
		mov pntMouse.y, eax

		; Hook the keyboard
		invoke SetWindowsHookEx, WH_KEYBOARD, ADDR KeyboardProc, hInstance, 0
		mov hKeyboard, eax

		; Send a dummy timer message
		invoke SendMessage, hWnd, WM_TIMER, 0, 0

	.ELSEIF uMsg==WM_TIMER

		; Load FPU with values
		finit
		fld fInc
		fild pntMouse.y
		fild pntMouse.x
		fild iRadius
		fld fCurrent

		; Increment sin/cos radian value
		fadd st(0), st(4)
		fst fCurrent

		; Get new mouse x position
		fld st(0)
		fcos
		fmul st(0), st(2)
		fadd st(0), st(3)
		fistp xMouse

		; Get new mouse y position
		fld st(0)
		fsin
		fmul st(0), st(2)
		fadd st(0), st(4)
		fistp yMouse

		invoke SetCursorPos, xMouse, yMouse
		return FALSE

	.ELSE
		return FALSE
	.ENDIF

	return TRUE

DlgProc ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

KeyboardProc PROC code:DWORD, wParam:WPARAM, lParam:LPARAM

	invoke KillTimer, hwnd, iTimer
	invoke UnhookWindowsHookEx, hKeyboard
	return TRUE

KeyboardProc ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

End Start

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
