;*************************************************
;
;	DIRECT PLAY
;		-CONSTANTS
;		-STRUCTURES
;		-Functions
;		-Interfaces
;
;*************************************************

;***************************************
;
;	External Functions
;
;***************************************
	extern		DirectPlayCreate:PROC
	extern		DirectPlayEnumerateW:PROC
	extern		DirectPlayEnumerateA:PROC

GUID1	STRUCT

	Data1a	DWORD	?
	Data2a	WORD	?
	Data3a	WORD	?
	Data4a	BYTE	?,?,?,?,?,?,?,?

GUID1	ENDS

GUID	STRUCT
    Data1 	dd ?
    Data2 	dw ?
    Data3 	dw ?
    Data4 	db 8 dup(?)
GUID ENDS




;***************************************************
; First the famouse GUIDS 
;	bla bla bla
;	just a series of numbers
;
;	here they are defined into data section
;	so refer to them with offset operator
;***************************************************

.data

IID_IDirectPlay		dd	05454e9a0h
			dw	0db65h
			dw	011ceh 
			db	092h, 01ch, 00h, 0aah, 00h, 06ch, 049h, 072h


IID_IDirectPlay2	dd	02b74f7c0h
			dw	09154h
			dw	011cfh
			db	0a9h,0cdh,00h,0aah,00h,068h,086h,0e3h

IID_IDirectPlay2A	dd	09d460580h
			dw	0a822h
			dw	011cfh 
			db 	096h, 0ch, 00h, 080h, 0c7h, 053h, 04eh, 082h

IID_IDirectPlay3	dd	0133efe40h 
			dw	032dch
			dw	011d0h 
			db	09ch, 0fbh, 00h, 0a0h, 0c9h, 0ah, 043h, 0cbh

IID_IDirectPlay3A	dd	0133efe41h
			dw	032dch
			dw	011d0h 
			db	09ch, 0fbh, 00h, 0a0h, 0c9h, 0ah, 043h, 0cbh

IID_IDirectPlay4	dd	0ab1c530h
			dw	04745h
			dw	011d1h
			db	0a7h, 0a1h, 00h, 00h, 0f8h, 03h, 0abh, 0fch

IID_IDirectPlay4A	dd	0ab1c531h
			dw	04745h
			dw	011d1h
			db	0a7h, 0a1h, 00h, 00h, 0f8h, 03h, 0abh, 0fch

;*********************************************
;	D1EB6D20-8923-11d0-9D97-00A0C90A43CB
;*********************************************
CLSID_DirectPlay	dd	0D1EB6D20h
			dw	08923h
			dw	011D0h
			db	09dh, 097h, 00h, 0a0h, 0c9h, 0ah, 043h, 0cbh

;***************************************************************************
;	GUIDS used by Service Providers shipped with DirectPlay
;	Use these to identify Service Provider returned by EnumConnections
;**************************************************************************

;**************************************************
;	GUID for IPX service provider
;	{685BC400-9D2C-11cf-A9CD-00AA006886E3}
;**************************************************

DPSPGUID_IPX		dd	0685bc400h
			dw	09d2ch
			dw	011cfh 
			db	0a9h, 0cdh, 00h, 0aah, 00h, 068h, 086h, 0e3h

;**************************************************
;	GUID for TCP/IP service provider
;	36E95EE0-8577-11cf-960C-0080C7534E82
;**************************************************

DPSPGUID_TCPIP		dd	036E95EE0h
			dw	08577h 
			dw	011cfh 
			db	096h, 0ch, 00h, 080h, 0c7h, 053h, 04eh, 082h


;*******************************************************************************
;	GUID for Serial service provider
;	{0F1D6860-88D9-11cf-9C4E-00A0C905425E}
;*******************************************************************************

DPSPGUID_SERIAL		dd	0f1d6860h
			dw	088d9h
			dw	011cfh 
			db	09ch, 04eh, 00h, 0a0h, 0c9h, 05h, 042h, 05eh


;********************************************************************************
;	GUID for Modem service provider
;	{44EAA760-CB68-11cf-9C4E-00A0C905425E}
;********************************************************************************

DPSPGUID_MODEM		dd	044eaa760h
			dw	0cb68h
			dw	011cfh 
			db	09ch, 04eh, 00h, 0a0h, 0c9h, 05h, 042h, 05eh

.code


;****************************************
;	funny defined as = S_OK 
;	is defined in win32api
;	is just ZERO....
;	a lot of search for a zero :)
;****************************************
DP_OK			EQU	0


;**************************************
;	DPID
;**************************************

DPID_SYSMSG		EQU		0
DPID_ALLPLAYERS		EQU		0
DPID_SERVERPLAYER	EQU		1
DPID_RESERVEDRANGE	EQU		100
DPID_UNKNOWN		EQU		0FFFFFFFFh


;*********************************************
;
;	INTERFACES
;
;*********************************************


;******************************************
;	IDirectPlay Interface
;
;	as this is obsolete i have prefixed
;	this with DPO1_xxx to use DPO_xxx to 
;	other non obsolete interfaces
;
;******************************************

;===============================================
; IUNKNOWN METHODS
;===============================================
DPO1_QueryInterface		EQU	0	
DPO1_AddRef			EQU	4	
DPO1_Release			EQU	8	
;===============================================
DPO1_AddPlayerToGroup		equ	12
DPO1_Close			equ	16
DPO1_CreatePlayer		equ	20
DPO1_CreateGroup		equ	24
DPO1_DeletePlayerFromGroup	equ	28
DPO1_DestroyPlayer		equ	32
DPO1_DestroyGroup		equ	36	
DPO1_EnableNewPlayers		equ	40
DPO1_EnumGroupPlayers		equ	44
DPO1_EnumGroups			equ	48
DPO1_EnumPlayers		equ	52
DPO1_EnumSessions		equ	56
DPO1_GetCaps			equ	60
DPO1_GetMessageCount		equ	64
DPO1_GetPlayerCaps		equ	68
DPO1_GetPlayerName		equ	72
DPO1_Initialize			equ	76
DPO1_Open			equ	80
DPO1_Receive			equ	84
DPO1_SaveSession		equ	88
DPO1_Send			EQU	92
DPO1_SetPlayerName		EQU	96
;===========================================







;******************************************
;
;	IDirectPlay 2,3,4 Interface
;
;	non-obsolete :)
;
;******************************************




;==========================================
;	IUnknown methods
;==========================================
DPO_QueryInterface		equ	0
DPO_AddRef			equ	4
DPO_Release			equ	8
;===========================================
;	IDirectPlay2 methdos
;===========================================
DPO_AddPlayerToGroup		equ	12
DPO_Close			equ	16
DPO_CreateGroup			equ	20
DPO_CreatePlayer		equ	24
DPO_DeletePlayerFromGroup	equ	28
DPO_DestroyGroup		equ	32
DPO_DestroyPlayer		equ	36
DPO_EnumGroupPlayers		equ	40
DPO_EnumGroups			equ	44
DPO_EnumPlayers			equ	48
DPO_EnumSessions		equ	52
DPO_GetCaps			equ	56
DPO_GetMessageCount		equ	60
DPO_GetGroupData		equ	64
DPO_GetGroupName		equ	68
DPO_GetPlayerAddress		equ	72
DPO_GetPlayerCaps		equ	76
DPO_GetPlayerData		equ	80
DPO_GetPlayerName		equ	84
DPO_GetSessionDesc		equ	88
DPO_Initialize			equ	92
DPO_Open			equ	96
DPO_Receive			equ	100
DPO_Send			equ	104
DPO_SetGroupData		equ	108
DPO_SetGroupName		equ	112
DPO_SetPlayerData		equ	116
DPO_SetPlayerName		equ	120
DPO_SetSessionDesc		equ	124
;============================================
;	IDirectPlay3 methods
;============================================
DPO_AddGroupToGroup		equ	128
DPO_CreateGroupInGroup		equ	132
DPO_DeleteGroupFromGroup	equ	136
DPO_EnumConnections		equ	140
DPO_EnumGroupsInGroup		equ	144
DPO_GetGroupConnectionSettings	equ	148
DPO_InitializeConnection	equ	152
DPO_SecureOpen			equ	156
DPO_SendChatMessage		equ	160
DPO_SetGroupConnectionSettings	equ	164
DPO_StartSession		equ	168
DPO_GetGroupFlags		equ	172
DPO_GetGroupParent		equ	176
DPO_GetPlayerAccount		equ	180
DPO_GetPlayerFlags		equ	184
;===========================================
;	IDirectPlay4 methods
;===========================================
DPO_GetGroupOwner		equ	188	
DPO_SetGroupOwner		equ	192
DPO_SendEx			equ	196
DPO_GetMessageQueue		equ	200
DPO_CancelMessage		equ	204
DPO_CancelPriority		equ	208
;============================================
;	they can add more here.... :)
;============================================


;*******************************************
;
;	STRUCTURES
;
;*******************************************

DPNAME STRUCT
	dpname_dwSize          DD ?		; Size of structure
	dpname_dwFlags         DD ?		; Not used. Must be zero.

    	union          				; The short or friendly name
		dpname_lpszShortName   DD ?	; Unicode
		dpname_lpszShortNameA  DD ?	; ANSI
    	ends

    	union          				; The long or formal name
		dpname_lpszLongName    DD ? 	; Unicode
		dpname_lpszLongNameA   DD ? 	; ANSI
	ends

DPNAME ENDS



_DPSESSIONDESC2		struct

	dwSize			DWORD	?
	dwFlags			DWORD	?
	guidInstance		GUID	<?>

	guidApplication		GUID	<?>

	dwMaxPlayers		DWORD	0
	dwCurrentPlayers	DWORD	0
	
	union
		lpszSessionName		DWORD	?
		lpszSessionNameA	DWORD	?
	ends
	
	union
		lpszPassword		DWORD	?
		lpszPasswordA		DWORD	?
	ends
;==============================================
; prefixed with DP_ as they are globals
; and appear more then once in my includes
; i wonder if i can do smthing else
;============================================== 
	DP_dwReserved1		DWORD	?	
	DP_dwReserved2		DWORD	?	

	dwUser1			DWORD	?
	dwUser2			DWORD	?
	dwUser3			DWORD	?
	dwUser4			DWORD	?

_DPSESSIONDESC2		ends

DPSESSIONDESC2		typedef	_DPSESSIONDESC2

;*************************************
;	DPSESIONDESC2 FLAGS
;*************************************

DPSESSION_NEWPLAYERSDISABLED    =000000001H
DPSESSION_MIGRATEHOST           =000000004H
DPSESSION_NOMESSAGEID           =000000008H
DPSESSION_JOINDISABLED          =000000020H
DPSESSION_KEEPALIVE             =000000040H
DPSESSION_NODATAMESSAGES        =000000080H
DPSESSION_CLIENTSERVER		=000001000H
DPSESSION_DIRECTPLAYPROTOCOL	=000002000H
DPSESSION_NOPRESERVEORDER	=000004000H
DPSESSION_OPTIMIZELATENCY	=000008000H

;============================================
;	Open Session flags
;============================================
DPOPEN_JOIN                 = 000000001h
DPOPEN_CREATE               = 000000002h

;=============================================
; Enumerate CallBack flag
;=============================================
DPESC_TIMEDOUT          = 000000001h


;************************************
;	Predefined IDs
;************************************
DPID_ALLPLAYERS 	=	0
DPID_SYSMSG		=	0
DPID_SERVERPLAYER	=	1
DPID_RESERVEDRANGE	=	100
DPID_UNKNOWN		=	0FFFFFFFFh


;*************************************
;	Receive Flag
;*************************************
DPRECEIVE_ALL		=	0



;******************************************
;	System Messages
;******************************************
DPSYS_CREATEPLAYERORGROUP   = 00003h
DPSYS_DESTROYPLAYERORGROUP  = 00005h
DPSYS_ADDPLAYERTOGROUP      = 00007h
DPSYS_DELETEPLAYERFROMGROUP = 00021h
DPSYS_SESSIONLOST           = 00031h
DPSYS_HOST                  = 00101h
DPSYS_SETPLAYERORGROUPDATA  = 00102h
DPSYS_SETPLAYERORGROUPNAME  = 00103h
DPSYS_SETSESSIONDESC        = 00104h;
DPSYS_ADDGROUPTOGROUP       = 00105h;
DPSYS_DELETEGROUPFROMGROUP  = 00106h;
DPSYS_SECUREMESSAGE         = 00107h;
DPSYS_STARTSESSION          = 00108h;
DPSYS_CHAT                  = 00109h;
DPSYS_SETGROUPOWNER         = 0010Ah;
DPSYS_SENDCOMPLETE          = 0010Dh;


;**********************************************
;	Error Codes
;**********************************************
MAKE_DPHRESULT		=	088770000h

DPERR_NOMESSAGES	=	MAKE_DPHRESULT + 190;
DPERR_BUFFERTOOSMALL	=	MAKE_DPHRESULT + 30;
