;***************************************************
;
;	Direct Play Init and Core functions
;
;***************************************************

.data

;==============================================
; just a guid
; 
;==============================================
my_guid1	dd	059f5a261h
		dw	0e7fch
		dw	011d1h
		db	000,80h,0adh,0a6h,0f4h,032h,0dfh,05eh

;========================================
; this is the same guid as dpchat appl
; in directx samples
; so u can see seession with dpchat
;========================================

my_guid2	dd	05bfdb060h
		dw	006a4h
		dw	011d0h
		db	09ch, 04fh, 00h, 0a0h, 0c9h, 05h, 042h, 05eh

.code



;*********************************************
;
;	Menu actions we do
;
;*********************************************
action_dplay_init_ipx:
	call	Direct_play_init_ipx
ret

action_session_create1:
	call	CreateSession1
ret

action_session_create2:
	call	CreateSession2
ret

action_session_create3:
	call	CreateSession3
ret

action_session_list:
	call	Enumerate_session1
ret

action_session_join:
	call	JoinSession1
ret


action_player_create1:
	call	Create_player1
ret

action_player_create2:
	call	Create_player2
ret

action_player_create3:
	call	Create_player3
ret


action_data_send1:
	call	Data_Send1
ret

action_data_read1:
	call	Data_Read1
ret

;***************************************************************
;	End of Actions :)
;***************************************************************






;************************************
;
;	Read data From a player
;
;************************************
.data
	szReadFail	db	"Read Data Fail!",0

	szReadStart	db	"Read Data Start...",0

	szReadNoMsg	db	"Read Data No Messages!",0 

	lpidFrom	dd	0

	lpidTo		dd	0

	lpdwDataSize	dd	2048

	lpData		dd	2048 dup(0)

.code

Data_Read1:

	 	mov	eax,offset szReadStart
		push	eax
		call	OutputDebugStringA

	mov	eax,2048
	mov	[lpdwDataSize],eax

	mov	eax,offset lpdwDataSize		;buffer size
	push	eax

	mov	eax,offset lpData		;lp to buffer
	push	eax

	mov	eax,0				;dwFlags 0=DPRECEIVE_ALL
	push	eax

	mov	eax,offset lpidTo		;lpidTo
	push	eax

	mov	eax,offset lpidFrom		;lpidFrom
	push	eax
;====================================================
;	call IdirectPlay2A::Receive
;====================================================
	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; get vtable addr
	call [eax+DPO_Receive]	  		; call vector

;=========================================================

	cmp	eax,DP_OK
	jz	data_read1_ok

	cmp	eax,DPERR_NOMESSAGES
	jz	data_read1_nomsg



data_read1_fail:
	mov	[dwErrCode],eax

 	mov	eax,offset szReadFail
	push	eax
	call	OutputDebugStringA

;======================================
; print error code
;======================================
	mov	eax,[dwErrCode]
	push	eax
	mov	eax,offset szErrCode
	push	eax
	call	dwtoa

	mov	eax,offset szErrHead
	push	eax
	call	OutputDebugStringA	
	

    	jmp end_loop


.data
	dwErrCode	dd	0
	szErrHead	db	"Error Code:"
	szErrCode	db	"xxxxxxxxxxxxxxxxxxxxx",0
.code


data_read1_nomsg:
 	mov	eax,offset szReadNoMsg
	push	eax
	call	OutputDebugStringA
ret

data_read1_ok:
	mov	eax,[lpidFrom]
	cmp	eax,DPID_SYSMSG
	jz	data_read1_system_message
;======================================
; a normal message
;======================================
 	mov	eax,offset lpData
	add	eax,4
	push	eax
	call	OutputDebugStringA
ret


.data
	szReadSystemMsg		db	"This is a SYSTEM Message!",0
.code
data_read1_system_message:
	mov	eax,offset szReadSystemMsg
	push	eax
	call	OutputDebugStringA

	mov	eax,offset lpData
	mov	eax,[eax]
	cmp	eax,DPSYS_HOST
	jz	data_read1_host
ret



.data
	szReadSysHost		db	"SYS:You are the HOST Now!",0
.code
data_read1_host:
	mov	eax,offset szReadSysHost
	push	eax
	call	OutputDebugStringA
ret





;************************************
;
;	Send data to a player
;
;************************************


.data
	szSendStart	db	"Data Send start...",0

	szSendFail	db	"Data Send Fail....",0	

	szSendOk	db	"Data Send Ok.",0

	dwSendData1Type	dd	0
	szSendData1	db	"Message from over the Net",0

	szTest		db	"TestTestTest",0,0,0,0,0,0,0,0,0,0,0,0,0,0
			db	100 dup (0)
.code

Data_Send1:

	mov	eax,offset szSendStart
	push	eax
	call	OutputDebugStringA

;================================================================
	mov	eax,4+32			;dwDataSize
	push	eax		

	mov	eax,offset dwSendData1Type	;lpData
;	mov	eax,offset szSendData1
	push	eax

	mov	eax,0				;dwFlags
	push	eax

	mov	eax,DPID_ALLPLAYERS		;idTo
	push	eax

	mov	eax,[dw_Player1_id]
	push	eax				;idFrom

	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_Send]	  		; call vector

;=========================================================

	.IF eax != DP_OK
	 	mov	eax,offset szSendFail
		push	eax
		call	OutputDebugStringA
	    	jmp end_loop
    	.ENDIF


	mov	eax,offset szSendOk
	push	eax
	call	Print_string01

ret















;************************************
;
;	Create a player
;
;************************************


.data
	dpname_Player1		DPNAME	<0>

	szCreatePlayerStart	db	"Create Player start...",0

	szCreatePlayerFail	db	"Create Player Fail....",0	

	szCreatePlayerOk	db	"Create Player Ok.",0

	lpsz_Player_name	dd	0

	sz_Player1_name		db	"Player_One_Yellow",0
	sz_Player2_name		db	"Player_Two_Blue",0
	sz_Player3_name		db	"Player_Three_Red",0

	dw_Player1_id		dd	0
.code

Create_player1:
	mov	eax,offset sz_Player1_name
	mov	[lpsz_Player_name],eax
	call	Create_player_all
ret

Create_player2:
	mov	eax,offset sz_Player2_name
	mov	[lpsz_Player_name],eax
	call	Create_player_all
ret

Create_player3:
	mov	eax,offset sz_Player3_name
	mov	[lpsz_Player_name],eax
	call	Create_player_all
ret

Create_player_all:

	mov	eax,offset szCreatePlayerStart
	push	eax
	call	OutputDebugStringA
;====================================================
	mov	eax,size DPNAME
	mov	[dpname_Player1.dpname_dwSize],eax

	mov	eax,[lpsz_Player_name]
	mov	[dpname_Player1.dpname_lpszShortNameA],eax

	mov	eax,0
	mov	[dpname_Player1.dpname_lpszLongNameA],eax

;====================================================
	mov	eax,0			;dwFlags
	push	eax

	mov	eax,0			;lpdata size
	push	eax

	mov	eax,0			;lpdata
	push	eax

	mov	eax,[hevent_Player1]
	push	eax

	mov	eax,offset dpname_Player1
	push	eax

	mov	eax,offset dw_Player1_id
	push	eax

	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_CreatePlayer]	  	; call vector

;=========================================================
	.IF eax != DP_OK
	 	mov	eax,offset szCreatePlayerFail
		push	eax
		call	OutputDebugStringA
	    	jmp end_loop
    	.ENDIF


	mov	eax,offset szCreatePlayerOk
	push	eax
	call	OutputDebugStringA

	mov	eax,[dw_Player1_id]
	push	eax
	call	PrintNumar01

ret







;========================================
;	wrapper to init
;	call all routines needed for
;	dplay init in sequence
;========================================

.data
	szCreateIPX	db	"Create IPX IDirectPlay2A ok",0
.code
Direct_play_init_ipx:
	
	call	Create_dplay1

	call	Querry_dplay2A

	call	Release_dplay1

	mov	eax,offset szCreateIPX
	push	eax
	call	Print_string01

ret


;=========================================
;	Create a IDirectPlay Object
;
;=========================================

.data
	lp_dplay1			dd	0

	szDirectPlayCreateFail		db	"DirectPlayCreate1 Fail!",0

	msg_create_dplay1		db	"Start create dplay1",0
.code

Create_dplay1:

	mov	eax,offset msg_create_dplay1
	push	eax
	call	OutputDebugStringA


	mov	eax,0			; punker
	push	eax
	
	mov	eax,offset lp_dplay1	; lplp IDirectPlay interface
	push	eax

	mov	eax,offset DPSPGUID_IPX	; IPX service provider GUID
	push	eax

	call	DirectPlayCreate

	cmp	eax,DP_OK
	jz	ok_create_dplay1
	call	Fail01, hwndmain, offset szDirectPlayCreateFail
	jmp	end_loop

ok_create_dplay1:

ret


;**********************************************
; 
;	Querry for a IDirectPlay2A interface
;
;**********************************************

.data
	lp_dplay2A			dd	0
	szDirectPlayQuerry2AFail	db	"Querry IDirectPlay2A Failed!",0
.code

Querry_dplay2A:

	mov	eax,offset lp_dplay2A
	push	eax

	mov	eax,offset IID_IDirectPlay2A
	push	eax

	mov eax,[lp_dplay1]
	push eax				; DPlay1 Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_QueryInterface]	  	; call vector


	cmp	eax,DP_OK
	jz	ok_querry_dplay2
	call	Fail01, hwndmain, offset szDirectPlayQuerry2AFail
	jmp	end_loop

ok_querry_dplay2:

ret



;**********************************************
; 
;	Release obsolete IDirectPlay1 interface
;
;**********************************************

.data
	szDirectRelease1Fail	db	"Release IDirectPlay1 Failed!",0
.code

Release_dplay1:

	mov eax,[lp_dplay1]
	push eax				; DPlay1 Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO1_Release]	  		; call vector

	.IF eax != DP_OK
    		call Fail01, hwndmain, offset szDirectRelease1Fail
	    	jmp end_loop
    	.ENDIF

ret


;**********************************************
; 
;	Create a session for others to join
;
;**********************************************

.data
	sesion_desc1		DPSESSIONDESC2	<0>

	szGameName1		db	"Multiplayer Game1",0
	szGameName2		db	"Multiplayer Game2",0
	szGameName3		db	"Multiplayer Game3",0

	szGamePass1		db	"ObySoft",0

	dwSessionName		dd	0

	szCreateSessionFail	db	"Create Session Fail!",0

	szCreateSessionOk	db	"CreateSession Ok.",0	
.code

CreateSession1:
	mov	eax,offset szGameName1
	mov	[dwSessionName],eax
	call	CreateSessionAll
ret

CreateSession2:
	mov	eax,offset szGameName2
	mov	[dwSessionName],eax
	call	CreateSessionAll
ret

CreateSession3:
	mov	eax,offset szGameName3
	mov	[dwSessionName],eax
	call	CreateSessionAll
ret




CreateSessionAll:

;=============================================================
; init sesion descriptor structure
;=============================================================
	mov	[sesion_desc1.dwSize], SIZE DPSESSIONDESC2

	mov	eax,DPSESSION_MIGRATEHOST or DPSESSION_KEEPALIVE
	mov	[sesion_desc1.dwFlags],eax

	mov	eax,8
	mov	[sesion_desc1.dwMaxPlayers],eax

	mov	eax,[dwSessionName]
	mov	[sesion_desc1.lpszSessionNameA],eax

;===================================
;	call	copy_guid2
;===================================
	mov	esi,offset my_guid2
	mov	edi,offset sesion_desc1.guidApplication
	mov	ecx,SIZE GUID
	cld
	rep	movsb
;========================================================



;======================================
; params for IDirectDraw2A::Open
;======================================
	mov	eax,DPOPEN_CREATE   
	push	eax

	mov	eax,offset sesion_desc1
	push	eax

	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_Open]	  		; call vector

	.IF eax != DP_OK
    		call Fail01, hwndmain, offset szCreateSessionFail
	    	jmp end_loop
    	.ENDIF

	mov	eax,offset szCreateSessionOk
	push	eax
	call	OutputDebugStringA


	mov	eax,offset szCreateSessionOk
	push	eax
	call	Print_string01
ret







;**********************************************
; 
;	Enumerate sessions we can join to
;
;**********************************************

.data
	sesion_desc2		DPSESSIONDESC2	<0>

	szListSessions		db	"--List Found Sessions--:",0

	szEnumSessionFail	db	"Enumerate Session Failed!",0
.code

Enumerate_session1:

	mov	eax,offset szListSessions
	push	eax
	call	Print_string01
;=============================================================
; init sesion descriptor structure
;=============================================================
	mov	[sesion_desc2.dwSize], SIZE DPSESSIONDESC2


;===================================
;	copy my_guid2
;===================================
	mov	esi,offset my_guid2
	mov	edi,offset sesion_desc2.guidApplication
	mov	ecx,SIZE GUID
	cld
	rep	movsb
;========================================================


;==============================================
; params for IDirectDraw2A::EnumSessions
;==============================================
	mov	eax,0				;dwflags
	push	eax

	mov	eax,offset hwndmain		; lpcontext
	push	eax

	mov	eax,offset ECallBack2		; callback function
	push	eax

	mov	eax,0				; dwtimeout
	push	eax

	mov	eax,offset sesion_desc2		; lp ddsesiondesc2
	push	eax

	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_EnumSessions]	  		; call vector

	.IF eax != DP_OK
    		call Fail01, hwndmain, offset szEnumSessionFail
	    	jmp end_loop
    	.ENDIF

ret


ECallBack2 proc uses ebx edi esi, lpThisSD1:DWORD, lpdwTimeOut1:DWORD, dwFlags1:DWORD, lpContext:DWORD

	mov	eax,[dwFlags1]
	cmp	eax,DPESC_TIMEDOUT
	jnz	more_sessions
;=====================================
; NO more sessions
; return FALSE and exit 
;=====================================
	mov	eax,0
	ret

more_sessions:
;=========================================
; here we have more sessions
; so stor data about the current session
; and return TRUE
;=========================================

	call	store_session

	mov	eax,1
	ret

ECallBack2 endp


.data
	tmp_text_x	dd	0

	tmp_text_y	dd	10

	tmpDC_01	dd	0

	tmp_sesdesc	DPSESSIONDESC2	<0>

	lp_session_name		dd	0
	dw_session_name_len	dd	0


.code

store_session:

;===========================================
; copy whole found structure to my buffer
;===========================================
	mov	esi,[lpThisSD1]
	mov	edi, offset tmp_sesdesc
	mov	ecx, size DPSESSIONDESC2
	cld
	rep	movsb
;==========================================



	mov	eax,offset tmp_sesdesc.lpszSessionNameA
	mov	eax,[eax]
	mov	[lp_session_name],eax

	push	eax
	call	OutputDebugStringA


	mov	eax,[crt_x]
	push	eax
	add	[crt_x],15

	mov	eax,[lp_session_name]
	push	eax
	call	Print_string01

	pop	eax
	mov	[crt_x],eax
ret

;*******************************************
;
;	Join a Session
;
;*******************************************
.data
	dpsdesc2_Join		DPSESSIONDESC2	<0>

	szJoinSessionFail	db	"Join Session Fail!",0

	szJoinSessionOk		db	"Join Session Ok.",0	

	guid_Join		GUID	<0>
.code



JoinSession1:

;=============================================================
; init sesion descriptor structure
;=============================================================
	mov	[dpsdesc2_Join.dwSize], SIZE DPSESSIONDESC2

;====================================================
;	copy found guid to request guid
;====================================================
	mov	esi,offset tmp_sesdesc.guidInstance
	mov	edi,offset dpsdesc2_Join.guidInstance
	mov	ecx,SIZE GUID
	cld
	rep	movsb
;========================================================



;======================================
; params for IDirectDraw2A::Open
;======================================
	mov	eax,DPOPEN_JOIN 
	push	eax

	mov	eax,offset dpsdesc2_Join
	push	eax

	mov eax,[lp_dplay2A]
	push eax				; dplay2A Object

	mov eax,[eax]				; vtable addr
	call [eax+DPO_Open]	  		; call vector

	.IF eax != DP_OK
    		call Fail01, hwndmain, offset szJoinSessionFail
	    	jmp end_loop
    	.ENDIF

	mov	eax,offset szJoinSessionOk
	push	eax
	call	OutputDebugStringA


	mov	eax,offset szJoinSessionOk
	push	eax
	call	Print_string01
ret


