.data
;	mouse_x			dd	0
;	mouse_y			dd	0

	flag_mouse_move		dd	0

	flag_leftbuttondown	dd	0

	flag_leftbuttonup	dd	0

	flag_rightbuttondown	dd	0

	flag_key_pressed	dd	0

	key_code		dd	0

	sz_msg_about00		db	" ASM Bitmap Slicer v01 ",0
	sz_msg_about01		db	" CopyRight (c)2000 Obysoft ",0
.code




; **************************************
; Windows message management / actions
; **************************************
;
; WndProc = main CallBack 
; ====================================
; take care of ebx,edi,esi 
; witch we have to save now / restore later
; or else win32api will crash hmmm...
; =========================================================
WndProc proc uses ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

	LOCAL   theDC:DWORD		; for wmpaint

	mov	eax,[wmsg]		; fetch the message

;=======================================
	cmp	eax,WM_COMMAND
	je	wm_command_action
;=======================================
	cmp	eax,WM_ACTIVATEAPP
	je	wmactivateapp
;=======================================
	cmp 	eax,WM_DESTROY
	je  	wmdestroy
;=======================================
	cmp 	eax,WM_PAINT
	je  	wmpaint
;=======================================
	cmp	eax, WM_KEYDOWN
	je	wmkeydown
;=======================================
	cmp	eax,WM_LBUTTONDOWN
	jz	leftbuttondown01
;=======================================
	cmp	eax,WM_LBUTTONUP
	jz	leftbuttonup01
;------------------------------------
 	cmp	eax,WM_RBUTTONDOWN
	jz	rightbuttondown01
; -----------------------------------
	cmp	eax,WM_MOUSEMOVE
	jz	mousemove01
;------------------------------------



; =======================================================
; Let WIN deal with all messages that we dont care about
; by call to default win32api message handler
; =================================================
	push [lparam]
	push [wparam]
	push [wmsg]
	push [hwnd]
	call DefWindowProcA

;=========================================
; not having eax = zero at exit signnals
; our code didnt manage this message
;========================================
	ret




;*******************************************************
; 	HERE are procedures 
;	for the MESSAGES THAT WE DO CARE ABOUT
;*******************************************************


;==============================
; Menu command actions
;==============================
wm_command_action:
	mov	eax,[wparam]
	
	cmp	eax,1000
	je	cmd_file_exit

	cmp	eax,1900
	je	cmd_help_about


	cmp	eax,1100
	je	cmd_file_open

	cmp	eax,1110
	je	cmd_file_save

	cmp	eax,1210
	je	cmd_edit_slice

	xor	eax,eax
	ret


cmd_file_open:

	call	file_open_action

	xor	eax,eax
	ret


cmd_file_save:

	call	file_save_action

	xor	eax,eax
	ret

cmd_file_exit:
	push 0
	push SC_CLOSE
	push WM_SYSCOMMAND
	push [hwndmain]
	call SendMessageA

	xor eax,eax
	ret

cmd_edit_slice:

	call	edit_slice_action

	xor	eax,eax
	ret

cmd_help_about:
	push MB_OK
	push offset sz_msg_about00
	push offset sz_msg_about01
	push [hwndmain]
	call MessageBoxA

	xor eax,eax
	ret





mousemove01:
;==========================
; luam coord. de la mouse
;==========================
	mov	eax,[lparam]
	and	eax,0000ffffh
	mov	[mouse_x],eax
	mov	eax,[lparam]
	and	eax,0ffff0000h
	shr	eax,16
	mov	[mouse_y],eax
;
	mov	[flag_mouse_move],1

	xor	eax,eax
ret


.data
	tmp_xmin	dd	0
	tmp_xmax	dd	0
	tmp_ymin	dd	0
	tmp_ymax	dd	0
.code


leftbuttondown01:
;===================================
; luam coord. de la mouse
;===================================
	mov	eax,[lparam]
	and	eax,0000ffffh
	mov	[mouse_x],eax
	mov	eax,[lparam]
	and	eax,0ffff0000h
	shr	eax,16
	mov	[mouse_y],eax

	mov	[flag_leftbuttondown],1

	xor	eax,eax
ret

leftbuttonup01:
;===================================
; luam coord. de la mouse
;===================================
	mov	eax,[lparam]
	and	eax,0000ffffh
	mov	[mouse_x],eax
	mov	eax,[lparam]
	and	eax,0ffff0000h
	shr	eax,16
	mov	[mouse_y],eax

	mov	[flag_leftbuttonup],1

	xor	eax,eax
ret


rightbuttondown01:
;===================================
; luam coord. de la mouse repede
;===================================
	mov	eax,[lparam]
	and	eax,0000ffffh
	mov	[mouse_x],eax
	mov	eax,[lparam]
	and	eax,0ffff0000h
	shr	eax,16
	mov	[mouse_y],eax

	mov	[flag_rightbuttondown],1

	xor	eax,eax

ret



;************************************
; test if we got minimized/maximized
;************************************
wmactivateapp:		
	mov eax,[wparam]
	mov [game_is_on],eax	; MAKE IT STOP/start at ALT+TAB?

	cmp	eax,0		;zero=we loose focus
	jnz	end_activate

;===================================
; beep if we loose maximized/focus mode
;===================================
	push	MB_OK
	call	MessageBeep
;===========================================
; flag we will have to restore our surfaces
; but have to wait until we get maximized
;===========================================
	mov	[surface_is_lost],1

;
end_activate:
	xor eax,eax
ret


;===============
; none for now
;===============
wmcreate:
	xor eax,eax
	ret

;======================
; EXIT this program
; =====================
wmdestroy:
	call	ReleaseObjects
	push 	LARGE	0    
	call 	PostQuitMessage
;
	xor 	eax,eax
	ret

;===========================================
; i wonder if we still have to do this?
;===========================================
wmpaint:
	push    offset lppaint
	push    [hwnd]
	call    BeginPaint
	mov     [theDC], eax


	mov	eax,[file_open_ok]
	cmp	eax,1
	jnz	end_wmpaint


;==================================
; repaint the main window
;==================================
	push	SRCCOPY
        push    0
        push    0
        push    [file_open_mem_HDC]

	mov	eax,[file_open_dy]
	push	eax

	mov	eax,[file_open_dx]
	push	eax

        push    0
        push    0
        push    [theDC]
        call    BitBlt


end_wmpaint:
	push    offset lppaint
	push    [hwnd]
	call    EndPaint
;
	mov	eax,0
	ret


;******************************
; keyboard messages
;******************************
wmkeydown:
	mov 	eax,[wparam]
	mov	[key_code],eax

	mov	[flag_key_pressed],1

	xor 	eax,eax
	ret


; =====================================
; END OF MAIN WINDOW CALLBACK
; ======================================
WndProc endp




