;============================================
;	dplay01.asm
;============================================

;	Assembler specific instructions for 32 bit ASM code
;============================================================

.386			; minimum processor needed

locals
jumps

masm51
	
.model flat, stdcall	; FLAT memory model & STDCALL calling
option casemap :none	; set code to case sensitive

;==============================================
; Win 32 const and structures are here
;==============================================
	include win32_const_include.asm
	include win32_struct_include.asm

;=======================================================
;	win32api external functions are declared here
;	linker will resolve them :)
;=======================================================
	include	win32_extern.asm

	include menu_id.asm


.data

;===================================================
; date pt fereastra principala
;==================================================
	CommandLine	dd	0

	szDisplayName 	db	"Direct Play Test v01",0
	szClassName   	db	"SolarDplayClass",0	

	hwndmain	dd	0
	hinstmain	dd	0
	hdc_main	dd	0
	hmenu_main	dd	0

	wc   WNDCLASS    <?>

	Wwd  DWORD      400
	Wht  DWORD      300
	Wtx  DWORD      10
	Wty  DWORD      10


	hdc_main_back	dd	0

	lppaint		PAINTSTRUCT	<?>
	msg 		MSGSTRUCT	<?>

;	sz_temporar	db	"999.999.999.999.999.999.999",0,0,0,0


;=======================
; date generale
; ======================
	contor			dd	0
	game_is_on		dd	0
	surface_is_lost		dd	0
	game_is_paused		dd	0		;no moving
;================
; for MOUSE
;================
	mouse_x			dd	0
	mouse_y			dd	0
;===========
; MISC
;===========
	crt_x		dd	0
	crt_y		dd	0


.code

; ===============================================
; OUR PROGRAM STARTS HERE 
; ===============================================

;**************************************
;	MAIN PROGRAM ENTRY POINT
;	linker will jump us here
;**************************************

start:

;===========================================
;   get the module handle for this instance
;===========================================
	push	large 0
	call	GetModuleHandleA
	mov	[hinstmain], eax	; and store it


	call	setup_winmain01

; ====================================================
; The MAIN Window is now vizible in GDI screen
; ====================================================



;**********************************************
;
;	Prepare GDI to do graphics
;
;**********************************************

	call	GDI_init


;**************************************
;	Create a Event for player1
;**************************************

	extern	CreateEventA:PROC

.data
	hevent_Player1		dd	0
	sz_buffer1		db	"xxxxxxxxxxxxxxxxxxxxxx",0
.code

	mov	eax,0		;lpname
	push	eax

	mov	eax,0		;binitialstate=0=False=Nonsignaled
	push	eax

	mov	eax,0		;bManualReset=0=False=AutoReset
	push	eax

	mov	eax,0		;lpsecurityattributes
	push	eax	

	call	CreateEventA
	mov	[hevent_Player1],eax
;
;
;
	mov	eax,[hevent_Player1]
	push	eax

	mov	eax,offset sz_buffer1
	push	eax

	call	dwtoa

	mov	eax,offset sz_buffer1
	push	eax
	call	OutputDebugStringA


	call	Thread_Read_Setup
	
;==========================
; MESSAGE LOOP STARTS HERE
;==========================

msg_loop:

    push    0
    push    0
    push    0
    push    offset msg
    call    GetMessageA

;===================================
; test: is this message  WM_QUIT ?
; =================================
    cmp     eax,0			; GetMessageA will return zero if it is...?
    je      end_loop			; EXIT PROGRAM IF TRUE!!!!

;================================================
; default action (let windows do it's dirty job)
; for all other messages
;================================================
    push    offset msg
    call    TranslateMessage

    push    offset msg
    call    DispatchMessageA

;=========================================
; and jump back to do it all over again
;======================================
    jmp     msg_loop


;=================================
; Here ENDS Our Program (normaly)
;==================================
end_loop:
	push    [msg.msWPARAM]
	call    ExitProcess		;exit to windows

;===================================
; we should never reach this point
;===================================
	ret








;********************************************
;	INCLUDES START HERE
;********************************************

include GDI_init.asm


include Thread_Read.asm

;*********************************
;	Direct play stuff
;*********************************
include direct_play_include.asm

include direct_play_init.asm


;************************************
; windows stuff
;************************************
include Win_Main_Setup.asm

include Win_Main_Call_Back.asm

include win32_AboutDlg.asm

;*********************************
; THIS FILE HAS UTILITY FUNCTIONS
;*********************************

INCLUDE UTIL.ASM


;******************************
;  END OF PROGRAM TEXT
;******************************

end start
