;===================================
; MOUSE PROCEDURES
;===================================

.data

	flag_mouse_move			dd	0
	flag_leftbuttondown		dd	0
	flag_leftbuttonup		dd	0
	flag_rightbuttondown		dd	0

	flag_begin_rect_sel		dd	0
	flag_end_rect_sel		dd	0

	rect_sel_x1			dd	0
	rect_sel_y1			dd	0
	rect_sel_x2			dd	0
	rect_sel_y2			dd	0
.code



;*****************************************************************************************************
mousemove:
;*****************************************************************************************************
	cmp	[flag_mouse_move],1
	jnz	end_mousemove

	mov	[flag_mouse_move],0

;=========================================
;test menu
;=========================================
test_menu_mousemove:
	cmp	[flag_menu_active],1
	jnz	out_menu_mousemove

	call	test_mouse_in_menu
	cmp	eax,1
	jnz	out_menu_mousemove
in_menu_mousemove:
	call	menu_mousemove
	jmp	end_mousemove
out_menu_mousemove:

;=========================================
;test scroll
;=========================================
	call	mousemove_test_scroll

end_mousemove:

ret

;===================================
;	MENU PE MOUSEMOVE
;===================================
menu_mousemove:


;test for new
test_new_btn_mousemove:
;=====================
	mov	eax,menu_x
	add	eax,menu000_new_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_new_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_new_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_new_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_load_btn_mousemove

	mov	[menu_button_new_phase],1
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

	jmp	end_menu_mousemove

test_load_btn_mousemove:
;=======================
	mov	eax,menu_x
	add	eax,menu000_load_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_load_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_load_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_load_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_save_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],1
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

	jmp	end_menu_mousemove

test_save_btn_mousemove:
;=======================
	mov	eax,menu_x
	add	eax,menu000_save_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_save_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_save_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_save_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_resume_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],1
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

	jmp	end_menu_mousemove

test_resume_btn_mousemove:
;=========================
	cmp	[flag_menu_type],flag_menu_paused
	jnz	test_pause_btn_mousemove


	mov	eax,menu_x
	add	eax,menu000_resume_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_resume_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_resume_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_resume_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_pause_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],1
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

	jmp	end_menu_mousemove

test_pause_btn_mousemove:
;========================
	cmp	[flag_menu_type],flag_menu_standard
	jnz	test_exit_btn_mousemove

	mov	eax,menu_x
	add	eax,menu000_pause_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_pause_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_pause_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_pause_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_exit_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],1
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

	jmp	end_menu_mousemove

test_exit_btn_mousemove:
;=======================
	mov	eax,menu_x
	add	eax,menu000_exit_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_exit_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_exit_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_exit_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_exitmenu_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],1
	mov	[menu_button_exitmenu_phase],0
	jmp	end_menu_mousemove


test_exitmenu_btn_mousemove:
;=======================
	mov	eax,menu_x
	add	eax,menu000_exitmenu_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_exitmenu_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_exitmenu_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_exitmenu_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	next_test_btn_mousemove

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],1
	jmp	end_menu_mousemove


next_test_btn_mousemove:

	mov	[menu_button_new_phase],0
	mov	[menu_button_load_phase],0
	mov	[menu_button_save_phase],0
	mov	[menu_button_pause_phase],0
	mov	[menu_button_resume_phase],0
	mov	[menu_button_exit_phase],0
	mov	[menu_button_exitmenu_phase],0

end_menu_mousemove:


ret




;=======================================
;		SCROLL PE MOUSEMOVE
;=======================================
mousemove_test_scroll:
	mov	[dir_scroll],0
	mov	[dir_scroll01],0

test_scroll_left:
	mov	eax,[mouse_x]
	cmp	eax,4
	ja	test_scroll_right

	or	[dir_scroll01],scroll01_left

test_scroll_right:
	mov	eax,[mouse_x]
	cmp	eax,screen_dx-4
	jbe	test_scroll_up

	or	[dir_scroll01],scroll01_right

test_scroll_up:

	mov	eax,[mouse_y]
	cmp	eax,4
	ja	test_scroll_down

	or	[dir_scroll01],scroll01_up

test_scroll_down:
	mov	eax,[mouse_y]
	cmp	eax,screen_dy-4
	jbe	test_scroll00

	or	[dir_scroll01],scroll01_down

	jmp	end_test_scroll

test_scroll00:

	mov	[dir_scroll],0

end_test_scroll:

ret


;*****************************************************************************************************
leftbuttondown:
;*****************************************************************************************************

	cmp	[flag_leftbuttondown],1
	jnz	end_leftbuttondown

	mov	[flag_leftbuttondown],0


mov	ecx,[mouse_x]
mov	eax,[x_ecran]
shr	ecx,5
add	ecx,eax

mov	ebx,[mouse_y]
mov	eax,[y_ecran]
shr	ebx,5
add	ebx,eax

call	get_harta_xy
mov	[flag_tmp],eax

cmp	eax,80000000h
jc	ok_flag_tmp01

	and	eax,0ffffh
	add	eax,100000
	mov	[flag_tmp],eax

ok_flag_tmp01:
call	end_counter_00


;=========================================
;test menu
;=========================================
test_menu_leftbuttondown:
	cmp	[flag_menu_active],1
	jnz	out_menu_leftbuttondown

	call	test_mouse_in_menu
	cmp	eax,1
	jnz	out_menu_leftbuttondown
in_menu_leftbuttondown:
	call	menu_leftbuttondown
	jmp	end_leftbuttondown
out_menu_leftbuttondown:


;=========================================
;test radar
;=========================================
test_leftbutton_radar:
	cmp	[flag_radar_active],1
	jnz	out_radar_leftbuttondown

	call	test_mouse_in_radar
	cmp	eax,1
	jnz	out_radar_leftbuttondown
in_radar_leftbuttondown:
	call	radar_leftbuttondown
	jmp	end_leftbuttondown
out_radar_leftbuttondown:


;=========================================
;main window
;=========================================
	call	main_leftbuttondown



end_leftbuttondown:

ret






;==========================================
; test for mouse press in menu zone
;==========================================
test_mouse_in_menu:
	mov	eax,menu_x
	mov	[test_rect_x1],eax
	mov	ebx,menu_y
	mov	[test_rect_y1],ebx
	add	eax,[menu_dx]
	mov	[test_rect_x2],eax
	add	ebx,[menu_dy]
	mov	[test_rect_y2],ebx

	mov	eax,[mouse_x]
	mov	ebx,[mouse_y]
;
	mov	[test_rect_x],eax
	mov	[test_rect_y],ebx

	call	test_point_in_rect
ret


menu_leftbuttondown:
;============================
;	MENU ACTIONS
;============================
;test for new
test_new_btn:
;============
	mov	eax,menu_x
	add	eax,menu000_new_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_new_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_new_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_new_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_load_btn


;	call	new_map
	call	create_new_map
	
	call	repaint_map

	call	redraw_radar

	jmp	end_menu_leftbuttondown

test_load_btn:
;=============
	mov	eax,menu_x
	add	eax,menu000_load_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_load_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_load_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_load_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_save_btn

	call	load_map
	jmp	end_menu_leftbuttondown

test_save_btn:
;============
	mov	eax,menu_x
	add	eax,menu000_save_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_save_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_save_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_save_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_resume_btn

	call	save_map
	jmp	end_menu_leftbuttondown

test_resume_btn:
;==============
	cmp	[flag_menu_type],flag_menu_paused
	jnz	test_pause_btn

	mov	eax,menu_x
	add	eax,menu000_resume_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_resume_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_resume_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_resume_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_pause_btn

	mov	[flag_menu_type],flag_menu_standard

	mov	eax,0
	mov	[game_is_paused],eax

	jmp	end_menu_leftbuttondown

test_pause_btn:
;=============
	cmp	[flag_menu_type],flag_menu_standard
	jnz	test_exit_btn

	mov	eax,menu_x
	add	eax,menu000_pause_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_pause_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_pause_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_pause_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_exit_btn

	mov	eax,1
	mov	[game_is_paused],eax

	mov	[flag_menu_type],flag_menu_paused

	jmp	end_menu_leftbuttondown

test_exit_btn:
;============
	mov	eax,menu_x
	add	eax,menu000_exit_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_exit_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_exit_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_exit_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	test_exitmenu_btn

	call	ReleaseObjects
	push    [msg.msWPARAM]
	call    ExitProcess

	jmp	end_menu_leftbuttondown

test_exitmenu_btn:
;============
	mov	eax,menu_x
	add	eax,menu000_exitmenu_x1
	mov	[test_rect_x1],eax
	mov	eax,menu_y
	add	eax,menu000_exitmenu_y1
	mov	[test_rect_y1],eax
;
	mov	eax,menu_x
	add	eax,menu000_exitmenu_x2
	mov	[test_rect_x2],eax
	mov	eax,menu_y
	add	eax,menu000_exitmenu_y2
	mov	[test_rect_y2],eax

	call	test_point_in_rect
	cmp	eax,1
	jnz	next_test_btn

	mov	[flag_menu_active],0

	jmp	end_menu_leftbuttondown


next_test_btn:

end_menu_leftbuttondown:

ret


;==========================================
; test for mouse press in radar zone
;==========================================
test_mouse_in_radar:
	mov	eax,[radar_x]
	mov	[test_rect_x1],eax
	mov	ebx,[radar_y]
	mov	[test_rect_y1],ebx
	add	eax,radar_dx
	mov	[test_rect_x2],eax
	add	ebx,radar_dy
	mov	[test_rect_y2],ebx

	mov	eax,[mouse_x]
	mov	ebx,[mouse_y]
;
	mov	[test_rect_x],eax
	mov	[test_rect_y],ebx

	call	test_point_in_rect
ret



radar_leftbuttondown:
;============================
;	RADAR ACTIONS
;============================

	mov	eax,[mouse_x]
	mov	ebx,[radar_x]
	sub	eax,ebx

;test pt minimum
	mov	ebx,eax
;	shl	ebx,1
	cmp	ebx,screen_dx/64
	jnc	test_x_radar_maxim

	mov	eax,0
	jmp	end_test_x_radar

test_x_radar_maxim:
	mov	ebx,eax
;	shl	ebx,1
	mov	ecx,[map_dx]
	sub	ecx,screen_dx/32
	cmp	ebx,ecx
	jbe	ok_test_x_radar

	mov	eax,[map_dx]
	sub	eax,screen_dx/32
	jmp	end_test_x_radar

ok_test_x_radar:
;	shl	eax,1
	sub	eax,screen_dx/64

end_test_x_radar:
	mov	[x_ecran],eax



; test y
;==================

	mov	eax,[mouse_y]
	mov	ebx,[radar_y]
	sub	eax,ebx

;test pt minimum
	mov	ebx,eax
;	shl	ebx,1
	cmp	ebx,screen_dy/64
	jnc	test_y_radar_maxim

	mov	eax,0
	jmp	end_test_y_radar

test_y_radar_maxim:
	mov	ebx,eax
;	shl	ebx,1
	mov	ecx,[map_dy]
	sub	ecx,screen_dy/32
	cmp	ebx,ecx
	jbe	ok_test_y_radar

	mov	eax,[map_dy]
	sub	eax,screen_dy/32
	jmp	end_test_y_radar

ok_test_y_radar:
;	shl	eax,1
	sub	eax,screen_dy/64

end_test_y_radar:
	mov	[y_ecran],eax



	mov	[flag_repaint_map],1
ret










radar_leftbuttondown1:
;============================
;	RADAR ACTIONS
;============================

	mov	eax,[mouse_x]
	mov	ebx,[radar_x]
	sub	eax,ebx

	sub	eax,(screen_dx*5)/512		;(dx_ecran/2)*(5/8)/32
	jnc	in_radar_set_x

	mov	eax,0	
	jmp	in_radar_set_x1

in_radar_set_x:
	cmp	eax,radar_dx-((screen_dx*5)/256)-1				;((25*(5/8)/32)+1)
	jbe	in_radar_set_x1
	mov	eax,radar_dx-((screen_dx*5)/256)-1

in_radar_set_x1:
	shl	eax,3
	mov	ebx,5
	mov	edx,0
	div	ebx
;dec	eax
	mov	[x_ecran],eax

; test y
;=============================

	mov	eax,[mouse_y]
	mov	ebx,[radar_y]
	sub	eax,ebx

	sub	eax,(screen_dy*5)/512		;(dy_ecran/2)*(5/8)/32
	jnc	in_radar_set_y

	mov	eax,0
	jmp	in_radar_set_y1

in_radar_set_y:
	cmp	eax,radar_dy-((screen_dy*5)/256)				;((18*(5/8)/32)+1)
	jbe	in_radar_set_y1
	mov	eax,radar_dy-((screen_dy*5)/256)				;((18*(5/8)/32)+1)

in_radar_set_y1:
	shl	eax,3
	mov	ebx,5
	mov	edx,0
	div	ebx
	mov	[y_ecran],eax

	mov	[flag_repaint_map],1
ret





main_leftbuttondown:
;=====================================
;	MAIN WINDOW  ACTIONS
;=====================================


;-------------------------------
;setup for rectangle selection
;--------------------------------
	mov	[flag_begin_rect_sel],1
	mov	[flag_end_rect_sel],0
	mov	ebx,[mouse_x]
	mov	ecx,[mouse_y]
	mov	[rect_sel_x1],ebx
	mov	[rect_sel_y1],ecx
;--------------------------------


;============================================
; immediate test for editing map key pressed
;============================================

	call	test_pune_tile_leftbuttondown

	cmp	[flag_pune_tile],1
	jz	gata_select1_leftbuttondown


gata_select1_leftbuttondown:


ret



.data
	flag_pune_tile		dd	0
	nr_tile			dd	0
.code

test_pune_tile_leftbuttondown:
;================================

	mov	[flag_pune_tile],0


next0_test_pune_tile_leftbuttondown:

	push	VK_Q
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next1_test_pune_tile_leftbuttondown
	mov	[nr_tile],0
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next1_test_pune_tile_leftbuttondown:

	push	VK_W
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next2_test_pune_tile_leftbuttondown
	mov	[nr_tile],80000001h
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next2_test_pune_tile_leftbuttondown:

	push	VK_E
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next3_test_pune_tile_leftbuttondown
	mov	[nr_tile],2
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next3_test_pune_tile_leftbuttondown:


	push	VK_R
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next4_test_pune_tile_leftbuttondown
	mov	[nr_tile],3
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next4_test_pune_tile_leftbuttondown:

	push	VK_T
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next5_test_pune_tile_leftbuttondown
	mov	[nr_tile],4
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next5_test_pune_tile_leftbuttondown:

	push	VK_Y
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next6_test_pune_tile_leftbuttondown
	mov	[nr_tile],5
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next6_test_pune_tile_leftbuttondown:


	push	VK_U
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next7_test_pune_tile_leftbuttondown
	mov	[nr_tile],6
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown

next7_test_pune_tile_leftbuttondown:

	push	VK_I
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next8_test_pune_tile_leftbuttondown
	mov	[nr_tile],7
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown


next8_test_pune_tile_leftbuttondown:

	push	VK_O
	call	GetAsyncKeyState
	shr	eax,8               ; hiword (eax)
	cmp	eax,0
	jz	next9_test_pune_tile_leftbuttondown
	mov	[nr_tile],8
	call	pune_tile002
	mov	[flag_pune_tile],1
	jmp	end_test_pune_tile_leftbuttondown


next9_test_pune_tile_leftbuttondown:




end_test_pune_tile_leftbuttondown:


ret





;*****************************************************************************************************
rightbuttondown:
;*****************************************************************************************************
	cmp	[flag_rightbuttondown],1
	jnz	end_rightbuttondown

	mov	[flag_rightbuttondown],0





;=========================================
;test radar
;=========================================
test_rightbutton_radar:
	cmp	[flag_radar_active],1
	jnz	out_radar_rightbuttondown

	call	test_mouse_in_radar
	cmp	eax,1
	jnz	out_radar_rightbuttondown

	call	radar_rightbuttondown
	jmp	end_rightbuttondown
out_radar_rightbuttondown:


	call	main_rightbuttondown


end_rightbuttondown:

ret






radar_rightbuttondown:
;========================================
; in radar right mouse button is pressed
;========================================

ret







main_rightbuttondown:
;=====================================
;	MAIN WINDOW  ACTIONS
;=====================================

	mov	eax,[x_ecran]
	mov	ecx,[mouse_x]
	shr	ecx,5		;mouse_x div 32
	add	eax,ecx		;mouse_x/32+x_ecran

	mov	[x_pos_dx],eax

	mov	eax,[y_ecran]
	mov	ebx,[mouse_y]
	shr	ebx,5
	add	eax,ebx

	mov	[y_pos_dy],eax


	call	place_tile_munte
	call	repaint_map
	call	redraw_radar

ret





;*****************************************************************************************************
leftbuttonup:
;*****************************************************************************************************

	cmp	[flag_leftbuttonup],1
	jnz	end_leftbuttonup
	mov	[flag_leftbuttonup],0

	mov	[flag_end_rect_sel],1

end_leftbuttonup:

ret
