.386
.model flat,stdcall
option casemap:none

AddText PROTO :DWORD                        ;Add text to listbox
Broadcast PROTO :DWORD,:DWORD               ;Send message to all players
CheckAround PROTO :DWORD                    ;Change to single after remove
CheckPos PROTO :DWORD                       ;Enough space for the sprite?
ClrColor PROTO                              ;4 of a color get removed
CountActive PROTO                           ;Counts people playing
DrawSide PROTO                              ;Draws numbers in side bar
Drop PROTO                                  ;Piece drop attack
EditProc PROTO :DWORD,:DWORD,:DWORD,:DWORD  ;For sending messages (chat)
GameProc PROTO :DWORD,:DWORD,:DWORD,:DWORD  ;Main game routine
GetNext PROTO                               ;Finds next player's number
Gravity PROTO                               ;Unsupported pieces fall
NewPill PROTO                               ;Set new pill
PlayerList PROTO                            ;Sorts players and shows names
PutGerms PROTO                              ;What it says
RemovePlayer PROTO :DWORD                   ;Removes player from listing
WhichSock PROTO :DWORD                      ;Returns player # given hSock
WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc2 PROTO :DWORD,:DWORD,:DWORD,:DWORD
WndProc3 PROTO :DWORD,:DWORD,:DWORD,:DWORD

include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
includelib \masm32\lib\kernel32.lib
include \masm32\include\shell32.inc
includelib \masm32\lib\shell32.lib
include \masm32\include\user32.inc
includelib \masm32\lib\user32.lib
include \masm32\include\gdi32.inc
includelib \masm32\lib\gdi32.lib
include \masm32\include\wsock32.inc
includelib \masm32\lib\wsock32.lib
include \masm32\include\rand.inc

.data
ClassName db "CLASS1",0
DlgName   db "Form1",0
CN2       db "CLASS2",0
DN2       db "Form2",0
CN3       db "CLASS3",0
DN3       db "Form3",0
Icon      db "i",0
Graphics  db "g",0
GrX2      db "g2",0
GrX3      db "g3",0
Tem       db "%lu",0
Templ     db "%lu %s %lu",0
Templ2    db "%s: %s",0
Templ3    db "%s targeted.",0
Templ4    db "%s sent %lu.",0
Templ5    db "%s won!",0
Templ6    db "Sent %lu to %s.",0
Templ7    db "%s died.",0
Templ8    db "%lu*%s*%lu",0
DCap      db "Game over",0
Died      db "You died.",0
Win       db "There's no more",13,10,"space for germs"
          db 13,10,"in the well!",13,10,13,10,"You win!",0
S0        db "Fast",0
S1        db "Normal",0
S2        db "Slow",0
S3        db "Stopped",0
Speed     dd 100
Toggle    dd 32
Base      dd 10     ;What base to show numbers in.
AFallD    dd 3      ;Delay for autodrop
FTime     dd 5
Level     dd 0
PlayerN   dd 0
PlayerT   dd 0
Flags     dd 0
WellDim   RECT <0,0,216,256>

.const
WM_SOCKET equ WM_USER+256

.data?
hInstance HINSTANCE ?
hDlg dd ?
hDlg2 dd ?
hDlg3 dd ?
hDC dd ?
lpEditProc dd ?
CommandLine LPSTR ?
hSock dd 40 dup(?)
Names dd 160 dup(?)
GermList db 10 dup(?)
WinList db 10 dup(?)
Well db 128 dup(?)
Buf db 32 dup(?)
BoxBuf db 100 dup(?)
black dd ?
Back dd ?
GBuffer dd ?
Old dd ?
WPen dd ?
Gr dd ?
GrDC dd ?
Gr2 dd ?
Gr2DC dd ?
Gr3 dd ?
Gr3DC dd ?
Side dd ?
SideDC dd ?
myDC dd ?
ScIn SCROLLINFO <>
wsadata WSADATA <>
SA sockaddr_in <>
Count dd ?
Count2 dd ?
Pill dd ?
NextPill dd ?
Pos dd ?
PosX dd ?
PosY dd ?
Fall dd ?
Germs dd ?
OldG dd ?
NumDrop dd ?
NumDel dd ?
Attack dd ?
Falling dd ?

.code
program:
INVOKE GetModuleHandle,0
mov hInstance,eax
INVOKE GetCommandLine
mov CommandLine,eax
INVOKE WinMain,hInstance,0,CommandLine,SW_SHOWDEFAULT
INVOKE ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPI:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
LOCAL msg:MSG
LOCAL wc:WNDCLASSEX
mov wc.cbSize,SIZEOF WNDCLASSEX
mov wc.style,CS_HREDRAW or CS_VREDRAW
mov wc.lpfnWndProc,OFFSET WndProc2
mov wc.cbClsExtra,0
mov wc.cbWndExtra,DLGWINDOWEXTRA
push hInst
pop wc.hInstance
mov wc.hbrBackground,COLOR_BTNFACE+1
mov wc.lpszClassName,OFFSET CN2
mov wc.lpszMenuName,0
INVOKE LoadIcon,hInst,offset Icon
mov wc.hIcon,eax
mov wc.hIconSm,eax
INVOKE LoadCursor,0,IDC_ARROW
mov wc.hCursor,eax
INVOKE GetTickCount
INVOKE Randomize,eax
INVOKE RegisterClassEx,addr wc      ;Make game window
mov wc.lpfnWndProc,OFFSET WndProc
mov wc.lpszClassName,OFFSET ClassName
INVOKE RegisterClassEx,addr wc      ;Make options window
mov wc.lpfnWndProc,OFFSET WndProc3
mov wc.lpszClassName,OFFSET CN3
INVOKE RegisterClassEx,addr wc      ;Make options window
INVOKE WSAStartup,101h,offset wsadata
INVOKE CreateDialogParam,hInstance,offset DN2,0,0,0
mov hDlg2,eax
INVOKE ShowWindow,hDlg2,SW_SHOWNORMAL
INVOKE UpdateWindow,hDlg2
Main:
    INVOKE GetMessage,addr msg,0,0,0
    test eax,eax
    jz EOP
    INVOKE IsDialogMessage,hDlg2,addr msg
    test eax,eax
    jnz Main
    INVOKE IsDialogMessage,hDlg3,addr msg
    test eax,eax
    jnz Main
    INVOKE TranslateMessage,addr msg
    INVOKE DispatchMessage,addr msg
jmp Main
EOP:
INVOKE WSACleanup
mov eax,msg.wParam
ret
WinMain endp

WndProc proc hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
LOCAL Ps:PAINTSTRUCT
mov eax,uMsg
.IF eax==WM_DESTROY
    INVOKE ReleaseDC,hWnd,myDC
    INVOKE DeleteDC,GBuffer
    INVOKE DeleteDC,GrDC
    INVOKE DeleteDC,Gr2DC
    INVOKE DeleteDC,Gr3DC
    INVOKE DeleteDC,SideDC
    INVOKE DeleteObject,Back
    INVOKE DeleteObject,Old
    INVOKE DeleteObject,Side
.ELSEIF eax==WM_CLOSE
    .IF PlayerT!=0
        INVOKE ShowWindow,hDlg2,SW_NORMAL
        mov eax,PlayerN
        mov GermList[eax],-1
        .IF lParam==3
        .ELSEIF lParam==2
            mov Buf,5
            mov eax,PlayerN
            mov Buf[1],al
            .IF al==0
                INVOKE Broadcast,offset Buf,2
                INVOKE GetDlgItem,hDlg3,1000
                INVOKE EnableWindow,eax,1
                INVOKE wsprintfA,offset Buf,offset Templ5,offset Names
                INVOKE AddText,offset Buf
                mov ecx,10
                mov al,-1
                lea edi,GermList
                rep stosb
                inc WinList
            .ELSE
                INVOKE send,hSock,offset Buf,2,0
            .ENDIF
        .ELSE
            mov Buf,3
            mov eax,PlayerN
            mov Buf[1],al
            mov Buf[2],-1
            .IF eax==0
                INVOKE Broadcast,offset Buf,3
            .ELSE
                INVOKE send,hSock,offset Buf,3,0
            .ENDIF
            mov eax,PlayerN
            .IF eax==0
                shl eax,4
                INVOKE wsprintfA,offset Buf,offset Templ7,addr Names[eax]
                INVOKE AddText,offset Buf
            .ENDIF
        .ENDIF
        INVOKE PlayerList
        INVOKE KillTimer,hWnd,1001
        INVOKE KillTimer,hWnd,1000
        INVOKE DestroyWindow,hWnd
        xor eax,eax
        ret
    .ENDIF
    .IF lParam==2 && Level!=25
        INVOKE GetDlgItem,hDlg2,2001        ;Beat level
        INVOKE SendMessage,hDlg2,WM_HSCROLL,SB_LINERIGHT,eax
        INVOKE NewPill
        INVOKE NewPill
        mov Pos,3
        INVOKE PutGerms
        INVOKE DrawSide
        mov Falling,25
        xor eax,eax
        ret
    .ENDIF
    INVOKE KillTimer,hWnd,1001
    INVOKE KillTimer,hWnd,1000
    mov eax,lParam
    .IF eax==1
        INVOKE MessageBox,hWnd,offset Died,offset DCap,40000h
    .ELSEIF eax==2
        INVOKE MessageBox,hWnd,offset Win,offset DCap,40000h
    .ENDIF
    INVOKE ShowWindow,hDlg2,SW_NORMAL
    INVOKE DestroyWindow,hWnd
.ELSEIF eax==WM_KILLFOCUS
    .IF PlayerT==0
        or Flags,256
    .ENDIF
.ELSEIF eax==WM_SETFOCUS
    and Flags,-257
.ELSEIF eax==WM_CREATE
    xor eax,eax
    mov Fall,eax
    mov NumDrop,eax
    mov NumDel,eax
    and Flags,-512
    mov Falling,20
    INVOKE GetDC,hWnd   ;Initialize graphics
    mov myDC,eax
    INVOKE CreateCompatibleDC,myDC
    mov GBuffer,eax
    INVOKE CreateCompatibleBitmap,myDC,WellDim.right,WellDim.bottom
    mov Back,eax
    INVOKE SelectObject,GBuffer,Back
    mov Old,eax
    INVOKE SelectObject,GBuffer,WPen
    INVOKE FillRect,GBuffer,offset WellDim,black
    INVOKE CreateCompatibleBitmap,myDC,88,256
    mov Side,eax
    INVOKE CreateCompatibleDC,myDC
    mov GrDC,eax
    INVOKE SelectObject,GrDC,Gr
    INVOKE CreateCompatibleDC,myDC
    mov Gr2DC,eax
    INVOKE SelectObject,Gr2DC,Gr2
    INVOKE CreateCompatibleDC,myDC
    mov Gr3DC,eax
    INVOKE SelectObject,Gr3DC,Gr3
    INVOKE CreateCompatibleDC,myDC
    mov SideDC,eax
    INVOKE SelectObject,SideDC,Side
    INVOKE FillRect,SideDC,offset WellDim,black
    mov PosY,256
@11:    INVOKE SetPixelV,SideDC,0,PosY,00FFFFFFh
        dec PosY
        jnz @11
    INVOKE SetPixelV,SideDC,0,0,00FFFFFFh
    INVOKE BitBlt,SideDC,8,8,80,32,Gr2DC,0,0,SRCCOPY
    INVOKE BitBlt,SideDC,8,72,80,32,Gr2DC,0,32,SRCCOPY
    INVOKE BitBlt,SideDC,8,136,80,32,Gr2DC,0,64,SRCCOPY
    INVOKE BitBlt,SideDC,8,200,80,32,Gr2DC,0,96,SRCCOPY
    mov eax,FTime   ;Draw speed setting
    .IF eax==3
        mov eax,128
    .ELSEIF eax==7
        mov eax,192
    .ELSEIF eax==-1
        mov eax,224
    .ELSE
        mov eax,160
    .ENDIF
    INVOKE BitBlt,SideDC,8,104,80,32,Gr2DC,0,eax,SRCCOPY
    INVOKE DrawSide
.ELSEIF eax==WM_PAINT
    INVOKE BeginPaint,hWnd,addr Ps
    mov Count,0
    mov Count2,0
@2:     mov eax,Count
        shr eax,3
        add eax,Count2
        shr eax,1
        lea edi,Well
        add edi,eax
        xor edx,edx
        mov dl,[edi]
        mov ecx,edx
        shr edx,2       ;Loop to draw Well
        and ecx,3
        .IF ecx!=3
            mov eax,Flags
            .IF (eax & 16) && (edx>5)
                xor edx,1
            .ENDIF
            shl ecx,4
            shl edx,4
            INVOKE BitBlt,GBuffer,Count,Count2,16,16,GrDC,ecx,edx,SRCCOPY
        .ENDIF
        add Count,16
        cmp Count,128
        jnz @2
        mov Count,0
        add Count2,16
        cmp Count2,256
        jnz @2

    mov eax,Pos     ;Draw sprite
    and eax,7
    shl eax,4
    mov PosX,eax
    mov eax,Pos
    and eax,-8
    shl eax,1
    mov PosY,eax
    mov ecx,Pill
    and ecx,3
    shl ecx,4
    mov eax,Pill
    .IF eax & 16
        mov edx,0
    .ELSE
        mov edx,32
    .ENDIF
    INVOKE BitBlt,GBuffer,PosX,PosY,16,16,GrDC,ecx,edx,SRCCOPY
    mov eax,Pill
    .IF eax & 16
        mov edx,16
        add PosY,16
    .ELSE
        mov edx,48
        add PosX,16
    .ENDIF
    mov ecx,Pill
    and ecx,12
    shl ecx,2
    INVOKE BitBlt,GBuffer,PosX,PosY,16,16,GrDC,ecx,edx,SRCCOPY

    INVOKE BitBlt,GBuffer,128,0,88,WellDim.bottom,SideDC,0,0,SRCCOPY
    INVOKE BitBlt,myDC,0,0,WellDim.right,WellDim.bottom,GBuffer,0,0,SRCCOPY
    INVOKE FillRect,GBuffer,offset WellDim,black
    INVOKE EndPaint,hWnd,addr Ps                ;Update window
.ELSEIF eax==WM_TIMER
    mov eax,wParam
    .IF eax==1000
        xor Flags,16
    .ENDIF
.ELSEIF eax==WM_KEYDOWN
    mov eax,lParam
    shr eax,30
    and eax,1           ;Ignore keys that are held down
    .IF eax             ;Although, since I use or, it doesn't matter
        xor eax,eax
        ret
    .ENDIF
    mov eax,wParam
    .IF eax==VK_UP      ;Mark keys that are pressed
        mov eax,Flags
        .IF eax & 512
            or Flags,128
        .ELSE
            or Flags,129
        .ENDIF
    .ELSEIF eax==VK_SPACE
        mov eax,Flags
        .IF eax & 512
            or Flags,128
        .ELSE
            or Flags,129
        .ENDIF
    .ELSEIF eax==VK_DOWN
        or Flags,2
    .ELSEIF eax==VK_LEFT
        or Flags,36
    .ELSEIF eax==VK_RIGHT
        or Flags,72
    .ELSEIF eax==VK_P
        .IF PlayerT==0      ;Can only pause 1 player game
            xor Flags,256
            and Flags,-225
        .ENDIF
    .ENDIF
.ELSEIF eax==WM_KEYUP   ;Unmark released keys
    mov eax,wParam
    .IF eax==VK_UP
        and Flags,-2
    .ELSEIF eax==VK_SPACE
        and Flags,-2
    .ELSEIF eax==VK_DOWN
        and Flags,-3
    .ELSEIF eax==VK_LEFT
        and Flags,-5
    .ELSEIF eax==VK_RIGHT
        and Flags,-9
    .ELSEIF eax>=VK_0 && eax<=VK_9
        sub eax,VK_0
        .IF eax<PlayerT && eax!=PlayerN && GermList[eax]!=-1
            mov Attack,eax
            shl eax,4
            INVOKE wsprintfA,offset Buf,offset Templ3,addr Names[eax]
            INVOKE AddText,offset Buf
        .ENDIF
    .ENDIF
.ELSE
    INVOKE DefWindowProc,hWnd,uMsg,wParam,lParam
    ret
.ENDIF
xor eax,eax
ret
WndProc endp

GameProc proc uses ebx hWnd:DWORD,uMsg:DWORD,idEvent:DWORD,dwTime:DWORD
mov eax,Flags   ;TimerProc must preserve ebx?
.IF eax & 256   ;Paused
    ret
.ENDIF
mov eax,Falling
.IF eax
    dec Falling
    xor edx,edx
    dec eax
    div AFallD
    .IF edx==0
        INVOKE Gravity
        .IF eax
            add Falling,3
        .ENDIF
        .IF eax==0
            INVOKE ClrColor
            .IF ecx
                inc Falling
            .ELSE
                push eax
                INVOKE CheckPos,Pos
                 .IF eax==0  ;New piece doesn't fit -> Dead
                    INVOKE PostMessage,hDlg,WM_CLOSE,0,1
                .ENDIF
                pop eax
            .ENDIF
            sub Germs,eax
                jnz @7          ;Victory!
                INVOKE PostMessage,hDlg,WM_CLOSE,0,2
@7:         INVOKE DrawSide
            mov eax,OldG
            sub eax,Germs
            .IF PlayerT!=0 && eax!=0
                mov eax,Germs
                mov ebx,PlayerN
                mov GermList[ebx],al
                INVOKE PlayerList
                mov eax,Germs
                mov ebx,PlayerN
                mov Buf[2],al
                mov Buf[1],bl
                mov Buf,3
                .IF PlayerN==0
                    INVOKE Broadcast,offset Buf,3
                .ELSE
                    INVOKE send,hSock,offset Buf,3,0
                .ENDIF
            .ENDIF
        .ENDIF
    .ENDIF
.ELSE
    inc Fall
    mov ebx,Fall
    mov eax,Flags
    .IF ebx==FTime || (eax & 2) ;Move down if pressing down or
        mov Fall,0
        mov eax,Pos             ;too much time has elapsed
        add eax,8
        INVOKE CheckPos,eax     ;Check if can move down
        .IF eax
            add Pos,8
        .ELSE
            lea edi,Well        ;Can't -> Put in background
            mov eax,Pill
            .IF eax & 16
                mov ebx,0
            .ELSE
                mov ebx,8
            .ENDIF
            and eax,3
            add eax,ebx
            add edi,Pos
            mov [edi],al
            mov eax,Pill
            .IF eax & 16
                add edi,8
                mov ebx,4
            .ELSE
                inc edi
                mov ebx,12
            .ENDIF
            shr eax,2
            and eax,3
            add eax,ebx
            mov [edi],al
            INVOKE ClrColor
            inc Falling
            mov ebx,Germs
            mov OldG,ebx
            sub Germs,eax   ;Victory!
            jnz @4
                INVOKE PostMessage,hDlg,WM_CLOSE,0,2
@4:         mov Pos,3       ;Reset sprite
            INVOKE NewPill
            INVOKE DrawSide
            mov eax,NumDel
            shr eax,2
            .IF PlayerT>1 && eax>1      ;Attack other players!
                push eax
                mov ecx,eax
                mov ebx,Attack
                shl ebx,4
INVOKE wsprintfA,offset Buf,offset Templ6,ecx,addr Names[ebx]
                INVOKE AddText,offset Buf
                pop eax
                mov Buf[3],al
                mov Buf,4
                mov eax,PlayerN
                mov Buf[1],al
                mov eax,Attack
                mov Buf[2],al
                .IF PlayerN==0
                    shl eax,2
                    INVOKE send,hSock[eax],offset Buf,4,0
                .ELSE
                    INVOKE send,hSock,offset Buf,4,0
                .ENDIF
            .ENDIF
            INVOKE Drop     ;If pieces to drop, do it now.
            mov NumDel,0
        .ENDIF
    .ENDIF
    mov eax,Flags
    .IF eax & 1 || eax & 128 ;Flip if up is pressed and there is space
        xor Pill,16
        INVOKE CheckPos,Pos
        .IF eax==0              ;Check neighboring positions
            mov eax,Pos
            inc eax
            mov Pos,eax
            .IF eax & 7
                INVOKE CheckPos,Pos
                test eax,eax
                jnz @10
            .ENDIF
            mov eax,Pos
            sub eax,2
            mov Pos,eax
            and eax,7
            .IF eax!=7
                INVOKE CheckPos,Pos
                test eax,eax
                jnz @10
            .ENDIF
            mov eax,Pos
            add eax,8
            mov Pos,eax
            and eax,7
            .IF eax!=7
                INVOKE CheckPos,Pos
                test eax,eax
                jnz @10
            .ENDIF
            inc Pos
            INVOKE CheckPos,Pos
            test eax,eax
            jnz @10
            sub Pos,8
            xor Pill,16
        .ENDIF
@10:    mov eax,Pill
        .IF eax & 16    ;Swap colors every other time
            mov ebx,eax ;so all 4 combinations are possible
            and ebx,3
            shr eax,2
            and eax,3
            shl ebx,2
            or eax,ebx
            or eax,16
            mov Pill,eax
        .ENDIF
    .ENDIF
    mov eax,Flags
    .IF eax & 4 || eax & 32 ;Move left if possible
        mov eax,Pos
        mov ebx,eax
        dec eax
        .IF ebx & 7         ;No wrapping
            INVOKE CheckPos,eax
            .IF eax
                dec Pos
            .ENDIF
        .ENDIF
    .ENDIF
    mov eax,Flags
    .IF eax & 8 || eax & 64 ;Move right if possible
        mov eax,Pos
        inc eax
        .IF eax & 7         ;No wrapping
            INVOKE CheckPos,eax
            .IF eax
                inc Pos
            .ENDIF
        .ENDIF
    .ENDIF
.ENDIF
and Flags,-225
INVOKE InvalidateRect,hDlg,offset WellDim,0    ;Tell Windows that Well
ret                                            ;has changed
GameProc endp

CheckPos proc Spot:DWORD    ;Returns 1 if it fits, 0 if it doesn't
mov eax,Spot
.IF eax>127     ;Fail if out of box
    xor eax,eax
    ret
.ENDIF
lea edi,Well
add edi,eax
mov eax,[edi]
and eax,3
.IF eax!=3      ;Fail if block already there
    xor eax,eax
    ret
.ENDIF
mov eax,Pill
.IF eax & 16
    mov eax,Spot
    shr eax,3
    .IF eax==15     ;Can't go below bottom
        xor eax,eax
        ret
    .ENDIF
    add edi,8
.ELSE
    mov eax,Spot
    and eax,7
    .IF eax==7      ;Can't go past right wall
        xor eax,eax
        ret
    .ENDIF
    inc edi
.ENDIF
mov bl,[edi]
and ebx,3
xor eax,eax
.IF ebx!=3          ;Check other end of Pill
    ret
.ENDIF
inc eax
ret
CheckPos endp

PutGerms proc
LOCAL Height:DWORD
lea edi,Well        ;Zero Well
mov al,3
mov ecx,128
rep stosb
mov eax,Level
mov Height,eax
inc eax
shl eax,2           ;Put Level*4+4 germs
mov Germs,eax
mov PosX,eax
mov eax,Height       ;Adjust height based on level
dec eax
shr eax,1
add eax,4
.IF eax>20
    mov eax,10
.ENDIF
.IF eax<10
    mov eax,10
.ENDIF
.IF eax>13
    mov eax,13
.ENDIF
shl eax,3
mov Height,eax
@1: INVOKE Rand,3   ;Loop to put germs
    mov PosY,eax
    INVOKE Rand,2
    add eax,6
    shl eax,2
    add PosY,eax
    INVOKE Rand,Height
    mov ebx,Height
    add eax,128
    sub eax,ebx
    lea edi,Well
    add edi,eax
    mov eax,PosY
    mov ebx,[edi]
    and ebx,3
    .IF ebx==3
        mov [edi],al
    .ELSE
        inc PosX
    .ENDIF
    dec PosX
    jnz @1
INVOKE ClrColor
.IF eax
    mov PosX,eax
    INVOKE Gravity
    jmp @1
.ENDIF
ret
PutGerms endp

ClrColor proc   ;Deletes groups of 4 of same color
LOCAL Num:DWORD ;Returns number of germs killed
xor ecx,ecx
mov Num,0
lea edi,Well
@3: mov al,[edi]
    and eax,3
    .IF eax!=3
        mov bl,[edi+1]
        and ebx,3
        .IF al==bl
            mov bl,[edi+2]
            and bl,3
            .IF al==bl
                mov bl,[edi+3]
                and bl,3
                .IF al==bl        ;4 in a row
                    inc ecx
                    add al,20
                    mov bl,[edi]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi],al
                    mov bl,[edi+1]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+1],al
                    mov bl,[edi+2]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+2],al
                    mov bl,[edi+3]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+3],al
                .ENDIF
            .ENDIF
        .ENDIF
    .ENDIF
    inc edi
    lea ebx,Well
    mov eax,edi
    sub eax,ebx
    mov ebx,eax
    and eax,7
    cmp eax,5
    jnz @3
    add edi,3
    cmp ebx,125
    jb @3
lea edi,Well
@5: mov al,[edi]
    and eax,3
    .IF eax!=3
        mov bl,[edi+8]
        and ebx,3
        .IF al==bl
            mov bl,[edi+16]
            and bl,3
            .IF al==bl
                mov bl,[edi+24]
                and bl,3
                .IF al==bl        ;4 in a column
                    inc ecx
                    add al,20
                    mov bl,[edi]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi],al
                    mov bl,[edi+8]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+8],al
                    mov bl,[edi+16]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+16],al
                    mov bl,[edi+24]
                    and bl,28
                    .IF bl>23
                        inc Num
                    .ENDIF
                    mov [edi+24],al
                .ENDIF
            .ENDIF
        .ENDIF
    .ENDIF
    inc edi
    lea ebx,Well
    mov eax,edi
    sub eax,ebx
    cmp eax,104
    jnz @5
mov eax,Num
ret
ClrColor endp

Gravity proc    ;Returns 1 if should wait, 0 if did nothing
LOCAL Did:DWORD
xor eax,eax
xor edx,edx
mov Did,eax
lea edi,Well
mov esi,edi
mov ebx,120
@5: mov al,[esi+ebx]    ;Get junk off bottom
    and eax,28
    .IF al==20
        INVOKE CheckAround,ebx
        inc Did
        inc NumDel
    .ENDIF
    inc ebx
    cmp ebx,128
    jnz @5
mov esi,edi
mov ebx,119
@6: mov al,[esi+ebx]    ;Main gravity loop
    shr al,2
    .IF al==5
        INVOKE CheckAround,ebx
        inc Did
        inc NumDel
    .ELSE
        mov cl,[esi+ebx+8]
        and cl,3
        .IF cl==3
            .IF al==0 || al==1 || al==4     ;Fall plain
                mov cl,[esi+ebx]
                and cl,3
                .IF cl!=3
                    inc Did
                    mov al,[esi+ebx]
                    mov [esi+ebx+8],al
                    mov BYTE PTR[esi+ebx],3
                .ENDIF
            .ELSEIF al==3                   ;Fall if other half can
                mov cl,[esi+ebx+7]
                and cl,3
                .IF cl==3
                    mov cl,[esi+ebx-1]
                    shr cl,2
                    .IF cl==2
                        inc Did
                        mov al,[esi+ebx]
                        mov [esi+ebx+8],al
                        mov BYTE PTR[esi+ebx],3
                        mov al,[esi+ebx-1]
                        mov [esi+ebx+7],al
                        mov BYTE PTR[esi+ebx-1],3
                    .ENDIF
                .ENDIF
            .ENDIF
        .ENDIF
    .ENDIF
    dec ebx
    cmp ebx,-1
    jnz @6
xor eax,eax
.IF Did
    inc eax
.ENDIF
ret
Gravity endp

CheckAround proc uses esi ebx Where:DWORD
lea esi,Well
mov ecx,Where
sub ecx,8
add esi,ecx
xor eax,eax
mov BYTE PTR[esi+8],3
.IF ecx<128
    mov al,[esi]    ;Check above
    mov ebx,eax
    and bl,3
    shr al,2
    .IF eax==0
        add bl,16
        mov [esi],bl
    .ENDIF
.ENDIF
add esi,7
add ecx,7
.IF ecx<128
    mov al,[esi]    ;Check left
    mov ebx,eax
    and bl,3
    shr al,2
    .IF eax==2
        add bl,16
        mov [esi],bl
    .ENDIF
.ENDIF
add esi,2
add ecx,2
.IF ecx<128
    mov al,[esi]    ;Check right
    mov ebx,eax
    and bl,3
    shr al,2
    .IF eax==3
        add bl,16
        mov [esi],bl
    .ENDIF
.ENDIF
add esi,7
add ecx,7
.IF ecx<128
    mov al,[esi]    ;Check below
    mov ebx,eax
    and bl,3
    shr al,2
    .IF eax==1
        add bl,16
        mov [esi],bl
    .ENDIF
.ENDIF
ret
CheckAround endp

NewPill proc
mov eax,NextPill
mov Pill,eax
INVOKE Rand,3
mov PosX,eax
INVOKE Rand,3   ;Pick left and right colors
shl eax,2
add eax,PosX    ;and combine to form pill
mov NextPill,eax
ret
NewPill endp

Drop proc
mov eax,NumDrop
.IF eax==0      ;Make sure there's something to do
    ret
.ENDIF
inc Falling
lea edi,Well
mov ebx,8
xor ecx,ecx
@8: dec ebx
    mov al,[edi+ebx]    ;Check available space
    and al,3
    .IF al==3
        inc ecx
    .ENDIF
    test ebx,ebx
    jnz @8
mov eax,NumDrop
.IF eax>ecx             ;Drop as many as possible
    mov eax,ecx
.ENDIF
.IF eax==0
    ret
.ENDIF
sub NumDrop,eax
mov ecx,eax
@9: push ecx
    INVOKE Rand,8
    lea edi,Well
    mov ebx,eax
    mov al,[edi+ebx]    ;Find a spot and drop!
    and al,3
    pop ecx
    .IF al==3
        push ebx
        push ecx
        INVOKE Rand,3
        lea edi,Well
        add al,16
        pop ecx
        pop ebx
        dec ecx
        mov [edi+ebx],al
    .ENDIF
    test ecx,ecx
    jnz @9
ret
Drop endp

WndProc2 proc hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
mov eax,uMsg
.IF eax==WM_DESTROY
    INVOKE DeleteObject,WPen
    INVOKE DeleteObject,black
    INVOKE DeleteObject,Gr
    INVOKE DeleteObject,Gr2
    INVOKE DeleteObject,Gr3
    INVOKE PostQuitMessage,0
.ELSEIF eax==WM_CREATE
    INVOKE CreateSolidBrush,0
    mov black,eax
    INVOKE CreatePen,PS_SOLID,1,00FFFFFFh
    mov WPen,eax		
    INVOKE LoadBitmap,hInstance,offset Graphics
    mov Gr,eax
    INVOKE LoadBitmap,hInstance,offset GrX2
    mov Gr2,eax
    INVOKE LoadBitmap,hInstance,offset GrX3
    mov Gr3,eax
    mov ScIn.cbSize,28
    mov ScIn.fMask,SIF_ALL
    mov ScIn.nPage,1
    mov ScIn.nTrackPos,0
    mov ScIn.nMin,0
    mov ScIn.nPos,0
    INVOKE PostMessage,hWnd,WM_TIMER,0,0
.ELSEIF eax==WM_TIMER
    mov ScIn.nMax,25
    INVOKE SendDlgItemMessage,hWnd,2001,SBM_SETSCROLLINFO,1,offset ScIn
    mov ScIn.nMax,3
    mov ScIn.nPos,1
    INVOKE SendDlgItemMessage,hWnd,2000,SBM_SETSCROLLINFO,1,offset ScIn
    INVOKE SendDlgItemMessage,hWnd,1005,BM_SETCHECK,1,0

    INVOKE gethostname,offset Buf,20
    INVOKE SendDlgItemMessage,hWnd,600,WM_SETTEXT,0,offset Buf
    INVOKE gethostbyname,offset Buf
    mov eax,[eax+12]
    mov eax,[eax]
    mov eax,[eax]
    INVOKE inet_ntoa,eax
    INVOKE SendDlgItemMessage,hWnd,601,WM_SETTEXT,0,eax
.ELSEIF eax==WM_COMMAND
    mov eax,wParam
    .IF ax==1000
        mov PlayerT,0
@Game:: INVOKE NewPill
        INVOKE NewPill
        mov Pos,3
        INVOKE PutGerms
        INVOKE CreateDialogParam,hInstance,offset DlgName,0,0,0
        mov hDlg,eax
        INVOKE ShowWindow,hDlg2,SW_HIDE
        INVOKE ShowWindow,hDlg,SW_SHOWNORMAL
        INVOKE UpdateWindow,hDlg
        INVOKE SetTimer,hWnd,1001,Speed,offset GameProc
        INVOKE SetTimer,hDlg,1000,133,0
        .IF PlayerT!=0
            mov Buf,3
            mov ebx,PlayerN
            mov Buf[1],bl
            mov eax,Germs
            mov GermList[ebx],al
            mov Buf[2],al
            .IF PlayerN==0
                INVOKE Broadcast,offset Buf,3
            .ELSE
                INVOKE send,hSock,offset Buf,3,0
            .ENDIF
        .ENDIF
    .ELSEIF ax==1001
        INVOKE CreateDialogParam,hInstance,offset DN3,0,0,0
        mov hDlg3,eax
        INVOKE GetDlgItem,hWnd,1000
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1001
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1002
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1003
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1004
        INVOKE EnableWindow,eax,0
        INVOKE ShowWindow,hDlg3,SW_SHOWNORMAL
        INVOKE UpdateWindow,hDlg3
    .ELSEIF ax==1002
        INVOKE SendDlgItemMessage,hWnd,1003,WM_GETTEXT,32,offset Buf
        .IF Buf==0
            ret
        .ENDIF
        INVOKE GetDlgItem,hWnd,1000
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1001
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1002
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1003
        INVOKE EnableWindow,eax,0
        INVOKE GetDlgItem,hWnd,1004
        INVOKE EnableWindow,eax,0
        INVOKE socket,PF_INET,SOCK_STREAM,IPPROTO_TCP
        mov hSock,eax
        INVOKE inet_addr,offset Buf
        .IF eax==INADDR_NONE
            INVOKE gethostbyname,offset Buf
            mov eax,[eax+12]
            mov eax,[eax]
            mov eax,[eax]
        .ENDIF
        mov SA.sin_addr,eax
        mov SA.sin_family,AF_INET
        INVOKE htons,80
        mov SA.sin_port,ax
        INVOKE WSAAsyncSelect,hSock,hWnd,WM_SOCKET,FD_CONNECT
        INVOKE connect,hSock,offset SA,sizeof SA
    .ELSEIF ax==1005
        xor Flags,512
    .ENDIF
.ELSEIF eax==WM_SOCKET
    mov eax,lParam
    .IF ax==FD_CONNECT
        shr eax,16
        .IF ax==0
            mov PlayerN,1
            INVOKE CreateDialogParam,hInstance,offset DN3,0,0,0
            mov hDlg3,eax
            INVOKE WSAAsyncSelect,hSock,eax,WM_SOCKET,FD_CLOSE or FD_READ
            INVOKE ShowWindow,hDlg3,SW_SHOWNORMAL
            INVOKE UpdateWindow,hDlg3
        .ELSE
            INVOKE GetDlgItem,hWnd,1000
            INVOKE EnableWindow,eax,1
            INVOKE GetDlgItem,hWnd,1001
            INVOKE EnableWindow,eax,1
            INVOKE GetDlgItem,hWnd,1002
            INVOKE EnableWindow,eax,1
            INVOKE GetDlgItem,hWnd,1003
            INVOKE EnableWindow,eax,1
            INVOKE GetDlgItem,hWnd,1004
            INVOKE EnableWindow,eax,1
        .ENDIF
    .ENDIF
.ELSEIF eax==WM_HSCROLL
    INVOKE SendMessage,lParam,SBM_GETSCROLLINFO,0,offset ScIn
    mov eax,wParam
    .IF ax==SB_LINERIGHT
        inc ScIn.nPos
    .ELSEIF ax==SB_LINELEFT
        dec ScIn.nPos
    .ELSEIF ax==SB_PAGELEFT
        sub ScIn.nPos,5
    .ELSEIF ax==SB_PAGERIGHT
        add ScIn.nPos,5
    .ELSEIF ax==SB_THUMBPOSITION
        shr eax,16
        mov ScIn.nPos,eax
    .ENDIF
    .IF ScIn.nPos>-10
        mov ScIn.nPos,0
    .ENDIF
    mov eax,ScIn.nMax
    .IF ScIn.nPos>eax
        mov ScIn.nPos,eax
    .ENDIF
    INVOKE SendMessage,lParam,SBM_SETSCROLLINFO,1,offset ScIn
    INVOKE GetDlgCtrlID,lParam
    .IF eax==2000
        mov eax,ScIn.nPos
        .IF eax==0
            mov FTime,3
            lea edi,S0
        .ELSEIF eax==1
            mov FTime,5
            lea edi,S1
        .ELSEIF eax==2
            mov FTime,7
            lea edi,S2
        .ELSEIF eax==3
            mov FTime,-1
            lea edi,S3
        .ENDIF
        INVOKE SendDlgItemMessage,hWnd,501,WM_SETTEXT,0,edi
    .ELSEIF eax==2001
        mov eax,ScIn.nPos
        mov Level,eax
        INVOKE wsprintfA,offset Buf,offset Tem,eax
        INVOKE SendDlgItemMessage,hWnd,503,WM_SETTEXT,0,offset Buf
    .ENDIF
.ELSE
    INVOKE DefWindowProc,hWnd,uMsg,wParam,lParam
    ret
.ENDIF
xor eax,eax
ret
WndProc2 endp

DrawSide proc
xor edx,edx
mov eax,Level   ;Draw level number
div Base
push edx
shl eax,4
INVOKE BitBlt,SideDC,40,40,16,32,Gr3DC,eax,0,SRCCOPY
pop edx
shl edx,4
INVOKE BitBlt,SideDC,56,40,16,32,Gr3DC,edx,0,SRCCOPY
xor edx,edx
mov eax,Germs   ;Draw germs left number
div Base
push eax
shl edx,4
INVOKE BitBlt,SideDC,56,168,16,32,Gr3DC,edx,0,SRCCOPY
pop eax
xor edx,edx
div Base
push eax
shl edx,4
INVOKE BitBlt,SideDC,40,168,16,32,Gr3DC,edx,0,SRCCOPY
pop eax
shl eax,4
INVOKE BitBlt,SideDC,24,168,16,32,Gr3DC,eax,0,SRCCOPY
mov ecx,NextPill
and ecx,3
shl ecx,4
INVOKE BitBlt,SideDC,28,232,16,16,GrDC,ecx,32,SRCCOPY
mov ecx,NextPill
and ecx,12
shl ecx,2
INVOKE BitBlt,SideDC,44,232,16,16,GrDC,ecx,48,SRCCOPY
ret
DrawSide endp

WndProc3 proc hWnd:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM
LOCAL Buf2[100]:BYTE
LOCAL Who:DWORD
mov eax,uMsg
.IF eax==WM_DESTROY
    INVOKE GetDlgItem,hDlg2,1000
    INVOKE EnableWindow,eax,1
    INVOKE GetDlgItem,hDlg2,1001     ;Enable all controls
    INVOKE EnableWindow,eax,1
    INVOKE GetDlgItem,hDlg2,1002
    INVOKE EnableWindow,eax,1
    INVOKE GetDlgItem,hDlg2,1003
    INVOKE EnableWindow,eax,1
    INVOKE GetDlgItem,hDlg2,1004
    INVOKE EnableWindow,eax,1
    INVOKE closesocket,hSock
    .IF PlayerN==0 && PlayerT>1 ;Server must close all sockets
        dec PlayerT
@21:    mov eax,PlayerT
        shl eax,2
        INVOKE closesocket,hSock[eax]
        dec PlayerT
        jnz @21
    .ENDIF
.ELSEIF eax==WM_CLOSE
    INVOKE IsWindowVisible,hDlg2
    .IF eax==0
        INVOKE SendMessage,hDlg,WM_CLOSE,0,0
    .ENDIF
    INVOKE DestroyWindow,hWnd
.ELSEIF eax==WM_CREATE
    INVOKE PostMessage,hWnd,WM_TIMER,0,0
.ELSEIF eax==WM_SOCKET
    mov eax,lParam
    .IF ax==FD_ACCEPT
        .IF PlayerT<10
            INVOKE accept,wParam,0,0
            mov ebx,PlayerT
            inc PlayerT
            mov GermList[ebx],-1
            shl ebx,2
            mov hSock[ebx],eax
            INVOKE WSAAsyncSelect,eax,hWnd,WM_SOCKET,FD_READ or FD_CLOSE
            .IF PlayerT==2
                INVOKE GetDlgItem,hWnd,1000
                INVOKE EnableWindow,eax,1
            .ENDIF
        .ELSE
            INVOKE accept,wParam,0,0
            INVOKE closesocket,eax
        .ENDIF
    .ELSEIF ax==FD_READ
        INVOKE recv,wParam,addr Buf2,1,0
        .IF eax==-1
            ret
        .ENDIF
        .IF eax
            mov al,Buf2
            .IF al==0   ;Message: Connect
                INVOKE WhichSock,wParam
                mov Who,eax
                mov GermList[eax],-1
                mov WinList[eax],0
                mov Buf2,8
                mov Buf2[1],al      ;Tell them their number
                shl eax,2
                mov ebx,eax
                INVOKE send,hSock[ebx],addr Buf2,2,0
                mov eax,Who         ;Add their name to the list
                shl eax,4
                INVOKE recv,wParam,addr Names[eax],16,0
                INVOKE PlayerList

                mov Buf2,2
                xor ebx,ebx         ;Send all players to new person
@17:                push ebx
                    .IF ebx
                        mov eax,Who
                        shl eax,2
                        mov ebx,eax
                        INVOKE send,hSock[ebx],addr Buf2,19,0
                    .ENDIF
                    pop ebx
                    mov Buf2[1],bl
                    mov cl,WinList[ebx]
                    mov Buf2[2],cl
                    lea edi,Buf2[3]
                    lea esi,Names
                    mov eax,ebx
                    shl eax,4
                    add esi,eax
                    mov ecx,16
                    rep movsb
                    inc ebx
                    cmp ebx,PlayerT
                    jb @17          ;Broadcast name to other players
                INVOKE Broadcast,addr Buf2,19
            .ELSEIF al==1 ;Message: Disconnect
                INVOKE recv,wParam,addr Buf2,1,0
                xor eax,eax
                mov al,Buf2
                INVOKE RemovePlayer,eax
            .ELSEIF al==2 ;Message: Add name
                INVOKE recv,wParam,addr Buf2,18,0
                xor eax,eax
                mov al,Buf2
                mov GermList[eax],-1
                .IF eax>=PlayerT
                    inc eax
                    mov PlayerT,eax
                    dec eax
                .ENDIF
                mov bl,Buf2[1]
                mov WinList[eax],bl
                lea edi,Names
                shl eax,4
                add edi,eax
                lea esi,Buf2[2]
                mov ecx,16
                rep movsb
                INVOKE PlayerList
            .ELSEIF al==3 ;Message: Germs left
                INVOKE recv,wParam,addr Buf2[1],2,0
                .IF PlayerN==0
                    INVOKE Broadcast,addr Buf2,3
                .ENDIF
                xor eax,eax
                xor ebx,ebx
                mov al,Buf2[1]
                mov bl,Buf2[2]
                mov GermList[eax],bl
                INVOKE IsWindowVisible,hDlg2
                .IF eax==0
                mov ecx,Attack
                .IF al==cl && bl==-1
                 mov eax,PlayerN
                 .IF GermList[eax]!=-1
                 INVOKE GetNext
                 .IF Attack!=eax && eax!=PlayerN
                   mov Attack,eax
                   shl eax,4
                   INVOKE wsprintfA,addr Buf2,offset Templ3,addr Names[eax]
                   INVOKE AddText,addr Buf2
                 .ENDIF
                 .ENDIF
                .ENDIF
                .ENDIF
                mov al,Buf2[2]
                .IF al==-1
                   xor eax,eax
                   mov al,Buf2[1]
                   shl eax,4
                   INVOKE wsprintfA,addr Buf2,offset Templ7,addr Names[eax]
                   INVOKE AddText,addr Buf2
                .ENDIF 
                INVOKE PlayerList
                INVOKE CountActive
                .IF eax==1
                    INVOKE PostMessage,hDlg,WM_CLOSE,0,2
                .ENDIF
            .ELSEIF al==4 ;Message: Attack
                INVOKE recv,wParam,addr Buf2[1],3,0
                mov al,Buf2[2]
                .IF PlayerN==0 && al!=0
                    shl eax,2
                    mov ebx,eax
                    INVOKE send,hSock[ebx],addr Buf2,4,0
                    xor eax,eax
                    ret
                .ENDIF  ;Therefore being attacked
                xor eax,eax
                mov al,Buf2[3]
                add NumDrop,eax
                xor ebx,ebx
                mov bl,Buf2[1]
                shl ebx,4
INVOKE wsprintfA,addr Buf2,offset Templ4,addr Names[ebx],eax
                INVOKE AddText,addr Buf2
            .ELSEIF al==5 ;Message: Won
                INVOKE recv,wParam,addr Buf2[1],1,0
                .IF PlayerN==0
                    INVOKE Broadcast,addr Buf2,2
                    .IF PlayerT>1
                        INVOKE GetDlgItem,hWnd,1000
                        INVOKE EnableWindow,eax,1
                    .ENDIF
                .ENDIF
                INVOKE IsWindowVisible,hDlg2
                .IF eax==0
                    INVOKE SendMessage,hDlg,WM_CLOSE,0,3
                .ENDIF
                xor eax,eax
                mov al,Buf2[1]
                inc WinList[eax]
                shl eax,4
                INVOKE wsprintfA,addr Buf2,offset Templ5,addr Names[eax]
                INVOKE AddText,addr Buf2
                lea edi,GermList
                mov al,-1
                mov ecx,10
                rep stosb
                INVOKE PlayerList
            .ELSEIF al==6 ;Message: Start game
                INVOKE recv,wParam,addr Buf2,2,0
                lea edi,Buf2
                xor eax,eax
                mov ax,[edi]
                INVOKE Randomize,eax
                mov eax,PlayerN
                inc eax
                .IF eax==PlayerT
                    xor eax,eax
                .ENDIF
                mov Attack,eax
                shl eax,4
                INVOKE wsprintfA,addr Buf2,offset Templ3,addr Names[eax]
                INVOKE AddText,addr Buf2
                jmp @Game
            .ELSEIF al==7 ;Message: Chat
                mov Buf2,7
                INVOKE recv,wParam,addr Buf2[1],2,0
                xor eax,eax
                mov al,Buf2[2]
                push eax
                INVOKE recv,wParam,addr Buf2[3],eax,0
                pop eax
                .IF PlayerN==0
                    add eax,3
                    INVOKE Broadcast,addr Buf2,eax
                .ENDIF
                xor ebx,ebx
                mov bl,Buf2[1]
                shl ebx,4
INVOKE wsprintfA,offset BoxBuf,offset Templ2,addr Names[ebx],addr Buf2[3]
                INVOKE AddText,offset BoxBuf
            .ELSEIF al==8 ;Message: Set PlayerN
                INVOKE recv,wParam,addr Buf2,1,0
                xor eax,eax
                mov al,Buf2
                mov PlayerN,eax
                inc eax
                mov PlayerT,eax
            .ENDIF
        .ENDIF
    .ELSEIF ax==FD_CLOSE
        .IF PlayerN==0
            INVOKE WhichSock,wParam
            mov Who,eax
            mov Buf2,1
            mov Buf2[1],al
            INVOKE Broadcast,addr Buf2,2
            INVOKE RemovePlayer,Who
            .IF PlayerT<2
                INVOKE IsWindowVisible,hDlg2
                .IF eax==0
                    INVOKE CountActive
                    .IF eax==1
                        INVOKE PostMessage,hDlg,WM_CLOSE,0,2
                    .ENDIF                
                .ENDIF
                INVOKE GetDlgItem,hWnd,1000
                INVOKE EnableWindow,eax,0
            .ENDIF
        .ELSE
            INVOKE PostMessage,hWnd,WM_CLOSE,0,0
        .ENDIF
    .ENDIF
.ELSEIF eax==WM_TIMER
    INVOKE GetDlgItem,hWnd,1001
    INVOKE SetWindowLong,eax,GWL_WNDPROC,EditProc
    mov lpEditProc,eax
    lea edi,WinList
    mov al,0
    mov ecx,10
    rep stosb
    .IF PlayerN==0
        mov PlayerT,1
        INVOKE SendDlgItemMessage,hDlg2,1004,WM_GETTEXT,16,offset Names
        mov GermList,255
        INVOKE PlayerList
        INVOKE socket,PF_INET,SOCK_STREAM,IPPROTO_TCP
        mov hSock,eax
        mov SA.sin_family,AF_INET
        mov SA.sin_addr.S_un.S_addr,INADDR_ANY
        INVOKE htons,80
        mov SA.sin_port,ax
        INVOKE WSAAsyncSelect,hSock,hWnd,WM_SOCKET,FD_ACCEPT
        INVOKE bind,hSock,offset SA,sizeof SA
        INVOKE listen,hSock,5   ;Server listens for connections
    .ELSE
        mov Buf2,0
        INVOKE SendDlgItemMessage,hDlg2,1004,WM_GETTEXT,16,addr Buf2[1]
        INVOKE send,hSock,addr Buf2,17,0
    .ENDIF
    INVOKE SendDlgItemMessage,hWnd,1001,EM_SETLIMITTEXT,80,0
.ELSEIF eax==WM_COMMAND
    mov eax,wParam
    .IF ax==1000 && PlayerT>1   ;Time to start!
        mov Buf2,6
        INVOKE Rand,65536
        lea edi,Buf2[1]
        mov [edi],ax
        INVOKE Randomize,eax
        INVOKE GetDlgItem,hWnd,1000
        INVOKE EnableWindow,eax,0
        INVOKE Broadcast,addr Buf2,3
        mov Attack,1
        INVOKE wsprintfA,addr Buf2,offset Templ3,addr Names[16]
        INVOKE AddText,addr Buf2
        jmp @Game
    .ENDIF
.ELSE
    INVOKE DefWindowProc,hWnd,uMsg,wParam,lParam
    ret
.ENDIF
xor eax,eax
ret
WndProc3 endp

PlayerList proc
LOCAL Sort[20]:BYTE
LOCAL Way:BYTE
INVOKE IsWindowVisible,hDlg2
mov Way,al
lea edi,Sort[10]
.IF al
    lea esi,WinList
.ELSE
    lea esi,GermList
.ENDIF
mov ecx,PlayerT
rep movsb
lea edi,Sort        ;Sort players by germs left or wins
mov al,0
@12:mov [edi],al
    inc edi
    inc al
    cmp al,10
    jnz @12
xor ebx,ebx
xor ecx,ecx
inc ecx
.IF PlayerT!=1
@13:    mov al,Sort[10+ebx]
        mov dl,Way
        .IF (Sort[10+ecx]<al && dl==0) || (Sort[10+ecx]>al && dl)
            mov dl,Sort[10+ecx]
            mov Sort[10+ecx],al
            mov Sort[10+ebx],dl
            mov al,Sort[ebx]
            mov dl,Sort[ecx]
            mov Sort[ebx],dl
            mov Sort[ecx],al
        .ENDIF
        inc ecx
        cmp ecx,PlayerT
        jb @13
        inc ebx
        mov ecx,ebx
        inc ecx
        cmp ecx,PlayerT
        jb @13
.ENDIF
xor ebx,ebx
@15:push ebx
    xor eax,eax
    mov al,Sort[ebx+10]
    push eax
    lea ecx,Names
    xor edx,edx
    mov dl,Sort[ebx]
    shl edx,4
    add ecx,edx     ;Put together string of rank,name,germs left/wins
    push ecx
    shr edx,4
    push edx
    .IF edx!=PlayerN
        push offset Templ
    .ELSE
        push offset Templ8      ;Put * on self
    .ENDIF
    push offset Buf
    call wsprintfA
    add esp,20
    pop ebx
    push ebx

    push offset Buf
    push 0
    push WM_SETTEXT     ;Put text
    mov eax,500
    add eax,ebx
    push eax
    push hDlg3
    call SendDlgItemMessage

    pop ebx
    inc ebx
    cmp ebx,PlayerT
    jb @15
mov ebx,PlayerT
.IF ebx<10
    mov Buf[1],0
    add bl,48           ;Blank next caption
    mov Buf,bl

    push offset Buf
    push 0
    push WM_SETTEXT     ;Put text
    mov eax,452
    add eax,ebx
    push eax
    push hDlg3
    call SendDlgItemMessage
.ENDIF
ret
PlayerList endp

WhichSock proc hS:DWORD
xor eax,eax
lea edi,hSock
@16:mov ebx,[edi]
    .IF ebx==hS   ;If socket found, return it!
        ret
    .ENDIF
    add edi,4
    inc eax
    cmp eax,PlayerT
    jb @16
xor eax,eax         ;Failed.  Return -1.
dec eax
ret
WhichSock endp

Broadcast proc Msg:DWORD,Len:DWORD
.IF PlayerT!=1
    xor ebx,ebx
    inc ebx
@18:    push ebx
        mov ecx,ebx
        shl ecx,2
        INVOKE send,hSock[ecx],Msg,Len,0
        pop ebx
        inc ebx
        cmp ebx,PlayerT
        jb @18
.ENDIF
ret
Broadcast endp

EditProc proc hCtl:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
LOCAL Buf2[100]:BYTE
.IF uMsg==WM_KEYUP && wParam==VK_RETURN     ;If enter, send message
    mov Buf2,7
    mov eax,PlayerN
    mov Buf2[1],al
    INVOKE CallWindowProc,lpEditProc,hCtl,WM_GETTEXT,81,addr Buf2[3]
    inc eax
    mov Buf2[2],al
    add eax,3
    .IF PlayerN==0
        INVOKE Broadcast,addr Buf2,eax
INVOKE wsprintfA,offset BoxBuf,offset Templ2,offset Names,addr Buf2[3]
        INVOKE AddText,offset BoxBuf
    .ELSE
        INVOKE send,hSock,addr Buf2,eax,0
    .ENDIF
    mov Buf2,0
    INVOKE CallWindowProc,lpEditProc,hCtl,WM_SETTEXT,0,addr Buf2
    xor eax,eax
    ret
.ENDIF
INVOKE CallWindowProc,lpEditProc,hCtl,uMsg,wParam,lParam
ret
EditProc endp

AddText proc Txt:DWORD
LOCAL hDCLB:DWORD
LOCAL PLen:SIZEL
LOCAL Len:DWORD
INVOKE GetDlgItem,hDlg3,2000
INVOKE GetDC,eax
mov hDCLB,eax
@24:
INVOKE lstrlen,Txt      ;Word wrap if necessary
mov Len,eax
INVOKE GetTextExtentPoint32,hDCLB,Txt,Len,addr PLen
.IF PLen.x>257
    mov ebx,17
@23:    push ebx
        INVOKE GetTextExtentPoint32,hDCLB,Txt,ebx,addr PLen
        pop ebx
        inc ebx
        cmp PLen.x,257
        jb @23
    dec ebx
    dec ebx
    mov edi,Txt
    add edi,ebx
    mov ecx,10
    mov al,32
    std
    repne scasb     ;Scan backwards for spaces
    cld
    .IF ecx!=0
        add ebx,ecx
        sub ebx,8
    .ENDIF
    mov edi,Txt
    add edi,ebx
    push ebx
    mov al,[edi]
    push ax
    mov BYTE PTR[edi],0
    INVOKE SendDlgItemMessage,hDlg3,2000,LB_ADDSTRING,0,Txt
    pop ax
    pop ebx
    add Txt,ebx
    mov edi,Txt
    mov [edi],al
    sub edi,5
    mov al,32
    mov ecx,5
    rep stosb
    sub Txt,5
    jmp @24
.ENDIF
INVOKE GetDlgItem,hDlg3,2000
INVOKE ReleaseDC,eax,hDCLB
INVOKE SendDlgItemMessage,hDlg3,2000,LB_ADDSTRING,0,Txt
INVOKE SendDlgItemMessage,hDlg3,2000,LB_GETCOUNT,0,0
.IF eax>100
@22:INVOKE SendDlgItemMessage,hDlg3,2000,LB_DELETESTRING,0,0
    cmp eax,100
    ja @22
.ENDIF
.IF eax>5
    sub eax,5       ;Scroll listbox to bottom
    INVOKE SendDlgItemMessage,hDlg3,2000,LB_SETTOPINDEX,eax,0
.ENDIF
ret
AddText endp

RemovePlayer proc Who:DWORD
mov eax,Who
dec eax
.IF PlayerN>eax
    dec PlayerN
.ENDIF
.IF eax!=PlayerT
    mov ebx,Who
@19:    mov al,GermList[ebx+1]
        mov GermList[ebx],al
        mov al,WinList[ebx+1]
        mov WinList[ebx],al
        shl ebx,4
        lea esi,Names[ebx]
        mov edi,esi
        add esi,16
        mov ecx,16
        rep movsb
        shr ebx,2
        .IF PlayerN==0
            mov eax,hSock[ebx+4]
            mov hSock[ebx],eax
        .ENDIF
        shr ebx,2
        inc ebx
        cmp ebx,PlayerT
        jb @19
.ENDIF
dec PlayerT
INVOKE PlayerList
INVOKE IsWindowVisible,hDlg2    ;Game in progress
.IF eax==0
    mov eax,Who
    .IF Attack==eax
        INVOKE GetNext
        .IF eax!=PlayerN        ;Can't target self
            mov Attack,eax
            shl eax,4
            INVOKE wsprintfA,offset Buf,offset Templ3,addr Names[eax]
            INVOKE AddText,offset Buf
        .ENDIF
    .ENDIF
.ENDIF
ret
RemovePlayer endp

GetNext proc
mov eax,PlayerN
xor ebx,ebx
inc eax
.IF eax==PlayerT
    xor eax,eax     ;If at end, go to beginning
.ENDIF
@20:mov bl,GermList[eax]
    .IF bl!=-1      ;Not dead, so done
        ret
    .ENDIF
    inc eax
    .IF eax==PlayerT
        xor eax,eax ;If at end, go to beginning
    .ENDIF
    cmp eax,PlayerN ;Done when loop back to self
    jnz @20
ret
GetNext endp

CountActive proc
xor ebx,ebx
xor eax,eax
@21:mov cl,GermList[ebx]
    .IF cl!=-1      ;Count if not dead
        inc eax
    .ENDIF
    inc ebx
    cmp ebx,PlayerT
    jb @21
ret
CountActive endp
end program