.386
.model flat,stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\masm32.inc

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib

WinMain proto :DWORD,:DWORD,:DWORD,:DWORD
EditBox PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD

.data
	ClassName db "SimpleWinClass",0
	AppName   db "Our First Window",0
	szDisplayText db "FlatBorder", 0
	
.data?
	hInstance HINSTANCE ?
	CommandLine LPSTR ?
	
.code
start:
	invoke GetModuleHandle, NULL
	mov    hInstance,eax
	invoke GetCommandLine
	mov    CommandLine,eax
	invoke WinMain, hInstance,NULL,CommandLine, SW_SHOWDEFAULT
	invoke ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:DWORD
	LOCAL wc:WNDCLASSEX
	LOCAL msg:MSG
	LOCAL hwnd:HWND
	mov   wc.cbSize,SIZEOF WNDCLASSEX
	mov   wc.style, CS_HREDRAW or CS_VREDRAW
	mov   wc.lpfnWndProc, OFFSET WndProc
	mov   wc.cbClsExtra,NULL
	mov   wc.cbWndExtra,NULL
	push  hInstance
	pop   wc.hInstance
	mov   wc.hbrBackground,COLOR_BTNFACE+1
	mov   wc.lpszMenuName,NULL
	mov   wc.lpszClassName,OFFSET ClassName
	invoke LoadIcon,NULL,IDI_APPLICATION
	mov   wc.hIcon,eax
	mov   wc.hIconSm,eax
	invoke LoadCursor,NULL,IDC_ARROW
	mov   wc.hCursor,eax
	invoke RegisterClassEx, addr wc
	INVOKE CreateWindowEx,NULL,ADDR ClassName,ADDR AppName,\
           WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,\
           CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,\
           hInst,NULL
	mov   hwnd,eax
	invoke ShowWindow, hwnd,SW_SHOWNORMAL
	invoke UpdateWindow, hwnd
	.WHILE TRUE
		invoke GetMessage, ADDR msg,NULL,0,0
		.BREAK .IF (!eax)
		invoke TranslateMessage, ADDR msg
		invoke DispatchMessage, ADDR msg
	.ENDW
	mov     eax,msg.wParam
	ret
WinMain endp

WndProc proc hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	.IF uMsg==WM_DESTROY
		invoke PostQuitMessage,NULL
	.ELSEIF uMsg==WM_CREATE
		invoke EditBox,ADDR szDisplayText,200,10,150,21,hWnd,700
		invoke EditBox,ADDr szDisplayText,200,35,150,21,hWnd,701
		
	.ELSE
		invoke DefWindowProc,hWnd,uMsg,wParam,lParam
		ret
	.ENDIF
	xor eax,eax
	ret

WndProc endp

EditBox proc szMsg:DWORD,a:DWORD,b:DWORD,
               wd:DWORD,ht:DWORD,hParent:DWORD,ID:DWORD
	
	LOCAL hEdit :DWORD
	
	.Data
    	szEditText db "EDIT", 0
	.Code
		
    invoke CreateWindowEx,WS_EX_CLIENTEDGE,ADDR szEditText,szMsg,
                WS_VISIBLE or WS_CHILDWINDOW or \
                ES_AUTOHSCROLL or ES_NOHIDESEL,
              	a,b,wd,ht,hParent,ID,hInstance,NULL
	
	; Remember the handle of the newly created edit control
	;
	mov hEdit, eax
	
	; Get the extended styles
	;
	invoke GetWindowLong, hEdit, GWL_EXSTYLE
	
	; Get rid of the client edge
	;
	and eax, not WS_EX_CLIENTEDGE
	or eax, WS_EX_STATICEDGE
	
	; Make the changes take effect
	;
	invoke SetWindowLong, hEdit, GWL_EXSTYLE, eax
	invoke SetWindowPos, hEdit, 0, 0, 0, 0, 0, SWP_NOACTIVATE or SWP_NOZORDER or SWP_FRAMECHANGED or SWP_NOSIZE or SWP_NOMOVE
	
	; Make sure the edit control's handle is in EAX at this point
	;
	mov eax, hEdit
    ret

EditBox endp

end start
