;              *****************************************         |
;    --      **                                         **      -*-  
;           **         flux 3.00                           **     |
;         **                                                 **
;   *   **      By +++ Angelo     :-)                          **
;       **                                                     **    +
;       **      Learn as if you would live forever,            **
;       **                                                     **
;       **        but live as if you should die tomorrow.      **   .   .
;         **                                                 **
;   +       **    -- Be Happy to be in The Asm Elite ! --  **       --
;       |     **                                         **
;      -*-      *****************************************
;       |                                                       --    
                                                                                                                                                                                                                                                                                                                                                                                                                                                           
        .386
        locals
        jumps 
        .model flat, stdcall
                                                 
        extrn   BeginPaint              :Proc
        extrn   BitBlt                  :Proc
        extrn   ClearCommError          :Proc
        extrn   CloseHandle             :Proc
        extrn   CreateCompatibleDC      :Proc
        extrn   CreateWindowExA         :Proc
        extrn   CreateFileA             :Proc
        extrn   CreateFontA             :Proc
        extrn   CreateThread            :Proc
        extrn   DefWindowProcA          :Proc
        extrn   DispatchMessageA        :Proc
        extrn   EnableWindow            :Proc
        extrn   EndPaint                :Proc
        extrn   ExitProcess             :Proc
        extrn   GetCommandLineA         :Proc
        extrn   GetCommMask             :Proc
        extrn   GetCommState            :Proc
        extrn   GetComputerNameA        :Proc
        extrn   GetDC                   :Proc      
        extrn   GetLastError            :Proc
        extrn   GetModuleHandleA        :Proc
        extrn   GetWindowTextA          :Proc
        extrn   GetWindowTextLengthA    :Proc
        extrn   GlobalAlloc             :Proc
        extrn   GlobalMemoryStatus      :Proc
        extrn   LoadBitmapA             :Proc
        extrn   LoadCursorA             :Proc
        extrn   LoadIconA               :Proc
        extrn   RtlMoveMemory           :Proc
        extrn   PeekMessageA            :Proc
        extrn   PostMessageA            :Proc
        extrn   PostQuitMessage         :Proc
        extrn   PurgeComm               :Proc
        extrn   ReadFile                :Proc
        extrn   RegisterClassA          :Proc
        extrn   ResumeThread            :Proc
        extrn   SelectObject            :Proc
        extrn   SendMessageA            :Proc
        extrn   SetCommMask             :Proc
        extrn   SetCommState            :Proc
        extrn   SetLastError            :Proc
        extrn   SetWindowTextA          :Proc
        extrn   SetCommMask             :Proc
        extrn   SetupComm               :Proc
        extrn   ShowWindow              :Proc
        extrn   Sleep                   :Proc
        extrn   TextOutA                :Proc
        extrn   TranslateMessage        :Proc
        extrn   UpdateWindow            :Proc
        extrn   VirtualAlloc            :Proc
        extrn   WaitCommEvent           :Proc
        extrn   WriteFile               :Proc
        extrn   _wsprintfA              :Proc

;      USUAL SETTINGS:             
;                           03BCh LPT1 port    
;                           0378h LPT2 port     
;                           0278h LPT3 port     
;                           03F8h COM1 port     
;                           02F8h COM2 port    
;                           03E8h COM3 port    
;                           02E8h COM4 port  
   
;                           Off Desc.          
;                           --------------------
;                           +0  SPP data port  
;                           +1  SPP status reg. 
;                           +2  SPP control reg.
;                           +3  EPP port address
;                           +4  EPP data port  
;                           +5  N/A not defined 



        ; +++ Data Structures

MEMORYSTATUS            STRUC

dwLength                dd      ?       ;    // sizeof(MEMORYSTATUS) 
dwMemoryLoad            dd      ?       ;    // percent of memory in use 
dwTotalPhys             dd      ?       ;    // bytes of physical memory 
dwAvailPhys             dd      ?       ;    // free physical memory bytes 
dwTotalPageFile         dd      ?       ;    // bytes of paging file 
dwAvailPageFile         dd      ?       ;    // free bytes of paging file 
dwTotalVirtual          dd      ?       ;    // user bytes of address space 
dwAvailVirtual          dd      ?       ;    // free user bytes 
MEMORYSTATUS            ENDS

OVERLAPPED              STRUC

Internal                dd      ?       ; 
InternalHigh            dd      ?       ; 
TOffset                 dd      ?       ; 
OffsetHigh              dd      ?       ; 
hEvent                  dd      ?       ; 
OVERLAPPED              ENDS 

WNDCLASS                STRUC

clsStyle                dd      ?       ; class style
clsLpfnWndProc          dd      ?
clsCbClsExtra           dd      ?
clsCbWndExtra           dd      ?
clsHInstance            dd      ?       ; instance handle
clsHIcon                dd      ?       ; class icon handle
clsHCursor              dd      ?       ; class cursor handle
clsHbrBackground        dd      ?       ; class background brush
clsLpszMenuName         dd      ?       ; menu name
clsLpszClassName        dd      ?       ; far ptr to class name
hIconSm                 dd      ?
WNDCLASS                ENDS

MSGSTRUCT               STRUC

mshWnd                  dd      ?
msMessage               dd      ?
msWparam                dd      ?
msLparam                dd      ?
msTime                  dd      ?
msPT                    dd      2 dup(?)
MSGSTRUCT               ENDS

PAINTSTRUCT             STRUC

psHdc                   dd      ? 
fErase                  dd      ? 
rcPaint                 dd      ? 
fRestore                dd      ? 
fIncUpdate              dd      ?
gbReserved              db      ?
PAINTSTRUCT             ENDS

DCBS                    STRUC  

DCBlength               dd      ?       ;               // sizeof(DCB) 
BaudRate                dd      ?       ;               // current baud rate 
fBinary                 dd      ?       ;               // binary mode, no EOF check 
fParity                 dd      ?       ;               // enable parity checking 
fOutxCtsFlow            dd      ?       ;               // CTS output flow control 
fOutxDsrFlow            dd      ?       ;               // DSR output flow control 
fDtrControl             dd      ?       ;               // DTR flow control type 
fDsrSensitivity         dd      ?       ;               // DSR sensitivity 
fTXContinueOnXoff       dd      ?       ;               // XOFF continues Tx 
fOutX                   dd      ?       ;               // XON/XOFF out flow control 
fInX                    dd      ?       ;               // XON/XOFF in flow control 
fErrorChar              dd      ?       ;               // enable error replacement 
fNull                   dd      ?       ;               // enable null stripping 
fRtsControl             dd      ?       ;               // RTS flow control 
fAbortOnError           dd      ?       ;               // abort reads/writes on error 
fDummy2                 dd      ?       ;               // reserved 
wReserved               dw      ?       ;               // not currently used 
XonLim                  dw      ?       ;               // transmit XON threshold 
XoffLim                 dw      ?       ;               // transmit XOFF threshold 
ByteSize                db      ?       ;               // number of bits/byte, 4-8 
Parity                  db      ?       ;               // 0-4=no,odd,even,mark,space 
StopBits                db      ?       ;               // 0,1,2 = 1, 1.5, 2 
XonChar                 db      ?       ;               // Tx and Rx XON character 
XoffChar                db      ?       ;               // Tx and Rx XOFF character 
ErrorChar               db      ?       ;               // error replacement character 
EofChar                 db      ?       ;               // end of input character 
EvtChar                 db      ?       ;               // received event character 
wReserved1              dw      ?       ;               // reserved; do not use 
DCBS                    ENDS 

COMRECORD               RECORD  fCtsHold:1, fDsrHold:1,fRlsdHold:1,fXoffHold:1,fXoffSent:1,fEof:1,fTxim:1,fReserved:25

COMSTAT                 STRUC

comrec                  COMRECORD       <>
cbInQue                 dd              ?
cbOutQue                dd              ?
COMSTAT                 ENDS

.data

;                       CONTROL HANDLES

E010                    dd      0
E020                    dd      0
E021                    dd      0
E022                    dd      0
E023                    dd      0
E024                    dd      0
E025                    dd      0
E030                    dd      0
E035                    dd      0
E040                    dd      0
E050                    dd      0             
E060                    dd      0 
E070                    dd      0
E071                    dd      0
E072                    dd      0
E073                    dd      0
E074                    dd      0  
E075                    dd      0  
E080                    dd      0
E090                    dd      0
E100                    dd      0
E110                    dd      0
E120                    dd      0
E130                    dd      0
E140                    dd      0
E150                    dd      0
E160                    dd      0
B100                    dd      0
B110                    dd      0
B120                    dd      0
B130                    dd      0
B131                    dd      0
B140                    dd      0
B164                    dd      0
B170                    dd      0
B180                    dd      0
B190                    dd      0
B200                    dd      0
B210                    dd      0
B220                    dd      0
B230                    dd      0
B240                    dd      0
B250                    dd      0              
B260                    dd      0
C010                    dd      0

;                       EVENTS

Event                   db      0
Event00                 db      '0',0
Event01                 db      13,10,'#01: parallel port open',0
Event02                 db      13,10,'#02: string sent on port',0
Event03                 db      13,10,'#03: serial port open 9600,N,8,1',0  
Event04                 db      13,10,'#04: buffer cleared',0
Event05                 db      13,10,'#05: port selected:     ',0
Event06                 db      13,10,'#06: buffer empty ! Please insert data',0
Event07                 db      13,10,'#07: port is already open',0
Event08                 db      13,10,'#10: port closed',0
Event09                 db      13,10,'#11: receiving data...',0   

;                       BUFFERS

CompName                db      16      dup (0)
NumBuffer               db      32      dup (?),0
PortName                db      16      dup (0),0
SelectedPort            db      4       dup (0),0
StringToSend            db      1000    dup (0),0
RecBuffer               db      1000    dup (0),0

;                       Header - HYNTRO

Header                  db      13,10
                        db      'Flux is Freeware !',13,10
                        db      13,10          
                        db      'written entirely in assembler',13,10
                        db      'by Angelo',13,10,13,10
                        db      'i hope that this little program',13,10
                        db      'will be helpful to you in someway ...',13,10,13,10
                        db      'but in any case thanks for using it !',13,10,13,10
                        db      'you can send comments & suggestions to:',13,10
                        db      'asm@ngi.it',13,10,0

;                       BYTE

Com1St                  db      0                               ; ComSt and LptSt must stay togheter (loop)
Com2St                  db      0
Com3St                  db      0
Com4St                  db      0
Lpt1St                  db      0
Lpt2St                  db      0
Lpt3St                  db      0
Lpt4St                  db      0
EndDoc                  db      12
Format1                 db      '%lu',0                         ; a long, unsigned integer
Format2                 db      '%0.4lX',0                      ; 0 min, 4 digit, long, unsigned Hex uppercase
szCOM                   db      'COMX',0
szLPT                   db      'LPTX',0

;                       WORDS

Addr1                   dw      0
Addr2                   dw      0
Addr3                   dw      0
Addr4                   dw      0
Addr5                   dw      0
Addr6                   dw      0
Addr7                   dw      0
Addr8                   dw      0
Address                 dw      0

;                       DOUBLEWORDS

commListenerID          dd      0
MaxCompNameLength       dd      16
E16BuffAddr             dd      0
ErrorFlags              dd      0
FileHndle               dd      0
hBitmap1                dd      0
hBitmap2                dd      0
hDC                     dd      0
hFont1                  dd      0
hFont2                  dd      0
hFont3                  dd      0
hFont4                  dd      0
hInstance               dd      ?
hModemListener          dd      ?
hWndMain                dd      ?
Line                    dd      0
memdc                   dd      0
Point                   dd      0
PortEvent               dd      0
Read                    dd      0
XI                      dd      0
YI                      dd      0
Written                 dd      0

;                       CONTROLS CLASSES

ButtonClass             db      'BUTTON',0  
ComboClass              db      'COMBOBOX',0
EditClass               db      'EDIT',0

;                       CONTROLS STRINGS, window position order

AppName                 db      'Flux',0
ClassName               db      'flux',0
Font1                   db      'Arial',0
Font2                   db      'Courier New',0
Font3                   db      'Comic Sans MS',0
ComputerName            db      'PC name:',0
TotMemory               db      'total memory:',0
AvMemory                db      'avail. memory:',0
SelectPort              db      'Select a port: ',0
OpenPort                db      'Open Port',0
ClosePort               db      'Close Port ',0
TypeString              db      'Type a string to send ...',0
SendString              db      'Send String',0
PrintString             db      'Print String',0
ClearBuffer             db      'Clear Buffer',0
ReceiveBuffer           db      'Receive Buffer',0
AutoReceive             db      'Auto Receive On',0
EventMsg                db      'Event message',0
ClearEventLog           db      'Clear Events',0
PortsDet                db      'port/address dectecion',0
COMlabels               db      'COM1  COM2  COM3  COM4',0
LPTlabels               db      ' LPT1    LPT2    LPT3    LPT4',0
ParStatus               db      'Parallel Status',0
nERROR                  db      'nERROR',0
SELECT                  db      'SELECT / OnLine',0
PE                      db      'PE',0
nACK                    db      'nACK',0
BUSY                    db      'BUSY',0
SerStatus               db      'Serial Status',0
CTSOn                   db      'CTS On',0
DSROn                   db      'DSR On',0
RingOn                  db      'Ring On',0
RLSDOn                  db      'RLSD On',0

;                       RESOURCES
              
IDI_FLUX                equ     500
IDB_PSF                 equ     600
IDB_PSB                 equ     700

;                       COLORS

BROWN                   equ     00004284H
BLUE                    equ     00FF0000h                      
TAN                     equ     00BDDEFFH
LT_GRAY                 equ     00DEDEDEH
WHITE                   equ     00FFFFFFH

;                       STRUCTURES

wc                      WNDCLASS        <?>   
msg                     MSGSTRUCT       <?>
ps                      PAINTSTRUCT     <?>
mst                     MEMORYSTATUS    <?>
dcb                     DCBS            <?>
ovl                     OVERLAPPED      <?>
commState               COMSTAT         <?>

;-------------------------------------------------------------------------------------------------

.code

Start:          call    GetModuleHandleA,0
                mov     hInstance,eax

                ; registrazione classe
  
WinMain         Proc    hInst:DWORD, hPrevInst:DWORD, CmdLine:DWORD, CmdShow:DWORD             
                
                mov     eax,hInstance
                mov     wc.clsHInstance,eax
                mov     wc.clsStyle,0001h + 0002h + 4000h
                mov     wc.clsLpfnWndProc,offset WndProc      
                mov     wc.clsCbClsExtra,0
                mov     wc.clsCbWndExtra,0                            
                call    LoadIconA,hInstance,IDI_FLUX
                mov     wc.clsHIcon,eax
                mov     wc.hIconSm,eax
                call    LoadCursorA,0,32512
                mov     wc.clsHCursor,eax
                mov     wc.clsHbrBackground,5
                mov     wc.clsLpszMenuName,0
                mov     wc.clsLpszClassName,offset ClassName
                push    offset wc
                call    RegisterClassA                          ; Register the Window
      
                ; ora creiamo la finestra autocentrata
                
                call    CreateWindowExA,0,offset ClassName,offset AppName,080CE0A44h,20,20,550,400,0,0,hInstance,0
                mov     hWndMain,eax
               
                ; quindi attiviamola

                call    ShowWindow,hWndMain,01h
                call    UpdateWindow,hWndMain         
   
                ; +++ ciclo per lettura del messaggio
           
MessageLoop:    call    PeekMessageA,offset msg,0,0,0,1
                cmp     eax,0
                je      Return   
                call    TranslateMessage,offset msg
                call    DispatchMessageA,offset msg
Return:         jmp     MessageLoop
                mov     eax,msg.msMessage
                ret

WinMain         endp

                ; +++ routine principale WndProc

WndProc         proc    hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD

                cmp     uMsg,0001h                      
                je      Create
                cmp     uMsg,0111h
                je      Command
                cmp     uMsg,000Fh
                je      Paint 
                cmp     uMsg,0002h                      
                je      Destroy
                cmp     uMsg,0012h
                je      Destroy
                
                call    DefWindowProcA,hWnd,uMsg,wParam,lParam
                ret                                                            
             
Create:         call    CreateIOWin
                call    GetPortStatus
                ret

Paint:          call    BeginPaint,hWnd,offset ps       
                mov     hdc,eax                 

                ; Visualizzazione icone porte  ....

                mov     ebx,offset Com1st
                mov     XI,395
                mov     YI,030
                mov     ecx,8
DrawIcons:      cmp     ecx,4
                jne     LoopGoOn
                add     YI,057
                mov     XI,395
LoopGoOn:       cmp     byte ptr [ebx],2
                je      Increment
                push    ebx ecx
                cmp     byte ptr [ebx],1
                jne     Free
                call    SelectObject,memdc,hbitmap2
                call    BitBlt,hdc,XI,YI,26,26,memdc,0,0,00CC0020h
                jmp     NextCycle
Free:           call    SelectObject,memdc,hbitmap1
                call    BitBlt,hdc,XI,YI,26,26,memdc,0,0,00CC0020h
NextCycle:      pop     ecx ebx
Increment:      inc     ebx
                add     XI,36
                loop    DrawIcons   
                call    EndPaint,hWnd,offset ps
                ret

Destroy:        call    ExitProcess,eax
                ret

; 
; 
;                            
;                                  
;                           
;                                          
;                                  
;
; 

Command:        cmp     wParam,100A0h                                   ; CB.CURSEL + A0h = ID160
                jne     COpenPort
                call    GetWindowTextA,C010,offset SelectedPort,5       ; get combo text             
                mov     ebx,offset SelectedPort[3]
                xor     edx,edx
                mov     dl,byte ptr [ebx]
                sub     dl,48
                shl     dl,1                                            ; mul * 2
                sub     edx,2                                           ; port1, edx=2m, 2-2=0 (porta 1 = offset0)
                mov     ebx,offset SelectedPort
                cmp     byte ptr [ebx],'C'
                jne     PP
                mov     eax,offset Addr1
                jmp     Step2
PP:             mov     eax,offset Addr5
Step2:          add     eax,edx                                         ; aggiunge l'offset preparato in edx
                mov     ebx,offset Address
                mov     ebx,[eax]                                       ; prepare address of selected port                        
                mov     edi,offset Event05[22]
                mov     esi,offset SelectedPort
                mov     ecx,4
                cld
                rep     movsb
                call    DisableStButt
                call    CloseHandle,FileHndle
                call    EnableWindow,B131,0
                call    EnableWindow,E120,0
                mov     Event,05
                call    EventOut
                ret
                
COpenPort:      cmp     wParam,170
                jne     CloseThePort
                call    EnableWindow,E100,1
                mov     eax,offset SelectedPort
                cmp     byte ptr [eax],'L'                              ; Port is a parallel port ??
                jne     @serial
                call    Reset                                           ; reset, only for parallel port      
                mov     esi,offset B170 
                mov     ecx,5
PEnabling:      mov     eax,[esi]                                       ; PARALLEL ENABLING
                push    ecx    
                call    EnableWindow,eax,1
                add     esi,4
                pop     ecx
                loop    PEnabling              
                call    ParallelStatus
                mov     Event,01
                call    EventOut
                call    EnableWindow,B130,1
                ret
@serial:        call    EnableWindow,B131,1                                             ; AUTORECEIVE ENABLED
                call    CreateFileA,offset SelectedPort,0C0000000h,0,0,3,40000080h,0    ; open serial port
                mov     FileHndle,eax  
                mov     dcb.dcblength,size dcb                      
                call    GetCommState,FileHndle,offset dcb 
                call    SetSettings
                call    SetupComm,FileHndle,4096,4096                                   ; COMM_INBUFSIZE,COMM_OUTBUFSIZE 
                call    PurgeComm,FileHndle,0Fh                                                                                                                                    
                mov     esi,offset B220
                mov     ecx,4
SEnabling:      mov     eax,[esi] 
                push    ecx    
                call    EnableWindow,eax,1
                add     esi,4
                pop     ecx
                loop    SEnabling               
                call    SerialStatus       
                mov     Event,03
                call    EventOut
                call    EnableWindow,B120,1
                ret

CloseThePort:   cmp     wParam,180
                jne     CSendString
                call    CloseHandle,FileHndle
                call    DisableStButt
                call    EnableWindow,B131,0
                call    EnableWindow,E100,0
                mov     Event,08
                call    EventOut
                ret

CSendString:    cmp     wParam,190
                jne     @SendPP
                mov     ebx,offset StringToSend
                call    CleanBuffer
                call    GetWindowTextA,E100,offset StringToSend,1000
                cmp     eax,0
                jne     Sending
                mov     Event,06
                call    EventOut
                ret   
Sending:        call    WriteFile,FileHndle,offset StringToSend,eax,offset Written,offset ovl
                call    SerialStatus  
                ret   
  
@SendPP:        cmp     wParam,200
                jne     AutoRec
                mov     esi,offset StringToSend
                mov     dx,Address
                call    SPPSend
                mov     esi,offset EndDoc
                mov     eax,1
                mov     dx,Address
                call    SPPSend                                 ; End document to the printer
                mov     Event,02
                call    EventOut
                ret

AutoRec:        cmp     wParam,211
                jne     CClearBuffer1
                call    SendMessageA,B131,0F0h,0,0
                cmp     eax,01h
                je      StopAutoRec 
                call    SendMessageA,B131,00F1h,1,0             ; abilito il check box !
                call    EnableWindow,E120,1                     ; abilito l'edit box del receive buffer !
                call    SendMessageA,E120,000Fh,0,0             ; forza redraw receive buffer                                          
                call    SetupComm,FileHndle,4096,4096           ; COMM_INBUFSIZE,COMM_OUTBUFSIZE 
                call    PurgeComm,FileHndle,0Fh
                mov     PortEvent,0    
                mov     ebx,offset RecBuffer
                call    CleanBuffer   
                mov     ebx,offset RecBuffer
                mov     Point,ebx 
                call    CreateThread,0,0,offset ModemListener,hWnd,4h,offset commListenerID
                mov     hModemListener,eax             
                call    ResumeThread,hModemListener
                mov     Event,09
                call    EventOut
                ret
StopAutoRec:    call    EnableWindow,E120,0
                call    SetWindowTextA,E120,0
                call    SendMessageA,B131,0F1h,0,0 
                ret
                  
CClearBuffer1:  cmp     wParam,205
                jne     CClearBuffer2
                mov     ebx,offset StringToSend
                call    CleanBuffer
                call    SetWindowTextA,E100,0
                mov     Event,04
                call    EventOut
                ret

CClearBuffer2:  cmp     wParam,250
                jne     ClearEvent
                mov     ebx,offset RecBuffer
                call    CleanBuffer
                mov     ebx,offset RecBuffer
                mov     Point,ebx
                call    SetWindowTextA,E120,0
                mov     Event,04
                call    EventOut
                ret

ClearEvent:     cmp     wParam,320
                jne     comret
                call    SendMessageA,E160,000Ch,0,0
                call    SendMessageA,E160,000Fh,0,0             ; force redraw !!
comret:         ret

WndProc         endp

; 
;
;                            
;                                                 
;                           
;                                                 
;                               
;
; 
                          
CreateIOWin:    ; preparazione parte grafica
                
                call    LoadBitmapA,hInstance,IDB_PSF
                mov     hBitmap1,eax
                call    LoadBitmapA,hInstance,IDB_PSB
                mov     hBitmap2,eax
                call    GetDC,hWnd                               
                mov     hdc,eax
                call    CreateCompatibleDC,hdc
                mov     memdc,eax                       

                ; computer e system info ...

                call    GetComputerNameA,offset CompName,offset MaxCompNameLength
                call    GlobalMemoryStatus,offset mst

                ; creo tutti i font per l'applicaizone

                call    CreateFontA,14,0,0,0,700,0,0,0,0,0,0,0,0,offset Font1      ; Comic Sans MS
                mov     hFont1,eax                                                    
                call    CreateFontA,14,0,0,0,400,0,0,0,0,0,0,0,0,offset Font2
                mov     hFont2,eax
                call    CreateFontA,12,0,0,0,800,0,0,0,0,0,0,0,0,offset Font1
                mov     hFont3,eax
                call    CreateFontA,12,0,0,0,900,0,0,0,0,0,0,0,0,offset Font1
                mov     hFont4,eax
              
                ;       E010                   ## E1 presentazione  ##     

                call    CreateWindowExA,0,offset EditClass,offset Header,50200845h,5,8,200,60,hWnd,10,hInstance,0
                mov     E010,eax 
                call    SendMessageA,E010,0030h,hFont3,0 
             
                ;       E020-021               ## system info varie ##
     
                call    CreateWindowExA,0,offset EditClass,offset ComputerName,050000802h,212,8,60,15,hWnd,20,hInstance,0     
                mov     E020,eax 
                call    SendMessageA,E020,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,offset CompName,050000804h,272,8,120,15,hWnd,21,hInstance,0     
                mov     E021,eax 
                call    SendMessageA,E021,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,offset TotMemory,050000806h,212,28,90,15,hWnd,20,hInstance,0     
                mov     E022,eax 
                call    SendMessageA,E022,0030h,hFont3,0 
                mov     eax,mst.dwTotalPhys
                call    _wsprintfA,offset NumBuffer,offset Format1,eax
                add     esp,0ch
                call    CreateWindowExA,0,offset EditClass,offset NumBuffer,050000806h,304,28,60,15,hWnd,21,hInstance,0     
                mov     E023,eax 
                call    SendMessageA,E023,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,offset AvMemory,050000806h,212,42,90,15,hWnd,20,hInstance,0     
                mov     E024,eax 
                call    SendMessageA,E024,0030h,hFont3,0
                mov     eax,mst.dwAvailPhys
                call    _wsprintfA,offset NumBuffer,offset Format1,eax
                add     esp,0ch 
                call    CreateWindowExA,0,offset EditClass,offset NumBuffer,050000806h,304,42,60,15,hWnd,21,hInstance,0     
                mov     E025,eax 
                call    SendMessageA,E025,0030h,hFont3,0   
               
                ;                 ## RIGHT TOP SQUARE BOX

                call    CreateWindowExA,0,offset ButtonClass,0,50000007h,388,0,150,175,hWnd,30,hInstance,0   

                ;       E3        ## ports detected

                call    CreateWindowExA,0,offset EditClass,offset PortsDet,50000844h,395,11,140,15,hWnd,45,hInstance,0
                mov     E030,eax 
                call    SendMessageA,E030,0030h,hFont4,0 

                ;       E3a-E7a   ## COM-LPTLabels

                call    CreateWindowExA,0,offset EditClass,offset COMLabels,50000844h,393,58,140,25,hWnd,45,hInstance,0
                mov     E035,eax 
                call    SendMessageA,E035,0030h,hFont3,0
                call    CreateWindowExA,0,offset EditClass,offset LPTLabels,50000844h,393,115,140,25,hWnd,80,hInstance,0
                mov     E075,eax 
                call    SendMessageA,E075,0030h,hFont3,0 

                ;       E4-5-6-7  ## indirizzi COM-LPT

                call    CreateWindowExA,0,offset EditClass,0,50000844h,396,68,30,15,hWnd,50,hInstance,0
                mov     E040,eax
                call    SendMessageA,E040,0030h,hFont3,0
                call    CreateWindowExA,0,offset EditClass,0,50000844h,432,68,30,15,hWnd,60,hInstance,0
                mov     E050,eax 
                call    SendMessageA,E050,0030h,hFont3,0
                call    CreateWindowExA,0,offset EditClass,0,50000844h,468,68,30,15,hWnd,70,hInstance,0
                mov     E060,eax 
                call    SendMessageA,E060,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,0,50000844h,504,68,30,15,hWnd,80,hInstance,0
                mov     E070,eax 
                call    SendMessageA,E070,0030h,hFont3,0
                call    CreateWindowExA,0,offset EditClass,0,50000844h,396,125,30,15,hWnd,90,hInstance,0
                mov     E071,eax 
                call    SendMessageA,E071,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,0,50000844h,432,125,30,15,hWnd,100,hInstance,0
                mov     E072,eax 
                call    SendMessageA,E072,0030h,hFont3,0  
                call    CreateWindowExA,0,offset EditClass,0,50000844h,468,125,30,15,hWnd,110,hInstance,0
                mov     E073,eax 
                call    SendMessageA,E073,0030h,hFont3,0 
                call    CreateWindowExA,0,offset EditClass,0,50000844h,504,125,30,15,hWnd,120,hInstance,0
                mov     E074,eax
                call    SendMessageA,E074,0030h,hFont3,0
                                         
                ;       E8  ## select a port

                call    CreateWindowExA,0,offset EditClass,offset SelectPort,50000844h,7,82,80,25,hWnd,130,hInstance,0
                mov     E080,eax 
                call    SendMessageA,E080,0030h,hFont1,0           

                ;       ## type string to send

                call    CreateWindowExA,0,offset EditClass,offset TypeString,50000844h,7,108,150,15,hWnd,140,hInstance,0
                mov     E090,eax 
                call    SendMessageA,E090,0030h,hFont1,0  

                ;       (150) ## EditBox to type the string to send

                call    CreateWindowExA,0,offset EditClass,0,58A00004h,5,123,377,52,hWnd,150,hInstance,0
                mov     E100,eax 
                call    SendMessageA,E100,0030h,hFont3,0 

                ;       C1

                call    CreateWindowExA,0,offset ComboClass,0,050200003h,90,78,116,100,hWnd,160,hInstance,0
                mov     C010,eax 
                call    SendMessageA,C010,0030h,hFont1,0 

                ;       B10 (170) ## Open Port 

                call    CreateWindowExA,0,offset ButtonClass,offset OpenPort,50000800h,211,78,85,22,hWnd,170,hInstance,0
                mov     B100,eax 
                call    SendMessageA,B100,0030h,hFont3,0 

                ;       B11 (180) ## Reset Port

                call    CreateWindowExA,0,offset ButtonClass,offset ClosePort,50000800h,297,78,85,22,hWnd,180,hInstance,0
                mov     B110,eax 
                call    SendMessageA,B110,0030h,hFont3,0 

                ;       B12 (190) ## Send String

                call    CreateWindowExA,0,offset ButtonClass,offset SendString,58000800h,5,179,85,22,hWnd,190,hInstance,0
                mov     B120,eax 
                call    SendMessageA,B120,0030h,hFont3,0 

                ;       B13 (200) ## Print String

                call    CreateWindowExA,0,offset ButtonClass,offset PrintString,58000800h,91,179,85,22,hWnd,200,hInstance,0
                mov     B130,eax 
                call    SendMessageA,B130,0030h,hFont3,0 

                ;       B14 (205) ## Clear Buffer

                call    CreateWindowExA,0,offset ButtonClass,offset ClearBuffer,50000800h,177,179,85,22,hWnd,205,hInstance,0
                mov     B140,eax 
                call    SendMessageA,B140,0030h,hFont3,0 

                ;       E11 ## Receive buffer

                call    CreateWindowExA,0,offset EditClass,offset ReceiveBuffer,50000844h,7,210,150,15,hWnd,210,hInstance,0
                mov     E110,eax 
                call    SendMessageA,E110,0030h,hFont1,0           

                ;       ## AutoRecive

                call    CreateWindowExA,0,offset ButtonClass,offset AutoReceive,58000002h,240,209,110,15,hWnd,211,hInstance,0
                mov     B131,eax 
                call    SendMessageA,B131,0030h,hFont3,0          

                ;       E12 ## EditBox Receive buffer

                call    CreateWindowExA,0,offset EditClass,0,58A00004h,5,225,377,52,hWnd,220,hInstance,0
                mov     E120,eax 
                call    SendMessageA,E120,0030h,hFont3,0 

                ;       B17a ## ClearBuffer

                call    CreateWindowExA,0,offset ButtonClass,offset ClearBuffer,50000800h,5,281,85,22,hWnd,250,hInstance,0
                mov     B164,eax 
                call    SendMessageA,B164,0030h,hFont3,0

                ;           ## RIGHT LOW SQUARE BOX

                call    CreateWindowExA,0,offset ButtonClass,0,50000007h,388,171,150,199,hWnd,260,hInstance,0  

                ;       E13 ## Status and Control registers

                call    CreateWindowExA,0,offset EditClass,offset ParStatus,50000844h,394,185,140,15,hWnd,270,hInstance,0
                mov     E130,eax 
                call    SendMessageA,E130,0030h,hFont1,0     
                call    CreateWindowExA,0,offset EditClass,offset SerStatus,50000844h,394,277,140,15,hWnd,280,hInstance,0
                mov     E140,eax 
                call    SendMessageA,E140,0030h,hFont1,0     

                ;       B17 to 25
                
                call    CreateWindowExA,0,offset ButtonClass,offset nERROR,58000002h,398,202,75,12,hWnd,290,hInstance,0
                mov     B170,eax 
                call    SendMessageA,B170,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset SELECT,58000002h,398,217,120,12,hWnd,291,hInstance,0
                mov     B180,eax 
                call    SendMessageA,B180,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset PE,58000002h,398,232,75,12,hWnd,292,hInstance,0
                mov     B190,eax 
                call    SendMessageA,B190,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset nACK,58000002h,398,247,75,12,hWnd,293,hInstance,0
                mov     B200,eax 
                call    SendMessageA,B200,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset BUSY,58000002h,398,262,75,12,hWnd,294,hInstance,0
                mov     B210,eax 
                call    SendMessageA,B210,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset CTSOn,58000002h,398,295,70,12,hWnd,295,hInstance,0
                mov     B220,eax 
                call    SendMessageA,B220,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset DSROn,58000002h,398,310,70,12,hWnd,296,hInstance,0
                mov     B230,eax 
                call    SendMessageA,B230,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset RingOn,58000002h,398,325,70,12,hWnd,297,hInstance,0
                mov     B240,eax 
                call    SendMessageA,B240,0030h,hFont3,0 
                call    CreateWindowExA,0,offset ButtonClass,offset RLSDOn,58000002h,398,340,70,12,hWnd,298,hInstance,0
                mov     B250,eax 
                call    SendMessageA,B250,0030h,hFont3,0 

                ;       E15 ## Event Message

                call    CreateWindowExA,0,offset EditClass,offset EventMsg,50000844h,7,308,150,15,hWnd,300,hInstance,0
                mov     E150,eax 
                call    SendMessageA,E150,0030h,hFont1,0        

                ;       E16 ## EditBox Event

                call    CreateWindowExA,0,offset EditClass,0,50A00004h,5,325,285,44,hWnd,310,hInstance,0
                mov     E160,eax 
                call    SendMessageA,E160,0030h,hFont3,0 
                call    VirtualAlloc,0,32768,1000h,4
                mov     E16BuffAddr,eax

                ;       B26 ## Clear Event
               
                call    CreateWindowExA,0,offset ButtonClass,offset ClearEventLog,50000800h,307,325,75,22,hWnd,320,hInstance,0
                mov     B260,eax 
                call    SendMessageA,B260,0030h,hFont3,0

                ret

GetPortStatus:  ;       Address reading ...

                ;       40:00       COM1 address
                ;       40:02       COM2
                ;       ...
                ;       40:0E       LPT4     

                xor     eax,eax
                xor     edx,edx
                xor     esi,esi
                mov     bx,40h
                mov     gs,bx
                mov     si,00h
                mov     edx,offset Addr1
                mov     edi,offset E040
                mov     ecx,8
ScanAddress:    mov     ax,word ptr gs:[si]
                mov     [edx],ax                  
                cmp     ax,0
                je      JumpIt
                push    ecx
                push    edx   
                call    _wsprintfA,offset NumBuffer,offset Format2,eax
                add     esp,0Ch
                pop     edx
                pop     ecx
                mov     eax,[edi] 
                push    edx
                push    ecx
                push    gs
                call    SendMessageA,eax,000Ch,0,offset NumBuffer 
                pop     gs 
                pop     ecx      
                pop     edx  
JumpIt:         add     edx,2
                add     edi,4
                add     esi,2
                xor     eax,eax
                loop    ScanAddress   

;               scanning serial ports ....

                mov     edi,offset Com1St
                mov     bl,49                           ; offset 0,1,2,3
                mov     ecx,4
SerialCycle:    mov     byte ptr szCom[3],bl            ; parte da COM1    
                push    ebx                 
                push    ecx   
                call    CreateFileA,offset szCOM,0C0000000h,0,0,3,40000080h,0
                mov     FileHndle,eax
                call    GetLastError
                pop     ecx
                pop     ebx
                cmp     eax,5
                jne     SC2
                mov     byte ptr [edi],1                        ; access denied  (state = 1)
                jmp     @closing
SC2:            cmp     eax,2
                jne     @theloop
                mov     byte ptr [edi],2                        ; file not found (state = 2)
                jmp     @closing                      
@theloop:       push    ecx
                call    SendMessageA,C010,0143h,0,offset szCOM
                pop     ecx
@closing:       inc     edi
                inc     bl
                push    ecx
                call    CloseHandle,FileHndle
                call    SetLastError,0h
                pop     ecx
                loop    SerialCycle   

;               scanning parallel ports ....

                mov     edi,offset Lpt1St
                mov     bl,49                                   ; offset 0,1,2,3
                mov     ecx,4
ParallelCycle:  mov     byte ptr szLPT[3],bl                    ; parte da LPT1    
                push    ebx                 
                push    ecx   
                call    CreateFileA,offset szLPT,0C0000000h,0,0,3,40000080h,0
                mov     FileHndle,eax
                call    GetLastError
                pop     ecx
                pop     ebx
                cmp     eax,5
                jne     SC2b
                mov     byte ptr [edi],1                        ; access denied  (state = 1)
                jmp     @closing2
SC2b:           cmp     eax,2
                jne     @theloop2
                mov     byte ptr [edi],2                        ; file not found (state = 2)
                jmp     @closing2
@theloop2:      push    ecx
                call    SendMessageA,C010,0143h,0,offset szLPT
                pop     ecx
@closing2:      inc     edi
                inc     bl
                push    ecx
                call    CloseHandle,FileHndle
                call    SetLastError,0h
                pop     ecx
                loop    ParallelCycle                   
                call    SendMessageA,C010,014Eh,0,0                     ; select item 0
                call    GetWindowTextA,C010,offset SelectedPort,5       ; slected port is the now selected !
                ret


;   Standard parallel port I/O interface
;   Reg      i/o     DB25    Centronics
;   bit              pin     name
;--------------------------------------------
;   D0       o/p      2      D0    LSB   \
;   D1       o/p      3      D1     .     |
;   D2       o/p      4      D2     .     |   can act as inputs
;   D3       o/p      5      D3     .      >  as well as outputs 
;   D4       o/p      6      D4     .     |   on BIDIRECTIONAL
;   D5       o/p      7      D5     .     |   parallel ports.
;   D6       o/p      8      D6     .     |
;   D7       o/p      9      D7    MSB   /

;   03BDh Status

;   S0,S1,S2                [not used]       
;   S3+      i/p     15      -Error         
;   S4+      i/p     13      Select          
;   S5+      i/p     12      PaperEnd       
;   S6+      i/p     10      -Ack             [pin 10 can also be used to generate IRQs]
;   S7-      i/p     11      Busy

;   03BEh Control  

;   C0-      o/p      1      -Strobe          
;   C1-      o/p     14      -AutoFd        
;   C2+      o/p     16      -Init          
;   C3-      o/p     17      -SelectIn      
;   C4      software use     [set to 1 to enable interrupts on ACK=0]
;   C5      software use     [not used / sets data direction on PS/2-style ports: 1=input, 0=output]
;   C6,C7                    [not used]

;   ParallelStatus/SerialStatus routines ... read status registers

ParallelStatus: mov     dx,Address
                inc     dx                              ; STATUS ! offset +1 (status)
                mov     ecx,5
                mov     ebx,offset B170
                mov     si,3
Input:          in      al,dx
                push    ecx
                push    edx
                mov     cx,si
                shr     al,cl                           ; shift to have bite 3 to 7 ready
                and     al,1h
                cmp     si,3                            ; bit 3 = -Error, chekbox activ if state is 0 !
                je      Negate
                cmp     si,6
                je      Negate                          ; bit 6 = -Ack,   chekbox activ if state is 0 !
                cmp     al,1h
                jne     Next
                jmp     CheckIt
Negate:         cmp     al,0h
                jne     Next 
CheckIt:        mov     eax,[ebx]
                call    SendMessageA,eax,0F1h,1,0
Next:           add     ebx,4
                pop     edx
                pop     ecx
                inc     si
                loop    Input         
                ret

SerialStatus:   mov     dx,Address
                add     dx,6                            ; jump to modem status register !
                in      al,dx
                mov     bl,al
                shr     bl,4
                mov     ecx,4
                mov     edx,offset B220
ScanningSMR:    mov     eax,[edx]                
                and     bl,00000001b
                cmp     bl,1
                jne     NextCheck
                push    ecx ebx edx
                call    SendMessageA,eax,0F1h,1,0
                pop     edx ebx ecx
NextCheck:      add     edx,4
                shr     bl,1
                loop    ScanningSMR      
                ret
                
;               SPPSend Centronics/Compatibility Mode Driver, by Angelo

;               Operation done by the driver: 
;
;                       1. write data to the register
;                       2. Read the status of BUSY
;                       3. When not busy write to control reg. to assert CTSOn line
;                       4. Write to control reg. to deassert nSTROBE line      
;                       
;                       IN : EAX -> character count
;                            ESI -> offset String to send
;                             DX -> address of port
 
SPPSend:        mov     ecx,eax
SPPDataOut:     mov     al,[esi]
                out     dx,al           ; data OUT
                inc     dx              ; salto a Status
SPPChekBusy:    in      al,dx
                shr     al,7
                cmp     al,1            ; controllo il byte BUSY
                je      SPPChekBusy
                inc     dx              ; salto a Control
                in      al,dx
                and     al,11110000b    ; nSTROBE low 
                out     dx,al           
                push    eax
                push    edx
                call    Sleep,1         ; pause for fast processor
                pop     edx
                pop     eax
                in      al,dx
                or      al,00000001b    ; nSTROBE high         
                out     dx,al           
                dec     dx
                dec     dx
                inc     esi
                loop    SPPDataOut     
                ret

;               Reset routine, reset the parallel port in SPP 

Reset:          mov     dx,Address
                inc     dx
                inc     dx
                in      al,dx
                mov     al,00000000b
                add     al,00000001b            ; Step is mandatory: Select, Reset and AutoFeed to printer
                out     dx,al       
                ret    

;               CleanBuffer             Buffer offset in ebx !
        
CleanBuffer:    mov     ecx,250
Clean:          mov     dword ptr [ebx],0
                inc     ebx
                loop    Clean
                ret

;               Serial Settings

SetSettings:    mov     dcb.BaudRate,9600    
                mov     dcb.ByteSize,8
                mov     dcb.Parity,0                                            ; // 0-4=no,odd,even,mark,space 
                mov     dcb.StopBits,1                                          ; // 0,1,2 = 1, 1.5, 2 
                call    SetCommState,FileHndle,offset dcb  
                ret

;               disable all state buttons

DisableStButt:  mov     esi,offset B170                                         ; disabling all the state buttons ...
                mov     ecx,9
Disabling:      mov     eax,[esi] 
                push    ecx
                call    SendMessageA,eax,0F1h,0,0  
                mov     eax,[esi]  
                call    EnableWindow,eax,0 
                add     esi,4
                pop     ecx
                loop    Disabling 
                call    EnableWindow,B120,0                                     ; disable send string button 
                ret

                ;       ModemListener, routine for autoreceive

ModemListener   PROC    hWnd: DWORD
                
InitialStep:    call    SetCommMask,FileHndle,1h                                ; must monitor EV_RXCHAR
                call    WaitCommEvent,FileHndle,offset PortEvent,0              ; no overlapped
                cmp     PortEvent,1h
                jne     @r 
WaitChar:       call    ClearCommError,FileHndle,offset ErrorFlags,offset commState
                mov     eax,commState.cbInQue
                call    ReadFile,FileHndle,Point,eax,offset Read,offset ovl     ; legge il byte se e' nel buffer
                mov     eax,Read
                add     Point,eax                                               ; incrementa pos. buffer
                call    SetWindowTextA,E120,offset RecBuffer                    ; scrivi nell'edit box
                cmp     Read,0
                jne     WaitChar   
                call    SerialStatus         
@r:             loop    InitialStep

                ret

ModemListener   ENDP

;               SubRoutine EVENT OUT - Message out

EventOut:       push    eax ebx ecx edx esi edi
                xor     ecx,ecx
                mov     cl,Event                                ; n. messaggio = contatore
                mov     esi,offset Event00                      ; riga di partenza
SearchMessage:  push    ecx
                mov     ecx,200
SearchLF:       mov     al,[esi]
                cmp     al,0                                    ; cerca 0 (fine linea)
                je      StepOver
                inc     esi
                loop    SearchLF
StepOver:       pop     ecx
                inc     esi                                     ; punta al primo carattere della riga dopo
                loop    SearchMessage 
                call    GetWindowTextLengthA,E160
                mov     edi,E16BuffAddr
                add     edi,eax
                mov     ecx,50
                cld
                rep     movsb
                inc     Line
                call    SetWindowTextA,E160,E16BuffAddr 
                call    SendMessageA,E160,0B6h,0,Line           
                pop     edi esi edx ecx ebx eax
                ret
                
end             Start