.const

IFNDEF EXCEPTION_INVALID_DISPOSITION
	EXCEPTION_INVALID_DISPOSITION		equ STATUS_INVALID_DISPOSITION
ENDIF
IFNDEF EXCEPTION_NONCONTINUABLE_EXCEPTION
	EXCEPTION_NONCONTINUABLE_EXCEPTION	equ STATUS_NONCONTINUABLE_EXCEPTION
ENDIF
IFNDEF EXCEPTION_STACK_OVERFLOW
	EXCEPTION_STACK_OVERFLOW		equ STATUS_STACK_OVERFLOW
ENDIF

Entro_ExceptionEmail				EQU			"BugReport@asmz.com"

IFNDEF DEBUG
	DEBUG				EQU				FALSE
ENDIF
IF DEBUG
.data
	szEntro_ExceptionDebugFormat		db		"%s (%d) : %s",13,10,0
.data?
	szEntro_ExceptionDebugLine		db		1024		dup(?)
.code
ENDIF

writeconp	MACRO	lpsz
	LOCAL @@numwrit
	.DATA?
		 @@numwrit		DWORD		?
	.CODE
	INVOKE GetStdHandle, STD_OUTPUT_HANDLE
	push eax
	INVOKE lstrlen, lpsz
	pop ebx
	INVOKE WriteConsole, ebx, lpsz , eax, ADDR @@numwrit, NULL
ENDM

Entro_PutExceptionText		MACRO	szText
	local @szText
	.data	
		@szText db szText,0
	.code
		mov eax, offset @szText
ENDM

Entro_ExceptionLine		MACRO
	mov Entro_ExceptionCurrentLine, @Line + 1
ENDM	

Entro_ExceptionFile		MACRO	nFile
	local	@szFile
	.data
		@szFile		db		"&nFile",0
	.code
	invoke lstrcpy, addr Entro_ExceptionCurrentFile, addr @szFile
ENDM
	
Entro_ExceptionEntryPoint	MACRO	szText
	local	@szInfo
	.data
		@szInfo		db		szText,0
	.code
	pusha
	mov Entro_ExceptionCurrentMainLine, @Line + 1
	Entro_ExceptionFile	%@FileCur
	invoke lstrcpy, addr Entro_ExceptionCurrentInfo, addr @szInfo
IF DEBUG
	invoke wsprintf, addr szEntro_ExceptionDebugLine, addr szEntro_ExceptionDebugFormat, addr Entro_ExceptionCurrentFile, Entro_ExceptionCurrentMainLine, addr Entro_ExceptionCurrentInfo
	writeconp addr szEntro_ExceptionDebugLine
ENDIF
	popa	
ENDM

Entro_PutExceptionHandler	MACRO	szExceptTitle:REQ, lpCleanUpProc		; MUST BE IN " .CODE "

.data
	szEntro_ExceptionBadTitle		db			szExceptTitle
									db			" Extreme Fatal Error",0
	szEntro_ExceptionBadContent		db			"2nd Level Exception",13,10,13,10
									db			"hmmm, this sucks",13,10
									db			"This really should not ever have happened",13,10,13,10
									db			"Please send a bug report to:",13,10
									db			"   ",Entro_ExceptionEmail,13,10,13,10
									db			"Crashed on",13,10
									db			"       LINE : %d",13,10,13,10
									db			"Remember to specify program name, and if",13,10
									db			"possible, exactly how you managed to do this",13,10,13,10
									db			"This application will now close.",13,10
									db			"Thank you, and sorry.",0
.data?
	Entro_ExceptionCurrentLine		dd			?
	Entro_ExceptionCurrentMainLine		dd			?
	Entro_ExceptionCurrentFile		db	1024	dup(?)									
	Entro_ExceptionCurrentInfo		db	1024	dup(?)									
	szEntro_ExceptionBadContent2	db	1024	dup(?)
	
.code
	Entro_ExceptionSecond	PROC	lpExceptionPointers:DWORD
		invoke SetUnhandledExceptionFilter, addr Entro_ExceptionSecond
		invoke wsprintf, addr szEntro_ExceptionBadContent2, addr szEntro_ExceptionBadContent, Entro_ExceptionCurrentLine
		invoke MessageBox, NULL, addr szEntro_ExceptionBadContent2, addr szEntro_ExceptionBadTitle, MB_OK or MB_ICONERROR
		invoke ExitProcess, -1
		ret
	Entro_ExceptionSecond	ENDP

.data
	szEntro_ExceptionTitle		db			szExceptTitle
								db			" Fatal Error",0
	szEntro_ExceptionContent	db			"1st Level Exception",13,10,13,10
								db			"Damn! What exactly did you do to my poor program ?",13,10
								db			"Just Kidding :)",13,10
								db			"Anyway, this is the problem in brief :",13,10,13,10
								db			"Code : %Xh",13,10
								db			"Flags : %Xh",13,10
								db			"Address : %Xh",13,10
								db			13,10
								db			"Would you like to generate a detailed bug report (.txt)?"
								db			0
	szEntro_ExceptionCleanup	db			"This program has caused an exception.",13,10,13,10
								db			"Would you like the application to attempt",13,10
								db			"to save the work you were busy with ?",13,10,13,10
								db			"The details of the problem will be specified",13,10
								db			"directly after this message, or the cleanup",13,10
								db			"if you choose to attempt it.",0
	szEntro_ExceptionCleanup2	db			"Oh dear",13,10
								db			"It would seem that the cleanup itself died.",13,10,13,10
								db			"Please submit a bug report, as this is very serious!",0
	lpEntro_ExceptionCleanup	dd			lpCleanUpProc
	szEntro_ExceptionDetail		db			"This is an automatically generated Bug Report for ",34,szExceptTitle,34,13,10,13,10
								db			"Send to : ",Entro_ExceptionEmail,13,10
								db			"Subject : ",szExceptTitle,13,10,13,10
								db			"Email Content :",13,10,13,10
								db			"---8<---------------------------8<----------",13,10
								db			"Program Name : ",szExceptTitle,13,10
								db			"Date : %s",13,10
								db			"Executable Path : %s",13,10,13,10
								db			"OS Information : [%Xh].[%Xh].[%Xh].[%Xh] ( %s )",13,10,13,10
								db			"Code : %Xh   ( %s )",13,10
								db			"Flags : %Xh",13,10
								db			"Address : %Xh",0
	szEntro_ExceptionParam		db			13,10,"Parameters :"
	szEntro_ExceptionParamF		db			" [%X]",0
	szEntro_ExceptionLastKnown	db			13,10,13,10,"Last known entry point :",13,10
								db			9,"File : %s",13,10
								db			9,"Line : %d",13,10
								db			9,"Info : %s",0
	szEntro_ExceptionRegisters	db			13,10,13,10
								db			"DR %08X %08X %08X %08X %08X %08X",13,10,13,10
								db			"CS  %08X",9,"EIP %08X",13,10
								db			"DS  %08X",9,"ES  %08X",9,"FS  %08X",9,"GS  %08X",13,10
								db			"SS  %08X",9,"ESP %08X",13,10,0
	szEntro_ExceptionRegisters2	db			"%sEDI %08X",9,"ESI %08X",9,"EBP %08X",13,10
								db			"EAX %08X",9,"EBX %08X",9,"ECX %08X",9,"EDX %08X",13,10,13,10
								db			"flags %08X",13,10,13,10,0
	szEntro_ExceptionDetailEnd	db			13,10,"---8<---------------------------8<----------",13,10,13,10
								db			"Thank you for taking the time",13,10
								db			"  Clive Crous"
								db			0
	szEntro_ExceptionFile		db			"./BUG REPORT for ",szExceptTitle," - %s.txt",0
	szEntro_ExceptionDateFormat	db			"yyyyMMdd",0
	szEntro_ExceptionDateForm2	db			"dd'/'MM'/'yyyy",0
	szEntro_ExceptionContinue	db			"This Program has caused an Exception,",13,10
								db			"but it is possible to try and recover",13,10
								db			"and continue execution.",13,10,13,10
								db			"Would you like to attempt recovery?",0
	szEntro_ExceptionHex		db			"0123456789ABCDEF",0								
	
.data?
	ddEntro_ExceptionCleanup	dd					?
	szEntro_ExceptionMessage	db		1024		dup(?)
	szEntro_ExceptionTemp		db		1024		dup(?)
	szEntro_ExceptionFile2		db		MAX_PATH	dup(?)
	
ENDM

Entro_InstallExceptionHandler	MACRO
	.IF DEBUG
		invoke AllocConsole
	.ENDIF
	invoke SetUnhandledExceptionFilter, addr Entro_ExceptionMain
ENDM

