;=============================================================================================
; "Intelligent" Error Handling  (c) Clive Crous
; by Clive Crous [ Entro-P ]   	[ CliveCrous@asmz.com ]
;---------------------------------------------------------------------------------------------
; All code in this example, this includes source and executables, are copywrited to
; Clive Crous as of March 2001.
; You may freely use / modify and redistribute all sources/executables as long as
; the following conditions are met :
; 1> you application _must_be released as freeware or under the GNU public licence
; 2> you must credit me somewhere in your program or docs if these sources are not
;    redistributed whole with your application / software.
;=============================================================================================
.386
.model flat, stdcall
option casemap :none
include c:\masm32\include\windows.inc
_incboth	MACRO	incl
	include incl.inc
	includelib incl.lib
ENDM
_incboth kernel32
_incboth user32
_incboth shell32
;=============================================================================================
.const
	DEBUG			EQU				TRUE		; TRUE --> Console ; FALSE --> No Console
include except.inc
;=============================================================================================
_question	MACRO	szq:VARARG
	local	@szq
	.data
		@szq		db			szq,0
	.code
		invoke MessageBox, NULL, addr @szq, addr szApplicationName, MB_YESNO or MB_ICONQUESTION
ENDM
;=============================================================================================
.const
	cszApplicationName		EQU			"Intelligent Error Handling"
;=============================================================================================
.data
	szApplicationName		db			cszApplicationName,0
;=============================================================================================
.code
;=============================================================================================
; if NULL is givven as the second parameter, the EH will never ask if you want to perform 
; a cleanup.
	Entro_PutExceptionHandler	cszApplicationName, offset ExceptionCleanupProcedure
	;Entro_PutExceptionHandler	cszApplicationName, NULL
;=============================================================================================
include excepth.inc
;=============================================================================================
ExceptionCleanupProcedure	PROC
	Entro_ExceptionEntryPoint "Cleanup Procedure"
	_question "Currently in Cleanup Procedure.",13,10,"Cause Another Exception from here ?"
	.IF eax == IDYES
		Entro_ExceptionEntryPoint "Gonna Cause Exception (Cleanup)"
		xor ebx, ebx
		div ebx
	.ENDIF
	ret	
ExceptionCleanupProcedure	ENDP
;=============================================================================================
start:
	Entro_InstallExceptionHandler
	Entro_ExceptionEntryPoint "Application Start"
	_question "Cause Exception?"
	.IF eax == IDYES
		Entro_ExceptionEntryPoint "Gonna Cause Exception (Main)"
		int 03h
	.ENDIF
	ret
end start