.386
.model          flat,stdcall
option          casemap:none

;include         \masm32\include\windows.inc
include         \masm32\include\kernel32.inc
include         \masm32\include\masm32.inc

includelib      \masm32\lib\kernel32.lib
includelib      \masm32\lib\masm32.lib


InString2 PROTO :DWORD, :DWORD, :DWORD


inv     equ     invoke

;  --------------------------------------------------------------------------------
;  initialized data
;  --------------------------------------------------------------------------------

.DATA

szOK                db  "OK",13,10, 0

Msg1                db  "Main String:", 0
Msg2                db  "Sub String :", 0

CrLf                db  13, 10, 0


;  --------------------------------------------------------------------------------
;  uninitialized data
;  --------------------------------------------------------------------------------

.DATA?

Buffer          db 300 dup (?)
MainStr         db 256 dup (?)
sSubStr         db 256 dup (?)


;  --------------------------------------------------------------------------------
;  code section
;  --------------------------------------------------------------------------------

.CODE

start:


@@Rep:

    ; inv locate, 10, 10

    inv RtlZeroMemory, Addr MainStr, 512

    inv StdOut, Addr Msg1
    inv StdIn, Addr MainStr, SizeOf MainStr
    inv StdOut, Addr Msg2
    inv StdIn, Addr sSubStr, SizeOf sSubStr

    inv lnstr, addr MainStr    ; remove CrLf
    mov esi, offset MainStr
    add esi, eax
    sub esi, 2
    mov word ptr [esi], 0

    inv lnstr, addr sSubStr    ; remove CrLf
    mov esi, offset sSubStr
    add esi, eax
    sub esi, 2
    mov word ptr [esi], 0

    inv InString2, 1, addr MainStr, addr sSubStr

    inv dwtoa, eax, addr Buffer
    inv lstrcat, addr Buffer, addr CrLf
    inv lstrcat, addr Buffer, addr CrLf
    inv StdOut, Addr Buffer

    jmp @@Rep

    ret




InString2 proc StartPos:DWORD, lpszString:DWORD, lpszSubStr:DWORD

    LOCAL lnStrng :DWORD
    LOCAL lnSubSt :DWORD
    LOCAL reg1    :DWORD
    LOCAL reg2    :DWORD
    LOCAL Byte1   :BYTE

    push esi
    push edi
    push ebx

    .if StartPos < 1
      mov eax, -2               ; set eax -2
      jmp @@Get_Outa_Here       ; exit if less than 1
    .endif

    dec StartPos                ; correct to 0 based index

    invoke lnstr, lpszString    ; main string length
    mov lnStrng, eax
    push eax

    invoke lnstr, lpszSubStr    ; sub string length
    mov lnSubSt, eax

    pop eax
    sub eax, lnSubSt            ; subtract substr len from main string

    ; The following order is important.

    .if eax >= lnStrng          ; the substring is greater than the main string
      mov eax, -1
      jmp @@Get_Outa_Here
    .elseif StartPos == eax     ; startpos at the last position accepted
      jmp Same_Size
    .elseif StartPos > eax      ; startpos greater than the last position accepted
      mov eax, -2
      jmp @@Get_Outa_Here
    .elseif eax == 0            ; the two strings have the same size
      jmp Same_Size
    .endif

    mov esi, lpszSubStr         ; get 1st byte in substring
    mov bl, [esi]

  ; -------------------------------------------------------
  ; set maximum count as main string length minus substring
  ; -------------------------------------------------------

    mov ecx, lpszString
    add ecx, lnStrng
    sub ecx, lnSubSt
    inc ecx

    mov esi, lpszString         ; main string address
    add esi, StartPos           ; add starting position to esi

    cld                         ; read forward

    @@L1s:                      ; 8 cycles on no 1st char match
      mov al, [esi]             ; 1
      inc esi                   ; 1
      cmp al, bl                ; 1     find 1st substring byte
      je @F                     ; 1 - 3 compare subsequent bytes to
    @@L1r:
      cmp esi, ecx              ; 1
      jne @@L1s                 ; 3 - 1

      mov eax, 0                ; return zero and exit if
      jmp @@Get_Outa_Here         ; match not found in string

  ; ------------------------------------------------
  ; do the comparison, main string is already in esi
  ; ------------------------------------------------

    @@:

    mov reg1, ecx               ; 1
    mov reg2, esi               ; 1
    mov Byte1, bl               ; 1

    mov ecx, lnSubSt            ; sub string length
    .if ecx == 1
        inc esi
        jmp @@GetRetVal
    .endif
    inc ecx                     ; compare correct number of bytes
    dec esi                     ; back one to compare correct bytes
    mov edi, lpszSubStr

    repe cmpsb                  ; 9 if strings match, ecx will be 0

    cmp ecx, 0                  ; did the two strings match ??
    jne @F

    ; jnz @F

    @@GetRetVal:
      mov eax, lpszString
      sub esi, eax              ; subtract it from esi current value
      sub esi, lnSubSt          ; subtract the search string length

      mov eax, esi              ; put count in eax
      add eax, StartPos         ; add starting pos to get correct count
      jmp @@Get_Outa_Here
    @@:

    mov ecx, reg1               ; 1
    mov esi, reg2               ; 1
    mov bl, Byte1               ; 1
    jmp @@L1r                   ; try again for match



    Same_Size:

    inv StdOut, Addr szOK

    mov esi, lpszString         ; main string address
    add esi, StartPos           ; add starting position to esi
    mov edi, lpszSubStr         ; sub string address
    mov ecx, lnSubSt            ; sub string length

    cld
    repe cmpsb

    .if ZERO?                   ; the two strings match
        mov eax, StartPos       ; get the return value
        inc eax
    .else
        mov eax, 0
    .endif



    @@Get_Outa_Here:

    pop ebx
    pop edi
    pop esi

    ret
InString2 endp


END         start
