; #########################################################################

      .386
      .model flat, stdcall
      option casemap :none   ; case sensitive

; #########################################################################

      include \masm32\include\windows.inc
      include \masm32\include\user32.inc
      include \masm32\include\kernel32.inc
      include \MASM32\INCLUDE\rasapi32.inc


     ;  include \masm32\include\dmacros.inc
      include \masm32\include\masm32.inc

includelib\masm32\lib\masm32.lib

      includelib \MASM32\lib\rasapi32.lib
      includelib \masm32\lib\user32.lib
      includelib \masm32\lib\kernel32.lib

; #########################################################################

      ;=============
      ; Local macros
      ;=============

      szText MACRO Name, Text:VARARG
        LOCAL lbl
          jmp lbl
            Name db Text,0
          lbl:
        ENDM

      m2m MACRO M1, M2
        push M2
        pop  M1
      ENDM

      return MACRO arg
        mov eax, arg
        ret
      ENDM

        ;=================
        ; Local prototypes
        ;=================
        WinMain PROTO :DWORD,:DWORD,:DWORD,:DWORD
        WndProc PROTO :DWORD,:DWORD,:DWORD,:DWORD
        TopXY PROTO   :DWORD,:DWORD
        
        ListBoxProc PROTO :DWORD,:DWORD,:DWORD,:DWORD


        ListBox PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
        PushButton PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
        Static PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD

        GetConnections PROTO :BYTE



   .const
ID_LIST1 equ 500
ID_LIST2 equ 501

ID_BTN1 equ 600
ID_BTN2 equ  ID_BTN1 +1

  
   .data
        szDisplayName db "Dial - up connections example - by eko",0
        ButtonAbout db "About",0
        
        ButtonActive db "Get Active Connections",0;  -23
        ButtonAll  db "Get All",0 ;
        BooleanForButton db 23
        About db "Dial - up connections example",13,13,10,\
                 "translate from vb to masm(add few changes) by",13,"eko - skater_surfer@hotmail.com",13,13,10,\
                 "the vb source was written by Matt Hart - vbhelp@matthart.com",0
                 

        
        
  .data? 
        
CommandLine   dd ?
        hWnd          dd ?
        hInstance     dd ?
        hList1        dd ?
        hList2        dd ?
   

          
R  RASENTRYNAME 255 dup (<?> )
Rd  RASDEVINFO 255 dup (<?>)
Ra RASCONN 255 dup (<?>)
       
.code
  

start:
        invoke GetModuleHandle, NULL
        mov hInstance, eax

        invoke GetCommandLine
        mov CommandLine, eax

        invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
        invoke ExitProcess,eax

; #########################################################################

WinMain proc hInst     :DWORD,
             hPrevInst :DWORD,
             CmdLine   :DWORD,
             CmdShow   :DWORD

        ;====================
        ; Put LOCALs on stack
        ;====================

        LOCAL wc   :WNDCLASSEX
        LOCAL msg  :MSG

        LOCAL Wwd  :DWORD
        LOCAL Wht  :DWORD
        LOCAL Wtx  :DWORD
        LOCAL Wty  :DWORD

        ;==================================================
        ; Fill WNDCLASSEX structure with required variables
        ;==================================================

        mov wc.cbSize,         sizeof WNDCLASSEX
        mov wc.style,          CS_HREDRAW or CS_VREDRAW \
                               or CS_BYTEALIGNWINDOW
        mov wc.lpfnWndProc,    offset WndProc
        mov wc.cbClsExtra,     NULL
        mov wc.cbWndExtra,     NULL
        m2m wc.hInstance,      hInst   ;<< NOTE: macro not mnemonic
        mov wc.hbrBackground,  COLOR_BTNFACE+1
        mov wc.lpszMenuName,   NULL
        mov wc.lpszClassName,  offset szClassName
          invoke LoadIcon,hInst,500    ; icon ID
        mov wc.hIcon,          eax
          invoke LoadCursor,NULL,IDC_ARROW
        mov wc.hCursor,        eax
        mov wc.hIconSm,        0

        invoke RegisterClassEx, ADDR wc

        ;================================
        ; Centre window at following size
        ;================================

        mov Wwd, 470
        mov Wht, 285

        invoke GetSystemMetrics,SM_CXSCREEN
        invoke TopXY,Wwd,eax
        mov Wtx, eax

        invoke GetSystemMetrics,SM_CYSCREEN
        invoke TopXY,Wht,eax
        mov Wty, eax

        szText szClassName,"IntCheck_Class"

        invoke CreateWindowEx,WS_EX_OVERLAPPEDWINDOW,
                              ADDR szClassName,
                              ADDR szDisplayName,
                              WS_OVERLAPPED or WS_SYSMENU,
                              Wtx,Wty,Wwd,Wht,
                              NULL,NULL,
                              hInst,NULL
            mov   hWnd,eax

        invoke LoadMenu,hInst,600  ; menu ID
        invoke SetMenu,hWnd,eax

        invoke ShowWindow,hWnd,SW_SHOWNORMAL
        invoke UpdateWindow,hWnd

      ;===================================
      ; Loop until PostQuitMessage is sent
      ;===================================

    StartLoop:
      invoke GetMessage,ADDR msg,NULL,0,0
      cmp eax, 0
      je ExitLoop
      invoke TranslateMessage, ADDR msg
      invoke DispatchMessage,  ADDR msg
      jmp StartLoop
    ExitLoop:

      return msg.wParam

WinMain endp

; #########################################################################

WndProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    .if uMsg == WM_COMMAND

        .if wParam == ID_BTN1

                 lea ecx,ButtonActive
                 mov bl,byte ptr [BooleanForButton]
                 
add cl,bl

                 invoke SetDlgItemText,hWin,ID_BTN1,ecx; ButtonActive[ebx]

                 

xor bl,23
                 
mov [BooleanForButton],bl

                 invoke GetConnections,bl

        .elseif wParam==ID_BTN2
 invoke MessageBox,hWin,ADDR About,ADDR szDisplayName,MB_OK

        .endif        
   .elseif uMsg == WM_CLOSE
        szText TheText,"are sure you wanna leave?"
        invoke MessageBox,hWin,ADDR TheText,ADDR szDisplayName,MB_YESNO
          .if eax == IDNO
            return 0
          .endif
    .elseif uMsg == WM_DESTROY
        invoke PostQuitMessage,NULL
        return 0    
    .elseif uMsg == WM_CREATE
       



       invoke ListBox,20,20,200,200,hWin,ID_LIST1

       mov hList1, eax

      
       invoke ListBox,240,20,200,150,hWin,ID_LIST2
       mov hList2, eax
      

       invoke PushButton,ADDR ButtonAbout,hWin,240,220,200,25,ID_BTN2


       invoke PushButton,ADDR ButtonActive,hWin,240,182,200,25,ID_BTN1


       PUSH 1 ; just dont push null ;] 
       call GetConnections
      

    .endif

    invoke DefWindowProc,hWin,uMsg,wParam,lParam

    ret

WndProc endp

; ########################################################################

TopXY proc wDim:DWORD, sDim:DWORD

    shr sDim, 1      ; divide screen dimension by 2
    shr wDim, 1      ; divide window dimension by 2
    mov eax, wDim    ; copy window dimension into eax
    sub sDim, eax    ; sub half win dimension from half screen dimension

    return sDim

TopXY endp

; ########################################################################

ListBox proc a:DWORD,b:DWORD,wd:DWORD,ht:DWORD,hParent:DWORD,ID:DWORD

    szText lstBox,"LISTBOX"

    invoke CreateWindowEx,WS_EX_CLIENTEDGE,ADDR lstBox,0,
              WS_VSCROLL or WS_VISIBLE or \
              WS_BORDER or WS_CHILD or \
              LBS_HASSTRINGS or LBS_NOINTEGRALHEIGHT or \
              LBS_DISABLENOSCROLL,
              a,b,wd,ht,hParent,ID,hInstance,NULL

    ret

ListBox endp

PushButton proc lpText:DWORD,hParent:DWORD,
                a:DWORD,b:DWORD,wd:DWORD,ht:DWORD,ID:DWORD

    szText btnClass,"BUTTON"
    
    invoke CreateWindowEx,0,\
            ADDR btnClass,lpText,\
            WS_CHILD or WS_VISIBLE,\
            a,b,wd,ht,hParent,ID,\
            hInstance,NULL

    ret

PushButton endp


GetConnections proc ACTIVE:BYTE

local s:DWORD
local ln:DWORD

invoke SendMessage,hList1,     LB_RESETCONTENT,NULL,NULL
invoke SendMessage,hList2,     LB_RESETCONTENT,NULL,NULL

and ln,0
mov bl,[ACTIVE]
or bl,bl
jz GETTHEACTIVE

mov ebx,SIZEOF RASENTRYNAME + 3


mov R.dwSize, ebx



mov ebx,SIZEOF RASENTRYNAME + 3

shl ebx,8

mov s,ebx


invoke RasEnumEntries,NULL,NULL,ADDR R,addr s  ,addr ln




or eax,eax
jnz NOTWORKING ; (error) eax=603 - buffer too small
mov ecx,ln
dec ecx


@@:

push ecx ; i saves ecx apparently the api call changes it ;[


mov eax,SIZEOF RASENTRYNAME + 3
mul ecx



invoke SendMessage,hList1,LB_ADDSTRING,0,ADDR R[eax].szEntryName
pop ecx

dec ecx

cmp ecx,0
jge @B

jmp GETDEVICES


GETTHEACTIVE:
    
 
    mov ebx,412
    mov Ra.dwSize,ebx ;R(0).dwSize = 412
    shl ebx,8   
    mov s,ebx
    invoke  RasEnumConnections, ADDR Ra, ADDR s, ADDR ln
    or eax,eax
jnz NOTWORKING ; (error) eax=603 - buffer too small
mov ecx,ln
dec ecx


@@:

push ecx


mov eax,412 ; probably SIZEOF RASCONN + ?
mul ecx


invoke SendMessage,hList1,LB_ADDSTRING,0,ADDR Ra[eax].szEntryName
pop ecx
dec ecx

cmp ecx,0
jge @B


GETDEVICES:
mov ebx,SIZEOF RASDEVINFO + 2 
mov Rd.dwSize,ebx
shl ebx,8
mov s,ebx

and ln,0

;and s,0



invoke RasEnumDevices,ADDR Rd[0],addr s,addr ln
or eax ,eax
jnz NOTWORKING

mov ecx,ln
dec ecx


@@:
push ecx
mov eax,SIZEOF RASDEVINFO + 2
mul ecx

invoke SendMessage,hList2,LB_ADDSTRING,0,ADDR Rd[eax].szDeviceName
pop ecx
dec ecx

cmp ecx,0
jge @B





  xor eax,eax
  ret
    

 NOTWORKING:
  szText msgE,"Error"
  szText MsgE,"Error"
          invoke MessageBox,hWnd,ADDR msgE,ADDR MsgE,MB_OK
   xor eax,eax
  ret
GetConnections endp


end start




