; #########################################################################

      ; MAC_NIC v1.0.0.0 by P1, Pone@ecad.org
      ; A MASM32 program to dump the Media Access Control (MAC) address
      ; of any Network Interface Card in the current system.

; #########################################################################

      .386
      .model flat, stdcall
      option casemap :none   ; case sensitive

; #########################################################################
        
      include \masm32\include\windows.inc
      include \masm32\include\user32.inc
      include \masm32\include\kernel32.inc
      include \masm32\include\netapi32.inc

      includelib \masm32\lib\user32.lib
      includelib \masm32\lib\kernel32.lib
      includelib \masm32\lib\netapi32.lib

; #########################################################################

    .data
    
        szMsgTitle      db "MAC# for this NIC", 0
        szCall_Name     db "*               ", 0  
        szMsgNONE       db "No Adapter Present!", 0
        szHexString     db 0Dh dup (0)

; #########################################################################

    .data?
    
        ; FYI, These structures need to stay evenly aligned.
        ASTAT STRUCT
            adapt ADAPTER_STATUS <>
            NameBuff  NAME_BUFFER 1Eh dup ({})
        ASTAT ENDS

        l_ASTAT         ASTAT <>
        l_ENUM          LANA_ENUM <>
        l_NCB           NCB <>

        hInstance       dd ?
        NbrOf_Lanas     db ?

; #########################################################################

    .code
start: 
        invoke GetModuleHandle, NULL
        mov hInstance, eax

        ; Do not assume Adapter 0, read it out, or else.
        invoke RtlZeroMemory, OFFSET l_NCB, SIZEOF l_NCB
        mov l_NCB.ncb_command, NCBENUM
        mov l_NCB.ncb_length, SIZEOF l_ENUM
        mov l_NCB.ncb_buffer, OFFSET l_ENUM
        INVOKE Netbios, addr l_NCB
        .if al != NRC_GOODRET
            ; Add Error Handling here.
            jmp l_Exit
        .endif

        ; AKA, Number of Adapters present.
        mov esi, OFFSET l_ENUM.iLength
        mov al, [esi]
        mov NbrOf_Lanas, al

        xor ecx,ecx
        
        test al,al
        jnz Get_Another
        invoke MessageBox, 0h, ADDR szMsgNONE, ADDR szMsgTitle, MB_OK
        jmp l_Exit
        
Get_Another:
        push ecx    

        invoke RtlZeroMemory, OFFSET l_NCB, SIZEOF l_NCB
        mov l_NCB.ncb_command, NCBRESET
        mov esi, OFFSET l_ENUM.lana
        mov al, [esi + ecx]
        mov l_NCB.ncb_lana_num, al
        INVOKE Netbios, addr l_NCB
        .if al != NRC_GOODRET
            ; Add Error Handling here.
            jmp l_Exit
        .endif
        
        mov l_NCB.ncb_command, NCBASTAT
        invoke lstrcpy, addr l_NCB.ncb_callname, addr szCall_Name
        mov l_NCB.ncb_length, SIZEOF l_ASTAT
        mov l_NCB.ncb_buffer, OFFSET l_ASTAT
        INVOKE Netbios, addr l_NCB
        .if al != NRC_GOODRET
            ; Add Error Handling here.
            jmp l_Exit
        .endif	

        ; 6 byte Binary Conversion to ASCII HEX (12 characters)
        mov esi, OFFSET l_ASTAT.adapt.adapter_address
        mov edi, OFFSET szHexString
    
        xor ecx, ecx
        xor ebx, ebx
        mov cl, 0Bh
        mov bl, 05h
        
hexloop:
        mov al, [esi + ebx]
        push eax
        and al, 00001111b

        add al, 90h
        daa
        adc al, 40h
        daa

        mov [edi + ecx], al
        dec ecx

        pop eax
        shr al, 4h
        and al, 00001111b

        add al, 90h
        daa
        adc al, 40h
        daa
    
        mov [edi + ecx], al
    
        dec ebx
        dec ecx
        jns hexloop

        invoke MessageBox, 0, ADDR szHexString, ADDR szMsgTitle, MB_OK
        
        pop ecx ;OFFSET into l_ENUM.lana
        inc ecx
        cmp cl, NbrOf_Lanas
        jne Get_Another
        
l_Exit:
        mov eax, hInstance
        invoke ExitProcess,eax

; #########################################################################
end start







