         title   Rich Text Editor
         comment '======================================================|'
         comment '* AsmEdit v3.2 uses RICHED20.DLL  V3                  *'
         comment '* Copyright (r) Ewayne L. Wagner, All Rights Reserved.*'
         comment '* Unless you can improve on the program and send me   *'
         comment '* the changes. yooper@kalamazoo.net                   *'
         comment '======================================================|'
         .586
         .model  flat, STDCALL
            option   casemap: none   ; Case sensitive
            include  \MASM32V1\include\Windows.inc
            include  \MASM32V1\include\AsmEdit.inc
            include  \MASM32V1\include\user32.inc
            include  \MASM32V1\include\kernel32.inc
            include  \MASM32V1\include\gdi32.inc
            include  \MASM32V1\include\comctl32.inc
            include  \MASM32V1\include\comdlg32.inc
            include  \MASM32V1\include\tapi32.inc
            include  \MASM32V1\include\winmm.inc
            include  \MASM32V1\include\winspool.inc
            include  \MASM32V1\include\shell32.inc
            include  \MASM32V1\include\advapi32.inc
include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\lib\user32.lib
         includelib  \MASM32V1\lib\kernel32.lib
         includelib  \MASM32V1\lib\gdi32.lib
         includelib  \MASM32V1\lib\comctl32.lib
         includelib  \MASM32V1\lib\comdlg32.lib
         includelib  \MASM32V1\lib\tapi32.lib
         includelib  \MASM32V1\lib\winmm.lib
         includelib  \MASM32V1\lib\winspool.lib
         includelib  \MASM32V1\lib\shell32.lib
         includelib  \MASM32V1\lib\advapi32.lib

         .list
      
;=========================================================================
; DATA                                                                   *
;=========================================================================
           .data
;
szNULL       db      0
pTitle       db      'Assembler Editor V3.2 - ',0
szHelp       db      'AsmEdit.HLP',0
HelpKeyS     db      'Setup',0
szDos        db      '\COMMAND.COM',0
szEWREdit    db      'AsmEdit.exe',0

;szRundll32   db      'Rundll32.exe',0
szCallDLLe   db      'EWCallDLL.exe',0
szCallDLLW   db      'EWCallDLLW.exe',0
szBuildE     db      'Build.exe',0
LibNameS     db      'Startup.dll',0
FuncNameS    db      'Initialize',0
LibNameC     db      'Create.dll',0
FuncNameC    db      'Create',0
FuncNameCF   db      'Folder',0
LibNameG     db      'CodeGen.dll',0
FuncNameG    db      'CodeGen',0
FuncNameGC   db      'CloseIt',0
FuncNameD    db      'DelProj',0
LibNameW     db      'WorkWin.dll',0
FuncNameWC   db      'CloseIt',0

szPtr        db      'Pointers\',0
PatnP        db      'Pointers\*.ptr',0
class        db      'AsmEdit V3.2',0
EditPT       db      'EDIT',0
;richedit     db      'RichEdit',0
;RichEdDLL    db      'RICHED32.DLL',0
richedit     db      'RichEdit20A',0
RichEdDLL    db      'RICHED20.DLL',0

LibName      db      'EWCalcTB.dll',0
ProcName     db      'Calc',0
hLib         dd      0

ToolClass    db      'ToolbarWindow32',0
StatClass    db      'msctls_statusbar32',0
combobox     db      'COMBOBOX',0
listbox      db      'LISTBOX',0
buttxt1      db      'Goto',0
buttxt2      db      'Build',0
buttxt3      db      'Projects',0
DlgClass     db      'DIALOGEX',0
FontMS       db      'MS Sans Serif',0  ;'Arial',0
FontCN       db      'Courier New',0
FontFS       db      'Fixedsys',0
FontName     db      64 dup(0)

MsgTitle     db      'Error opening file!',0
szFR         db      'Find And Replace',0
szOpenTitle  db      'Open File',0
szSaveTitle  db      'Save File As',0
szEdit       db      'Edit',0
szView       db      'View',0

szALL        db      'All Files',0,'*.*',0,0

szASM        db      'Asm Files & Inc Files & RC Files',0,'*.ASM;*.INC;*.RC',0,
                     'All Files',0,'*.*',0,0

szTXT        db      'Text Files & RTF Files & Asm Files & Inc Files & RC Files',0,'*.TXT;*.RTF;*.ASM;*.INC;*.RC',0,
                     'All Files',0,'*.*',0,0

szEXE        db      'Exec Files & Link Files & Com Files',0,'*.EXE;*.LNK;*.COM',0,
                     'All Files',0,'*.*',0,0

szUntitled   db      '(Untitled)',0
szAccess     db      'This program is in use.'
             db      0Dh,0Ah
             db      'Would you like to open it as read only ?',0
szError1     db      'The file size has changed.'
             db      0Dh,0Ah
             db      'Do you want to continue?',0
NoHTML       db      'This is not an HTML type file.'
             db      0Dh,0Ah
             db      '   Do you wish to continue?',0
FindEnd      db      'There Are No More Matches.'
             db      0Dh,0Ah
             db      'Would You Like To Restart From The'
TopBot       db      ' Top? '
             db      0
Top          db      ' Top? '
Bot          db      ' Bot? '
;
dmsg         equ     $
dmo          db      2 dup(?)
             db      '-'
dda          db      2 dup(?)
             db      '-'
dyr          db      4 dup(?)
             db      '   ',0
tmsg         equ     $
tmsghour     db      2 dup(?)
             db      ':'
tmsgmin      db      2 dup(?)
             db      ':'
tmsgsec      db      2 dup(?)
             db      ' '
tmsgampm     db      '?' ;'A'/'P'
             db      'M',0
Page1        equ     $ 
             db      'Page '
num          db      2 dup(?),0
Ldata        db      ' Row: '
cnt1         db      5 dup(?)
             db      '  of  '
cnt2         db      5 dup(?)
             db      '         Col: '
cnt3         db      4 dup(?)
             db      '  of  '
cnt4         db      4 dup(?)
             db      0
mmsg         db      ' X: '
mmsgx        db      4 dup(0)
             db      '   Y: '
mmsgy        db      4 dup(0)
             db      0
;
; Static Buffers
;
.data?
PathName     db      256 dup(?)
FileName     db      64  dup(?)
RootDir      db      100 dup(?)
CurDir       db      100 dup(?)
ExtType      db      5   dup(?)
;
WorkBuff     db      256 dup(?)
szBuff       db      256 dup(?)
szFilter     db      128 dup(?)
CustClrs     dd      16  dup(?)
TabStops     dd      32  dup(?)

szFind       db      100 dup(?)
szRep        db      100 dup(?)
Misc         db      40  dup(?)
Fsize        db      12  dup(?)
szFileSize   db      40  dup(?)
;
.data
szSaving     db      'File modified: ',0
szSetup      db      'Missing entries!',0
szSelect     db      'Selected Text!',0
szNoSel      db      'No item was selected.',0
szNoItem     db      "Either the Edit wasn't pressed"
             db      0Dh,0Ah
             db      "or there's no items to update.",0
;
parts        dd      SBPARTS dup(0)

szOpened     db      'File opened size: = ',0
szSaved      db      'File saved size: = ',0
;
; assorted handles
;
hWnd         dd      0
hWndStat     dd      0
hTBBmp       dd      0
hWndTool     dd      0
hREdit       dd      0
lpRichEdit   dd      0
hREditW      dd      0
hREdDll      dd      0
hInst        dd      0
hMenu        dd      0
hSMenu       dd      0
hAccel       dd      0
hFRDlg       dd      0
hEdit        dd      0
hFile        dd      0
hReg         dd      0
hLibA        dd      0
hWorkA       dd      0
dFont        dd      0
hFont        dd      0
mFont        dd      0
pFont        dd      0
tFont        dd      0
hDefHeap     dd      0
hwMem        dd      0
hWordListS   dd      0
hWordListU   dd      0
hHead        dd      0
hBuff        dd      0
hpMem        dd      0
fpMem        dd      0
hsMem        dd      0
fsMem        dd      0
hMnem        dd      0
hAscii       dd      0
hAsciibox    dd      0
lpAsciibox   dd      0
hAsm         dd      0
hABut        dd      0
hGBut        dd      0
hAsmbox      dd      0
hMult        dd      0
hSUDlg       dd      0
hBR          dd      0
hClrDlg      dd      0
hCSyntax     dd      0
hInput       dd      0
hCreate      dd      0
hCodeGen     dd      0
hBuild       dd      0
;
; Misc storage
;
CommandLine  dd      0
MainExit     dd      0
sMemSize     dd      300000  ;65535
bytesread    dd      0
ExitCode     dd      0
MultInst     dd      0
HoldT        dd      0
RTF          dd      0
OA           dd      0
cnt          dd      0
XP           dd      0
YP           dd      0
FRFlags      dd      0
OpnFlag      dd      0
UpdateSel    dd      0 ;1
UpdateAll    dd      1 ;0
dwAttr       dd      0
MenuCnt      dd      0
Prev         dd      0
sw1          dd      0
sw2          dd      0
sw3          dd      0
sw4          dd      0
Len          dd      0
PrtHead      dd      1
PrtColor     dd      0
Sel          dd      0
RTwips1000   REAL10  1.44
w1           dd      0
w2           dd      0
w3           dd      0
w4           dd      0
w5           dd      0
w6           dd      0
w7           dd      0
NH           dd      0
Hold         dd      0
 
PH           dd      2
pX           dd      0
pY           dd      30 ;10
mL           dd      0  ;75
mT           dd      0  ;75
mR           dd      0  ;75
mB           dd      0  ;75
;
;Setup
Patn         db      '*.*',0
PatnA        db      '*.asm',0
PatnT        db      '*.txt',0
PatnE        db      '*.exe',0
PatnI        db      '*.inc',0
PatnR        db      '*.rc',0
;
;Registry
;
szCustClrs   db      'CustClrs',0
szColor01    db      'Color01',0
szKeyw01     db      'Keyw Grp01',0
szKeyw02     db      'Keyw Grp02',0
szKeyw03     db      'Keyw Grp03',0
szKeyw04     db      'Keyw Grp04',0
szKeyw05     db      'Keyw Grp05',0
szKeyw06     db      'Keyw Grp06',0
szKeyw07     db      'Keyw Grp07',0
szKeyw08     db      'Keyw Grp08',0
szKeyw09     db      'Keyw Grp09',0
szKeyw10     db      'Keyw Grp10',0
szKeyw11     db      'Keyw Grp11',0
szKeyw12     db      'Keyw Grp12',0
szAllS       db      'Dsp all sorted by name',0
szAllU       db      'Dsp all sorted by group',0
KeyWord      dd      szKeyw01,szKeyw02,szKeyw03,szKeyw04,szKeyw05,szKeyw06,szKeyw07,szKeyw08,szKeyw09,szKeyw10,
                     szKeyw11,szKeyw12,szAllS,szAllU

szComm       db      'EW_Common',0
szKey        db      'Comm Key',0
szPath       db      'Path',0
szName       db      'Name',0
szParent     db      'Parent Handle',0
szBuild      db      'Build Handle',0
szChar       db      'CharFormat',0
szCharC      db      'CharFormat Clear',0
szcrF        db      'Char Range',0
szMin        db      'crMin',0
szMax        db      'crMax',0
szRun        db      'Run Code', 0

szRedit      db      'AsmEdit V3',0
szREGSZ      db      'REG_SZ',0
szLeft       db      'PosLeft',0
szTop        db      'PosTop',0
szRight      db      'PosRight',0
szBottom     db      'PosBottom',0
szBuildC     db      'Build',0
szFont       db      'Font',0
szFontH      db      'FontH',0
szFontW      db      'FontW',0
szPoint      db      'Point',0
szColor      db      'Color',0
szEffects    db      'Effects',0
szMask       db      'Mask',0
szSaveWhen   db      '[SaveSettings]',0
szSetFlags   db      '[Settings Flags]',0
szWordWrap   db      '[Word Wrap]',0
szMaxWin     db      '[Max Win on start]',0  
rTS1         db      '[Tab Stop 01]',0
rTS2         db      '[Tab Stop 02]',0
rTS3         db      '[Tab Stop 03]',0
rTS4         db      '[Tab Stop 04]',0
rTS5         db      '[Tab Stop 05]',0
rTS6         db      '[Tab Stop 06]',0
rTS7         db      '[Tab Stop 07]',0
rTS8         db      '[Tab Stop 08]',0
rTS9         db      '[Tab Stop 09]',0
rTS10        db      '[Tab Stop 10]',0
rF1          db      '[F1 Col. Pos]',0
rF2          db      '[F2 Col. Pos]',0
rF3          db      '[F3 Col. Pos]',0
rF4          db      '[F4 Col. Pos]',0
rSP          db      '[Shift Space]',0
rST          db      '[Shift To Cl]',0
rTC          db      '[Color Text.]',0
rTBGC        db      '[Color TxBG.]',0
rBC          db      '[Color BackG]',0

rDEFr        db      '[Default Root Dir]',0
rDEFb        db      '[Default Bin Dir.]',0
rDEFp        db      '[Default Proj Dir]',0
rDEFi        db      '[Default Inc Dir.]',0
rDEFe        db      '[Default Exe Dir.]',0
rDEFm        db      '[Default Misc Dir]',0
rDEFs        db      '[Backup Dir......]',0
rDEFh        db      '[Win32 Help Dir..]',0
rDEFw        db      '[Music Wave Dir..]',0

szHandle     db      'hWorkA',0

SaveWhen     dd      1
SetFlags     dd      15
MaxWin       dd      0
WWrap        dd      1
PointSize    dd      180
FontHeight   dd      -12
FontWeight   dd      500

Build        dd      1
sTS          dd      0
sSPACE       dd      0
TS1          dd      7
TS2          dd      9
TS3          dd      10
TS4          dd      18
TS5          dd      20
TS6          dd      25
TS7          dd      30
TS8          dd      35
TS9          dd      40
TS10         dd      45
Pos1         dd      7
Pos2         dd      9
Pos3         dd      10
Pos4         dd      18
SPACE        dd      5
SHIFT        dd      10
TextC        dd      00008000h
TextBGC      dd      00f7f7f4h
BackGC       dd      00f7f7f4h
P            db      'play ',0
waveP1       db      60 dup(?),0

;Syntax
HighLite     dd      0
WorkArea     dd      0
TextBG       dd      1
SBook        dd      0
EBook        dd      0
HBook1       dd      0
HBook2       dd      0
SPos         dd      0
EPos         dd      0
NScrL        dd      0
ScrL         dd      0
KDN          dd      0
KUP          dd      0
FileOff      dd      0
Llen         dd      0
Lmax         dd      0
Ltot         dd      0
CurPos       dd      0
SavAddr      dd      0
hLibW        dd      0

;Assembly
NMake        db      'NMAKE',0
dash         db      ' - ',0
SlashB       db      '\',0
Per          db      '.',0
Car          db      '^',0
szSpace      db      ' ',0
szByte       db      ' ',0
szCodeGen    db      ' ',0
szWorkWin    db      ' ',0

keyw01       db      'eax,ebx,ecx,edx,esi,edi,ebp,esp,ax,ah,al,bx,bh,bl,cx,ch,cl,dx,dh,dl,si,di,bp,cs,ds,es,ip,sp,',0
keyw02       db      'invoke,call,',0
keyw03       db      'addr,offset,lengthof,sizeof,ptr,uses,',0
keyw04       db      'db,dw,dd,dq,df,dt,d,byte,sbyte,tbyte,word,sword,dword,sdword,fword,qword,real4,real8,real10,',0
keyw05       db      '.if,.elseif,.else,.endif,.while,.break,.endw,while,else,endif,forc,repeat,loope,loopz,loopne,loopnz,loop,local,'
             db      'style,exstyle,caption,font,struct,ends,',0
keyw06       db      'add,adc,aaa,aad,aam,aas,sub,sbb,mul,imul,div,idiv,daa,das,shrd,shld,shr,shl,rol,ror,and,or,xor,not,neg,'
             db      'inc,dec,xadd,xchg,xlat,xlatb,toolbar,menu,stringtable,accelerators,dialog,dialogex,',0
keyw07       db      'stc,std,sti,clc,cld,cli,clts,cmc,cmov,repne,repe,repnz,repz,rep,scas,scasb,scasd,scasw,cmps,cmpsb,cmpsd,cmpsw,'
             db      'cmpxchg,cmpxchg8b,lods,stos,lodsb,stosb,lodsw,stosw,lodsd,stosd,movd,movq,movs,movsb,movsd,movsw,movsx,movzx,bsf,'
             db      'out,outs,outsb,outsd,outsw,ins,insb,insd,insw,packsswb,packssdw,paddb,paddw,paddd,paddsb,paddsw,paddusb,'
             db      'paddusw,bsr,bswap,dup,',0
keyw08       db      'push,pop,pushad,popad,pusha,popa,pushf,popf,pushfd,popfd,lea,cwde,cwd,cbw,cdq,lds,les,lfs,lgs,lidt,lldt,lmsw,'
             db      'lsl,lss,lar,ltr,lgdt,enter,leave,esc,assume,setng,setnge,setnl,setnle,setno,setnp,setns,setnz,seto,'
             db      'setp,setpe,setpo,sets,setz,sgdt,popup,',0
keyw09       db      'mov,cmp,je,jne,jnb,jna,jnl,jmp,jecxz,jz,jnz,jae,ja,jbe,jb,jle,js,jns,jl,jg,jge,jae,jng,jnae,jnbe,'
             db      'jo,jp,jpe,jpo,jc,jcxz,jnc,jnge,jnle,jno,jnp,proc,endp,ret,retf,retn,include,includelib,#include,#define,'
             db      'setng,setnge,setnl,setnle,setno,setnp,setns,setnz,seto,setp,setpe,setpo,sets,setz,sgdt,'
             db      'setae,setb,setbe,setc,sete,setg,setge,setl,setle,setna,setnae,setnb,setnc,setne,bt,btc,btr,bts,rsm,rcl,rcr,'
             db      'menuitem,icon,bitmap,control,ltext,ctext,rtext,pushbutton,defpushbutton,edittext,groupbox,'
             db      'sal,sar,equ,eq,macro,endm,test,sahf,lahf,nop,int,into,bound,iret,str,',0
keyw10       db      'finit,fldcw,fnop,fld,fild,fldz,fld1,f2xm1,fldl2t,fyl2x,fldl2e,fadd,faddp,fsub,fsubr,fsubp,fmul,fmulr,fmulp,'
             db      'fdiv,fdivr,fdivp,fsqrt,fsin,fcos,fsincos,fptan,fpatan,fxch,fchs,fscale,frndint,fst,fstp,fist,fistp,fbstp,'
             db      'fwait,fabs,fiadd,fisub,fisubr,fimul,fidiv,fidivr,fninit,fnstsw,fnstcw,fcompp,fstsw,fldpi,fxtract,fcmov,fcomi,'
             db      'fldlg2,fcom,fcomp,ficom,ficomp,fdecstp,fdivr,fdivrp,ffree,fxam,fucom,fucomp,fcmov,fcomi,',0
keyw11       db      'title,comment,.286,.386,.486,.586,.686,.model,option,.list,.const,.data,.data?,.code,begin,end,separator,',0
keyw12       db      'movmd,movmw,movmb,msgbox,tbbutt,tbsep,m2m,',0

KeyArray     dd      keyw01,keyw02,keyw03,keyw04,keyw05,keyw06,keyw07,keyw08,keyw09,keyw10,keyw11,keyw12
DefColor01   dd      000000ffh,00ff8000h,00808000h,000080ffh,00404080h,00000000h,00ff8000h,000000a6h,00ffd000h,00c000c0h,
                     00400040h,0011d952h,00ff0000h,00002200h,00ac5757h,000045d5h
Color01      dd      16 dup(?)
szColorC     db      'Comments Color,Quots Color,Label Color,Func or Proc Color,Group01 Color,Group02 Color,Group03 Color,Group04 Color,',
                     'Group05 Color,Group06 Color,Group07 Color,Group08 Color,Group09 Color,Group10 Color,Group11 Color,Group12 Color,',0
;
TempWord1    dd      0
TempWord2    dd      0 
xPerInch     dd      0
yPerInch     dd      0

lpType       dd      0
lpcbData     dd      0
lpdwDisp     dd      0

TopLine      dd      0
ScrollPos    dd      0
SavScroll    dd      0

FirstTime    dd      1 ;0
HexOpen      dd      0
FontH        dd      0
SavSize      dd      0
IDArray      dd      0
ArraySize    dd      0
REVer3       dd      0
DataFlag     dd      0
szSColon     db      ';',0
szDol        db      '$',0
szHT         db      09h,0
szCR         db      0dh,0
szCRLF       db      0dh,0ah,0
szTest       db      0dh,0ah,0h,0
szCode       db      '.code',0
szProc       db      'proc',0
szEndP       db      'endp',0
HexDec       dd      0
NumKWs       dd      0
hProcessWA   dd      0
hProcessB    dd      0
hThreadB     dd      0
RunCode      dd      0
;osvBN        dd      0
Test4        dd      0

;
; Structure storage
;

;IID_ITextDocument   GUID <08cc497c0h, 0a1dfh, 011ceh, <080h, 098h, 000h, 0aah, 000h, 047h, 0beh, 05dh>>
;IID_ITextDocument   TEXTEQU      <{08cc497c0h, 0a1dfh, 011ceh, {080h, 098h, 000h, 0aah, 000h, 047h, 0beh, 05dh}}>

stin     STARTUPINFO         <?> ; For GetStartupInfo/CreateProcess
prin     PROCESS_INFORMATION <?> ; For CreateProcess/GetExitCodeProcess
;sat      SECURITY_ATTRIBUTES <?>
;osv      OSVERSIONINFO       <>  ; O/S Information
ms       MEMORYSTATUS        <?> ; Memory status
msg      MSG                 <?> ; GetMessage/DispatchMessage structure
doci     DOCINFO             <?> ; Docinfo (printing support)
ofn      OPENFILENAME        <?> ; Open file common dialog structure
psd      PAGESETUPDLG        <?> ; Page setup common dialog structure
pd       PRINTDLG            <?> ; print common dialog structure
time     SYSTEMTIME          <?> ; For GetLocalTime
rect     RECT                <?> ; Rectangle
tm       TEXTMETRIC          <?> ; Text Metrics
wc       WNDCLASSEX          <?> ; Window class (RegisterClass) structure
EditS    EDITSTREAM          <?> ; For EM_STREAMIN/EM_STREAMOUT
charF    CHARFORMAT2         <?> ; For EM_GETCHARFORMAT/EM_SETCHARFORMAT
charC    CHARFORMAT2         <?> ; For EM_GETCHARFORMAT/EM_SETCHARFORMAT
cf       CHOOSEFONT          <?> ; Keep CHOOSFONT/LOGFONT together (Choose Font comm dlg)
lf       LOGFONT             <?> ; For CreateFontIndirect
cc       CHOOSECOLOR         <?> ; Chose Color comm dlg
pf       PARAFORMAT2         <0> ; For EM_SETPARAFORMAT
ft       FINDTEXT            <>  ; For EM_EXGETSEL/EM_EXSETSEL
sci      SCROLLINFO          <?> ; For GetScrollInfo/SetScrollInfo
ftX      FINDTEXTEX          <>  ; For EM_EXGETSEL/EM_EXSETSEL
tbab     TBADDBITMAP         <>  ; For TB_ADDBITMAP
fr       FORMATRANGE         <0> ; For EM_FORMATRANGE
cr       CHARRANGE           <?> ; Character range
;dv       DLLVERSIONINFO      <?> ; Get O/S version info
tr       TEXTRANGE           <>  ; For EM_GETTEXTRANGE
rectV    RECT                <>  ; Rectangle
dis      DRAWITEMSTRUCT      <?> ; For WM_DRAWITEM
;rq       REQRESIZE           <>

;=========================================================================
; CODE                                                                   *
;=========================================================================
         .code
start:
      INVOKE     GetCommandLine
         mov     CommandLine, eax
        call     ParseCommandLine
        call     InitCommonControls          ; Initialize the common ctrl lib
      INVOKE     LoadLibrary, addr RichEdDLL ; Load the Riched20.dll
      .if !eax
         MsgBox     ERROR_REQUIRED_DLL_NOT_FOUND, RichEdDLL, MB_OK or MB_ICONERROR
            jmp     NoGo
      .endif
         mov     hREdDll, eax

      INVOKE     GetProcessHeap
         mov     hDefHeap, eax
      INVOKE     GetModuleHandle, 0          ; Get hModule (in eax)
         mov     hInst, eax                  ; hInst is same as HMODULE

findcls:
      INVOKE     FindWindow, addr class, 0
          or     eax, eax
          jz     regclass
          or     MultInst, 1

;         MsgBox  ERROR_ALREADY_RUNNING, , MB_ABORTRETRYIGNORE
;         cmp     eax, IDABORT
;          je     NoLoad
;         cmp     eax, IDRETRY
;          je     regclass

regclass:
      INVOKE     WinMain, hInst, NULL, CommandLine, SW_SHOWDEFAULT
         mov     MainExit, eax
      INVOKE     FreeLibrary, hREdDll
      .if hLib
         INVOKE     FreeLibrary, hLib
      .endif
      .if hCodeGen
         INVOKE     FreeLibrary, hCodeGen
      .endif
      .if hLibA
         INVOKE     FreeLibrary, hLibA
      .endif

NoGo:
      INVOKE     ExitProcess, MainExit ;msg.wParam

;============================================================
; Initialize the WndClass structure and register our class  *
;============================================================
WinMain PROC     hinst:DWORD, hPrevInst, CmdLine, CmdShow
         mov     wc.cbSize, sizeof WNDCLASSEX    
         mov     wc.style, CS_BYTEALIGNWINDOW ;CS_HREDRAW or CS_VREDRAW or CS_GLOBALCLASS
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
         mov     eax, hInst
         mov     wc.hInstance, eax
      INVOKE     LoadIcon, eax, IDI_ICON1
         mov     wc.hIcon, eax
         mov     wc.hIconSm, eax
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
;         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.hbrBackground,COLOR_BTNFACE+1
         mov     wc.lpszMenuName, 0
         mov     wc.lpszClassName, offset class
      INVOKE     RegisterClassEx, addr wc

;=======================
; Get our menu resources
;=======================
      INVOKE     LoadMenu, hInst, IDR_MENU1
         mov     hMenu, eax
      INVOKE     LoadMenu, hInst, IDR_MENU2   
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenu, eax

;=======================
; Create the main window
;=======================
      INVOKE     RegQuery, addr szLeft, CW_USEDEFAULT
         mov     rect.left, eax
      INVOKE     RegQuery, addr szTop, CW_USEDEFAULT
         mov     rect.top, eax
      INVOKE     RegQuery, addr szBottom, CW_USEDEFAULT
         mov     rect.bottom, eax
      INVOKE     RegQuery, addr szRight, CW_USEDEFAULT
         mov     rect.right, eax
         cmp     eax, CW_USEDEFAULT
         jne     calcwh

;---------- [If first time center window] ----------
      INVOKE     GetSystemMetrics, SM_CXSCREEN
         sub     eax, 702
         shr     eax, 1
         mov     rect.left, eax
      INVOKE     GetSystemMetrics, SM_CYSCREEN
         sub     eax, 540
         shr     eax,1
         mov     rect.top, eax
         mov     ebx, 702
         mov     eax, 540
         jmp     crewin

calcwh:
         mov     eax, rect.bottom
         sub     eax, rect.top
         mov     ebx, rect.right
         sub     ebx, rect.left

crewin:
      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr class, addr pTitle,
                 WS_OVERLAPPEDWINDOW or WS_VISIBLE or WS_CLIPCHILDREN or WS_CLIPSIBLINGS,
                 rect.left, rect.top, ebx, eax, 0, hMenu, hInst, 0
         mov     hWnd, eax

;==================================================
; Show the window and go into message dispatch loop
;==================================================
      INVOKE     RegQuery, addr szMaxWin, MaxWin
         mov     MaxWin, eax
      .if eax
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_CHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWMAXIMIZED
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_UNCHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      .endif
      INVOKE     UpdateWindow, hWnd

      INVOKE     LoadAccelerators, hInst, IDR_ACCEL
         mov     hAccel, eax

BeginLoop:
      INVOKE     GetMessage, addr msg, 0, 0, 0
         cmp     ax, 0
          je     EndLoop
      INVOKE     TranslateAccelerator, hWnd, hAccel, addr msg
   cmp     eax, 0
   jne     BeginLoop
      INVOKE     IsDialogMessage, hFRDlg, addr msg
         cmp     eax, 0
         jne     BeginLoop
      INVOKE     TranslateMessage, addr msg

;**** changes keyboard del key to menu key ****
;.if msg.wParam == 2eh
;INVOKE     PeekMessage, addr msg, hWnd, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE  
;INVOKE     PostMessage, hWnd, WM_COMMAND, IDM_DEL, 0
;jmp     BeginLoop
;.endif
;**********************************************

      INVOKE     DispatchMessage, addr msg
         jmp     BeginLoop

EndLoop:
         ret
WinMain  ENDP
NoLoad:

;=========================================================================
; WNDPROC                                                                *
;=========================================================================
WndProc  PROC    uses ebx edx edi esi hwnd:DWORD, wmsg, wparam, lparam
LOCAL    tbb:TBBUTTON
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    Chg:DWORD, hEDC, hFind
LOCAL    SavFile[100]:BYTE, szWork[256]

         mov     eax, wmsg
         cmp     eax, WM_TIMER
          je     wmtimer
         cmp     eax, WM_SIZE
          je     wmsize
         cmp     eax, WM_CREATE
          je     wmcreate
         cmp     eax, WM_COMMAND
          je     wmcommand
         cmp     eax, WM_DESTROY
          je     wmdestroy
         cmp     eax, WM_NOTIFY
          je     wmnotify
         cmp     eax, WM_MENUSELECT
          je     wmmenuselect
         cmp     eax, WM_SETFOCUS
          je     wmsetfocus
         cmp     eax, WM_PAINT
          je     wmpaint
         cmp     eax, WM_TRACKCURSOR
          je     wmtrackcursor
         cmp     eax, WM_QUERYENDSESSION
          je     wmqueryendsession
         cmp     eax, WM_CLOSE
          je     wmclose
         cmp     eax, WM_INITMENUPOPUP
          je     wminitmenupopup
         cmp     eax, WM_OPENCOMMANDARGS
          je     idmopenB
      .if wmsg == WM_NCMOUSEMOVE
            and     MultInst, 0
      .endif
         jmp     defwndproc

wmcommand:
         mov     eax, wparam
        cwde                          ; Only low word contains command
         mov     wparam, eax
         jmp     BranchTo

IDCMD    dd idmnew,idmopen,idmopenhex,idmnew,idmsave,idmsaveas,idmsavehex,idmpagesu,idmprintprev,idmprint
         dd idmsavesettings,wmclose,idmcut,idmcopy,idmpaste,idmdelete,idmundo,idmredo,idmfind,idmfindnext
         dd idmfindprev,idmreplace,idmreplacenext,idmshiftr,idmshiftl,idmshiftto,idmpos1,idmpos2,idmpos3
         dd idmpos4,idmgotoline,idmselall,idmcolorfont,idmindentr,idmindentl,idmwwrap,idmrtfon,idmrtfoff
         dd idmsettabs,idmconv,idmhtml,idmsetup,idmbooks,idmbookr,idmbooks,idmbookr,idmprthead,idmroot
         dd idmbin,idmpgm,idminc,idmexe,idmmisc,idmback,idmascii,idmcalctb,idmhelp,idmwhelp,idmabout
         dd idmversion,idmewedit,idmexe,idmdos,idmassmb,idmsyntax,idmundoredo,idmclip,idmrcolor
         dd idmrkeyword,idmmax,idmwork
BranchTo:
      .if eax > 6000 && eax < 6072
            sub     eax, 6001
           imul     eax, 4
            jmp     IDCMD[eax]
      .endif

;---------- [Set the char range for highlighting errors from build] ----------
      .if eax == 844  ; From Build
         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szBuild, 0, addr lpType, addr hBuild, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szMin, 0, addr lpType, addr cr.cpMin, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szMax, 0, addr lpType, addr cr.cpMax, addr lpcbData
         INVOKE     RegCloseKey, hReg

         .if lparam == 8888                                               ; In case there are multible builds
              call     SetReg
         .endif

         .if lparam == 4444
            INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
             MOVmd     SavScroll, sci.nPos
              call     CenterSel
            INVOKE     SetFocus, hBuild
         .endif
         .if lparam > 1000 && lparam < 1005
               and     sw1, 0
              call     SaveFile
            INVOKE     SendMessage, hBuild, WM_COMMAND, lparam, lparam    ; Go back to Build
         .else
            INVOKE     SendMessage, hBuild, WM_COMMAND, 9999, lparam      ; Go back to Build
         .endif
      .endif

;--------------- [New Project] ---------------
      .if eax == 802 || eax == 902  ; 802 = new project, 902 = new pointer and folder
            cmp     szWorkWin, 1
             je     return0
            cmp     szCodeGen, 1
             je     return0
            cmp     hCreate, 0
            jnz     return0
         .if hAsm
            INVOKE     SendMessage, hAsm, WM_COMMAND, IDCANCEL, 0
               and     hAsm, 0
         .endif
.if wparam == 802
         INVOKE     StartNewDocument, hwnd
         INVOKE     SendMessage, hREdit, WM_SETTEXT, 0, addr szNULL
            mov     byte ptr PathName, 0
           call     SetTitle
.endif
         INVOKE     LoadLibrary, addr LibNameC
         .if !eax
            MsgBox     ERROR_MISSING_DLL, LibNameC, MB_OK or MB_ICONERROR
               jmp     defwndproc
         .endif
            mov     hCreate, eax
           push     offset szByte
           push     offset szRedit
           push     offset PathName
           push     hInst
           push     hWnd
         .if wparam == 802
            INVOKE     GetProcAddress, hCreate, addr FuncNameC
         .else
            INVOKE     GetProcAddress, hCreate, addr FuncNameCF
         .endif
         .if !eax
               jmp     defwndproc
         .endif
           call     eax
         INVOKE     FreeLibrary, hCreate
            and     hCreate, 0
         .if byte ptr szByte == 3  ;4
               jmp     return0
         .endif
            mov     w5, 1
            mov     sw4, 1
            jmp     idmopenB
      .endif

;--------------- [Gode Generators] ---------------
      .if eax == 803
           call     SetReg
         .if hCodeGen
               mov     al, byte ptr szCodeGen
            .if !al
                  and     hLibW, 0
                  jmp     GetProc
            .endif
               jmp     return0
         .endif

         INVOKE     LoadLibrary, addr LibNameG
         .if !eax
            MsgBox     ERROR_MISSING_DLL, LibNameG, MB_OK or MB_ICONERROR
               jmp     defwndproc
         .endif
            mov     hCodeGen, eax

GetProc:
         INVOKE     GetProcAddress, hCodeGen, addr FuncNameG
         .if eax
              push     offset hLibW
              push     offset szWorkWin
              push     offset szCodeGen
              push     offset szRedit
              push     offset hCodeGen
              push     hInst
              push     hWnd
              call     eax
         .endif
            jmp     return0
      .endif

;--------------- [Quick Build] ---------------
      .if eax == 804
         .if !PathName

NotRight:
            MsgBox     ERROR_NOTHING_DISPLAYED, szSetup, MB_OK or MB_ICONERROR
               jmp     return0
         .endif
         .if ExtType == 'a' && ExtType + 1 == 's' && ExtType + 2 == 'm' ||\
             ExtType == '.' && ExtType + 1 == 'r' && ExtType + 2 == 'c'
         .else
               jmp     NotRight
         .endif
         INVOKE     GetExitCodeProcess, hProcessB, addr ExitCode 
         .if ExitCode == STILL_ACTIVE
            INVOKE     SendMessage, hBuild, WM_COMMAND, 1004, 1004  ; Go back to Build
                  jmp     return0
         .endif
            and     RunCode, 0
         .if lparam == 25 || Build              ; 25 Is from Assemble/Edit dialog, Build is complete build
               mov     RunCode, 1
         .endif
           call     SetReg

            mov     charF.crBackColor, 0080ffffh
            mov     charF.dwEffects, 0
          MOVmd     charC.crTextColor, TextC
          MOVmd     charC.crBackColor, BackGC
            mov     charC.dwEffects, 0
            mov     charC.dwMask, CFM_COLOR or CFM_BACKCOLOR

         INVOKE     lstrcpy, addr WorkBuff, addr RootDir
         INVOKE     lstrcat, addr WorkBuff, addr szBuildE
         INVOKE     GetStartupInfo, addr stin
         INVOKE     CreateProcess, addr WorkBuff, 0, 0, 0, FALSE,\
                    NORMAL_PRIORITY_CLASS, 0, 0 , addr stin, addr prin
          MOVmd     hProcessB, prin.hProcess
          MOVmd     hThreadB, prin.hThread
      .endif

;--------------- [File name list from the file menu] --------------- 
      .if eax > 1400 && eax < 1411
           push     eax
         INVOKE     CheckSav, hwnd
         INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
         INVOKE     lstrcpy, addr WorkBuff, addr PathName
            pop     eax
         INVOKE     GetRegPath, eax, addr szRedit
         INVOKE     lstrcpy, addr PathName, eax
         INVOKE     lstrcpy, addr szBuff, addr PathName
            mov     w5, 1
            jmp     idmopenB
      .endif
         jmp     defwndproc

;--------------- [Load the Work Area] ---------------
idmwork:
        call     SetReg

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp

      .if hProcessWA
            jmp     Loaded
      .endif
      INVOKE     RegSetValueEx, hReg, addr szHandle, 0, REG_DWORD, addr hwnd, 4
      INVOKE     lstrcpy, addr WorkBuff, addr RootDir
      INVOKE     lstrcat, addr WorkBuff, addr szCallDLLW
      INVOKE     GetStartupInfo, addr stin
      INVOKE     CreateProcess, addr WorkBuff, 0, 0, 0, FALSE,\
                 NORMAL_PRIORITY_CLASS, 0, 0 , addr stin, addr prin
        test     eax, eax
          jz     return0
       MOVmd     hProcessWA, prin.hProcess
;      INVOKE     CloseHandle, prin.hProcess

Loaded:
         mov     eax, hWnd
      .if !hWorkA || eax == hWorkA
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szHandle, 0, addr lpType, addr hWorkA, addr lpcbData
      .endif
      INVOKE     RegCloseKey, hReg

      .if WorkArea
         INVOKE     SetWindowPos, hWorkA, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_HIDEWINDOW
         INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_WORK, 1
         INVOKE     SendMessage, hWndTool, TB_CHECKBUTTON, IDM_WORK, MF_UNCHECKED or MF_BYCOMMAND
            mov     WorkArea, 0
      .else
         INVOKE     SetWindowPos, hWorkA, HWND_TOP, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW
         INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_WORK, 0
         INVOKE     SendMessage, hWndTool, TB_CHECKBUTTON, IDM_WORK, MF_CHECKED or MF_BYCOMMAND
            mov     WorkArea, 1
      .endif
      INVOKE     SetFocus, hREdit
         jmp     return0

wmpaint:
      INVOKE     SendMessage, hREdit, WM_PAINT, 0, 0
         jmp     defwndproc

idmrcolor:
         mov     sw3, 8
        call     Initialize
         jmp     return0

idmrkeyword:
         mov     sw3, 7
        call     Initialize
        call     KeyWordList
         jmp     return0

idmsyntax:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
         mov     al, charF.bCharSet
      .if al == DEFAULT_CHARSET
            jmp     return0
      .endif
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax

      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos

      .if HighLite
            mov     TempWord1, MF_GRAYED
            mov     TempWord2, MF_ENABLED
            and     HighLite, 0
      .else
            mov     TempWord1, MF_ENABLED
            mov     TempWord2, MF_GRAYED
            mov     HighLite, 1
      .endif
      INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_SYNTAX, TempWord1
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, TextBGC
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF

        call     SetScroll
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0

      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
      INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
         jmp     EnaDis

idmnew:
      INVOKE     StartNewDocument, hwnd
      INVOKE     SendMessage, hREdit, WM_SETTEXT, 0, addr szNULL
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
         mov     byte ptr[PathName], 0
         and     HexOpen, 0
        call     SetTitle
         jmp     return0

idmopen:
         mov     ecx, lengthof szASM
         mov     esi, offset szASM
         jmp     DoOpen
idmopenB:
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     OA, 1
         jmp     DoOpen
DoOpen:
         mov     edi, offset szFilter
         rep     movsb
        call     OpenFileA
      .if sw4
;            and     sw4, 0
         INVOKE     SendMessage, hwnd, WM_COMMAND, IDM_ASSEMBLE, 0
      .endif
         jmp     return0

idmopenhex:
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     edi, offset szFilter
         rep     movsb
         mov     sw1, 5
         mov     OA, 2
        call     OpenFileA
      .if !eax
            jmp     return0
      .endif
         mov     ebx, hBuff
      INVOKE     lstrcpy, ebx, addr PathName
        call     readp
        push     eax
      .if eax
          MOVmd     SavSize, bytesread
         INVOKE     BuildHex, hREdit, fpMem, bytesread, 16
      .endif
      INVOKE     GlobalUnlock, fpMem
      INVOKE     GlobalFree, hpMem
         mov     hpMem, 0
         pop     eax
     .if !eax
           jmp     return0
     .endif
        call     SetTitle
         and     HighLite, 0
        call     ScreenLines
         jmp     return0

idmsave:
         and     sw1, 0
        call     SaveFile
         jmp     return0
idmsaveas:
         mov     sw1, 1
        call     SaveFile
         jmp     return0
idmsavehex:
        call     ConvHex
         jmp     return0

idmprint:
        call     PrintProc
         jmp     return0

idmpagesu:
        call     DoPageSU
         jmp     return0

idmprintprev:
         jmp     return0

idmsavesettings:
         mov     eax, offset SavSetDlg
         mov     ebx, IDD_SAVSET
         jmp     CreateDlg

idmexit:
      INVOKE     SendMessage, hwnd, WM_CLOSE, 0, 0
         jmp     return0

idmcut:
      INVOKE     SendMessage, hREdit, WM_CUT, 0 ,0
         jmp     EnaDis

idmcopy:
      INVOKE     SendMessage, hREdit, WM_COPY, 0 ,0
         jmp     EnaDis

idmpaste:
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
         mov     al, charF.bCharSet
      .if al == DEFAULT_CHARSET
           call     ScreenLines
            and     DataFlag, 0
;         INVOKE     SendMessage, hREdit, EM_PASTESPECIAL, CF_TEXT, 0
         INVOKE     SendMessage, hREdit, WM_PASTE, 0 ,0
            jmp     EnaDis
      .endif

         mov     DataFlag, 1
         mov     w7, 9

; or ES_SAVESEL or WS_VISIBLE or ES_NOHIDESEL
;---------- [Have to do this for pasting from IE, etc.] ----------
      INVOKE     CreateWindowEx, 0, addr EditPT, 0, WS_POPUP or ES_MULTILINE or\
                 WS_HSCROLL or WS_VSCROLL,\
                 100, 100, 300, 400, 0, 0, hInst, 0
         mov     Test4, eax
      INVOKE     SendMessage, Test4, EM_EXLIMITTEXT, 0, 2000000
      INVOKE     SendMessage, Test4, WM_PASTE, 0 ,0
      INVOKE     SendMessage, Test4, WM_SETFONT, hFont, 1
      INVOKE     SendMessage, Test4, WM_GETTEXTLENGTH, 0, 0
      .if eax
         INVOKE     SendMessage, Test4, EM_SETSEL, -1, 0
         INVOKE     SendMessage, Test4, EM_REPLACESEL, TRUE, addr szCR
      .endif
      INVOKE     SendMessage, Test4, EM_SETSEL, 0, -1
      INVOKE     SendMessage, Test4, WM_COPY, 0 ,0
        call     ScreenLines
      INVOKE     SendMessage, hREdit, WM_PASTE, 0 ,0
      INVOKE     SendMessage, Test4, WM_GETTEXTLENGTH, 0, 0
      .if eax
            dec     eax
            mov     ebx, eax
            inc     ebx
         INVOKE     SendMessage, Test4, EM_SETSEL, eax, ebx
         INVOKE     SendMessage, Test4, EM_REPLACESEL, TRUE, addr szNULL
         INVOKE     SendMessage, Test4, EM_SETSEL, 0, -1
         INVOKE     SendMessage, Test4, WM_COPY, 0 ,0
      .endif
      INVOKE     DestroyWindow, Test4
         jmp     EnaDis

idmdelete:
      .if hFRDlg > 0
            jmp     return0
      .endif
      ;INVOKE     SendMessage, hREdit, WM_KEYDOWN, VK_DELETE, 0  ;????????
      INVOKE     SendMessage, hREdit, WM_CLEAR, 0 ,0
         jmp     EnaDis

idmundo:
idmredo:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
      .if wparam == IDM_UNDO
         INVOKE     SendMessage, hREdit, WM_UNDO, 0, 0
      .else
         INVOKE     SendMessage, hREdit, EM_REDO, 0, 0
      .endif
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         jmp     EnaDis

idmfind:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         mov     eax, offset FindReplace
      INVOKE     CreateDialogParam, hInst, IDD_FIND, hwnd, eax, 0
         cmp     eax, IDCANCEL    ; Canceled?
          je     return0          ; yes, then return
      INVOKE     SetDlgItemText, hFRDlg, EditF, addr szFind
         jmp     EnaDis

idmfindnext:
         and     Prev, 0
         mov     FRFlags, 1
         mov     ft.chrg.cpMax, -1
idmfindnext1:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
      .if !Prev 
         add     cr.cpMin, 1
      .endif
       MOVmd     ft.chrg.cpMin, cr.cpMin
         lea     eax, offset szFind
         mov     ft.lpstrText, eax
      INVOKE     Find, hwnd, 1, FRFlags, ft.lpstrText, Prev
         jmp     EnaDis

idmfindprev:
         mov     Prev, 1
         and     FRFlags, 0
         mov     ft.chrg.cpMax, 0
         jmp     idmfindnext1

idmreplace:
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         mov     eax, offset FindReplace
      INVOKE     CreateDialogParam, hInst, IDD_FINDREPLACE, hwnd, eax, 0
         cmp     eax, IDCANCEL
          je     return0
      INVOKE     SetDlgItemText, hFRDlg, EditF, addr szFind
         jmp     return0

idmreplacenext:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szRep
      INVOKE     Find, hwnd, 1, FRFlags, ft.lpstrText, Prev
         jmp     EnaDis

idmshiftr:
         mov     Misc, 'R'
        call     Shift
         jmp     return0
idmshiftl:
         mov     Misc, 'L'
        call     Shift
         jmp     return0
idmshiftto:
         mov     Misc, 'S'
        call     Shift
         jmp     return0

idmpos1:
       MOVmd     w5, Pos1
        call     Column
         jmp     return0
idmpos2:
       MOVmd     w5, Pos2
        call     Column
         jmp     return0
idmpos3:
       MOVmd     w5, Pos3
        call     Column
         jmp     return0
idmpos4:
       MOVmd     w5, Pos4
        call     Column
         jmp     return0

idmgotoline:
         mov     sw2, 9
         mov     eax, offset CommonDlg
         mov     ebx, IDD_GOTOLINE
         jmp     CreateDlg ;DialogBox

idmselall:
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
      INVOKE     SendMessage, hREdit, WM_GETTEXTLENGTH, 0, 0
         mov     SBook, 0
         mov     EBook, eax
         jmp     EnaDis

idmcolorfont:
      .if hClrDlg
            jmp     return0
      .endif
         mov     eax, offset ColorFontDlg
         mov     ebx, IDD_COLORFONT
         jmp     CreateDlg

idmindentr:
         jmp     return0

idmindentl:
         jmp     return0

idmmax:
         and     MaxWin, 0 
      INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_CHECKED
         INVOKE     ShowWindow, hWnd, SW_SHOWMAXIMIZED
            mov     MaxWin, 1
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_MAX, MF_UNCHECKED
         INVOKE     ShowWindow, hWnd, SW_RESTORE
      .endif
         jmp     return0

idmwwrap:
      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
        call     WordWrap
        call     SetScroll
         jmp     return0

idmrtfon:
      INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_UNCHECKED
            mov     RTF, 1
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_UNCHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_CHECKED
      .endif
         mov     OA, 1
        call     OpenFileA 
         jmp     return0

idmrtfoff:
      INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_BYCOMMAND
      .if eax != MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_UNCHECKED
            and     RTF, 0      
      .else
         INVOKE     CheckMenuItem, hMenu, IDM_RTFOFF, MF_UNCHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
      .endif
         mov     OA, 1
        call     OpenFileA 
         jmp     return0

idmsettabs:
        call     TabStop
         jmp     return0

idmconv:
         mov     eax, offset ConvTabs
         mov     ebx, IDD_CONVERT
         jmp     CreateDlg

idmhtml:
        call     HTML
         jmp     return0

idmsetup:
      .if hSUDlg
            jmp     return0
      .endif
         mov     w7, 0
         mov     eax, offset Setup
         mov     ebx, IDD_SETUP
         jmp     CreateDlg

idmbooks:
      .if wparam == 6043
         INVOKE     SendMessage, hREdit, EM_GETSEL, addr HBook1, 0
      .else
         INVOKE     SendMessage, hREdit, EM_GETSEL, addr HBook2, 0
      .endif
         jmp     return0
idmbookr:
      .if wparam == 6044
         INVOKE     SendMessage, hREdit, EM_SETSEL, HBook1, HBook1
          MOVmd     SBook, HBook1
          MOVmd     EBook, HBook1
      .else
         INVOKE     SendMessage, hREdit, EM_SETSEL, HBook2, HBook2
          MOVmd     SBook, HBook2
          MOVmd     EBook, HBook2
      .endif
      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
        call     CenterSel
         jmp     return0

idmundoredo:
      INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
         jmp     EnaDis

idmclip:
      INVOKE     OpenClipboard, NULL
      INVOKE     EmptyClipboard
      INVOKE     CloseClipboard
         jmp     EnaDis

idmprthead:
         mov     sw2, 6
         mov     eax, offset CommonDlg
         mov     ebx, IDD_PRTHEAD
         jmp     DialogBox

idmewedit:
      INVOKE     lstrcpy, addr szWork, addr RootDir
      INVOKE     lstrcat, addr szWork, addr szEWREdit
      INVOKE     WinExec, addr szWork, SW_SHOWNORMAL     ; Exec a program
         jmp     return0

idmdos:
      INVOKE     GetWindowsDirectory, addr WorkBuff, lengthof WorkBuff
         ;dec     eax  
      .if byte ptr WorkBuff[eax-1] == 'T'  
         INVOKE     GetSystemDirectory, addr WorkBuff, lengthof WorkBuff
      .endif  
      INVOKE     lstrcat, addr WorkBuff, addr szDos
      INVOKE     WinExec, addr WorkBuff, SW_SHOWNORMAL   ; Dos Prompt
         jmp     return0

idmroot:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFr, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szASM
         mov     esi, offset szASM
         mov     OA, 2
         jmp     DoOpen

idmbin:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFb, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     OA, 2
         jmp     DoOpen

idmpgm:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFp, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szTXT
         mov     esi, offset szTXT
         mov     OA, 2
         jmp     DoOpen

idminc:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFi, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     OA, 2
         jmp     DoOpen

idmexe:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFe, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
;      INVOKE     lstrcpy, addr szBuff, addr CurDir
      INVOKE     lstrcpy, addr SavFile, addr FileName
      INVOKE     lstrcpy, addr WorkBuff, addr PathName
         mov     ecx, lengthof szEXE
         mov     esi, offset szEXE
         mov     edi, offset szFilter
         rep     movsb
         mov     OA, 2
         mov     sw1, 4
        call     OpenFileA
      INVOKE     WinExec, addr FileName, SW_SHOWNORMAL  ; Exec a program
;      INVOKE     lstrcpy, addr CurDir, addr szBuff
      INVOKE     lstrcpy, addr FileName, addr SavFile
      INVOKE     lstrcpy, addr PathName, addr WorkBuff
      INVOKE     SetCurrentDirectory, addr CurDir
         jmp     return0

idmmisc:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFm, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     OA, 2
         jmp     DoOpen


idmback:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFs, addr szBuff
      .if szBuff == ' ' || !szBuff
         jmp     ERRSetup
      .endif
      INVOKE     SetCurrentDirectory, addr szBuff
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     edi, offset szFilter
         rep     movsb
      INVOKE     lstrcpy, addr szBuff, addr CurDir
      INVOKE     lstrcpy, addr WorkBuff, addr PathName
      INVOKE     lstrcpy, addr PathName, addr FileName
      INVOKE     GetCurrentDirectory, lengthof CurDir, addr CurDir
      .if HexOpen
         INVOKE     SendMessage, hWnd, WM_COMMAND, IDM_SAVEHEX, 0
      .else
            mov     sw1, 1
            mov     sw2, 1 
           call     SaveFile
      .endif
         jmp     return0

ERRSetup:
         shr     eax, 2
         add     eax, 6001
         mov     w3, eax
      MsgBox     ERROR_SETUP_HAS_NOT_BEEN_RUN, szSetup, MB_YESNO or MB_ICONQUESTION
         cmp     eax, IDNO
          je     return0
         mov     w7, 0
         mov     Hold, 3
         mov     eax, offset Setup
      INVOKE     CreateDialogParam, hInst, IDD_SETUP, hWnd, eax, 0
         jmp     return0

idmascii:
         mov     eax, offset AsciiDlg
      INVOKE     CreateDialogParam, hInst, IDD_ASCII, hwnd, eax, 0
         mov     hAscii, eax
      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr EditPT, 0,
                 WS_CHILD or WS_VISIBLE or ES_CENTER, 39, 36, 26, 20, hAscii, 41, hInst, 0
         mov     hAsciibox, eax
      INVOKE     SetFocus, eax
      INVOKE     SetWindowLong, hAsciibox, GWL_WNDPROC, AsciiProc
         mov     lpAsciibox, eax


      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr EditPT, 0,
                 WS_CHILD or WS_VISIBLE or ES_CENTER or ES_UPPERCASE, 120, 36, 32, 20, hAscii, 42, hInst, 0
         mov     hInput, eax
      INVOKE     SetWindowLong, hInput, GWL_WNDPROC, AsciiProc
         mov     lpAsciibox, eax
         jmp     return0

idmassmb:
         cmp     hAsm, 0
         jne     return0
         mov     eax, offset AssmbDlg
      INVOKE     CreateDialogParam, hInst, IDD_ASSEMBLE, hwnd, eax, 0
         mov     hAsm, eax

      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr listbox, 0,
                 WS_CHILD or WS_VSCROLL or WS_VISIBLE or LBS_HASSTRINGS or\
                 LBS_NOINTEGRALHEIGHT or LBS_DISABLENOSCROLL or LBS_SORT,\
                 9, 61, 152, 147, hAsm, 315, hInst, 0
         mov     hAsmbox, eax
      INVOKE     CreateWindowEx, 0, addr listbox, 0,
                 WS_CHILD or WS_VSCROLL or LBS_HASSTRINGS or LBS_NOTIFY or\
                 LBS_NOINTEGRALHEIGHT or LBS_DISABLENOSCROLL or LBS_SORT,\
                 11, 63, 148, 143, hAsm, 319, hInst, 0
         mov     hMult, eax

      INVOKE     SetCurrentDirectory, addr RootDir
      INVOKE     lstrcpy, addr szWork, addr RootDir
      INVOKE     lstrcat, addr szWork, addr PatnP
      INVOKE     FindFirstFile, addr szWork, addr FindData
        test     eax, eax
          js     NoFile
         mov     hFind, eax
         jmp     Addem

Getem:
      INVOKE     FindNextFile, hFind, addr FindData
        test     eax, eax
          jz     AllDone

Addem:
      INVOKE     lstrlen, addr FindData.cFileName
         sub     eax, 3
      INVOKE     lstrcpyn, addr szWork, addr FindData.cFileName, eax
      INVOKE     SendMessage, hAsmbox, LB_ADDSTRING, 0, addr szWork
         jmp     Getem

AllDone:
      INVOKE     FindClose, hFind
      .if sw4
            and     sw4, 0
         INVOKE     lstrlen, addr FileName
            sub     eax, 3
         INVOKE     lstrcpyn, addr Misc, addr FileName, eax
         INVOKE     SendMessage, hAsmbox, LB_SELECTSTRING, -1, addr Misc
      .endif

NoFile:
         jmp     return0

idmcalctb:
      .if lparam == 0
         INVOKE     LoadLibrary, addr LibName
         .if eax
               mov     hLib, eax
            INVOKE     GetProcAddress, eax, addr ProcName
            .if eax
                 push     hLib
                 call     eax
            .else
; Error message
            .endif
         .else
            MsgBox     ERROR_MISSING_DLL, LibName, MB_OK or MB_ICONERROR
         .endif
      .endif
         jmp     return0

DialogBox:                          ; Modal dialog box
      INVOKE     DialogBoxParam, hInst, ebx, hwnd, eax, 0
         jmp     return0

CreateDlg:                          ; Modeless dialog box 
      INVOKE     CreateDialogParam, hInst, ebx, hwnd, eax, lparam
         jmp     return0

idmhelp:
      INVOKE     lstrcpy, addr WorkBuff, addr RootDir
      INVOKE     lstrcat, addr WorkBuff, addr szHelp
      INVOKE     WinHelp, hwnd, addr WorkBuff, HELP_CONTENTS, 0
 ;     INVOKE     WinHelp, hWnd, addr szBuff1, HELP_KEY, addr szHelpKey
         jmp     return0

idmwhelp:
         mov     lpcbData, 250
      INVOKE     RegQuerySZ, addr rDEFh, addr szBuff
;      INVOKE     WinHelp, hwnd, addr szBuff, HELP_FINDER, 0
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr Misc
      INVOKE     WinHelp, hwnd, addr szBuff, HELP_KEY, addr Misc
         jmp     return0

idmabout:
         jmp     return0
;         mov     eax, offset AbVerDlg
;         mov     ebx, IDD_ABOUT
;         jmp     DialogBox
idmversion:
         mov     eax, offset AbVerDlg
         mov     ebx, IDD_VERSION
         jmp     DialogBox

wminitmenupopup:
         mov     eax, lparam
         cmp     eax, 0           ; Index 0 = file menu
          je     FileMenu
         cmp     eax, 1           ; Index 1 = edit menu
          je     EditMenu
         cmp     eax, 2           ; Index 2 = format menu
          je     FormatMenu
         cmp     eax, 6           ; Index 6 = project menu
          je     EditMenu
         jmp     return0
FileMenu:
         jmp     return0

EditMenu:
         jmp     EnaDis

FormatMenu:
;      INVOKE     UpdateFormatMenuItems, hwnd
         jmp     return0

wmsetfocus:
      .if !PathName
         INVOKE     SetFocus, hREdit
      .endif
         jmp     return0

wmnotify:
         mov     ebx, lparam    ; Get pointer to NMHDR
         mov     eax, (NMHDR ptr [ebx]).code
         cmp     eax, TTN_NEEDTEXT
          je     ttnneedtext
         cmp     eax, TBN_QUERYDELETE
          je     tbnquerydelete
         cmp     eax, TBN_GETBUTTONINFO
          je     tbngetbuttoninfo
         cmp     eax, TBN_QUERYINSERT
          je     tbnqueryinsert
         cmp     eax, TBN_TOOLBARCHANGE
          je     tbntoolbarchange
         cmp     eax, EN_MSGFILTER
          je     enmsgfilter
         cmp     eax, EN_SELCHANGE
          je     enselchange
         cmp     eax, EN_DROPFILES
          je     endropfiles
;cmp     eax, EN_REQUESTRESIZE
; je     enrequestresize
         jmp     defwndproc

endropfiles:
         mov     ebx, lparam     ; Address of ENDROPFILES structure
      INVOKE     DragQueryFile, (ENDROPFILES ptr [ebx]).hDrop, 0, addr PathName, lengthof PathName
         cmp     eax, 0          ; Chars from DragQueryFile <= 0
         jle     return0         ; Return 0 to ignore the drop
         mov     w5, 7
      INVOKE     PostMessage, hwnd, WM_OPENCOMMANDARGS, 0, 0 ; Open droped file
         jmp     return1         ; Return 1 to accept the drop

;enrequestresize:
;mov     ebx, lparam     ;address of REQRESIZE structure
;mov     eax, (REQRESIZE ptr [ebx]).rc.bottom
;jmp     return0

enmsgfilter:
         mov     ebx, lparam     ; Get pointer to msgfilter
         mov     eax, (MSGFILTER ptr [ebx]).msg
         cmp     eax, WM_MOUSEMOVE
          je     return0         ; Dont want these

enselchange:
      INVOKE     PostMessage, hwnd, WM_TRACKCURSOR, 0, 0
         ;call    SetTitle
         jmp     return0

tbnquerydelete:
         jmp     return1

tbngetbuttoninfo:
         jmp     return0

tbnqueryinsert:
         jmp     return1

tbncusthelp:
         jmp     defwndproc

tbntoolbarchange:
;Tell the toolbar to size itself
      INVOKE     SendMessage, hWndTool, TB_AUTOSIZE, 0, 0
         jmp     defwndproc

ttnneedtext:
         mov     eax, (NMHDR ptr [ebx]).idFrom ; Resource id
;Load the tip from STRINGTABLE
      INVOKE     LoadString, hInst, eax, addr szBuff, lengthof szBuff
         mov     ebx, lparam                   ; Get the buffer addr
         mov     (TOOLTIPTEXT ptr [ebx]).lpszText, offset szBuff
         jmp     return0

wmcreate:
;         mov     osv.dwOSVersionInfoSize, sizeof OSVERSIONINFO
;      INVOKE     GetVersionEx, addr osv
;         mov     eax, osv.dwBuildNumber ;dwPlatformId
;         and     eax, 0000ffffh  ; Low = BN, High = Major & Minor 
;         mov     osvBN, eax
                 ; 950  = Win95
                 ; 1111 = Win95 OSR2
                 ; 1998 = Win98
                 ; 1381 = WinNT v4
                 ; 2195 = Win2K
         mov     charF.cbSize, sizeof charF
        call     Initialize      ; Loads the registry

;=============================
; Create the status bar window
;=============================
         mov     hWndStat, 0     ; Zero handle
      INVOKE     CreateWindowEx, 0, addr StatClass, addr szNULL, WS_CHILD or WS_BORDER or WS_VISIBLE or SBS_SIZEGRIP,\
                 0, 0, 0, 0, hwnd, ID_STATUSBAR, hInst, 0  
         cmp     eax, 0          ; Handle null?
         jne     creatok          ;yes continue
      MsgBox     ERROR_CREATE_STATUSBAR
         jmp     wmcrexit
creatok:
         mov     hWndStat, eax   ; Save the handle to statusbar

;===================
; Create the toolbar
;===================
      INVOKE     CreateWindowEx, 0, addr ToolClass, 0,
                 WS_CHILD or WS_VISIBLE or TBSTYLE_TOOLTIPS or CCS_NOPARENTALIGN or CCS_NORESIZE or\
                 CCS_ADJUSTABLE or TBSTYLE_FLAT or WS_BORDER, 0, -2, 1200, 26, hwnd, ID_TOOLBAR, hInst, NULL
         cmp     eax, 0          ; Handle null?
         jne     tbok            ; yes continue
      MsgBox     ERROR_CREATE_TOOLBAR
         jmp     wmcrexit

tbok:
         mov     hWndTool, eax

      INVOKE     LoadBitmap, hInst, IDB_TOOLBAR
         mov     hTBBmp, eax
      INVOKE     SendMessage, hWndTool, TB_BUTTONSTRUCTSIZE, sizeof TBBUTTON, 0
         mov     tbab.hInst, 0
       MOVmd     tbab.nID, hTBBmp
      INVOKE     SendMessage, hWndTool, TB_ADDBITMAP, 22, addr tbab

      TBButt     hWndTool, 0,  IDM_NEW, 0
      TBButt     hWndTool, 1,  IDM_OPEN, 0
      TBButt     hWndTool, 2,  IDM_SAVE, 0
       TBSep     hWndTool
      TBButt     hWndTool, 3,  IDM_CUT, 0
      TBButt     hWndTool, 4,  IDM_COPY, 0
      TBButt     hWndTool, 5,  IDM_PASTE, 0
      TBButt     hWndTool, 6,  IDM_DEL, 0
      TBButt     hWndTool, 7,  IDM_UNDO, 0
      TBButt     hWndTool, 8,  IDM_REDO, 0
       TBSep     hWndTool
      TBButt     hWndTool, 9,  IDM_FINDTEXT, 0
      TBButt     hWndTool, 10, IDM_FINDNEXT, 0
      TBButt     hWndTool, 11, IDM_FINDPREV, 0
      TBButt     hWndTool, 12, IDM_REPLACETEXT, 0
       TBSep     hWndTool
      TBButt     hWndTool, 13, IDM_SHIFTR, 0
      TBButt     hWndTool, 14, IDM_SHIFTL, 0
      TBButt     hWndTool, 15, IDM_SHIFTTO, 0
       TBSep     hWndTool
      TBButt     hWndTool, 16, IDM_WORK, 0
      TBButt     hWndTool, 17, IDM_EWEDIT, 0
      TBButt     hWndTool, 18, IDM_RUN, 0
      TBButt     hWndTool, 19, IDM_DOS, 0
       TBSep     hWndTool
      TBButt     hWndTool, 20, IDM_SYNTAX, 0
      TBButt     hWndTool, 21, IDM_EXIT, 0

         mov     w4, WS_CHILD or WS_VISIBLE or TBSTYLE_TOOLTIPS or CCS_NOPARENTALIGN or \
                 CCS_NORESIZE or CCS_ADJUSTABLE or TBSTYLE_FLAT or TBSTYLE_LIST or CCS_NODIVIDER

      INVOKE     CreateWin, 0, addr ToolClass, w4,
                 548, 0, 95, 24, hWndTool, 72
         mov     w5, eax

      INVOKE     CreateWin, 0, addr ToolClass, w4,
                 630, 0, 1200, 24, hWndTool, 73
         mov     w6, eax

      INVOKE     lstrcpy, addr lf.lfFaceName, addr FontMS
         mov     lf.lfHeight, -12  ; -9 for win9x -12 for NT
         mov     lf.lfWeight, 600
      INVOKE     CreateFontIndirect, addr lf
         mov     mFont, eax
      INVOKE     SendMessage, w5, WM_SETFONT, mFont, 1
      INVOKE     SendMessage, w6, WM_SETFONT, mFont, 1

      INVOKE     SendMessage, w5, TB_BUTTONSTRUCTSIZE, sizeof TBBUTTON, 0
         mov     eax, 00100000h   ;00a0032h
      INVOKE     SendMessage, w5, TB_SETBITMAPSIZE, 0, eax
      INVOKE     SendMessage, w6, TB_BUTTONSTRUCTSIZE, sizeof TBBUTTON, 0
         mov     eax, 00100000h   ;00a0032h
      INVOKE     SendMessage, w6, TB_SETBITMAPSIZE, 0, eax

;       TBSep     w5
      INVOKE     SendMessage, w5, TB_ADDSTRING, 0, addr buttxt1
      TBButt     w5, 0, IDM_GOTOLINE, eax
      INVOKE     SendMessage, w5, TB_ADDSTRING, 0, addr buttxt2
      TBButt     w5, 0, 804, eax
      INVOKE     SendMessage, w6, TB_ADDSTRING, 0, addr buttxt3
      TBButt     w6, 0, IDM_ASSEMBLE, eax

;======================
; Create an EDIT window
;======================
         mov     w4, WS_CHILD or WS_VISIBLE or ES_LEFT or ES_MULTILINE or ES_NOHIDESEL or\
                 ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or ES_AUTOVSCROLL or WS_TABSTOP or\
                 WS_BORDER or WS_HSCROLL or ES_AUTOHSCROLL
;      .if !WWrap
;             or     w4, WS_HSCROLL or ES_AUTOHSCROLL
;      .endif

      INVOKE     CreateWin, 0, addr richedit, w4,
                 0, 0, 0, 0, hwnd, ID_EDITWINDOW

      .if !WWrap
         INVOKE     SendMessage, hREdit, EM_SETTARGETDEVICE, NULL, 444444
      .else
         INVOKE     SendMessage, hREdit, EM_SETTARGETDEVICE, NULL, 0
      .endif

;============================================
; Tell edit window what notifications to send
;============================================
      INVOKE     SendMessage, hREdit, EM_SETEVENTMASK, 0, ENM_CHANGE or ENM_SELCHANGE or ENM_MOUSEEVENTS or\
                 ENM_KEYEVENTS or ENM_DROPFILES ;or ENM_REQUESTRESIZE

;=================================
; Tell edit window to accept drops
;=================================
      INVOKE     DragAcceptFiles, hREdit, TRUE

;=================================
; Get the version of the RichEdit
;=================================
      INVOKE     SendMessage, hREdit, EM_SETFONTSIZE, 0, 0
         mov     REVer3, eax

;==============
; Initalization
;==============

;---------- [Build the Key Word List] ----------
        call     KeyWordList

         mov     ofn.lStructSize, sizeof ofn
         mov     eax, hWnd
         mov     ofn.hwndOwner, eax
         mov     eax, hInst
         mov     ofn.hInstance, eax
         mov     charF.cbSize, sizeof charF
         mov     charC.cbSize, sizeof charC
         mov     pf.cbSize, sizeof pf
         mov     sci.cbSize, sizeof sci
         mov     sci.fMask, SIF_ALL         ; Init. scroll info

      .if WWrap
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_CHECKED
      .endif
        call     SetCharFormatting
      INVOKE     CheckMenuItem, hMenu, IDM_RTFON, MF_CHECKED
      INVOKE     GetSubMenu, hMenu, 0       ; Get handle to 1st sub menu
      INVOKE     GetMenuItemCount, eax      ; Get count of items in the sub menu
         mov     MenuCnt, eax               ; Menu count for ProcessMRUFiles
;      INVOKE     SendMessage, hREdit, EM_SETEDITSTYLE, SES_EMULATESYSEDIT, SES_EMULATESYSEDIT
      INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
      INVOKE     ProcessMRUFiles, hwnd, 1, MenuCnt, 0, addr szRedit
          or     RTF, 1
          or     HighLite, 1
      INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_WORK, 1

initdoc:
;=======================================================================
; Determine state of initial document; new or open file specified as arg
;=======================================================================
        test     PathName, 0ffh
          jz     postnew
      INVOKE     PostMessage, hwnd, WM_OPENCOMMANDARGS, 0, 0 ; From file type association or cmd
         jmp     settimer

postnew:
      INVOKE     PostMessage, hwnd, WM_COMMAND, IDM_NEW, 0

settimer:
;=====================
; Finally, setup timer
;=====================
      INVOKE     SetTimer, hwnd, ID_TIMER1, 100, 0 ; Timer every mil second

wmcrexit:
         jmp     return0

wmtimer:
         cmp     wparam, ID_TIMER1 ; Is it our timer?
         jne     wmtimex           ; No, then exit
        call     fmtime            ; Format and display the time

wmtimex:
         jmp     return0

wmsize:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax

         cmp     hWndStat, 0       ; Is status valid?
          jz     wmsizexit         ; no, then exit
         mov     eax, lparam       ; Height/width of new window
         mov     ebx, eax
         and     ebx, 0000ffffh    ; ebx = LOWORD(lparam) = width
         shr     eax, 16           ; eax = HIWORD(lparam) = height
        push     TRUE              ; Repaint is true
        push     eax               ; Height
        push     ebx               ; Width
        push     eax               ; y
        push     0                 ; X
        push     hWndStat          ; Handle to statusbar
        call     MoveWindow        ; Adjust window
         mov     eax, lparam       ; Get width
        cwde                       ; Lowword
         shr     eax, 2            ; /4
         mov     ecx, eax          ; Save factor
         sub     eax, 30
         mov     parts, eax        ; Make part 1 1/4 the width
         add     eax, ecx
         add     eax, 75 ;60
         mov     [parts+4], eax    ; and also part2, .. etc
         add     eax, ecx
         sub     eax, 65 ;80
         mov     [parts+8], eax
         mov     [parts+12], -1    ; The last part extends to the end

      INVOKE     SendMessage, hWndStat, SB_SETPARTS, SBPARTS, addr parts
         cmp     hWndTool, 0       ; Is there a valid toolbar?
          jz     wmsizexit         ; no, then exit
      INVOKE     SendMessage, hWndTool, TB_AUTOSIZE, 0, 0
;
; move and size the EDIT window
;
      INVOKE     GetWindowRect, hWndTool, addr rect ; Rectangle of toolbar
         mov     eax, rect.bottom
         sub     eax, rect.top
        push     eax             ; Save height of toolbar
      INVOKE     GetWindowRect, hWndStat, addr rect ; Rectangle of statusbar
         mov     eax, rect.bottom
         sub     eax, rect.top   ; eax = height of statusbar
         pop     edx             ; edx = height of toolbar
         mov     ebx, lparam     ; Width of new client area
         and     ebx, 0ffffh     ; ebx = width
         mov     ecx, lparam
         shr     ecx, 16         ; Height of new client area
         sub     ecx, eax        ; Edit window - size of statusbar
         sub     ecx, edx        ; and - size of toolbar
         sub   edx, 2
         add   ecx, 2
      INVOKE     MoveWindow, hREdit, 0, edx, ebx, ecx, TRUE
      INVOKE     GetClientRect, hREdit, addr rect
         mov     rect.left, 10
         mov     rect.top, 4
         sub     rect.bottom, 4
      INVOKE     SendMessage, hREdit, EM_SETRECT, 0, addr rect

        call     ScreenLines
      .if MultInst == 1
         INVOKE     ShowWindow, hWnd, SW_RESTORE
      .endif

      .if hAsm
         INVOKE     SendMessage, hAsm, WM_INITDIALOG, 0, 0
      .endif

wmsizexit:
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         jmp     return0

wmmenuselect:
         mov     eax, wparam
         and     eax, 0ffff0000h
         cmp     eax, 0ffff0000h    ; Special case, menu canceled
         jne     wmms1
         mov     eax, lparam
         cmp     eax, 0
         jne     wmms1
      INVOKE     lstrcpy, addr szBuff, addr szFileSize  ; Display bytes read when exiting from menu
         jmp     wmms2

wmms1:
         mov     eax, wparam
        cwde
         add     eax, 10000        ; Resource base #
        push     eax
;      INVOKE     mciSendString, addr waveP1, 0, 0, 0   ; Disabled, because I can't free the resource
         pop     eax
      INVOKE     LoadString, hInst, eax, addr szBuff, lengthof szBuff
         cmp     eax, 0
         jne     wmms2
         mov     eax, offset szFileSize
         jmp     wmms3

wmms2:
         mov     eax, offset szBuff

wmms3:
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, eax
         jmp     EnaDis

wmtrackcursor:
         jmp     EnaDis

EnaDis:
        call     EnableDisableEditMenu
         jmp     return0

wmclose:
      INVOKE     CheckSav, hwnd
         cmp     eax, IDCANCEL
          je     return0

         cmp     szWorkWin, 0
          je     NoWork
      INVOKE     LoadLibrary, addr LibNameW
      .if eax
            mov     w3, eax
         INVOKE     GetProcAddress, w3, addr FuncNameWC
         .if eax
               mov     ebx, 4
              push     ebx
              call     eax
         .else
         .endif
         INVOKE     FreeLibrary, w3
      .else
      .endif

NoWork:
      INVOKE     DestroyWindow, hREdit
      INVOKE     DestroyWindow, hwnd
         jmp     return0

wmqueryendsession:
      INVOKE    CheckSav, hwnd
         cmp    eax, IDCANCEL
          je    return0
         jmp    return1

defwndproc:
      INVOKE     DefWindowProc, hwnd, wmsg, wparam, lparam
         jmp     finish

wmdestroy:
      .if hsMem
         INVOKE     GlobalUnlock, fsMem
         INVOKE     GlobalFree, hsMem
      .endif

      INVOKE     GetExitCodeProcess, hProcessWA, addr ExitCode 
      .if ExitCode == STILL_ACTIVE 
         INVOKE     TerminateProcess, hProcessWA, 0 
      .endif 
      INVOKE     CloseHandle, hProcessWA

      INVOKE     GetExitCodeProcess, hProcessB, addr ExitCode 
      .if ExitCode == STILL_ACTIVE 
         INVOKE     TerminateProcess, hProcessB, 0 
      .endif 
      INVOKE     CloseHandle, hProcessB

      INVOKE     DeleteObject, hBR
      INVOKE     DeleteObject, hTBBmp
      INVOKE     DeleteObject, dFont
      INVOKE     DeleteObject, hFont
      INVOKE     DeleteObject, mFont
      INVOKE     DeleteObject, pFont
      INVOKE     DeleteObject, tFont

      INVOKE     KillTimer, hwnd, ID_TIMER1
      INVOKE     WinHelp, hwnd, addr szHelp, HELP_QUIT, 0
         cmp     SaveWhen, 2
          je     ShutDown
        call     RegSave

ShutDown:
      INVOKE     PostQuitMessage, 0
         jmp     return0

return1:
         mov     eax, 1
         jmp     finish

return0:
         xor     eax, eax

finish:
         ret
WndProc  ENDP

;=========================================================================
; Create Window PROCEDURE                                                *
;=========================================================================
CreateWin PROC   StyleEX:DWORD, classN, Style, x, y, wd, ht, hwnd, ID

      INVOKE     CreateWindowEx, 0, classN, 0, Style, x, y, wd, ht, hwnd, ID, hInst, 0
         cmp     eax, 0        ; Create go ok?
         jne     winok         ; Yes continue
      MsgBox     ERROR_CREATE_EDITWINDOW
         jmp     CreateRet

winok:
         mov     ecx, hwnd
      .if ecx == hWndTool
            jmp     CreateRet
      .endif
         mov     hREdit, eax
      INVOKE     SetWindowLong, hREdit, GWL_WNDPROC, RichEditProc
         mov     lpRichEdit, eax
      INVOKE     SendMessage, hREdit, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
      INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 8000000

      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
;xor     eax, eax
;mov     al, charF.bCharSet
;DSPValue hWnd, eax
         mov     al, charF.bCharSet
         mov     lf.lfCharSet, al
         mov     al, charF.bPitchAndFamily
         mov     lf.lfPitchAndFamily, al

      .if FontName == 'C' && FontName+2 == 'u' && FontName+8 == 'N'
         INVOKE     lstrcpy, addr lf.lfFaceName, addr FontName  ;FontNameDlg
      .else
         INVOKE     lstrcpy, addr lf.lfFaceName, addr FontFS
      .endif
         mov     lf.lfHeight, -12
         mov     lf.lfWeight, 500
      INVOKE     CreateFontIndirect, addr lf
         mov     tFont, eax    ; Dialog font
INVOKE     lstrcpy, addr lf.lfFaceName, addr FontMS
      INVOKE     CreateFontIndirect, addr lf
         mov     dFont, eax    ; Dialog font

;---------- [FontName will be Fixedsys the first time the program is loaded] ----------
      INVOKE     lstrcpy, addr lf.lfFaceName, addr FontName
         mov     lf.lfHeight, 40  ;-12
         mov     lf.lfWeight, 600
      INVOKE     CreateFontIndirect, addr lf
         mov     pFont, eax    ; Printer font

;*********************************
       MOVmd     lf.lfHeight, FontHeight
       MOVmd     lf.lfWeight, FontWeight
      INVOKE     CreateFontIndirect, addr lf
         mov     hFont, eax    ; Text font
;        call     ScreenLines
;*********************************

      INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1  ;$$$$$$$$$$$$$$$$$$$$

CreateRet:
         ret
CreateWin ENDP

;=========================================================================
; Create ComboBox PROCEDURE                                              *
;=========================================================================
CreateCombo PROC   StyleEX:DWORD, classN, Style, x, y, wd, ht, hwnd, ID
      INVOKE     CreateWindowEx, 0, classN, 0, Style, x, y, wd, ht, hwnd, ID, hInst, 0
         ret
CreateCombo ENDP

;=========================================================================
; Display Save Settings Dialog PROCEDURE                                 *
;=========================================================================
SavSetDlg PROC    hdlg:DWORD, wmsg, wparam, lparam

      .if wmsg == WM_INITDIALOG
         .if (SetFlags & 1)
            INVOKE     GetDlgItem, hdlg, sb1                           ; Get Pos check
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Pos to checked
         .endif
         .if (SetFlags & 2)
            INVOKE     GetDlgItem, hdlg, sb2                           ; Get Setup check
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Setup to checked
         .endif
         .if (SetFlags & 4)
            INVOKE     GetDlgItem, hdlg, sb3                           ; Get Syntax check
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Syntax to checked
         .endif
         .if (SetFlags & 8)
            INVOKE     GetDlgItem, hdlg, sb4                           ; Get Char check
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Char to checked
         .endif

          MOVmd     w1, sb4
            mov     eax, SaveWhen
            add     w1, eax
         INVOKE     GetDlgItem, hdlg, w1                               ; Get Save check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets Save to checked
      .endif
      .if wmsg != WM_COMMAND     ; See if msg is a command
            jmp     SavSetDone
      .endif
         mov     eax, wparam     ; Otherwise, see if its CANCEL
         cmp     eax, IDCANCEL   ; That was pressed
          je     CancelOut       ; and if not either of these
      .if eax == B1
         .if SaveWhen == 2
              call     RegSave
         .else
            INVOKE     RegSet, addr szSaveWhen, SaveWhen
         .endif
            jmp     CancelOut
      .endif

         and     SetFlags, 0
      INVOKE     IsDlgButtonChecked, hdlg, sb1    ; Save window Pos and size settings
      .if eax
             or     SetFlags, 1
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb2    ; Save character format settings
      .if eax
             or     SetFlags, 2
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb3    ; Save syntax settings
      .if eax
             or     SetFlags, 4
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb4    ; Save setup settings
      .if eax
             or     SetFlags, 8
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb5    ; Save on every exit
      .if eax
            mov     SaveWhen, 1
      .endif

      INVOKE     IsDlgButtonChecked, hdlg, sb6    ; Save now
      .if eax
            mov     SaveWhen, 2
      .endif

         jmp     SavSetDone
CancelOut:
        push     wparam             ; Terminate with wparam as the return
        push     hdlg               ; handle of the dialog
        call     EndDialog          ; End the dialog
         mov     eax, TRUE          ; Return
         jmp     SavSetRet          ; with TRUE
SavSetDone:
         mov     eax, FALSE         ; Return with FALSE
SavSetRet:
         ret                        ; Return to caller
SavSetDlg ENDP

;=========================================================================
; Initialization PROCEDURE                                               *
;=========================================================================
Initialize PROC
LOCAL    hRegI:DWORD, FirstFlg   ;, hKey
LOCAL    szBuffer[1024]:BYTE

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegI, addr lpdwDisp

         mov     lpcbData, 4
         mov     eax, offset szSetFlags
         lea     ebx, SetFlags
      INVOKE     RegQueryValueEx, hRegI, addr szSetFlags, 0, addr lpType, addr SetFlags, addr lpcbData
         cmp     eax, 0
          je     ChkWordList
         mov     FirstFlg, 4

;---------- [First time the program is loaded] ----------
      INVOKE     RegSetValueEx, hRegI, addr rDEFr, 0, REG_SZ, addr RootDir, 250
      INVOKE     lstrcpy, addr FontName, addr FontFS ;FontCN
      INVOKE     lstrlen, addr FontName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegI, addr szFont, 0, REG_SZ, addr FontName, lpcbData
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF

;mov     charF.bCharSet, ANSI_CHARSET
;mov     charF.bPitchAndFamily, FIXED_PITCH or FF_MODERN
;mov     lf.lfCharSet, ANSI_CHARSET
;mov     lf.lfPitchAndFamily, FIXED_PITCH or FF_MODERN;

      INVOKE     RegSet, addr rTC, TextC
      INVOKE     RegSet, addr rTBGC, TextBGC
      INVOKE     RegSet, addr rBC, BackGC

      INVOKE     RegSet, addr szBuildC, Build
      INVOKE     RegSet, addr szPoint, PointSize
      INVOKE     RegSet, addr szFontH, FontHeight
      INVOKE     RegSet, addr szFontW, FontWeight
      INVOKE     RegSet, addr szMask, 0feffffffh
      INVOKE     RegSet, addr szEffects, 0
      INVOKE     RegSet, addr szSaveWhen, SaveWhen
      INVOKE     RegSet, addr szSetFlags, SetFlags
      INVOKE     RegSet, addr szWordWrap, WWrap
         lea     ebx, offset szCustClrs
         lea     ecx, CustClrs
      INVOKE     RegSetValueEx, hRegI, ebx, 0, REG_BINARY, ecx, 64


ChkWordList:

;---------- [Make sure all of the syntax keywords have been stored] ----------
         and     w4, 0
      .while (w4 < 12)
            mov     eax, w4
           imul     eax, 4
          MOVmd     w5, KeyWord[eax]       ; Pointer to szKeywxx array
          MOVmd     w6, KeyArray[eax]
            mov     lpcbData, 1023
         INVOKE     RegQueryValueEx, hRegI, w5, 0, addr lpType, addr szBuffer, addr lpcbData
         .if sw3 != 7                      ; 7 = restore default keywords
               cmp     eax, 0
                je     ChkNext
         .endif
         INVOKE     lstrlen, w6
            mov     lpcbData, eax
         INVOKE     RegSetValueEx, hRegI, w5, 0, REG_SZ, w6, lpcbData

ChkNext:
            inc     w4
      .endw
.if sw3 == 7
      jmp     GetOut
.endif

;---------- [Store the syntax colors] ----------
      .if sw3 != 8                        ; 8 = restore default colors
            cmp     FirstFlg, 4
            jne     NotFirst
      .endif
         and     w4, 0
      .while (w4 < 16)
            mov     eax, w4
           imul     eax, 4
            lea     ebx, offset szColor01
            lea     ecx, DefColor01[eax]
         INVOKE     RegSetValueEx, hRegI, ebx, 0, REG_DWORD, ecx, 4
            inc     w4
            mov     eax, w4
            inc     eax
         INVOKE     BaseAscii, eax, addr Misc, 2, 10, 0, 1, 0
            mov     al, byte ptr Misc
            mov     byte ptr szColor01+5, al
            mov     al, byte ptr Misc+1
            mov     byte ptr szColor01+6, al
      .endw
         mov     byte ptr szColor01+5, '0'
         mov     byte ptr szColor01+6, '1'

;---------- [Retrive the entries from the  registry] ----------
NotFirst:
         and     w4, 0
      .while (w4 < 16)
            mov     eax, w4
           imul     eax, 4
            lea     ebx, offset szColor01
            lea     ecx, Color01[eax]
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hRegI, ebx, 0, addr lpType, ecx, addr lpcbData
            inc     w4
            mov     eax, w4
            inc     eax
         INVOKE     BaseAscii, eax, addr Misc, 2, 10, 0, 1, 0
            mov     al, byte ptr Misc
            mov     byte ptr szColor01+5, al
            mov     al, byte ptr Misc+1
            mov     byte ptr szColor01+6, al
      .endw
         mov     byte ptr szColor01+5, '0'
         mov     byte ptr szColor01+6, '1'
.if sw3 == 8
      jmp     GetOut
.endif
         mov     lpcbData, 64
      INVOKE     RegQueryValueEx, hRegI, addr szCustClrs, 0, addr lpType, addr CustClrs, addr lpcbData

         mov     lpcbData, 50
      INVOKE     RegQuerySZ, addr szFont, addr FontName

      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName

      INVOKE     RegQuery, addr szSaveWhen, SaveWhen
         mov     SaveWhen, eax
      INVOKE     RegQuery, addr szSetFlags, SetFlags
         mov     SetFlags, eax
      INVOKE     RegQuery, addr szWordWrap, WWrap
         mov     WWrap, eax

         mov     ecx, 19
         lea     eax, offset rTS1
         mov     w5, eax
         lea     eax, TS1
         mov     w6, eax
      .while (ecx)
            mov     lpcbData, 4
           push     ecx
         INVOKE     RegQueryValueEx, hRegI, w5, 0, addr lpType, w6, addr lpcbData
            pop     ecx
            add     w5, 14
            add     w6, 4
            dec     ecx
      .endw

      INVOKE     RegQuery, addr szBuildC, Build
         mov     Build, eax
      INVOKE     RegQuery, addr szPoint, PointSize
         mov     PointSize, eax
      INVOKE     RegQuery, addr szFontH, FontHeight
         mov     FontHeight, eax
      INVOKE     RegQuery, addr szFontW, FontWeight
         mov     FontWeight, eax
;       MOVmd     charF.yHeight, PointSize

      .if !sw3
           call     TabStop
      .endif

      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
;         mov     lpcbData, 50
;      INVOKE     RegQueryValueEx, hRegI, addr rDEFw, 0, addr lpType, addr szBuff, addr lpcbData
;      INVOKE     lstrcpy, addr waveP1, addr P
;      INVOKE     lstrcat, addr waveP1, addr szBuff

GetOut:
      INVOKE     RegCloseKey, hRegI
         and     sw3, 0
           ret
Initialize ENDP

;=========================================================================
; Setup PROCEDURE                                                        *
;=========================================================================
Setup PROC  uses ebx esi edi  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    szSetUp[256]:BYTE

      .if wmsg == WM_INITDIALOG
          MOVmd     hSUDlg, hdlg
         .if Build
               INVOKE     GetDlgItem, hdlg, cb1                           ; Get Build check
               INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Build to checked
         .endif

         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
      .endif
         cmp     wmsg, WM_COMMAND   ; Is message a WM_COMMAND?
         jne     ThatsAll           ; No, then just return
         mov     eax, wparam
         and     eax, 0000ffffh
      .if eax == 1500 && w7 == 0
            mov     edi, tb1
            xor     esi, esi
            mov     ecx, 14

TabS:
           push     ecx
         INVOKE     SetDlgItemInt, hdlg, edi, TS1[esi], 0
            pop     ecx
            inc     edi
            add     esi, 4
         loopnz     TabS

            mov     eax, 1599
            add     eax, SPACE
         INVOKE     GetDlgItem, hdlg, eax
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets SHIFT spaces
         INVOKE     SetDlgItemInt, hdlg, SH, SHIFT, 0

         mov     w4, E1
         lea     eax, offset rDEFr
         mov     w5, eax
         lea     eax, offset szBuff
         mov     w6, eax
      .while (w4 < E10)
            mov     lpcbData, 250
         INVOKE     RegQueryValueEx, hReg, w5, 0, addr lpType, w6, addr lpcbData
         .if eax == ERROR_SUCCESS
            INVOKE     SetDlgItemText, hdlg, w4, w6
         .endif
            add     w4, 1
            add     w5, 19
      .endw

            mov     w7, 1
         MOVmd      sSPACE, SPACE
      .elseif eax > 1599 && eax < 1620
            mov     sSPACE, eax
            sub     sSPACE, 1599
      .endif

      INVOKE     lstrcpy, addr szSetUp, addr Patn
         mov     eax, wparam

      .if eax == 801
;jmp     NotNow
         INVOKE     LoadCursor, NULL, IDC_WAIT
         INVOKE     SetCursor, eax
         INVOKE     LoadLibrary, addr LibNameS
         .if !eax
            MsgBox     ERROR_MISSING_DLL, LibNameS, MB_OK or MB_ICONERROR
               jmp     ThatsAll
         .endif
            mov     w2, eax
           push     E1
           push     hdlg
           push     hWnd
         INVOKE     GetProcAddress, w2, addr FuncNameS
           call     eax
         INVOKE     FreeLibrary, w2
         INVOKE     LoadCursor, NULL, IDC_ARROW
         INVOKE     SetCursor, eax
            mov     Hold, 12
            jmp     UpdatePaths
NotNow:
      .endif

         cmp     eax, REPLACE          
          je     Update
         mov     eax, wparam
      .if eax > B0 && eax < B11     ; Directory buttons
         INVOKE     lstrcpy, addr szFilter, addr Patn
            jmp     GetDir
      .endif
         cmp     eax, IDHELP
         jne     CkCan
      INVOKE     lstrcpy, addr WorkBuff, addr RootDir
      INVOKE     lstrcat, addr WorkBuff, addr szHelp
      INVOKE     WinHelp, hWnd, addr WorkBuff, HELP_KEY, addr HelpKeyS
         jmp     ThatsAll

CkCan:
         cmp     eax, IDCANCEL
          je     Destroy
         jmp     ThatsAll

GetDir:
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     edi, offset szFilter
         rep     movsb
      INVOKE     GetCurrentDirectory, lengthof CurDir, addr CurDir
         lea     eax, szSetUp
         mov     ofn.lpstrFile, eax
         mov     ofn.nMaxFile, lengthof szSetUp
         mov     ofn.lpstrInitialDir, offset CurDir
         mov     ofn.lpstrTitle, offset szOpenTitle
         mov     ofn.Flags, OFN_NOVALIDATE
      INVOKE     GetOpenFileName, addr ofn
         cmp     eax, FALSE         ; Cancel'ed or error occurred
          je     ThatsAll
         xor     ebx, ebx
         mov     bx, ofn.nFileOffset
         inc     ebx
      INVOKE     lstrcpyn, addr WorkBuff, ofn.lpstrFile, ebx
         mov     eax, wparam
         sub     eax, 100
      .if eax == E8 || eax == E9 ;|| eax == E10
         INVOKE     SetDlgItemText, hdlg, eax, ofn.lpstrFile
            jmp     ThatsAll
      .else
         INVOKE     SetDlgItemText, hdlg, eax, addr WorkBuff
            jmp     ThatsAll
      .endif

Update:
         and     Build, 0
      INVOKE     IsDlgButtonChecked, hdlg, cb1    ; Save Build
      .if eax
            mov     Build, 1
      .endif
      INVOKE     RegSet, addr szBuildC, Build

       MOVmd     SPACE, sSPACE
      INVOKE     GetDlgItemInt, hdlg, SH, 0, 0
         mov     SHIFT, eax

         mov     edi, tb1
         xor     esi, esi
         mov     ecx, 14

TabG:
        push     ecx
      INVOKE     GetDlgItemInt, hdlg, edi, 0, 0
         pop     ecx
         mov     TS1[esi], eax
         inc     edi
         add     esi, 4
      loopnz     TabG

UpdatePaths:
         mov     w4, E1
         lea     eax, offset rDEFr
         mov     w5, eax
         lea     eax, offset szBuff
         mov     w6, eax
      .while (w4 < E10)
         INVOKE     GetDlgItemText, hdlg, w4, w6, 250
         INVOKE     lstrlen, w6
         .if eax
            INVOKE     RegSetValueEx, hReg, w5, 0, REG_SZ, w6, eax
         .endif
            add     w4, 1
            add     w5, 19
      .endw
      .if Hold == 12              ; From copy files
            and     Hold, 0
            jmp     ThatsAll
      .endif

         mov     ecx, 19
         lea     eax, offset rTS1
         mov     w5, eax
         lea     eax, TS1
         mov     w6, eax
      .while (ecx)
           push     ecx
         INVOKE     RegSetValueEx, hReg, w5, 0, REG_DWORD, w6, 4
            pop     ecx
            add     w5, 14
            add     w6, 4
            dec     ecx
      .endw
      .if Hold == 3 || Hold == 4  ; 3 is from ERRSetup, 4 is from close
            jmp     Destroy
      .endif
      INVOKE     lstrlen, addr FontName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hReg, addr szFont, 0, REG_SZ, addr FontName, lpcbData
        call     TabStop
        call     Initialize

Destroy:
         and     hSUDlg, 0
      INVOKE     RegCloseKey, hReg
      INVOKE     DestroyWindow, hdlg    ; End the dialog
      .if Hold == 3
         INVOKE     SendMessage, hWnd, WM_COMMAND, w3, 0
      .elseif Hold == 4
         INVOKE     SendMessage, hWnd, WM_CLOSE, 0, 0
      .endif
         mov     eax, TRUE              ; Return
         jmp     SelectRet              ; with TRUE

ThatsAll:
         mov     eax, FALSE             ; Return with FALSE

SelectRet:
         ret
Setup ENDP

;=========================================================================
; Set scroll position                                                    *
;=========================================================================
SetScroll PROC
         mov     eax, SavScroll
         shl     eax, 16
         mov     ecx, SB_THUMBPOSITION
         mov     ax, cx
      INVOKE     SendMessage, hREdit, WM_VSCROLL, eax, 0
         ret
SetScroll ENDP

;=========================================================================
; Tab Stop PROCEDURE                                                     *
;=========================================================================
TabStop PROC
LOCAL    N:DWORD

         mov     pf.cbSize, sizeof pf
         mov     pf.dwMask, PFM_TABSTOPS
         mov     pf.cTabCount, MAX_TAB_STOPS
      INVOKE     lstrcpy, addr pf.rgxTabs, addr TabStops
         xor     eax, eax
         xor     edx, edx
         and     N, 0
         mov     ecx, 32

TabW:
         mov     eax, TS1[edx]
      .if edx > 36
            add     N, 5
            mov     eax, TS1[36]
            add     eax, N
      .endif 
         mov     TabStops[edx], eax
      .if eax > 0
            dec     eax
      .endif
         mov     ebx, eax
        imul     ebx, 105  ;(8 = 105) (9 = 105) (10 = 120) (11 = 135) (12 = 150) twips
         mov     pf.rgxTabs[edx], ebx
         add     edx, 4
      loopnz     TabW

      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
      INVOKE     SendMessage, hREdit, EM_SETPARAFORMAT, 0, addr pf
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
         ret
TabStop ENDP

;=========================================================================
; CommonDlg Print heading and Find Line/Proc PROCEDURE                   *
;=========================================================================
CommonDlg PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    Clear[256]:BYTE

         cmp     wmsg, WM_INITDIALOG    ; If message is not INITDIALOG then
         jne     NotInit                ; check wmsg
         and     sw3, 0
      INVOKE     GetDlgItem, hdlg, E1
      INVOKE     SetFocus, eax
         cmp     sw2, 6
         jne     GetProcs
      INVOKE     GetDlgItem, hdlg, cb1                              ; Get handle PrtHead
      .if PrtHead == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets PrtHead to checked
      .else
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0 ; Sets PrtHead to unchecked
      .endif
      INVOKE     GetDlgItem, hdlg, cb2                              ; Get handle PrtColor
      .if PrtColor == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets PrtColor to checked
      .else
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0 ; Sets PrtColor to unchecked
      .endif
      .if PH
            mov     eax, rb1
            add     eax, PH
            dec     eax
         INVOKE     GetDlgItem, hdlg, eax                           ; Get handle Heading Type
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets Heading Type to checked
      .endif
         jmp     DlgDone               ; Go and return

GetProcs:
      INVOKE     CreateCombo, 0, addr combobox, WS_CHILD or WS_VISIBLE or WS_VSCROLL or\
                 CBS_HASSTRINGS or CBS_DROPDOWN or CBS_SORT, 59, 39, 196, 210, hdlg, 85 ;162
         mov     hMnem, eax

      INVOKE     SendMessage, hMnem, WM_SETFONT, dFont, 1
      INVOKE     SendMessage, hMnem, CB_SETITEMHEIGHT, -1, 14       ; Selection field
      INVOKE     SendMessage, hMnem, CB_SETITEMHEIGHT, 0, 13        ; List items
      .if ExtType == 'a' && ExtType + 1 == 's' && ExtType + 2 == 'm'
           call     BuildProcs
      .else
            jmp     DlgDone            ; Go and return
      .endif

NotInit:
         cmp     wmsg, WM_COMMAND      ; Is message a WM_COMMAND?
         jne     DlgDone               ; No, then just return
         mov     eax, wparam
         cmp     eax, IDCANCEL
          je     CancleIt

         mov     ebx, eax
         shr     ebx, 16

;---------- [Check for proc selection] ----------
      .if ebx == CBN_SELCHANGE
         INVOKE     SendMessage, hMnem, CB_GETCURSEL, 0, 0
            mov     ebx, eax
         INVOKE     SendMessage, hMnem, CB_GETLBTEXT, ebx, addr szFind
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
            lea     eax, offset szFind
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD, offset ft
            cmp     eax, -1            ; Nothing found?
             je     DlgDone
            jmp     DoCenter
      .endif

         cmp     eax, IDOK
         jne     DlgDone
         cmp     sw2, 6
          je     Heading
      INVOKE     GetDlgItemInt, hdlg, E1, 0, 0
         dec     eax
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, eax, 0

DoCenter:
         mov     cr.cpMin, eax
         mov     SBook, eax
         inc     eax
         mov     cr.cpMax, eax
         mov     EBook, eax
         mov     EPos, eax
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
        call     CenterSel
         and     EPos, 0
         jmp     CancleIt

Heading:
      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
         mov     sw3, 1
         mov     PH, 0
         and     PrtHead, 0
         and     PrtColor, 0
      INVOKE     IsDlgButtonChecked, hdlg, cb1
         mov     PrtHead, eax
      INVOKE     IsDlgButtonChecked, hdlg, cb2
         mov     PrtColor, eax
         mov     ebx, hHead
      INVOKE     lstrcpy, ebx, addr Clear
      INVOKE     GetDlgItemText, hdlg, IDC_EDIT1, addr szBuff, lengthof szBuff
      INVOKE     IsDlgButtonChecked, hdlg, rb1
      .if eax
            mov     PH, 1
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb2
      .if eax
            mov     PH, 2
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb3
      .if eax
            mov     PH, 3
      .endif
      INVOKE     lstrlen, addr szBuff
      .if eax || PH > 0
            mov     ebx, hHead
         .if eax
            INVOKE     lstrcpy, ebx, addr szBuff
         .elseif PH == 1
            INVOKE     lstrcpy, ebx, addr Clear
         .elseif PH == 2
            INVOKE     lstrcpy, ebx, addr FileName
         .elseif PH == 3
            INVOKE     lstrcpy, ebx, addr PathName
         .endif
      .endif

CancleIt:
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE             ; Return
         jmp     DlgRet                ; with TRUE

DlgDone:
         mov     eax, FALSE            ; Return with FALSE
DlgRet:
         ret
CommonDlg ENDP

;=========================================================================
; Load the Proc combobox PROCEDURE                                       *
;=========================================================================
BuildProcs PROC uses ebx edx esi edi

         and     cnt, 0
         mov     ft.chrg.cpMin, 0
         mov     ft.chrg.cpMax, -1
         lea     eax, offset szCode
         mov     ft.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD, offset ft
         cmp     eax, -1                 ; Nothing found?
          je     retBuildProcs
         mov     ft.chrg.cpMin, eax
         lea     eax, offset szProc
         mov     ft.lpstrText, eax

LoopF:
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD, offset ft
         cmp     eax, -1                 ; Nothing found?
          je     retBuildProcs

        push     eax
         mov     ft.chrg.cpMin, eax      ; Start of PROC
         sub     eax, 50
         mov     ft.chrg.cpMax, eax
         lea     eax, offset szCR
         mov     ft.lpstrText, eax

      INVOKE     SendMessage, hREdit, EM_FINDTEXT, 0, offset ft
         cmp     eax, -1                 ; Nothing found?
          je     NoCR
         inc     eax
         mov     tr.chrg.cpMin, eax      ; Start of the proc name
         pop     eax
        push     eax
         mov     tr.chrg.cpMax, eax
         lea     eax, offset szBuff
         mov     tr.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_GETTEXTRANGE, 0, addr tr

         pop     eax
        push     eax
         add     eax, 4
         mov     tr.chrg.cpMax, eax
         lea     eax, offset WorkBuff
         mov     tr.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_GETTEXTRANGE, 0, addr tr
        
         xor     ebx, ebx
      .while (eax)
           .if byte ptr szBuff[ebx] == ' '
                 mov     byte ptr szBuff[ebx], 0
              .break
           .endif
            inc     ebx
            dec     eax
      .endw
      
         pop     eax
        push     eax
         mov     ft.chrg.cpMin, eax

DoAgain:
      .if byte ptr szBuff == ';'
            jmp     NoCR
      .endif
         mov     ft.chrg.cpMax, -1
         lea     eax, offset szBuff
         mov     ft.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD or FR_MATCHCASE, offset ft
         cmp     eax, -1                 ; Nothing found?
          je     NoCR
         mov     ft.chrg.cpMin, eax
         add     eax, 50
      .if eax > bytesread
            mov     eax, bytesread
      .endif
         mov     ft.chrg.cpMax, eax
         lea     eax, offset szEndP
         mov     ft.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD, offset ft
      .if eax == -1                      ; Nothing found?
            inc     ft.chrg.cpMin
            jmp     DoAgain
      .endif
         pop     ebx
        push     eax
      INVOKE     SendMessage, hMnem, CB_ADDSTRING, 0, offset WorkBuff
         add     cnt, 1
NoCR:
         pop     eax
         add     eax, 5
      .if eax >= bytesread
            jmp     retBuildProcs
      .endif
         mov     ft.chrg.cpMin, eax
         mov     ft.chrg.cpMax, -1
         lea     eax, offset szProc
         mov     ft.lpstrText, eax
         jmp     LoopF

retBuildProcs:
      INVOKE     SendMessage, hMnem, CB_SETCURSEL, 0, 0
;DSPValue hWnd, cnt  ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
         ret
BuildProcs ENDP

;=========================================================================
; Change Font PROCEDURE                                                  *
;=========================================================================
Font  PROC
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
      INVOKE     GetDC, hWnd
        push     eax
      INVOKE     GetDeviceCaps, eax, LOGPIXELSY  ; = 96    eg.
         mov     TempWord1, eax
         pop     eax
      INVOKE     ReleaseDC, hWnd, eax
         mov     eax, charF.yHeight              ; = 180   eg.
         mul     TempWord1
         mov     ecx, 1440
         div     ecx
         neg     eax
         mov     lf.lfHeight, eax                ; = -12   eg.
         mov     lf.lfWeight, FW_NORMAL
        test     charF.dwEffects, CFE_BOLD       ; = 500   eg.
          jz     NotBold
         mov     lf.lfWeight, FW_BOLD

NotBold:
         mov     lf.lfItalic, FALSE
        test     charF.dwEffects, CFE_ITALIC
          jz     NotItalic
         mov     lf.lfItalic, TRUE

NotItalic:
         mov     lf.lfUnderline, FALSE
        test     charF.dwEffects, CFE_UNDERLINE
          jz     NotUnder
         mov     lf.lfUnderline, TRUE

NotUnder:
         mov     lf.lfStrikeOut, FALSE
        test     charF.dwEffects, CFE_STRIKEOUT
          jz     NotStrike
         mov     lf.lfStrikeOut, TRUE

NotStrike:
         mov     al, charF.bCharSet
         mov     lf.lfCharSet, al
         mov     al, charF.bPitchAndFamily
         mov     lf.lfPitchAndFamily, al
      INVOKE     lstrcpy, addr lf.lfFaceName, addr charF.szFaceName
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' || !PathName
          MOVmd     cf.rgbColors, charF.crTextColor 
      .else
          MOVmd     cf.rgbColors, TextC 
      .endif
         mov     cf.lStructSize, sizeof cf
       MOVmd     cf.hwndOwner, hWnd
       MOVmd     cf.hInstance, hInst
         mov     cf.lpLogFont, offset lf
         mov     cf.Flags, CF_SCREENFONTS or CF_INITTOLOGFONTSTRUCT or CF_FORCEFONTEXIST or CF_EFFECTS
      INVOKE     ChooseFont, addr cf   ; Invoke common ChooseFont dialog
         cmp     eax, FALSE
          je     FontRet
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
         mov     charF.dwEffects, 0    ; Reset the effects, they will all be specified
          or     charF.dwMask, CFM_STRIKEOUT
         mov     al, lf.lfStrikeOut
         cmp     al, FALSE
          je     nostrik
          or     charF.dwEffects, CFE_STRIKEOUT

nostrik:
          or     charF.dwMask, CFM_ITALIC
         mov     al, lf.lfItalic
         cmp     al, FALSE
          je     noital
          or     charF.dwEffects, CFE_ITALIC

noital:
          or     charF.dwMask, CFM_UNDERLINE
         mov     al, lf.lfUnderline
         cmp     al, FALSE
          je     nounder
         xor     charF.dwEffects, CFE_UNDERLINE

nounder:
          or     charF.dwMask, CFM_BOLD
         mov     eax, lf.lfWeight
         cmp     eax, FW_BOLD          ; 400 = FW_NORMAL 700 = FW_BOLD
          jl     nobold
          or     charF.dwEffects, CFE_BOLD

nobold:
         mov     eax, cf.rgbColors
         mov     charF.crTextColor, eax
;         mov     TextC, eax
       MOVmd     charF.crBackColor, TextBGC
      .if HighLite
           MOVmd     charF.crBackColor, BackGC
      .endif
         mov     al, lf.lfCharSet
         mov     charF.bCharSet, al
         mov     al, lf.lfPitchAndFamily
         mov     charF.bPitchAndFamily, al
          or     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     eax, cf.iPointSize
         shl     eax, 1                ; Convert from 1/10 pt to twips (which is points*20)
         mov     charF.yHeight, eax

      .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f' || RTF == 0
            mov     PointSize, eax
          MOVmd     FontHeight, lf.lfHeight
          MOVmd     FontWeight, lf.lfWeight
          MOVmd     TextC, cf.rgbColors
         INVOKE     lstrcpy, addr FontName, addr lf.lfFaceName
         INVOKE     CreateFontIndirect, addr lf
            mov     hFont, eax

;INVOKE     MessageBox, NULL, addr FontName, addr pTitle, MB_OK  ;^^^^^^^^^^^^^^^^^^^^^^

         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
         INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
          MOVmd     SavScroll, sci.nPos
         INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1  ;$$$$$$$$$$$$$$$$$$$$
           call     SetScroll
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      .endif
      INVOKE     lstrcpy, addr charF.szFaceName, addr lf.lfFaceName

FontRet:
         ret                           ; Return
Font    ENDP

;=========================================================================
; Color PROCEDURE                                                        *
;=========================================================================
Color    PROC
         mov     cc.lStructSize, sizeof cc
       MOVmd     cc.hwndOwner, hWnd
       MOVmd     cc.hInstance, hInst
         mov     cc.lpCustColors, offset CustClrs
         mov     cc.Flags, CC_FULLOPEN or CC_RGBINIT
      INVOKE     ChooseColor, addr cc
         ret
Color    ENDP

;=========================================================================
; Color And Font DIALOG PROCEDURE                                        *
;=========================================================================
ColorFontDlg PROC  uses ebx edi esi  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    hEDC:DWORD, hTemp, Chg, Cnt, Var, hBrush, Ypos, hRegC, sw5
LOCAL    ColorB:DWORD, ColorT, ColorTB
LOCAL    szBuffer1[1024]:BYTE, szBuffer2[1024], Clear[256], szWork[10]

      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
         cmp     wmsg, WM_INITDIALOG
         jne     NotInit

       MOVmd     hClrDlg, hdlg
         and     Hold, 0

      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
         mov     eax, charF.yHeight
         shr     eax, 1
         mov     cf.iPointSize, eax

      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f'
          MOVmd     TextC, charF.crTextColor
      .endif
;      INVOKE     lstrcpy, addr FontName, addr charF.szFaceName
      INVOKE     SetDlgItemText, hdlg, E1, addr charF.szFaceName
      INVOKE     GetDlgItem, hdlg, sb1                                 ; Get UpdateSel check
      .if UpdateSel == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets UpdateSel to checked
      .endif
      INVOKE     GetDlgItem, hdlg, sb2                                 ; Get UpdateAll check
      .if UpdateAll == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets UpdateAll to checked
      .endif
      INVOKE     GetDlgItem, hdlg, cb1                                 ; Get highlite check
      .if HighLite == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets highlite to checked
      .endif
      INVOKE     GetDlgItem, hdlg, cb2                                 ; Get text BG check
      .if TextBG == 1
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0      ; Sets text BG to checked
      .endif

      INVOKE     GetDlgItem, hdlg, E6
         mov     hEdit, eax
      INVOKE     SendMessage, hEdit, WM_SETFONT, tFont, 1

;---------- [Create and load the Syntax Color combobox] ----------
      INVOKE     CreateCombo, 0, addr combobox, WS_CHILD or WS_VISIBLE or WS_VSCROLL or\
                 CBS_HASSTRINGS or CBS_DROPDOWN or CBS_OWNERDRAWFIXED, 17, 224, 174, 240, hdlg, 83
         mov     hCSyntax, eax

      INVOKE     SendMessage, hCSyntax, WM_SETFONT, dFont, 1
      INVOKE     SendMessage, hCSyntax, CB_SETITEMHEIGHT, -1, 14    ; Selection field
      INVOKE     SendMessage, hCSyntax, CB_SETITEMHEIGHT, 0, 13     ; List items

         lea     esi, offset szColorC
         xor     eax, eax
         mov     cnt, 0
Getlen:
      .if byte ptr[esi+eax] == 2ch
            mov     Len, eax
            add     Len, 1 
            add     cnt, 1
         INVOKE     lstrcpyn, offset Misc, esi, Len
         INVOKE     SendMessage, hCSyntax, CB_ADDSTRING, 0, offset Misc
            add     esi, Len
            xor     eax, eax
            jmp     Getlen
      .elseif byte ptr[esi+eax] == 0h
         INVOKE     SendMessage, hCSyntax, CB_SETCURSEL, 0, 0
            jmp     Loaded
      .endif
         inc     eax
         jmp     Getlen

Loaded:
;---------- [Create and load the Keyword List combobox] ----------
      INVOKE     CreateCombo, 0, addr combobox, WS_CHILD or WS_VISIBLE or WS_VSCROLL or\
                 CBS_HASSTRINGS or CBS_DROPDOWN, 281, 18, 174, 210, hdlg, 84
         mov     hMnem, eax

      INVOKE     SendMessage, hMnem, WM_SETFONT, dFont, 1
      INVOKE     SendMessage, hMnem, CB_SETITEMHEIGHT, -1, 14    ; Selection field
      INVOKE     SendMessage, hMnem, CB_SETITEMHEIGHT, 0, 13     ; List items

         and     cnt, 0
      .while (cnt < 14) ;11)
            mov     ebx, cnt
            mov     edx, KeyWord[ebx*4]
           push     edx
         INVOKE     lstrlen, edx
            inc     eax
            pop     edx
         INVOKE     lstrcpyn, offset Misc, edx, eax ;7
         INVOKE     SendMessage, hMnem, CB_ADDSTRING, 0, offset Misc
            inc     cnt
      .endw
         INVOKE     SendMessage, hMnem, CB_SETCURSEL, 0, 0

NotInit:
;---------- [Update the colors in the combobox] ----------
      .if wmsg == WM_DRAWITEM
         .if wparam == 83
            INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
               mov     esi, lparam
               mov     edi, offset dis
               mov     ecx, sizeof dis
               rep     movsb
            .if dis.itemID != -1
               INVOKE     SendMessage, hCSyntax, CB_GETLBTEXT, dis.itemID, addr szBuff
                  mov     Len, eax
               INVOKE     GetTextMetrics, dis.hdc, addr tm
                  mov     eax, dis.rcItem.bottom
                  add     eax, dis.rcItem.top
                  sub     eax, tm.tmHeight
                  shr     eax, 1
                  mov     Ypos, eax
               .if dis.itemState == ODS_SELECTED
                  INVOKE     CreateSolidBrush, 00800000h
                     mov     hBrush, eax
                  INVOKE     FillRect, dis.hdc, addr dis.rcItem, eax
                  INVOKE     SetTextColor, dis.hdc, 00ffffffh
                  INVOKE     SetBkColor, dis.hdc, 00800000h
               .else
                  INVOKE     CreateSolidBrush, 00ffffffh
                     mov     hBrush, eax
                  INVOKE     FillRect, dis.hdc, addr dis.rcItem, eax
                  INVOKE     SetTextColor, dis.hdc, dis.itemData
                  INVOKE     SetBkColor, dis.hdc, 00ffffffh
               .endif        
                  add     dis.rcItem.left, 15
               INVOKE     TextOut, dis.hdc, dis.rcItem.left, Ypos, addr szBuff, Len
                  sub     dis.rcItem.left, 14
                  mov     dis.rcItem.right, 14
                  add     dis.rcItem.top, 1
                  sub     dis.rcItem.bottom, 1
               INVOKE     DeleteObject, hBrush
               INVOKE     CreateSolidBrush, 00000000h
                  mov     hBrush, eax
               INVOKE     FrameRect, dis.hdc, addr dis.rcItem, eax
                  inc     dis.rcItem.left
                  inc     dis.rcItem.top
                  dec     dis.rcItem.right
                  dec     dis.rcItem.bottom
                  mov     ebx, dis.itemID
               INVOKE     SetBkColor, dis.hdc, dword ptr Color01[ebx*4]
               INVOKE     DrawText, dis.hdc, addr Clear, 6, addr dis.rcItem, DT_LEFT or DT_SINGLELINE
               INVOKE     DeleteObject, hBrush
            .endif
               mov     dis.itemState, ODS_DEFAULT
               mov     dis.hdc, 0
         .endif
      .endif

      .if wmsg == WM_PAINT ;|| wmsg == WM_ACTIVATE
         INVOKE     SetFocus, hEdit ;hCSyntax hMnem hEdit
            jmp     DoColors ;OutPut
      .endif

      .if wmsg == WM_MOUSEMOVE
            add     Hold, 1
      .endif

         cmp     wmsg, WM_COMMAND
         jne     OutPut
         and     sw5, 0
         mov     eax, wparam
         and     eax, 0000ffffh

      .if !Hold
            jmp     Pass
      .endif

      .if eax == 84             ; Keyword List combobox
         INVOKE     SendMessage, hMnem, CB_GETDROPPEDSTATE, 0, 0
            mov     Var, eax
         INVOKE     SendMessage, hMnem, CB_GETCURSEL, 0, 0

FromColor:
            .if eax > 11
               INVOKE     lstrcpy, addr Misc, addr szView
               INVOKE     GetDlgItem, hdlg, B7
               INVOKE     ShowWindow, eax, SW_HIDE
            INVOKE     SendMessage, hEdit, EM_SETREADONLY, TRUE, 0
            .else
               INVOKE     lstrcpy, addr Misc, addr szEdit
               INVOKE     GetDlgItem, hdlg, B7
               INVOKE     ShowWindow, eax, SW_SHOWNORMAL
            INVOKE     SendMessage, hEdit, EM_SETREADONLY, FALSE, 0
            .endif
         INVOKE     GetDlgItem, hdlg, B6
         INVOKE     SetWindowText, eax, addr Misc
         .if Var
               jmp     DisplayList
         .endif
      .endif
 
;________________________________________________________________________________________
      .if eax == B6                 ; Edit the Keyword List

DisplayList:
         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hRegC, addr lpdwDisp
         INVOKE     SendMessage, hMnem, CB_GETCURSEL, 0, 0
         .if eax == -1
            INVOKE     MessageBox,NULL, addr szNoSel, addr pTitle, MB_OK
               jmp     Pass
         .endif
         .if eax > 11               ; List by name or group
              push     eax
             MOVmd     ColorB, 00c0c0c0h
               mov     ColorT, 0
             MOVmd     ColorTB, 00c0c0c0h
            INVOKE     SendMessage, hEdit, EM_SETREADONLY, TRUE, 0
               pop     eax
            .if eax == 12
                  mov     esi, hWordListS
            .elseif eax == 13
                  mov     esi, hWordListU
            .else
                  jmp     SetF
            .endif
            INVOKE     SendMessage, hEdit, WM_SETTEXT, NULL, esi
               jmp     SetF
         .endif
mov     Var, eax
add     Var, 4
            mov     ebx, KeyWord[eax*4]
            mov     lpcbData, 1023
         INVOKE     RegQuerySZ, ebx, addr szBuffer1
            cmp     eax, 0
            jne     SetF            ; Entry not found in the registry

;---------- [Insert a space after the comma for easier edit] ----------
            mov     ecx, lpcbData
            xor     esi, esi
            xor     edi, edi
         .while (ecx)
               mov     al, byte ptr szBuffer1[esi]
               mov     byte ptr szBuffer2[edi], al
            .if al == ','
                  mov     byte ptr szBuffer2[edi+1], ' '
                  inc     edi
            .endif
               inc     esi
               inc     edi
               dec     ecx
         .endw
         .if byte ptr szBuffer2[edi-2] == ' '
               mov     byte ptr szBuffer2[edi-2], 0
         .else
               mov     byte ptr szBuffer2[edi], 0
         .endif
         INVOKE     SendMessage, hEdit, WM_SETTEXT, NULL, addr szBuffer2
         INVOKE     RegCloseKey, hRegC

          MOVmd     ColorB, BackGC
            mov     eax, Var
          MOVmd     ColorT, dword ptr Color01[eax*4]
          MOVmd     ColorTB, TextBGC

SetF:
         INVOKE     SendMessage, hEdit, EM_SETBKGNDCOLOR, 0, ColorB
          MOVmd     charF.crTextColor, ColorT
          MOVmd     charF.crBackColor, ColorTB
         INVOKE     SendMessage, hEdit, EM_SETCHARFORMAT, SCF_ALL, addr charF

         INVOKE     SetFocus, hEdit

;________________________________________________________________________________________
      .elseif eax == B7             ; Update the Keyword List
         INVOKE     SendMessage, hMnem, CB_GETCURSEL, 0, 0
            cmp     eax, 10
             jg     Pass            ; Complete list
         INVOKE     SendMessage, hEdit, WM_GETTEXT, 1023, addr szBuffer1
;           test     eax, eax
;             jz     Pass
         .if !eax
            INVOKE     MessageBox, NULL, addr szNoItem, addr pTitle, MB_OK
               jmp     Pass
         .endif
            dec     eax
         .if byte ptr szBuffer1[eax] != ',' ; Insert the end comma if missing
               mov     word ptr szBuffer1[eax+1], 002ch
               inc     eax
         .endif
;---------- [Remove the space] ----------
            inc     eax
            mov     ecx, eax
            xor     esi, esi
            xor     edi, edi

LoopSp:
         .while (ecx)
               mov     al, byte ptr szBuffer1[esi]
            .if al == ' '
                  inc     esi
                  dec     ecx
                  jmp     LoopSp
            .else
               .if al >= 'A' && al <= 'Z'
                     add     al, 20h
               .endif
                  mov     byte ptr szBuffer2[edi], al
            .endif
               inc     esi
               inc     edi
               dec     ecx
         .endw
            mov     byte ptr szBuffer2[edi], 0

;---------- [Update the registry with the updated keyword list] ----------
         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hRegC, addr lpdwDisp
         INVOKE     lstrlen, addr szBuffer2
            inc     eax
            mov     lpcbData, eax
         INVOKE     SendMessage, hMnem, CB_GETCURSEL, 0, 0
            mov     ebx, KeyWord[eax*4]
         INVOKE     RegSetValueEx, hRegC, ebx, 0, REG_SZ, addr szBuffer2, lpcbData
         INVOKE     RegCloseKey, hRegC
           call     KeyWordList
         INVOKE     SendMessage, hREdit, WM_PAINT, 0, 0
            jmp     DoColors ;OutPut

;---------- [Font and Color controls] ----------
      .elseif eax == sb1            ; Apply to a selection
         INVOKE     IsDlgButtonChecked, hdlg, sb1
            mov     UpdateSel, eax
         .if eax
               mov    UpdateAll, 0
         .endif
            jmp     SetColors

      .elseif eax == sb2            ; Apply to all
         INVOKE     IsDlgButtonChecked, hdlg, sb2
            mov     UpdateAll, eax
         .if eax
               mov    UpdateSel, 0
         .endif
            jmp     SetColors

      .elseif eax == cb1            ; Enable syntax highlighting
      INVOKE     GetDlgItem, hdlg, cb1                ; Get highlite chkbox
      INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0  ; Gets check state
         mov     HighLite, eax
         jmp     SetColors

      .elseif eax == cb2            ; Enable text and backgrounr colors
      INVOKE     GetDlgItem, hdlg, cb2                ; Get text BG chkbox
      INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0  ; Gets check state
         mov     TextBG, eax
         jmp     SetColors

      .elseif eax == cb3            ; Make the text BG and BG colors the same
          MOVmd     TextBGC, BackGC
            mov     sw5, 22
            jmp     SetColors

      .elseif eax == B1             ; Font button
            jmp     FontS

      .elseif eax > B1 && eax < B6  ; Color buttons
            mov     ebx, eax
            sub     ebx, B0
            mov     sw5, ebx
            jmp     TextColor
      .endif
         cmp     eax, IDCANCEL
         jne     OutPut

CancelOut:
         and     hClrDlg, 0
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' ;&& eax == 7733 ;|| PathName == 0
            mov     sw3, 8
           push     PointSize
           call     Initialize
            mov     charF.dwMask, 0f000000fh ;CFM_FACE or CFM_SIZE or CFM_COLOR ;0feffffffh
            mov     charF.dwEffects, 0
            mov     charF.yOffset, 0
            pop     PointSize
          MOVmd     charF.yHeight, PointSize
;           call     SetCharFormatting
      .endif

      INVOKE     EndDialog, hdlg, wparam
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         mov     eax, TRUE
         ret

SetColors:
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
       MOVmd     w1, cf.rgbColors
      .if TextBG == 0
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00ffffffh
            mov     charF.crTextColor, 0
            mov     charF.crBackColor, 00ffffffh
      .else
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
          MOVmd     charF.crTextColor, TextC
          MOVmd     charF.crBackColor, TextBGC
      .endif
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
      .if UpdateSel
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, addr charF
      .else
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
         INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
           call     EnableDisableEditMenu
      .endif
        call     SetScroll
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
       MOVmd     cf.rgbColors, w1
;         cmp     sw5, 22
;          je     DoColors           ; Making BG and text BG the same
         jmp     DoColors ;Pass

FontS:
        call     Font               ; Call the font dialog
         cmp     eax, FALSE         ; Cancel'ed or error occurred
          je     DoColors ;OutPut
        call     ScreenLines
         jmp     DoTextColor      

TextColor:
      .if sw5 < 5                   ; Text, text background, and background color
            mov     ecx, sw5
            sub     ecx, 2
          MOVmd     cc.rgbResult, TextC[ecx*4]
      .else                        ; Syntax colors
         INVOKE     GetWindowText, hCSyntax, addr Misc, 20
         INVOKE     SendMessage, hCSyntax, CB_FINDSTRING, -1, addr Misc
          MOVmd     cc.rgbResult, Color01[eax*4]
      .endif
        call     Color              ; Call the color dialog
         cmp     eax, FALSE         ; Cancel'ed or error occurred
          je     DoColors ;OutPut

      .if sw5 == 4                  ; Background color
          MOVmd      BackGC, cc.rgbResult
          MOVmd      w4, cc.rgbResult
            jmp      DoBackGC
      .elseif sw5 > 1 && sw5 < 5    ; Text and text background color
         .if sw5 == 2 && UpdateSel
             MOVmd     charF.crTextColor, cc.rgbResult
               jmp     PastMov
         .endif
         .if sw5 == 3 && UpdateSel
             MOVmd     charF.crBackColor, cc.rgbResult
               jmp     PastMov
         .endif
            mov     ecx, sw5 
            sub     ecx, 2
           imul     ecx, 4
          MOVmd     TextC[ecx], cc.rgbResult
         .if sw5 == 2 || sw5 == 3
               jmp     DoTextColor
         .endif
      .else                         ; Syntax colors
         INVOKE     GetWindowText, hCSyntax, addr Misc, 20
         INVOKE     SendMessage, hCSyntax, CB_FINDSTRING, -1, addr Misc
          MOVmd     Color01[eax*4], cc.rgbResult
;         .if sw5 == 2 || sw5 == 3
;               jmp     DoTextColor
;         .endif
      INVOKE     SendMessage, hREdit, WM_PAINT, 0, 0
            jmp     DoColors ;OutPut
      .endif

DoTextColor:
;   mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, TextBGC

PastMov:
       MOVmd     w4, BackGC
      .if charF.dwEffects == CFM_BACKCOLOR
            mov     charF.dwEffects, 0
      .endif
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' ;|| PathName == 0
            mov     charF.crBackColor, 00ffffffh
            mov     w4, 00ffffffh
      .endif
;;      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
      .if UpdateSel
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, addr charF
      .else
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
         INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
           call     EnableDisableEditMenu
      .endif
        call     SetScroll
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
         jmp     DoColors

DoBackGC:
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, w4  ; w4 = BackGC
         jmp     DoColors

OutPut:
      .if wmsg == WM_CTLCOLOREDIT
            jmp     DoColors
      .endif

      .if Hold > 2
            jmp     Pass
      .endif

DoColors:
      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
       MOVmd     Cnt, E1    ; E1 = 1801
      INVOKE     GetDlgItem, hdlg, Cnt
         mov     hTemp, eax
        test     eax, eax
          jz     Pass
      INVOKE     GetClientRect, hTemp, addr rect
      INVOKE     GetDC, hTemp
         mov     hEDC, eax

      INVOKE     SetTextColor, hEDC, TextC
      INVOKE     SetBkColor, hEDC, BackGC

;      INVOKE     SetBkMode, hEDC, TRANSPARENT
      INVOKE     DrawText, hEDC, addr Clear, -1, addr rect, DT_LEFT or DT_SINGLELINE
      INVOKE     SelectObject, hEDC, mFont
         mov     w2, eax
         mov     rect.left, 1
         mov     rect.top, 1
      INVOKE     DrawText, hEDC, addr charF.szFaceName, -1, addr rect, DT_LEFT or DT_SINGLELINE
      INVOKE     SelectObject, hEDC, w2
         mov     rect.top, 0

         mov     rect.left, 150
      INVOKE     DrawText, hEDC, addr Clear, -1, addr rect, DT_LEFT or DT_SINGLELINE
      .if cf.iPointSize == 0
            mov     eax, PointSize
            shr     eax, 1
            mov     cf.iPointSize, eax
      .endif
      INVOKE     BaseAscii, cf.iPointSize, addr Misc, 2, 10, 0, 1, 1
      .if Misc == '0'
            mov     Misc, '9'
            mov     Misc + 1, ' '
      .endif
      .if cf.iPointSize < 100
            mov     al, Misc
            mov     Misc + 1, al
            mov     Misc, ' '
      .else
            mov     Misc + 2, ' '
      .endif
         mov     rect.left, 152
      INVOKE     DrawText, hEDC, addr Misc, -1, addr rect, DT_LEFT or DT_SINGLELINE
      INVOKE     ReleaseDC, hTemp, hEDC

         inc     Cnt
         mov     ecx, Cnt
      .while ecx <= 1804
         INVOKE     GetDlgItem, hdlg, Cnt
            mov     hTemp, eax
           test     eax, eax
             jz     Pass
         INVOKE     GetClientRect, hTemp, addr rect
         INVOKE     GetDC, hTemp
            mov     hEDC, eax
            mov     ebx, Cnt
            sub     ebx, 1802
         INVOKE     SetBkColor, hEDC, TextC[ebx*4]
            mov     rect.left, 150
         INVOKE     DrawText, hEDC, addr Clear, -1, addr rect, DT_LEFT or DT_SINGLELINE
         INVOKE     ReleaseDC, hTemp, hEDC
            inc     Cnt
            mov     ecx, Cnt
      .endw

      INVOKE     GetWindowText, hCSyntax, addr Misc, 20
        test     eax, eax
          jz     Pass
      INVOKE     SendMessage, hCSyntax, CB_FINDSTRING, -1, addr Misc
       MOVmd     w5, Color01[eax*4]
      INVOKE     GetWindow, hCSyntax, GW_CHILD
         mov     w6, eax
      INVOKE     GetClientRect, w6, addr rect
      INVOKE     GetDC, w6
         mov     hEDC, eax
         inc     rect.bottom
      INVOKE     SelectObject, hEDC, dFont ;dFont tFont
      INVOKE     SetTextColor, hEDC, w5
      INVOKE     DrawText, hEDC, addr Clear, -1, addr rect, DT_LEFT or DT_SINGLELINE
      INVOKE     DrawText, hEDC, addr Misc, -1, addr rect, DT_LEFT or DT_SINGLELINE
      INVOKE     ReleaseDC, w6, hEDC

Pass:

ColorFontRet:
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         mov     eax, FALSE
         ret
ColorFontDlg ENDP

;=========================================================================
; Build the Key Word List PROCEDURE                                      *
;=========================================================================
KeyWordList PROC  uses ebx edx esi edi
LOCAL    hRegK:DWORD
LOCAL    szBuffer[1024]:BYTE, szWork[256]

;---------- [Create a temperary combobox to load and sort the word list        ] ----------
;---------- [             **** A Dummy's Way To Sort ****                      ] ----------
;---------- [The list will include the word size and pointer to the color array] ----------

      INVOKE     CreateCombo, 0, addr combobox, WS_CHILD or WS_VSCROLL or\
                 CBS_HASSTRINGS or CBS_DROPDOWN or CBS_SORT, 600,0,120,210, hWndTool, 81
         mov     TempWord2, eax

;---------- [Allocate memory from the default heap] ----------
      INVOKE     HeapAlloc, hDefHeap, 0, 10000
         mov     hwMem, eax
      INVOKE     HeapAlloc, hDefHeap, 0, 1028
         mov     IDArray, eax
      INVOKE     HeapAlloc, hDefHeap, 0, 5000
         mov     hWordListS, eax
      INVOKE     HeapAlloc, hDefHeap, 0, 5000
         mov     hWordListU, eax
      INVOKE     HeapAlloc, hDefHeap, 0, 300
         mov     hHead, eax
      INVOKE     HeapAlloc, hDefHeap, 0, 300
         mov     hBuff, eax
         mov     edi, IDArray
      INVOKE     RtlZeroMemory, edi, 1028

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegK, addr lpdwDisp

         mov     lpcbData, 1023
      INVOKE     RegQuerySZ, addr szKeyw01, addr szBuffer
         mov     sw3, eax         ; 0 = success
         mov     w4, 0
         mov     cnt, 0
         xor     ebx, ebx
      .if sw3                     ; Use the default word list
            mov     esi, KeyArray[ebx]
      .else                       ; Use the registery
            lea     esi, szBuffer
      .endif
         xor     eax, eax

Getlen:
      .while (w4 < 12)
         .if byte ptr[esi+eax] == ','
               mov     Len, eax
               inc     Len
               add     cnt, 1
              push     esi
              push     eax
            INVOKE     lstrcpyn, addr Misc, esi, Len
            INVOKE     lstrcpy, addr szRep, addr Misc
            INVOKE     lstrcat, addr Misc, addr Car
               pop     eax
            INVOKE     BaseAscii, eax, addr szBuff, 4, 10, 0, 1, 1
            INVOKE     lstrcat, addr Misc, addr szBuff     ; Size of the word
            INVOKE     lstrcat, addr Misc, addr Car
               mov     eax, w4
               add     eax, 4
            INVOKE     BaseAscii, eax, addr szBuff, 4, 10, 0, 1, 1
               sub     eax, 3
            INVOKE     BaseAscii, eax, addr WorkBuff, 2, 10, 0, 1, 1
            INVOKE     lstrcat, addr WorkBuff, addr szSpace
            INVOKE     lstrcat, addr WorkBuff, addr szRep
            INVOKE     lstrcat, addr WorkBuff, addr szCRLF
               mov     edi, hWordListU
            .if cnt == 1
               INVOKE     lstrcpy, edi, addr WorkBuff
            .else
               INVOKE     lstrcat, edi, addr WorkBuff
            .endif

            INVOKE     lstrcat, addr Misc, addr szBuff     ; Pointer to the color array
            INVOKE     lstrcat, addr Misc, addr szSColon
            INVOKE     SendMessage, TempWord2, CB_ADDSTRING, 0, addr Misc
               pop     esi
               add     esi, Len
               xor     eax, eax
               jmp     Getlen
         .elseif byte ptr[esi+eax] == 0
               inc     w4
               mov     ebx, w4
              imul     ebx, 4
            .if sw3
                  mov     esi, KeyArray[ebx]
            .else
                  mov     edx, KeyWord[ebx]
                  mov     lpcbData, 1023
               INVOKE     RegQuerySZ, edx, addr szBuffer
                  lea     esi, szBuffer
            .endif
               xor     eax, eax
               jmp     Getlen
         .endif
            inc     eax
            jmp     Getlen
      .endw

         and     w4, 0
         and     w3, 0
         and     cnt, 0
      INVOKE     SendMessage, TempWord2, CB_GETCOUNT, 0, 0
         mov     w6, eax
         mov     NumKWs, eax

;---------- [Swap the num and word fields and write the sorted words to memory from the    ] ----------
;---------- [combobox. This will also create a pointer to the offset in the word list array] ----------
;---------- [and convert the ascii fields to decimal                                       ] ----------
      .while w6 > 0              ; w6 = num of words in the combobox
         INVOKE     SendMessage, TempWord2, CB_GETLBTEXT, cnt, addr szBuff
            add     w4, eax      ; w4 = the address offset for the char set
            mov     Len, eax
            xor     eax, eax

Loop4:
         .if byte ptr szBuff[eax] == '^'
              push     eax
            INVOKE     lstrcpyn, addr WorkBuff, addr szBuff[eax], 6      ; Keyword length
               pop     eax
              push     eax
            INVOKE     lstrcpyn, addr WorkBuff+5, addr szBuff[eax+5], 6  ; Color code
               pop     eax
              push     eax
            INVOKE     lstrcpyn, addr Misc, addr szBuff[eax+8], 3
            INVOKE     AsciiBase, addr Misc, addr Hold, 10
               sub     Hold, 3
            INVOKE     BaseAscii, Hold, addr Misc, 2, 10, 0, 1, 1
            INVOKE     lstrcpy, addr szWork, addr Misc
            INVOKE     lstrcat, addr szWork, addr szSpace
               pop     eax
               inc     eax
              push     eax
            INVOKE     lstrcpyn, addr WorkBuff+10, addr szBuff, eax      ; Keyword
               pop     eax
            INVOKE     lstrcpyn, addr szWork+3, addr szBuff, eax
            INVOKE     lstrcat, addr szWork, addr szCRLF
            INVOKE     lstrcat, addr WorkBuff, addr szSColon
         .else
               inc     eax
               jmp     Loop4
         .endif
         .if !cnt
               mov     edi, hWordListS
            INVOKE     lstrcpy, edi, addr szWork
         .else
               mov     edi, hWordListS
            INVOKE     lstrcat, edi, addr szWork
         .endif
         INVOKE     lstrcpyn, addr Misc, addr WorkBuff+1, 5
         INVOKE     AsciiBase, addr Misc, addr Hold, 10
          MOVmb     WorkBuff[1], Hold
          MOVmb     WorkBuff[2], Hold[1]
          MOVmb     WorkBuff[3], Hold[2]
          MOVmb     WorkBuff[4], Hold[3]
         INVOKE     lstrcpyn, addr Misc, addr WorkBuff+6, 5
         INVOKE     AsciiBase, addr Misc, addr Hold, 10
          MOVmb     WorkBuff[6], Hold
          MOVmb     WorkBuff[7], Hold[1]
          MOVmb     WorkBuff[8], Hold[2]
          MOVmb     WorkBuff[9], Hold[3]
            dec     w6
            inc     cnt
         .if cnt == 1
               mov     bl, szBuff
               mov     szByte, bl
              imul     ebx, 4
               mov     edi, IDArray
             MOVmd     dword ptr[edi+ebx], w3        ; Pointer to an offset in the word array
               and     ArraySize, 0
         .else
               mov     al, szBuff
            .if al != szByte
                  mov     szByte, al
                MOVmd     w3, w4
                  mov     eax, Len
                  sub     w3, eax
                  xor     ebx, ebx
                  mov     bl, szByte
                 imul     ebx, 4
               mov     edi, IDArray
             MOVmd     dword ptr[edi+ebx], w3        ; Pointer to an offset in the word array
            .endif
         .endif

            xor     ebx, ebx
            mov     ecx, ArraySize
            mov     edi, hwMem
         .while (Len)
               mov     al, byte ptr WorkBuff[ebx]
               mov     byte ptr [edi+ecx], al
               inc     ebx
               inc     ecx
               dec     Len
         .endw
            mov     ArraySize, ecx
      .endw
         mov     ecx, ArraySize
         mov     byte ptr [edi+ecx], '$'
      INVOKE     DestroyWindow, TempWord2          ; Destroy the combobox
      INVOKE     RegCloseKey, hRegK
         mov     szRep, 0
         ret
KeyWordList ENDP

;=========================================================================
; Assemble Box PROCEDURE                                                 *
;=========================================================================
AssmbDlg  PROC  uses ebx esi edi  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    pt:POINT
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    SPos1:DWORD, SW, Cnt, Num, hFind, swD, swR, BatchOff
LOCAL    SavFile[256]:BYTE, szWork[256], szWork1[256], szWork2[256], szSearch[256], szProjName[25], szResr[25]

      .if wmsg == WM_INITDIALOG
         INVOKE     GetClientRect, hWnd, addr rect
          MOVmd     pt.x, rect.left
            mov     pt.y, 0
           push     rect.top
         INVOKE     ClientToScreen, hWnd, addr pt
            mov     eax, rect.right
            sub     eax, rect.left
           push     eax
         INVOKE     GetWindowRect, hdlg, addr rect
            mov     ebx, rect.right
            sub     ebx, rect.left
            pop     eax
            sub     eax, ebx
            add     eax, pt.x
            sub     eax, 19
            mov     ecx, rect.bottom
            sub     ecx, rect.top
            pop     edx                                              ; rect.top from hWnd
            add     edx, pt.y
            add     edx, 27
         INVOKE     MoveWindow, hdlg, eax, edx, ebx, ecx, TRUE

         INVOKE     GetDlgItem, hdlg, sb3                            ; Get .exe
         INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0              ; Gets check state
         .if !eax
            INVOKE     GetDlgItem, hdlg, sb1                         ; Get .dll
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets .dll to checked
         .endif
         INVOKE     SetFocus, hAsmbox
            and     Sel, 0
            and     sw3, 0
      .endif

      .if wmsg == WM_CTLCOLORDLG 
;         INVOKE     GetStockObject, WHITE_BRUSH         ; Select the white brush for the background
         .if hBR
            INVOKE     DeleteObject, hBR
         .endif
         INVOKE     CreateSolidBrush, 00ffffe0h
            mov     hBR, eax
            ret
      .endif

      .if wmsg == WM_CTLCOLORSTATIC
         INVOKE     GetDlgItem, hdlg, 34
         .if lparam != eax
;            INVOKE     GetStockObject, WHITE_BRUSH     ; Select the white brush for the background
            INVOKE     SetBkColor, wparam, 00ffffe0h
            INVOKE     SetTextColor, wparam, 00000000h
            .if hBR
               INVOKE     DeleteObject, hBR
            .endif
            INVOKE     CreateSolidBrush, 00ffffe0h
               mov     hBR, eax
         .else
            INVOKE     SetBkColor, wparam, 00000000h   ; Background color is black
            INVOKE     SetTextColor, wparam, 00ffff00h ; Text color of edit box is lt blue
            INVOKE     GetStockObject, BLACK_BRUSH     ; Select the black brush for background
         .endif
            ret
      .endif

      .if wmsg == WM_CTLCOLORLISTBOX || wmsg == WM_CTLCOLOREDIT
         INVOKE     SetBkColor, wparam, 00000000h   ; Background color is black
         INVOKE     SetTextColor, wparam, 00ffff00h ; Text color of edit box is lt blue
         INVOKE     GetStockObject, BLACK_BRUSH     ; Select the black brush for background
            ret
      .endif

         cmp     wmsg, WM_COMMAND
         jne     AssmbDone
      INVOKE     SendMessage, hAsmbox, LB_GETCURSEL, 0, 0
         mov     w1, eax
      INVOKE     SendMessage, hAsmbox, LB_GETTEXT, w1, addr szProjName
      INVOKE     lstrcpy, addr szWork, addr RootDir
      INVOKE     lstrcat, addr szWork, addr szPtr
      INVOKE     lstrcat, addr szWork, addr szProjName
      INVOKE     lstrcat, addr szWork, addr PatnP+10  ; = .ptr

         mov     eax, wparam

      .if eax > B1 && eax < B10 && w1 == -1
         jmp     AssmbDone
      .elseif eax > B1 && eax < B10 && w1 != -1
         INVOKE     ShowWindow, hAsmbox, SW_SHOWNORMAL
         INVOKE     SendMessage, hMult, LB_RESETCONTENT, 0, 0
         INVOKE     ShowWindow, hMult, SW_HIDE
      .endif
         mov     eax, wparam
         mov     SW, eax
         mov     ebx, eax
         shr     ebx, 16

;---------- [For mult source files] ----------
      .if ebx == LBN_SELCHANGE
         INVOKE     SendMessage, hMult, LB_GETCURSEL, 0, 0
            mov     ebx, eax
         INVOKE     SendMessage, hMult, LB_GETTEXT, ebx, addr szProjName
         INVOKE     lstrlen, addr szProjName
            sub     eax, 3
         INVOKE     lstrcpyn, addr szProjName, addr szProjName, eax
         INVOKE     lstrcpy, addr szWork, addr WorkBuff
         INVOKE     lstrcat, addr szWork, addr szProjName
         INVOKE     ShowWindow, hAsmbox, SW_SHOWNORMAL
         INVOKE     ShowWindow, hMult, SW_HIDE
            and     Sel, 0
            mov     SW, B5
MOVmd     SW, sw3
            jmp     Source
      .endif

      .if eax == B2
         INVOKE     lstrcmpi, addr Misc, addr szProjName
         .if eax != 0
               mov     SW, 44
               mov     sw3, 44
               jmp     ChkSave
         .endif
         INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
            cmp     eax, 0
             je     Ret44
           call     SaveFile

Ret44:
         INVOKE     SendMessage, hWnd, WM_COMMAND, 804, 25
            jmp     AssmbDone
      .elseif eax == B3
            and     Sel, 0
            jmp     readem
      .elseif eax == B5
mov     sw3, B5
            jmp     ChkSave
      .elseif eax == B6
            jmp     ChkSave
      .elseif eax == B7
            jmp     Extract
      .elseif eax == B8
            jmp     Extract
      .elseif eax == B9
            jmp     RemoveP
      .elseif eax == IDCANCEL
            jmp     CancelOut
      .else
            jmp     AssmbDone
      .endif

CancelOut:
         and     hAsm, 0
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE
         jmp     AssmbRet

ExecProg:
      INVOKE     lstrlen, addr szWork
        test     eax, eax
          jz     AssmbDone
      INVOKE     lstrcpy, addr WorkBuff, addr szWork
      INVOKE     lstrcat, addr WorkBuff, addr PatnE+1
      INVOKE     WinExec, addr WorkBuff, SW_SHOWNORMAL   ; Run a .exe program
      .if eax < 32                                       ; Error
         INVOKE     WinExec, addr szWork1, SW_SHOWNORMAL ; Run a .dll program
      .endif
      INVOKE     SetFocus, hdlg
         jmp     GetFileName

ChkSave:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         cmp     eax, 0
          je     NoSav1
        call     SaveFile

NoSav1:
         jmp     Extract

Source:
      INVOKE     lstrcpy, addr PathName, addr szWork
         mov     eax, SW
      .if eax == B5 || eax == 44
         INVOKE     lstrcat, addr PathName, addr PatnA+1
      .elseif eax == B6 && swR
         INVOKE     lstrcpy, addr PathName, addr WorkBuff
         INVOKE     lstrcat, addr PathName, addr szResr
      .else
            jmp     AssmbDone
      .endif
      INVOKE     lstrcmpi, addr SavFile, addr PathName
        test     eax, eax
          jz     BuildTitle
         mov     OA, 1
         mov     w5, 6
        call     OpenFileA
      .if eax == -1
            jmp     AssmbDone
      .endif
         jmp     BuildTitle

CopyOut:
         mov     ebx, hBuff
      INVOKE     lstrcpy, ebx, addr szWork
      INVOKE     lstrlen, addr szWork
         mov     ebx, hBuff
         add     ebx, eax
      INVOKE     GetDlgItem, hdlg, sb1                   ; Get .dll
      INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0     ; Gets check state
      .if eax
            mov     dword ptr[ebx], 'lld.'
      .endif
      INVOKE     GetDlgItem, hdlg, sb2                   ; Get .lib
      INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0     ; Gets check state
      .if eax
            mov     dword ptr[ebx], 'bil.'
      .endif
      INVOKE     GetDlgItem, hdlg, sb3                   ; Get .exe
      INVOKE     SendMessage, eax, BM_GETCHECK, 0, 0     ; Gets check state
      .if eax
            mov     dword ptr[ebx], 'exe.'
      .endif
         mov     ebx, hBuff
      INVOKE     lstrcpy, addr PathName, ebx
        call     readp
         mov     sw1, 1
         mov     sw2, 5
        call     SaveFile
      .if hpMem > 0
         INVOKE     GlobalUnlock, fpMem
         INVOKE     GlobalFree, hpMem
            mov     hpMem, 0
      .endif
      INVOKE     lstrcpy, addr PathName, addr SavFile
         jmp     GetFileName

Extract:
      INVOKE     lstrcpy, addr SavFile, addr PathName
         mov     ebx, hBuff
      INVOKE     lstrcpy, ebx, addr szWork
        call     readp
        test     eax, eax
          js     AssmbDone

         mov     al, 5bh               ; Bracket
         mov     ecx, bytesread        ; Bytes left to analyze
         mov     edi, fpMem            ; Start address in input buffer
         cld                           ; Increment edi
         repnz   scasb                 ; Repeat until byte = al [
      .if ecx
            sub     edi, fpMem
            mov     bytesread, edi
      .endif

         mov     al, 3ah               ; Colon
         mov     ecx, bytesread        ; Bytes left to analyze
         mov     edi, fpMem            ; Start address in input buffer
         mov     SPos1, edi
         cld                           ; Increment edi
         repnz   scasb                 ; Repeat until byte = al(3ah)
         mov     eax, edi
         sub     eax, fpMem
        push     eax
      INVOKE     lstrcpyn, addr Misc, SPos1, eax
         pop     eax
         inc     eax
         add     SPos1, eax
         mov     ecx, eax
         mov     eax, bytesread
         sub     eax, ecx
         inc     eax

         mov     ecx, 20
         mov     ebx, SPos1
      .while (ecx)
         .if byte ptr [ebx+eax] == '\'
            .break
         .endif
            dec     eax
            dec     ecx
      .endw
         add     eax, 2

;---------- [Check for a drive letter] ----------
         mov     ebx, SPos1
      .if byte ptr [ebx+1] != ':'
           push     eax
         INVOKE     lstrcpyn, addr szWork, addr RootDir, 3
            pop     eax
         INVOKE     lstrcpyn, addr szWork+2, SPos1, eax
      .else
         INVOKE     lstrcpyn, addr szWork, SPos1, eax
      .endif
      INVOKE     lstrcpy, addr szSearch, addr szWork
      INVOKE     lstrcat, addr szSearch, addr Patn
      INVOKE     lstrcpy, addr szWork1, addr szWork
      INVOKE     lstrcpy, addr WorkBuff, addr szWork
      INVOKE     lstrcat, addr szWork1, addr szCallDLLe
      INVOKE     lstrcat, addr szWork, addr Misc
         and     Num, 0
         and     swD, 0
         and     swR, 0

         mov     eax, SW
      .if eax == B5 || eax == B6 || eax == 44 ; added 44 04-01
         INVOKE     FindFirstFile, addr szSearch, addr FindData
           test     eax, eax
             js     AllDone
            mov     hFind, eax
            jmp     ChkFile

GetNext:
         INVOKE     FindNextFile, hFind, addr FindData
         .if eax == 0
               jmp     AllDone
         .endif

ChkFile:
         .if byte ptr FindData.cFileName == '.'
               jmp     GetNext
         .endif
         INVOKE     lstrlen, addr FindData.cFileName
            mov     Cnt, eax
            sub     eax, 3
            lea     esi, FindData.cFileName
            add     esi, eax
            mov     ecx, 3
           call     LowerCase                ; Convert to lowercase for compare
         .while (Cnt)
               dec     Cnt
               mov     eax, Cnt
            .if byte ptr FindData.cFileName[eax] == '.'
               .if byte ptr FindData.cFileName[eax+1] == 'a' &&\
                   byte ptr FindData.cFileName[eax+2] == 's'
                  INVOKE     SendMessage, hMult, LB_ADDSTRING, 0, addr FindData.cFileName
                     inc     Num
                  .break
               .elseif byte ptr FindData.cFileName[eax+1] == 'd' &&\
                       byte ptr FindData.cFileName[eax+2] == 'e'
                     mov     swD, 1
               .elseif byte ptr FindData.cFileName[eax+1] == 'r' &&\
                       byte ptr FindData.cFileName[eax+2] == 'c'
                  INVOKE     lstrcpy, addr szResr, addr FindData.cFileName
                     mov     swR, 1
               .endif
            .endif
         .endw
            jmp     GetNext

AllDone:
         .if swD
            INVOKE     GetDlgItem, hdlg, sb1                           ; Get .dll
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets .dll to checked
            INVOKE     GetDlgItem, hdlg, sb3                           ; Get .exe
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0 ; Sets .exe to checked
         .else
            INVOKE     GetDlgItem, hdlg, sb3                           ; Get .exe
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0   ; Sets .exe to checked
            INVOKE     GetDlgItem, hdlg, sb1                           ; Get .dll
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0 ; Sets .dll to checked
         .endif
            mov     eax, SW
         .if Num > 1 && eax == B5 || Num > 1 && eax == 44 ; added 44 04-01 
            .if Sel
                  and     Sel, 0
                  jmp     AssmbDone
            .endif
               mov     Sel, 1
            INVOKE     ShowWindow, hAsmbox, SW_HIDE
            INVOKE     ShowWindow, hMult, SW_SHOWNORMAL
               jmp     AssmbDone
         .endif
            mov     eax, SW
      .endif

      .if eax == B7
            jmp     CopyOut
      .elseif eax == B8
            jmp     ExecProg
      .elseif eax == B5
            jmp     Source
      .elseif eax == B6
            and     Sel, 0
            jmp     Source
      .elseif eax == 44
            jmp     Source
      .endif
         jmp     AssmbDone ;readem

readem:
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         cmp     eax, 0
          je     NoSav3
        call     SaveFile

NoSav3:
      INVOKE     lstrcpy, addr PathName, addr szWork
         mov     w5, 6
         mov     OA, 1
         mov     ecx, lengthof szALL
         mov     esi, offset szALL
         mov     edi, offset szFilter
         rep     movsb
        call     OpenFileA

BuildTitle:
      INVOKE     GetCurrentDirectory, lengthof CurDir, addr CurDir
      INVOKE     lstrcpy, addr szBuff, addr pTitle
      INVOKE     lstrcat, addr szBuff, addr PathName
      INVOKE     SetWindowText, hWnd, addr szBuff
      .if SW == 44
            jmp     Ret44
      .endif

GetFileName:
      INVOKE     lstrlen, addr PathName
      .while (eax)
            dec     eax
         .if PathName[eax] == '\'
            .break
         .endif
      .endw
         inc     eax
      INVOKE     lstrcpy, addr FileName, addr PathName[eax]
         jmp     AssmbDone

;---------- [Remove Project] ----------
RemoveP:
      INVOKE     SetFocus, hAsmbox
      INVOKE     LoadLibrary, addr LibNameC
      .if eax
            mov     hCreate, eax
         INVOKE     GetProcAddress, eax, addr FuncNameD
         .if eax
              push     eax
            INVOKE     lstrcpy, addr Misc, addr szProjName
               pop     eax
              push     w1
              push     offset Misc
              Push     offset szRedit
              push     hAsmbox
              push     hdlg
              call     eax
         .else
         .endif
         INVOKE     FreeLibrary, hCreate
            and     hCreate, 0
         INVOKE     SetFocus, hAsm
      .else
            MsgBox     ERROR_MISSING_DLL, LibNameC, MB_OK or MB_ICONERROR
      .endif

AssmbDone:
         mov     eax, FALSE

AssmbRet:
         and     sw1, 0
         ret
AssmbDlg ENDP

;=========================================================================
; Screen Lines & Char's Per Line PROCEDURE                               *
;=========================================================================
ScreenLines PROC uses ebx edx
LOCAL            hEDC:DWORD

      INVOKE     SendMessage, hREdit, EM_GETLINECOUNT, 0, 0    ; Returns # lines + 1
         dec     eax
         mov     Ltot, eax
      INVOKE     GetClientRect, hREdit, addr rect
      INVOKE     GetDC, hREdit
         mov     hEDC, eax
      INVOKE     SelectObject, hEDC, hFont
      INVOKE     GetTextMetrics, hEDC, addr tm
      INVOKE     ReleaseDC, hREdit, hEDC
         mov     eax, rect.bottom     ; Load dividend
         and     edx, 0 
         div     tm.tmHeight
         mov     NScrL, eax           ; Number of lines per screen
mov     ScrL, eax

mov     al, tm.tmCharSet
mov     lf.lfCharSet, al
mov     charF.bCharSet, al
mov     al, tm.tmPitchAndFamily
 or     eax, 0eh
xor     eax, 0fh
mov     lf.lfPitchAndFamily, al
mov     charF.bPitchAndFamily, al

         mov     eax, rect.right
         mov     ebx, tm.tmAveCharWidth
         sub     eax, ebx
         and     edx, 0 
        idiv     ebx
         mov     Lmax, eax
         mov     eax, FontHeight
         neg     eax
         add     eax, 4 ;2
;      .if eax < 15
;            inc     eax
;      .endif
         mov     FontH, eax
         ret
ScreenLines ENDP

;=========================================================================
; Rich Edit PROCEDURE - Rich Edit is a SUB CLASS                         *
;=========================================================================
RichEditProc PROC  uses ebx hwnd, wmsg, wparam, lparam
LOCAL    Lnum:DWORD

      .if wmsg == WM_PAINT
         INVOKE     SendMessage, hwnd, EM_GETFIRSTVISIBLELINE, 0, 0
            inc     eax
            mov     Lnum, eax
         INVOKE     HideCaret, hwnd
         INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam
         .if DataFlag && HighLite
              call     Syntax
         .endif
         INVOKE     ShowCaret, hwnd
            jmp     Countem
      .endif

      .if wmsg == WM_KEYDOWN
;---------- [For hex edit] ----------
INVOKE     SendMessage, hwnd, EM_GETMODIFY, 0, 0
   mov     Hold, eax
INVOKE     SendMessage, hwnd, EM_LINEINDEX, -1, 0
MOVmd     w2, eax
MOVmd     w3, eax
INVOKE     SendMessage, hwnd, EM_LINELENGTH, eax, 0
add     w3, eax
         .if wparam == VK_DELETE ||\
             wparam == VK_DOWN ||\
             wparam == VK_UP
               jmp     DoLine
         .endif
      .endif
      .if wmsg == WM_LBUTTONUP || wmsg == WM_KEYUP
            mov     DataFlag, 1

DoLine:
           call     EnableDisableEditMenu
         INVOKE     SendMessage, hwnd, EM_GETSEL, addr SBook, addr EBook
         INVOKE     SendMessage, hwnd, EM_EXGETSEL, 0, addr cr
         INVOKE     SendMessage, hwnd, EM_GETLINECOUNT, 0, 0    ; Returns # lines + 1
            dec     eax
            mov     Ltot, eax
         INVOKE     SendMessage, hwnd, EM_GETSEL, addr SPos, addr EPos
            mov     eax, SPos
            sub     EPos, eax
         INVOKE     SendMessage, hwnd, EM_LINEINDEX, -1, 0
            mov     FileOff, eax
         INVOKE     SendMessage, hwnd, EM_EXLINEFROMCHAR, 0, FileOff
            mov     Lnum, eax
         INVOKE     SendMessage, hwnd, EM_LINELENGTH, FileOff, 0
            inc     eax
            mov     Llen, eax

;---------- [For hex update] ----------
.if HexOpen && wmsg == WM_KEYUP
      add     w2, 10
      sub     w3, 19
      mov     ebx, cr.cpMin
      mov     ecx, cr.cpMax
   .if ebx < w2 || ecx > w3
      INVOKE     SendMessage, hwnd, WM_UNDO, 0, 0
      INVOKE     SendMessage, hwnd, EM_EMPTYUNDOBUFFER, 0, 0
      INVOKE     SendMessage, hwnd, EM_SETMODIFY, Hold, 0
        call     EnableDisableEditMenu
   .endif
.endif
            mov     eax, FileOff
         .if eax > SPos
               and     SPos, 0
               mov     ebx, EPos
            .if EPos > 2 
                  sub     ebx, 2
            .endif
               mov     Llen, ebx
         .else
               sub     SPos, eax
         .endif
            add     SPos, 1
            mov     eax, EPos
         .if eax > Llen
;               sub     Lnum, 1  ; NOTE may need
         .endif
         .if Llen == 0
               mov     SPos, 1
         .endif
          MOVmd     CurPos, SPos
            mov     KUP, 1
            mov     KDN, 1
            add     Lnum, 1
         .if Llen > 1
               sub     Llen, 1
         .endif

Countem:
            mov     word ptr cnt3+4, '  '
         INVOKE     BaseAscii, Lnum, addr cnt1, 5, 10, 0, 1, 0
         INVOKE     BaseAscii, Ltot, addr cnt2, 5, 10, 0, 1, 0
         INVOKE     BaseAscii, SPos, addr cnt3, 4, 10, 0, 1, 0
         INVOKE     BaseAscii, Llen, addr cnt4, 4, 10, 0, 1, 0
         INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE2, addr Ldata
            jmp     MoveIt
      .endif

      .if wmsg == WM_MOUSEMOVE
            and     MultInst, 0
            jmp     MoveIt             
      .endif

      .if wmsg == WM_VSCROLL
         INVOKE     SendMessage, hwnd, EM_GETFIRSTVISIBLELINE, 0, 0
            inc     eax
            mov     Lnum, eax

         INVOKE     SendMessage, hwnd, EM_GETLINECOUNT, 0, 0
            dec     eax
            mov     Ltot, eax
            mov     SPos, 0
            mov     Llen, 0
;            jmp     Countem
      .endif

      .if wmsg == WM_RBUTTONDOWN
            jmp     PopUp
      .endif
         jmp     ThatsAll

PopUp:
        call     EnableDisableEditMenu
      INVOKE     GetWindowRect,hWnd,addr rect
         mov     eax, lparam        ; x/y pos of window
         mov     ebx, eax
         and     ebx, 0000ffffh     ; ebx = LOWORD(lparam) = x pos
         shr     eax, 16            ;eax = HIWORD(lparam) = y pos
         add     ebx, rect.left
         add     eax, rect.top
         mov     XP, ebx            ; x position
         mov     YP, eax            ; y position
         add     XP, 10 
         add     YP, 70
      INVOKE     TrackPopupMenu, hSMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, XP, YP, 0, hWnd, addr rect
        jmp      ThatsAll

MoveIt:
         mov     eax, lparam        ; Get the y
         shr     eax, 16            ; position in hiword(lparam)
      .if ax > 9000
            xor     eax, eax
      .endif
      INVOKE     BaseAscii, eax, addr mmsgy, 4, 10, 0, 1, 1
         mov     eax, lparam        ; Get the x
         cwde                       ; position in loword(lparam)
      .if ax > 9000
             xor     eax, eax
      .endif
      INVOKE     BaseAscii, eax, addr mmsgx, 4, 10, 0, 1, 0
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MOUSEMOVE, addr mmsg

ThatsAll:
      INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam

         ret
RichEditProc ENDP

;=========================================================================
; Find / Replace PROCEDURE                                               *
;=========================================================================
FindReplace PROC    uses ebx edi esi hdlg:DWORD, wmsg, wparam, lparam

      .if wmsg == WM_INITDIALOG      ; If message is INITDIALOG then
            mov     sw1, 0
            mov     eax, hdlg
            mov     hFRDlg, eax
         INVOKE     GetDlgItem, hdlg, EditF  ; Get handle of edit box
           push     eax                      ; Save handle of edit1
         INVOKE     SetFocus, eax            ; Set focus to this field
            pop     eax
         INVOKE     SendMessage, eax, EM_LIMITTEXT, 100, 0 ; Limit text size
         INVOKE     GetDlgItem, hdlg, EditR
         INVOKE     SendMessage, eax, EM_LIMITTEXT, 100, 0 ; Limit text size
         INVOKE     lstrlen, addr szFind
         .if eax == 1 && szFind == ' '
               mov     szFind, 0
         .endif
         INVOKE     SetDlgItemText, hdlg, EditF, addr szFind
         INVOKE     SetDlgItemText, hdlg, EditR, addr szRep
         INVOKE     GetDlgItem, hdlg, rb2    ; Get search down check
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets find down to checked
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
            and     FRFlags, 0
            jmp     FRDone
      .endif
         cmp     wmsg, WM_COMMAND
         jne     FRDone

      .if wparam == FIND || wparam == REPLACE || wparam == REPLACEALL
            jmp     FRText
      .endif
         cmp     wparam, IDCANCEL
          je     CloseIt
         jmp     FRDone

FRText:
         and     FRFlags, 0
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
      INVOKE     GetDlgItemText, hdlg, EditF, addr szFind, 100
       MOVmd     ft.chrg.cpMin, cr.cpMin
         mov     ft.chrg.cpMax, -1
         lea     eax, offset szFind
         mov     ft.lpstrText, eax

      .if wparam != FIND    
        INVOKE      GetDlgItemText, hdlg, EditR, addr szRep, 100
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, cb1
      .if eax
             or     FRFlags, FR_WHOLEWORD
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, cb2
      .if eax
             or     FRFlags, FR_MATCHCASE
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb1
      .if eax
            mov     Prev, 1
            mov     ft.chrg.cpMax, 0
      .endif
      INVOKE     IsDlgButtonChecked, hdlg, rb2
      .if eax
            mov     Prev, 0
             or     FRFlags, FR_DOWN
      .endif
      .if wparam == FIND
        INVOKE     Find, hWnd, 0, FRFlags, ft.lpstrText, Prev
          call     EnableDisableEditMenu
      .endif

Again:
      .if wparam != FIND
         INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szRep
            mov     eax, cr.cpMin
            mov     cr.cpMax, eax
         INVOKE     lstrlen, addr szRep
            add     cr.cpMax, eax
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     GetMenu, hWnd        ; Enable the replace next command
         INVOKE     EnableMenuItem, eax, IDM_REPLACENEXT, MF_BYCOMMAND or MF_ENABLED
           call     EnableDisableEditMenu
         .if Prev
               sub     ft.chrg.cpMin, 1
         .else
               add     ft.chrg.cpMin, 1
         .endif
         INVOKE     Find, hWnd, 0, FRFlags, ft.lpstrText, Prev
         .if eax != 1
            INVOKE     GetMenu, hWnd     ; Enable the replace next command
            INVOKE     EnableMenuItem, eax, IDM_REPLACENEXT, MF_BYCOMMAND or MF_GRAYED
               jmp     FRDone
         .endif 
         .if wparam == REPLACEALL
               jmp     Again
         .endif
      .endif
         jmp     FRDone

CloseIt:
      INVOKE     GetMenu, hWnd           ; Enable the replace next command
      INVOKE     EnableMenuItem, eax, IDM_REPLACENEXT, MF_BYCOMMAND or MF_GRAYED
      INVOKE     EndDialog, hdlg, wparam ; End the dialog with wparam as return
         mov     eax, TRUE               ; Return
         and     hFRDlg, 0
         jmp     FRRet                   ; with TRUE
FRDone:
         mov     eax, FALSE              ; Return with FALSE
FRRet:
         ret                             ; Return
FindReplace  ENDP

;=========================================================================
; FindProc returns TRUE or FALSE based on finding Text                   *
;=========================================================================
Find    PROC     hwnd:DWORD, Next, Flags, FText, Up
      INVOKE     lstrlen, FText
         mov     Len, eax

Loop1:
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FRFlags, addr ft
         cmp     eax, -1                 ; Nothing found?
         jne     FoundIt
      .if Up == 0
         INVOKE     lstrcpyn, addr TopBot, addr Top, 6
      .else
         INVOKE     lstrcpyn, addr TopBot, addr Bot, 6
      .endif
      INVOKE     MessageBox, NULL, addr FindEnd, addr szFR, MB_YESNO or MB_ICONQUESTION or MB_TASKMODAL
      .if eax == IDNO
            mov     eax, TRUE
            jmp     Ret0
      .endif
      .if Up == 0
            mov     cr.cpMin, 0
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
      .else
            mov     eax, bytesread
         .if !eax
            INVOKE     SendMessage, hREdit, WM_GETTEXTLENGTH, 0, 0
         .endif
            mov     ft.chrg.cpMin, eax
            mov     ft.chrg.cpMax, 0
      .endif
         jmp     Loop1

FoundIt:
      .if eax == cr.cpMin && eax != cr.cpMax && Up == 0
            add     ft.chrg.cpMin, 1
            jmp     Loop1
      .endif
         mov     cr.cpMin, eax
         mov     ft.chrg.cpMin, eax
         add     eax, Len
         mov     cr.cpMax, eax

      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

      INVOKE     GetScrollInfo, hREdit, SB_VERT, addr sci
       MOVmd     SavScroll, sci.nPos
        call     CenterSel
      INVOKE     GetMenu, hwnd
      INVOKE     EnableMenuItem, eax, IDM_FINDNEXT, MF_BYCOMMAND or MF_ENABLED
         mov     eax, TRUE
         jmp     Ret1
Ret0:
         mov     eax, FALSE
Ret1:
         ret
Find    ENDP

;=========================================================================
; Scroll selection to center PROCEDURE                                   *
;=========================================================================
CenterSel  PROC   uses ebx edx

      INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
         mov     TopLine, eax
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
      INVOKE     SendMessage, hREdit, EM_EXLINEFROMCHAR, 0, eax
         mov     ebx, NScrL
         shr     ebx, 1
      .if eax < ebx
            xor     ebx, ebx
            jmp     GetSettings
      .endif
         mov     edx, TopLine
         xor     ecx, ecx
         add     edx, ebx
      .if edx > eax
            mov     ebx, edx
            sub     ebx, eax
            sub     ecx, ebx
      .else
            mov     ebx, eax
            sub     ebx, edx
            add     ecx, ebx
      .endif

         xor     edx, edx
         mov     eax, sci.nPage
         mov     ebx, NScrL
dec     ebx
         div     ebx
        imul     eax, ecx
         mov     ebx, SavScroll
      .if eax > 7fffffffh
            neg     eax
            sub     ebx, eax
      .else
            add     ebx, eax
      .endif

GetSettings:
         mov     SavScroll, ebx
        call     SetScroll
       MOVmd     SavScroll, sci.nPos
      INVOKE     SetFocus, hREdit
      INVOKE     RichEditProc, hREdit, WM_LBUTTONUP, 0, 0
         ret
CenterSel  ENDP

;=========================================================================
; Syntax PROCEDURE                                                       *
;=========================================================================
Syntax   PROC   uses ebx edi esi
LOCAL    pt:POINT 
LOCAL    SPos1:DWORD, EPos1, BuffSize, Chg, hEDC, hRgn, hOldRgn, InLen, sedi, Tabsw

         and     sw2, 0
         and     Tabsw, 0
      .if KUP
         .if PathName
               and     KDN, 0
               jmp     NotNew
         .endif

           call     ScreenLines
         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     cr.cpMin, eax                         ; Top line
            add     eax, ScrL                             ; Number of lines per screen
            mov     cr.cpMax, eax                         ; Last line
         INVOKE     SendMessage, hREdit, EM_LINEINDEX, cr.cpMin, 0
            mov     cr.cpMin, eax                         ; Address of first char
         INVOKE     SendMessage, hREdit, EM_LINEINDEX, cr.cpMax, 0
            mov     cr.cpMax, eax                         ; Address of last char
            mov     ebx, ScrL
         .if eax == -1 || ebx > Ltot
            INVOKE     SendMessage, hREdit, WM_GETTEXTLENGTH, 0, 0
               inc     eax
               mov     cr.cpMax, eax
         .endif
            jmp     FromNewDoc
      .endif

NotNew:
      .if w7 == 9                                         ; From paste
            and     w7, 0
         INVOKE     SendMessage, hREdit, EM_GETLINECOUNT, 0, 0
            dec     eax
            mov     Ltot, eax
      .endif

      INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
         mov     cr.cpMin, eax                            ; Top line
         add     eax, ScrL                                ; Number of lines per screen
         mov     cr.cpMax, eax                            ; Last line
         add     cr.cpMax, 1
         mov     eax, Ltot
      .if cr.cpMin > 0 && cr.cpMax > eax || ScrL > eax
            mov     cr.cpMax, eax
      .endif

      INVOKE     SendMessage, hREdit, EM_LINEINDEX, cr.cpMin, 0
         mov     cr.cpMin, eax                            ; Address of first char
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, cr.cpMax, 0
         mov     cr.cpMax, eax                            ; Address of last char
      .if KUP  ; Try to remove the KUP condition for normal scroll
            and     KUP, 0
         INVOKE     SendMessage, hREdit, EM_LINELENGTH, eax, 0
            add     cr.cpMax, eax
      .endif

FromNewDoc:
      .if FirstTime
            and     FirstTime, 0
           call     BuildfsMem
       .endif
       MOVmd     tr.chrg.cpMin, cr.cpMin
       MOVmd     tr.chrg.cpMax, cr.cpMax
         mov     eax, fsMem
         mov     tr.lpstrText, eax
      INVOKE     SendMessage, hREdit, EM_GETTEXTRANGE, 0, addr tr
         cmp     eax, 0
          je     GetOut
         mov     BuffSize, eax

mov     edi, fsMem                             ; Start address in input buffer
mov     byte ptr[edi+eax], 0dh

;         mov     ecx, eax
;         mov     esi, fsMem
;        call     LowerCase                                ; Convert to lower case
;         mov     eax, fsMem                               ; Start address in input buffer LC file in memory
;         mov     SavAddr, eax                             ; Offset of file
       MOVmd     SavAddr, fsMem                           ; Start address in input buffer in memory

      INVOKE     GetClientRect, hREdit, addr rect
         mov     eax, rect.left
         add     eax, 10
         mov     ebx, rect.top
         add     ebx, 3
         sub     rect.right, 1
         sub     rect.bottom, 4
      INVOKE     CreateRectRgn, eax, ebx, rect.right, rect.bottom
         mov     hRgn, eax

      INVOKE     GetDC, hREdit
         mov     hEDC, eax
;      INVOKE     SetBkColor, hEDC, BackGC
      INVOKE     SetBkMode, hEDC, TRANSPARENT
      INVOKE     SelectObject, hEDC, hFont
      INVOKE     SelectObject, hEDC, hRgn
         mov     hOldRgn, eax
         mov     edi, SavAddr                             ; Start address in input buffer
         xor     ecx, ecx

LoopStr:
         cmp     ecx, cr.cpMax
         jae     GetOut
         mov     eax, edi
         sub     eax, fsMem
         cmp     eax, BuffSize
          ja     GetOut

         mov     al, byte ptr[edi]
      .if al == ' ' || al == 9h || al == 0dh || al == 0ah || al == 0  ; (SP), (HT), (CR), (LF)
            inc     edi
            inc     ecx
            jmp     LoopStr
      .endif

         mov     SPos1, edi

      .if sw2 == 2
            and     sw2, 0
          MOVmd     charF.crTextColor, Color01[12]        ; API or Proc Color
            jmp     RunOut
      .endif

      .if Tabsw                                           ; Finish comment
            and     Tabsw, 0
            jmp     FinishC
      .endif

;---------- [Comments] ----------
      .if byte ptr[edi] == ';'                            ; (;)       -comments
FinishC:
          MOVmd     charF.crTextColor, Color01            ; Comment Color
            mov     SPos1, edi
CommA:
         .if byte ptr[edi] == 0dh || byte ptr[edi] == 0ah || byte ptr[edi] == 09h || byte ptr[edi] == 0  ; (CR), (LF), (HT)
               mov     EPos1, edi
            .if byte ptr[edi] == 09h
                  mov     Tabsw, 1                        ; Set for runout of comments
            .endif
               jmp     GotIt
         .endif

            inc     edi
            inc     ecx
            cmp     ecx, cr.cpMax                         ; Bytes to read
             ja     GetOut
            jmp     CommA
      .endif

;---------- [Qoutes] ----------
      .if byte ptr[edi] == '"' || byte ptr[edi] == "'"    ; ("), (')  -quotes
          MOVmd     charF.crTextColor, Color01[4]         ; Quot Color
            mov     al, byte ptr[edi]
            mov     SPos1, edi
            inc     edi
            inc     ecx

QuoteA:
         .if byte ptr[edi] == al || byte ptr[edi] == 0dh  ; ('), ("), (CR) CR is for wordwrap
               mov     EPos1, edi
               add     EPos1, 1
               jmp     GotIt
         .endif
            inc     edi
            inc     ecx
            cmp     ecx, cr.cpMax                         ; Bytes to read
             ja     GetOut
            jmp     QuoteA
      .endif

;---------- [Labels or XXX_XXXXXX] ----------
      .if byte ptr[edi] == ':' || byte ptr[edi] == '_'    ; (:), (_) - XXX_XXXXXX
         .if byte ptr[edi-1] == ' ' || byte ptr[edi-1] == 9h
               jmp     Pass
         .endif
          MOVmd     charF.crTextColor, Color01[8]         ; Label Color
;          MOVmd     SPos1, SavAddr
mov     SPos1, edi
           push     edi
            xor     esi, esi

LabApi:
            dec     edi
            inc     esi
         .if byte ptr[edi-1] == 0dh || byte ptr[edi-1] == 0ah || byte ptr[edi-1] == ',' ||\
             byte ptr[edi-1] == '.' || byte ptr[edi-1] == 09h || byte ptr[edi-1] == ' ' ||\
             byte ptr[edi-1] == '=' || byte ptr[edi] == ',' || edi == SavAddr ; (CR), (LF), (,), (HT), (SP), (=)
               mov     SPos1, edi
               pop     edi
            .if byte ptr[edi] == 5fh
                MOVmd     charF.crTextColor, Color01[20]  ; Underbar
                  dec     ecx
                  jmp     RunOut
            .endif
               mov     EPos1, edi
;               add     EPos1, 1
               jmp     GotIt
         .endif
            .if esi < 20 && edi > SavAddr  ;15
                  jmp     LabApi
            .endif
            pop     edi
      .endif

;========== [            ****    K E Y W O R D   A R R A Y    ****            ] ==========

;---------- [Check to see if a valid character] ----------
         mov     w5, ecx                                  ; Save increment count
         mov     al, byte ptr[edi-1]
      .if al == ' ' || al == 9h  || al == ',' || al == 0dh || al == ':' || al == '[' ||\
          al == '+' || al == '-' || al == '*' || al == '=' || al == '(' || al == '>' ||\
          al == '<' || al == '!' || al == '/' || !ecx     ; 0dh will highlight column one
            mov     al, byte ptr[edi]
         .if al > 40h && al < 5bh || al > 60h && al < 7bh || al == '.' || al == '#'
               jmp     GotOne
         .else
               jmp     Pass
         .endif
      .endif
         jmp     Pass

GotOne:
;---------- [Get the length of the text word (for speed)] ----------
         and     InLen, 0
         mov     ecx, 25                                  ; Set max size
         mov     edx, 1
      .while (ecx)
            mov     bl, byte ptr[edi+edx]
         .if bl == '_' ;|| bl == '.' && ecx < 25
               jmp     Pass                               ; Bypass the loop for these imbedded char
         .endif
         .if bl == ',' || bl == ' ' || bl == '!' || bl == '=' || bl == '(' || bl == ')' || bl == ']' ||\
             bl == '[' || bl == '/' || bl == '+' || bl == '-' || bl == '*' || bl == '>' || bl == '<' ||\
             bl == '\' || bl == '.' || bl == 09h || bl == 0dh
            .if edx == 1
                  jmp     OneMore
            .endif
               mov     InLen, edx
            .break
         .endif

OneMore:
            inc     edx
            dec     ecx
      .endw

;---------- [Get the offset in the keyword Array] ----------
         xor     ebx, ebx
         mov     bl, al
      .if bl >= 'A' && bl <= 'Z'
            add     bl, 20h
      .endif
         mov     esi, IDArray
         mov     eax, [esi+ebx*4]                         ; Offset into the keyword array
         mov     ebx, hwMem                               ; Address of the keyword array 
         add     ebx, eax
         mov     ecx, dword ptr[ebx+1]                    ; Keyword length
         mov     al, byte ptr[ebx+10]
         cmp     al, 0
          je     Pass                                     ; Not a valid keyword
         mov     szByte, al

LoopArray:
         add     ebx, 10                                  ; Increment past size and color
      .if InLen && ecx != InLen                           ; Compare the text and keyword length
            jmp     DoMore   ; FIX ?????????????          ; Get the next Array
      .endif
         xor     eax, eax
         mov     Len, ecx
      .while (Len)
            mov     dl, byte ptr[edi+eax]                 ; Text
         .if dl >= 'A' && dl <= 'Z'
               add     dl, 20h                            ; Change text to lowed case
         .endif
         .if dl == byte ptr[ebx+eax]                      ; Compare text with the Array
               inc     eax
               dec     Len
         .elseif ecx > Len && dl < byte ptr[ebx+eax]      ; If text is < keyword
               jmp     Pass                               ; get out of the loop
         .else
            .break
         .endif
      .endw

      .if !Len
            mov     eax, dword ptr[ebx-4]                 ; Array group and color pointer
          MOVmd     charF.crTextColor, Color01[eax*4]     ; Offset into the color array
         .if eax == 5                                     ; Invoke and call
               mov     sw2, 2                             ; 2 = API and proc color
         .endif
            mov     eax, ecx
            add     edi, eax
            mov     EPos1, edi
            jmp     GotIt
      .else

DoMore:
            inc     ecx                                   ; ecx = length of previous word
            add     ebx, ecx                              ; Offset to next Array
            mov     eax, ebx
            sub     eax, hwMem
         .if eax > ArraySize
               jmp     Pass
         .endif
            mov     ecx, dword ptr[ebx+1]                 ; Word length
            mov     al, byte ptr[ebx+10]                  ; First character of keyword

         .if al != szByte                                 ; szByte = Text character
               jmp     Pass
         .endif
            jmp     LoopArray
      .endif
          jmp     Pass

Pass:
         mov     ecx, w5                                  ; Restore increment count
         inc     edi
         inc     ecx
         jmp     LoopStr

RunOut:
         cmp     ecx, cr.cpMax                            ; Runout
          ja     TheEnd
         inc     ecx
         mov     eax, edi
         sub     eax, fsMem
         cmp     eax, BuffSize
          ja     GetOut                                   ; For sw2

      .if byte ptr[edi] == ' ' || byte ptr[edi] == ',' || byte ptr[edi] == 9h ||\
          byte ptr[edi] == ']' || byte ptr[edi] == 0  ; 0 is for sw2; (SP), (,), (HT)
TheEnd:
            mov     EPos1, edi
            dec     edi
            dec     ecx
            jmp     GotIt
      .endif
      .if byte ptr[edi] != 0dh                            ; CR
            inc     edi 
            jmp     RunOut
      .endif
         mov     EPos1, edi

GotIt:
        push     EPos1
        push     SPos1
         mov     eax, SavAddr                             ; Start address of memory buffer
         sub     eax, cr.cpMin                            ; Start address of screen buffer
         sub     SPos1, eax
         sub     EPos1, eax
         mov     eax, EPos1
         sub     eax, SPos1
         mov     Len, eax

      .if REVer3
         INVOKE     SendMessage, hREdit, EM_POSFROMCHAR, addr rect, SPos1
      .else
         INVOKE     SendMessage, hREdit, EM_POSFROMCHAR, SPos1, 0
            mov     ebx, eax
            and     ebx, 0ffffh
            mov     rect.left, ebx
            shr     eax, 16
            mov     rect.top, eax
      .endif
       MOVmd     rect.bottom, rect.top
         mov     eax, FontH                               ; Font height
         add     rect.bottom, eax  ;15
      INVOKE     SetTextColor, hEDC, charF.crTextColor
;      INVOKE     DrawText, hEDC, addr szBuffer, -1, addr rect, DT_NOPREFIX ;or DT_EDITCONTROL or DT_EXTERNALLEADING or DT_EXPANDTABS
         pop     ebx    ; ebx = SPos1
      INVOKE     DrawText, hEDC, ebx, Len, addr rect, DT_NOPREFIX or DT_EDITCONTROL ;or DT_EXTERNALLEADING or DT_EXPANDTABS

         mov     ecx, EPos1
         sub     ecx, cr.cpMin
         pop     edi
         inc     edi
         inc     ecx
         jmp     LoopStr

GetOut:
      INVOKE     SelectObject, hEDC, hOldRgn
      INVOKE     DeleteObject, hRgn
      INVOKE     ReleaseDC, hEdit, hEDC

         and     KUP, 0
         and     KDN, 0

         xor     eax, eax
         ret
Syntax   ENDP

;=========================================================================
; Column F1 thru F4 Position PROCEDURE                                   *
;=========================================================================
Column   PROC
LOCAL    Clear[256]:BYTE

      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
      INVOKE     SendMessage, hREdit, EM_GETSEL, addr SPos, 0  ; Current pos
         mov     ecx, w5
         sub     ecx, CurPos
        push     ecx
         add     SPos, ecx
         inc     ecx
         mov     eax, Llen
         inc     eax
      .if eax >= w5
            jmp     Set
      .endif
      INVOKE     lstrcpyn, addr WorkBuff, addr Clear, ecx
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr WorkBuff

Set:
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos, SPos
         pop     SPos
         ret
Column   ENDP

;=========================================================================
; Shift PROCEDURE                                                        *
;=========================================================================
Shift    PROC
LOCAL     Chg:DWORD, SPos1, EPos1, SavPos
LOCAL     szWork[256]:BYTE, Clear[256]

      INVOKE     FillBuffer, addr Clear, lengthof Clear, ' ', 1
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
         and     sw1, 0 
      INVOKE     SendMessage, hREdit, EM_GETSEL, addr SPos1, addr EPos1  ; Current pos
       MOVmd     SavPos, SPos1

Again:
      INVOKE     SendMessage, hREdit, EM_LINELENGTH, SPos1, 0
         inc     eax
       MOVmd     EPos1, SPos1
         add     EPos1, eax
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos1, EPos1
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr WorkBuff
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos1, SPos1
         mov     al, 0dh               ; Carrage return
         mov     edi, offset WorkBuff  ; Start address in input buffer
         mov     ecx, EPos1
         cld                           ; Increment edi
       repnz     scasb                 ; Repeat until byte = al(13)
         mov     ecx, edi
         sub     ecx, offset WorkBuff
         mov     EPos1, ecx
      INVOKE     lstrcpyn, addr szWork, addr WorkBuff, ecx
         cmp     sw1, 1
          je     ShiftL
      .if Misc == 'S'
            mov     eax, SHIFT
            mov     ecx, CurPos
         .if eax > ecx
            .if byte ptr szWork == ' '
                 push     ecx
               INVOKE     lstrlen, addr szWork
                  pop     ecx
                  lea     edi, szWork            ; Start address in input buffer
               .while (eax)
                  .if byte ptr[edi] == ' '
                        inc     edi
                        inc     SPos1
                        inc     ecx
                        dec     eax
                  .else
                        mov     CurPos, ecx
                        jmp     Again
                  .endif
               .endw
            .endif
               sub     eax, ecx
               jmp     ShiftR
         .else
               sub     ecx, eax
               sub     SPos1, ecx
               mov     CurPos, eax
                or     sw1, 1
               jmp     Again 
         .endif
      .endif
      .if Misc == 'R'
            mov     eax, SPACE

ShiftR:
            inc     eax
         INVOKE     lstrcpyn, addr WorkBuff, addr Clear, eax
         INVOKE     SendMessage, hREdit, EM_SETSEL, SPos1, SPos1
            jmp     Replace
      .endif
      .if Misc == 'L'
            mov     ecx, SPACE             ; Increments

ShiftL:
            lea     edi, szWork            ; Start address in input buffer

Loop1:
            cmp     byte ptr[edi], 20h
             je     Cont
            cmp     byte ptr[edi], 09h
            jne     GotEm

Cont:
            inc     edi
            dec     ecx
             jz     GotEm
            jmp     Loop1

GotEm:
            mov     eax, SPos1
            dec     eax                    ; For Richedit V2, V3
            add     EPos1, eax
         INVOKE     lstrcpy, addr WorkBuff, edi
         INVOKE     SendMessage, hREdit, EM_SETSEL, SPos1, EPos1
      .endif

Replace:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr WorkBuff
       MOVmd     SPos1, SavPos
      INVOKE     SendMessage, hREdit, EM_SETSEL, SPos1, SPos1

NoMore:
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         ret
Shift    ENDP

;=========================================================================
; HTML to Text Converter PROCEDURE                                       *
;=========================================================================
HTML     PROC  uses ebx
      .if ExtType == 'h' && ExtType + 1 == 't' && ExtType + 2 == 'm'
            jmp     htmlOK
      .else   
         INVOKE     MessageBox, NULL, addr NoHTML, addr pTitle, MB_YESNO or MB_ICONQUESTION or MB_TASKMODAL
            cmp     eax, IDNO
             je     GetOut
      .endif
htmlOK:
         mov     ebx, hBuff
      INVOKE     lstrcpy, ebx, addr PathName
        call     readp
         mov     cr.cpMin, 0
         mov     cr.cpMax, -1
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
        call     BuildfsMem 
         mov     esi, fpMem
         mov     edi, fsMem
         mov     ecx, bytesread
         mov     sw1, 0
         mov     sw2, 0
      .while (ecx)
            mov     al, byte ptr[esi]
         .if al == '<'
            .if word ptr[esi+1] == '-!'
                   or     sw2, 1
            .endif
               mov     sw1, 1
               jmp     NoCopy
         .endif
         .if al == '>'
            .if word ptr[esi-2] == '--'
                  and     sw2, 0
            .endif
               and     sw1, 0
               jmp     NoCopy
         .endif
            .if sw1 == 0 && sw2 == 0
               .if al == 0dh && edi > fsMem
                  .if byte ptr[edi-2] == 0dh
                       inc     esi
                       dec     ecx
                       jmp     NoCopy
                  .endif
               .endif
                  mov     byte ptr[edi], al
                  inc     edi
            .endif
NoCopy:
            inc     esi
            dec     ecx
      .endw
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, fsMem
      INVOKE     GlobalUnlock, fpMem
      INVOKE     GlobalFree, hpMem
         mov     hpMem, 0
         and     sw1, 0
         and     sw2, 0
      INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0
GetOut:
         ret
HTML     ENDP

;=========================================================================
; Convert Tab Stops PROCEDURE                                            *
;=========================================================================
ConvTabs PROC  uses edx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    Val:DWORD
LOCAL    Clear[256]:BYTE

         cmp     wmsg, WM_INITDIALOG    ;if message is not INITDIALOG then
         jne     NotInit
         and     sw1, 0
         and     cnt, 0
         jmp     ConvDone

NotInit:
         cmp     wmsg, WM_COMMAND
         jne     ConvDone
         mov     eax, wparam
         cmp     eax, IDCONVERT
          je     Convit
         cmp     eax, IDFINDTS
          je     Findit
         cmp     eax, REPLACE
          je     Replaceit
         cmp     eax, IDUNDO
          je     Undo
         cmp     eax, IDSETUP
          je     CallSetup
         cmp     eax, IDCANCEL
         jne     ConvDone

Endit:
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE
         jmp     ConvRet

Findit:
      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
      .if sw1 == 0
            mov     sw1, 1
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
            lea     eax, offset szHT
            mov     ft.lpstrText, eax
            mov     FRFlags, 1
      .endif

LFind:
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, FRFlags, addr ft
         cmp     eax, -1                 ; Nothing found?
          je     ConvDone
         mov     cr.cpMin, eax
         inc     eax
         mov     cr.cpMax, eax
        push     cr.cpMin
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         pop     cr.cpMin
        push     cr.cpMin
         inc     cr.cpMin
       MOVmd     ft.chrg.cpMin, cr.cpMin
      INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
         pop     ecx
         sub     ecx, eax
         inc     ecx
         xor     edx, edx
         mov     eax, TabStops[edx]
      .while (ecx >= eax)
            add     edx, 4
            mov     eax, TabStops[edx]
      .endw
         sub     eax, ecx
         inc     eax
      INVOKE     lstrcpyn, addr szBuff, addr Clear, eax
      .if Val == 5
            jmp     Replaceit
      .endif
         jmp     ConvDone

Replaceit:
      INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szBuff
         inc     cnt
      INVOKE     BaseAscii, cnt, addr Misc, 0, 10, 0, 0, 1
      INVOKE     SetDlgItemText, hdlg, IDC_EDIT1, addr Misc
      .if Val == 5
            jmp     LFind
      .endif
         jmp     ConvDone

Convit:
         mov     sw1, 0
         mov     Val, 5
         jmp     Findit

Undo:
         mov     OA, 1
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
        call     OpenFileA
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, EBook
         and     Val, 0  
         and     cnt, 0
      INVOKE     SetDlgItemText, hdlg, IDC_EDIT1, addr cnt
         and     sw1, 0
        call     TabStop
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, 0, 0
         jmp     ConvDone

CallSetup:
         mov     w7, 0
      INVOKE     CreateDialogParam, hInst, IDD_SETUP, hWnd, addr Setup, 0
         jmp     ConvDone
ConvDone:
         mov     eax, FALSE
ConvRet:
         ret
ConvTabs ENDP

;=========================================================================
; About PROCEDURE                                                        *
;=========================================================================
AbVerDlg PROC  hdlg:DWORD, wmsg, wparam, lparam

      .if wmsg == WM_INITDIALOG
         mov     ms.dwLength, sizeof ms
      INVOKE     GlobalMemoryStatus, addr ms
      INVOKE     BaseAscii, ms.dwTotalPhys, addr szBuff, 10, 10, 1, 0, 1
      INVOKE     SetDlgItemText, hdlg, E2, addr szBuff
      INVOKE     BaseAscii, ms.dwAvailPhys, addr szBuff, 10, 10, 1, 0, 1
      INVOKE     SetDlgItemText, hdlg, E3, addr szBuff
      INVOKE     BaseAscii, ms.dwMemoryLoad, addr szBuff, 2, 10, 0, 0, 1
      INVOKE     SetDlgItemText, hdlg, E4, addr szBuff

      .elseif wmsg == WM_CLOSE
            jmp     EndIt
      .elseif wmsg != WM_COMMAND
            jmp     AbVerDone
      .endif
         mov     eax, wparam
         cmp     eax, IDOK
          je     EndIt
         jmp     AbVerDone

EndIt:
      INVOKE     EndDialog, hdlg, wparam ; End the dialog with wparam as return
         mov     eax, TRUE               ; Return
         jmp     AbVerRet                ; with TRUE

AbVerDone:
         mov     eax, FALSE              ; Return with FALSE

AbVerRet:
         ret
AbVerDlg ENDP

;=========================================================================
; esi = input string pointer ecx = len get before call                   *
; returns string converted to lower case                                 *
;=========================================================================
LowerCase PROC

         xor     eax, eax
      .while ecx
         .if byte ptr[esi+eax] >= 'A' && byte ptr[esi+eax] <= 'Z'
;               and     byte ptr[esi+eax], 0dfh  ; and off lower case bit
               add     byte ptr[esi+eax], 20h   ; add 20h to upper case bit
         .endif
            inc     eax
            dec     ecx
      .endw
         ret

LowerCase ENDP

;=========================================================================
; ASCII PROCEDURE - ASCII Win is a Sub Class                             *
;=========================================================================
AsciiProc   PROC  hwnd:DWORD, wmsg, wparam, lparam

      .if wmsg == WM_CHAR
          MOVmd     w4, wmsg
          MOVmd     Hold, wparam
         INVOKE     BaseAscii, wparam, addr szBuff, 0, 10, 0, 0, 1
         INVOKE     BaseAscii, wparam, addr WorkBuff, 0, 16, 0, 0, 1
            mov     eax, hwnd
         .if eax == hAsciibox
               mov     Misc, 0
              call     ChkKey
            .if Misc
               INVOKE     SendMessage, hAsciibox, WM_SETTEXT, NULL, addr Misc
                  mov     w4, 0
                  jmp     EndIt
            .endif
         .endif
         INVOKE     SendMessage, hAsciibox, EM_SETSEL, 0, -1
      .endif

EndIt:
       INVOKE        CallWindowProc, lpAsciibox, hwnd, wmsg, wparam, lparam
            ret
AsciiProc   ENDP

;=========================================================================
; ASCII PROCEDURE                                                        *
;=========================================================================
AsciiDlg PROC  uses ebx esi hdlg:DWORD, wmsg, wparam, lparam
LOCAL    Num:DWORD, Var1, Var2
LOCAL    szWork[10]:BYTE

      .if wmsg == WM_INITDIALOG      ; If message is INITDIALOG then
         INVOKE     CheckDlgButton, hdlg, 31, BST_CHECKED   ; Sets Hex type
          MOVmd     w2, hdlg
            mov     HexDec, 16
            jmp     AsciiDone
      .endif

         cmp     wmsg, WM_COMMAND
         jne     AsciiDone
         mov     eax, wparam
         cwde

      .if eax == 31 || eax == 32
            mov     w4, WS_CHILD or WS_VISIBLE or  WS_BORDER or ES_UPPERCASE or ES_CENTER or ES_AUTOHSCROLL
            mov     Var1, 2
            mov     Var2, E2
         .if eax == 31
               mov     HexDec, 16
         .else
               mov     HexDec, 10
                or     w4, ES_NUMBER
               mov     Var1, 3
               mov     Var2, E1
         .endif
         INVOKE     SetWindowLong, hInput, GWL_STYLE, w4
         INVOKE     SendMessage, hInput, EM_LIMITTEXT, Var1, 0 ; Limit text size
         INVOKE     GetDlgItemText, hdlg, Var2, addr Misc, sizeof Misc
           push     eax
         INVOKE     SetDlgItemText, hdlg, 42, offset Misc
            pop     eax
         INVOKE     SendMessage, hInput, EM_SETSEL, eax, eax
         INVOKE     SetFocus, hInput

      .elseif eax ==  41 && w4 == WM_CHAR
         INVOKE     SetDlgItemText, hdlg, E1, addr szBuff
         INVOKE     SetDlgItemText, hdlg, E2, addr WorkBuff

      .elseif eax ==  42 && w4 == WM_CHAR
         INVOKE     GetDlgItemText, hdlg, 42, addr szWork, sizeof szWork

;---------- [Validate the user input characters] ----------
            mov     Num, eax
            cmp     HexDec, 10
             je     NoValidate
            xor     esi, esi
         .while (eax)
               mov     bl, byte ptr szWork[esi]
            .if bl > 2fh && bl < 3ah || bl > 40h && bl < 47h || bl > 60h && bl < 67h
                  jmp     HexOK
            .else

ReSet:
                  mov     eax, Num
                  mov     ebx, eax
                  dec     eax
                  mov     Misc, 0
               INVOKE     SendMessage, hInput, EM_SETSEL, eax, ebx
               INVOKE     SendMessage, hInput, EM_REPLACESEL, FALSE, addr Misc
                  jmp     ConvertErr
            .endif

HexOK:
               inc     esi
               dec     eax
         .endw

NoValidate:
         INVOKE     GetDlgItemText, hdlg, 42, addr szWork, sizeof szWork
            mov     Num, eax
         INVOKE     lstrcpy, addr szBuff, addr szWork
         .if HexDec == 16
            .if Num == 1
                  mov     ax, word ptr szBuff
                  mov     szBuff+1, al
                  mov     szBuff+2, ah
                  mov     byte ptr szBuff, '0'
            .endif
               mov     Var1, E2
               mov     Var2, E1
         .else
               mov     Var1, E1
               mov     Var2, E2
         .endif
         INVOKE     AsciiBase, addr szWork, addr Hold, HexDec
         .if Hold > 255
               jmp     ReSet
         .endif
         INVOKE     SetDlgItemText, hdlg, Var1, addr szBuff
         .if HexDec == 16
            INVOKE     BaseAscii, Hold, addr szBuff, 0, 10, 0, 0, 1
         .else
            INVOKE     BaseAscii, Hold, addr szBuff, 2, 16, 0, 1, 1
         .endif
         INVOKE     SetDlgItemText, hdlg, Var2, addr szBuff
            mov     Misc, 0
           call     ChkKey
         .if !Misc
                MOVmb     Misc, Hold
                  mov     Misc+1, 0
         .endif
         INVOKE     SendMessage, hAsciibox, WM_SETTEXT, NULL, addr Misc
            jmp     AsciiDone
      .endif

         cmp     eax, IDCANCEL
         jne     AsciiDone
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE
         jmp     AsciiRet

ConvertErr:
      INVOKE     MessageBeep, MB_OK

AsciiDone:
         and     w4, 0
         mov     eax, FALSE

AsciiRet:
         ret
AsciiDlg ENDP

;=========================================================================
; Check for special key   CR, LF, etc.                                   *
;=========================================================================
ChkKey PROC
         .if Hold == 08h
               mov     word ptr Misc, 'SB'
               mov     Misc+2, 0
         .elseif Hold == 09h
               mov     word ptr Misc, 'TH'
               mov     Misc+2, 0
         .elseif Hold == 0ah
               mov     word ptr Misc, 'FL'
               mov     Misc+2, 0
         .elseif Hold == 0dh
               mov     word ptr Misc, 'RC'
               mov     Misc+2, 0
         .elseif Hold == 20h
               mov     word ptr Misc, 'PS'
               mov     Misc+2, 0
         .endif
         ret
ChkKey ENDP

;=========================================================================
; Fills a buffer with a character.                                       *
;=========================================================================
FillBuffer PROC  uses esi edi  Input:DWORD, SizeB:DWORD, Fill:BYTE, TermA:DWORD
         mov     esi, Input
         mov     edi, esi           ; Dest = Source
         mov     ecx, SizeB         ; Size to fill
         mov     al, Fill           ; Fill character

FillBuff:
       stosb                        ; Store al
        loop     FillBuff           ; for length of string
      .if TermA                     ; Write a terminating char
            dec     edi
            mov     byte ptr[edi], 0
      .endif
         ret
FillBuffer ENDP

;=========================================================================
; Converts a Dec, Hex, Oct or Bin ascii string to a 32 bit num value.    *
;=========================================================================
AsciiBase PROC Input:DWORD, Output, Base
      pushad
         mov     esi, Input
         mov     edi, Output
         and     dword ptr[edi], 0
      INVOKE     lstrlen, Input
         xor     ecx, ecx
      .while (eax)
         .if byte ptr[esi+ecx] > 60h
               sub     byte ptr[esi+ecx], 57h
         .elseif byte ptr[esi+ecx] > 40h
               sub     byte ptr[esi+ecx], 37h
         .else
               xor     byte ptr[esi+ecx], 30h
         .endif
            dec     eax
            inc     ecx
      .endw
         mov     ebx, 1
         mov     esi, Input
         add     esi, ecx
         dec     esi
         xor     edx, edx
      .while (ecx)
            mov     al, byte ptr[esi]      ; Extract byte for conversion
            and     eax, 000000ffh
           imul     eax, ebx
            add     dword ptr[edi], eax    ; Accumulate output
           imul     ebx, Base
            dec     esi
            dec     ecx 
      .endw
       popad
          ret
AsciiBase ENDP

;==========================================================================
;  Converts a 32 bit num value to a Dec, Hex, Oct or Bin ascii string.    *
;==========================================================================
;INVOKE     BaseAscii, cnt, addr num, 2, 10, 0, 1, 0
BaseAscii PROC InPut:DWORD, OutPut, LEN, Base, Comma, Fill, TermA
LOCAL    LBuff[32]: BYTE

      pushad
         xor     esi, esi
         mov     eax, InPut                ; Input
         mov     ebx, OutPut
         mov     byte ptr [ebx], '0'
      .while (eax)
            xor     edx, edx
            div     Base                   ; Base 10, 16, 8, 2
         .if dl > 9h
               add     dl, 37h             ; Convert to hex ASCII
         .else
               add     dl, 30h             ; Convert to dec ASCII
         .endif
            mov     LBuff[esi], dl
            inc     esi
         .if Comma == 1 && Base == 10 && eax > 0
            .if esi == 3 || esi == 7 || esi == 11
                  mov     LBuff[esi], 2ch  ; Insert commas
                  inc     esi
            .endif
         .endif
      .endw
         xor     edi, edi
         mov     ecx, esi
      .if LEN > ecx && Fill == 1           ; Zero fill
            xor     eax, eax
         .while (eax < LEN)
               mov     byte ptr [ebx+eax], '0'
               inc     eax
         .endw
            sub     LEN, ecx
            add     edi, LEN
      .endif
      .while (ecx)
            mov     al, byte ptr LBuff[esi-1]
            mov     byte ptr [ebx+edi], al
            inc     edi
            dec     esi
            dec     ecx
      .endw
      .if TermA
         mov     byte ptr [ebx+edi], 0h
      .endif
       popad
          ret
BaseAscii ENDP

;=========================================================================
; Format the time and send it to the status bar                          *
;=========================================================================
fmtime   PROC
LOCAL    hEDC:DWORD
LOCAL    Clear[256]:BYTE

      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
      INVOKE     BaseAscii, cnt, addr num, 2, 10, 0, 1, 0
         cmp     hWndStat, 0            ; Valid statusbar?
          jz     ftimex                 ; no, then exit
        push     offset time            ; Get the local
        call     GetLocalTime           ; time from win32
       MOVmw     HoldT, time.wDay
      INVOKE     BaseAscii, HoldT, addr dda, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wMonth
      INVOKE     BaseAscii, HoldT, addr dmo, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wYear
      INVOKE     BaseAscii, HoldT, addr dyr, 2, 10, 0, 1, 0
         mov     byte ptr[tmsgampm],'A' ; Default to AM
         cmp     time.wHour,  12        ; >12?
         jle     AM                     ; It's AM
         mov     byte ptr[tmsgampm],'P' ; Reset to PM
         sub     time.wHour, 12         ; -12
AM:
       MOVmw     HoldT, time.wHour
      INVOKE     BaseAscii, HoldT, addr tmsghour, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wMinute
      INVOKE     BaseAscii, HoldT, addr tmsgmin, 2, 10, 0, 1, 0
       MOVmw     HoldT, time.wSecond
      INVOKE     BaseAscii, HoldT, addr tmsgsec, 2, 10, 0, 1, 0
      INVOKE     GetDC, hWndStat
         mov     hEDC, eax
      INVOKE     SetTextColor, hEDC, 0000ff00h
      INVOKE     SetBkColor, hEDC, 00000000h
         mov     ebx, [parts+8]
         add     ebx, 2
      INVOKE     TextOut, hEDC, ebx, 3, addr Clear, 150
      INVOKE     lstrlen, offset tmsg
         add     ebx, 110
      .if parts < 200
            sub     ebx, 50 ;35
      .endif
      INVOKE     TextOut, hEDC, ebx, 3, offset tmsg, eax
      INVOKE     ReleaseDC, hWndStat, hEDC
ftimex:
         ret
fmtime   ENDP
         
;=========================================================================
; Set the title string in the main window                                *
;=========================================================================
SetTitle PROC
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
        push     eax
      INVOKE     lstrcpy, addr szBuff, addr pTitle
         cmp     PathName, 0
          je     NoFile
      INVOKE     lstrcat, addr szBuff, addr PathName
         jmp     TestDirty

NoFile:
      INVOKE     lstrcat, addr szBuff, addr szUntitled

TestDirty:
         pop     eax
         cmp     eax, FALSE
          je     NotDirty
;      INVOKE     lstrlen, addr szBuff
;         mov     dword ptr[szBuff+eax], 'HC  '

NotDirty:
      INVOKE     SetWindowText, hWnd, addr szBuff

Endit:
         ret
SetTitle ENDP

;=========================================================================
; Generate error message                                                 *
; eax = message # to display                                             *
; ebx = Title                                                            *
; ecx = MessageBox Flags                                                 *
;=========================================================================
CreateMsg PROC  uses ebx edx
        push     ebx
        push     ecx
         mov     edx, hHead
      INVOKE     LoadString, hInst, eax, edx, 256
         cmp     eax, 0           ; Did we get a string?
         jne     Error1           ; Yes, continue
         lea     eax, szNULL      ; Null string

Error1:
         pop     ecx
         pop     ebx
         mov     edx, hHead
      INVOKE     MessageBox, NULL, edx, ebx, ecx
         ret
CreateMsg ENDP

;=========================================================================
; Enable or disable the items in the edit Menu and Toolbar               *
;=========================================================================
EnableDisableEditMenu PROC
      INVOKE     EnableMenuItem, hMenu, IDM_UNDOREDO, MF_GRAYED
      INVOKE     SendMessage, hREdit, EM_CANUNDO, 0, 0
         cmp     eax, TRUE
         jne     EdMu1
         mov     TempWord1, MF_ENABLED
      INVOKE     EnableMenuItem, hMenu, IDM_UNDOREDO, TempWord1
         jmp     EdMu2
EdMu1:
         mov     TempWord1, MF_GRAYED
EdMu2:
      INVOKE     EnableMenuItem, hMenu, IDM_UNDO, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_UNDO, TempWord1
         xor     TempWord1, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_UNDO, TempWord1
      INVOKE     SendMessage, hREdit, EM_CANREDO, 0, 0
         cmp     eax, TRUE
         jne     EdMu3
         mov     TempWord1, MF_ENABLED
      INVOKE     EnableMenuItem, hMenu, IDM_UNDOREDO, TempWord1
         jmp     EdMu4
EdMu3:
         mov     TempWord1, MF_GRAYED
EdMu4:
      INVOKE     EnableMenuItem, hMenu, IDM_REDO, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_REDO, TempWord1
         xor     TempWord1, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_REDO, TempWord1
      INVOKE     IsClipboardFormatAvailable, CF_TEXT
         cmp     eax, TRUE
         jne     EdMu5
         mov     TempWord1, MF_ENABLED
         jmp     EdMu6
EdMu5:
         mov     TempWord1, MF_GRAYED
EdMu6:
      INVOKE     EnableMenuItem, hMenu, IDM_PASTE, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_CLIP, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_PASTE, TempWord1
         xor     TempWord1, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_PASTE, TempWord1
         mov     eax, SBook
         cmp     eax, EBook         ;if no selection then gray otherwise enable
          je     EdMu7
         mov     TempWord1, MF_ENABLED
         jmp     EdMu8
EdMu7:
         mov     TempWord1, MF_GRAYED
EdMu8:
      INVOKE     EnableMenuItem, hMenu, IDM_CUT, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_CUT, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_COPY, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_COPY, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_DEL, TempWord1
      INVOKE     EnableMenuItem, hSMenu, IDM_DEL, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_FINDNEXT, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_FINDPREV, TempWord1

         xor     TempWord1, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_CUT, TempWord1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_COPY, TempWord1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_DEL, TempWord1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_FINDNEXT, TempWord1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_FINDPREV, TempWord1
      .if HexOpen
            mov     TempWord1, MF_ENABLED
            mov     TempWord2, MF_GRAYED
      .else
            mov     TempWord1, MF_GRAYED
            mov     TempWord2, MF_ENABLED
      .endif
      INVOKE     EnableMenuItem, hMenu, IDM_SAVEHEX, TempWord1
      INVOKE     EnableMenuItem, hMenu, IDM_SAVE, TempWord2
      INVOKE     EnableMenuItem, hMenu, IDM_SAVEAS, TempWord2
         xor     TempWord2, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_SAVE, TempWord1
      .if HighLite
            mov     TempWord1, MF_ENABLED
      .else
            mov     TempWord1, MF_GRAYED
      .endif
      INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_SYNTAX, TempWord1

      .if szWorkWin == 1 || szCodeGen == 1
            mov     TempWord1, MF_GRAYED
      .else
            mov     TempWord1, MF_ENABLED
      .endif
         INVOKE     EnableMenuItem, hMenu, 802, TempWord1

         ret
EnableDisableEditMenu ENDP

;=========================================================================
; Checks or Unchecks the menu item based on the flags                    *
;=========================================================================
CheckUncheck PROC hwnd:DWORD, MenuID
         mov     ebx, MF_UNCHECKED or MF_BYCOMMAND
         mov     edx, FALSE
          jz     cunc1
         mov     ebx, MF_CHECKED or MF_BYCOMMAND
         mov     edx, TRUE
cunc1:
        push     edx             ; Last arg of SendMessage
      INVOKE     GetMenu, hwnd
      INVOKE     CheckMenuItem, eax, MenuID, ebx
         pop     edx
      INVOKE     SendMessage, hWndTool, TB_CHECKBUTTON, MenuID, edx
         ret
CheckUncheck ENDP

;=========================================================================
; Parses the command line and extracts the exe root dir and if           *
; available builds a full path name , file name, ext name and filling    *
; in the needed ofn words                                                *
;=========================================================================
ParseCommandLine PROC  uses edi
      INVOKE     lstrlen, CommandLine          ;Saved address of commandline
         mov     ecx, eax
         mov     edi, CommandLine              ;Saved address of commandline
      .if byte ptr[edi] == 22h
            jmp     GetRoot
      .endif
         sub     ecx, 2
         add     edi, 2
         mov     eax, 3ah                      ; Look for colon in commandline
       repnz     scasb
;       jecxz     GetRoot                       ; Not from command or association
.if !ecx
      jmp     GetRoot
.endif
         add     ecx, 2
         sub     edi, 2
         mov     Len, ecx                      ; Save length of arg
        push     edi
      INVOKE     lstrcpy, addr PathName, edi   ; Copy PathName
         pop     edi
         mov     ecx, Len
         mov     eax, 2eh                      ; Look for period in commandline
       repnz     scasb
        push     eax
      INVOKE     lstrcpy, addr ExtType, edi    ; Copy ExtType
         pop     eax
         mov     ofn.nFileExtension, ax
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase                     ; Convert to lowercase
      INVOKE     lstrlen, addr PathName
      .if byte ptr PathName[eax-1] == '"'
           push     eax
         INVOKE     lstrcpyn, addr PathName, addr PathName, eax  ; Remove '"'
         INVOKE     lstrlen, addr ExtType
         INVOKE     lstrcpyn, addr ExtType, addr ExtType, eax    ; Remove '"'
            pop     eax
            dec     eax
      .endif
         lea     edi, PathName
         add     edi, eax
      .while (eax)
         .if byte ptr[edi] == 5ch              ; \
              .break 
         .endif
            dec     eax
            dec     edi
      .endw
         add     edi, 1
      INVOKE     lstrcpy, addr FileName, edi   ; Copy FileName

GetRoot:
      INVOKE     lstrlen, CommandLine
         mov     edi, CommandLine
         add     edi, eax
         sub     edi, Len
      .while (eax)
         .if byte ptr[edi] == 5ch              ; \
              .break 
         .endif
            dec     eax
            dec     edi
      .endw
         add     edi, 2
         sub     edi, CommandLine
        push     edi
      INVOKE     lstrcpy, addr WorkBuff, CommandLine
         pop     edi
         mov     eax, offset WorkBuff
      .if WorkBuff == 22h                      ; "
            inc     eax
            dec     edi
      .endif
      INVOKE     lstrcpyn, addr RootDir, eax, edi ;Copy RootDir
;INVOKE    MessageBox,NULL, CommandLine, addr pTitle, MB_OK
;INVOKE    MessageBox,NULL, addr RootDir, addr pTitle, MB_OK
;INVOKE    MessageBox,NULL, addr PathName, addr pTitle, MB_OK
;INVOKE    MessageBox,NULL, addr FileName, addr pTitle, MB_OK
;INVOKE    MessageBox,NULL, addr ExtType, addr pTitle, MB_OK
         ret
ParseCommandLine ENDP

;=========================================================================
; Sets the initial character format                                      *
;=========================================================================
SetCharFormatting PROC
      INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF

      INVOKE     RegQuery, addr rTC, TextC
         mov     charF.crTextColor, eax
         mov     TextC, eax
      INVOKE     RegQuery, addr rTBGC, TextBGC
         mov     charF.crBackColor, eax
         mov     TextBGC, eax
      INVOKE     RegQuery, addr rBC, BackGC
         mov     BackGC, eax
      INVOKE     RegQuery, addr szPoint, 180
         mov     charF.yHeight, eax
      INVOKE     RegQuery, addr szMask,\
                 CFM_OFFSET or CFM_BOLD or CFM_ITALIC or CFM_UNDERLINE or CFM_STRIKEOUT or CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     charF.dwMask, eax
      INVOKE     RegQuery, addr szEffects, 0
         mov     charF.dwEffects, eax
         mov     lpcbData, 50
      INVOKE     RegQuerySZ, addr szFont, addr FontName
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
         mov     eax, BackGC

;        test     PathName, 0ffh
;         jnz     NotNew
;         mov     charF.crBackColor, 0ffffffh
;         mov     eax, 0ffffffh

NotNew:
      .if ExtType != 'r' && ExtType + 1 != 't' && ExtType + 2 != 'f'
;            mov     charF.dwEffects, 0
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, eax
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
      .endif
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
      INVOKE     SetFocus, hREdit
         ret
SetCharFormatting ENDP

;=========================================================================
; Check if the file needs saving and prompt user for action              *
;=========================================================================
CheckSav PROC hwnd:DWORD
         and     OpnFlag, 0
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
      .if eax == 0
            mov    eax, 1
      .else
         MsgBox     ERROR_SAVE_BEFORE_QUIT, szSaving,\
                    MB_YESNOCANCEL or MB_ICONEXCLAMATION or MB_SYSTEMMODAL
         .if eax == IDYES
            .if HexOpen
               INVOKE     SendMessage, hwnd, WM_COMMAND, IDM_SAVEHEX, 0
            .else
               INVOKE     SendMessage, hwnd, WM_COMMAND, IDM_SAVE, 0
            .endif
               mov     eax, 1
         .elseif eax == IDNO
               mov     eax, 1
         .else
               mov     eax, IDCANCEL
         .endif
      .endif
         mov     OpnFlag, eax
      ret
CheckSav ENDP

;=========================================================================
; StartNewDocument                                                       *
;=========================================================================
StartNewDocument PROC hwnd:DWORD
      INVOKE     CheckSav, hwnd
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
        call     EnableDisableEditMenu
         mov     byte ptr szFileSize, 0
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, addr szFileSize
;        call    SetTitle
;        call    SetCharFormatting
         ret
StartNewDocument ENDP

;=========================================================================
; Open file PROCEDURE                                                    *
;=========================================================================
OpenFileA  PROC
LOCAL    SavPath[256]:Byte, SavCur[256]

         and     TopLine, 0
         and     ScrollPos, 0
      .if sw1 == 5
            mov     HexOpen, 1
            mov     sw1, 4
      .else
            and     HexOpen, 0
      .endif
      INVOKE     StartNewDocument, hWnd
      .if OpnFlag == IDCANCEL
            jmp     EndOpen
      .endif
         cmp     OA, 1
          je     OpenAssoc
      .if OA == 2
            mov     ofn.lpstrInitialDir, 0
            mov     PathName, 0
            jmp     PastSet
      .endif

      .if PathName
         INVOKE     lstrlen, addr FileName
           push     eax
         INVOKE     lstrlen, addr PathName
            pop     ecx
            sub     eax, ecx
         INVOKE     lstrcpyn, addr SavPath, addr PathName, eax
         INVOKE     SetCurrentDirectory, addr SavPath
      .else
         INVOKE     SetCurrentDirectory, addr RootDir
      .endif

      INVOKE     GetCurrentDirectory, lengthof CurDir, addr CurDir
         mov     ofn.lpstrDefExt, offset PatnT
         mov     ofn.lpstrInitialDir, offset CurDir

PastSet:
      INVOKE     lstrcpy, addr SavPath, addr PathName
      INVOKE     lstrcpy, addr PathName, addr FileName
      .if OA == 2 && sw1 == 4 && !HexOpen
         INVOKE     lstrcpy, addr PathName, addr szBuff
         INVOKE     lstrcat, addr PathName, addr PatnE
      .endif
         mov     ofn.nFilterIndex, 0
         mov     ofn.lpstrFile, offset PathName
         mov     ofn.nMaxFile, lengthof PathName
         mov     ofn.lpstrFilter, offset szFilter
         mov     ofn.lpstrFileTitle, offset FileName
         mov     ofn.nMaxFileTitle, lengthof FileName
         mov     ofn.lpstrTitle, offset szOpenTitle
         mov     ofn.Flags, OFN_PATHMUSTEXIST or OFN_FILEMUSTEXIST
      INVOKE     GetOpenFileName, offset ofn
      .if !eax                    ; Cancel'ed or error occurred
         INVOKE     lstrcpy, addr PathName, addr SavPath
            jmp     EndOpen
      .endif
         cmp     sw1, 4           ; From executable or hex
          je     EndOpen

;INVOKE    MessageBox,NULL, addr PathName, addr pTitle, MB_OK
;INVOKE    MessageBox,NULL, addr CurDir, addr pTitle, MB_OK 
;INVOKE    MessageBox,NULL, addr FileName, addr pTitle, MB_OK
 
OpenAssoc:                       ; From file association or cmd line
      INVOKE     GetFileAttributes, addr PathName
         cmp     eax, 0ffffffffh
          je     operr
         mov     dwAttr, eax

      INVOKE     SetFileAttributes, addr PathName, FILE_ATTRIBUTE_ARCHIVE ; In case the file is read only
      INVOKE     CreateFile, addr PathName,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL
         cmp     eax, -1            ; Error?
         jne     opcrok

operr:
      MsgBox     ERROR_CREATE_FILE
      .if w5 == 1                   ; From menu file list
         INVOKE     ProcessMRUFiles, hWnd, 1, MenuCnt, addr PathName, addr szRedit  ; Delete the list file name
         INVOKE     lstrcpy, addr PathName, addr WorkBuff
      .endif
         mov     eax, -1
         jmp     EndOpen

opcrok:
         mov     hFile, eax
         mov     EditS.dwCookie, eax
         mov     EditS.pfnCallback, offset EditStreamRead
         mov     EditS.dwError, 0
      INVOKE     SetFileAttributes, addr PathName, dwAttr

      .if w5 == 1 || w5 == 6 || w5 == 7              ; From MRU, need the filename for print
         INVOKE     lstrlen, addr PathName
         .while (eax)
               dec     eax
            .if PathName[eax] == '\'
               .break
            .endif
         .endw
            inc     eax
         INVOKE     lstrcpy, addr FileName, addr PathName[eax]
      .endif

      INVOKE     lstrlen, addr PathName
      .if PathName[eax-5] == 2eh
            dec     eax
      .endif
      INVOKE     lstrcpy, addr ExtType, addr PathName[eax-3]
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase          ; Convert to lowercase for compare
         cmp     RTF, 0
          je     opntxt
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f'
            mov      charF.crBackColor, 00ffffffh
            mov      w1, 00ffffffh  
            jmp      opnrtf
      .endif

opntxt:
      INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1  ;$$$$$$$$$$$$$$$$$$$$

         mov     charF.dwMask, 0feffffffh
         mov     charF.dwEffects, 0
         mov     eax, lf.lfWeight
         mov     charF.wWeight, ax
         mov     charF.yOffset, 0

       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, TextBGC
       MOVmd     charF.yHeight, PointSize
      INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF  ;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
      INVOKE     SendMessage, hREdit, EM_STREAMIN, SF_TEXT, addr EditS
         jmp     opnclos
                 
opnrtf:
      INVOKE     SendMessage, hREdit, EM_STREAMIN, SF_RTF, addr EditS
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_SYNTAX, FALSE
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, w1  ; BackGC
         mov     sw1, 7

opnclos:
         mov     bytesread, eax
      INVOKE     CloseHandle, hFile
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
        call     SetTitle
         and     HighLite, 0
         and     UpdateSel, 0
         and     UpdateAll, 0
         mov     DataFlag, 1
      INVOKE     SendMessage, hWndTool, TB_ENABLEBUTTON, IDM_SYNTAX, TRUE
      INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_SYNTAX, MF_GRAYED

      .if sw1 !=7   ; Not RTF
           call     ScreenLines
          MOVmd     charF.crTextColor, TextC
          MOVmd     charF.crBackColor, TextBGC
          MOVmd     charF.yHeight, PointSize
         INVOKE     lstrcpy, offset charF.szFaceName, offset FontName
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF  ;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0
         INVOKE     SendMessage, hREdit, EM_EMPTYUNDOBUFFER, 0, 0
      .endif

      .if ExtType == 'a' && ExtType + 1 == 's' && ExtType + 2 == 'm' ||\
          ExtType == 'i' && ExtType + 1 == 'n' && ExtType + 2 == 'c' ||\
          ExtType + 1 == 'r' && ExtType + 2 == 'c'
            mov     HighLite, 1
            mov     UpdateAll, 1
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
         INVOKE     SendMessage, hWndTool, TB_INDETERMINATE, IDM_SYNTAX, MF_ENABLED
     call     SetReg
      mov     charF.crBackColor, 0080ffffh
      mov     charF.dwEffects, 0
      .else
            mov     UpdateSel, 1
      .endif
      INVOKE     BaseAscii, bytesread, addr Fsize, 0, 10, 1, 0, 1
      INVOKE     lstrcpy, addr szFileSize, addr szOpened
      INVOKE     lstrcat, addr szFileSize, addr Fsize
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, addr szFileSize
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
      INVOKE     RichEditProc, hREdit, WM_PAINT, 0, 0  ; Need this for highlite and no wordwrap
      INVOKE     SetFocus, hREdit
      .if w5 != 6                 ; 6 = from assmb
         INVOKE     ProcessMRUFiles, hWnd, 0, MenuCnt, addr PathName, addr szRedit
      .endif

EndOpen:
         and     OA, 0
         and     sw1, 0
         and     w5, 0
           ret
OpenFileA  ENDP

;=========================================================================
; Edit Stream Read Callback PROCEDURE                                    *
;=========================================================================
EditStreamRead PROC uses ebx edi esi dwCookie:DWORD, pbBuff, cb, pcb
      INVOKE     ReadFile, dwCookie, pbBuff, cb, pcb, 0
         mov     eax, 0          ; Return 0
         ret
EditStreamRead ENDP

;=========================================================================
; Save file PROCEDURE                                                    *
;=========================================================================
SaveFile PROC  uses ebx
         cmp     sw1, 1
          je     SaveAs
         mov     al, PathName
         cmp     al, 0
         jne     dosave2
         mov     ofn.Flags, OFN_PATHMUSTEXIST or OFN_FILEMUSTEXIST
         jmp     dosave1

SaveAs:
         mov     ofn.Flags, OFN_OVERWRITEPROMPT or OFN_CREATEPROMPT

dosave1:
      .if PathName == 0
         INVOKE     lstrcpy, addr PathName, addr RootDir
         INVOKE     lstrcat, addr PathName, addr Patn
      .endif
;         mov     ofn.lStructSize, sizeof ofn
;         mov     eax, hWnd
;         mov     ofn.hwndOwner, eax
;         mov     eax, hInst
;         mov     ofn.hInstance, eax
         mov     ofn.lpstrFilter, offset szFilter
         mov     ofn.lpstrFile, offset PathName
         mov     ofn.nMaxFile, lengthof PathName
         mov     ofn.lpstrInitialDir, 0
         mov     ofn.lpstrTitle, offset szSaveTitle
;         mov     ofn.lpstrDefExt, offset PatnT
      INVOKE     GetSaveFileName, addr ofn
         cmp     eax, FALSE               ; Cancel'ed or error occurred
          je     EndSave
      .if sw2 == 5 || sw2 == 6            ; From assembly copy output or Hex update
            mov     ebx, hBuff
         INVOKE     lstrcpy, ebx, addr PathName
           call     writep
            jmp     EndSave
      .endif

dosave2:
         mov     dwAttr, FILE_ATTRIBUTE_ARCHIVE
      INVOKE     GetFileAttributes, addr PathName
         cmp     eax, 0ffffffffh
          je     crFile  ;saverr
         mov     dwAttr, eax
      INVOKE     SetFileAttributes, addr PathName, FILE_ATTRIBUTE_ARCHIVE ; In case the file is read only

crFile:
      INVOKE     CreateFile, addr PathName,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
         cmp     eax, -1                  ; Error?
         jne     savcrok

saverr:
      MsgBox     ERROR_CREATE_FILE
         jmp     EndSave

savcrok:
         mov     hFile, eax
         mov     EditS.dwCookie, eax
         mov     EditS.dwError, 0
         mov     EditS.pfnCallback, offset EditStreamWrite
         cmp     RTF, 0
          je     savtxt
      INVOKE     lstrlen, addr PathName
      INVOKE     lstrcpy, addr ExtType, addr PathName[eax-3]
         mov     ecx, 3
         lea     esi, ExtType
        call     LowerCase                ;Convert to lowercase for compare
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f'
            jmp      savrtf
      .endif

savtxt:
      INVOKE     SendMessage, hREdit, EM_STREAMOUT, SF_TEXT, addr EditS
         jmp     savclose

savrtf:
      INVOKE     SendMessage, hREdit, EM_STREAMOUT, SF_RTF, addr EditS

savclose:
         mov     bytesread, eax
      INVOKE     CloseHandle, hFile
      INVOKE     SetFileAttributes, addr PathName, dwAttr
        call     EnableDisableEditMenu
      INVOKE     SendMessage,  hREdit, EM_SETMODIFY, FALSE, 0
      .if sw2 == 1                       ; From backup dir
         INVOKE     lstrcpy, addr CurDir, addr szBuff
         INVOKE     lstrcpy, addr PathName, addr WorkBuff
         INVOKE     SetCurrentDirectory, addr CurDir
      .endif
        call     SetTitle
      INVOKE     BaseAscii, bytesread, addr Fsize, 0, 10, 1, 0, 1
      INVOKE     lstrcpy, addr szFileSize, addr szSaved
      INVOKE     lstrcat, addr szFileSize, addr Fsize
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, addr szFileSize

EndSave:
         and     sw1, 0
         and     sw2, 0
         ret
SaveFile ENDP

;=========================================================================
; Edit Stream Save Callback PROCEDURE                                    *
;=========================================================================
EditStreamWrite PROC uses ebx edi esi dwCookie:DWORD, pbBuff, cb, pcb
      INVOKE     WriteFile, dwCookie, pbBuff, cb, pcb, 0
         mov     eax, 0          ; File completely read
         ret
EditStreamWrite ENDP

;=========================================================================
; Word Wrap PROCEDURE                                                    *
;=========================================================================
WordWrap PROC
      INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_BYCOMMAND
         and     WWrap, 0
      .if eax == MF_CHECKED
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_UNCHECKED
         INVOKE     SendMessage, hREdit, EM_SETTARGETDEVICE, NULL, 444444

      .else
             or     WWrap, 1
         INVOKE     CheckMenuItem, hMenu, IDM_WWRAP, MF_CHECKED
         INVOKE     SendMessage, hREdit, EM_SETTARGETDEVICE, NULL, 0
      .endif

WordWrapRet:
         ret
WordWrap ENDP

;=========================================================================
; Read file for selected text or ini file PROCEDURE                      *
;=========================================================================
readp   PROC  uses ebx
      .if hpMem > 0
         INVOKE     GlobalUnlock, fpMem
         INVOKE     GlobalFree, hpMem
            mov     hpMem, 0
      .endif
      INVOKE     SendMessage, hREdit, EM_SETREADONLY, FALSE, 0
         mov     ebx, hBuff
      INVOKE     CreateFile, ebx,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 0, OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE, 0
         jmp     Past

ReadOnlyF:
      INVOKE     SendMessage, hREdit, EM_SETREADONLY, TRUE, 0
         mov     ebx, hBuff
      INVOKE     CreateFile, ebx,\
                 GENERIC_READ, FILE_SHARE_READ,\
                 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0

Past:
      .if eax == -1
           call     GetLastError
         .if eax == 32
            INVOKE     MessageBox, hWnd, addr szAccess, addr pTitle, MB_YESNO
            .if eax == IDYES
                  jmp     ReadOnlyF
            .endif
               mov     eax, -1
               jmp     NoFile
         .else
            MsgBox     ERROR_CREATE_FILE
               mov     eax, -1
               jmp     NoFile
         .endif
      .endif

         mov     hFile, eax
      INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, sMemSize
         mov     hpMem, eax
      INVOKE     GlobalLock, hpMem
         mov     fpMem, eax
      INVOKE     ReadFile, hFile, fpMem, sMemSize, addr bytesread, NULL
        push     eax
      INVOKE     CloseHandle, hFile
         pop     eax

NoFile:
         ret
readp   ENDP

;=========================================================================
; Write file for ini file PROCEDURE                                      *
;=========================================================================
writep     PROC  uses ebx
         mov     ebx, hBuff
      INVOKE     CreateFile, ebx,\
                 GENERIC_READ or GENERIC_WRITE ,\
                 FILE_SHARE_READ or FILE_SHARE_WRITE,\
                 NULL, CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE,\
                 NULL
         mov     hFile, eax
      .if sw2 == 5 || sw2 == 6
            mov     eax, bytesread
;      .elseif
;            mov     eax, bytesread
      .endif
      INVOKE     WriteFile, hFile, fpMem, eax, addr bytesread, NULL
        push     eax
      INVOKE     CloseHandle, hFile
         pop     eax
         ret
writep     ENDP

;=========================================================================
; Build Small Memory File PROCEDURE                                      *
;=========================================================================
BuildfsMem  PROC     STDCALL
      .if hsMem > 0
         INVOKE     GlobalUnlock, fsMem
         INVOKE     GlobalFree, hsMem
            mov     hsMem, 0
      .endif
         INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, sMemSize
            mov     hsMem, eax
         INVOKE     GlobalLock, hsMem            
            mov     fsMem, eax
            ret
BuildfsMem  ENDP

;=========================================================================
; Format the input file to hex                                           *
;=========================================================================
BuildHex PROC  uses ebx edx esi edi  hREditO:DWORD, InFile, FileSize, Base
LOCAL    hMemO:DWORD, pMemO, BytesO, SavIn, SavOut, Cnt, Num, BuffOff

         mov     eax, FileSize
        imul     eax, 5
         mov     BytesO, eax

      INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, BytesO, 0
         mov     hMemO, eax
      INVOKE     HeapAlloc, hMemO, HEAP_GENERATE_EXCEPTIONS, BytesO
         mov     pMemO, eax

         mov     SavIn, 0
         mov     SavOut, 0
         mov     Cnt, 0
         mov     Len, 17

LoopIt:
;---------- [Offset characters] ---------- 
         mov     Num, 0
         mov     BuffOff, 0
         mov     edi, SavOut
         mov     eax, pMemO
         add     eax, edi
         mov     Hold, edi
      INVOKE     BaseAscii, Cnt, eax, 8, Base, 0, 1, 1
         mov     ecx, Len
         dec     ecx
         add     SavOut, 10
         mov     edi, SavOut
         mov     edx, pMemO
         mov     Word ptr[edx+edi-2], '  '

;---------- [Hex characters] ---------- 
      .while (ecx)
            mov     esi, SavIn
            mov     ebx, InFile
            mov     al, byte ptr [ebx+esi]
            mov     esi, BuffOff
         .if al == 0ah || al == 0dh || al == 09h || al < 20h || al > 7fh
               mov     byte ptr szBuff[esi], 2eh
         .else
               mov     byte ptr szBuff[esi], al
         .endif
            shr     eax, 4
            and     eax, 0fh
         .if eax > 9
            add     eax, 37h
         .else
            add     eax, 30h
         .endif
            mov     byte ptr[edx+edi], al
            mov     esi, SavIn
            mov     ebx, InFile
            mov     al, byte ptr [ebx+esi]
            and     eax, 0fh
         .if eax > 9
               add     eax, 37h
         .else
               add     eax, 30h
         .endif
            inc     edi
            mov     byte ptr[edx+edi], al
            inc     BuffOff
            inc     SavIn
            add     Num, 2
            inc     edi
         .if Num == 4
               mov     byte ptr[edx+edi], ' '
               inc     edi
               mov     Num, 0
         .endif
            dec     ecx
      .endw

         mov     esi, BuffOff
         mov     byte ptr szBuff[esi], 0
         dec     edi
      .if Num == 2
            inc     edi
      .endif
         mov     SavOut, edi
         mov     word ptr[edx+edi], '  '
         inc     edi
         inc     edi
         mov     eax, 17
      .if Len < eax
            mov     eax, edi
            sub     eax, Hold
            mov     ecx, 50
            sub     ecx, eax
         .while (ecx)
               mov     byte ptr[edx+edi], ' '
               inc     edi
               dec     ecx
         .endw
      .endif

;---------- [Ascii characters] ---------- 
         mov     edx, pMemO
         mov     ecx, 16
         xor     ebx, ebx
      .while (ecx)
            mov     al, byte ptr szBuff[ebx]
            mov     byte ptr[edx+edi], al
            inc     edi
            inc     ebx
            dec     ecx
      .endw

;---------- [Finish the line] -----------
         add     Cnt, 16
;INVOKE     MessageBox, hWnd, pMemO, addr szDisplayName, MB_OK
         mov     eax, FileSize
      .if SavIn < eax
            sub     eax, SavIn
         .if eax < 17
               inc     eax
               mov     Len, eax
         .endif
            mov     edx, pMemO
            mov     edi, SavOut
            add     edi, 18
            mov     word ptr[edx+edi], 0A0Dh
            add     SavOut, 20
            jmp     LoopIt
      .endif

      INVOKE     SendMessage, hREditO, WM_SETTEXT, NULL, pMemO
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
      INVOKE     HeapDestroy, hMemO
      INVOKE     BaseAscii, bytesread, addr Fsize, 0, 10, 1, 0, 1
      INVOKE     lstrcpy, addr szFileSize, addr szOpened
      INVOKE     lstrcat, addr szFileSize, addr Fsize
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, addr szFileSize

         ret
BuildHex ENDP

;==========================================
; Convert hex to previous format PROCEDURE
;==========================================
ConvHex proc uses ebx edx esi edi

LOCAL     hMemI:DWORD, pMemI, hMemO, pMemO, BytesO, SavIn, LineLen, SavOut
LOCAL     txtBuffer[64], szWorkS[10]

         mov     SavIn, 0
         mov     SavOut, 0
         mov     LineLen, 0

      INVOKE     SendMessage, hREdit, WM_GETTEXTLENGTH, 0, 0
         inc     eax
         mov     BytesO, eax

      INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, BytesO, 0
         mov     hMemI, eax
      INVOKE     HeapAlloc, hMemI, HEAP_GENERATE_EXCEPTIONS, BytesO
         mov     pMemI, eax
      INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, BytesO, 0
         mov     hpMem, eax
      INVOKE     HeapAlloc, hpMem, HEAP_GENERATE_EXCEPTIONS, BytesO
         mov     fpMem, eax
      INVOKE     SendMessage, hREdit, WM_GETTEXT, BytesO, pMemI
         mov     BytesO, eax
         mov     SavIn, 10

;---------- [Convert the hex portion to ascii] ----------
LoopIt:
         mov     ecx, BytesO
      .while (SavIn <= ecx)
         .while (LineLen < 80) ;40)
               mov     esi, SavIn
               mov     ebx, pMemI
               mov     edi, SavOut
               mov     edx, fpMem
               xor     eax, eax
.if byte ptr [ebx+esi] == 20h && byte ptr [ebx+esi+1] == 20h
   .break
.endif
               mov     al, byte ptr [ebx+esi]
            .if al == 0ah || al == 0dh || al == 20h
                  inc     SavIn
                  inc     LineLen
                  jmp     LoopIt
            .endif
               mov     ax, word ptr [ebx+esi]
               mov     word ptr szWorkS, ax
               mov     eax, 2
               xor     ecx, ecx
            .while (eax)
               .if byte ptr szWorkS[ecx] > 60h
                     sub     byte ptr szWorkS[ecx], 57h
               .elseif byte ptr szWorkS[ecx] > 40h
                     sub     byte ptr szWorkS[ecx], 37h
               .else
                     xor     byte ptr szWorkS[ecx], 30h
               .endif
                  dec     eax
                  inc     ecx
            .endw
               mov     al, byte ptr szWorkS
              imul     eax, 16
               mov     ecx, eax
               mov     al, byte ptr szWorkS+1
               and     eax, 000000ffh
               add     ecx, eax
               mov     byte ptr [edx+edi], cl
               add     SavIn, 2
               add     LineLen, 2
               inc     SavOut
               jmp     LoopIt
         .endw
            and     LineLen, 0
            add     SavIn, 29
      .endw

         mov     eax, SavSize
      .if eax != SavOut
         INVOKE     MessageBox, NULL, addr szError1, addr pTitle, MB_YESNO or MB_ICONQUESTION
         .if eax == IDNO
               jmp     NoUpdate
         .endif
      .endif
         mov     sw1, 1
         mov     sw2, 6
       MOVmd     bytesread, SavOut
        call     SaveFile

NoUpdate:
      INVOKE     HeapDestroy, hMemI
      INVOKE     HeapDestroy, hpMem
      INVOKE     BaseAscii, SavOut, addr Fsize, 0, 10, 1, 0, 1
      INVOKE     lstrcpy, addr szFileSize, addr szSaved
      INVOKE     lstrcat, addr szFileSize, addr Fsize
      INVOKE     SendMessage, hWndStat, SB_SETTEXT, SBPART_MESSAGE1, addr szFileSize
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0
         ret
ConvHex endp

;=========================================================================
; Page Setup Dialog PROCEDURE                                            *
;=========================================================================
DoPageSU PROC
         mov     psd.lStructSize, sizeof psd
        push     hWnd
         pop     psd.hwndOwner
        push     hInst
         pop     psd.hInstance
         mov     psd.Flags, PSD_MARGINS or PSD_INTHOUSANDTHSOFINCHES or PSD_DISABLEPAPER or PSD_DISABLEPRINTER
      INVOKE     PageSetupDlg, addr psd
         cmp     eax,0
          jz     NSU
       finit
         mov     al, psd.rtMargin[0]
         mov     ah, psd.rtMargin[1]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mL
         mov     al, psd.rtMargin[4]
         mov     ah, psd.rtMargin[5]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mT
         mov     al, psd.rtMargin[8]
         mov     ah, psd.rtMargin[9]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mR
         mov     al, psd.rtMargin[12]
         mov     ah, psd.rtMargin[13]
         and     eax, 0000ffffh
         mov     w1, eax
         fld     RTwips1000
        fild     w1
        fmul     ST(0), ST(1)
       fistp     mB
         sub     mL, 360
         sub     mT, 360
         sub     mR, 360
         sub     mB, 302

NSU:
         ret
DoPageSU ENDP

;=========================================================================
; Build print heading PROCEDURE                                          *
;=========================================================================
HeadProc PROC  uses ebx
LOCAL    Clear[256]:BYTE
      INVOKE     BaseAscii, cnt, addr num, 2, 10, 0, 1, 0
      INVOKE     FillBuffer, addr Clear, sizeof Clear, ' ', 1
      INVOKE     lstrcpy, addr szBuff, addr Clear   ; Clear the buffer

         mov     ebx, hHead
      INVOKE     lstrcpy, addr szBuff, ebx
      INVOKE     lstrlen, addr szBuff
         mov     byte ptr szBuff[eax], ' '
         lea     ebx, szBuff
         mov     ecx, 97 ;110  ;Lmax
         sub     ecx, 33
         add     ebx, ecx
      .if PH <= 1
            add     ebx, 26
            jmp     PageNum
      .endif
      INVOKE     lstrcpyn, ebx, offset dmsg, 11
         add     ebx, 10
      INVOKE     lstrcpyn, ebx, addr Clear, 10
         add     ebx, 2
      INVOKE     lstrcpyn, ebx, offset tmsg, 12
         add     ebx, 11
      INVOKE     lstrcpyn, ebx, addr Clear, 10
         add     ebx, 3

PageNum: 
      INVOKE     lstrcpyn, ebx, offset Page1, 8
      INVOKE     lstrlen, addr szBuff
         mov     Len, eax
         ret
HeadProc ENDP

;=========================================================================
; Print document PROCEDURE                                               *
;=========================================================================
PrintProc PROC
LOCAL    Chg: DWORD, TextSize

      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
         mov     sw2, 6
      INVOKE     DialogBoxParam, hInst, IDD_PRTHEAD, hWnd, addr CommonDlg, 0
         cmp     sw3, 0         ; Cancel dialog
          je     PrtRet
        push     cf.rgbColors
         mov     cf.rgbColors, 0
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00ffffffh
         pop     cf.rgbColors
        push     HighLite
         cmp     PrtColor, 1
          je     StartPrt
         and     HighLite, 0
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
      INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
          or     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         mov     charF.crTextColor, 0
        push     charF.crBackColor
         mov     charF.crBackColor, 00ffffffh
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         pop     charF.crBackColor

StartPrt:
         mov     cnt, 0
         mov     pd.lStructSize, sizeof pd
         mov     eax, hWnd
         mov     pd.hwndOwner, eax
         mov     eax, hInst
         mov     pd.hInstance, eax
         ;mov     pd.Flags, PD_RETURNDC or PD_NOSELECTION or PD_PRINTSETUP
         mov     pd.Flags, PD_RETURNDC
      INVOKE     PrintDlg, addr pd
         cmp     eax, FALSE
          je     PrtRet
         mov     eax, pd.Flags
         mov     ebx, eax
         and     ebx, 000000ffh
         mov     Sel, ebx
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
         mov     eax, cr.cpMax
      .if eax > cr.cpMin && Sel != 1
         MsgBox     ERROR_NO_SELECTION, szSelect, MB_YESNO or MB_ICONQUESTION
            cmp     eax, IDNO
             je     PrtRet
      .endif
         mov     doci.cbSize, sizeof doci
         mov     doci.lpszDocName, offset pTitle
         mov     doci.lpszOutput, 0
         mov     doci.fwType, 0
         mov     eax, pd.hDC
         mov     fr.hdc, eax
         mov     fr.hdcTarget, eax  ;0
      INVOKE     GetDeviceCaps, fr.hdc, LOGPIXELSX ; Number of pixels per logical inch along the screen width.
         mov     xPerInch, eax
      INVOKE     GetDeviceCaps, fr.hdc, LOGPIXELSY ; Number of pixels per logical inch along the screen height.
         mov     yPerInch, eax
         mov     eax, mL             ; Min is 360
         mov     rect.left, eax
         mov     eax, mT             ; Min is 360
         mov     rect.top, eax
      .if PrtHead
            add     rect.top, 420 ;360
      .endif
      INVOKE     GetDeviceCaps, fr.hdc, HORZRES    ; Width, in pixels, of the screen.
         mov     ecx, 1440
         mul     ecx
         div     xPerInch
         mov     rect.right, eax
         mov     eax, mR             ; Min is 360
         sub     rect.right, eax
      INVOKE     GetDeviceCaps, fr.hdc, VERTRES    ; Height, in raster lines, of the screen.
         mov     ecx, 1440
         mul     ecx
         div     yPerInch
         mov     rect.bottom, eax
         mov     eax, mB             ; Min is 302
         sub     rect.bottom, eax
         mov     ecx, 16
         mov     edi, offset fr.rcPage
         mov     esi, offset rect
         cld
         rep     movsb
      INVOKE     StartDoc, pd.hDC, addr doci
      INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
         mov     eax, cr.cpMin
         mov     ebx, cr.cpMax
      .if ebx > eax && Sel == 1
            mov     fr.chrg.cpMin, eax
            mov     fr.chrg.cpMax, ebx
            mov     TextSize, ebx
      .else
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
            mov     cr.cpMin, 0
            mov     cr.cpMax, -1
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
          MOVmd     fr.chrg.cpMin, cr.cpMin
            mov     fr.chrg.cpMax, -1
          MOVmd     TextSize, cr.cpMax 
            mov     cr.cpMin, 0
            mov     cr.cpMax, 0
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
      .endif

prtloop:
      INVOKE     StartPage, pd.hDC
         cmp     eax, 0
         jle     prtabort
      .if PrtHead
            add     cnt, 1
           call     HeadProc 
         INVOKE     SelectObject, pd.hDC, pFont
         INVOKE     TextOut, pd.hDC, pX, pY, addr szBuff, Len       ; Print heading line
      .endif
         mov     ecx, 16
         mov     esi, offset rect
         mov     edi, offset fr.rc                                  ; Actual print page dimensions
         cld
         rep     movsb
      INVOKE     SendMessage, hREdit, EM_FORMATRANGE, TRUE, addr fr ; Print page
         mov     fr.chrg.cpMin, eax
      INVOKE     EndPage, pd.hDC
         cmp     eax, 0
         jle     prtabort
         mov     eax, fr.chrg.cpMin
         cmp     eax, 0
         jle     prtdone
         cmp     eax, TextSize
          jl     prtloop
prtdone:
      INVOKE     SendMessage, hREdit, EM_FORMATRANGE, 0, 0
      INVOKE     EndDoc, pd.hDC
      INVOKE     DeleteDC, pd.hDC
         jmp     PrtRet

prtabort:
      INVOKE     AbortDoc, fr.hdc

PrtRet:
      INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackGC
         pop     HighLite
       MOVmd     charF.crTextColor, TextC
       MOVmd     charF.crBackColor, BackGC
      INVOKE     lstrcpy, addr charF.szFaceName, addr FontName
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
       MOVmd     EBook, SBook
      INVOKE     SendMessage, hREdit, EM_SETSEL, SBook, SBook
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0
         ret
PrintProc ENDP

;=========================================================================
; Set Common Registry                                                    *
;=========================================================================
SetReg PROC
LOCAL    hRegC:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegC, addr lpdwDisp
      INVOKE     lstrlen, addr szRedit
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegC, addr szKey, 0, REG_SZ, addr szRedit, lpcbData
      INVOKE     lstrlen, addr PathName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegC, addr szPath, 0, REG_SZ, addr PathName, lpcbData
      INVOKE     lstrlen, addr FileName
         mov     lpcbData, eax
      INVOKE     RegSetValueEx, hRegC, addr szName, 0, REG_SZ, addr FileName, lpcbData
      INVOKE     RegSetValueEx, hRegC, addr szParent, 0, REG_DWORD, addr hWnd, 4
      INVOKE     RegSetValueEx, hRegC, addr szEdit, 0, REG_DWORD, addr hREdit, 4
        push     w1
         mov     eax, offset charF
         mov     w1, eax 
      INVOKE     RegSetValueEx, hRegC, addr szChar, 0, REG_DWORD, addr w1, 4
         mov     eax, offset charC
         mov     w1, eax 
      INVOKE     RegSetValueEx, hRegC, addr szCharC, 0, REG_DWORD, addr w1, 4
         mov     eax, offset cr
         mov     w1, eax 
      INVOKE     RegSetValueEx, hRegC, addr szcrF, 0, REG_DWORD, addr w1, 4
         pop     w1
      INVOKE     RegSetValueEx, hRegC, addr szRun, 0, REG_DWORD, addr RunCode, 4
      INVOKE     RegCloseKey, hRegC
         ret
SetReg ENDP

;=========================================================================
; Registry Save saves tabs, spaces, shift and colors                     *
;=========================================================================
RegSave PROC  uses ebx
LOCAL    hRegS:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegS, addr lpdwDisp

      INVOKE     RegSet, addr szBuildC, Build
      INVOKE     RegSet, addr szSaveWhen, SaveWhen
      INVOKE     RegSet, addr szSetFlags, SetFlags
      INVOKE     RegSet, addr szWordWrap, WWrap

         lea     ebx, offset szCustClrs
         lea     ecx, CustClrs
      INVOKE     RegSetValueEx, hRegS, ebx, 0, REG_BINARY, ecx, 64
         mov     w1, 0
      INVOKE     RegSetValueEx, hRegS, addr szHandle, 0, REG_DWORD, addr w1, 4

      .if (SetFlags & 1)                   ; Save window size and position
           call     GetDesktopWindow
         INVOKE     GetWindowRect, eax, addr rect
           push     rect.right
         INVOKE     GetWindowRect, hWnd, addr rect
            pop     eax
            cmp     eax, rect.right
            jle     NoSavePos              ; If window is maximized 
         INVOKE     RegSet, addr szLeft, rect.left
         INVOKE     RegSet, addr szRight, rect.right
         INVOKE     RegSet, addr szTop, rect.top
         INVOKE     RegSet, addr szBottom, rect.bottom
      .endif

NoSavePos:
      .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            jmp      SkipFormat
      .endif
      .if (SetFlags & 2)                   ; Save char format
         INVOKE     SendMessage, hREdit, EM_GETCHARFORMAT, TRUE, addr charF
         INVOKE     lstrlen, addr charF.szFaceName
            mov     lpcbData, eax
         INVOKE     RegSetValueEx, hRegS, addr szFont, 0, REG_SZ, addr charF.szFaceName, lpcbData
         INVOKE     RegSet, addr szPoint, charF.yHeight
         INVOKE     RegSet, addr szMask, charF.dwMask
         INVOKE     RegSet, addr szEffects, charF.dwEffects
         INVOKE     RegSet, addr szFontH, FontHeight
         INVOKE     RegSet, addr szFontW, FontWeight
      .endif

      .if (SetFlags & 4)                   ; Save syntax
            mov     ecx, 3 ;11
            lea     eax, offset rTC
            mov     w5, eax
            lea     eax, TextC
            mov     w6, eax
         .while (ecx)
              push     ecx
            INVOKE     RegSetValueEx, hRegS, w5, 0, REG_DWORD, w6, 4
               pop     ecx
               add     w5, 14
               add     w6, 4
               dec     ecx
         .endw

            and     w4, 0
         .while (w4 < 16)
               mov     eax, w4
              imul     eax, 4
               lea     ebx, offset szColor01
               lea     ecx, Color01[eax]
            INVOKE     RegSetValueEx, hRegS, ebx, 0, REG_DWORD, ecx, 4
               inc     w4
               mov     eax, w4
               inc     eax
            INVOKE     BaseAscii, eax, addr Misc, 2, 10, 0, 1, 0
               mov     al, byte ptr Misc
               mov     byte ptr szColor01+5, al
               mov     al, byte ptr Misc+1
               mov     byte ptr szColor01+6, al
         .endw
            mov     byte ptr szColor01+5, '0'
            mov     byte ptr szColor01+6, '1'
      .endif

SkipFormat:
      .if (SetFlags & 8)                   ; Save setup
       .if ExtType == 'r' && ExtType + 1 == 't' && ExtType + 2 == 'f' && RTF == 1
            mov     ecx, 16
       .else
            mov     ecx, 19
       .endif
            lea     eax, offset rTS1
            mov     w5, eax
            lea     eax, TS1
            mov     w6, eax
         .while (ecx)
              push     ecx
            INVOKE     RegSetValueEx, hRegS, w5, 0, REG_DWORD, w6, 4
               pop     ecx
               add     w5, 14
               add     w6, 4
               dec     ecx
         .endw
      .endif

      INVOKE     RegCloseKey, hRegS
         ret
RegSave ENDP

;=========================================================================
; Registry Query for text strings                                        *
;=========================================================================
RegQuerySZ  PROC  uses ebx  ValueName:DWORD, Default
LOCAL    hRegQ:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegQ, addr lpdwDisp
         mov     eax, ValueName
         mov     ebx, Default
      INVOKE     RegQueryValueEx, hRegQ, eax, 0, addr lpType, ebx, addr lpcbData
        push     eax
      INVOKE     RegCloseKey, hRegQ
         pop     eax
         ret
RegQuerySZ  ENDP

;=========================================================================
; Return the integer value in eax from the registry                      *
;=========================================================================
RegQuery PROC  uses ebx  ValueName:DWORD, Default
LOCAL     hRegQ:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegQ, addr lpdwDisp
         mov     lpcbData, 4
         mov     eax, ValueName
         lea     ebx, Default
      INVOKE     RegQueryValueEx, hRegQ, eax, 0, addr lpType, ebx, addr lpcbData
      INVOKE     RegCloseKey, hRegQ
         mov     eax, Default
         ret
RegQuery ENDP

;=========================================================================
; Sets the specified value in the registry                               *
;=========================================================================
RegSet PROC  uses ebx  ValueName:DWORD, Value
LOCAL     hRegS:DWORD

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szRedit, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hRegS, addr lpdwDisp
         mov     lpcbData, 4
         mov     eax, ValueName
         lea     ebx, Value
      INVOKE     RegSetValueEx, hRegS, eax, 0, REG_DWORD, ebx, lpcbData
      INVOKE     RegCloseKey, hRegS
         ret
RegSet ENDP
         end     start
                 
;DSPValue hWnd, eax, 1, 'm'
;INVOKE     MessageBox, NULL, addr szBuff, addr pTitle, MB_OK

