;*******************************************************************
;*  RESOURCE EQUATES                                               *
;*******************************************************************
;
; Non-menu resources
;
FIND             EQU 1400
REPLACE          EQU 1401
REPLACEALL       EQU 1402
cb1              EQU 1403
cb2              EQU 1404
cb3              EQU 1405
rb1              EQU 1406
rb2              EQU 1407
rb3              EQU 1408
rb21             EQU 1409
rb22             EQU 1410
hHelp            EQU 1415
EditF            EQU 1416
EditR            EQU 1417
TC               EQU 1422
BC               EQU 1423
H1               EQU 1424
H2               EQU 1425
H3               EQU 1426
H4               EQU 1427
H5               EQU 1428
H6               EQU 1429
H7               EQU 1430

tb0              EQU 1500
tb1              EQU 1501
tb2              EQU 1502
tb3              EQU 1503
tb4              EQU 1504
tb5              EQU 1505
tb6              EQU 1506
tb7              EQU 1507
tb8              EQU 1508
tb9              EQU 1509
tb10             EQU 1510
F1               EQU 1511
F2               EQU 1512
F3               EQU 1513
F4               EQU 1514
sb1              EQU 1600
sb2              EQU 1601
sb3              EQU 1602
sb4              EQU 1603
sb5              EQU 1604
sb6              EQU 1605
sb7              EQU 1606
sb8              EQU 1607
sb9              EQU 1608
sb10             EQU 1609
sb15             EQU 1614
sb20             EQU 1619
T1               EQU 1701
T2               EQU 1702
T3               EQU 1703
T4               EQU 1704
T5               EQU 1705
T6               EQU 1706
T7               EQU 1707
T8               EQU 1708
T9               EQU 1709
T10              EQU 1710
E1               EQU 1801
E2               EQU 1802
E3               EQU 1803
E4               EQU 1804
E5               EQU 1805
E6               EQU 1806
E7               EQU 1807
E8               EQU 1808
E9               EQU 1809
E10              EQU 1810
E11              EQU 1811
E12              EQU 1812
E13              EQU 1813
B0               EQU 1900
B1               EQU 1901
B2               EQU 1902
B3               EQU 1903
B4               EQU 1904
B5               EQU 1905
B6               EQU 1906
B7               EQU 1907
B8               EQU 1908
B9               EQU 1909
B10              EQU 1910
B11              EQU 1911
B12              EQU 1912
B13              EQU 1913
B14              EQU 1914
B15              EQU 1915
B16              EQU 1916
B17              EQU 1917
B18              EQU 1918
B19              EQU 1919
B20              EQU 1920
SH               EQU 1980

IDI_ICON1        equ 2001 ;application icon resource id
IDR_MENU1        equ 2002 ;id of menu
IDR_MENU2        equ 2003 ;id of sub menu
IDD_FIND         equ 2004 ;dialog id of find dialog
IDD_FINDREPLACE  equ 2005 ;dialog id of find/replace dialog
IDD_INDENT       equ 2006 ;dialog id of indent dialog
IDR_ACCEL        equ 2007 ;accelerator table id
IDB_TOOLBAR      equ 2008 ;bitmap id of toolbar bitmap
ID_TOOLBAR       equ 2009 ;id of toolbar
IDD_PRTHEAD      equ 2010 ;dialog id of print heading dialog
IDC_EDIT1        equ 2011 ;id of change print heading and goto linenumber edit ctrl
IDD_MNEM         equ 2012 ; 
IDM_MNEM         equ 2013 ;dialog id of mnemonics dialog
IDD_FONT         equ 2014 ;dialog id of font and control dialog
IDD_COLORFONT    equ 2015 ;dialog id of ColorFont dialog
IDD_SETUP        equ 2016 ;dialog id of setup dialog
IDD_CONVERT      equ 2017 ;dialog id of tab stop conv dialog
IDD_ABOUT        equ 2018 ;dialog id of about dialog
IDD_VERSION      equ 2019 ;dialog id of version dialog
IDD_ASCII        equ 2020 ;dialog id of key ascii dialog
IDD_GOTOLINE     equ 2021 ;id of goto linenumber dialog
IDD_ASSEMBLE     equ 2022 ;dialog id of assemble dialog
IDD_SAVSET       EQU 2040 ;dialog id of save settings dialog
;IDD_VIEWBMP      EQU 2041 ;dialog id of view bitmap
;
; Miscellaneous EQUates
;
IDS_SYSMENU      EQU 3000     ;System Menu ID
IDM_FILEMENU     EQU 3001
IDM_EDITO        EQU 3002
IDM_SEARCH       EQU 3003
IDM_FORMAT       EQU 3004
IDM_INIT         EQU 3005
IDM_BOOK         EQU 3006
IDM_OPTIONS      EQU 3007
IDM_SNDMENU      EQU 3008
IDM_DIR          EQU 3009
IDD_POPUPC       EQU 3010
IDD_BACKUP       EQU 3011
IDM_TOOLS        EQU 3012
IDM_HELPMENU     EQU 3013
IDM_ABOUTMENU    EQU 3014
 
IDM_COMBO        EQU 4000
IDM_LISTBOX      EQU 4001
IDM_RTF          EQU 4002
;
; Internal (not .rc defined) resource equates
;
ID_TIMER1        EQU 5000
ID_STATUSBAR     EQU 5001
ID_EDITWINDOW    EQU 5003
IDCONVERT        EQU 5004
IDUNDO           EQU 5005
IDSETUP          EQU 5006
IDFINDTS         EQU 5007
IDASSMB          EQU 5008
;
; Menu And Toolbar Equates
;
IDM_NEW          equ 6001
IDM_OPEN         equ 6002
IDM_OPENHEX      equ 6003
IDM_CLOSE        equ 6004
IDM_SAVE         equ 6005
IDM_SAVEAS       equ 6006
IDM_SAVEHEX      equ 6007
IDM_PAGESETUP    equ 6008
IDM_PRINTPRE     equ 6009
IDM_PRINT        equ 6010
IDM_SAVESETTINGS equ 6011
IDM_EXIT         equ 6012
IDM_CUT          equ 6013
IDM_COPY         equ 6014
IDM_PASTE        equ 6015
IDM_DEL          equ 6016
IDM_UNDO         equ 6017
IDM_REDO         equ 6018
IDM_FINDTEXT     equ 6019
IDM_FINDNEXT     equ 6020
IDM_FINDPREV     equ 6021
IDM_REPLACETEXT  equ 6022
IDM_REPLACENEXT  equ 6023
IDM_SHIFTR       equ 6024
IDM_SHIFTL       equ 6025
IDM_SHIFTTO      equ 6026
IDM_POS1         equ 6027
IDM_POS2         equ 6028
IDM_POS3         equ 6029
IDM_POS4         equ 6030
IDM_GOTOLINE     equ 6031
IDM_SELALL       equ 6032
IDM_COLORFONT    equ 6033
IDM_INDENTR      equ 6034
IDM_INDENTL      equ 6035
IDM_WWRAP        equ 6036
IDM_RTFON        equ 6037
IDM_RTFOFF       equ 6038
IDM_SETTABS      equ 6039
IDM_CONV         equ 6040
IDM_HTML         equ 6041
IDM_SETUP        equ 6042
IDM_BOOKS1       equ 6043
IDM_BOOKR1       equ 6044
IDM_BOOKS2       equ 6045
IDM_BOOKR2       equ 6046
IDM_HEAD         equ 6047
IDM_ROOT         equ 6048
IDM_BIN          equ 6049
IDM_PGM          equ 6050
IDM_INC          equ 6051
IDM_EXE          equ 6052
IDM_MISC         equ 6053
IDM_BACKUP       equ 6054
IDM_ASCII        equ 6055
IDM_CALCTB       equ 6056
IDM_HELP         equ 6057
IDM_WHELP        equ 6058
IDM_ABOUT        equ 6059
IDM_VERSION      equ 6060
IDM_EWEDIT       equ 6061
IDM_RUN          equ 6062
IDM_DOS          equ 6063
IDM_ASSEMBLE     equ 6064
IDM_SYNTAX       equ 6065
IDM_UNDOREDO     equ 6066
IDM_CLIP         equ 6067
IDM_RCOLOR       equ 6068
IDM_RKEYWORD     equ 6069
IDM_MAX          equ 6070
IDM_WORK         equ 6071

;
; NUM_TIPS should match the number of strings defines in .rc with resource
; ids in the 20000 range
NUM_TIPS         equ 20
;
; Status bar section equates.
;
SBPART_MESSAGE1  EQU 0           ;general messages
SBPART_MESSAGE2  EQU 1           ;line #
SBPART_MOUSEMOVE EQU 2           ;X - Y Position
SBPART_TIME      EQU 3           ;time of day
SBPARTS          EQU 4           ;total # parts

;
;User defined messages
;
WM_TRACKCURSOR equ WM_USER+1     ;sent to track cursor pos of edit
WM_OPENCOMMANDARGS equ WM_USER+2 ;sent if arguments specified on cmd line
;
; RC defined error message equates
;
ERROR_CREATE_TOOLBAR          equ 30001
ERROR_CREATE_STATUSBAR        equ 30002
ERROR_ALREADY_RUNNING         equ 30003
ERROR_NOTHING_DISPLAYED       equ 30004
ERROR_FILE_SIZE               equ 30005
ERROR_NOREAD                  equ 30006
ERROR_CREATE_FILE             equ 30007
ERROR_SAVE_BEFORE_QUIT        equ 30008
ERROR_FILE_MODIFIED           equ 30009
ERROR_CREATE_EDITWINDOW       equ 30010
ERROR_NOT_FOUND               equ 30011
ERROR_NO_SELECTION            equ 30012
ERROR_SETUP_HAS_NOT_BEEN_RUN  equ 30013
ERROR_REQUIRED_DLL_NOT_FOUND  equ 30014
ERROR_MISSING_DLL             equ 30015
;
; Miscellaneous Equates
;
TRUE     equ     1
FALSE    equ     0

PlayWave         PROTO STDCALL
PlayMidi         PROTO STDCALL

MsgBox   MACRO   Resource:req, Title:=<MsgTitle>, Flags:=<MB_OK or MB_ICONEXCLAMATION>
         mov     eax, Resource
         lea     ebx, Title
         mov     ecx, Flags
         call    CreateMsg
         ENDM

MOVmb    MACRO Var1, Var2
      pushad 
         lea     esi, Var2
         lea     edi, Var1
         mov     al, [esi]
         mov     [edi], al
       popad
         ENDM

MOVmw    MACRO Var1, Var2
      pushad 
         lea     esi, Var2
         lea     edi, Var1
         REPEAT     2
            mov     al, [esi]
            mov     [edi], al
            inc     esi
            inc     edi
         ENDM
        popad
         ENDM

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

;EditMsg EM_SETCHARFORMAT, SCF_SELECTION, offset charF
;EditMsg  macro   msg:req, wparam:=<0>, lparam:=<0>
      ;INVOKE     SendMessage, hREdit, msg, wparam, lparam
         ;endm

TBSep    MACRO hTool
           mov     tbb.iBitmap, 0
           mov     tbb.idCommand, 0
           mov     tbb.fsState, TBSTATE_ENABLED
           mov     tbb.fsStyle, TBSTYLE_SEP
        INVOKE     SendMessage, hTool, TB_ADDBUTTONS, 1, addr tbb
          ENDM

TBButt   MACRO hTool, bID, cID, Text
           mov     tbb.iBitmap, bID    ; Button image number
           mov     tbb.idCommand, cID  ; Command ID number
           mov     tbb.fsState, TBSTATE_ENABLED
           mov     tbb.fsStyle, TBSTYLE_BUTTON
           mov     tbb.dwData, 0
           mov     tbb.iString, Text
        INVOKE     SendMessage, hTool, TB_ADDBUTTONS, 1, addr tbb
          ENDM

wsprintfA        PROTO C :DWORD,:VARARG
wsprintf         equ <wsprintfA>

WinMain          PROTO :DWORD, :DWORD, :DWORD, :DWORD
SetTimer         PROTO :DWORD, :DWORD, :DWORD, :DWORD
CreateWin        PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
CreateCombo      PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
RichEditProc     PROTO :DWORD, :DWORD, :DWORD, :DWORD
ListBoxProc      PROTO :DWORD, :DWORD, :DWORD, :DWORD
HexAscii         PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
AsciiProc        PROTO :DWORD, :DWORD, :DWORD, :DWORD
RulePosProc      PROTO :DWORD, :DWORD, :DWORD, :DWORD
PopUpProc        PROTO :DWORD, :DWORD, :DWORD, :DWORD
Mnemonic         PROTO :DWORD, :DWORD, :DWORD, :DWORD
CmpArray         PROTO :DWORD, :DWORD
AsciiBase        PROTO :DWORD, :DWORD, :DWORD
BaseAscii        PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
Find             PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
StartNewDocument PROTO :DWORD
CheckUncheck     PROTO :DWORD, :DWORD
CheckSav         PROTO :DWORD
RegGetInt        PROTO :DWORD, :DWORD
RegQuery         PROTO :DWORD, :DWORD
RegQuerySZ       PROTO :DWORD, :DWORD
RegSetInt        PROTO :DWORD, :DWORD
RegSet           PROTO :DWORD, :DWORD
RegCloseKey      PROTO :DWORD
;EnableDisableEditMenu PROTO :DWORD
UpdateFormatMenuItems PROTO :DWORD
MarIndDlg        PROTO :DWORD, :DWORD, :DWORD, :DWORD
CreateListWin    PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
LoadList         PROTO :DWORD, :DWORD, :DWORD

;*********** NEW ***********
ProcessMRUFiles  PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
GetRegPath       PROTO :DWORD, :DWORD
BuildHex         PROTO :DWORD, :DWORD, :DWORD, :DWORD
FillBuffer       PROTO :DWORD, :DWORD, :BYTE, :DWORD

