         title   Bitmap Viewer
         .586
         .model flat, stdcall
            option   casemap: none
            include  \MASM32V1\include\windows.inc
            include  \MASM32V1\include\user32.inc
            include  \MASM32V1\include\kernel32.inc
            include  \MASM32V1\include\GDI32.inc

     include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\LIB\USER32.LIB
         includelib  \MASM32V1\LIB\KERNEL32.LIB
         includelib  \MASM32V1\lib\GDI32.LIB

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

BitmapVu        PROTO :DWORD, :DWORD, :DWORD, :DWORD

IDM_CLOSE       equ    5

.data

DlgName1    db  'BitmapVu',0

hWnd        dd  0
hInst       dd  0
SavPath     dd  0
ImgHgt      dd  0
ImgNum      dd  0
SavBuff     dd  0
hSubMenu    dd  0
hDLG        dd  0
ImgArray    dd  0
BmpX        dd  0
BmpY        dd  0

.code

;________________________________________________________________________________
DllEntry PROC hInstance:DWORD, reason:DWORD, reserved1:DWORD
      .if reason == DLL_PROCESS_ATTACH  ; When the dll is loaded
           push     hInstance
            pop     hInst
            mov     eax, TRUE
      .endif
         ret
DllEntry ENDP

;================================================================
BmpView  PROC   hwnd:DWORD, hinst, PathAddr, ArrayAddr, ImgH, ImgN

       MOVmd     hWnd, hwnd
       MOVmd     SavPath, PathAddr
       MOVmd     ImgArray, ArrayAddr
       MOVmd     ImgHgt, ImgH
       MOVmd     ImgNum, ImgN
      INVOKE     LoadMenu, hInst, 601
      INVOKE     GetSubMenu, eax, 0
         mov     hSubMenu, eax

      INVOKE     CreateDialogParam, hInst, addr DlgName1, hWnd, addr BitmapVu, 0

         ret

BmpView  ENDP

;========================================
; Display Images Procedure
;========================================
BitmapVu PROC  uses ebx ecx edx esi edi  hdlg:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
LOCAL    rect:RECT
LOCAL    BmpHeader[26]:BYTE, szPath[256]
LOCAL    MemPtr:DWORD, hFile, Bytesread, hBmp, hMemDC, hDC, XP, YP

      .if wmsg == WM_INITDIALOG
         INVOKE     lstrcpy, addr szPath, SavPath
            mov     ebx, ImgArray
         .if dword ptr[ebx] == 0
               and     BmpX, 0
               and     BmpY, 0
         .endif
            xor     eax, eax
            mov     ecx, 30
         .while (ecx)
            .if dword ptr[ebx+eax] == 0
                MOVmd     [ebx+eax], hdlg
               .break
            .endif
               add     eax, 4
               dec     ecx
         .endw
         .if !ecx
               jmp     ViewDone
         .endif

         INVOKE     SetWindowText, hdlg, addr szPath
         INVOKE     PostMessage, hdlg, WM_LBUTTONDOWN, 44, 0 ; Post to display opened image
            jmp     ViewDone

      .elseif wmsg == WM_CTLCOLORDLG
         INVOKE     SetBkColor, wparam, 00000000h      ; Background color is black
         INVOKE     GetStockObject, BLACK_BRUSH        ; Select the black brush for background
            jmp     ViewRet                            ; Return with brush in eax

      .elseif wmsg == WM_RBUTTONUP
          MOVmd     hDLG, hdlg
         INVOKE     GetWindowRect, hdlg, addr rect
            mov     ecx, lparam                        ; x/y pos of window
            mov     ebx, ecx
            and     ebx, 0000ffffh                     ; ebx = LOWORD(lparam) = x pos
            shr     ecx, 16                            ; eax = HIWORD(lparam) = y pos
            add     ebx, rect.left                     
            add     ecx, rect.top
            add     ebx, 3                             ; x Position
            add     ecx, 20                            ; y Position
         INVOKE     TrackPopupMenu, hSubMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, ebx, ecx, 0, hdlg, addr rect

      .elseif wmsg == WM_PAINT && hdlg != 0
         INVOKE     PostMessage, hWnd, WM_PAINT, 0, 0  ; Need for NT
            jmp     DisplayEM

      .elseif wmsg == WM_LBUTTONDOWN
         .if wparam != 44
               mov     eax, ImgNum
             MOVmd     [eax], lparam
            INVOKE     PostMessage, hdlg, WM_NCLBUTTONDOWN, HTCAPTION, 0 ; Post to drag window in the client area
         .endif
            jmp     DisplayEM

      .elseif wmsg == WM_LBUTTONUP
         jmp     ViewDone

      .elseif wmsg != WM_COMMAND
            jmp     ViewDone
      .endif

         mov     eax, wparam
         cmp     eax, IDM_CLOSE                        ; See if its CLOSE that was pressed
          je     GetOut                                ; and if not leave
         jmp     ViewDone

DisplayEM:
      INVOKE     GetWindowRect, hdlg, ADDR rect
       MOVmd     XP, rect.left
       MOVmd     YP, rect.top
      INVOKE     GetWindowText, hdlg, addr szPath, Lengthof szPath
   INVOKE     lstrcpy, SavPath, addr szPath

      INVOKE     CreateFile, addr szPath, GENERIC_READ, FILE_SHARE_READ,\
                 NULL, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL
         cmp     eax, -1
         jz      NoFile
         mov     hFile, eax

      INVOKE     ReadFile, hFile, addr BmpHeader, 26, addr Bytesread, 0
         cmp     Bytesread, 26
         jnz     NotBitmap
         cmp     word ptr BmpHeader, 'MB'
         jnz     NotBitmap

      INVOKE     GlobalAlloc, 0, dword ptr BmpHeader+2 ; BmpHeader+2 = file size
         or      eax, eax
         jz      NotBitmap
         mov     MemPtr, eax

      INVOKE     SetFilePointer, hFile, 0, 0, 0
      INVOKE     ReadFile, hFile, MemPtr, dword ptr BmpHeader+2, addr Bytesread, 0
      INVOKE     GetDC, hdlg                           ; Get the dc of the window
         mov     hDC, eax
         mov     esi, MemPtr
         add     esi, dword ptr BmpHeader+10           ; Pointer to initialization data
         mov     edi, MemPtr
         add     edi, 14                               ; Pointer to bitmap size and format data
      INVOKE     CreateDIBitmap, hDC, edi, CBM_INIT, esi, edi, 0 ; Creates a device-dependent bitmap from a device-independent bitmap
         mov     hBmp, eax
      INVOKE     CreateCompatibleDC, hDC               ; Create a compatible dc in memory
         mov     hMemDC, eax
      INVOKE     SelectObject, hMemDC, hBmp            ; Select the opened bitmap into the dc
         mov     eax, ImgHgt
       MOVmd     [eax], dword ptr BmpHeader+22
         mov     ebx, dword ptr BmpHeader+18           ; BmpHeader+18 = image width
         mov     ecx, dword ptr BmpHeader+22           ; BmpHeader+22 = image height
         add     ebx, 6
         add     ecx, 6
      .if wparam == 44
            mov     eax, BmpX
            add     XP, eax
            mov     eax, BmpY
            add     YP, eax
            add     BmpX, 4
            add     BmpY, 4
      .endif
      INVOKE     MoveWindow, hdlg, XP, YP, ebx, ecx, 1
      INVOKE     BitBlt, hDC, 0, 0, dword ptr BmpHeader+18, dword ptr BmpHeader+22, hMemDC, 0, 0, SRCCOPY ; Copy the bitmap
      INVOKE     DeleteDC, hMemDC                      ; Delete the memory dc
      INVOKE     ReleaseDC, hdlg, hDC     
      INVOKE     GlobalFree, MemPtr
      INVOKE     DeleteObject, hBmp
      INVOKE     CloseHandle, hFile
         jmp     ViewDone 

NotBitmap:
      INVOKE     CloseHandle, hFile
         jmp     GetOut

NoFile:
         jmp     GetOut

GetOut:
         mov     ebx, ImgArray
         xor     eax, eax
         mov     ecx, 30
      .while     ecx                                   ; Find handle of active window in the array
            mov     edx, hdlg
         .if dword ptr[ebx+eax] == edx
             MOVmd     [ebx+eax], [ebx+eax+4]
               add     eax, 4
               dec     ecx
            .while     ecx                             ; Shift the array to the left
                MOVmd     [ebx+eax], [ebx+eax+4]
                  add     eax, 4
                  dec     ecx
            .endw
            .break  
         .endif
            add     eax, 4
            dec     ecx
      .endw

CancelOut:
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE                             ; Return with TRUE
         jmp     ViewRet

ViewDone:
         mov     eax, FALSE                            ; Return with FALSE

ViewRet:
         RET
BitmapVu ENDP

End DllEntry
;INVOKE     MessageBox, NULL, SavPath, addr DlgName1, MB_OK
