         title   Build

         .586
         .model flat, stdcall
         option casemap:none

            include  \Masm32V1\include\windows.inc
            include  \Masm32V1\include\user32.inc
            include  \Masm32V1\include\GDI32.inc
            include  \Masm32V1\include\kernel32.inc
            include  \MASM32V1\include\advapi32.inc

   include  \MASM32V1\include\DSPMACRO.asm

         includelib  \Masm32V1\lib\user32.lib
         includelib  \Masm32V1\lib\GDI32.lib
         includelib  \Masm32V1\lib\kernel32.lib
         includelib  \MASM32V1\lib\advapi32.lib

WinMain         PROTO  :DWORD, :DWORD, :DWORD, :DWORD
RichEditProc    PROTO  :DWORD, :DWORD, :DWORD, :DWORD
MultSrc         PROTO :DWORD, :DWORD, :DWORD, :DWORD
BuildCmd        PROTO  :DWORD
AsciiBase       PROTO  :DWORD

.const
IDM_EXIT   equ 2
;IDM_FIX    equ 1009

.data
ClassName   db  'Build',0
AppName     db  'Build',0
RichEdit    db  'RichEdit20A',0
RichEdDLL   db  'RICHED20.DLL',0
MenuName    db  'MainMenu',0
FontMS      db  'MS Sans Serif',0  ;'Arial',0

szError     db  'error',0
szError1    db  'The RICHED20.DLL was not found!',0
szError2    db  'Error during pipe creation',0
szError3    db  'Error during process creation',0

szComm      db  'EW_Common',0
szKey       db  'Comm Key',0
szREGSZ     db  'REG_SZ',0
rDEFr       db  '[Default Root Dir]',0
szPath      db  'Path',0
szName      db  'Name',0
szParent    db  'Parent Handle',0
szHBuild    db  'Build Handle',0
szEdit      db  'Edit',0
szChar      db  'CharFormat',0
szCharC     db  'CharFormat Clear',0
szcrF       db  'Char Range',0
szMin       db  'crMin',0
szMax       db  'crMax',0
szRun       db  'Run Code', 0

szPointer   db  'Pointers\',0
szResr      db  'Bin\rc ',0
szAsmb      db  'Bin\ml /c /coff /Cp ',0
szLinkE     db  'Bin\Link /SUBSYSTEM:WINDOWS ',0
szLinkD     db  'Bin\Link /SUBSYSTEM:WINDOWS /DLL /DEF:',0

szSavBuild  db  '[SaveBuild]',0
szR1E       db  'R1=',0
szA1E       db  'A1=',0
szL1E       db  'L1=',0
szL2E       db  'L2=',0
szPtrS      db  'SaveBuild',0
szR1        db  'R1',0
szA1        db  'A1',0
szL1        db  'L1',0
szL2        db  'L2',0

szNULL      db  0
szEnd       db  '*.*',0
szSpace     db  ' ',0
szPer       db  '.',0
szPerL      db  '(',0
szPerR      db  ')',0
szBackS     db  '\',0
szCol       db  ': ',0
szAsm       db  'asm',0
szObj       db  'obj',0
szRes       db  'res',0
szDef       db  'def',0
szExe       db  'exe',0
szDll       db  'dll',0
szPtr       db  'ptr',0

szCallDLL   db  'EWCallDLL.asm',0
szProject   db  'P R O J E C T  ',0
szCompile   db  ' Compiling: ',0
szLinking   db  ' Linking: ',0
szOutput    db  ' Output: ',0
szCRLF      db  0dh,0ah,0

swR         dd  0
swA         dd  0
swD         dd  0
sw1         dd  0
MoreS       dd  0
RunCode     dd  0
Errors      dd  33 dup(0)
Lines       dd  33 dup(0)
Cnt         dd  0
NumErr      dd  0
ResetOn     dd  0

lpType      dd  0
lpcbData    dd  0
lpdwDisp    dd  0

.data?
szExt       db  6   dup(?)
CompA       db  25  dup(?)
SavRes      db  25  dup(?)
SavDef      db  25  dup(?)
SavName     db  25  dup(?)
HoldName    db  25  dup(?)
FileName    db  25  dup(?)
SavNameFull db  25  dup(?)
szProj      db  50  dup(?)
szRC        db  50  dup(?)
szLink      db  256 dup(?)
szOut       db  50  dup(?)
szRoot      db  256 dup(?)
szBuffR     db  256 dup(?)
szBuffA     db  256 dup(?)
szBuffL     db  256 dup(?)
szBuffP     db  256 dup(?)
SavAsm      db  256 dup(?)
szBuffSavA  db  256 dup(?)
SavAsmSav   db  256 dup(?)
PathName    db  256 dup(?)

hInst       dd  ?
CommandLine dd  ?
hREdDll     dd  ?
hParent     dd  ?
hParEdit    dd  ?
hCharF      dd  ?
hCharC      dd  ?
hcrF        dd  ?
hMin        dd  ?
hMax        dd  ?
MainExit    dd  ?
hMenu       dd  ?
hWnd        dd  ? 
hREdit      dd  ?
lpRichEdit  dd  ?
hMult       dd  ?
hList340    dd  ?

charF       CHARFORMAT2 <?>

.code

;________________________________________________________________________________
Start:
      INVOKE     GetModuleHandle, NULL
         mov     hInst, eax
      INVOKE     GetCommandLine
         mov     CommandLine, eax

      INVOKE     LoadLibrary, addr RichEdDLL ; Load the Riched20.dll
         mov     hREdDll, eax
      .if !eax
         INVOKE     MessageBox, NULL, addr szError1, addr AppName, MB_OK or MB_ICONERROR
            jmp     NoGo
      .endif

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hWnd, addr lpdwDisp
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szParent, 0, addr lpType, addr hParent, addr lpcbData
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szEdit, 0, addr lpType, addr hParEdit, addr lpcbData
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szChar, 0, addr lpType, addr hCharF, addr lpcbData
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szCharC, 0, addr lpType, addr hCharC, addr lpcbData
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szcrF, 0, addr lpType, addr hcrF, addr lpcbData
         mov     lpcbData, 4
      INVOKE     RegQueryValueEx, hWnd, addr szRun, 0, addr lpType, addr RunCode, addr lpcbData
      INVOKE     RegCloseKey, hWnd

      INVOKE     WinMain, hInst ,NULL, CommandLine, SW_SHOWDEFAULT
         mov     MainExit, eax
      INVOKE     FreeLibrary, hREdDll

NoGo:
      INVOKE     ExitProcess, MainExit

;________________________________________________________________________________
WinMain proc  uses ebx  hinst:DWORD, hPrevInst:DWORD, CommandLn:DWORD, CmdShow:DWORD
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG

         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, NULL
         mov     wc.cbWndExtra, NULL
        push     hInst
         pop     wc.hInstance
         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.lpszMenuName, offset MenuName
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon, NULL, IDI_APPLICATION
         mov     wc.hIcon, eax
         mov     wc.hIconSm, eax
      INVOKE     LoadCursor, NULL, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

;---------- [Center the window] ----------
      INVOKE     GetSystemMetrics, SM_CXSCREEN
         sub     eax, 400
         shr     eax, 1
        push     eax
      INVOKE     GetSystemMetrics, SM_CYSCREEN
         sub     eax, 300
         shr     eax, 1
         pop     ebx

      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr ClassName,\
                 addr AppName, WS_OVERLAPPEDWINDOW,\
                 ebx, eax, 400, 300, hParent, NULL, hInst, NULL
         mov     hWnd, eax

      INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      INVOKE     UpdateWindow, hWnd
      INVOKE     GetMenu, hWnd
	  mov     hMenu, eax
      .if RunCode
            and     RunCode, 0
         INVOKE     SendMessage, hWnd, WM_COMMAND, 1004, 0
      .endif

      .while TRUE
         INVOKE     GetMessage, addr msg, NULL, 0, 0
            .BREAK .IF (!eax)
            INVOKE     TranslateMessage, addr msg
            INVOKE     DispatchMessage, addr msg
      .endw
         mov     eax, msg.wParam
         ret
WinMain endp

;________________________________________________________________________________
WndProc proc  uses edx  hwnd:DWORD, wmsg, wParam, lParam
LOCAL    pt:POINT
LOCAL    rect:RECT
LOCAL    ft:FINDTEXT
LOCAL    cr:CHARRANGE
LOCAL    szBuff[256]:BYTE, PtrBuild[1024*2]:BYTE
LOCAL    Chg:DWORD, hFile, fpMem, hpMem, Bytesread, hReg, Lnum

      .if wmsg == WM_CREATE

         INVOKE     CreateWindowEx, NULL, addr RichEdit, NULL,\
                    WS_CHILD or WS_VISIBLE or ES_MULTILINE or\
                    ES_AUTOHSCROLL or ES_AUTOVSCROLL or WS_HSCROLL or WS_VSCROLL,\
                    0, 0, 0, 0, hwnd, 21, hInst, NULL
            mov     hREdit, eax

         INVOKE     SetWindowLong, hREdit, GWL_WNDPROC, RichEditProc
            mov     lpRichEdit, eax
         INVOKE     SendMessage, hREdit, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
         INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 100000
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00000000h

            mov     charF.cbSize, sizeof charF
            mov     charF.dwEffects, 0
            mov     charF.yHeight, 180
            mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR ;or CFM_BACKCOLOR
         INVOKE     lstrcpy, addr charF.szFaceName, addr FontMS
            mov     charF.crTextColor, 00ffff00h
            mov     charF.crBackColor, 00000000h
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0
         INVOKE     SetFocus, hREdit
           push     hwnd
            pop     hWnd
           call     BuildFile

      .elseif wmsg == WM_SIZE
            mov     eax, lParam
            mov     edx, eax
            shr     edx, 16
            and     eax, 0ffffh
         INVOKE     MoveWindow, hREdit, 0, 0, eax, edx, TRUE
         INVOKE     SetWindowText, hWnd, addr PathName

      .elseif wmsg == WM_INITMENUPOPUP || wmsg == WM_INITMENU
         .if !swR
            INVOKE     EnableMenuItem, hMenu, 1001, MF_GRAYED
         .endif
         .if swD
            INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_GRAYED
         .endif

      .elseif wmsg == WM_COMMAND
            mov     eax, wParam
           cwde                                 ; Only low word contains command
         .if eax == 9999                        ; Return from parent after highlight
               jmp     DefWin
         .endif

         .if eax > 1000 && eax < 1005
              push     eax
            .if lParam > 1000 && lParam < 1005  ; Return from parent after save
                  and     lParam, 0
                  pop     eax
               INVOKE     PostMessage, hWnd, WM_COMMAND, wParam, lParam
                  jmp     Ret0
            .endif

;---------- [Check to see if text changed or a different file] ----------
            INVOKE     SendMessage, hParEdit, EM_GETMODIFY, 0, 0
            .if eax != 0
                  pop     eax
               INVOKE     SendMessage, hParent, WM_COMMAND, 844, eax
            .endif

;---------- [Send the parent the build handle] ----------
            INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                       KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
            INVOKE     RegSetValueEx, hReg, addr szHBuild, 0, REG_DWORD, addr hWnd, 4
            INVOKE     RegCloseKey, hReg
            INVOKE     SendMessage, hParent, WM_COMMAND, 844, 8888

            INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                       KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
               mov     lpcbData, 29
            INVOKE     RegQueryValueEx, hReg, addr szName, 0, addr lpType, addr FileName, addr lpcbData
            INVOKE     RegCloseKey, hReg
            INVOKE     lstrcmpi, addr SavNameFull, addr FileName
            .if eax != 0
                 call     BuildFile
            .endif

               mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR ;or CFM_BACKCOLOR
               mov     charF.crBackColor, 00000000h
            INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
            INVOKE     GetCursorPos, addr pt
            INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_GRAYED
            INVOKE     GetWindowRect, hWnd, addr rect
               add     rect.left, 20
               add     rect.top, 30
            INVOKE     SetCursorPos, rect.left, rect.top
;            INVOKE     SetCursorPos, pt.x, pt.y
            INVOKE     SetFocus, hREdit
            INVOKE     SendMessage, hREdit, EM_SETSEL, 0, -1
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szProj
            INVOKE     SendMessage, hREdit, WM_PAINT, 0, 0

            INVOKE     SendMessage, hParEdit, EM_GETMODIFY, 0, 0
               mov     Chg, eax
            INVOKE     SendMessage, hParEdit, EM_HIDESELECTION, 1, 0
            INVOKE     SendMessage, hParEdit, EM_SETCHARFORMAT, SCF_ALL, hCharC
            INVOKE     SendMessage, hParEdit, EM_HIDESELECTION, 0, 0
            INVOKE     SendMessage, hParEdit, EM_SETMODIFY, Chg, 0
               pop     eax
         .endif

;---------- [Compile Resource] ----------
         .if eax == 1001
            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szRC
            INVOKE     BuildCmd, addr szBuffR
            .if eax == 1
               .if byte ptr szExt == 'r' || byte ptr szExt == 'R'
                     jmp     DoError
               .else
                     jmp     Ret0
               .endif
            .endif

;---------- [Assemble] ----------
         .elseif eax == 1002
            INVOKE     lstrcmpi, addr HoldName, addr SavName
            .if eax != 0 && swA < 2
               INVOKE     lstrlen, addr HoldName
               INVOKE     lstrcpyn, addr szBuff, addr HoldName, eax
               INVOKE     GetDlgItem, hMult, 240           ; Get the handle of the Edit
                  mov     ebx, eax
               INVOKE     SendMessage, ebx, WM_SETTEXT, 0, addr szBuff
               INVOKE     SendMessage, hList340, LB_SETSEL, TRUE, 0
                  mov     sw1, 1002
               INVOKE     SendMessage, hMult, WM_COMMAND, 540, 0
                  jmp     Ret0
            .endif

;---------- [Retrive saved info from the pointer file] ----------
            .if swA > 1 && !ResetOn
                 call     GetPtr
               .if !eax
                     jmp     UseNew1
               .else
                     jmp     UseSave1
               .endif
            .endif
               and     ResetOn, 0

UseNew1:
            .if swA > 1
                  mov     sw1, 1002
               INVOKE     ShowWindow, hMult, SW_SHOWNORMAL
                  jmp     Ret0
            .endif

UseSave1:
         INVOKE     SetCursorPos, pt.x, pt.y
            INVOKE     BuildCmd, addr szBuffA
            .if eax == 1
               .if byte ptr szExt == 'a' || byte ptr szExt == 'A'
                     jmp     DoError
               .else
                     jmp     Ret0
               .endif
            .endif

;---------- [Link] ----------
         .elseif eax == 1003
            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szLink
            INVOKE     BuildCmd, addr szBuffL
              test     eax, eax
               jnz     Ret0
            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szOut
            .if !swD
               INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_ENABLED
                  add     rect.left, 135
               INVOKE     SetCursorPos, rect.left, rect.top
            .else
               INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_GRAYED
            .endif

;---------- [Complete build] ----------
         .elseif eax == 1004
            INVOKE     lstrcmpi, addr HoldName, addr SavName
            .if eax != 0 && swA < 2
               INVOKE     lstrlen, addr HoldName
               INVOKE     lstrcpyn, addr szBuff, addr HoldName, eax
               INVOKE     GetDlgItem, hMult, 240           ; Get the handle of the Edit
                  mov     ebx, eax
               INVOKE     SendMessage, ebx, WM_SETTEXT, 0, addr szBuff
               INVOKE     SendMessage, hList340, LB_SETSEL, TRUE, 0
                  mov     sw1, 1004
               INVOKE     SendMessage, hMult, WM_COMMAND, 540, 0
                  jmp     Ret0
            .endif

;---------- [Retrive saved info from the pointer file] ----------
            .if swA > 1 && !ResetOn
                 call     GetPtr
               .if !eax
                     jmp     UseNew2
               .else
                     jmp     UseSave2
               .endif
            .endif
               and     ResetOn, 0

UseNew2:
            .if swA > 1
                  mov     sw1, 1004
               INVOKE     ShowWindow, hMult, SW_SHOWNORMAL
                  jmp     Ret0
            .endif

UseSave2:
            .if !swR
                  jmp     NoResr
            .endif
            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szRC
            INVOKE     BuildCmd, addr szBuffR
            .if eax == 1
               .if byte ptr szExt == 'r' || byte ptr szExt == 'R'
                     jmp     DoError
               .else
                     jmp     Ret0
               .endif
            .endif

NoResr:
         INVOKE     SetCursorPos, pt.x, pt.y

            INVOKE     BuildCmd, addr szBuffA
            .if eax == 1
               .if byte ptr szExt == 'a' || byte ptr szExt == 'A'
                     jmp     DoError
               .else
                     jmp     Ret0
               .endif
            .endif

            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     lstrcpy, addr szBuff, addr szCRLF
            INVOKE     lstrcat, addr szBuff, addr szLink

            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szBuff
            INVOKE     BuildCmd, addr szBuffL
              test     eax, eax
               jnz     Ret0
            INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
            INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr szOut
            .if !swD
               INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_ENABLED
                  add     rect.left, 135
               INVOKE     SetCursorPos, rect.left, rect.top
            .else
               INVOKE     EnableMenuItem, hMenu, 3, MF_BYPOSITION or MF_GRAYED
            .endif

;---------- [Build Pointer file if missing] ----------
            INVOKE     lstrlen, addr SavName
            INVOKE     lstrcpyn, addr szBuff, addr SavName, eax
            INVOKE     lstrcat, addr szBuff, addr szCol
            INVOKE     lstrcat, addr szBuff, addr PathName

            INVOKE     lstrcpy, addr PtrBuild, addr szBuff
            .if MoreS > 1
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
               INVOKE     lstrcat, addr PtrBuild, addr szSavBuild
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
               INVOKE     lstrcat, addr PtrBuild, addr szR1E
               INVOKE     lstrcat, addr PtrBuild, addr szBuffR
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
               INVOKE     lstrcat, addr PtrBuild, addr szA1E
               INVOKE     lstrcat, addr PtrBuild, addr szBuffA
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
               INVOKE     lstrcat, addr PtrBuild, addr szL1E
               INVOKE     lstrcat, addr PtrBuild, addr szBuffL
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
               INVOKE     lstrcat, addr PtrBuild, addr szL2E
               INVOKE     lstrcat, addr PtrBuild, addr szLink
               INVOKE     lstrcat, addr PtrBuild, addr szCRLF
            .endif

            INVOKE     CreateFile, addr szBuffP,\
                       GENERIC_READ or GENERIC_WRITE ,\
                       FILE_SHARE_READ or FILE_SHARE_WRITE,\
                       0, OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, 0
            .if eax == -1 || MoreS > 1
               INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, 100000
                  mov     hpMem, eax
               INVOKE     GlobalLock, hpMem
                  mov     fpMem, eax
            .else
                  jmp     Ret0
            .endif

            INVOKE     CreateFile, addr szBuffP,\
                       GENERIC_READ or GENERIC_WRITE ,\
                       FILE_SHARE_READ or FILE_SHARE_WRITE,\
                       NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, NULL
            .if !eax
                  jmp     ClearMem
            .endif
               mov     hFile, eax
            INVOKE     lstrlen, addr PtrBuild
               mov     ebx, eax
            INVOKE     WriteFile, hFile, addr PtrBuild, ebx, addr Bytesread, NULL

            INVOKE     CloseHandle, hFile

ClearMem:
            INVOKE     GlobalUnlock, fpMem
            INVOKE     GlobalFree, hpMem

         .elseif eax == 1009 ; IDM_FIX

;---------- [Get the Error line number(s)] ----------
               and     Cnt, 0
               and     NumErr, 0
               mov     ft.chrg.cpMin, 0

FindNext:
               mov     ft.chrg.cpMax, -1
               lea     eax, offset szError
               mov     ft.lpstrText, eax
            INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN, addr ft
            .if eax != -1
                  mov     ft.chrg.cpMax, eax
                  sub     eax, 15
                  mov     ft.chrg.cpMin, eax
                  lea     eax, offset szPerL
                  mov     ft.lpstrText, eax
               INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN, addr ft
               .if eax != -1
                     mov     ebx, eax
                     inc     eax
                     mov     cr.cpMin, eax

;---------- [Check to see if error is for the displayed file] ----------
                  INVOKE     SendMessage, hREdit, EM_LINEFROMCHAR, ebx, 0
                     mov     ebx, eax
                    push     ebx
                     mov     Lnum, ebx
                     mov     word ptr szBuff, 255
                  INVOKE     SendMessage, hREdit, EM_GETLINE, ebx, addr szBuff
                     pop     ebx
                  INVOKE     SendMessage, hREdit, EM_LINEINDEX, ebx, 0
                     mov     ebx, eax
                     mov     ecx, cr.cpMin
                     sub     ecx, ebx
                  INVOKE     lstrcpyn, addr FileName, addr szBuff, ecx
                  INVOKE     lstrlen, addr FileName
                  .if byte ptr FileName[eax-1] == ' '
                     INVOKE     lstrcpyn, addr FileName, addr FileName, eax
                  .endif
                  INVOKE     lstrcmpi, addr SavNameFull, addr FileName
                  .if eax != 0
                        jmp     NoMatch
                  .endif

;---------- [Get the line number] ----------
                     lea     eax, offset szPerR
                     mov     ft.lpstrText, eax
                  INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN, addr ft
                  .if eax != -1
                        mov     cr.cpMax, eax
                     INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
                     INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szBuff
                       push     cr.cpMin
                        pop     cr.cpMax
                     INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
                     INVOKE     AsciiBase, addr szBuff
                        dec     eax
                        mov     ebx, Cnt
                        mov     Errors[ebx*4], eax
                        mov     eax, Lnum
                        mov     ebx, Cnt
                        mov     Lines[ebx*4], eax
                        inc     Cnt
                        inc     NumErr
                     .if Cnt > 32
                           jmp     NoMore
                     .endif
                  .endif
               .endif

NoMatch:
                 push     ft.chrg.cpMax
                  pop     ft.chrg.cpMin
                  inc     ft.chrg.cpMin
                  jmp     FindNext
            .endif

NoMore:
;---------- [Highlight Errors on the Parent Window] ----------
            INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                       KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
               mov     lpcbData, 4
            INVOKE     RegQueryValueEx, hReg, addr szEdit, 0, addr lpType, addr hParEdit, addr lpcbData

               and     Cnt, 0
            .while (NumErr)
               INVOKE     SendMessage, hParEdit, EM_GETMODIFY, 0, 0
                  mov     Chg, eax
                  mov     ebx, Cnt
               INVOKE     SendMessage, hParEdit, EM_LINEINDEX, Errors[ebx*4], 0
                 push     eax
                  mov     ebx, Cnt
                  mov     ecx, Errors[ebx*4]
                  inc     ecx
               INVOKE     SendMessage, hParEdit, EM_LINEINDEX, ecx, 0
                  mov     ebx, eax
                  pop     eax
                  mov     hMin, eax
                  mov     hMax, ebx
               INVOKE     RegSetValueEx, hReg, addr szHBuild, 0, REG_DWORD, addr hwnd, 4
               INVOKE     RegSetValueEx, hReg, addr szMin, 0, REG_DWORD, addr hMin, 4
               INVOKE     RegSetValueEx, hReg, addr szMax, 0, REG_DWORD, addr hMax, 4
               INVOKE     SendMessage, hParent, WM_COMMAND, 844, 1111

               INVOKE     SendMessage, hParEdit, EM_EXSETSEL, 0, hcrF
               INVOKE     SendMessage, hParEdit, EM_SETCHARFORMAT, SCF_SELECTION, hCharF
               INVOKE     SendMessage, hParEdit, EM_SETMODIFY, Chg, 0
                  inc     Cnt
                  dec     NumErr
            .endw

               mov     ecx, Errors
            .if ecx > 4
                  sub     ecx, 4
            .endif
            INVOKE     SendMessage, hParEdit, EM_LINEINDEX, ecx, 0
               mov     hMin, eax
               mov     hMax, eax
            INVOKE     RegSetValueEx, hReg, addr szMin, 0, REG_DWORD, addr hMin, 4
            INVOKE     RegSetValueEx, hReg, addr szMax, 0, REG_DWORD, addr hMax, 4
            INVOKE     RegCloseKey, hReg
            INVOKE     SendMessage, hParent, WM_COMMAND, 844, 2222

            INVOKE     lstrcmpi, addr SavNameFull, addr FileName
            .if eax == 0
               INVOKE     SendMessage, hParEdit, EM_EXSETSEL, 0, hcrF
            .endif

         .elseif eax == 1005                                 ; Reset
               mov     byte ptr SavNameFull, 0
               mov     ResetOn, 1
            INVOKE     SendMessage, hREdit, WM_SETTEXT, 0, 0

         .elseif eax == 1006                                 ; Run
            INVOKE     lstrcpy, addr szBuff, addr PathName
            INVOKE     lstrcat, addr szBuff, addr SavName
            INVOKE     lstrcat, addr szBuff, addr szExe
            INVOKE     WinExec, addr szBuff, SW_SHOWNORMAL   ; Run a .exe program


         .elseif eax == IDM_EXIT
               jmp     CloseOut
         .endif

      .elseif wmsg == WM_CLOSE
         INVOKE     SetFocus, hParent

CloseOut:
         INVOKE     DestroyWindow, hwnd

      .elseif wmsg == WM_DESTROY
         INVOKE     SetWindowPos, hwnd, HWND_BOTTOM, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_HIDEWINDOW
         INVOKE     PostQuitMessage, NULL

      .else

DefWin:
         INVOKE     DefWindowProc, hwnd, wmsg, wParam, lParam
            ret
      .endif
         jmp     Ret0

DoError:
      INVOKE     SendMessage, hParEdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
      INVOKE     SendMessage, hParEdit, EM_HIDESELECTION, 1, 0
      INVOKE     SendMessage, hParEdit, EM_SETCHARFORMAT, SCF_ALL, hCharC
      INVOKE     SendMessage, hParEdit, EM_HIDESELECTION, 0, 0
      INVOKE     SendMessage, hParEdit, EM_SETMODIFY, Chg, 0
      INVOKE     SendMessage, hWnd, WM_COMMAND, 1009, 0

Ret0:
         xor    eax, eax
         ret
WndProc endp

;_____________________________________________________________________
;---------- [Retrive saved info from the pointer file] ----------
GetPtr PROC
LOCAL    szBuff[256]:byte

      INVOKE     GetPrivateProfileString, addr szPtrS, addr szL1, addr szNULL, addr szBuff, 255, addr szBuffP
      .if eax == 0
            ret
      .endif
      INVOKE     GetPrivateProfileString, addr szPtrS, addr szR1, addr szNULL, addr szBuffR, 255, addr szBuffP
      INVOKE     GetPrivateProfileString, addr szPtrS, addr szA1, addr szNULL, addr szBuffA, 255, addr szBuffP
      INVOKE     GetPrivateProfileString, addr szPtrS, addr szL1, addr szNULL, addr szBuffL, 255, addr szBuffP
      INVOKE     GetPrivateProfileString, addr szPtrS, addr szL2, addr szNULL, addr szBuff, 255, addr szBuffP
      INVOKE     lstrcpy, addr szLink, addr szSpace
      INVOKE     lstrcat, addr szLink, addr szBuff
      INVOKE     lstrcat, addr szLink, addr szCRLF
      INVOKE     lstrcat, addr szLink, addr szCRLF
         and     swA, 0
         mov     eax, 1
         ret
GetPtr endp

;_____________________________________________________________________
;---------- [Executes the batch commands] ----------
BuildCmd PROC  uses ebx  Input:DWORD
LOCAL    sat:SECURITY_ATTRIBUTES
LOCAL    stin:STARTUPINFO
LOCAL    prin:PROCESS_INFORMATION
LOCAL    ft:FINDTEXT
LOCAL    hRead:DWORD, hWrite, BytesRead
LOCAL    buffer[1024]:byte

               mov     sat.nLength, sizeof SECURITY_ATTRIBUTES
               mov     sat.lpSecurityDescriptor, NULL
               mov     sat.bInheritHandle, TRUE
            INVOKE     CreatePipe, addr hRead, addr hWrite, addr sat, NULL
            .if eax == NULL
               INVOKE     MessageBox, hWnd, addr szError2, addr AppName, MB_ICONERROR or MB_OK
            .else
                  mov     stin.cb, sizeof STARTUPINFO
               INVOKE     GetStartupInfo, addr stin
                  mov     eax, hWrite
                  mov     stin.hStdOutput, eax
                  mov     stin.hStdError, eax
                  mov     stin.dwFlags, STARTF_USESHOWWINDOW or STARTF_USESTDHANDLES
                  mov     stin.wShowWindow, SW_HIDE

                  mov     ebx, Input
               INVOKE     CreateProcess, NULL, ebx, NULL, NULL, TRUE, NULL,
                          NULL, addr PathName, addr stin, addr prin
               .if eax == NULL
                  INVOKE     MessageBox, hWnd, addr szError3, addr AppName, MB_ICONERROR or MB_OK
               .else
                  INVOKE     CloseHandle, hWrite
                  .while TRUE
                     INVOKE     RtlZeroMemory, addr buffer, 1024
                     INVOKE     ReadFile, hRead, addr buffer, 1023, addr BytesRead, NULL
                     .if eax == NULL
                        .break
                     .else
                        INVOKE     SendMessage, hREdit, EM_SETSEL, -1, 0
                        INVOKE     SendMessage, hREdit, EM_REPLACESEL, FALSE, addr buffer
                        INVOKE     SendMessage, hREdit, WM_PAINT, 0, 0
                     .endif
                  .endw
                     mov     ft.chrg.cpMin, 0
                     mov     ft.chrg.cpMax, -1
                     lea     eax, offset szError
                     mov     ft.lpstrText, eax
                  INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN or FR_WHOLEWORD, addr ft
                  .if eax != -1
                     INVOKE     CloseHandle, hRead
                        mov     eax, 1
                        ret
                  .endif
               .endif
               INVOKE     CloseHandle, hRead
            .endif
         xor     eax, eax
         ret
BuildCmd ENDP

;_____________________________________________________________________
BuildFile PROC  uses ebx esi
;LOCAL    stin:STARTUPINFO
;LOCAL    prin:PROCESS_INFORMATION
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    hReg:DWORD, hFind, Proj
LOCAL    szBuff[20]:BYTE, szBuff0[256] ;, SavAsm[200]

         mov     byte ptr SavRes, 0
         mov     byte ptr SavAsm, 0
         and     Proj, 0
         and     swA, 0
         and     swD, 0
         and     swR, 0
      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
         mov     lpcbData, 20
      INVOKE     RegQueryValueEx, hReg, addr szKey, 0, addr lpType, addr szBuff, addr lpcbData
         mov     lpcbData, 250
      INVOKE     RegQueryValueEx, hReg, addr szPath, 0, addr lpType, addr PathName, addr lpcbData
         mov     lpcbData, 29
      INVOKE     RegQueryValueEx, hReg, addr szName, 0, addr lpType, addr FileName, addr lpcbData
      INVOKE     RegSetValueEx, hReg, addr szHBuild, 0, REG_DWORD, addr hWnd, 4
      INVOKE     RegCloseKey, hReg

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szBuff, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
         mov     lpcbData, 250
      INVOKE     RegQueryValueEx, hReg, addr rDEFr, 0, addr lpType, addr szRoot, addr lpcbData
      .if eax != ERROR_SUCCESS
; Do message
         INVOKE     RegCloseKey, hReg
            jmp     AllDone
      .endif
      INVOKE     RegCloseKey, hReg

      INVOKE     lstrcpy, addr szBuffR, addr szRoot
      INVOKE     lstrcpy, addr szBuffA, addr szRoot
      INVOKE     lstrcpy, addr szBuffL, addr szRoot
      INVOKE     lstrcpy, addr szBuffP, addr szRoot
      INVOKE     lstrcat, addr szBuffR, addr szResr
      INVOKE     lstrcat, addr szBuffA, addr szAsmb
      INVOKE     lstrcat, addr szBuffP, addr szPointer
      INVOKE     lstrcpy, addr SavNameFull, addr FileName

      INVOKE     lstrlen, addr FileName
      .while (eax)
            dec     eax
         .if byte ptr FileName[eax] == '.'
            .break
         .endif
      .endw
        push     eax
      INVOKE     lstrcpy, addr szExt, addr FileName[eax+1]
         pop     eax
         add     eax, 2
      INVOKE     lstrcpyn, addr FileName, addr FileName, eax
      INVOKE     lstrcpy, addr HoldName, addr FileName

      INVOKE     lstrlen, addr PathName
      .while (eax)
            dec     eax
         .if byte ptr PathName[eax] == '\'
            .break
         .endif
      .endw
         add     eax, 2
      INVOKE     lstrcpyn, addr szBuff0, addr PathName, eax
      INVOKE     lstrcpy, addr PathName, addr szBuff0
      INVOKE     lstrcat, addr szBuff0, addr szEnd

;---------- [Get folder as FileName if not in the root dir] ----------
      INVOKE     lstrlen, addr PathName
        push     eax
         dec     eax
      .while (eax)
            dec     eax
         .if byte ptr PathName[eax] == '\'
            .if byte ptr PathName[eax-1] == ':'
                  jmp     GetFirst
            .endif
            .break
         .endif
      .endw
         pop     ecx
         sub     ecx, eax
         inc     eax
         dec     ecx
      INVOKE     lstrcpyn, addr FileName, addr PathName[eax], ecx
      INVOKE     lstrcat, addr FileName, addr szPer
         mov     Proj, 1

GetFirst:
      INVOKE     lstrcat, addr szBuffP, addr FileName
      INVOKE     lstrcat, addr szBuffP, addr szPtr
      INVOKE     lstrcpy, addr SavName, addr FileName

      INVOKE     FindFirstFile, addr szBuff0, addr FindData
        test     eax, eax
          js     Ret0
         mov     hFind, eax

      .if !hMult
         INVOKE     CreateDialogParam, hInst, 4901, hWnd, addr MultSrc, 0
            mov     hMult, eax
      .else
         INVOKE     SendMessage, hList340, LB_RESETCONTENT, 0, 0
      .endif
;      INVOKE     ShowWindow, hMult, SW_HIDE

;---------- [Make sure the proper FileName is first in mult. source file projects] ----------
mov     Proj, 1   ; NOTE! May want to remove this.
      .if Proj
         INVOKE     lstrcpy, addr CompA, addr FileName
         INVOKE     lstrcat, addr CompA, addr szAsm
         INVOKE     lstrcat, addr szBuffA, addr FileName
         INVOKE     lstrcat, addr szBuffA, addr szAsm
         INVOKE     lstrcat, addr szBuffA, addr szSpace
         INVOKE     lstrcat, addr SavAsm, addr FileName
         INVOKE     lstrcat, addr SavAsm, addr szObj
         INVOKE     lstrcat, addr SavAsm, addr szSpace
      .endif
         jmp     ChkFile

GetNext:
      INVOKE     FindNextFile, hFind, addr FindData
      .if eax == 0
            jmp     AllDone
      .endif

ChkFile:
      .if byte ptr FindData.cFileName == '.'
            jmp     GetNext
      .else
         INVOKE     lstrcmpi, addr FindData.cFileName, addr szCallDLL
         .if eax == 0
               jmp     GetNext
         .endif
      .endif
      INVOKE     lstrlen, addr FindData.cFileName
         mov     Cnt, eax
         sub     eax, 3
         lea     esi, FindData.cFileName
         add     esi, eax
         mov     ecx, 3
        call     LowerCase                ; Convert to lowercase for compare

      .while (Cnt)
            dec     Cnt
            mov     eax, Cnt
         .if byte ptr FindData.cFileName[eax] == '.'
            .if byte ptr FindData.cFileName[eax+1] == 'r' && byte ptr FindData.cFileName[eax+2] == 'c'
                  mov     swR, 1
               INVOKE     lstrcat, addr szBuffR, addr FindData.cFileName
               INVOKE     lstrlen, addr FindData.cFileName
                  dec     eax
               INVOKE     lstrcpyn, addr SavRes, addr FindData.cFileName, eax
               INVOKE     lstrcat, addr SavRes, addr szRes
               INVOKE     lstrcpy, addr szRC, addr szCompile
               INVOKE     lstrcat, addr szRC, addr FindData.cFileName
               INVOKE     lstrcat, addr szRC, addr szCRLF
               INVOKE     lstrcat, addr szRC, addr szCRLF
            .elseif byte ptr FindData.cFileName[eax+1] == 'a' && byte ptr FindData.cFileName[eax+2] == 's'
                  inc     swA
               INVOKE     SendMessage, hList340, LB_ADDSTRING, 0, addr FindData.cFileName
               .if Proj
                  INVOKE     lstrcmpi, addr CompA, addr FindData.cFileName
                  .if !eax
                     .break
                  .endif
               .endif
               INVOKE     lstrcat, addr szBuffA, addr FindData.cFileName
               INVOKE     lstrcat, addr szBuffA, addr szSpace
               INVOKE     lstrcpy, addr szBuff, addr FindData.cFileName
               INVOKE     lstrlen, addr szBuff
                  sub     eax, 2
               INVOKE     lstrcpyn, addr szBuff, addr szBuff, eax
               INVOKE     lstrcat, addr szBuff, addr szObj
               INVOKE     lstrcat, addr SavAsm, addr szBuff
               INVOKE     lstrcat, addr SavAsm, addr szSpace
            .elseif byte ptr FindData.cFileName[eax+1] == 'd' && byte ptr FindData.cFileName[eax+2] == 'e'
                  mov     swD, 1
               INVOKE     lstrlen, addr FindData.cFileName
                  sub     eax, 2
               INVOKE     lstrcpyn, addr SavDef, addr FindData.cFileName, eax
               INVOKE     lstrcat, addr SavDef, addr szDef
               INVOKE     lstrcat, addr SavDef, addr szSpace
            .else
               .break
            .endif
         .endif
      .endw
         jmp     GetNext

AllDone:
      INVOKE     FindClose, hFind
;        push     swA
;         pop     MoreS
        call     OutPut

Ret0:
         xor     eax, eax
          ret
BuildFile ENDP

;=========================================================================
; Multiple Source PROCEDURE                                              *
;=========================================================================
MultSrc  PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL    Num:DWORD, CntL, Val
LOCAL    szNameL[256]:BYTE, szBuff0[25], szBuff[25]

      .if wmsg == WM_INITDIALOG
         INVOKE     GetDlgItem, hdlg, 340           ; Get the handle of the Listbox
            mov     hList340, eax                   ; Save it
         INVOKE     lstrlen, addr SavName
         INVOKE     lstrcpyn, addr szBuff, addr SavName, eax
         INVOKE     GetDlgItem, hdlg, 240           ; Get the handle of the Edit
            mov     ebx, eax
         INVOKE     SendMessage, ebx, WM_SETTEXT, NULL, addr szBuff

            jmp     MultSrcDone

      .elseif wmsg == WM_CTLCOLORDLG || wmsg == WM_CTLCOLORSTATIC
         INVOKE     GetStockObject, WHITE_BRUSH     ; Select the white brush for the background
            ret

      .elseif wmsg == WM_CTLCOLORLISTBOX ||  wmsg == WM_CTLCOLOREDIT
         INVOKE     SetBkColor, wparam, 00000000h   ; Background color is black
         INVOKE     SetTextColor, wparam, 00ffff00h ; Text color of edit box is lt blue
         INVOKE     GetStockObject, BLACK_BRUSH     ; Select the black brush for background
            ret

      .elseif wmsg == WM_CLOSE
            jmp     wmclose
GetOut:
         .if sw1 == 1002
            INVOKE     PostMessage, hWnd, WM_COMMAND, 1002, 0
         .else
            INVOKE     PostMessage, hWnd, WM_COMMAND, 1004, 0
         .endif

wmclose:
;            and     hMult, 0
         INVOKE     EndDialog, hdlg, wparam
            mov     eax, TRUE
            jmp     MultSrcRet

      .elseif wmsg != WM_COMMAND
            jmp     MultSrcDone
      .endif
         mov     eax, wparam
      .if ax == 540
           push     swA
            pop     MoreS
         INVOKE     GetDlgItem, hdlg, 240           ; Get the handle of the Edit
            mov     ebx, eax
         INVOKE     SendMessage, ebx, WM_GETTEXT, 24, addr FileName
         INVOKE     lstrcat, addr FileName, addr szPer
         INVOKE     lstrcpy, addr SavName, addr FileName
         INVOKE     lstrcpy, addr HoldName, addr FileName
         INVOKE     lstrcpy, addr CompA, addr FileName
         INVOKE     lstrcat, addr CompA, addr szAsm
         INVOKE     lstrcpy, addr szBuffSavA, addr szRoot
         INVOKE     lstrcat, addr szBuffSavA, addr szAsmb
         INVOKE     lstrcat, addr szBuffSavA, addr FileName
         INVOKE     lstrcat, addr szBuffSavA, addr szAsm
         INVOKE     lstrcat, addr szBuffSavA, addr szSpace
            mov     byte ptr SavAsmSav, 0
         INVOKE     lstrcat, addr SavAsmSav, addr FileName
         INVOKE     lstrcat, addr SavAsmSav, addr szObj
         INVOKE     lstrcat, addr SavAsmSav, addr szSpace

         INVOKE     SendMessage, hList340, LB_GETSELCOUNT, 0, 0
         .if !eax
               jmp     MultSrcDone
         .endif
            mov     ebx, eax
         INVOKE     SendMessage, hList340, LB_GETSELITEMS, ebx, addr szNameL
            mov     Num, eax
            mov     Val, eax
            and     CntL, 0
         .while (Num)
               mov     ecx, CntL
            INVOKE     SendMessage, hList340, LB_GETTEXT, dword ptr szNameL[ecx*4], addr szBuff0
            INVOKE     lstrcmpi, addr CompA, addr szBuff0
            .if eax != 0 && Val != 1
               INVOKE     lstrcat, addr szBuffSavA, addr szBuff0
               INVOKE     lstrcat, addr szBuffSavA, addr szSpace
               INVOKE     lstrcpy, addr szBuff, addr szBuff0
               INVOKE     lstrlen, addr szBuff
                  sub     eax, 2
               INVOKE     lstrcpyn, addr szBuff, addr szBuff, eax
               INVOKE     lstrcat, addr szBuff, addr szObj
               INVOKE     lstrcat, addr SavAsmSav, addr szBuff
               INVOKE     lstrcat, addr SavAsmSav, addr szSpace
            .endif
               inc     CntL
               dec     Num
         .endw
         INVOKE     lstrcpy, addr szBuffL, addr szRoot
         INVOKE     lstrcpy, addr szBuffA, addr szBuffSavA
         INVOKE     lstrcpy, addr SavAsm, addr SavAsmSav
           call     OutPut
            and     swA, 0
            jmp     GetOut
      .endif

MultSrcDone:
         mov     eax, FALSE           ; Return with FALSE

MultSrcRet:
         RET
MultSrc  ENDP

;=========================================================================
; Build the OutPut PROCEDURE                                             *
;=========================================================================
OutPut  PROC
;      INVOKE     lstrcpy, addr szLink, addr szCRLF
      INVOKE     lstrcpy, addr szLink, addr szLinking
      INVOKE     lstrcpy, addr szOut, addr szCRLF
      INVOKE     lstrcat, addr szOut, addr szOutput
      INVOKE     lstrcat, addr szOut, addr FileName
      .if !swD
         INVOKE     lstrcat, addr szBuffL, addr szLinkE
         INVOKE     lstrcat, addr szBuffL, addr SavAsm
         INVOKE     lstrcat, addr szLink, addr SavAsm
         INVOKE     lstrcat, addr szOut, addr szExe
      .else
         INVOKE     lstrcat, addr szBuffL, addr szLinkD
         INVOKE     lstrcat, addr szBuffL, addr SavDef
         INVOKE     lstrcat, addr szBuffL, addr SavAsm
         INVOKE     lstrcat, addr szLink, addr SavDef
         INVOKE     lstrcat, addr szLink, addr SavAsm
         INVOKE     lstrcat, addr szOut, addr szDll
      .endif
      INVOKE     lstrcat, addr szBuffL, addr SavRes
      INVOKE     lstrcat, addr szLink, addr SavRes
      INVOKE     lstrcat, addr szLink, addr szCRLF
      INVOKE     lstrcat, addr szLink, addr szCRLF
      INVOKE     lstrcat, addr szOut, addr szCRLF

      INVOKE     lstrcpy, addr szProj, addr szProject
      INVOKE     lstrcat, addr szProj, addr FileName
      INVOKE     lstrcat, addr szProj, addr szCRLF
      INVOKE     lstrcat, addr szProj, addr szCRLF
         RET
OutPut  ENDP

;=========================================================================
; esi = input string pointer ecx = Len get before call                   *
; Returns string converted to lower case                                 *
;=========================================================================
LowerCase PROC
         xor     eax, eax
      .while ecx
         .if byte ptr[esi+eax] >= 'A' && byte ptr[esi+eax] <= 'Z'
               add     byte ptr[esi+eax], 20h   ; add 20h to upper case bit
         .endif
            inc     eax
            dec     ecx
      .endw
         ret
LowerCase ENDP

;=========================================================================
RichEditProc PROC  uses ebx esi edi  hwnd, wmsg, wparam, lparam
LOCAL    cr:CHARRANGE
LOCAL    sw:DWORD, hReg
LOCAL    szBuff[128]:BYTE, szBuff0[256]

      .if wmsg == WM_MOUSEMOVE
         INVOKE     GetFocus
         .if eax != hWnd
            INVOKE     SetFocus, hWnd
         .endif

      .elseif wmsg == WM_LBUTTONUP
;---------- [Scroll the error line on the Parent Window into view] ----------
         INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szBuff0
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
         INVOKE     SendMessage, hREdit, EM_LINEINDEX, -1, 0
         INVOKE     SendMessage, hREdit, EM_SETSEL, eax, eax
         INVOKE     lstrlen, addr szBuff0
         .if eax > 250
               jmp      ThatsAll
         .endif
            mov     ecx, eax
            xor     eax, eax
            lea     esi, szBuff0
            lea     edi, szBuff
         .while (ecx)
            .if byte ptr[esi] == '('
                  inc     esi
                  mov     al, byte ptr[esi]
                  mov     byte ptr[edi], al
                  inc     esi
                  inc     edi
                  sub     ecx, 2
               .while (ecx)
                  .if byte ptr[esi] == ')' && byte ptr[esi]+2 == ':' && byte ptr[esi]+4 == 'e'
                        mov     byte ptr[edi], 0
                        jmp     GotIt
                  .else
                     mov     al, byte ptr[esi]
                     mov     byte ptr[edi], al
                     inc     esi
                     inc     edi
                     dec     ecx
                  .endif
               .endw
                  jmp     ThatsAll
            .endif
            inc     esi
            dec     ecx
         .endw
      .endif
         jmp     ThatsAll

GotIt:
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR or CFM_BACKCOLOR
         mov     charF.crBackColor, 000000ffh
      INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_SELECTION, addr charF

      INVOKE     AsciiBase, addr szBuff
         dec     eax
         and     Cnt, 0
      .while (Cnt < 33)
            mov     ebx, Cnt
         .if eax == Errors[ebx*4]
            INVOKE     SendMessage, hParEdit, EM_LINEINDEX, eax, 0
               mov     hMin, eax
               mov     hMax, eax
            INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                       KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
               mov     lpcbData, 4
            INVOKE     RegQueryValueEx, hReg, addr szEdit, 0, addr lpType, addr hParEdit, addr lpcbData
            INVOKE     RegSetValueEx, hReg, addr szMin, 0, REG_DWORD, addr hMin, 4
            INVOKE     RegSetValueEx, hReg, addr szMax, 0, REG_DWORD, addr hMax, 4
            INVOKE     RegCloseKey, hReg
            INVOKE     SendMessage, hParent, WM_COMMAND, 844, 2222
            INVOKE     SendMessage, hParEdit, EM_EXSETSEL, 0, hcrF
            INVOKE     SendMessage, hParent, WM_COMMAND, 844, 4444
            INVOKE     SendMessage, hParEdit, EM_EXSETSEL, 0, hcrF
            .break
         .endif
            inc     Cnt
      .endw

ThatsAll:
      INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam

         ret
RichEditProc ENDP

;=================================================
; Converts an ascii string to a 32 bit num value.
;=================================================
;            INVOKE     AsciiBase, addr szBuff
;               mov     Num, eax
AsciiBase proc uses edx esi InPut:DWORD

         xor     eax, eax
         mov     esi, InPut
         xor     ecx, ecx
         xor     edx, edx
         mov     al, [esi]
         inc     esi
      .while al != 0
            sub     al, '0'          ; Convert to bcd
            lea     ecx, [ecx+ecx*4] ; ecx = ecx * 5
            lea     ecx, [eax+ecx*2] ; ecx = eax + old ecx * 10
            mov     al, [esi]
            inc     esi
      .endw

         lea     eax, [ecx]          ; Move to eax and negate
         ret

AsciiBase endp

end Start
;INVOKE     MessageBox, NULL, addr szText, addr AppName, MB_OK
