         title   Create
         .586
         .model flat, stdcall
            option   casemap: none
            include  \MASM32V1\include\windows.inc
            include  \MASM32V1\include\user32.inc
            include  \MASM32V1\include\kernel32.inc
            include  \MASM32V1\include\gdi32.inc
            include  \Masm32V1\include\comdlg32.inc
            include  \MASM32V1\include\advapi32.inc
            include   \MASM32V1\include\shell32.inc

     include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\LIB\user32.lib
         includelib  \MASM32V1\LIB\kernel32.lib
         includelib  \MASM32V1\LIB\gdi32.lib
         includelib  \Masm32V1\lib\comdlg32.lib
         includelib  \MASM32V1\lib\advapi32.LIB
         includelib  \MASM32V1\LIB\shell32.LIB

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

WndProc          PROTO :DWORD, :DWORD, :DWORD, :DWORD
UserTemp         PROTO :DWORD, :DWORD, :DWORD, :DWORD
EmptyDir         PROTO :DWORD
ControlButt      PROTO :DWORD, :DWORD, :DWORD, :DWORD
ButtonType       PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

.data

pTitle      db  'Delete Projects',0
ClassName   db  'Create',0
Richedit    db  'RichEdit20A',0
;RichEdDLL   db  'RICHED20.DLL',0
listbox     db  'LISTBOX',0
FontName    db  'MS Sans Serif',0

szALL       db  'All Files',0,'*.*',0,0

szIncWin    db  '\Include\Windows.inc',0
szWin       db  'Windows.inc',0
szPointer   db  'Pointers\',0
szTemplates db  'Templates\',0
szProjects  db  'Projects\',0
szUser      db  'User\',0
szCallDLLb  db  'EWCallDLL.bat',0
szCallDLLe  db  'EWCallDLL.exe',0
szPgm01     db  'Pgm01',0
szPgm02     db  'Pgm02',0
szPgm03     db  'Pgm03',0
szPgm04     db  'Pgm04',0
szPgm05     db  'Pgm05',0
szPgm06     db  'Pgm06',0
szPgm07     db  'Pgm07',0
szPgm08     db  'Pgm08',0
szPgm11     db  'Pgm11',0
szPtr       db  '.ptr',0
szExe       db  '.exe',0
szAsm       db  '*.asm',0
szDef       db  '*.def',0
szRsc       db  '*.rc',0
szBackS     db  '\',0
szEnd       db  '*.*',0
szCol       db  ': ',0
szSavName   db  50 dup(?)
szCancel    db  'Cancel',0
szCreate    db  'Create',0
szBrowse    db  'Browse',0
szReturn    db  'Return',0
szUserDef   db  'User Defined Templates',0

szXXXX      db  'xxxx',0

DlgName1    db  'Create',0
DlgName2    db  'UserTemp',0
DlgName3    db  'CreateF',0
szREGSZ     db  'REG_SZ',0
rDEFr       db  '[Default Root Dir]',0

szClr       db  0,0
szErr       db  3,0  ;4
szError1    db  'The Projects Folder Is Missing!'
            db  0Dh,0Ah
            db  'Make Sure You Have Created The:'
            db  0Dh,0Ah
            db  0Dh,0Ah
            db  'PROJECTS and TEMPLATES folders'
            db  0Dh,0Ah
            db  0Dh,0Ah
            db  'In The Above Directory.',0
szError2    db  'The Above Folder Already Exists, Do You Wish To Continue?',0
szError3    db  'The Contents Of The Templates Folder Is Corrupted.',0
szError4    db  'The Contents Of The Projects Folder Is Corrupted.',0
szError5    db  'You Must Enter A Project Name.',0
szError6    db  'You Must Make A Selection To Use Return.',0
szError7    db  'Are you sure you want to delete the Project.',0
szError8    db  'The Program file(s) are not in the Project Directory.'
            db  0Dh,0Ah
            db  0Dh,0Ah
            db  'Are you sure you want to DELETE the Project?',0
szError9    db  'There was a problem trying to delete the Project.',0
szError10   db  'There was a problem trying to delete the Folder.',0

hInst       dd  0
hWnd        dd  0
fpMem       dd  0
hpMem       dd  0
SavPath     dd  0
SavReg      dd  0
SavErr      dd  0
hAsmbox     dd  0
szNameP     dd  0
SavBuff     dd  0
hEdit       dd  0
hListBox    dd  0
hWndProc    dd  0
hBR         dd  0
Asm         dd  0
Def         dd  0
Rsc         dd  0
FolderSW    dd  0
hCreate     dd  0
hBrowse     dd  0
hCancel     dd  0
hReturn     dd  0
hUser       dd  0
SubControl  dd  0
hFontB      dd  0

lpType      dd  0
lpcbData    dd  0
lpdwDisp    dd  0

hin         dd  0

ft          FINDTEXT   <>

.code

DllEntry PROC hInstance:DWORD, reason:DWORD, reserved1:DWORD
      .if reason == DLL_PROCESS_ATTACH  ; When the dll is loaded
          MOVmd     hInst, hInstance
            mov     eax, TRUE
      .endif
         ret
DllEntry ENDP

;================================================================
Create  PROC   hwnd:DWORD, hinst, PathAddr, szReg, Err

       MOVmd     hWnd, hwnd
       MOVmd     hin, hinst
       MOVmd     SavPath, PathAddr
       MOVmd     SavReg, szReg
       MOVmd     SavErr, Err

      INVOKE     lstrcpy, SavErr, addr szErr
      INVOKE     DialogBoxParam, hInst, addr DlgName1, hWnd, addr WndProc, 0
;INVOKE     lstrcpy, SavErr, addr szErr
;      INVOKE     CreateDialogParam, hInst, addr DlgName1, hWnd, addr WndProc, 0
         ret

Create  ENDP

;================================================================
Folder  PROC   hwnd:DWORD, hinst, PathAddr, szReg, Err

       MOVmd     hWnd, hwnd
       MOVmd     hin, hinst
       MOVmd     SavPath, PathAddr
       MOVmd     SavReg, szReg
       MOVmd     SavErr, Err

         mov     FolderSW, 1
      INVOKE     lstrcpy, SavErr, addr szErr
      INVOKE     DialogBoxParam, hInst, addr DlgName3, hWnd, addr WndProc, 0
         ret

Folder  ENDP

;____________________________________________________________________
WndProc proc  uses ebx  hdlg:DWORD, wMsg, wParam, lParam
LOCAL    rect:RECT
LOCAL    cr:CHARRANGE
LOCAL    lf:LOGFONT
LOCAL    ofn:OPENFILENAME
LOCAL    ShFileOp:SHFILEOPSTRUCT
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    hReg:DWORD, hREdit, hFile, hFind, hFindSub, Bytesread, sw1, ChkDLL, Chk11
LOCAL    szName[64]:BYTE, szExt[10], szRoot[256], szBuff0[256], szBuff1[256], szBuff2[256], szSavBuff[256]
LOCAL    szCurDir[256]:BYTE, szWork[30], szWorkPgm[30]

      .if wMsg == WM_INITDIALOG

         INVOKE     LoadIcon, 0, IDI_APPLICATION
         INVOKE     SendMessage, hdlg, WM_SETICON, 1, eax

          MOVmd     hWndProc, hdlg
         INVOKE     GetDlgItem, hdlg, 401
         INVOKE     SetFocus, eax
         INVOKE     GetDlgItem, hdlg, 502
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0
         INVOKE     GetDlgItem, hdlg, 504
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0
         INVOKE     GetDlgItem, hdlg, 506
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0
         INVOKE     GetDlgItem, hdlg, 507
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0
         INVOKE     GetDlgItem, hdlg, 510
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0
         INVOKE     GetDlgItem, hdlg, 512
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0

         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, SavReg, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
            mov     lpcbData, 250
         INVOKE     RegQueryValueEx, hReg, addr rDEFr, 0, addr lpType, addr szRoot, addr lpcbData
         .if eax == ERROR_SUCCESS
            INVOKE     lstrcpy, addr szBuff0, addr szRoot
            INVOKE     lstrcat, addr szBuff0, addr szProjects
         .endif
         INVOKE     RegCloseKey, hReg
         INVOKE     SetDlgItemText, hdlg, 402, addr szBuff0

      INVOKE     RtlZeroMemory, addr lf, sizeof lf
      INVOKE     lstrcpy, addr lf.lfFaceName, addr FontName
         mov     lf.lfHeight, 14
         mov     lf.lfWeight, 600
      INVOKE     CreateFontIndirect, ADDR lf
         mov     hFontB, eax

      INVOKE     GetDlgItem, hdlg, 801            ; Get the handle of the User
         mov     hUser, eax                       ; Save it
      INVOKE     SetWindowLong, hUser, GWL_WNDPROC, ControlButt
         mov     SubControl, eax
      INVOKE     GetDlgItem, hdlg, 901            ; Get the handle of the Create
         mov     hCreate, eax                    ; Save it
      INVOKE     SetWindowLong, hCreate, GWL_WNDPROC, ControlButt
         mov     SubControl, eax
      INVOKE     GetDlgItem, hdlg, 902            ; Get the handle of the Browse
         mov     hBrowse, eax                    ; Save it
      INVOKE     SetWindowLong, hBrowse, GWL_WNDPROC, ControlButt
         mov     SubControl, eax
      INVOKE     GetDlgItem, hdlg, IDCANCEL       ; Get the handle of the IDCANCEL
         mov     hCancel, eax                    ; Save it
      INVOKE     SetWindowLong, hCancel, GWL_WNDPROC, ControlButt
         mov     SubControl, eax


            and     Asm, 0
            and     Def, 0
            and     Rsc, 0
            and     fpMem, 0
            and     hpMem, 0
            jmp     Ret0
      .endif

      .if wMsg == WM_CTLCOLORDLG
;         INVOKE     GetStockObject, WHITE_BRUSH        ; Select the white brush for the background
         .if hBR
            INVOKE     DeleteObject, hBR
         .endif
         INVOKE     CreateSolidBrush, 00ffffe0h
            mov     hBR, eax
            ret
      .endif

      .if wMsg == WM_CTLCOLORSTATIC
         INVOKE     GetDlgItem, hdlg, 34
         .if lParam != eax
;            INVOKE     GetStockObject, WHITE_BRUSH     ; Select the white brush for the background
            INVOKE     SetBkColor, wParam, 00ffffe0h
            INVOKE     SetTextColor, wParam, 00000000h
            .if hBR
               INVOKE     DeleteObject, hBR
            .endif
            INVOKE     CreateSolidBrush, 00ffffe0h
               mov     hBR, eax

         .else
;            INVOKE     SetBkColor, wParam, 00000000h   ; Background color is black
;            INVOKE     SetTextColor, wParam, 00ffff00h ; Text color of edit box is lt blue
;            INVOKE     GetStockObject, BLACK_BRUSH     ; Select the black brush for background
            INVOKE     SetBkColor, wParam, 00ffffeah
            INVOKE     SetTextColor, wParam, 00800000h
            .if hBR
               INVOKE     DeleteObject, hBR
            .endif
            INVOKE     CreateSolidBrush, 00ffffeah
               mov     hBR, eax
         .endif
            ret
      .endif

      .if wMsg == WM_CTLCOLORLISTBOX || wMsg == WM_CTLCOLOREDIT
         INVOKE     SetBkColor, wParam, 00000000h      ; Background color is black
         INVOKE     SetTextColor, wParam, 00ffff00h    ; Text color of edit box is lt blue
         INVOKE     GetStockObject, BLACK_BRUSH        ; Select the black brush for background
            ret
      .endif

      .if wMsg == WM_COMMAND
         .if wParam == IDCANCEL
            INVOKE     lstrcpy, SavErr, addr szErr
               jmp     GetOut

         .elseif wParam == 504                                     ; Set no .rc
            INVOKE     IsDlgButtonChecked, hdlg, 505               ; Dialog as main window
            .if eax
               INVOKE     CheckRadioButton, hdlg, 503, 504, 503    ; Set .rc
            .endif
            INVOKE     IsDlgButtonChecked, hdlg, 508               ; No edit
            .if eax
               INVOKE     CheckRadioButton, hdlg, 503, 504, 503    ; Set .rc
            .endif

         .elseif wParam == 505                                     ; Dialog as main window
            INVOKE     IsDlgButtonChecked, hdlg, 505
            .if eax
               INVOKE     CheckRadioButton, hdlg, 503, 504, 503    ; Set .rc
            .endif

         .elseif wParam == 508                                     ; No edit
            INVOKE     IsDlgButtonChecked, hdlg, 504
            .if eax
               INVOKE     CheckRadioButton, hdlg, 503, 504, 503    ; Set .rc
            .endif

         .elseif wParam == 509                                     ; MDI
            INVOKE     CheckRadioButton, hdlg, 503, 504, 503       ; Set .rc
            INVOKE     CheckRadioButton, hdlg, 501, 502, 502       ; Set no .dll

         .elseif wParam == 510                                     ; No MDI
            INVOKE     CheckRadioButton, hdlg, 503, 504, 504       ; Set no .rc

         .elseif wParam == 801                                     ; UserTemplates
               lea     eax, szSavBuff
               mov     SavBuff, eax
            INVOKE     DialogBoxParam, hInst, addr DlgName2, hWndProc, addr UserTemp, 0
            .if Asm                                                ; Return from UserTemplates 
               INVOKE     CheckRadioButton, hdlg, 501, 502, 502    ; Set no .dll
               INVOKE     CheckRadioButton, hdlg, 503, 504, 504    ; Set no .rc
               INVOKE     CheckRadioButton, hdlg, 511, 512, 512    ; Set no Folder, Pointer only
               .if Def
                  INVOKE     CheckRadioButton, hdlg, 501, 502, 501 ; Set .dll
               .endif
               .if Rsc
                  INVOKE     CheckRadioButton, hdlg, 503, 504, 503 ; Set .rc
               .endif
                  jmp     FinishIt
            .endif

         .elseif wParam == 902                                     ; Browse
            INVOKE     RtlZeroMemory, addr ofn, sizeof ofn
            INVOKE     lstrcpy, addr szBuff0, addr szEnd
               lea     eax, szBuff0
               mov     ofn.lStructSize, sizeof ofn
               mov     ofn.lpstrFilter, offset szALL
               mov     ofn.lpstrFile, eax
               mov     ofn.nMaxFile, lengthof szBuff0
               mov     ofn.Flags, OFN_NOVALIDATE
            INVOKE     GetOpenFileName, addr ofn
               cmp     eax, FALSE                                  ; Cancel'ed or error occurred
                je     Ret0
               xor     ebx, ebx
               mov     bx, ofn.nFileOffset
               inc     ebx
            INVOKE     lstrcpyn, addr szBuff0, ofn.lpstrFile, ebx
            INVOKE     SetDlgItemText, hdlg, 402, ofn.lpstrFile
               jmp     Ret0

         .elseif wParam == 901                                     ; Create
            .if hListBox
; User Template still open
                  jmp     Ret0
            .endif

FinishIt:
            INVOKE     lstrcpy, SavErr, addr szClr
            INVOKE     GetDlgItemText, hdlg, 401, addr szName, lengthof szName
            .if eax
               INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, SavReg, 0, addr szREGSZ, 0,\
                          KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp

                  mov     lpcbData, 250
               INVOKE     RegQueryValueEx, hReg, addr rDEFr, 0, addr lpType, addr szRoot, addr lpcbData
               .if eax == ERROR_SUCCESS

;---------- [Create a folder in the Projects Directory] ---------- 
                  INVOKE     GetDlgItemText, hdlg, 402, addr szBuff0, lengthof szBuff0
                  INVOKE     lstrcat, addr szBuff0, addr szName
                  INVOKE     CreateDirectory, addr szBuff0, NULL

                  .if !eax
                       call     GetLastError
                       push     eax
                     .if eax == 3                      ; Path does not exists
                        INVOKE     MessageBox, NULL, addr szError1, addr szRoot, MB_OK or MB_ICONSTOP or MB_SYSTEMMODAL
                           pop     eax
                           jmp     NoFile
                     .else
                        INVOKE     MessageBox, NULL, addr szError2, addr szName, MB_YESNO or MB_ICONWARNING or MB_TASKMODAL
                     .endif
                        pop     ebx
                     .if eax == IDNO
                           and     Asm, 0
                           jmp     NoFile
                     .elseif ebx == 183                ; File already exists
                        INVOKE     lstrcpy, addr szBuff1, addr szBuff0
                        INVOKE     lstrcat, addr szBuff1, addr szBackS
                        INVOKE     GetCurrentDirectory, lengthof szCurDir, addr szCurDir
                        INVOKE     SetCurrentDirectory, addr szBuff1
                        INVOKE     lstrcat, addr szBuff1, addr szEnd
                           lea     ebx, szBuff1
                        INVOKE     EmptyDir, ebx
                        INVOKE     SetCurrentDirectory, addr szCurDir
                     .endif
                  .endif

                  INVOKE     GetWindowRect, hdlg, addr rect
                     mov     eax, rect.right
                     sub     eax, rect.left
                     sub     rect.left, 100
                     add     rect.top, 40
; or WS_VISIBLE
                  INVOKE     CreateWindowEx, 0, addr Richedit, 0,
                             WS_POPUP or ES_MULTILINE,
                             rect.left, rect.top, 400, 300, hdlg, 0, hInst, 0
                     mov     hREdit, eax
                     mov     sw1, 1
                     and     Chk11, 0
                     and     ChkDLL, 0

                  INVOKE     IsDlgButtonChecked, hdlg, 511  ; Folder and Pointer only
                     mov     Chk11, eax
                  .if FolderSW
                        mov     Chk11, 1
                  .endif
                  INVOKE     lstrcpy, addr szWorkPgm, addr szPgm01

                  INVOKE     IsDlgButtonChecked, hdlg, 501
                  .if eax
                        mov     ChkDLL, eax
                     INVOKE     lstrcpy, addr szWorkPgm, addr szPgm05

                     INVOKE     IsDlgButtonChecked, hdlg, 503
                     .if eax
                        INVOKE     lstrcpy, addr szWorkPgm, addr szPgm06

                        INVOKE     IsDlgButtonChecked, hdlg, 508
                        .if eax
                           INVOKE     lstrcpy, addr szWorkPgm, addr szPgm08
                        .endif
                     .endif
                  .else

                     INVOKE     IsDlgButtonChecked, hdlg, 503
                     .if eax
                        INVOKE     lstrcpy, addr szWorkPgm, addr szPgm02

                        INVOKE     IsDlgButtonChecked, hdlg, 508
                        .if eax
                           INVOKE     lstrcpy, addr szWorkPgm, addr szPgm07
                        .endif
                     .endif

                     INVOKE     IsDlgButtonChecked, hdlg, 505
                     .if eax
                        INVOKE     lstrcpy, addr szWorkPgm, addr szPgm04

                        INVOKE     IsDlgButtonChecked, hdlg, 508
                        .if eax
                           INVOKE     lstrcpy, addr szWorkPgm, addr szPgm03
                        .endif
                     .endif

                     INVOKE     IsDlgButtonChecked, hdlg, 509
                     .if eax
                        INVOKE     lstrcpy, addr szWorkPgm, addr szPgm11
                     .endif
                  .endif
                  .if Asm
                     INVOKE     lstrcpy, addr szWorkPgm, addr szSavName
                  .endif

DoAgain:
                  INVOKE     lstrcpy, addr szBuff0, addr szRoot
                  INVOKE     lstrcat, addr szBuff0, addr szTemplates
                  .if sw1 == 1
                  INVOKE     lstrcpy, addr szBuff1, addr szName
                  INVOKE     lstrcat, addr szBuff1, addr szCol
                  INVOKE     GetDlgItemText, hdlg, 402, addr szCurDir, lengthof szCurDir
                  INVOKE     lstrcat, addr szBuff1, addr szCurDir
                  INVOKE     lstrcat, addr szBuff1, addr szName
                  INVOKE     lstrcat, addr szBuff1, addr szBackS
                     jmp     ByPass
                  .elseif sw1 == 2 && !Chk11              ; Chk11 = Pointer and Folder only
                     .if Asm
                        INVOKE     lstrcat, addr szBuff0, addr szUser
                     .endif
                     INVOKE     lstrcat, addr szBuff0, addr szWorkPgm
                     INVOKE     lstrcpy, addr szSavBuff, addr szBuff0
                     INVOKE     lstrcpy, addr szBuff1, addr szBuff0
                     INVOKE     lstrcat, addr szBuff1, addr szBackS
                     INVOKE     lstrcat, addr szBuff1, addr szEnd

;---------- [Find first file] ----------
GetFirstF:
                     INVOKE     FindFirstFile, addr szBuff1, addr FindData
                     .if eax == -1
                        INVOKE     MessageBox, NULL, addr szError3, addr szTemplates, MB_OK or MB_ICONWARNING or MB_SYSTEMMODAL
                           jmp     NoFile
                     .endif
                        mov     hFind, eax
                        jmp     ChkFile

;---------- [Find next file] ----------
GetNextF:
                     INVOKE     FindNextFile, hFind, addr FindData
                       test     eax, eax
                         jz     CloseIt

;---------- [Validate file] ----------
ChkFile:
                     .if byte ptr FindData.cFileName == '.'
                           jmp     GetNextF
                     .endif
                     INVOKE     lstrcpy, addr szBuff0, addr szSavBuff
                     INVOKE     lstrcat, addr szBuff0, addr szBackS
                     INVOKE     lstrcat, addr szBuff0, addr FindData.cFileName
                     .if (FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
                           jmp     AddDir
                     .endif
                     INVOKE     lstrlen, addr FindData.cFileName
                     .while (eax)
                           dec     eax
                        .if FindData.cFileName[eax] == '.'
                           .break
                        .endif
                     .endw
                     INVOKE     lstrcpy, addr szExt, addr FindData.cFileName[eax]

                  .else
                     .if Chk11                                  ; Pointer and Folder only
                        INVOKE     lstrcpy, SavErr, addr szErr  ; Set flag so assemble dialog is not called
                           jmp     CloseIt
                     .endif
                        jmp     Ret0
                  .endif
                     jmp     JmpMe

AddDir:
                  INVOKE     lstrcat, addr szBuff0, addr szBackS
                  INVOKE     SetCurrentDirectory, addr szBuff0
                  INVOKE     lstrcat, addr szBuff0, addr szEnd
   
                  INVOKE     GetDlgItemText, hdlg, 402, addr szBuff2, lengthof szBuff2
                  INVOKE     lstrcat, addr szBuff2, addr szName
                  INVOKE     lstrcat, addr szBuff2, addr szBackS
                  INVOKE     lstrcat, addr szBuff2, addr FindData.cFileName
                  INVOKE     lstrcat, addr szBuff2, addr szBackS
                  INVOKE     CreateDirectory, addr szBuff2, NULL
                  INVOKE     lstrlen, addr szBuff2
                     inc     eax
                     mov     szBuff2[eax], 0     ; Insert additional terminator


GetFirstSubF:
                  INVOKE     FindFirstFile, addr szBuff0, addr FindData
                    test     eax, eax
                      js     GetNextF
                     mov     hFindSub, eax
                     jmp     ChkFileSub

GetNextSubF:
                  INVOKE     FindNextFile, hFindSub, addr FindData
                  .if eax == 0
                     INVOKE     FindClose, hFindSub
                        jmp     GetNextF
                  .endif

ChkFileSub:
                  .if byte ptr FindData.cFileName == '.'
                        jmp     GetNextSubF
                  .endif
                  INVOKE     lstrlen, addr FindData.cFileName
                     inc     eax
                     mov     FindData.cFileName[eax], 0  ; Insert additional terminator
            
                     mov     ShFileOp.wFunc, FO_COPY
                     mov     ShFileOp.hwnd, 0            ; If 0, then no parent can task switch away
                     lea     eax, FindData.cFileName
                     mov     ShFileOp.pFrom, eax
                     lea     eax, szBuff2
                     mov     ShFileOp.pTo, eax
                     mov     ShFileOp.fFlags, FOF_SILENT or FOF_NOCONFIRMATION or FOF_NOCONFIRMMKDIR
                  INVOKE     SHFileOperation, addr ShFileOp
                     jmp     GetNextSubF

JmpMe:
;---------- [Read file for selecting text] ----------
                  INVOKE     CreateFile, addr szBuff0,\
                             GENERIC_READ or GENERIC_WRITE ,\
                             FILE_SHARE_READ or FILE_SHARE_WRITE,\
                             0, OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE, 0
                  .if eax == -1
                     INVOKE     MessageBox, NULL, addr szError3, addr ClassName, MB_OK or MB_ICONWARNING or MB_SYSTEMMODAL
                     INVOKE     lstrcpy, SavErr, addr szErr
                        jmp     Ret0
                  .endif
                     mov     hFile, eax
                  INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, 100000
                     mov     hpMem, eax
                  INVOKE     GlobalLock, hpMem
                     mov     fpMem, eax
                  INVOKE     ReadFile, hFile, fpMem, 100000, addr Bytesread, NULL
                  INVOKE     CloseHandle, hFile
                     mov     al, byte ptr szExt+1
                  .if al >= 'A' && al <= 'Z'
                        add     al, 20h
                        mov     byte ptr szExt+1, al
                  .endif

;---------- [Don't rename Bitmap's, Cursor's or Icon's and copy them from memory] ----------
                  .if al == 'b' || al == 'c' || al == 'i'
                        jmp     ByPass
                  .endif

                  INVOKE     SendMessage, hREdit, WM_SETTEXT, NULL, fpMem

                     mov     ft.chrg.cpMin, 0
                     mov     ft.chrg.cpMax, -1
                     lea     eax, offset szXXXX
                     mov     ft.lpstrText, eax

FindNext:
                  INVOKE     SendMessage, hREdit, EM_FINDTEXT, FR_DOWN, addr ft
                  .if eax != -1
                        mov     ft.chrg.cpMin, eax
                        inc     ft.chrg.cpMin
                        mov     cr.cpMin, eax
                        mov     cr.cpMax, eax
                        add     cr.cpMax, 4
                     INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
                     INVOKE     SendMessage, hREdit, EM_REPLACESEL, TRUE, addr szName
                        jmp     FindNext
                  .endif

ByPass:
                  INVOKE     lstrcpy, addr szBuff0, addr szRoot
                  .if sw1 == 1                      ; 1 = Batch
                     INVOKE     lstrcat, addr szBuff0, addr szPointer
                     INVOKE     lstrcat, addr szBuff0, addr szName
                     INVOKE     lstrcat, addr szBuff0, addr szPtr
                        jmp     Writem
                  .elseif sw1 == 2                  ; 2 = The rest
                     INVOKE     GetDlgItemText, hdlg, 402, addr szBuff0, lengthof szBuff0
                     INVOKE     lstrcat, addr szBuff0, addr szName
                     INVOKE     lstrcat, addr szBuff0, addr szBackS

;---------- [If Bitmap's, Cursor's or Icon's keep as is] ----------
                     .if byte ptr szExt+1 == 'b' || byte ptr szExt+1 == 'c' || byte ptr szExt+1 == 'i' || byte ptr szExt+1 == 'q'
                        INVOKE     lstrcat, addr szBuff0, addr FindData.cFileName
                        .if byte ptr szExt+1 == 'q' ; Call program for a Dll program
                           INVOKE     lstrlen, addr szBuff0
                              mov     ebx, eax
                           INVOKE     lstrcpyn, addr szBuff0[ebx-4], addr szBuff0[ebx-3], 4
                              jmp     GetText
                        .endif
                           jmp     Writem
                     .endif
                     INVOKE     lstrcat, addr szBuff0, addr szName
                     INVOKE     lstrcat, addr szBuff0, addr szExt
                  .else
                        jmp     Ret0
                  .endif

GetText:
                  INVOKE     SendMessage, hREdit, WM_GETTEXT, 100000, fpMem

;---------- [Write file] ----------
Writem:
                  INVOKE     CreateFile, addr szBuff0,\
                             GENERIC_READ or GENERIC_WRITE ,\
                             FILE_SHARE_READ or FILE_SHARE_WRITE,\
                             NULL, CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE, NULL
                  .if !eax
                     INVOKE     MessageBox, NULL, addr szError4, addr ClassName, MB_OK or MB_ICONWARNING or MB_SYSTEMMODAL
                     INVOKE     lstrcpy, SavErr, addr szErr
                        jmp     Ret0
                  .endif
                     mov     hFile, eax
                  INVOKE     SendMessage, hREdit, WM_GETTEXTLENGTH, 0, 0
                     mov     ebx, eax
                  .if byte ptr szExt+1 == 'b' || byte ptr szExt+1 == 'c' || byte ptr szExt+1 == 'i'
                        mov     ebx, Bytesread
                  .endif
                  .if sw1 == 1
                     INVOKE     lstrlen, addr szBuff1
                        mov     ebx, eax
                     INVOKE     WriteFile, hFile, addr szBuff1, ebx, addr Bytesread, NULL
                  .else
                     INVOKE     WriteFile, hFile, fpMem, ebx, addr Bytesread, NULL
                  .endif
                  INVOKE     CloseHandle, hFile
                  .if sw1 < 2
                     INVOKE     GlobalUnlock, fpMem
                     INVOKE     GlobalFree, hpMem
                        inc     sw1
                        jmp     DoAgain
                  .elseif sw1 == 2
                     .if byte ptr szExt+1 == 'a'
                        INVOKE     lstrcpy, SavPath, addr szBuff0
                     .endif
                        jmp     GetNextF 
                  .endif
               .endif                      ; = ERROR_SUCCESS

            .else                          ; No project name entered
               INVOKE     MessageBox, NULL, addr szError5, addr ClassName, MB_OK or MB_ICONWARNING or MB_SYSTEMMODAL
               INVOKE     lstrcpy, SavErr, addr szErr
                  jmp     Ret0
            .endif

NoFile:
            INVOKE     lstrcpy, SavErr, addr szErr
               jmp     Ret0

CloseIt:
            .if ChkDLL                     ; Program is a DLL Prepare the call program
               INVOKE     GetDlgItemText, hdlg, 402, addr szBuff0, lengthof szBuff0
               INVOKE     lstrcat, addr szBuff0, addr szName
               INVOKE     lstrcat, addr szBuff0, addr szBackS
               INVOKE     lstrcpy, addr szBuff1, addr szBuff0
               INVOKE     lstrcat, addr szBuff0, addr szCallDLLb
               INVOKE     WinExec, addr szBuff0, SW_HIDE  ; Exec a .bat program
               .if eax < 32
                     ;Do error
               .endif
            .endif
            INVOKE     FindClose, hFind
               jmp     GetOut
         .endif

      .elseif wMsg == WM_CLOSE
         INVOKE     lstrcpy, SavErr, addr szErr

GetOut:
         INVOKE     RegCloseKey, hReg
         .if fpMem 
            INVOKE     GlobalUnlock, fpMem
            INVOKE     GlobalFree, hpMem
         .endif
;         .if hUserTemp
;            INVOKE     EndDialog, hUserTemp, 0
;         .endif
         INVOKE     DeleteObject, hBR
         INVOKE     EndDialog, hdlg, 0
            mov     eax, TRUE
            ret
      .endif

Ret0:
         xor     eax, eax
         ret

WndProc endp

;_______________________________________________________________________
EmptyDir proc  uses ebx  InPut:DWORD
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    ShFileOp:SHFILEOPSTRUCT
LOCAL    hFind:DWORD

;---------- [Find First File] ----------
      INVOKE     FindFirstFile, InPut, addr FindData
        test     eax, eax
          js     Ret0
         mov     hFind, eax
         jmp     ChkFile

;---------- [Find Next File] ----------
GetNextF:
      INVOKE     FindNextFile, hFind, addr FindData
        test     eax, eax
          jz     CloseIt

;---------- [Validate File] ----------
ChkFile:
      .if byte ptr FindData.cFileName == '.'
            jmp     GetNextF
      .endif

;---------- [Delete File] ----------
      INVOKE     lstrlen, addr FindData.cFileName
         inc     eax
         mov     FindData.cFileName[eax], 0  ; Insert additional terminator
         mov     ShFileOp.wFunc, FO_DELETE
         mov     ShFileOp.hwnd, 0            ; If 0, then no parent can task switch away
         lea     eax, FindData.cFileName
         mov     ShFileOp.pFrom, eax
         mov     ShFileOp.fFlags, FOF_SILENT or FOF_NOCONFIRMATION or FOF_NOCONFIRMMKDIR
      INVOKE     SHFileOperation, addr ShFileOp
         jmp     GetNextF

CloseIt:
      INVOKE     FindClose, hFind

Ret0:
         xor     eax, eax
         ret

EmptyDir endp

;____________________________________________________________________
UserTemp proc  uses ebx  hdlg:DWORD, wMsg, wParam, lParam
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    hReg:DWORD, hFind, hFindS, ChkType
LOCAL    szName[50]:BYTE, szRoot[256], szBuff0[256], szBuff1[256], szBuff2[256], szWork[50]

      .if wMsg == WM_INITDIALOG
;          MOVmd     hUserTemp, hdlg
         INVOKE     LoadIcon, 0, IDI_APPLICATION
         INVOKE     SendMessage, hdlg, WM_SETICON, 1, eax

      INVOKE     GetDlgItem, hdlg, 901            ; Get the handle of the Browse
         mov     hReturn, eax                     ; Save it
      INVOKE     SetWindowLong, hReturn, GWL_WNDPROC, ControlButt
         mov     SubControl, eax
      INVOKE     GetDlgItem, hdlg, IDCANCEL       ; Get the handle of the IDCANCEL
         mov     hCancel, eax                    ; Save it
      INVOKE     SetWindowLong, hCancel, GWL_WNDPROC, ControlButt
         mov     SubControl, eax

         INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr listbox, 0,
                    WS_CHILD or WS_VSCROLL or WS_VISIBLE or LBS_HASSTRINGS or LBS_NOINTEGRALHEIGHT or \
                    LBS_DISABLENOSCROLL or LBS_SORT,
                    12, 11, 150, 100, hdlg, 315, 0, 0
            mov     hListBox, eax

         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, SavReg, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
            mov     lpcbData, 250
         INVOKE     RegQueryValueEx, hReg, addr rDEFr, 0, addr lpType, addr szRoot, addr lpcbData
         .if eax == ERROR_SUCCESS
            INVOKE     RegCloseKey, hReg
            INVOKE     lstrcpy, addr szBuff0, addr szRoot
            INVOKE     lstrcat, addr szBuff0, addr szTemplates
            INVOKE     lstrcat, addr szBuff0, addr szUser
            INVOKE     lstrcpy, addr szBuff1, addr szBuff0
            INVOKE     lstrcpy, SavBuff, addr szBuff0
            INVOKE     lstrcat, addr szBuff0, addr szEnd
               and     ChkType, 0

GetFirstF:
            INVOKE     FindFirstFile, addr szBuff0, addr FindData
              test     eax, eax
                js     NoFile
               mov     hFind, eax
               jmp     ChkFile

GetNextF:
            INVOKE     FindNextFile, hFind, addr FindData
              test     eax, eax
                jz     AllDone

;---------- [Validate File] ----------
ChkFile:
            .if byte ptr FindData.cFileName == '.'
                  jmp     GetNextF
            .endif

            .if ChkType
               INVOKE     lstrlen, addr FindData.cFileName
                  mov     bl, byte ptr FindData.cFileName[eax-3]
               .if bl == '.'
                     mov     bl, byte ptr FindData.cFileName[eax-2]
               .endif
               .if bl >= 'A' && bl <= 'Z'
                     add     bl, 20h
               .endif
               .if bl == 'a'
                     mov     Asm, 1
               .elseif bl == 'd'
                     mov     Def, 1
               .elseif bl == 'r'
                     mov     Rsc, 1
               .endif
                  jmp     GetNextF
            .endif

            INVOKE     lstrcpy, addr szName, addr FindData.cFileName

;---------- [Check for types of files in the user folder] ----------
            INVOKE     lstrcpy, addr szBuff2, addr szBuff1
            INVOKE     lstrcat, addr szBuff2, addr FindData.cFileName
            INVOKE     lstrcat, addr szBuff2, addr szBackS
            INVOKE     lstrcat, addr szBuff2, addr szEnd

GetFirstSub:
            INVOKE     FindFirstFile, addr szBuff2, addr FindData
              test     eax, eax
                js     GetNextF
               mov     hFindS, eax
               jmp     ChkSub

GetNextSub:
            INVOKE     FindNextFile, hFindS, addr FindData
            .if eax == 0
               INVOKE     FindClose, hFindS
                  jmp     GetNextF
            .endif

ChkSub:
            .if byte ptr FindData.cFileName == '.'
                  jmp     GetNextSub
            .endif
            INVOKE     lstrlen, addr FindData.cFileName
               mov     bl, byte ptr FindData.cFileName[eax-3]
            .if bl == 'a' || bl == 'A'
               INVOKE     FindClose, hFindS
               INVOKE     SendMessage, hListBox, LB_ADDSTRING, 0, addr szName ;FindData.cFileName
                  jmp     GetNextF
            .else
                  jmp     GetNextSub
            .endif

AllDone:
            INVOKE     FindClose, hFind
            .if ChkType
                  jmp     GetOut
            .endif
         .endif

NoFile:
            jmp     Ret0
      .endif

      .if wMsg == WM_CTLCOLORDLG || wMsg == WM_CTLCOLORSTATIC
;         INVOKE     GetStockObject, WHITE_BRUSH     ; Select the white brush for the background

         INVOKE     SetBkColor, wParam, 00ffffe0h
         INVOKE     SetTextColor, wParam, 00000000h
         .if hBR
            INVOKE     DeleteObject, hBR
         .endif
         INVOKE     CreateSolidBrush, 00ffffe0h
            mov     hBR, eax
            ret
      .endif

      .if wMsg == WM_CTLCOLORLISTBOX || wMsg == WM_CTLCOLOREDIT
         INVOKE     SetBkColor, wParam, 00000000h   ; Background color is black
         INVOKE     SetTextColor, wParam, 00ffff00h ; Text color of edit box is lt blue
         INVOKE     GetStockObject, BLACK_BRUSH     ; Select the black brush for background
            ret
      .endif

      .if wMsg == WM_COMMAND
         .if wParam == IDCANCEL
               and     Asm, 0
               jmp     GetOut
         .elseif wParam == 901     ; Return
            INVOKE     SendMessage, hListBox, LB_GETCURSEL, 0, 0
            .if eax == -1
               INVOKE     MessageBox, NULL, addr szError6, addr ClassName, MB_OK or MB_ICONWARNING or MB_SYSTEMMODAL
                  jmp     Ret0
            .else
                  mov     ebx, eax
               INVOKE     SendMessage, hListBox, LB_GETTEXT, ebx, addr szSavName
                  mov     ChkType, 1
               INVOKE     lstrcat, SavBuff, addr szSavName
               INVOKE     lstrcat, SavBuff, addr szBackS
               INVOKE     lstrcat, SavBuff, addr szEnd
               INVOKE     lstrcpy, addr szBuff0, SavBuff
                  jmp     GetFirstF
            .endif
         .endif

      .elseif wMsg == WM_CLOSE
            and     Asm, 0

GetOut:
            and     hListBox, 0
;            and     hUserTemp, 0
         INVOKE     EndDialog, hdlg, 0
            mov     eax, TRUE
            ret
      .endif

Ret0:
         xor     eax, eax
         ret

UserTemp endp

;________________________________________________________________________________
DelProj  PROC  uses ebx esi edi  hwnd:DWORD, hAsm, szReg, PNane, w1
LOCAL    FindData:WIN32_FIND_DATA
LOCAL    ShFileOp:SHFILEOPSTRUCT
LOCAL    hReg:DWORD, hFind, hFile, Bytesread, SPos1, sw
LOCAL    szRoot[256]:BYTE, szBuff0[256], szBuff1[256], szBuff2[256], szCurDir[256], Misc[40]

       MOVmd     hWnd, hwnd
       MOVmd     hAsmbox, hAsm
       MOVmd     SavReg, szReg
       MOVmd     szNameP, PNane

      INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, SavReg, 0, addr szREGSZ, 0,\
                 KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp

         mov     lpcbData, 250
      INVOKE     RegQueryValueEx, hReg, addr rDEFr, 0, addr lpType, addr szRoot, addr lpcbData
      .if eax == ERROR_SUCCESS
         INVOKE     lstrcpy, addr szBuff0, addr szRoot
         INVOKE     lstrcat, addr szBuff0, addr szPointer
         INVOKE     lstrcat, addr szBuff0, szNameP
         INVOKE     lstrcat, addr szBuff0, addr szPtr

         INVOKE     lstrcpy, addr szBuff1, addr szRoot
         INVOKE     lstrcat, addr szBuff1, addr szProjects
         INVOKE     lstrcat, addr szBuff1, szNameP
         INVOKE     lstrcat, addr szBuff1, addr szBackS
         INVOKE     GetCurrentDirectory, lengthof szCurDir, addr szCurDir
         INVOKE     SetCurrentDirectory, addr szBuff1
         INVOKE     lstrcat, addr szBuff1, addr szEnd

;---------- [Read file for extracting text] ----------
         INVOKE     CreateFile, addr szBuff0,\
                    GENERIC_READ or GENERIC_WRITE ,\
                    FILE_SHARE_READ or FILE_SHARE_WRITE,\
                    0, OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE, 0
         .if eax == -1
               jmp     DelDone
         .endif
            mov     hFile, eax
         INVOKE     GlobalAlloc, GMEM_MOVEABLE or GMEM_ZEROINIT, 100000
            mov     hpMem, eax
         INVOKE     GlobalLock, hpMem
            mov     fpMem, eax
         INVOKE     ReadFile, hFile, fpMem, 100000, addr Bytesread, NULL
         INVOKE     CloseHandle, hFile

            mov     al, 3ah               ; Colon
            mov     ecx, Bytesread        ; Bytes left to analyze
            mov     edi, fpMem            ; Start address in input buffer
            mov     SPos1, edi
            cld                           ; Increment edi
            repnz   scasb                 ; Repeat until byte = al(3ah)
            mov     eax, edi
            sub     eax, fpMem
           push     eax
         INVOKE     lstrcpyn, addr Misc, SPos1, eax
            pop     eax
            inc     eax
            add     SPos1, eax
            mov     ecx, eax
            mov     eax, Bytesread
            sub     eax, ecx
            inc     eax

            mov     ecx, 20
            mov     ebx, SPos1
         .while (ecx)
            .if byte ptr [ebx+eax] == '\'
               .break
            .endif
               dec     eax
               dec     ecx
         .endw
            add     eax, 2

;---------- [Check for a drive letter] ----------
            mov     ebx, SPos1
         .if byte ptr [ebx+1] != ':'
              push     eax
            INVOKE     lstrcpyn, addr szBuff2, addr szRoot, 3
               pop     eax
            INVOKE     lstrcpyn, addr szBuff2+2, SPos1, eax
         .else
            INVOKE     lstrcpyn, addr szBuff2, SPos1, eax
         .endif

         INVOKE     RegCloseKey, hReg
         INVOKE     GlobalUnlock, fpMem
         INVOKE     GlobalFree, hpMem
      .else
; Do message
            jmp     DelDone
      .endif


      INVOKE     MessageBox, NULL, addr szError7, addr pTitle, MB_YESNO or MB_ICONQUESTION
      .if eax == IDNO
            jmp     DelDone
      .endif

;---------- [Find First File in the Project Folder] ----------
      INVOKE     FindFirstFile, addr szBuff1, addr FindData
      .if eax == -1
         INVOKE     MessageBox, NULL, addr szError8, addr pTitle, MB_YESNO or MB_ICONWARNING
         .if eax == IDNO
               jmp     SetCurr
         .endif
            INVOKE     SetCurrentDirectory, addr szCurDir
            INVOKE     GetCurrentDirectory, lengthof szCurDir, addr szCurDir
            INVOKE     lstrcpy, addr szBuff1, addr szBuff2
            INVOKE     SetCurrentDirectory, addr szBuff1
            INVOKE     lstrcat, addr szBuff1, addr szEnd

;---------- [Find First File in a non-Project Folder] ----------
            INVOKE     FindFirstFile, addr szBuff1, addr FindData
            .if eax == -1
; Do message
                  jmp     CloseIt ;SetCurr
            .endif
      .endif
         mov     hFind, eax
         jmp     ChkFile

;---------- [Find Next File] ----------
GetNext:
      INVOKE     FindNextFile, hFind, addr FindData
        test     eax, eax
          jz     CloseIt

;---------- [Validate File] ----------
ChkFile:
      .if byte ptr FindData.cFileName == '.'
            jmp     GetNext
      .endif

;---------- [Delete File(s)] ----------
      INVOKE     lstrcpy, addr szBuff1, addr szBuff2
      INVOKE     lstrcat, addr szBuff1, addr FindData.cFileName
      INVOKE     lstrlen, addr szBuff1
         inc     eax
         mov     szBuff1[eax], 0             ; Insert additional terminator
         mov     ShFileOp.wFunc, FO_DELETE
         mov     ShFileOp.hwnd, 0            ; If 0, then no parent can task switch away
         lea     eax, szBuff1
         mov     ShFileOp.pFrom, eax
         mov     ShFileOp.pTo, 0
         mov     ShFileOp.fFlags, FOF_SILENT or FOF_NOCONFIRMATION or FOF_NOCONFIRMMKDIR
      INVOKE     SHFileOperation, addr ShFileOp
      .if eax != 0
         INVOKE     MessageBox, NULL, addr szError9, addr pTitle, MB_YESNO or MB_ICONWARNING
         INVOKE     FindClose, hFind
            jmp     SetCurr
      .endif
         jmp     GetNext

CloseIt:
      INVOKE     FindClose, hFind
         and     sw, 0


;---------- [Delete the Folder] ----------
      INVOKE     lstrcpy, addr szBuff1, addr szBuff2
      INVOKE     lstrlen, addr szBuff1
      INVOKE     lstrcpyn, addr szBuff1, addr szBuff1, eax

LoopDel:
      INVOKE     lstrlen, addr szBuff1
         inc     eax
         mov     szBuff1[eax], 0             ; Insert additional terminator
         mov     ShFileOp.wFunc, FO_DELETE
         mov     ShFileOp.hwnd, 0            ; If 0, then no parent can task switch away
         lea     eax, szBuff1
         mov     ShFileOp.pFrom, eax
         mov     ShFileOp.pTo, 0
         mov     ShFileOp.fFlags, FOF_SILENT or FOF_NOCONFIRMATION or FOF_NOCONFIRMMKDIR
      INVOKE     SHFileOperation, addr ShFileOp
      .if eax != 0
         INVOKE     MessageBox, NULL, addr szError10, addr pTitle, MB_YESNO or MB_ICONWARNING
            jmp     SetCurr
      .endif

      .if !sw
         inc     sw
      INVOKE     lstrcpy, addr szBuff1, addr szBuff0
         jmp     LoopDel                     ; Delete the pointer file
      .endif
      INVOKE     SendMessage, hAsmbox, LB_DELETESTRING, w1, 0

SetCurr:
      INVOKE     SetCurrentDirectory, addr szCurDir

DelDone:
         mov     eax, FALSE

         ret
DelProj  Endp

;=================================================
; Subclass procedure for the Control Buttons
;=================================================
ControlButt  PROC  hwnd:DWORD, wMsg, wParam, lParam
LOCAL     UpDown:DWORD

      INVOKE     CallWindowProc, SubControl, hwnd, wMsg, wParam, lParam

         mov     UpDown , 1
      .if wMsg == WM_PAINT
PaintEM:
            mov     eax, hwnd
         .if eax == hCancel
            INVOKE     ButtonType, eax, hFontB, 000000ffh, 00000000h, addr szCancel, UpDown
         .elseif eax == hCreate
            INVOKE     ButtonType, eax, hFontB, 00000000h, 00ffff00h, addr szCreate, UpDown
         .elseif eax == hBrowse
            INVOKE     ButtonType, eax, hFontB, 0095caffh, 00004000h, addr szBrowse, UpDown
         .elseif eax == hReturn
            INVOKE     ButtonType, eax, hFontB, 00c1ffc1h, 00006000h, addr szReturn, UpDown
         .elseif eax == hUser
            INVOKE     ButtonType, eax, hFontB, 00c1ffc1h, 00006000h, addr szUserDef, UpDown
         .endif
            mov     UpDown, 1

      .elseif wMsg == WM_LBUTTONDOWN || wMsg == WM_LBUTTONDBLCLK
            mov     UpDown, 2
            jmp     PaintEM

      .elseif wMsg == WM_MOUSEMOVE || wMsg == WM_NCMOUSEMOVE
         .if wParam == MK_LBUTTON
               mov     UpDown, 2
         .else
               mov     UpDown, 1
         .endif
            jmp     PaintEM

      .elseif wMsg == WM_LBUTTONUP
            mov     UpDown, 1
            jmp     PaintEM
      .endif

Ret1:
         mov     eax, TRUE
         ret
ControlButt  ENDP

;=============================================================================
; Creates various appearances of Buttons
;=============================================================================
ButtonType  PROC hButt:DWORD, hFont, BackC, TextC, szText, Bor
LOCAL     rect:RECT
LOCAL     hOldFont:DWORD, hDC

      INVOKE     GetDC, hButt
         mov     hDC, eax
      .if Bor == 2
            mov     BackC, 00929292h
      .endif
      INVOKE     CreateSolidBrush, BackC
         mov     hBR, eax
      INVOKE     GetClientRect, hButt, addr rect
      INVOKE     FillRect, hDC, addr rect, hBR
      INVOKE     DeleteObject, hBR            ; Delete the brush handle
         mov     eax, hButt
      .if Bor == 1 ;&& eax == hButt3
         INVOKE     DrawEdge, hDC, addr rect, BDR_RAISEDOUTER, BF_TOPLEFT
         INVOKE     DrawEdge, hDC, addr rect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT
      .elseif Bor == 2
         INVOKE     DrawEdge, hDC, addr rect, EDGE_SUNKEN, BF_RECT
      .endif
      INVOKE     SelectObject, hDC, hFont     ; Select the font into the dc
         mov     hOldFont, eax
      INVOKE     SetTextColor, hDC, TextC     ; Set the text color
      INVOKE     SetBkMode, hDC, TRANSPARENT  ; Set the text background to transparent
      INVOKE     DrawText, hDC, szText, -1, addr rect, DT_CENTER or DT_VCENTER or DT_SINGLELINE
      INVOKE     SelectObject, hDC, hOldFont
      INVOKE     ReleaseDC, hButt, hDC        ; Release the control dc

         xor    eax, eax
         ret
ButtonType  ENDP

End DllEntry

;INVOKE     MessageBox, NULL, addr szBuff1, addr ClassName, MB_OK
