            .586
            .model   flat, STDCALL
            include  \MASM32V1\include\Windows.inc
            include  \MASM32V1\include\USER32.inc
            include  \MASM32V1\include\KERNEL32.inc
            option   casemap: none

MOVmd       MACRO Var1, Var2
                 push     Var2
                  pop     Var1
            ENDM

.data
DLLName         db  'DSPVALUE.DLL',0
ValName         db  'Display Base Values',0
RegName         db  'Display 32 Bit Registers',0
BackUp          db  11 dup(' ')
                db  0Dh,0Ah
                db  'Hex.  '
                db  9 dup('0')
                db  '  Actual Value '
                db  9 dup(' ')
                db  0Dh,0Ah
                db  'Bin.   '
                db  32 dup(' '), 0

Display         db  'Dec.  '
mDEC            db  11 dup(' ')
                db  0Dh,0Ah
                db  'Hex.  '
mHEX            db  9 dup('0')
Lit             db  '  Actual Value '
mHEXa           db  9 dup(' ')
                db  0Dh,0Ah
                db  'Bin.   '
mBIN            db  32 dup(' '), 0

mREGS           db  '           -- Hex. --       -- Dec. --'
                db  0Dh,0Ah
mEAX            db  'EAX = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mEBX            db  'EBX = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mECX            db  'ECX = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mEDX            db  'EDX = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mESI            db  'ESI  = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mEDI            db  'EDI  = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mEBP            db  'EBP = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mESP            db  'ESP = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
mFLG            db  'FLG  = '
                db  9 dup('0')
                db  13 dup(' ')
                db  0Dh,0Ah
                db  'EFLAG Bin. =   '
mFLGB           db  32 dup(' '), 0
RegArray        dd  9 dup(0)
hInst           dd  0

.code
DllEntry PROC hinstDLL:DWORD, reason:DWORD, reserved1:DWORD
      INVOKE     GetModuleHandle, addr DLLName   
         mov     hInst, eax            ; hInstance is same as HMODULE
      .if reason == DLL_PROCESS_ATTACH
            mov     eax, TRUE
      .endif
         RET
DllEntry ENDP

;================================================================
BaseAscii PROC hWnd: DWORD, Value: DWORD, Sign: DWORD, Loc: DWORD
LOCAL    LBuff[32]: BYTE, Buff[32]: BYTE
LOCAL    Base: DWORD, cnt: DWORD, sgn: DWORD, save: DWORD

      INVOKE     lstrcpy, ADDR mDEC, ADDR BackUp
         mov     sgn, 0
         mov     eax, Value
         mov     save, eax
         and     eax, 0f0000000h
      .if eax > 70000000h && Sign == 1
            not     Value
            add     Value, 1
            mov     sgn, 1
      .endif
      .if sgn == 0
            mov     ecx, 14
            mov     edi, offset Lit
         .while (ecx)
               mov     byte ptr[edi], 20h
               inc     edi
               dec     ecx
         .endw
      .endif
         mov     cnt, 0
         mov     Base, 10
         mov     edi, offset mDEC
Again:
         xor     esi, esi
         mov     eax, Value           ; Input
      .while (eax)
            xor     edx, edx
            div     Base              ; Base 10, 16, 8, 2
         .if dl > 9h
               add     dl, 37h        ; Convert to hex ASCII
         .else
               add     dl, 30h        ; Convert to dec ASCII
         .endif
            mov     LBuff[esi], dl
            inc     esi
      .endw
         mov     ecx, esi
      .if sgn == 1
            mov     byte ptr[edi], 2dh
            inc     edi
      .endif
      .if cnt == 1
            add     edi, 8
            sub     edi, ecx
      .endif
         inc     ecx
      .if ecx == 1 && Base == 10
            mov     LBuff[esi-1], 30h
            inc     ecx
            inc     edi
      .endif
      .while (ecx)
            mov     al, byte ptr LBuff[esi-1]
            mov     byte ptr[edi], al
            inc     edi
            dec     esi
            dec     ecx
      .endw
            mov     byte ptr[edi-1], 20h
            add     cnt, 1
      .if cnt == 1
            mov     edi, offset mHEX
            mov     Base, 16
            jmp     Again
      .elseif cnt == 2
            mov     edi, offset mBIN
            mov     Base, 2
            jmp     Again
      .elseif cnt == 3
            mov     byte ptr[edi-1], 0h
      .endif
      .if cnt == 3 && sgn == 1
            and     sgn, 0
            mov     eax, save
            mov     Value, eax
            mov     edi, offset mHEXa
            mov     Base, 16
            jmp     Again
      .endif
      .if Loc == 'M' || Loc == 'm'
         INVOKE     MessageBox, NULL, ADDR Display, ADDR ValName, MB_OK or MB_ICONINFORMATION or MB_SYSTEMMODAL
      .elseif Loc == 'T' || Loc == 't'
            mov     word ptr[mDEC+11], 2020h
            mov     mHEXa+9, 0
         INVOKE     SetWindowText, hWnd, ADDR Display
      .elseif Loc == 'S' || Loc == 's'
            mov     word ptr[mDEC+11], 2020h
            mov     mHEXa+9, 0
         INVOKE     SendMessage, hWnd, SB_SETTEXT, 0, ADDR Display
      .endif
      INVOKE     lstrcpy, ADDR mDEC, ADDR BackUp
          RET
BaseAscii ENDP

;================================================================
ShowRegs  PROC hWnd:DWORD, Reax:DWORD, Rebx:DWORD, Recx:DWORD, Redx:DWORD, Resi:DWORD, Redi:DWORD, Rebp:DWORD, Resp:DWORD, Rflg:DWORD
LOCAL    LBuff[32]: BYTE, Buff[32]: BYTE
LOCAL    Base: DWORD, cnt: DWORD, sw1: DWORD, sgn: DWORD, save: DWORD

       MOVmd     RegArray, Reax
       MOVmd     RegArray+4, Rebx
       MOVmd     RegArray+8, Recx
       MOVmd     RegArray+12, Redx
       MOVmd     RegArray+16, Resi
       MOVmd     RegArray+20, Redi
       MOVmd     RegArray+24, Rebp
       MOVmd     RegArray+28, Resp
       MOVmd     RegArray+32, Rflg
         xor     ebx, ebx
         mov     cnt, 0
         mov     sw1, 1
         mov     Base, 16
         mov     edi, offset mEAX+6
         mov     save, edi
         mov     eax, RegArray[ebx]   ; Input
Again:
         xor     esi, esi
      .while (eax)
            xor     edx, edx
            div     Base              ; Base 10, 16, 8, 2
         .if dl > 9h
               add     dl, 37h        ; Convert to hex ASCII
         .else
               add     dl, 30h        ; Convert to dec ASCII
         .endif
            mov     LBuff[esi], dl
            inc     esi
      .endw
         mov     ecx, esi
      .if sw1 == 1
            add     edi, 8
            sub     edi, ecx
            and     sw1, 0
      .else
            add     ebx, 4
      .endif
         inc     ecx
      .if ecx == 1 && Base == 10
            mov     LBuff[esi-1], 30h
            inc     ecx
            inc     edi
      .endif
      .while (ecx)
            mov     al, byte ptr LBuff[esi-1]
            mov     byte ptr[edi], al
            inc     edi
            dec     esi
            dec     ecx
      .endw
            mov     byte ptr[edi-1], 20h
            mov     eax, RegArray[ebx]           ; Input
            add     cnt, 1
      .if Base == 10
            or      sw1, 1
            add     save, 18
            mov     Base, 16
      .else
            add     save, 12
            mov     Base, 10
      .endif
      .if cnt == 8 || cnt == 10 || cnt == 16
            add     save, 1
      .endif 
      .if cnt < 18
            mov     edi, save
            jmp     Again
      .elseif cnt == 18
            mov     eax, Rflg
            mov     edi, offset mFLGB
            mov     Base, 2
            jmp     Again   
      .endif
         mov     byte ptr[edi], 0h
      INVOKE     MessageBox, NULL, ADDR mREGS, ADDR RegName, MB_OK or MB_ICONINFORMATION or MB_SYSTEMMODAL
          RET
ShowRegs  ENDP

End DllEntry
