         title   Work Area
         .586
         .model flat, stdcall
            option   casemap: none
            include  \MASM32V1\include\windows.inc
            include  \MASM32V1\include\user32.inc
            include  \MASM32V1\include\kernel32.inc
            include  \MASM32V1\include\gdi32.inc
            include  \MASM32V1\include\advapi32.inc

     include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\LIB\user32.LIB
         includelib  \MASM32V1\LIB\kernel32.LIB
         includelib  \MASM32V1\lib\gdi32.LIB
         includelib  \MASM32V1\lib\advapi32.LIB

RichEditProc     PROTO :DWORD, :DWORD, :DWORD, :DWORD

.data
ClassName   db  'WorkArea',0
AppName     db  'Work Area',0
Richedit    db  'RichEdit20A',0
RichEdDLL   db  'RICHED20.DLL',0
PopupMenu   db  'PopupMenu',0

szComm      db  'EW_Common',0
szKey       db  'Comm Key',0
;szRedit     db  'AsmEdit V3',0
;szRedit     db  'AsmEdit3 V3',0
;szRedit     db  'RICH EDIT V3',0
szREGSZ     db  'REG_SZ',0
szHandle    db  'hWorkA',0
szEdit      db  'Edit',0

szFont      db  'Font',0
szPoint     db  'Point',0
szEffects   db  'Effects',0
szMask      db  'Mask',0
szFontH     db  'FontH',0
szFontW     db  'FontW',0
rTC         db  '[Color Text.]',0
rTBGC       db  '[Color TxBG.]',0
rBC         db  '[Color BackG]',0

szBuff      db  20 dup(?)

hInst       dd  0
hREdDll     dd  0
MainExit    dd  0
hWork       dd  0
SavEdit     dd  0
SavReg      dd  0
hWnd        dd  0
hREdit      dd  0
hSMenu      dd  0
lpRichEdit  dd  0
PointSize   dd  0
ExitCode    dd  0
First       dd  1

hParEdit    dd  0

lpType      dd  0
lpcbData    dd  0
lpdwDisp    dd  0

.code

;________________________________________________________________________________
DllEntry PROC hInstance:DWORD, reason:DWORD, reserved1:DWORD
      .if reason == DLL_PROCESS_ATTACH  ; When the dll is loaded
           push     hInstance
            pop     hInst
            mov     eax, TRUE
      .endif
         ret
DllEntry ENDP

;________________________________________________________________________________
WorkArea PROC   hwnd:DWORD

           push     hwnd
            pop     hWork

      INVOKE     LoadLibrary, addr RichEdDLL ; Load the Riched20.dll
         mov     hREdDll, eax
      .if !eax
;         INVOKE     MessageBox, NULL, addr szError1, addr AppName, MB_OK or MB_ICONERROR
            jmp     NoGo
      .endif

        call     WinMain
         mov     MainExit, eax
      INVOKE     FreeLibrary, hREdDll

NoGo:
      INVOKE     ExitProcess, MainExit
         ret
WorkArea Endp

;________________________________________________________________________________
CloseIt PROC   ExitC:DWORD

        push     ExitC
         pop     ExitCode
      INVOKE     SendMessage, hWnd, WM_CLOSE, 0, 0
         ret
CloseIt Endp

;________________________________________________________________________________
WinMain proc  uses ebx
LOCAL    rect:RECT
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG
LOCAL    hwnd:HWND

         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
        push     hInst
         pop     wc.hInstance
         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.lpszMenuName, 0
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon, 0, IDI_APPLICATION
         mov     wc.hIcon, eax
         mov     wc.hIconSm, 0
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

      INVOKE     LoadMenu, hInst, addr PopupMenu   
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenu, eax

;---------- [Center the window] ----------
      INVOKE     GetSystemMetrics, SM_CXSCREEN
         sub     eax, 400
         shr     eax, 1
        push     eax
      INVOKE     GetSystemMetrics, SM_CYSCREEN
         sub     eax, 150
         shr     eax, 1
         pop     ebx

;---------- [Main window] ----------
      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr ClassName,\
                 addr AppName, WS_POPUP or WS_CAPTION or WS_THICKFRAME,\
                 ebx, eax, 400, 150, hWork, NULL, hInst, NULL
         mov     hWnd, eax

      INVOKE     UpdateWindow, hWnd
      INVOKE     SetWindowPos, hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW
      INVOKE     SetFocus, hWork

      .while TRUE
         INVOKE     GetMessage, addr msg, 0, 0, 0
         .break .if (!eax)
         INVOKE     TranslateMessage, addr msg
         INVOKE     DispatchMessage, addr msg
      .endw
         mov     eax, msg.wParam
         ret
WinMain endp

;________________________________________________________________________________
WndProc proc  uses ebx  hwnd:DWORD, wmsg:DWORD, wParam:DWORD, lParam:DWORD
LOCAL    rect:RECT
LOCAL    tm:TEXTMETRIC
LOCAL    charF:CHARFORMAT2
LOCAL    lf:LOGFONT
LOCAL    hReg:DWORD, hEDC, hFont, BackC, FontH, FontW
;LOCAL    szBuff[20]:BYTE

      .if wmsg == WM_CREATE
         INVOKE     CreateWindowEx, NULL, addr Richedit, NULL,\
                    WS_CHILD or WS_VISIBLE or ES_MULTILINE or ES_SAVESEL or ES_NOHIDESEL or\
                    ES_AUTOHSCROLL or ES_AUTOVSCROLL or WS_HSCROLL or WS_VSCROLL,\
                    0, 0, 0, 0, hwnd, 44, hInst, NULL
            mov     hREdit, eax

         INVOKE     SetWindowLong, hREdit, GWL_WNDPROC, RichEditProc
            mov     lpRichEdit, eax
         INVOKE     SendMessage, hREdit, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
         INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 100000

            mov     charF.cbSize, sizeof charF

;---------- [The below is used to match the work window font with AsmEdit] ----------
         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szComm, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp
            mov     lpcbData, 20
         INVOKE     RegQueryValueEx, hReg, addr szKey, 0, addr lpType, addr szBuff, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szEdit, 0, addr lpType, addr hParEdit, addr lpcbData
         INVOKE     RegCloseKey, hReg

         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szBuff, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp

            mov     lpcbData, 50
         INVOKE     RegQueryValueEx, hReg, addr szFont, 0, addr lpType, addr charF.szFaceName, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szPoint, 0, addr lpType, addr charF.yHeight, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szMask, 0, addr lpType, addr charF.dwMask, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szEffects, 0, addr lpType, addr charF.dwEffects, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rTC, 0, addr lpType, addr charF.crTextColor, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rTBGC, 0, addr lpType, addr charF.crBackColor, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rBC, 0, addr lpType, addr BackC, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szFontH, 0, addr lpType, addr FontH, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szFontW, 0, addr lpType, addr FontW, addr lpcbData
         INVOKE     RegSetValueEx, hReg, addr szHandle, 0, REG_DWORD, addr hwnd, 4

         INVOKE     GetDC, hREdit
            mov     hEDC, eax
         INVOKE     SelectObject, hEDC, hFont
         INVOKE     GetTextMetrics, hEDC, addr tm
         INVOKE     ReleaseDC, hREdit, hEDC
            mov     al, tm.tmCharSet
            mov     lf.lfCharSet, al
            mov     charF.bCharSet, al
            mov     al, tm.tmPitchAndFamily
             or     eax, 0eh
            xor     eax, 0fh
            mov     lf.lfPitchAndFamily, al
            mov     charF.bPitchAndFamily, al

         INVOKE     lstrcpy, addr lf.lfFaceName, addr charF.szFaceName
           push     FontH
            pop     lf.lfHeight
           push     FontW
            pop     lf.lfWeight
            mov     lf.lfItalic, 0
            mov     lf.lfUnderline, 0
            mov     lf.lfStrikeOut, 0
         INVOKE     CreateFontIndirect, addr lf
            mov     hFont, eax
         INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1
   
            mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackC
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0

         INVOKE     RegCloseKey, hReg

      .elseif wmsg == WM_SIZE
            mov     eax, lParam
            mov     ebx, eax
            shr     ebx, 16
            and     eax, 0ffffh
         INVOKE     MoveWindow, hREdit, 0, 0, eax, ebx, TRUE
         INVOKE     SetFocus, hWork

      .elseif wmsg == WM_CLOSE
            mov     First, 1
         INVOKE     DestroyWindow, hwnd

      .elseif wmsg == WM_DESTROY
         INVOKE     PostQuitMessage, NULL
      .elseif wmsg == WM_COMMAND
            mov     eax, wParam
           cwde                         ; Only low word contains command

         .if eax == 601
            INVOKE     SendMessage, hREdit, WM_CUT, 0 ,0
         .elseif eax == 602
            INVOKE     SendMessage, hREdit, WM_COPY, 0 ,0
         .elseif eax == 603
            INVOKE     SendMessage, hREdit, WM_PASTE, 0 ,0
         .elseif eax == 604
            INVOKE     SendMessage, hREdit, EM_SETSEL, 0 ,-1
         .elseif eax == 605
            INVOKE     SendMessage, hREdit, WM_SETTEXT, NULL, 0
         .endif

      .else

DefWin:
         INVOKE     DefWindowProc, hwnd, wmsg, wParam, lParam
            ret
      .endif

         xor    eax, eax
         ret
WndProc endp

;=========================================================================
RichEditProc PROC  uses ebx ecx hwnd, wmsg, wparam, lparam
LOCAL    rect:RECT

      .if wmsg == WM_RBUTTONDOWN
            jmp     PopUp
      .endif
         jmp     ThatsAll

PopUp:
      INVOKE     GetWindowRect, hWnd, addr rect
         mov     ecx, lparam        ; x/y pos of window
         mov     ebx, ecx
         and     ebx, 0000ffffh     ; ebx = LOWORD(lparam) = x pos
         shr     ecx, 16            ; ecx = HIWORD(lparam) = y pos
         add     ebx, rect.left
         add     ecx, rect.top
         add     ebx, 10 
         add     ecx, 20
      INVOKE     TrackPopupMenu, hSMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, ebx, ecx, 0, hWnd, addr rect
        jmp      ThatsAll

ThatsAll:
      INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam

         ret
RichEditProc ENDP

End DllEntry
;INVOKE     MessageBox, NULL, addr szText, addr AppName, MB_OK
