         title   Work Window
         .586
         .model flat, stdcall
            option   casemap: none
            include  \MASM32V1\include\windows.inc
            include  \MASM32V1\include\user32.inc
            include  \MASM32V1\include\kernel32.inc
            include  \MASM32V1\include\gdi32.inc
            include  \MASM32V1\include\advapi32.inc

     include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32V1\LIB\user32.LIB
         includelib  \MASM32V1\LIB\kernel32.LIB
         includelib  \MASM32V1\lib\gdi32.LIB
         includelib  \MASM32V1\lib\advapi32.LIB

RichEditProc     PROTO :DWORD, :DWORD, :DWORD, :DWORD

.data
ClassName   db  'WorkWindow',0
AppName     db  'Work Window',0
Richedit    db  'RichEdit20A',0
RichEdDLL   db  'RICHED20.DLL',0
PopupMenu   db  'PopupMenu',0

szREGSZ     db  'REG_SZ',0
szFont      db  'Font',0
szPoint     db  'Point',0
szEffects   db  'Effects',0
szMask      db  'Mask',0
szFontH     db  'FontH',0
szFontW     db  'FontW',0
rTC         db  '[Color Text.]',0
rTBGC       db  '[Color TxBG.]',0
rBC         db  '[Color BackG]',0

szCodeO     db  1,0
szCodeC     db  0,0

hInst       dd  0
hREdDll     dd  0
MainExit    dd  0
hWork       dd  0
SavEdit     dd  0
SavReg      dd  0
hWnd        dd  0
hREdit      dd  0
hSMenu      dd  0
lpRichEdit  dd  0
PointSize   dd  0
SavCode     dd  0
ExitCode    dd  0
First       dd  1

lpType      dd  0
lpcbData    dd  0
lpdwDisp    dd  0

.code

;________________________________________________________________________________
DllEntry PROC hInstance:DWORD, reason:DWORD, reserved1:DWORD
      .if reason == DLL_PROCESS_ATTACH  ; When the dll is loaded
           push     hInstance
            pop     hInst
            mov     eax, TRUE
      .elseif reason == DLL_PROCESS_DETACH  ; When the dll is detached
            xor     eax, eax
      .endif
         ret
DllEntry ENDP

;________________________________________________________________________________
WorkWin PROC   hwnd:DWORD, hredit, szReg, OpenCode

        push     hwnd
         pop     hWork
        push     hredit
         pop     SavEdit
        push     szReg
         pop     SavReg
        push     OpenCode
         pop     SavCode
      INVOKE     LoadLibrary, addr RichEdDLL ; Load the Riched20.dll
         mov     hREdDll, eax
      .if !eax
;         INVOKE     MessageBox, NULL, addr szError1, addr AppName, MB_OK or MB_ICONERROR
            jmp     NoGo
      .endif
      INVOKE     lstrcpy, SavCode, addr szCodeO
        call     WinMain
         mov     MainExit, eax
      INVOKE     FreeLibrary, hREdDll

NoGo:

      .if ExitCode == 4
         INVOKE     ExitProcess, MainExit
      .endif
         ret
WorkWin Endp

;________________________________________________________________________________
SetCode PROC   hwnd:DWORD

        push     hwnd
         pop     hWork
         ret
SetCode Endp

;________________________________________________________________________________
CloseIt PROC   ExitC:DWORD

        push     ExitC
         pop     ExitCode
      INVOKE     SendMessage, hWnd, WM_CLOSE, 0, 0
         ret
CloseIt Endp

;________________________________________________________________________________
WinMain proc
LOCAL    rect:RECT
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG
LOCAL    hwnd:HWND

         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
        push     hInst
         pop     wc.hInstance
         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.lpszMenuName, 0
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon, 0, IDI_APPLICATION
         mov     wc.hIcon, eax
         mov     wc.hIconSm, 0
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

      INVOKE     LoadMenu, hInst, addr PopupMenu   
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenu, eax

;---------- [Center the window] ----------
;      INVOKE     GetSystemMetrics, SM_CXSCREEN
;         sub     eax, 350
;         shr     eax, 1
;        push     eax
;      INVOKE     GetSystemMetrics, SM_CYSCREEN
;         sub     eax, 200
;         shr     eax, 1
;         pop     ebx

      INVOKE     GetWindowRect, hWork, addr rect
        push     rect.right
        push     rect.bottom
         pop     rect.top
         pop     rect.left
         sub     rect.left, 500

;---------- [Main window] ----------
      INVOKE     CreateWindowEx, WS_EX_TOPMOST or WS_EX_CLIENTEDGE, addr ClassName,\
                 addr AppName, WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_THICKFRAME,\
                 rect.left, rect.top, 500, 200, hWork, NULL, hInst, NULL
         mov     hWnd, eax

      INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      INVOKE     UpdateWindow, hWnd
      INVOKE     SetWindowPos, hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW
      INVOKE     SetFocus, hWork

      .while TRUE
         INVOKE     GetMessage, addr msg, 0, 0, 0
         .break .if (!eax)
         INVOKE     TranslateMessage, addr msg
         INVOKE     DispatchMessage, addr msg
      .endw
         mov     eax, msg.wParam
         ret
WinMain endp

;________________________________________________________________________________
WndProc proc  uses ebx  hwnd:DWORD, wmsg:DWORD, wParam:DWORD, lParam:DWORD
LOCAL    rect:RECT
LOCAL    tm:TEXTMETRIC
LOCAL    charF:CHARFORMAT2
LOCAL    lf:LOGFONT
LOCAL    hReg:DWORD, hEDC, hFont, BackC, FontH, FontW


      .if wmsg == WM_CREATE
         INVOKE     CreateWindowEx, NULL, addr Richedit, NULL,\
                    WS_CHILD or WS_VISIBLE or ES_MULTILINE or ES_SAVESEL or ES_NOHIDESEL or\
                    ES_AUTOHSCROLL or ES_AUTOVSCROLL or WS_HSCROLL or WS_VSCROLL,\
                    0, 0, 0, 0, hwnd, 44, hInst, NULL
            mov     hREdit, eax
            mov     ebx, SavEdit
            mov     dword ptr[ebx], eax

         INVOKE     SetWindowLong, hREdit, GWL_WNDPROC, RichEditProc
            mov     lpRichEdit, eax
         INVOKE     SendMessage, hREdit, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
         INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 100000
;         INVOKE     SetFocus, hWork ;hREdit

            mov     charF.cbSize, sizeof charF

;---------- [The below is used to match the work window font with AsmEdit] ----------
         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, SavReg, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hReg, addr lpdwDisp

            mov     lpcbData, 50
         INVOKE     RegQueryValueEx, hReg, addr szFont, 0, addr lpType, addr charF.szFaceName, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szPoint, 0, addr lpType, addr charF.yHeight, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szMask, 0, addr lpType, addr charF.dwMask, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szEffects, 0, addr lpType, addr charF.dwEffects, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rTC, 0, addr lpType, addr charF.crTextColor, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rTBGC, 0, addr lpType, addr charF.crBackColor, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr rBC, 0, addr lpType, addr BackC, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szFontH, 0, addr lpType, addr FontH, addr lpcbData
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hReg, addr szFontW, 0, addr lpType, addr FontW, addr lpcbData
   
         INVOKE     GetDC, hREdit
            mov     hEDC, eax
         INVOKE     SelectObject, hEDC, hFont
         INVOKE     GetTextMetrics, hEDC, addr tm
         INVOKE     ReleaseDC, hREdit, hEDC
            mov     al, tm.tmCharSet
            mov     lf.lfCharSet, al
            mov     charF.bCharSet, al
            mov     al, tm.tmPitchAndFamily
             or     eax, 0eh
            xor     eax, 0fh
            mov     lf.lfPitchAndFamily, al
            mov     charF.bPitchAndFamily, al

         INVOKE     lstrcpy, addr lf.lfFaceName, addr charF.szFaceName
           push     FontH
            pop     lf.lfHeight
           push     FontW
            pop     lf.lfWeight
            mov     lf.lfItalic, 0
            mov     lf.lfUnderline, 0
            mov     lf.lfStrikeOut, 0
         INVOKE     CreateFontIndirect, addr lf
            mov     hFont, eax
         INVOKE     SendMessage, hREdit, WM_SETFONT, hFont, 1
   
            mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
         INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, BackC
         INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
         INVOKE     SendMessage, hREdit, EM_SETSEL, 0, 0

         INVOKE     RegCloseKey, hReg

      .elseif wmsg == WM_SIZE
         .if First
               and     First, 0
            INVOKE     GetWindowRect, hWork, addr rect
              push     rect.right
              push     rect.bottom
            INVOKE     GetWindowRect, hWnd, addr rect
               mov     eax, rect.right
               sub     eax, rect.left
               mov     ebx, rect.bottom
               sub     ebx, rect.top
               pop     rect.top
               pop     rect.left
               sub     rect.left, eax
            INVOKE     MoveWindow, hWnd, rect.left, rect.top, eax, ebx, TRUE
         .endif

            mov     eax, lParam
            mov     ebx, eax
            shr     ebx, 16
            and     eax, 0ffffh
         INVOKE     MoveWindow, hREdit, 0, 0, eax, ebx, TRUE
         INVOKE     SetFocus, hWork ;hREdit
         INVOKE     ShowWindow, hWork, SW_SHOWNORMAL
         INVOKE     SendMessage, hWork, WM_COMMAND, 744, 0

      .elseif wmsg == WM_CLOSE
            mov     First, 1
      INVOKE     lstrcpy, SavCode, addr szCodeC
         INVOKE     SendMessage, hWork, WM_COMMAND, 743, 0
         INVOKE     SetFocus, hWnd
         INVOKE     DestroyWindow, hwnd

      .elseif wmsg == WM_DESTROY
;      .if ExitCode == 4
         INVOKE     PostQuitMessage, NULL
;      .endif
      .elseif wmsg == WM_COMMAND
            mov     eax, wParam
           cwde                         ; Only low word contains command

         .if eax == 601
            INVOKE     SendMessage, hREdit, WM_CUT, 0 ,0
         .elseif eax == 602
            INVOKE     SendMessage, hREdit, WM_COPY, 0 ,0
         .elseif eax == 603
            INVOKE     SendMessage, hREdit, WM_PASTE, 0 ,0
         .elseif eax == 604
            INVOKE     SendMessage, hREdit, EM_SETSEL, 0 ,-1
         .elseif eax == 605
            INVOKE     SendMessage, hREdit, WM_SETTEXT, NULL, 0
         .endif

      .else

DefWin:
         INVOKE     DefWindowProc, hwnd, wmsg, wParam, lParam
            ret
      .endif

         xor    eax, eax
         ret
WndProc endp

;=========================================================================
RichEditProc PROC  uses ebx ecx hwnd, wmsg, wparam, lparam
LOCAL    rect:RECT

      .if wmsg == WM_RBUTTONDOWN
            jmp     PopUp
      .endif
         jmp     ThatsAll

PopUp:
      INVOKE     GetWindowRect, hWnd, addr rect
         mov     ecx, lparam        ; x/y pos of window
         mov     ebx, ecx
         and     ebx, 0000ffffh     ; ebx = LOWORD(lparam) = x pos
         shr     ecx, 16            ; ecx = HIWORD(lparam) = y pos
         add     ebx, rect.left
         add     ecx, rect.top
         add     ebx, 10 
         add     ecx, 20
      INVOKE     TrackPopupMenu, hSMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, ebx, ecx, 0, hWnd, addr rect
        jmp      ThatsAll

ThatsAll:
      INVOKE     CallWindowProc, lpRichEdit, hwnd, wmsg, wparam, lparam

         ret
RichEditProc ENDP

End DllEntry
;INVOKE     MessageBox, NULL, addr szText, addr AppName, MB_OK
