         title   Pgm06 - DLL Normal Window With (.rc)
         .586
         .model flat, stdcall
            option   casemap: none
            include  \Masm32V1\include\windows.inc
            include  \Masm32V1\include\user32.inc
            include  \Masm32V1\include\GDI32.inc
            include  \Masm32V1\include\kernel32.inc
            include  \Masm32V1\include\comdlg32.inc
            include  \Masm32V1\include\COMCTL32.inc
;   include  \MASM32V1\include\DSPMACRO.asm

         includelib  \Masm32V1\lib\user32.lib
         includelib  \Masm32V1\lib\GDI32.lib
         includelib  \Masm32V1\lib\kernel32.lib
         includelib  \Masm32V1\lib\comdlg32.lib
         includelib  \Masm32V1\lib\COMCTL32.lib

WinMain         PROTO  :DWORD, :DWORD, :DWORD, :DWORD
SetColor        PROTO  :DWORD, :DWORD, :DWORD, :DWORD

.const
EditID      equ 1
IDM_EXIT    equ 2
IDM_COLOR   equ 3

.data
ClassName   db  'Pgm06',0
AppName     db  'Pgm06 - DLL Normal Window With (.rc)',0
RichEdit    db  'RichEdit20A',0
RichEdDLL   db  'RICHED20.DLL',0
MenuName    db  'MainMenu',0
DlgName     db  'SetColors',0
szText      db  0Dh,0Ah
            db  ' H A V E   A   N I C E   D A Y !',0
szError1    db  'The RICHED20.DLL was not found!',0

.data?
hInst       dd  ?
hDLL        dd  ?
CommandLine dd  ?
hREdDll     dd  ?
MainExit    dd  ?
hWnd        dd  ? 
hREdit      dd  ?

.code

;________________________________________________________________________________
DllEntry PROC hInstance:DWORD, reason:DWORD, reserved1:DWORD
      .if reason == DLL_PROCESS_ATTACH  ; When the dll is loaded
           push     hInstance
            pop     hInst
            mov     eax, TRUE
      .endif
         ret
DllEntry ENDP

;________________________________________________________________________________
FunctionEntry PROC 

      INVOKE     GetCommandLine
         mov     CommandLine, eax

        call     InitCommonControls          ; Initialize the common ctrl lib
      INVOKE     LoadLibrary, addr RichEdDLL ; Load the Riched20.dll
         mov     hREdDll, eax
      .if !eax
         INVOKE     MessageBox, NULL, addr szError1, addr AppName, MB_OK or MB_ICONERROR
            jmp     NoGo
      .endif

      INVOKE     WinMain, hInst ,NULL, CommandLine, SW_SHOWDEFAULT
         mov     MainExit, eax
      INVOKE     FreeLibrary, hREdDll

NoGo:
      INVOKE     ExitProcess, MainExit
         ret
FunctionEntry Endp

;________________________________________________________________________________
WinMain proc  uses ebx  hinst:HINSTANCE, hPrevInst:HINSTANCE, CmdLine:LPSTR, CmdShow:DWORD
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG
LOCAL    hwnd:HWND

         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
        push     hInst
         pop     wc.hInstance
         mov     wc.hbrBackground, COLOR_WINDOWTEXT+1
         mov     wc.lpszMenuName, offset MenuName ;0
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon, 0, IDI_APPLICATION
         mov     wc.hIcon, eax
         mov     wc.hIconSm, 0
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

;---------- [Center the window] ----------
      INVOKE     GetSystemMetrics, SM_CXSCREEN
         sub     eax, 350
         shr     eax, 1
        push     eax
      INVOKE     GetSystemMetrics, SM_CYSCREEN
         sub     eax, 250
         shr     eax, 1
         pop     ebx

      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr ClassName,\
                 addr AppName, WS_OVERLAPPEDWINDOW,\
                 ebx, eax, 350, 250, NULL, NULL, hInst, NULL
         mov     hWnd, eax

      INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      INVOKE     UpdateWindow, hWnd
      .while TRUE
         INVOKE     GetMessage, addr msg, 0, 0, 0
         .break .if (!eax)
         INVOKE     TranslateMessage, addr msg
         INVOKE     DispatchMessage, addr msg
      .endw
         mov     eax, msg.wParam
         ret
WinMain endp

;________________________________________________________________________________
WndProc proc  hwnd:DWORD,wmsg:DWORD,wParam:DWORD,lParam:DWORD

      .if wmsg == WM_CREATE
         INVOKE     CreateWindowEx, NULL, addr RichEdit, NULL,\
                    WS_VISIBLE or WS_CHILD or ES_LEFT or ES_MULTILINE or\
                    ES_AUTOHSCROLL or ES_AUTOVSCROLL,\
                    0, 0, 0, 0, hwnd, EditID, hInst, NULL
            mov     hREdit, eax
         INVOKE     SendMessage, hREdit, EM_EXLIMITTEXT, 0, 100000
         INVOKE     SetFocus, hREdit

      .elseif wmsg == WM_SIZE
            mov     eax, lParam
            mov     edx, eax
            shr     edx, 16
            and     eax, 0ffffh
         INVOKE     MoveWindow, hREdit, 0, 0, eax, edx, TRUE

      .elseif wmsg == WM_COMMAND
            mov     eax, wParam
           cwde                         ; Only low word contains command

         .if eax == IDM_COLOR
            INVOKE     DialogBoxParam, hInst, addr DlgName, 0, addr SetColor, 0

         .elseif eax == IDM_EXIT
            INVOKE     DestroyWindow, hwnd

         .endif

      .elseif wmsg == WM_DESTROY
        INVOKE     PostQuitMessage, NULL

      .else

DefWin:
         INVOKE     DefWindowProc, hwnd, wmsg, wParam, lParam
            ret
      .endif

         xor    eax, eax
         ret
WndProc endp

;________________________________________________________________________________
SetColor proc  hdlg:DWORD, uMsg, wParam, lParam
LOCAL    charF:CHARFORMAT2

      .if uMsg == WM_COMMAND
         .if wParam == IDCANCEL
               jmp     GetOut

         .elseif wParam == 401              ; SetColors
            INVOKE     SendMessage, hREdit, EM_SETBKGNDCOLOR, 0, 00000000h ;00GGBBRRh
               mov     charF.cbSize, sizeof charF
               mov     charF.dwEffects, 0
               mov     charF.yHeight, 240
               mov     charF.dwMask, CFM_FACE or CFM_SIZE or CFM_COLOR
               mov     charF.crTextColor, 0000ff00h
               mov     charF.crBackColor, 00000000h
            INVOKE     SendMessage, hREdit, EM_SETCHARFORMAT, SCF_ALL, addr charF
            INVOKE     SendMessage, hREdit, WM_SETTEXT, NULL, addr szText
            INVOKE     SetFocus, hREdit
               jmp     GetOut
         .endif

      .elseif uMsg == WM_CLOSE

GetOut:
         INVOKE     EndDialog, hdlg, wParam ; End the dialog with wparam as return
            mov     eax, TRUE               ; Return
            jmp     SetColorRet             ; with TRUE

      .endif

Ret0:
         xor     eax, eax

SetColorRet:
         ret
SetColor endp

End DllEntry
;INVOKE     MessageBox, NULL, addr szText, addr AppName, MB_OK
