         title   Pgm10 - MDI Window(s) without RichEdit

         .586
         .model flat, stdcall
         option casemap:none

            include  \Masm32V1\include\windows.inc
            include  \Masm32V1\include\user32.inc
            include  \Masm32V1\include\gdi32.inc
            include  \Masm32V1\include\kernel32.inc
            include  \Masm32V1\include\comdlg32.inc
            include  \Masm32V1\include\comctl32.inc

   include  \MASM32V1\include\DSPMACRO.asm

         includelib  \Masm32V1\lib\user32.lib
         includelib  \Masm32V1\lib\gdi32.lib
         includelib  \Masm32V1\lib\kernel32.lib
         includelib  \Masm32V1\lib\comdlg32.lib
         includelib  \Masm32V1\lib\comctl32.lib

WinMain        proto :DWORD, :DWORD, :DWORD, :DWORD

.const
IDM_NEW        equ  701
IDM_CLOSE      equ  702
IDM_EXIT       equ  703
IDM_TILEHORZ   equ  704
IDM_TILEVERT   equ  705
IDM_CASCADE    equ  706

.data?
hInst          dd  ?
CommandLine    dd  ?
hMenuM         dd  ?
hWndClient     dd  ?
hWndFrame      dd  ?

.data
ClassName      db  'Pgm10',0
AppName        db  'Pgm10 - MDI Window(s) without RichEdit',0
MDIClientClass db  'MDICLIENT',0
MDIFrameClass  db  'Win32asmMDIFrame',0
MDIChildClass  db  'Win32asmMDIChild',0
MDIChildTitle  db  'MDI RichEdit Child',0

MenuName       db  'MainMenu',0


mdicreate    MDICREATESTRUCT <>

.code
start:
      INVOKE     GetModuleHandle, NULL
         mov     hInst, eax
      INVOKE     GetCommandLine
         mov     CommandLine, eax

        call     InitCommonControls          ; Initialize the common ctrl lib
      INVOKE     WinMain, hInst ,NULL, CommandLine, SW_SHOWDEFAULT

      INVOKE     ExitProcess, eax

;_________________________________________________________________________________________
WinMain proc  uses ebx  hinst:HINSTANCE, hPrevInst:HINSTANCE, CmdLine:LPSTR, CmdShow:DWORD
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG

;---------- [Register the frame window class] ----------
         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, NULL
         mov     wc.cbWndExtra, NULL
        push     hInst
         pop     wc.hInstance
         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.lpszMenuName, offset MenuName
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon ,NULL, IDI_APPLICATION
         mov     wc.hIcon, eax
         mov     wc.hIconSm, eax
      INVOKE     LoadCursor, NULL, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

;---------- [Register the MDI child window class] ----------
         mov     wc.lpfnWndProc, offset ChildProc
         mov     wc.hbrBackground, COLOR_WINDOW+1
         mov     wc.lpszClassName, offset MDIChildClass
      INVOKE     RegisterClassEx, addr wc

;---------- [Center and create the Frame window] ----------
      INVOKE     GetSystemMetrics, SM_CXSCREEN
         sub     eax, 350
         shr     eax, 1
        push     eax
      INVOKE     GetSystemMetrics, SM_CYSCREEN
         sub     eax, 250
         shr     eax, 1
         pop     ebx

      INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, addr ClassName, addr AppName,\
                 WS_OVERLAPPEDWINDOW or WS_CLIPCHILDREN,\
                 ebx, eax, 350, 250, NULL, NULL, hInst, NULL
         mov     hWndFrame, eax

      INVOKE     ShowWindow, hWndFrame, SW_SHOWNORMAL
      INVOKE     UpdateWindow, hWndFrame

      .while TRUE
         INVOKE     GetMessage, addr msg, NULL,0,0
         .break .if (!eax)
            INVOKE     TranslateMDISysAccel, hWndClient, addr msg
         .if eax == 0
            INVOKE     TranslateMessage, addr msg
            INVOKE     DispatchMessage, addr msg
         .endif
      .endw

         mov     eax, msg.wParam
         ret
WinMain endp

;_________________________________________________________________________________________
WndProc proc hWnd:DWORD, uMsg, wParam, lParam
LOCAL    rect:RECT
LOCAL    ClientStruct:CLIENTCREATESTRUCT
LOCAL    hWndChild:DWORD, hEdit

      .if uMsg==WM_CREATE
         INVOKE     GetMenu, hWnd
            mov     hMenuM, eax
         INVOKE     GetSubMenu, hMenuM, 1
            mov     ClientStruct.hWindowMenu, eax
            mov     ClientStruct.idFirstChild, 100
         INVOKE     EnableMenuItem, hMenuM, IDM_CLOSE, MF_GRAYED

;---------- [Create the Client window] ----------
         INVOKE     CreateWindowEx, NULL, addr MDIClientClass, NULL,\
                    WS_CHILD or WS_VISIBLE or WS_CLIPCHILDREN, CW_USEDEFAULT,\
                    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, hWnd, NULL,\
                    hInst, addr ClientStruct
            mov     hWndClient, eax

;---------- [Initialize the MDICREATESTRUCT] ----------
            mov     mdicreate.szClass, offset MDIChildClass
            mov     mdicreate.szTitle, offset MDIChildTitle
           push     hInst
            pop     mdicreate.hOwner
            mov     mdicreate.x, CW_USEDEFAULT
            mov     mdicreate.y, CW_USEDEFAULT
            mov     mdicreate.lx, CW_USEDEFAULT
            mov     mdicreate.ly, CW_USEDEFAULT

      .elseif uMsg == WM_COMMAND
            mov     eax, wParam
           cwde                         ; Only low word contains command
         .if eax == IDM_EXIT
            INVOKE     SendMessage, hWnd, WM_CLOSE, 0, 0
         .elseif eax == IDM_TILEHORZ
            INVOKE     SendMessage, hWndClient, WM_MDITILE, MDITILE_HORIZONTAL, 0
         .elseif eax == IDM_TILEVERT
            INVOKE     SendMessage, hWndClient, WM_MDITILE, MDITILE_VERTICAL, 0
         .elseif eax == IDM_CASCADE
            INVOKE     SendMessage, hWndClient, WM_MDICASCADE, MDITILE_SKIPDISABLED, 0                 
         .elseif eax == IDM_NEW

;---------- [Create the Child window(s)] ----------
            INVOKE     SendMessage, hWndClient, WM_MDICREATE, 0, addr mdicreate
               mov     hWndChild, eax

         .elseif eax == IDM_CLOSE
            INVOKE     SendMessage, hWndClient, WM_MDIGETACTIVE, 0, 0
            INVOKE     SendMessage, eax, WM_CLOSE, 0, 0
         .else
            INVOKE     DefFrameProc, hWnd, hWndClient, uMsg, wParam, lParam        
               ret
         .endif

      .elseif uMsg == WM_DESTROY
        INVOKE     PostQuitMessage, NULL
      .else
         INVOKE     DefFrameProc, hWnd, hWndClient, uMsg, wParam, lParam       
            ret
      .endif
         xor eax, eax
         ret
WndProc endp

;_________________________________________________________________________________________
ChildProc   proc   hChild:DWORD, uMsg, wParam, lParam
LOCAL    rect:RECT
LOCAL    hEdit:DWORD

      .if uMsg == WM_MDIACTIVATE
            mov     eax, lParam
         .if eax == hChild
            INVOKE     EnableMenuItem, hMenuM, IDM_CLOSE, MF_ENABLED
         .else
            INVOKE     EnableMenuItem, hMenuM, IDM_CLOSE, MF_GRAYED
         .endif

         INVOKE     GetSubMenu, hMenuM, 1
            mov     edx, eax
           push     edx
;         INVOKE     SendMessage, hWndClient, WM_MDISETMENU, hMenuM, edx
         INVOKE     GetWindow, hChild, GW_CHILD
            mov     ecx, eax
            pop     edx
         INVOKE     SendMessage, ecx, WM_MDISETMENU, hMenuM, edx
         INVOKE     DrawMenuBar, hWndFrame

      .elseif uMsg == WM_CLOSE
            INVOKE     SendMessage, hWndClient, WM_MDIDESTROY, hChild, 0

      .else
         INVOKE     DefMDIChildProc, hChild, uMsg, wParam, lParam
            ret
      .endif
         xor eax, eax
         ret
ChildProc endp
end start
