;NKS6D3
;======================================================================
;	Attempt at creating a pattern generator based on info from 
;	"A New Kind of Science" by Stephen Wolfram
;======================================================================
 
; See Win32 "Wincap" in c:\Win32 for info on DIBAPI.dll and a PrintDIB API ?

;=====================================================
; Bit map saving now OK 27/6/02
; Print bitmap now OK 1/7/02
;=====================================================

.486				; 32 bit when .386 appears before .MODEL
.MODEL FLAT,STDCALL

;option casemap :none   		; case sensitive

include \masm32\include\windows.inc

include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\gdi32.inc
include  comdlg32.inc			
include  comctl32.inc			 

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\gdi32.lib
includelib comdlg32.lib			; Needed for dialogs
includelib comctl32.lib			; Needed if UP/DOWN controls are used
 
; Prototypes
;=======================================================
WinMain           PROTO  :DWORD, :DWORD, :DWORD, :SDWORD
WndProc		  PROTO  :DWORD, :DWORD, :DWORD, :DWORD
MakeNKS		  PROTO
RuleTest	  PROTO
DibFileInitialize PROTO  :DWORD
DibFileSaveDlg	  PROTO  :DWORD, :DWORD, :DWORD  
DibSaveImage	  PROTO	 :DWORD, :DWORD
OptionsDlg	  PROTO  :DWORD, :DWORD, :DWORD, :DWORD
PrintSetup	  PROTO  :DWORD, :DWORD
PrintBMP	  PROTO  :DWORD, :DWORD
DibPrintDlg	  PROTO  
Invert		  PROTO
AbortFunc	  PROTO  :DWORD, :DWORD
KillPrint	  PROTO  :DWORD, :DWORD, :DWORD, :DWORD
;=======================================================

;=======================================================================
; #### Problem with widths 400 560 600; 1024 & 800 OK  ####
; #### & if pattern generated continues after boundary reaches window edge ###
;========================================================================
 
Bwidth	EQU	1024;800;256; 128 , 480	; Bitmap width in pixels
Bheight	EQU	Bwidth/2; 500;200	; Bitmap height (rows)
Bbytes  EQU	Bwidth/8	; Row width in bytes
Rwidth  EQU	Bbytes/4	; Row width in dwords 

IDOK		EQU   1	
IDM_EXIT 	EQU 102
IDM_HELP	EQU 103
IDM_FILE_SAVE   EQU 106
IDM_PRINT	EQU 107	
IDM_OPTIONS	EQU 108

IDC_RULE	EQU 200	
	
.data

ALIGN 4

bitmap  BITMAP <0, Bwidth, Bheight, Bbytes, 1, 1>	; Define the bitmap 

printOK		DD  1
hDLG		DD  0	
rule		DD  250					; Default NKS rule

ClassName	db "SimpleWinClass",0
szAppName	db "NKS Test",0
MenuName	db "BMPMENU",0				; Name of menu in resource file
DefExtn		db "bmp",0				; Default extension for file  	
szFilter	db "Bitmap Files (*.bmp)",0, "*.bmp",0,\
		   "All Files (*.*)",0,"*.*",0,0
Cantsave	db "Cannot save DIB file",0 
Cantprint	db "Could not print bitmap",0
printbitmap     db "Printing Bitmap",0
IntDlgName	db "IntDlg",0				; Name of Dialog Integer entry box 
helpnotimpl	db "Help not yet implemented !",0
error	        db "Error",0
CantprintRaster db "Cannot Print Raster Images",0
szCANCEL	db "PRCANCEL",0

; 8 Cases for combinations of 3 adjacent pixels (bits T1,T2 & T3)
; The setting of these determine the setting of a bit in the new line 
;--------------------------------------------------------------------
C1		EQU	0	; No bits set	
C2		EQU	1	;       T3	; This bit set	
C4		EQU	2	;    T2
C8		EQU	3	; T1 T2 	; These 2 set
C16		EQU	4	; T1
C32		EQU	5	; T1    T3 
C64		EQU	6	; T1 T2
C128		EQU	7	; T1 T2 T3	; All 3 set

;==============================================================================
;	A dib file is composed of 4 sections
;
;	A File header
;
;	An Information header
;
;	An RGB colour table (not used for monochrome)
;
;	And of course the bipmap pixel bits

;	So the file structure we need is as follows:-
 
bmfh	BITMAPFILEHEADER	<04D42h,\		; 1st word is binary equivalent of "BM" 
				sizeof BITMAPFILEHEADER + \ ; Size of the file 
				sizeof BITMAPINFOHEADER + \ ; 
			 	2*(sizeof RGBQUAD) + \	    ; 	
		  	        sizeof pixels,\             ;
				0,0, \ 
				sizeof BITMAPFILEHEADER + \ ; This is the offset in file 
				sizeof BITMAPINFOHEADER + \ ; to the DIB pixel bits
				2*(sizeof RGBQUAD)>	    ;
;					NB: ### Attempted -ve Bheight to invert - didn't work ! ###
bmih	BITMAPINFOHEADER	<sizeof BITMAPINFOHEADER, Bwidth, Bheight, 1,1, BI_RGB, \
				0,0,0,0,0>		; biSizeImage, biXPelsPerMeter,  
							; biYPelsPerMeter,biClrUsed, biClrImportant  
ctable	RGBQUAD			<0FFh,0FFh,0FFh,0>	; Colour table for 1 bit DIB (White) and
	RGBQUAD			<0,0,0,0>		; (Black); reverse these for negative image  

pixels		DD	Bwidth*Bheight/32 DUP (0)	; Storage for bitmap pixels in dwords
;==============================================================================

junk		DD	Rwidth DUP (0)		; Work buffer used in creating new row
	
;-----------------------------------------------------------------------------------------------
; Note in the above pixel storage, bits are stored in an array of dwords, there being Rwidth
; dwords per line. Each line is processed from left to right with a 1 bit shift "SHR" after each
; "pixel" is processed. For convenience we do this 1 dword at a time and all testing of pixels
; is on bits 0 and 1, and also the bit which has been shifted out by a previous test.             
;-----------------------------------------------------------------------------------------------

.data?

ALIGN 4
ofn   		OPENFILENAME <>
docinfo		DOCINFO	 <>
printdlg	PRINTDLG <>

hInstance	HINSTANCE ?
CommandLine	LPSTR     ?

buffer		DD	Rwidth DUP (?)	;Buffer for 1 line of bitmap
hBitmap		HBITMAP	?
cxSource	DD	?
cySource	DD	?

pMemory		DD	?
hMemory		DD	?

maxX		DD	?
maxY		DD	?
memDC		DD	?
hBit		DD	?
hBit2		DD	?

szFileName	db	MAX_PATH DUP (?)
szTitleName	db	MAX_PATH DUP (?)
	
include  macros.txt
;------------------------------------------------------------------------------
.code

start:
	invoke GetModuleHandle, 0
	mov    hInstance,eax
	invoke GetCommandLine		; Get pointer to command line for any arguments
	mov    CommandLine, eax
        invoke WinMain, hInstance, 0, CommandLine, SW_SHOWDEFAULT
	invoke ExitProcess,eax

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdLine:LPSTR,CmdShow:SDWORD

	LOCAL wc:WNDCLASSEX, msg:MSG
;	LOCAL icex:INITCOMMONCONTROLSEX 
        LOCAL hwnd:HWND

	mov   wc.cbSize,SIZEOF WNDCLASSEX
	mov   wc.style, CS_HREDRAW or CS_VREDRAW
	mov   wc.lpfnWndProc, OFFSET WndProc
	mov   wc.cbClsExtra,NULL
	mov   wc.cbWndExtra,NULL
        push  hInstance
        pop   wc.hInstance
	mov   wc.hbrBackground,COLOR_WINDOW+1
	mov   wc.lpszMenuName,offset MenuName
	mov   wc.lpszClassName,OFFSET ClassName
        invoke LoadIcon,NULL,IDI_APPLICATION
	mov   wc.hIcon,eax
        mov   wc.hIconSm,0
        invoke LoadCursor,NULL,IDC_ARROW
	mov   wc.hCursor,eax 
        invoke RegisterClassEx, addr wc
        INVOKE CreateWindowEx,NULL,ADDR ClassName,ADDR szAppName,\
           WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,\
           CW_USEDEFAULT,Bwidth+12,Bheight+48,NULL,NULL,\ ; Adjust width and height 
	    hInst,NULL					  ; to dynamically fit, allowing for 	 
  							  ; caption bar height etc        
;---------------------------------------------------------------------------------------------
;           CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,NULL,NULL,\ ; Original
;### Use System info to derive height of title bar etc and use in place of hardwired 12 and 48
;	in CreateWindowsEx
;---------------------------------------------------------------------------------------------
        mov   hwnd,eax

;	invoke InitCommonControlsEx, ADDR icex		; Initialise use of controls
						        ; Needed for possible spin control 
        INVOKE ShowWindow, hwnd,SW_SHOWNORMAL
        INVOKE UpdateWindow, hwnd

        .WHILE TRUE
                INVOKE GetMessage, ADDR msg,NULL,0,0
                .BREAK .IF (!eax)
                INVOKE TranslateMessage, ADDR msg
                INVOKE DispatchMessage, ADDR msg
        .ENDW
        mov     eax,msg.wParam
        ret
WinMain endp
;------------------------------------------------------------------------------
 
WndProc proc	uses ebx esi edi,  hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	LOCAL ps:PAINTSTRUCT
	LOCAL hDC:DWORD, hdcMem:DWORD, bSuccess:DWORD, hdcPrn:DWORD
	LOCAL cxPage:DWORD, cyPage:DWORD, memPrDC:DWORD

	LOCAL Xratio:DWORD, Yratio:DWORD;, slength:DWORD
	LOCAL VidXPPI:DWORD, VidYPPI:DWORD, PrXPPI:DWORD, PrYPPI:DWORD

	.IF	uMsg==WM_CREATE

	    invoke PrintSetup, ADDR printdlg, hWnd	; Initialise the PRINTDLG struct
	    invoke DibFileInitialize, hWnd	; Initialise OFN ready for file creation

	    invoke MakeNKS			; Show the default NKS diagram

;	Get screen coordinates

	invoke GetSystemMetrics, SM_CXSCREEN
	mov maxX, eax
	invoke GetSystemMetrics, SM_CYSCREEN
	mov maxY, eax

;	Create a virtual window

	invoke GetDC, hWnd
	mov hDC, eax
	invoke CreateCompatibleDC, hDC
	mov memDC, eax

	.ELSEIF uMsg==WM_COMMAND

	    LOWORD wParam
	    .IF eax ==IDM_FILE_SAVE		; Save data as a bitmap

;		invoke DibFileInitialize, hWnd	; Seem to need reinitialisation here ?	
						; Not need now 	
	        invoke DibFileSaveDlg, hWnd, ADDR szFileName, ADDR szTitleName

		.IF !eax
		    mov eax,0
		    ret
		.ENDIF

;	Save the DIB to a disk file
;	---------------------------

		invoke Invert				; Invert all lines top to bottom

	        invoke  LoadCursor, 0, IDC_WAIT		; Load cursor resource
	        invoke  SetCursor, eax 			; Set cursor shape
	        invoke  ShowCursor, TRUE

	        invoke DibSaveImage, ADDR szFileName, ADDR bmfh	; Save image as DIB

	        mov	bSuccess, eax
	        invoke  ShowCursor, FALSE
	        invoke  LoadCursor, 0, IDC_ARROW
	        invoke  SetCursor, eax

	        .IF !bSuccess
	            invoke MessageBox, hWnd, ADDR Cantsave, ADDR szAppName, \
					MB_ICONEXCLAMATION or MB_OK
	        .ENDIF
                          
	    .ELSEIF eax==IDM_PRINT		; Print  bitmap

		invoke PrintSetup, ADDR printdlg, hWnd
		invoke PrintDlg, ADDR printdlg

		.IF eax			; If true	; ### Add breakout if false ? ###
		    mov docinfo.cbSize, SIZEOF DOCINFO
		    M2M docinfo.lpszDocName, offset printbitmap 
		    mov docinfo.lpszOutput,0
		    mov docinfo.lpszDatatype,0
		    mov docinfo.fwType,0
		.ELSE
		    ; ### Add breakout if false ? ###
		.ENDIF

		invoke GetDeviceCaps, printdlg.hDC, RASTERCAPS
 		and eax, RC_BITBLT or RC_STRETCHBLT

		.IF !eax
		    invoke MessageBox, hWnd, ADDR CantprintRaster, ADDR error, MB_OK
		    ; ### add breakout ? ###
		.ENDIF

;	Create a memory DC compatible with the printer

		invoke CreateCompatibleDC, printdlg.hDC
		mov memPrDC, eax

;	Create a bitmap compatible with the printer DC

		invoke CreateCompatibleBitmap, printdlg.hDC, maxX, maxY
		mov hBit2, eax

		invoke SelectObject, memPrDC, hBit2
		invoke SelectObject, memDC, hBitmap;	Put bitmap into memory DC 

;		Copy bitmap to printer-compatible DC

		invoke BitBlt, memPrDC, 0,0, Bwidth, Bheight,memDC, 0,0, SRCCOPY  

;		Obtain pixels/inch

		invoke GetDeviceCaps, memDC, LOGPIXELSX		; For Screen
		mov VidXPPI, eax				;
		invoke GetDeviceCaps, memDC, LOGPIXELSY		;
		mov VidYPPI, eax				;

		invoke GetDeviceCaps, printdlg.hDC, LOGPIXELSX	; For Printer 
		mov PrXPPI, eax					;
		invoke GetDeviceCaps, printdlg.hDC, LOGPIXELSY	;
		mov PrYPPI, eax					;

;		Get scaling ratios

		mov eax, PrXPPI
		mov edx,0
		div VidXPPI			
		mov Xratio, eax

 		mov eax, PrYPPI
		mov edx,0
		div VidYPPI			
		mov Yratio, eax
	
		invoke SelectObject, memDC, hBit	; Restore virtual window
		invoke StartDoc, printdlg.hDC, ADDR docinfo

		mov ebx, 0
		.WHILE bx < printdlg.nCopies		; Print all copies

		  invoke StartPage, printdlg.hDC

		  ; Copy bitmap to printer DC as-is  
;		  ---------------------------------

;		  invoke BitBlt, printdlg.hDC,0,0,Bwidth,Bheight, memPrDC,0,0,SRCINVERT

		  ; Copy bitmap while maintaining perspective 
;		  -------------------------------------------

		  mov edx,0
		  mov eax, Bwidth
		  mul Xratio
		  mov ecx,eax

		  mov edx,0
		  mov eax, Bheight
		  mul Yratio
		   
		  invoke StretchBlt, printdlg.hDC, 0, Bheight+100, ecx,eax, \; Print bitmap
				    memPrDC, 0, 0, Bwidth, Bheight, SRCINVERT; Inverting bits
 
		  invoke EndPage, printdlg.hDC	; Finished with page
		  inc bx

		.ENDW

		invoke EndDoc, printdlg.hDC	; Finished with printer
		invoke DeleteDC, memPrDC
		invoke DeleteDC, printdlg.hDC

	    .ELSEIF eax==IDM_OPTIONS		; Dialog for setting the "Rule" etc

		invoke DialogBoxParam,hInstance, ADDR IntDlgName,hWnd,ADDR OptionsDlg,NULL 	
		invoke InvalidateRect, hWnd,NULL,TRUE

		mov eax, 0			
		mov ecx, Bwidth*Bheight/32 	; Get size of pixel storage in dwords
		mov edi, offset pixels		; Reset Pixels to zero ?
		rep stosd			;

		invoke MakeNKS			; Make and display pattern using new rule

	    .ELSEIF eax==IDM_EXIT

		invoke SendMessage, hWnd, WM_CLOSE, 0, 0
		return 0

	    .ELSEIF eax==IDM_HELP
		
	        invoke  MessageBox, hWnd, ADDR helpnotimpl, ADDR szAppName, \
					MB_OK or MB_ICONEXCLAMATION
	    .ENDIF
  
	.ELSEIF uMsg==WM_PAINT
 
            invoke BeginPaint,hWnd,ADDR ps
            mov hDC, eax

	    invoke CreateCompatibleDC, hDC
	    mov    hdcMem, eax 

	    invoke SelectObject, hdcMem, hBitmap

	    invoke BitBlt, hDC,1,1,cxSource,cySource,hdcMem,0,0,SRCINVERT; SRCCOPY;Show bitmap, inverting bits

	    invoke DeleteDC, hdcMem
          
            invoke EndPaint,hWnd,ADDR ps
    
	.ELSEIF uMsg==WM_CLOSE

	    invoke DestroyWindow, hWnd

	.ELSEIF uMsg==WM_DESTROY

	    invoke DeleteObject, hBitmap
	    invoke PostQuitMessage, 0

        .ELSE

          invoke  DefWindowProc, hWnd, uMsg, wParam, lParam
          ret 

	.ENDIF

	xor	eax,eax
	ret

WndProc endp
;------------------------------------------------------------------------------
MakeNKS		Proc uses ebx esi

;	==========================================
;	This makes a bitmap based on the NKS rules
;	for a monochrome bitmap
;	==========================================

	LOCAL bittrap:DWORD, DWcount:DWORD, pixcopy:DWORD, output:DWORD
	LOCAL T1:byte, T2:byte, T3:byte 

	    mov    ebx, Bbytes/2		; Start towards middle of row 0 (index in mutiples of 4)
	    or     DWORD ptr pixels[ebx],1;80000000h	; Set pixel as seed
							
;	=======================================================================	
;	Scan row from left to right, processing the 32 pixels in one DWORD at a
;	time and generate the next row of pixels according to the specific rule
;	In this case we create a new pixel if the pixel immediately above is set
;	and also if the pixel on either side of the seed pixel it is set. 
;	Otherwise we leave it blank.
;	=======================================================================
 
	    mov    esi, 0		; Index to row
	    mov    DWcount, 0	
	
	    .WHILE esi < Bheight*Rwidth*4 ; Do rows made up of n DWORDS ;
		    
		mov  eax, DWORD ptr pixels[esi]	; Get 32 pixels from buffer 			
		mov  edx, eax		; Take copy for triplet test
		mov  output,0		; Holds bits for corresponding position in next row
		mov  bittrap,0		; Holds shifted-out bit 
		mov  cl, 0		; Index to byte; bits in byte
		mov  T1, 0		; 
		mov  T2, 0		; Initialise to unset
		mov  T3, 0		; NB: due to byte reversal, T3 is least sig & T1 is most

;	    ==============================================================================
;	    In this loop we process 32 bits dealing with the 3 least signigicant at a time
;           shifting right 1 bit for each loop; each time we test these 3 bits and set
;	    flags if any are set. These flags are later used to determine whether a bit will
;	    be plotted according to the specific NKS rule.
;	    ==============================================================================
         		    
		.WHILE cl < 32  ; Test 32 pixels in each dword in the line
				; We test 3 bits. 2 in dl ; bit 0 at current position, 
				; bit 1 on the right and the left bit held in a bittrap 
		  
		    .IF cl==0 		; 1st bit of dword
 
			.IF DWcount != 0  ; Avoid bit wrap-round from end of line
			    test pixels[esi-4], 80000000h ; (MSB in previous dword)
			    .IF !ZERO?
			        mov T1,4   ; Set flag for 1st of triplet
			    .ENDIF
		        .ENDIF
           	
			test dl, 1 	; Test bit 0 (middle)
			.IF !ZERO?
			    mov T2,2	; Set flag for 2nd of triplet
			.ENDIF
		
			test dl, 2 	; Test bit 1 (right)
			.IF !ZERO?
			    mov T3,1	; Set flag for 3rd of triplet
			.ENDIF
			
		    .ELSEIF cl==31	; Last bit of dword	
			
			test bittrap, 1 ; Test bit in trap (left)
			.IF !ZERO?
			    mov T1,4	; Set flag for 1st of triplet
			.ENDIF		
		
			test dl, 1	; Test middle bit 
			.IF !ZERO?
			    mov T2,2	; Set flag for 2nd of triplet
			.ENDIF

			.IF DWcount != Rwidth-1  ; Avoid bit wrapround at end of line
			
			    test pixels[esi+4], 1 ; Test right; (LSB in next dword)
			    .IF !ZERO?
			        mov T3,1   ; Set flag for 3rd bit of triplet
			    .ENDIF
		
		        .ENDIF

		    .ELSE		; Bits 1 to 30 of dword

			test bittrap, 1 ; Test bit in trap

 			.IF !ZERO?
			    mov  T1, 4
			.ENDIF
		
			test dl, 1 	; Test 2nd of triplet
			.IF !ZERO?
			    mov  T2, 2
			.ENDIF
			
			test dl, 2 	; Test 3rd of triplet
			.IF !ZERO?
			    mov  T3, 1
			.ENDIF
	
		    .ENDIF

    		; A new pixel is generated if any of the following test true
;		  ==========================================================

		    mov bx,0	;
		    mov bl,T1	; Combine "pixels" into 1 entity of 3 bits
		    or  bl,T2	; which is used to determine if a pixels is 	
		    or  bl,T3	; plotted
		 
		    invoke RuleTest	; Test the 3 pixels according to the NKS rules
					; returning the bit in eax (bit 0) as 0 or 1 	
		    shl eax, cl 
		    or output, eax  ; Set bit in output dword
 
		    mov  T1, 0		; 
		    mov  T2, 0		; Reset flags
		    mov  T3, 0		;

		    mov  bittrap,edx	; We need to use bit 1 for the next test
		    shr  edx,1		; Shift bits right for next test of 3 bits

		    inc cl		; Increment for next triplet test
		    
		  .ENDW

		mov eax, output		; We now have the new bit data
		mov pixels[esi+Bbytes],eax ; Create pixels in row beneath tested line

		.IF DWcount==Rwidth-1	; If we get to end of the row
		    mov DWcount,0	; Reset
		.ELSE
		    inc DWcount		; Otherwise increment the counter
		.ENDIF
		 
		add esi, 4		; Bump dword index for next 32 pixels
		
	    .ENDW

;       =======================================================================================
;	We now have the generated bit data, but the "pixel" bits in each byte are the wrong way 
;	for use with a bitmap and hence we need to reverse the bits in each byte before display
;       =======================================================================================

;	Reverse the order of the bits in each byte of the generated bitmap
;	------------------------------------------------------------------

	mov     esi, 0		; Index for 4 bytes in DWORD

	.WHILE	 esi < Bheight*Rwidth*4 ; Do rows made up of n DWORDS  


	    mov  eax, DWORD ptr pixels[esi]	; Get 4 bytes from buffer ; starting at begining of line 1			
	    mov  pixcopy, eax	; take copy 
	 
	    mov ebx, 0
		   
	    .WHILE ebx < 4

		mov al, byte ptr pixcopy[ebx]
		mov ah,al	; Copy of byte
		mov cx,0	 

		; Move MSB bits to mirror position on right
 
	        shr ah,7	; Move any set bit to "LSB"
                or  cl,ah	; Gather bits together 

		mov ah,al
		and ah,40h	; AND with mask to remove unwanted bits 
		shr ah,5	; Sets 2nd LSB 
		or  cl,ah

		mov ah,al
		and ah,20h	
		shr ah,3	; Sets 3rd LSB
		or  cl,ah

		mov ah,al
		and ah,10h	
		shr ah,1	; Set 4th LSB
		or  cl,ah

		; Move LSB bits to mirror position on left

		mov ah,al
	        shl ah,7	; Move any set bit to "MSB"
                or  cl,ah	; Gather bits together 

		mov ah,al
		and ah,2	; AND with mask to remove unwanted bits 
		shl ah,5	; Sets 7th LSB 
		or  cl,ah

		mov ah,al
		and ah,4	
		shl ah,3	; Sets 6th LSB
		or  cl,ah

		mov ah,al
		and ah,8	
		shl ah,1	; Set 5th LSB
		or  cl,ah	; Byte is now completely reversed 
 
		mov byte ptr pixcopy[ebx],cl  
 		
		inc ebx		; Bump index to next byte
		
	    .ENDW

	    mov eax, pixcopy
	    mov pixels[esi],eax ; Correct stored in row

	    add esi, 4		; Bump dword index for next 32 pixels
				
	.ENDW
         
;	==================================
;	Prepare a bitmap ready for display
;	==================================

	    M2M	   bitmap.bmBits, OFFSET pixels
	    invoke CreateBitmapIndirect, ADDR bitmap
	    mov    hBitmap, eax

	    M2M	   cxSource, bitmap.bmWidth
	    M2M	   cySource, bitmap.bmHeight

		ret
MakeNKS		endp
;------------------------------------------------------------------------------
DibFileInitialize	proc	hwnd:HWND 

	mov	ofn.lStructSize, sizeof OPENFILENAME
	M2M	ofn.hWndOwner, hwnd
	mov	ofn.hInstance, 0
	mov	ofn.lpstrFilter, offset szFilter
	mov	ofn.lpstrCustomFilter, 0
	mov	ofn.nMaxCustFilter, 0
	mov	ofn.nFilterIndex, 0
	mov	ofn.lpstrFile, 0		; Set in Open and Close functions
	mov	ofn.nMaxFile, MAX_PATH
	mov	ofn.lpstrFileTitle, 0		; Set in Open and Close functions
	mov	ofn.nMaxFileTitle, MAX_PATH
	mov	ofn.lpstrInitialDir, 0
	mov	ofn.lpstrTitle, 0		
	mov	ofn.Flags, 0			; Set in Open and Close functions
	mov	ofn.nFileOffset, 0
	mov	ofn.nFileExtension, 0
	mov	ofn.lpstrDefExt,offset DefExtn	; default extension is bmp
	mov	ofn.lCustData, 0
	mov	ofn.lpfnHook, 0
	mov	ofn.lpTemplateName, 0
	ret

DibFileInitialize	endp
;------------------------------------------------------------------------------
DibFileSaveDlg		proc hwnd:HWND, pstrFileName:DWORD, pstrTitleName:DWORD

	mov	eax,hwnd
	mov	ofn.hWndOwner, eax
	mov	eax,pstrFileName
	mov	ofn.lpstrFile,  eax
	mov	eax, pstrTitleName	
	mov	ofn.lpstrFileTitle, eax
	mov	ofn.Flags, OFN_OVERWRITEPROMPT
	
	invoke	GetSaveFileName, ADDR ofn

	ret
DibFileSaveDlg	endp
;-----------------------------------------------------------------------------
DibPrintDlg	proc 

	 mov docinfo.cbSize, SIZEOF DOCINFO		; Initialise the DOCINFO struct
	 M2M docinfo.lpszDocName, offset printbitmap 
	 mov docinfo.lpszOutput,0
	 mov docinfo.lpszDatatype,0
	 mov docinfo.fwType,0

	ret
DibPrintDlg	endp
;-----------------------------------------------------------------------------
DibSaveImage	proc uses ebx, pstrFileName:DWORD, pbmfh:DWORD

	LOCAL	bSuccess:DWORD, dwBytesWritten:DWORD, hFile:HANDLE

	mov	ebx, pbmfh			; Get pointer to BITMAPFILEHEADER

	invoke	CreateFile, pstrFileName, GENERIC_WRITE, 0, 0, \
			    CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0
	mov	hFile, eax
	
	.IF eax==INVALID_HANDLE_VALUE
	    mov	eax,0
	    ret
	.ENDIF

	invoke WriteFile, hFile, ebx, BITMAPFILEHEADER.bfSize[ebx], ADDR dwBytesWritten, 0

	mov	bSuccess, eax

	invoke	CloseHandle, hFile

	mov	eax, dwBytesWritten

	.IF !bSuccess || eax!=BITMAPFILEHEADER.bfSize[ebx]
	    invoke DeleteFile, ADDR pstrFileName
	    mov	eax, FALSE
	.ELSE
	    mov	eax, TRUE
	.ENDIF

	ret
DibSaveImage	endp
;------------------------------------------------------------------------------
OptionsDlg PROC hDlg:HWND,iMsg:DWORD,wParam:WPARAM, lParam:LPARAM

        mov  eax,iMsg
        .IF     eax==WM_INITDIALOG
 
        .ELSEIF eax==WM_COMMAND

	    LOWORD wParam

            .IF eax==IDOK

		invoke  GetDlgItemInt, hDlg,IDC_RULE,NULL,0
                mov  rule,eax;al			; Can be DD value for > 256 rule
		invoke  EndDialog,hDlg,TRUE

	    .ELSEIF eax==IDCANCEL
		invoke  EndDialog,hDlg,FALSE
            .ENDIF

        .ELSE
                mov eax,FALSE
                ret
        .ENDIF

        mov  eax,TRUE
        ret
OptionsDlg endp
;------------------------------------------------------------------------------
Comment ~
AbortFunc	Proc	hdc:DWORD, err:DWORD	; NB: "err" is not used but is
						; needed for system compatability
						; See SDK on AbortProc
;	Printer abort function
;	======================

	LOCAL   message:MSG

	.WHILE	TRUE
	    invoke PeekMessage, ADDR message,0,0,0, PM_REMOVE	; Check for msg

	    .BREAK .IF !eax 			; Break out if no message		

	    invoke IsDialogMessage, hDLG, ADDR message	; If not processed eax = TRUE	

	    .IF !eax 
		invoke TranslateMessage, ADDR message
		invoke DispatchMessage, ADDR message
	    .ENDIF
	 	 	
	.ENDW

	return printOK

	ret

AbortFunc	endp
;------------------------------------------------------------------------------
KillPrint	Proc	hwnd:HWND, msg:UINT, wParam:WPARAM, lParam:LPARAM

	.IF msg==WM_COMMAND

	    LOWORD wParam

	    .IF eax==IDCANCEL

		mov printOK, FALSE
		invoke DestroyWindow, hDLG
		mov hDLG,0
		return 1

	    .ENDIF	 	

	.ENDIF

	return 0

KillPrint	endp ~
;------------------------------------------------------------------------------
Invert		Proc
	
;============================================================================
;	This inverts all lines in the bit map swapping from top to bottom and
;	we progress in this way until the middle of the bitmap is reached
;============================================================================ 	

		LOCAL   rowcount:DWORD

;		Allocate memory  
;	        ---------------
	
                invoke	GlobalAlloc,GMEM_MOVEABLE or GMEM_ZEROINIT, Bbytes
                mov	hMemory,eax
                invoke	GlobalLock,hMemory
		mov	pMemory, eax			; Memory to hold 1 line of data
			
		mov	ebx, 0				; Index for moving rows from top to bottom    
							
		.WHILE  ebx < Bheight*Rwidth*DWORD/2    ; Only need 1/2 the number of rows  
							; as we finish at the centre		

		    mov ecx, Rwidth			; Row width in dwords
		    mov esi, offset pixels		; Point at start of bits
		    add esi, ebx			; Allow for previous row shifts	
		    mov edi, pMemory			; Point at buffer in memory		 			
  	            rep movsd				; Take copy to buffer 
							
		    mov ecx, Rwidth			
		    mov esi, offset pixels		; Point at start of bits
		    add esi, (Bheight-1)*Rwidth*DWORD	; Add offset to start of bottom line 
		    sub esi, ebx			; Allow for previous row shifts
		    mov edi, offset pixels		; Location in inverted data,
		    add edi, ebx			; adjusted to top "target line"		 			
  	            rep movsd				; Update top ; 3 to 1

		    mov ecx, Rwidth			; Finally copy contents of
		    mov esi, pMemory			; buffer to new location  
		    mov edi, offset pixels		; Point at start of bits
		    add edi, (Bheight-1)*Rwidth*DWORD	; Add offset to start of bottom line 
		    sub edi, ebx			; Allow for previous row shifts	
		    rep movsd				; Update bottom

		    add ebx, Rwidth*DWORD		; Increment to next row
		     			    
		.ENDW

                invoke GlobalUnlock,pMemory
                invoke GlobalFree,hMemory

	ret
Invert		endp
;------------------------------------------------------------------------------
PrintSetup	Proc uses ebx, pPrintdlg:DWORD, hwnd:DWORD

	mov ebx, pPrintdlg

	mov PRINTDLG.lStructSize[ebx], SIZEOF PRINTDLG
	M2M PRINTDLG.hwndOwner[ebx],hwnd
  	mov PRINTDLG.hDevMode[ebx],0
  	mov PRINTDLG.hDevNames[ebx],0
  	mov PRINTDLG.hDC[ebx],0
 	mov PRINTDLG.Flags[ebx],PD_RETURNDC or PD_NOSELECTION or PD_NOPAGENUMS 
  	mov PRINTDLG.nFromPage[ebx],0
  	mov PRINTDLG.nToPage[ebx],0
  	mov PRINTDLG.nMinPage[ebx],0
  	mov PRINTDLG.nMaxPage[ebx],0
  	mov PRINTDLG.nCopies[ebx],1
  	mov PRINTDLG.hInstance[ebx],0
  	mov PRINTDLG.lCustData[ebx],0
 	mov PRINTDLG.lpfnPrintHook[ebx],0
	mov PRINTDLG.lpfnSetupHook[ebx],0
  	mov PRINTDLG.lpPrintTemplateName[ebx],0
  	mov PRINTDLG.lpPrintSetupTemplateName[ebx],0
  	mov PRINTDLG.hPrintTemplate[ebx],0
  	mov PRINTDLG.hSetupTemplate[ebx],0
      
	ret
PrintSetup	endp
;------------------------------------------------------------------------------
PrintBMP	Proc hWnd:DWORD, hImage:DWORD

	ret	
PrintBMP	endp
;------------------------------------------------------------------------------
RuleTest	Proc

;	=====================================================================
;	For explanation of rules see Stephen Wolfram's "A New Kind of Science"
;	There are 256 possible rule for a monochrome bitmap
;	=====================================================================
	
			mov eax,0

			.IF     rule==0		; We just get the initial seed
	
			.ELSEIF rule==1		; 1
			  .IF bx==C1		
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==2		; 2
			  .IF bx==C2 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==3		; 2 1
			 .IF bx==C2 || ebx==C1  
  			      mov eax,1
			  .ENDIF

			.ELSEIF rule==4		; 4	
			  .IF bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==5		; 4 1
			  .IF bx==C4 || bx==C1  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==6		; 4 2
			  .IF bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==7		; 4 2 1
			  .IF bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==8		; 8 
			  .IF bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==9		; 8 1
			  .IF (bx==C8 || bx==C1) 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==10	; 8 2
			  .IF bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==11	; 8 2 1
			  .IF bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==12	; 8 4
			  .IF bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==13	; 8 4 1
			  .IF bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==14	; 8 4 2
			    .IF bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==15	; 8 4 2 1  J
			  .IF bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==16	; 16
			  .IF bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==17	; 16 1 
			  .IF bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==18	; 16 2 
			  .IF bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==19	; 16 2 1
			  .IF bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==20	; 16 4
			  .IF bx==C16 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==21	; 16 4 1
			  .IF bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==22	; 16 4 2
			  .IF bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==23	; 16 4 2 1
			  .IF bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==24	; 16 8
			  .IF bx==C16 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==25	; 16 8 1 J
			  .IF bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==26	; 16 8 2
			  .IF bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==27	; 16 8 2 1 J
			  .IF bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
					
			.ELSEIF rule==28	; 16 8 4
			  .IF bx==C16 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==29	; 16 8 4 1
			  .IF bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==30	; 16 8 4 2
			  .IF bx== C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==31	; 16 8 4 2 1
			  .IF bx== C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==32	; 32
			  .IF bx==C32
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==33	; 32 1
			  .IF bx==C32 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==34	; 32 2
			   .IF bx==C32 || bx==C2
			      mov eax,1
			   .ENDIF

			.ELSEIF rule==35	; 32 2 1
			   .IF 	bx==C32 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
 
			.ELSEIF rule==36	; 32 4
			   .IF bx==C32 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==37	; 32 4 1
			   .IF bx==C32 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==38	; 32 4 2
			   .IF bx==C32 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==39	; 32 4 2 1
			   .IF bx==C32 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==40	; 32 8
			   .IF bx==C32 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==41	; 32 8 1 Junk
			   .IF 	bx==C32 || bx==C8 || bx==C1			
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==42	; 32 8 2
			   .IF  bx==C32 || bx==C8 || bx==C2			
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==43	; 32 8 2 1 J
			   .IF 	bx==C32 || bx==C8 || bx==C2 || bx==C1		
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==44	; 32 8 4
			   .IF bx==C32 || bx==C8 || bx==C4 			
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==45	; 32 8 4 1 J
			  .IF bx==C32 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==46	; 32 8 4 2
			  .IF bx==C32 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==47	; 32 8 4 2 1
			  .IF bx==C32 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==48	; 32 16
			  .IF bx==C32 || bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==49	; 32 16 1
			  .IF bx==C32 || bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==50	; 32 16 2
			  .IF bx==C32 || bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==51	; 32 16 2 1
			  .IF bx==C32 || bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==52	; 32 16 4
			  .IF bx==C32 || bx==C16 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==53	; 32 16 4 1
			  .IF bx==C32 || bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==54	; 32 16 4 2
			  .IF bx==C32 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF
								   
			.ELSEIF rule==55	; 32 16 4 2 1
			  .IF bx==C32 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==56	; 32 16 8
			  .IF bx==C32 || bx==C16 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==57	; 32 16 8 1 J
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==58	; 32 16 8 2
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==59	; 32 16 8 2 1 junk
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==60	; 32 16 8 4 	
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==61	; 32 16 8 4 1
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==62	; 32 16 8 4 2
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==63	; 32 16 8 4 2 1
			  .IF bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==64	; 64 
			  .IF bx==C64
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==65	; 64 1 J 
			  .IF bx==C64 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==66	; 64 2
			  .IF bx==C64 || bx==C2 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==67	; 64 2 1 J
			  .IF bx==C64 || bx==C2 || bx==C1
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==68	; 64 4
			  .IF bx==C64 || bx==C4 
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==69	; 64 4 1 J
			  .IF bx==C64 || bx==C4 || bx==C1
			      mov eax,1
		          .ENDIF
			
			.ELSEIF rule==70	; 64 4 2
			  .IF bx==C64 || bx==C4 || bx==C2
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==71	; 64 4 2 1
			  .IF bx==C64 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==72	; 64 8
			  .IF bx==C64 || bx==C8
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==73	; 64 8 1 J
			  .IF bx==C64 || bx==C8 || bx==C1 
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==74	; 64 8 2
			  .IF bx==C64 || bx==C8 || bx==C2
			      mov eax,1
		          .ENDIF

			.ELSEIF rule==75	; 64 8 2 1 J 	
			  .IF bx==C64 || bx==C8 || bx==C2 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==76	; 64 8 4 	
			  .IF bx==C64 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==77	; 64 8 4 1 J	
			  .IF bx==C64 || bx==C8 || bx==C4 || bx==C1 
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==78	; 64 8 4 2	
			  .IF bx==C64 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==79	; 64 8 4 2 1 J	
			  .IF bx==C64 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==80	; 64 16	
			  .IF bx==C64 || bx==C16 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==81	; 64 16 1 J	
			  .IF bx==C64 || bx==C16 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==82	; 64 16 2	
			  .IF bx==C64 || bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==83	; 64 16 2 1 J	
			  .IF bx==C64 || bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==84	; 64 16 4	
			  .IF bx==C64 || bx==C16 || bx==C4 
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==85	; 64 16 4 1 J	
			  .IF bx==C64 || bx==C16 || bx==C4 || bx==C1 
			      mov eax,1
			  .ENDIF

 			.ELSEIF rule==86	; 64 16 4 2
			  .IF bx==C64 || bx==C16 || bx==C4 || bx==C2 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==87	; 64 16 4 2 1
			  .IF bx==C64 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==88	; 64 16 8
			  .IF bx==C64 || bx==C16 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==89	; 64 16 8 1 J
			   .IF bx==C64 || bx==C16 || bx==C8 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==90	; 64 16 8 2
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C2  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==91	; 64 16 8 2 1
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C2 || bx==C1  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==92	; 64 16 8 4
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==93	; 64 16 8 4 1 J
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==94	; 64 16 8 4 2
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==95	; 64 16 8 4 2 1
			  .IF bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1  
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==96	; 64 32
			  .IF bx==C64 || bx==C32 
			      mov eax,1
 			  .ENDIF
			
			.ELSEIF rule==97	; 64 32 1 J
			  .IF bx==C64 || bx==C32 || bx==C1  
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==98	; 64 32 2
			  .IF bx==C64 || bx==C32 || bx==C2  
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==99	; 64 32 2 1 J
			  .IF bx==C64 || bx==C32 || bx==C2 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==100	; 64 32 4
			  .IF bx==C64 || bx==C32 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==101	; 64 32 4 1 J
			  .IF bx==C64 || bx==C32 || bx==C4 || bx==C1  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==102	; 64 32 4 2	
			  .IF bx==C64 || bx==C32 || bx==C4 || bx==C2  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==103	; 64 32 4 2 1
			  .IF bx==C64 || bx==C32 || bx==C4 || bx==C2 || bx==C1    
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==104	; 64 32 8
			  .IF bx==C64 || bx==C32 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==105	; 64 32 8 1	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==106	; 64 32 8 2	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C2  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==107	; 64 32 8 2 1	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C2 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==108	;  64 32 8 4	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==109	; 64 32 8 4 1	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C4  || bx==C1    
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==110	; 64 32 8 4 2   	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C4 || bx==C2    
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==111	; 64 32 8 4 2 1 J   	
			  .IF bx==C64 || bx==C32 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==112	; 64 32 16   	
			  .IF  bx==C64 || bx==C32 || bx==C16  
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==113	; 64 32 16 1 J 	
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==114	; 64 32 16 2  	
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C2  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==115	; 64 32 16 2 1 J	
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C2 || bx==C1  
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==116	; 64 32 16 4
			  .IF  bx==C64 || bx==C32 || bx==C16 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==117	; 64 32 16 4 1 J
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==118	; 64 32 16 4 2
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==119	; 64 32 16 4 2 1
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==120	; 64 32 16 8
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==121	; 64 32 16 8 1 J
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==122	; 64 32 16 8 2
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==123	; 64 32 16 8 2 1
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==124	; 64 32 16 8 4
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF
				
			.ELSEIF rule==125	; 64 32 16 8 4 1
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==126	; 64 32 16 8 4 2
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==127	; 64 32 16 8 4 2 1
			  .IF bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==128	; 128
			  .IF bx==C128
			      mov eax,1
			  .ENDIF

	 		.ELSEIF rule==129	; 128 1
			  .IF bx==C128 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==130	; 128 2
			  .IF bx==C128 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==131	; 128 2 1 J
			  .IF bx==C128 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==132	; 128 4
			  .IF bx==C128 || bx==C4
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==133	; 128 4 1 J
			  .IF bx==C128 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==134	; 128 4 2
			  .IF bx==C128 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==135	; 128 4 2 1 J
			  .IF bx==C128 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==136	; 128 8
			  .IF bx==C128 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==137	; 128 8 1 J
			  .IF bx==C128 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==138	; 128 8 2
			  .IF bx==C128 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==139	; 128 8 2 1 J
			  .IF bx==C128 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==140	; 128 8 4
			  .IF bx==C128 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==141	; 128 8 4 1 J
			  .IF bx==C128 || bx==C8 || bx==C4 || bx==C1					 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==142	; 128 8 4 2
			  .IF bx==C128 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==143	; 128 8 4 2 1 J
			  .IF bx==C128 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==144	; 128 16
			  .IF bx==C128 || bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==145	; 128 16 1 J
			  .IF bx==C128 || bx==C16 || bx==C1	 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==146	; 128 16 2
			  .IF bx==C128 || bx==C16 || bx==C2	 
			      mov eax,1
			  .ENDIF
								
			.ELSEIF rule==147	; 128 16 2 1 J
			  .IF bx==C128 || bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==148	; 128 16 4 J
			  .IF bx==C128 || bx==C16 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==149	; 128 16 4 1 J
			  .IF bx==C128 || bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==150	; 128 16 4 2
			  .IF bx==C128 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==151	; 128 16 4 2 1 J
			  .IF bx==C128 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==152	; 128 16 8
			  .IF bx==C128 || bx==C16 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==153	; 128 16 8 1 J
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==154	; 128 16 8 2
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==155	; 128 16 8 2 1 J
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==156	; 128 16 8 4 J
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==157	; 128 16 8 4 1 J
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==158	; 128 16 8 4 2
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==159	; 128 16 8 4 2 1 J
			  .IF bx==C128 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1	
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==160	; 128 32
			  .IF bx==C128 || bx==C32
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==161	; 128 32 1 J
			  .IF bx==C128 || bx==C32 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==162	; 128 32 2
			  .IF bx==C128 || bx==C32 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==163	; 128 32 2 1 J
			  .IF bx==C128 || bx==C32 || bx==C2 || bx==C1	
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==164	; 128 32 4
			  .IF  bx==C128 || bx==C32 || bx==C4 
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==165	; 128 32 4 1 J
			  .IF bx==C128 || bx==C32 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==166	; 128 32 4 2
			  .IF bx==C128 || bx==C32 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==167	; 128 32 4 2 1 J
			  .IF bx==C128 || bx==C32 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==168	; 128 32 8
			  .IF bx==C128 || bx==C32 || bx==C8 
			      mov eax,1
			  .ENDIF	

		        .ELSEIF rule==169	; 128 32 8 1 J
			  .IF bx==C128 || bx==C32 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==170	; 128 32 8 2
			  .IF bx==C128 || bx==C32 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==171	; 128 32 8 2 1 J
			  .IF  bx==C128 || bx==C32 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==172	; 128 32 8 4
			  .IF bx==C128 || bx==C32 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==173	; 128 32 8 4 1 J
			  .IF bx==C128 || bx==C32 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF
		        
			.ELSEIF rule==174	; 128 32 8 4 2
			  .IF bx==C128 || bx==C32 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF
		           
			.ELSEIF rule==175	; 128 32 8 4 2 1 J
			  .IF  bx==C128 || bx==C32 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==176	; 128 32 16
			  .IF bx==C128 || bx==C32 || bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==177	; 128 32 16 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==178	; 128 32 16 2
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==179	; 128 32 16 2 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
		
		        .ELSEIF rule==180	; 128 32 16 4
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C4
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==181	; 128 32 16 4 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C4 || bx==C1 
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==182	; 128 32 16 4 2
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==183	; 128 32 16 4 2 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==184	; 128 32 16 8
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==185	; 128 32 16 8 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==186	; 128 32 16 8 2
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==187	; 128 32 16 8 2 1 J
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==188	; 128 32 16 8 4
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==189	; 128 32 16 8 4 1
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==190	; 128 32 16 8 4 2
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==191	; 128 32 16 8 4 2 1
			  .IF bx==C128 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==192	; 128 64
			  .IF  bx==C128 || bx==C64
			      mov eax,1
			  .ENDIF
		    
	 		.ELSEIF rule==193	; 128 64 1
			  .IF  bx==C128 || bx==C64 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==194	; 128 64 2
			  .IF bx==C128 || bx==C64 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==195	; 128 64 2 1
			  .IF bx==C128 || bx==C64 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==196	; 128 64 4
			  .IF bx==C128 || bx==C64 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==197	; 128 64 4 1
			  .IF  bx==C128 || bx==C64 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==198	; 128 64 4 2
			  .IF bx==C128 || bx==C64 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==199	; 128 64 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==200	; 128 64 8
			  .IF bx==C128 || bx==C64 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==201	; 128 64 8 1
			  .IF  bx==C128 || bx==C64 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==202	; 128 64 8 2
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==203	; 128 64 8 2 1
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==204	; 128 64 8 4
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==205	; 128 64 8 4 1
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==206	; 128 64 8 4 2
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==207	; 128 64 8 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==208	; 128 64 16
			  .IF bx==C128 || bx==C64 || bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==209	; 128 64 16 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==210	; 128 64 16 2
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==211	; 128 64 16 2 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C2 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==212	; 128 64 16 4
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C4 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==213	; 128 64 16 4 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==214	; 128 64 16 4 2
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
		  	.ENDIF

			.ELSEIF rule==215	; 128 64 16 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==216	; 128 64 16 8
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==217	; 128 64 16 8 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C1	 
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==218	; 128 64 16 8 2
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C2	 
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==219	; 128 64 16 8 2 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C2 || bx==C1	 
			      mov eax,1
			  .ENDIF
		
			.ELSEIF rule==220	; 128 64 16 8 4
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C4	 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==221	; 128 64 16 8 4 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C1	 
			      mov eax,1
			  .ENDIF
				
			.ELSEIF rule==222	; 128 64 16 8 4 2
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C2 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==223	; 128 64 16 8 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1	 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==224	; 128 64 32
			  .IF bx==C128 || bx==C64 || bx==C32 
			      mov eax,1
			  .ENDIF
								
			.ELSEIF rule==225	; 128 64 32 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==226	; 128 64 32 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C2
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==227	; 128 64 32 2 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
				
			.ELSEIF rule==228	; 128 64 32 4
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==229	; 128 64 32 4 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C4 || ebx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==230	; 128 64 32 4 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C4 || ebx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==231	; 128 64 32 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C4 || ebx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==232	; 128 64 32 8
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==233	; 128 64 32 8 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C1 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==234	; 128 64 32 8 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C2 
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==235	; 128 64 32 8 2 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
			
			.ELSEIF rule==236	; 128 64 32 8 4
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==237	; 128 64 32 8 4 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C4 || ebx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==238	; 128 64 32 8 4 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C4 || ebx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==239	; 128 64 32 8 4 2 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C8 || bx==C4 || ebx==C2 || ebx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==240	; 128 64 32 16
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==241	; 128 64 32 16 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==242	; 128 64 32 16 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==243	; 128 64 32 16 2 1 J
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==244	; 128 64 32 16 4
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C4
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==245	; 128 64 32 16 4 1
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==246	; 128 64 32 16 4 2
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C2
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==247	; 128 64 32 16 4 2 1
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==248	; 128 64 32 16 8
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8
			      mov eax,1
			  .ENDIF

			.ELSEIF rule==249	; 128 64 32 16 8 1
		          .IF  bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==250	; 128 64 32 16 8 2
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C2
			      mov eax,1
			  .ENDIF

			 .ELSEIF rule==251	; 128 64 32 16 8 2 1	
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF

			 .ELSEIF rule==252	; 128 64 32 16 8 4	
		          .IF  bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 
			      mov eax,1
			  .ENDIF

			 .ELSEIF rule==253	; 128 64 32 16 8 4 1	
		          .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C1
			      mov eax,1
			  .ENDIF

		        .ELSEIF rule==254	; 128 64 32 16 8 4 2
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2
			    mov eax,1
 			  .ENDIF

			.ELSEIF rule==255	; 128 64 32 16 8 4 2 1	
			  .IF bx==C128 || bx==C64 || bx==C32 || bx==C16 || bx==C8 || bx==C4 || bx==C2 || bx==C1
			      mov eax,1
			  .ENDIF
 			  
	                .ENDIF
	ret
RuleTest	endp
;------------------------------------------------------------------------------
      end start
