;Netguard 1.2 (c) CodeMill by Saadam
;-----------------------------------
.386
.Model Flat,StdCall

Include Win32Api.Inc

Extrn           CloseHandle        : Proc
Extrn           CreateDialogParamA : Proc
Extrn           CreateFileA        : Proc
Extrn           DefWindowProcA     : Proc
Extrn           DispatchMessageA   : Proc
Extrn           ExitProcess        : Proc
Extrn           FindWindowA        : Proc
Extrn           GetDlgItem         : Proc
Extrn           GetDlgItemTextA    : Proc
Extrn           GetModuleHandleA   : Proc
Extrn           GetMessageA        : Proc
Extrn           GetSystemMetrics   : Proc
Extrn           GetWindowRect      : Proc
Extrn           GlobalAlloc        : Proc
Extrn           GlobalFree         : Proc
Extrn           GlobalLock         : Proc
Extrn           GlobalUnlock       : Proc
Extrn           IsDialogMessage    : Proc
Extrn           LoadIconA          : Proc
Extrn           LoadCursorA        : Proc
Extrn           MoveWindow         : Proc
Extrn           NetSessionEnum     : Proc
Extrn           NetSessionDel      : Proc
Extrn           PostQuitMessage    : Proc
Extrn           ReadFile           : Proc
Extrn           RegisterClassExA   : Proc
Extrn           SendMessageA       : Proc
Extrn           SetFocus           : Proc
Extrn		SetForegroundWindow: Proc
Extrn           SetTimer           : Proc
Extrn           Shell_NotifyIconA  : Proc
Extrn           ShowWindow         : Proc
Extrn           TranslateMessage   : Proc
Extrn           UpdateWindow       : Proc
Extrn           WriteFile          : Proc

.Const

BST_UNCHECKED   equ              0
BST_CHECKED     equ              1
SC_MINIMIZE     equ              61472
WM_TRAYICON     equ              WM_USER+1
IDD_MAIN        equ              101
IDI_ICON        equ              102


ID_TIMER        equ              1
IDC_RADIO1      equ              1001
IDC_RADIO2      equ              1002
IDC_RADIO3      equ              1003
IDC_RADIO4      equ              1004
IDC_LIST        equ              1005
IDC_EDIT        equ              1006
IDC_BUTTON1     equ              1007
IDC_BUTTON2     equ              1008

GMEM_MOVABLE    equ              02h
GMEM_ZEROINIT   equ              40h

.Data

Mode            db               01
CfgSave         db               FALSE
CfgName         db               'c:\windows\netguard.cfg',0
CfgHandle       HANDLE           ?
hInstance       HMODULE          0
WinClass        WNDCLASSEX       ?
ClassName       db               'CM',0
WinName         db               'Netguard',0
hDlg            HWND             0
hList           HWND             0
hEdit           HWND             0
Msg             MSG              ?
TrayIcon        NOTIFYICONDATA   <size TrayIcon,0,0,NIF_ICON+NIF_MESSAGE,WM_TRAYICON>
TextBuf         db               260 dup (0)
WinPos          RECT             ?
Count           dd               0
Count1          dd               0

Read            dw      0
Total           dw      0
BufSize         dd      1024
hMem            dd      ?
Buffer          LPVOID  ?

.Code

Start:          call    GetModuleHandleA,NULL
                mov     [hInstance],eax
                call    FindWindowA,offset ClassName,offset WinName
                or      eax,eax
                jnz     Stop
                call    WinMain
Stop:           call    ExitProcess,eax

WinMain:        mov     [WinClass.wce_cbSize],size WNDCLASSEX
                mov     [WinClass.wce_style],CS_HREDRAW+CS_VREDRAW
                mov     [WinClass.wce_lpfnWndProc],offset WndProc
                mov     [WinClass.wce_cbClsExtra],0
                mov     [WinClass.wce_cbWndExtra],DLGWINDOWEXTRA
                push    [hInstance]
                pop     [WinClass.wce_hInstance]
                call    LoadIconA,[hInstance],IDI_ICON
                mov     [WinClass.wce_hIcon],eax
                mov     [TrayIcon.nid_hIcon],eax
                call    LoadCursorA,NULL,IDC_ARROW
                mov     [WinClass.wce_hCursor],eax
                mov     [WinClass.wce_hbrBackground],COLOR_BACKGROUND
                mov     [WinClass.wce_lpszMenuName],NULL
                mov     [WinClass.wce_lpszClassName],offset ClassName
                mov     [WinClass.wce_hIconSm],NULL
                call    RegisterClassExA,offset WinClass
                call    CreateDialogParamA,[hInstance],IDD_MAIN,0,NULL,0
                mov     [hDlg],eax
                mov     [TrayIcon.nid_hWnd],eax
                call    Shell_NotifyIconA,NIM_ADD,offset TrayIcon
                call    GetDlgItem,[hDlg],IDC_LIST
                mov     [hList],eax
                call    GetDlgItem,[hDlg],IDC_EDIT
                mov     [hEdit],eax
                call    SetFocus,eax
                call    GetDlgItem,[hDlg],IDC_RADIO1
                call    SendMessageA,eax,BM_SETCHECK,BST_CHECKED,0
                call    RestoreConfig
                call    ShowWindow,[hDlg],SW_HIDE
                mov     byte ptr [CfgSave],TRUE
                call    SetTimer,[hDlg],ID_TIMER,1,NULL
MsgLoop:        call    GetMessageA,offset Msg,NULL,0,0
                or      eax,eax
                jz      WinMainEnd
                call    IsDialogMessage,[hDlg],offset Msg
                or      eax,eax
                jnz     MsgLoop
                call    TranslateMessage,offset Msg
                call    DispatchMessageA,offset Msg
                jmp     MsgLoop
WinMainEnd:     ret

WndProc         proc    wp_hwnd:HWND,wp_uMsg:UINT,wp_wParam:WPARAM,wp_lParam:LPARAM

                mov     eax,[wp_uMsg]
                cmp     eax,WM_TIMER
                jz      WinTimer
                cmp     eax,WM_SYSCOMMAND
                jz      WinSysCommand
                cmp     eax,WM_TRAYICON
                jz      WinTrayIcon
                cmp     eax,WM_DESTROY
                jz      WinDestroy
                cmp     eax,WM_COMMAND
                jz      WinCommand
                cmp     eax,WM_MOVE
                jz      WinMove
WndProcExit:    call    DefWindowProcA,[wp_hwnd],[wp_uMsg],[wp_wParam],[wp_lParam]
WndProcEnd:     ret

WinTimer:       mov     eax,[wp_wParam]
                cmp     eax,ID_TIMER
                jnz     WndProcExit
                movzx   eax,byte ptr [Mode]
                cmp     eax,01h
                jz      WinTimerEnd
                call    NetList
WinTimerEnd:    jmp     WndProcEnd

WinSysCommand:  mov     eax,[wp_wParam]
                cmp     eax,SC_MINIMIZE
                jnz     WndProcExit
                call    ShowWindow,[hDlg],SW_MINIMIZE
                call    ShowWindow,[hDlg],SW_HIDE
                jmp     WndProcEnd

WinTrayIcon:    mov     eax,[wp_lParam]
                cmp     eax,WM_LBUTTONDBLCLK
                jz      ShowDialog
                jmp     WndProcEnd
ShowDialog:     call    ShowWindow,[hDlg],SW_SHOW
                call    ShowWindow,[hDlg],SW_NORMAL
		call	SetForegroundWindow,[hDlg]
                jmp     WndProcEnd

WinDestroy:     call    Shell_NotifyIconA,NIM_DELETE,offset TrayIcon
                call    PostQuitMessage,NULL
                jmp     WndProcEnd

WinCommand:     mov     eax,[wp_lParam]
                or      eax,eax
                jz      WndProcExit
                mov     eax,[wp_wParam]
                cmp     ax,IDC_BUTTON1
                jnz     NextButton
                shr     eax,16
                cmp     ax,BN_CLICKED
                jnz     WndProcEnd
                call    GetDlgItemTextA,[hDlg],IDC_EDIT,offset TextBuf,260
                mov     esi,offset TextBuf
                call    UpCaseString
                call    SendMessageA,[hList],LB_FINDSTRING,-1,offset TextBuf
                cmp     eax,LB_ERR
                jnz     WndProcEnd
                call    SendMessageA,[hList],LB_ADDSTRING,0,offset TextBuf
SaveCfg:        call    SaveConfig
                jmp     WndProcEnd
NextButton:     cmp     ax,IDC_BUTTON2
                jnz     NextButton1
                shr     eax,16
                cmp     ax,BN_CLICKED
                jnz     WndProcEnd
                call    SendMessageA,[hList],LB_GETCURSEL,0,0
                cmp     eax,LB_ERR
                jz      WndProcEnd
                call    SendMessageA,[hList],LB_DELETESTRING,eax,0
                jmp     SaveCfg
NextButton1:    cmp     ax,IDC_RADIO1
                jnz     NextButton2
                mov     byte ptr [Mode],01
                jmp     SaveCfg
NextButton2:    cmp     eax,IDC_RADIO2
                jnz     NextButton3
                mov     byte ptr [Mode],02
                jmp     SaveCfg
NextButton3:    cmp     eax,IDC_RADIO3
                jnz     NextButton4
                mov     byte ptr [Mode],03
                jmp     SaveCfg
NextButton4:    cmp     eax,IDC_RADIO4
                jnz     WndProcExit
                mov     byte ptr [Mode],04
                jmp     SaveCfg

WinMove:        jmp     SaveCfg

WndProc         endp

UpCaseString:   mov     al,[esi]
                cmp     al,'a'
                jb      NextUp
                cmp     al,'z'
                ja      NextUp
                sub     al,20h
                mov     [esi],al
NextUp:         cmp     al,00h
                jz      UpCaseEnd
                inc     esi
                jmp     UpCaseString
UpCaseEnd:      ret

SaveConfig:     cmp     byte ptr [CfgSave],TRUE
                jnz     SaveError
                call    GetWindowRect,[hDlg],offset WinPos
                call    GetSystemMetrics,SM_CXFULLSCREEN
                cmp     eax,[WinPos.r_left]
                jbe     SaveError
                call    GetSystemMetrics,SM_CYFULLSCREEN
                cmp     eax,[WinPos.r_top]
                jbe     SaveError
                call    CreateFileA,offset CfgName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL
                cmp     eax,INVALID_HANDLE_VALUE
                jz      SaveError
                mov     [CfgHandle],eax
                call    WriteFile,[CfgHandle],offset Mode,size Mode,offset Count,NULL
                call    WriteFile,[CfgHandle],offset WinPos,size WinPos,offset Count,NULL
                call    SendMessageA,[hList],LB_GETCOUNT,0,0
                mov     [Count1],eax
                xchg    eax,ebx
                call    WriteFile,[CfgHandle],offset Count1,size Count1,offset Count,NULL
MoreList:       or      ebx,ebx
                jz      NoMoreList
                dec     ebx
                call    SendMessageA,[hList],LB_GETTEXTLEN,ebx,0
                mov     [Count1],eax
                call    WriteFile,[CfgHandle],offset Count1,size Count1,offset Count,NULL
                call    SendMessageA,[hList],LB_GETTEXT,ebx,offset TextBuf
                call    WriteFile,[CfgHandle],offset TextBuf,[Count1],offset Count,NULL
                jmp     MoreList
NoMoreList:     call    CloseHandle,[CfgHandle]
SaveError:      ret

RestoreConfig:  call    CreateFileA,offset CfgName,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
                cmp     eax,INVALID_HANDLE_VALUE
                jz      RestoreError
                mov     [CfgHandle],eax
                call    ReadFile,[CfgHandle],offset Mode,size Mode,offset Count,NULL
                mov     bl,1
NextSet:        movzx   eax,bl
                add     eax,IDC_RADIO1
                dec     eax
                call    GetDlgItem,[hDlg],eax
                mov     ecx,BST_UNCHECKED
                cmp     bl,[Mode]
                jnz     SetButton
                mov     ecx,BST_CHECKED
SetButton:      call    SendMessageA,eax,BM_SETCHECK,ecx,0
                inc     bx
                cmp     bx,4
                jbe     NextSet
                call    ReadFile,[CfgHandle],offset WinPos,size WinPos,offset Count,NULL
                mov     eax,[WinPos.r_right]
                sub     eax,[WinPos.r_left]
                mov     ecx,[WinPos.r_bottom]
                sub     ecx,[WinPos.r_top]
                call    MoveWindow,[hDlg],[WinPos.r_left],[WinPos.r_top],eax,ecx,TRUE
                call    ReadFile,[CfgHandle],offset Count1,size Count1,offset Count,NULL
                mov     ebx,[Count1]
MoreAdd:        or      ebx,ebx
                jz      NoMoreAdd
                dec     ebx
                call    ReadFile,[CfgHandle],offset Count1,size Count1,offset Count,NULL
                call    ReadFile,[CfgHandle],offset TextBuf,[Count1],offset Count,NULL
                mov     eax,[Count1]
                add     eax,offset TextBuf
                mov     byte ptr [eax],0
                call    SendMessageA,[hList],LB_ADDSTRING,0,offset TextBuf
                jmp     MoreAdd
NoMoreAdd:      call    CloseHandle,[CfgHandle]
RestoreError:   ret

Exist:          push    ebx
                xor     edx,edx
                mov     edi,[esi]
ChkStr:         cmp     byte ptr [edi],0
                jz      EndStr
                inc     edx
                inc     edi
                jmp     ChkStr
EndStr:         mov     [Count],edx
                call    SendMessageA,[hList],LB_GETCOUNT,0,0
                xchg    ebx,eax
NextData:       or      ebx,ebx
                jz      NoData
                dec     ebx
                call    SendMessageA,[hList],LB_GETTEXTLEN,ebx,0
                cmp     eax,[Count]
                jnz     NextData
                call    SendMessageA,[hList],LB_GETTEXT,ebx,offset TextBuf
                mov     edx,[Count]
                mov     edi,[esi]
                mov     ecx,offset TextBuf
CmpStr:         mov     al,[edi]
                cmp     al,[ecx]
                jnz     NextData
                inc     edi
                inc     ecx
                dec     edx
                jnz     CmpStr
                stc
                pop     ebx
                ret
NoData:         clc
                pop     ebx
                ret

Disconnect:     mov     eax,[esi]
                mov     ecx,[esi+8]
                call    NetSessionDel,NULL,eax,ecx
                ret

NetList:        call    GlobalAlloc,GMEM_MOVABLE+GMEM_ZEROINIT,[BufSize]
                or      eax,eax
                jz      NetStop
                mov     [hMem],eax
                call    GlobalLock,eax
                or      eax,eax
                jz      NetStop
                mov     [Buffer],eax
                call    NetSessionEnum,NULL,50,[Buffer],[BufSize],offset Read,offset Total
                cmp     eax,ERROR_SUCCESS
                jnz     FreeMemory
                push    eax
                mov     esi,[Buffer]
HaveInfo:       mov     bx,word ptr [Read]
NextInfo:       or      bx,bx
                jz      EndInfo
                dec     bx
                mov     al,[Mode]
                cmp     al,4
                jnz     ChkMode3
                call    Disconnect
                jmp     NextUser
ChkMode3:       cmp     al,3
                jnz     ChkMode2
                call    Exist
                jnc     NextUser
                call    Disconnect
                jmp     NextUser
ChkMode2:       call    Exist
                jc      NextUser
                call    Disconnect
NextUser:       add     esi,26
                jmp     NextInfo
EndInfo:        pop     eax
FreeMemory:     push    eax
                call    GlobalUnlock,[Buffer]
                call    GlobalFree,[hMem]
                pop     eax
                cmp     eax,ERROR_MORE_DATA
                jnz     NetStop
                mov     eax,[BufSize]
                add     eax,1024
                cmp     eax,65535
                ja      NetStop
                mov     [BufSize],eax
                jmp     NetList
NetStop:        ret

End Start