;## INCLUDED LIBRARIES ####################################################

include    \masm32\include\windows.inc

include    \masm32\include\user32.inc
include    \masm32\include\kernel32.inc
include    \masm32\include\gdi32.inc
include    \masm32\include\shell32.inc
include    \masm32\include\advapi32.inc

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\gdi32.lib
includelib \masm32\lib\shell32.lib
includelib \masm32\lib\advapi32.lib

;## MACROS ################################################################

m2m MACRO M1:REQ, M2:REQ
   push M2
   pop M1
ENDM

return MACRO arg:REQ
    mov eax, arg
    ret
ENDM

CopyMemory MACRO cmDest:REQ, cmSource:REQ, cmSize:REQ
    pushad
    cld
    mov edi, cmDest
    mov esi, cmSource
    mov ecx, cmSize
    shr ecx, 2
    rep movsd

    mov ecx, cmSize
    and ecx, 3
    rep movsb
    popad
ENDM

;## PROTOTYPES ############################################################

WinMain             PROTO :DWORD,:DWORD,:DWORD,:DWORD
WinProc             PROTO :DWORD,:DWORD,:DWORD,:DWORD
NoteProc            PROTO :DWORD,:DWORD,:DWORD,:DWORD
RestartApp          PROTO
Load                PROTO :DWORD
ShowWindowsCallback PROTO :DWORD,:DWORD
HideWindowsCallback PROTO :DWORD,:DWORD
SaveWindowsCallback PROTO :DWORD,:DWORD
EditorProc          PROTO :DWORD,:DWORD,:DWORD,:DWORD
SettingsProc        PROTO :DWORD,:DWORD,:DWORD,:DWORD

MakeWindow          PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
SetOnTop            PROTO :DWORD,:DWORD
ExtractFileName     PROTO :DWORD,:DWORD

dwtoa				PROTO :DWORD,:DWORD
atodw				PROTO :DWORD

;## MODULES ###############################################################

include Dialogs.asm
include Win32.asm

;##########################################################################