.code
;==========================================================================

MakeWindow PROC wClassName :DWORD, wTitle :DWORD, wStyle :DWORD, x :DWORD, y :DWORD, w :DWORD, h :DWORD, wProc :DWORD, hinstance :DWORD, wIconID :DWORD, wMenuID :DWORD

;***PUT LOCALS ON STACK***
    LOCAL wClass  :WNDCLASSEX
    LOCAL hWnd    :DWORD
    LOCAL hIcon   :DWORD

;***LOAD ICON***
    invoke LoadIcon, hinstance, wIconID
    mov hIcon, eax

;***MAKE CLASS***
    mov wClass.cbSize, sizeof WNDCLASSEX
    mov wClass.style,  CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW or CS_DBLCLKS
    m2m wClass.lpfnWndProc, wProc
    mov wClass.cbClsExtra, NULL
    mov wClass.cbWndExtra, NULL
    m2m wClass.hInstance, hinstance
    mov wClass.hbrBackground, COLOR_BTNFACE+1
    m2m wClass.lpszClassName, wClassName
    mov wClass.lpszMenuName, NULL
    invoke LoadCursor, NULL, IDC_ARROW
           mov wClass.hCursor, eax
    m2m wClass.hIcon, hIcon
    m2m wClass.hIconSm, hIcon
    invoke RegisterClassEx, ADDR wClass

;***CREATE WINDOW***
    invoke CreateWindowEx, NULL,
                           wClassName,
                           wTitle,
                           wStyle,
                           x,
                           y,
                           w,
                           h,
                           NULL,
                           NULL,
                           hinstance,
                           NULL
    cmp eax, 0
    jnz ok
        ret
    ok:
    mov hWnd, eax

;***ADD MENU***
    .if wMenuID > 0
        invoke LoadMenu, hinstance, wMenuID
        invoke SetMenu, hWnd, eax
    .endif

    return hWnd
MakeWindow  ENDP    
;==========================================================================

SetOnTop PROC hWindow :DWORD, OnTop :DWORD

    .if OnTop > 0
        invoke SetWindowPos, hWindow, -1, 0, 0, 0, 0, 3
    .else
        invoke SetWindowPos, hWindow, -2, 0, 0, 0, 0, 3
    .endif
    ret
SetOnTop    ENDP
;==========================================================================

ExtractFileName PROC hPathBuffer :DWORD, hResultBuffer :DWORD

    LOCAL   FindData    :WIN32_FIND_DATA

    invoke FindFirstFile, hPathBuffer, ADDR FindData
    cmp eax, INVALID_HANDLE_VALUE
    jnz ExtractFileFound
        xor eax, eax
        ret
    ExtractFileFound:
    invoke FindClose, eax

    ;//Copy file name in 8.3 format to hResultBuffer:
    lea eax, FindData.cFileName
    push eax
    invoke lstrlen, eax
    mov ebx, eax
    pop eax
    CopyMemory hResultBuffer, eax, ebx
    invoke lstrlen, hResultBuffer
    push eax

    ;//Remove extension
    mov ebx, hResultBuffer
    mov ecx, eax
    inc ecx
    @@:
        mov al, BYTE PTR[ebx+ecx]
        .if al == '.'
            mov BYTE PTR[ebx+ecx], 0
            jmp @F
        .endif
    loop @B
    @@:

    mov eax, TRUE
    ret
ExtractFileName ENDP