.386
.model flat,stdcall

include c:\masm\include\Windows.inc
include c:\masm\include\Kernel32.inc
include c:\masm\include\User32.inc
include c:\masm\include\ComCtl32.inc
includelib c:\masm\lib\kernel32.lib
includelib c:\masm\lib\User32.lib
includelib c:\masm\lib\ComCtl32.lib

.data
ReBarClassName db "ReBarWindow32",0
BlankText dd 0
hInstance dd 0
WhWnd dd 0
MsgCaption db "Error",0
MsgText db "An error has occurred, unable to create the rebar",0
MsgText1 db "ReBar control has not been created",0
MsgText2 db "Unable to create a rebar band",0
ToolBarClassName db "ToolbarWindow32",0
ReBarHwnd dd 0

.data?
ControlClassName db 15 dup(?),0
.const

.code
DllCODE proc hInst:HINSTANCE, reason:DWORD, reserved1:DWORD
mov  eax,TRUE
ret
DllCODE endp

LoadCommonControls proc
  LOCAL CcEx:INITCOMMONCONTROLSEX
  mov CcEx.dwSize, SIZEOF INITCOMMONCONTROLSEX
  mov CcEx.dwICC, ICC_COOL_CLASSES
  Invoke InitCommonControlsEx, addr CcEx
  ret
LoadCommonControls endp

CreateReBarControl proc hWnd:HWND, WidthR:DWORD, HeightR:DWORD, VerticalR:DWORD, hInst:HINSTANCE
Local ReBarStyle:DWORD
  push hWnd
  pop WhWnd
  .IF VerticalR==FALSE
    Invoke CreateWindowEx, NULL, addr ReBarClassName, NULL, WS_CHILD Or \
    WS_CLIPCHILDREN Or WS_CLIPSIBLINGS Or WS_VISIBLE Or RBS_VARHEIGHT Or RBS_BANDBORDERS Or WS_BORDER\
    , 0, 0, WidthR, HeightR, WhWnd, NULL, hInst, NULL
  .ELSE
    Invoke CreateWindowEx, NULL, addr ReBarClassName, NULL, WS_CHILD Or CCS_VERT Or \
    WS_CLIPCHILDREN Or WS_CLIPSIBLINGS Or WS_VISIBLE Or RBS_VARHEIGHT Or RBS_BANDBORDERS Or WS_BORDER\
    , 0, 0, WidthR, HeightR, WhWnd, NULL, hInst, NULL
  .ENDIF
  mov ReBarHwnd, eax
  .IF ReBarHwnd==NULL
    Invoke MessageBoxEx, hWnd, addr MsgText, addr MsgCaption, \
    MB_OK or MB_ICONEXCLAMATION, NULL
    jmp EndProc
  .ENDIF
  Invoke ShowWindow,eax,SW_SHOWNORMAL
  EndProc:
  ret
CreateReBarControl endp

CreateReBarBand proc CtrHwnd:HWND, BmpHwnd:HWND, TextPointer:DWORD, BrkLine:DWORD, Moveable:DWORD
LOCAL RbBInfo:REBARBANDINFO
LOCAL Rct:RECT
  
  .IF ReBarHwnd==NULL
    Invoke MessageBoxEx, WhWnd, addr MsgText1, addr MsgCaption, \
    MB_OK or MB_ICONEXCLAMATION, NULL
  .ENDIF
  mov RbBInfo.cbSize, SIZEOF REBARBANDINFO
  mov RbBInfo.fMask, RBBIM_STYLE Or RBBIM_ID Or RBBIM_COLORS Or RBBIM_SIZE 
  mov RbBInfo.fStyle, RBBS_FIXEDBMP or RBBS_CHILDEDGE
  Invoke GetSysColor, COLOR_BTNFACE
  mov RbBInfo.clrBack, eax
  Invoke GetSysColor, COLOR_BTNTEXT
  mov RbBInfo.clrFore, eax
  cmp CtrHwnd, NULL                    ;If There's no Control Handle skip all this instructions
  je fine1
  mov RbBInfo.fMask, RBBIM_CHILD Or RBBIM_CHILDSIZE
  push CtrHwnd
  pop RbBInfo.hwndChild
  Invoke GetClassName, CtrHwnd, addr ControlClassName, 300
  Invoke lstrcmp, addr ControlClassName, addr ToolBarClassName    ; check if the control is a Toolbar
  .IF eax==0                                                      ; if so set make it flat
    Invoke SetWindowLong, CtrHwnd, GWL_STYLE, 1442875725
  .ENDIF
  Invoke GetWindowRect, CtrHwnd, addr Rct
  add Rct.bottom,2
  mov eax, DWORD PTR [Rct.right]
  mov ebx, DWORD PTR [Rct.left]
  Sub eax, ebx
  mov RbBInfo.cxMinChild, eax
  mov eax, DWORD PTR [Rct.bottom]
  mov ebx, DWORD PTR [Rct.top]
  sub eax, ebx
  mov RbBInfo.cyMinChild, eax
  fine1:
  
  cmp BmpHwnd, NULL                  ;if there's no bitmap handle Skip
  je fine2
  Or RbBInfo.fMask, RBBIM_BACKGROUND
  push BmpHwnd
  pop eax
  mov RbBInfo.hbmBack, eax
  fine2:
  
  mov eax, DWORD PTR [TextPointer]    ; if there's no ReBar Title skip
  cmp eax, NULL
  je fine3
  Or RbBInfo.fMask, RBBIM_TEXT 
  mov RbBInfo.lpText, eax
  Invoke lstrlen, eax 
  mov RbBInfo.cch, eax
  fine3:

  .IF Moveable==FALSE
    or RbBInfo.fStyle, RBBS_FIXEDSIZE
  .ELSEIF Moveable==TRUE
    mov eax, RBBS_FIXEDSIZE
    Not eax
    And RbBInfo.fStyle,eax
  .ENDIF
  .IF BrkLine==TRUE
    Or RbBInfo.fStyle, RBBS_BREAK
  .ENDIF
  Invoke SendMessage, ReBarHwnd, RB_GETBANDCOUNT, NULL, NULL
  add eax,1
  mov RbBInfo.wID, eax
  mov RbBInfo.lx, 200
  Invoke SendMessage, ReBarHwnd, RB_INSERTBAND, -1,addr RbBInfo
  .IF eax==0
    Invoke MessageBoxEx, WhWnd, addr MsgText2, addr MsgCaption, \
    MB_OK or MB_ICONEXCLAMATION, NULL
  .ENDIF
  ret
CreateReBarBand endp

End DllCODE

