; #########################################################################

      .386
      .model    flat, stdcall  ; 32 bit memory model
      option    casemap :none  ; case sensitive

.const

; #################################################################
;     include files
; #################################################################

        include c:\masm32\INCLUDE\windows.inc
        include c:\masm32\INCLUDE\masm32.inc
        include c:\masm32\INCLUDE\gdi32.inc
        include c:\masm32\INCLUDE\user32.inc
        include c:\masm32\INCLUDE\kernel32.inc
        include c:\masm32\INCLUDE\Comctl32.inc
        include c:\masm32\INCLUDE\comdlg32.inc
        include c:\masm32\INCLUDE\shell32.inc
        include c:\masm32\INCLUDE\vfw32.inc
        include c:\masm32\INCLUDE\wsock32.inc
        include c:\masm32\INCLUDE\winmm.inc
        include c:\masm32\INCLUDE\ole32.inc
        include c:\masm32\INCLUDE\Myinclude.inc
      
; #########################################################################
;     libraries
; #########################################################################

        includelib c:\masm32\LIB\masm32.lib
        includelib c:\masm32\LIB\vfw32.lib
        includelib c:\masm32\LIB\gdi32.lib
        includelib c:\masm32\LIB\user32.lib
        includelib c:\masm32\LIB\kernel32.lib
        includelib c:\masm32\LIB\Comctl32.lib
        includelib c:\masm32\LIB\comdlg32.lib
        includelib c:\masm32\LIB\shell32.lib
        includelib c:\masm32\LIB\Wsock32.lib
        includelib c:\masm32\LIB\Winmm.lib
        includelib c:\masm32\LIB\ole32.lib

; #########################################################################
; Local prototypes
; #########################################################################

        WinMain         PROTO :DWORD,:DWORD,:DWORD,:DWORD
        WndProc         PROTO :DWORD,:DWORD,:DWORD,:DWORD
        TopXY           PROTO :DWORD,:DWORD
        FillBuffer      PROTO :DWORD,:DWORD,:BYTE
        Paint_Proc      PROTO :DWORD,:DWORD
        OvlProc         PROTO :DWORD
        Do_Status       PROTO :DWORD
        CapProc         PROTO
        CapJpg          PROTO
        Do_ToolBar      PROTO :DWORD
        SetBmpColor     PROTO :DWORD
        Topmost         PROTO
        PlaySound       PROTO :DWORD,:DWORD,:DWORD
        GetDateFormat   PROTO :DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
        FrameCallback   PROTO :DWORD,:DWORD
        dwtoa           PROTO :DWORD,:DWORD
        timer_a         PROTO
        sockerror       PROTO :DWORD
        statusp         PROTO :DWORD,:DWORD,:DWORD
        About           PROTO
        
        WM_SHELLNOTIFY      equ WM_USER+5
        IDI_TRAY            equ 0
        IDM_RESTORE         equ 1000
        IDM_EXIT            equ 1010
        SBPART_MESSAGE      equ 0
        SBPART_MESSAGE2     equ 1
        SBPART_MOUSEMOVE    equ 2
        SBPART_TIME         equ 3
        SBPARTS             equ 6
        ID_TIMER1           equ 1
        SBT_TOOLTIPS        equ 800h
        IDM_SHOW_NORMAL     equ 40002

; #########################################################################
; Local macros
; #########################################################################

; #########################################################################

    szText  MACRO Name, Text:VARARG

        LOCAL   lbl

        jmp     lbl
        Name    db Text,0
        lbl:

    ENDM
    
; #########################################################################

    m2m MACRO M1, M2

        push    M2
        pop     M1

    ENDM
    
; #########################################################################

    return MACRO arg
    
        mov     eax, arg
        ret

    ENDM
    
; #########################################################################

    RGB MACRO red,green,blue
    
        xor     eax,eax
        mov     ah,blue
        shl     eax,8
        mov     ah,green
        mov     al,red
                
    ENDM
    
; #########################################################################

    Nasobit MACRO Arg1, Arg2, Result ;Multiply 
    
        PUSH    ECX
        MOV     EAX, Arg1
        MOV     ECX, Arg2
        MUL     ECX
        MOV     Result , EAX
        POP     ECX

    ENDM
    
; #########################################################################

    Odcist MACRO Arg1, Arg2, Result ;minus
    
        PUSH    ECX
        MOV     EAX, Arg1 
        MOV     ECX, Arg2				
        SUB     EAX, ECX
        MOV     Result , EAX
        POP     ECX
        
    ENDM

; #########################################################################


    RGB macro red,green,blue
    
        xor eax,eax
        mov ah,blue
        shl eax,8
        mov ah,green
        mov al,red
        
    endm

; #########################################################################

    Secist MACRO Arg1, Arg2, Result ;addition
    
        PUSH    ECX
        MOV     EAX, Arg1 
        MOV     ECX, Arg2				
        ADD     EAX, ECX
        MOV     Result , EAX
        POP     ECX

    ENDM

; #########################################################################
; macros for creating toolbar
; #########################################################################

; #########################################################################

    TBextraData MACRO
    
        mov     tbb.fsState,   TBSTATE_ENABLED
        mov     tbb.dwData,    0
        mov     tbb.iString,   0
        
    ENDM

; #########################################################################

    TBbutton MACRO bID, cID, Stl
    
        mov     tbb.iBitmap,   bID  ;; button  ID number
        mov     tbb.idCommand, cID  ;; command ID number
        mov     tbb.fsStyle,   Stl  ;; TBSTYLE_BUTTON
        invoke  SendMessage,hToolBar,TB_ADDBUTTONS,1,ADDR tbb
        
    ENDM

; #########################################################################

    TBblank MACRO
    
        mov     tbb.iBitmap,   0
        mov     tbb.idCommand, 0
        mov     tbb.fsStyle,   TBSTYLE_SEP
        invoke  SendMessage,hToolBar,TB_ADDBUTTONS,1,ADDR tbb
        
    ENDM

; #################################################################

    Create_Tool_Bar MACRO Wd, Ht

        szText tbClass,"ToolbarWindow32"

        invoke  CreateWindowEx,0,
                ADDR tbClass,
                ADDR szDisplayName,
                WS_CHILD or WS_VISIBLE or TBSTYLE_TOOLTIPS or TBSTYLE_FLAT,    ;or TTS_BALLOON
                0,0,500,40,
                hWin,NULL,
                hInstance,NULL

        mov     hToolBar,   eax
    
        invoke  SendMessage,hToolBar,TB_BUTTONSTRUCTSIZE,sizeof TBBUTTON,0
        

; #########################################################################
; Put width & height of bitmap into DWORD
; #########################################################################

    
        mov     ecx,        Wd  ;; loword = bitmap Width
        mov     eax,        Ht  ;; hiword = bitmap Height
        shl     eax,        16
        mov     ax,         cx
        mov     bSize,      eax
    
        invoke  SendMessage,hToolBar,TB_SETBITMAPSIZE,0,bSize
    
        invoke  SetBmpColor,hTbBmp
        mov     hTbBmp,     eax
    
        mov     tbab.hInst, 0
        m2m     tbab.nID,   hTbBmp
        invoke  SendMessage,hToolBar,TB_ADDBITMAP,12,ADDR tbab
    
        invoke  SendMessage,hToolBar,TB_SETBUTTONSIZE,0,bSize
        
    ENDM
      
; #########################################################################
; data section
; #########################################################################

    .data
    
        ClassName       db  "TrayIconWinClass",0
        ProgressClass   db  "msctls_progress32",0
        ListViewClassName   db "SysListView32",0
        TrackBarCtrl    db  "scrollbar",0
        szDisplayName   db  "Remote Monitoring System",0
        capName         db  "Monitoring Window",0
        statcls         db  'msctls_statusbar32',0
        TrackBarTitle   db  'TrackBar Example',0
        nostatb         db  'Could not create status bar',0
        already         db  'A copy of this program is already running!',0
        Wsaasync        db  'Socket Options Registered at '
        ServerIp        db  30 dup(0)
        LenServIp       EQU $-ServerIp
        Winsock_end     db  'Winsock Successfully Unloaded!',0
        frame_          db  'Frame ....',0
        wavefil_        db  'wavefil',0
        wavecap_        db  'wavecap',0
        Heading1        db  "Date",0
        Heading2        db  "Time",0
        Heading3        db  "From IP",0
        Heading4        db  "Socket",0
        Heading5        db  "Observations",0
        sock_prot       dd  0
                        db  '0'
        filename        db  'RemMon12.avi',0
        endcap          db  'Finished Capturing Video.',0
        
; #########################################################################
;       Here, we put the error messages for the winsock
; #########################################################################

        errad       dd    0
        peerr       dd    0
        
        sockerr0    db    "No error"
        sockerr1    db    "Interrupted system call"
        sockerr2    db    "Bad file number"
        sockerr3    db    "Permission denied"
        sockerr4    db    "Bad address"
        sockerr5    db    "Invalid argument"
        sockerr6    db    "Too many open sockets"
        sockerr7    db    "Operation would block"
        sockerr8    db    "Operation now in progress"
        sockerr9    db    "Operation already in progress"
        sockerr10   db    "Socket operation on non-socket"
        sockerr11   db    "Destination address required"
        sockerr12   db    "Message too long"
        sockerr13   db    "Protocol wrong type for socket"
        sockerr14   db    "Bad protocol option"
        sockerr15   db    "Protocol not supported"
        sockerr16   db    "Socket type not supported"
        sockerr17   db    "Operation not supported on socket"
        sockerr18   db    "Protocol family not supported"
        sockerr19   db    "Address family not supported"
        sockerr20   db    "Address already in use"
        sockerr21   db    "Can't assign requested address"
        sockerr22   db    "Network is down"
        sockerr23   db    "Network is unreachable"
        sockerr24   db    "Net connection reset"
        sockerr25   db    "Software caused connection abort"
        sockerr26   db    "Connection reset by peer"
        sockerr27   db    "No buffer space available"
        sockerr28   db    "Socket is already connected"
        sockerr29   db    "Socket is not connected"
        sockerr30   db    "Can't send after socket shutdown"
        sockerr31   db    "Too many references can't splice"
        sockerr32   db    "Connection timed out"
        sockerr33   db    "Connection refused"
        sockerr34   db    "Too many levels of symbolic links"
        sockerr35   db    "File name too long"
        sockerr36   db    "Host is down"
        sockerr37   db    "No route to host"
        sockerr38   db    "Directory not empty"
        sockerr39   db    "Too many processes"
        sockerr40   db    "Too many users"
        sockerr41   db    "Disc quota exceeded"
        sockerr42   db    "Stale NFS file handle"
        sockerr43   db    "Too many levels of remote in path"
        sockerr44   db    "Network subsystem is unavailable"
        sockerr45   db    "Winsock version not supported"
        sockerr46   db    "Winsock not yet initialized"
        sockerr47   db    "Host not found"
        sockerr48   db    "Non-authoritative host not found"
        sockerr49   db    "Non-recoverable errors"
        sockerr50   db    "Valid name   db    no data record of requested type"
        sockerr51   db    "Unknown error"
        
; #########################################################################
;       This the image dll definitions
; #########################################################################

        Libname             db  '_ISource21.dll',0   ;name of the dll
        LibAddr             dd  0                   ;Addr of dll im mem
        Code_               db  "{00000000-0000-0000-0000-000000000000}",0  
        fontname            db  'Arial',0
        
        InitDll             dd  0
        OpenFileDest        dd  0
        CloseDest           dd  0
        RGBToJPG            dd  0
        VertFlipBuf         dd  0
        RGBToBGR            dd  0
        OpenMemDest         dd  0
        OpenMemSrc          dd  0
        FillRGBSolid        dd  0
        DrawTextOnRGBEx     dd  0
        RGBToGrayScale24    dd  0
        RGBToGrayScale8     dd  0
        LastError           dd  0
        
        _InitDll            db  '_ISInitialize',0
        ISopenFileDest      db  '_ISOpenFileDest',0
        ISCloseDest         db  '_ISCloseDest',0
        ISRgbToJpg          db  '_ISWriteJPG',0
        ISVertFlipBuf       db  '_ISVertFlipBuf',0
        ISRGBToBGR          db  '_ISRGBToBGR',0
        ISOpenMemDest       db  '_ISOpenMemoryDest',0
        ISOpenMemSrc        db  '_ISOpenMemorySource',0
        ISFillRGBSolid      db  '_ISFillRGBSolidRect',0
        ISDrawTextOnRGBEx   db  '_ISDrawTextOnRGBEx',0
        ISRGBToGrayScale24  db  '_ISRGBToGrayScale24',0
        RGBToGrayScale8Bit  db  '_ISRGBToGrayScale8Bit',0
        ISGetLastError      db  '_ISGetLastError',0
        
; #########################################################################

        M401            db  'HTTP/1.1 200 OK',13,10
                        db  'Expires: 0',13,10
                        db  'Last-Modified: 0',13,10
                        db  'Content-Type: text/html',13,10
                        db  "Content-Length: 975",13,10,13,10
                        db  '<html>',13,10
                        db  '<head>' ,13,10
                        db  '<title>Remote Monitoring System - Authentication</title>',13,10
                        db  '</head>',13,10
                        db  '<body bgcolor="#000000" text="#FFCC00">',13,10
                        db  '<form name="Authentication" method="POST" action="Authentication" > ',13,10
                        db  '<div align="center"><center><p><em><big><strong><font face="Arial">Remote Monitoring System</font></strong></big></em></p>' ,13,10
                        db  '</center></div><div align="center"><center><p><font face="Arial" color="#FFCC00"><strong>Authentication</strong></font></p>',13,10
                        db  '</center></div><div align="center"><center><p><strong><font face="Arial">Username :</font></strong>' ,13,10
                        db  '<input type="text" name="Username" size="10" maxlength="10"></p>',13,10
                        db  '</center></div><div align= "center"><center><p><strong><font face="Arial">Password&nbsp; :</font></strong>',13,10
                        db  '<input type="password" name="Password" size="10" maxlength="10"></p>',13,10
                        db  '</center></div><div align="center"><center><p><input type="submit" value="Submit" name="B1"><input type="reset" value="Reset" name="B2"></p>',13,10
                        db  '</center></div>',13,10
                        db  '</form>',13,10
                        db  '</body>',13,10
                        db  "</html>",13,10,13,10,0
                        
        M200            db  'HTTP/1.1 200 OK',13,10
                        db  'Expires: 0',13,10
                        db  'Last-Modified: 0',13,10
                        db  'Content-Type: text/html',13,10
                        db  "Content-Length: 260",13,10,13,10
                        db  '<html>',13,10
                        db  '<head>',13,10
                        db  '<title>Remote Monitoring System - Authentication</title>',13,10
                        db  '</head>',13,10
                        db  '<body bgcolor="#000000" text="#FFC00">',13,10
                        db  '<p align="center"><big><strong><big>Remote Monitoring System</big></strong></big></p>',13,10
                        db  '<p align="center">&nbsp;</p>',13,10
                        db  '<p align="center"><strong>You are not allowed to access this service!</strong></p>',13,10
                        db  '<p align="center"><strong>Please ask for someone who can!</strong></p>',13,10
                        db  '<p align="center"><strong>Have a nice day.</strong></p>',13,10
                        db  '</body>',13,10
                        db  '</html>',13,10
                        db  0
                        
        Title_cap       db  '                    Remote Monitoring System (c) 2000 By Sergio A.S. de Aguiar - ssaguiar@users.daex.ufsc.br'
                        db  0
        Title_buf       db  '                                                                                                           '
        Title_buf1      db  ' '
                        db  0
        callbk          db  0
        tmr             db  0
        CurrentStep     dd  ?
        Ovl_Enabled     dd  0
        CommandLine     dd  0
        getframe        dd  0
        port            dd  3248
        wShow           dd  IDM_SHOW_NORMAL
        bSuccess        dd  0
        ClipData        dd  0
        hdcMem          dd  0
        hWnd            dd  0
        hWnd1           dd  0
        hWnd2           dd  0
        imgsrc          dd  0
        imgdest         dd  0
        hWndc           dd  0
        hwndstat        dd  0
        hStatus         dd  0
        hTrackBar       dd  0
        hTrackBar1      dd  0
        hTrackBar2      dd  0
        ToolWndc        dd  0
        image           db  0
        hInstance       dd  0
        hInst1          dd  0
        hIcon           dd  0
        hIcon1          dd  0
        hIcon2          dd  0
        hIcon3          dd  0
        hIcon4          dd  0
        ycaption        dd  0
        ymenu           dd  0
        szNULL          db  0
        hTbBmp          dd  0
        hToolBar        dd  0
        Top_most        dd  0
        GrabBmp         dd  0
        GrabJpg         dd  0
        Connected       dd  0
        audio           dd  0
        tempword        dd  0
        hList           dd  0
        PopUpMenu       dd  0
        ID_STATUSBAR    EQU 200
        ID_TRACKBAR     EQU 201
        ID_TRACKBAR1    EQU 202
        ID_TRACKBAR2    EQU 203
        IDM_Overlay     EQU 50
        IDM_Preview     EQU 51
        IDM_Format      EQU 52
        IDM_Source      EQU 53
        IDM_Driver1     EQU 54
        IDM_Driver2     EQU 55
        IDM_Driver3     EQU 56
        IDM_Driver4     EQU 57
        IDM_Printer     EQU 58
        IDM_Footer      EQU 59
        IDM_Bmp         EQU 60
        IDMBmp          EQU 61
        IDMJpg          EQU 62
        IDM_Hide        EQU 63
        IDM_Display     EQU 64
        IDM_Call        EQU 65
        IDM_Hook        EQU 66
        IDM_Quad        EQU 67
        IDM_Auto        EQU 68
        WM_SOCKET       EQU WM_USER+100
        LocalAdd_       db  "Remote Server at : ",0
        Overlay_        db  "Put the Monitoring Window in Overlay Mode",0
        Preview_        db  "Put the Monitoring Window in Preview Mode",0
        Format_         db  "Format of Video",0
        Source_         db  "Source of Video",0
        Display_        db  "Video Display",0
        Camera1         db  "Connect to Camera 1, if Present.",0
        Camera2         db  "Connect to Camera 2, if Present.",0
        Camera3         db  "Connect to Camera 3, if Present.",0
        Camera4         db  "Connect to Camera 4, if Present",0
        Camera5         db  "Connect to Camera 5, if Present",0
        Camera6         db  "Connect to Camera 6, if Present",0
        BMP_tmr         db  "Enable/Disable Grabbing a Frame every 1s, in Bmp Format",0
        JPG_tmr         db  "Enable/Disable Grabbing a Frame every 1s, in Jpg Format",0
        Bmp_cap_        db  "Grab Frame to BMP File",0
        Hide_           db  "Enable/Disable Topmost Mode",0
        Call_           db  "Enable Audio Capture (8.0 KHz,8 Bits,Mono) in AVI",0
        Hook_           db  "Print Current Frame",0
        Comp_           db  "Select Compressor For AVI File.",0
        Capt_           db  "Capture AVI Sequence To File",0
        Tool_txt1       db  "Status of Operations.",0
        Tool_txt2       db  "Jpeg Quality.",0
        Tool_Txt3       db  "Timer Value.",0
        Tool_txt4       db  "To Be Defined.",0
        Tool_txt5       db  "Today's Date.",0
        Tool_txt6       db  "Current Time.",0
        TooltipClassName    db  "Tooltips_class32",0
        Connect_        db  "Connection Request Received",0
        Read_           db  8 dup(?)
                        db  " : Read Request Received from ",0
        Write_          db  "Write Request Received...",0
        Auth_           db  "Auth Page sent at : "
        tmsg            EQU $
        tmsghour        db  2 dup(?)
                        db  ':'
        tmsgmin         db  2 dup(?)
                        db  ':'
        tmsgsec         db  2 dup(?)
                        db  0
        Date            db  30 dup(?)
                        db  0
        date_format     db  "dd'/'MM'/'yyyy" ; "dddd','d MMMM yyyy"
                        db  0
        FilePath        db  2 dup(?)
        File_2          db  2 dup(?)
        File_3          db  2 dup(?)
                        db  ".bmp",0
        JpegPath        db  2 dup(?)
        Jpeg_2          db  2 dup(?)
        Jpeg_3          db  2 dup(?)
                        db  ".jpg",0
        mmsg            db  'X:'
        mmsgx           db  4 dup(0)
                        db  ' Y:'
        mmsgy           db  4 dup(0)
                        db  0
        temp1           db  2 dup(?)
                        db  0
        buffer1         db  128     dup(0)
        time            SYSTEMTIME  <?>
        vidhdr          VIDEOHDR    <?>
        VideoHeader     VIDEOHDR    <?>
        capcaps         CAPDRIVERCAPS   <?>
        waveformat      WAVEFORMATEX <?>
        parts           dd  SBPARTS dup(0)
        wsadata         WSADATA <>
        sin             sockaddr_in <>
        client          sockaddr_in <>
        sockadlen       db  0
        ipbuffer        db  30 dup(0)
        lvi             LV_ITEM <>
        lfnt            LOGFONT<>
        pd              PRINTDLG<>
        CapStatus       CAPSTATUS <>
        jpgq            dw  25
        T1_buf          db  8   dup(?)
                        db  0
        fps             dw  18
        fps_buf         db  8   dup(?)
                        db  0
        tmr_            dw  1
        tmr_buf         db  8   dup(?)
                        db  0
                                
	.data?

        note            NOTIFYICONDATA  <>
        bm              BITMAPINFO <>
        CAP_PARAMS      CAPTUREPARMS <>
        pt              POINT <>
        ThreadId        dd  ?
        hPopupMenu      dd  ?
        sock            dd  ?
        sock_           dd  ?
        sock_jpg        dd  ?
        OutBuff         db  6000    dup(?)
        InBuff          db  1024    dup(?)
        SizeBuffer      db  20      dup(?)
        sockerrmsg      db  ?
        imgbuf          db  300000  dup(?)  ;1200000 dup(?)
        imgbuf2         db  10000   dup(?)
        imgoutbuf       db  10000  dup(?)  ;this is the buffer for jpg imgs
                                            ;when sending them thru conn..

; #########################################################################
; code section
; #########################################################################

.code

    start:
    
        invoke  LoadLibrary, addr Libname
        
            .if eax == 0

                szText  tbMsgDll,"Dll Error!"
                invoke  MessageBox,hWnd,ADDR tbMsgDll,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,eax

            .else
            
                mov     LibAddr,eax

            .endif
                
        invoke  GetProcAddress,LibAddr,addr _InitDll
        
                mov     InitDll,eax
                
            .if eax == 0
                    
                szText  tbMsgDllFunc0,"Error Getting Reg Address !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc0,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr

            .else
                            
                mov     eax,offset Code_
                push    eax
                call    InitDll               
                                        
            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISopenFileDest
                
            .if eax == 0
                    
                szText  tbMsgDllFunc1,"ISopenFileDest ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc1,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     OpenFileDest,eax

            .endif


        invoke  GetProcAddress,LibAddr,addr ISCloseDest

                
            .if eax == 0
                    
                szText  tbMsgDllFunc2,"ISCloseDest ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc2,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     CloseDest,eax

            .endif

        invoke  GetProcAddress,LibAddr,addr ISRgbToJpg
                
            .if eax == 0
                    
                szText  tbMsgDllFunc3,"RGBToJPG ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc3,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     RGBToJPG,eax

            .endif

        invoke  GetProcAddress,LibAddr,addr ISVertFlipBuf
                
            .if eax == 0
                    
                szText  tbMsgDllFunc4,"VertFlipBuf ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc4,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     VertFlipBuf,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISRGBToBGR
                
            .if eax == 0
                    
                szText  tbMsgDllFunc5,"RGBToBGR ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc5,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     RGBToBGR,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISOpenMemDest
                
            .if eax == 0
                    
                szText  tbMsgDllFunc6,"ISOpenMemDest ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc6,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     OpenMemDest,eax

            .endif
            

        invoke  GetProcAddress,LibAddr,addr ISOpenMemSrc
                
            .if eax == 0
                    
                szText  tbMsgDllFunc7,"ISOpenMemSrc ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc7,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     OpenMemSrc,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISFillRGBSolid
                
            .if eax == 0
                    
                szText  tbMsgDllFunc8,"ISFillRGBSolid ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc8,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     FillRGBSolid,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISDrawTextOnRGBEx
                
            .if eax == 0
                    
                szText  tbMsgDllFunc9,"ISDrawTextOnRGBEx ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc9,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     DrawTextOnRGBEx,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr ISRGBToGrayScale24
                
            .if eax == 0
                    
                szText  tbMsgDllFunc10,"ISRGBToGrayScale24 ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc10,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     RGBToGrayScale24,eax

            .endif
            
        invoke  GetProcAddress,LibAddr,addr RGBToGrayScale8Bit
                
            .if eax == 0
                    
                szText  tbMsgDllFunc11,"RGBToGrayScale8Bit ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc11,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     RGBToGrayScale8,eax

            .endif
            

        invoke  GetProcAddress,LibAddr,addr ISGetLastError
                
            .if eax == 0
                    
                szText  tbMsgDllFunc12,"ISGetLastError ERROR !"
                invoke  MessageBox,hWnd,ADDR tbMsgDllFunc12,ADDR szDisplayName,MB_OK
                invoke  FreeLibrary,LibAddr
                
            .else
            
                mov     LastError,eax

            .endif
            
            mov     audio,FALSE
            
            invoke  GetModuleHandle, NULL
        
            mov hInstance, eax

; #########################################################################
; Let's see if there's already a copy of this program running !
; #########################################################################

findcls:

        push      0
        push      offset  szClassName
        call      FindWindow            ;Is this window already registered?
        or        eax,eax
        jz        regclass              ;no it's not !
        
        push      MB_OK   
        push      offset  szDisplayName
        push      offset  already
        push      0
        call      MessageBox
        xor       eax,eax
        jp        end_loop

regclass:

    invoke  GetCommandLine
    
        mov CommandLine, eax

    invoke  WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
    
    invoke  InitCommonControls

end_loop:

    invoke  ExitProcess,eax

InsertColumn proc

	LOCAL lvc:LV_COLUMN
	mov lvc.imask,LVCF_TEXT+LVCF_WIDTH
	mov lvc.fmt,LVCFMT_CENTER
	mov lvc.pszText,offset Heading1
	mov lvc.lx,70
	invoke SendMessage,hList, LVM_INSERTCOLUMN,0,addr lvc

	or lvc.imask,LVCF_FMT
	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset Heading2
	mov lvc.lx,60
	invoke SendMessage,hList, LVM_INSERTCOLUMN, 1 ,addr lvc

	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset Heading3
	mov lvc.lx,90
	invoke SendMessage,hList, LVM_INSERTCOLUMN, 2 ,addr lvc

	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset Heading4
	mov lvc.lx,50
	invoke SendMessage,hList, LVM_INSERTCOLUMN, 3 ,addr lvc

	mov lvc.fmt,LVCFMT_LEFT
	mov lvc.pszText,offset Heading5
	mov lvc.lx,165
	invoke SendMessage,hList, LVM_INSERTCOLUMN, 4 ,addr lvc

	ret
		
InsertColumn endp


; #########################################################################
; WinMain Proc
; #########################################################################

WinMain proc hInst :DWORD,hPrevInst :DWORD,CmdLine :DWORD,CmdShow :DWORD

;====================
; Put LOCALs on stack
;====================

    LOCAL   wc   :WNDCLASSEX
    LOCAL   msg  :MSG
    LOCAL   Wwd  :DWORD
    LOCAL   Wht  :DWORD
    LOCAL   Wtx  :DWORD
    LOCAL   Wty  :DWORD

; #########################################################################
; Fill WNDCLASSEX structure with required variables
; #########################################################################

    invoke  LoadIcon,hInst,500    ; icon ID
    
        mov hIcon, eax
        
    invoke  LoadIcon,hInst,101    ; icon ID
    
        mov hIcon1, eax
        
    invoke  LoadIcon,hInst,102    ; icon ID
    
        mov hIcon2, eax
        
    invoke  LoadIcon,hInst,103    ; icon ID
    
        mov hIcon3, eax
        
    invoke  LoadIcon,hInst,104    ; icon ID
    
        mov hIcon4, eax
        
        szText  szClassName,"Project_Class"

        mov wc.cbSize,sizeof WNDCLASSEX
        mov wc.style,CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW
        mov wc.lpfnWndProc,    offset WndProc
        mov wc.cbClsExtra,     NULL
        mov wc.cbWndExtra,     NULL
        m2m wc.hInstance,      hInst
        mov wc.hbrBackground,  COLOR_BTNFACE+1
        mov wc.lpszMenuName,   NULL
        mov wc.lpszClassName,  offset szClassName
        m2m wc.hIcon,          hIcon
        
        invoke  LoadCursor,NULL,IDC_ARROW
    
        mov wc.hCursor,eax
        m2m wc.hIconSm,hIcon

    invoke  RegisterClassEx, ADDR wc
    
; #########################################################################
; Create window at following size
; #########################################################################

    invoke  CreateWindowEx,WS_EX_OVERLAPPEDWINDOW,
            ADDR szClassName,
            ADDR szDisplayName,
            WS_OVERLAPPED or WS_SYSMENU or WS_MINIMIZEBOX ,
            CW_USEDEFAULT,CW_USEDEFAULT,530,187,    ;470,187,
            NULL,NULL,
            hInst,NULL

            mov hWnd,eax
            
    invoke  LoadMenu,hInst,600
    mov     PopUpMenu,eax
    invoke  SetMenu,hWnd,eax
            
    invoke  ShowWindow,hWnd,SW_SHOWNORMAL
    
    invoke  UpdateWindow,hWnd
    
; #########################################################################
;       Initialize the Winsock
; #########################################################################

    invoke  WSAStartup,101h,ADDR wsadata

        .if eax != NULL

            szText  tbMsgWsock,"WInsock Error!"
            invoke  MessageBox,hWnd,ADDR tbMsgWsock,ADDR szDisplayName,MB_OK

        .endif

; #########################################################################
;       Initialize the socket...
; #########################################################################

    invoke  socket,PF_INET,SOCK_STREAM,IPPROTO_IP

        .if eax != INVALID_SOCKET

            mov     sock,eax
            
            mov     sin.sin_family,AF_INET
            mov     sin.sin_addr.S_un.S_addr,0  ;INADDR_ANY
            invoke  htons,port
            mov     sin.sin_port,ax
            
        .else

            szText  tbMsgSock1,"Socket Error!"
            invoke  MessageBox,hWnd,ADDR tbMsgSock1,ADDR szDisplayName,MB_OK

        .endif
       
; #########################################################################
;       Register the socket options...
; #########################################################################

    invoke WSAAsyncSelect,sock,hWnd,WM_SOCKET, FD_ACCEPT

        .if eax==SOCKET_ERROR

            szText  tbMsgWsaasync,"Socket Options Error!"
            invoke  MessageBox,hWnd,ADDR tbMsgWsaasync,ADDR szDisplayName,MB_OK

        .else

            invoke  bind,sock,addr sin,sizeof sin
            invoke  listen,sock,5
            invoke  gethostname,ADDR ServerIp,LenServIp
            invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Wsaasync

       .endif

            mov     sockadlen,sizeof client

       
; #########################################################################
;       OK! Now, let's start the real thing!
; #########################################################################

; #########################################################################
; Loop until PostQuitMessage is sent
; #########################################################################

    StartLoop:
    
        invoke  GetMessage,ADDR msg,NULL,0,0
        
            cmp eax, 0
            
                je  ExitLoop
                
        invoke  TranslateMessage, ADDR msg
        invoke  DispatchMessage,  ADDR msg
            
        jmp     StartLoop
            
    ExitLoop:

        return  msg.wParam

WinMain endp

; #########################################################################
; WndProc
; #########################################################################

WndProc proc hWin :DWORD,uMsg :DWORD,wParam :DWORD,lParam :DWORD

    LOCAL hDC    :DWORD
    LOCAL Ps     :PAINTSTRUCT
    
; #########################################################################
; Window Messages Processing
; #########################################################################

    .if uMsg == WM_SOCKET
    
                mov     eax,lParam
                and     eax,0FFFFh
                
            .if         ax == FD_ACCEPT
            
                        invoke  accept,sock,0,0
                        mov     sock_,eax
                
                    .if     sock_ == INVALID_SOCKET
                    
                        invoke  WSAGetLastError
                        mov     peerr,eax
                        invoke  sockerror,peerr
                      
                    .else

            
                        mov     lvi.imask,LVIF_TEXT+LVIF_PARAM
                        mov     lvi.pszText,offset Date
                        mov     lvi.iItem,0
                        mov     lvi.iSubItem,0
                        invoke  SendMessage,hList, LVM_INSERTITEM,0, addr lvi
            
                        mov     lvi.imask,LVIF_TEXT
                        mov     lvi.pszText,offset tmsg
                        mov     lvi.iItem,0
                        mov     lvi.iSubItem,1
                        invoke  SendMessage,hList, LVM_SETITEM,0, addr lvi
            
                        invoke  getpeername,sock_,addr client,addr sockadlen
                        invoke  inet_ntoa,client.sin_addr.S_un.S_addr
                        
                        mov     lvi.imask,LVIF_TEXT
                        mov     lvi.pszText,eax
                        mov     lvi.iItem,0
                        mov     lvi.iSubItem,2
                        invoke  SendMessage,hList, LVM_SETITEM,0, addr lvi

                        invoke  ntohs,sock_
                        invoke  dwtoa,eax,addr sock_prot
                        mov     lvi.imask,LVIF_TEXT
                        mov     lvi.pszText,offset sock_prot
                        mov     lvi.iItem,0
                        mov     lvi.iSubItem,3
                        invoke  SendMessage,hList, LVM_SETITEM,0, addr lvi
            
                        invoke  WSAAsyncSelect,sock_,hWnd,WM_SOCKET,FD_READ or FD_CLOSE
                        
                        .if     eax != 0
                        
                            invoke  WSAGetLastError
                            mov     peerr,eax
                            invoke  sockerror,peerr

                        .endif
                        
                                                
                    .endif
                    
                    
            .elseif     ax == FD_READ
            
                push    wParam
                pop     sock_jpg
                
                invoke  recv,wParam,addr InBuff,1024,0
                
                mov     Connected,TRUE

                invoke  StrLen,addr M401
                dec     eax
                invoke  send,wParam,addr M401,eax,0
                invoke  closesocket,wParam
                                                                
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.pszText,offset Auth_
                mov     lvi.iItem,0
                mov     lvi.iSubItem,4
                invoke  SendMessage,hList, LVM_SETITEM,0, addr lvi
                
                
                    
; #########################################################################

            .elseif     ax == FD_CLOSE
            
                
            .endif
            
    .endif
    

    .if uMsg == WM_COMMAND
    
; #########################################################################

        .if     wParam == 50

            invoke  SendMessage,hWndc,WM_CAP_SET_OVERLAY,TRUE,0
            mov     Ovl_Enabled,TRUE
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 

; #########################################################################

        .elseif wParam == 51

            invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEW,TRUE,0
            mov     Ovl_Enabled,FALSE
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 52

            invoke  SendMessage,hWndc,WM_CAP_DLG_VIDEOFORMAT,0,0
            
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 53

            invoke  SendMessage,hWndc,WM_CAP_DLG_VIDEOSOURCE,0,0
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 54
        
            ;Connect to Cam1
            invoke  SendMessage,hToolBar,TB_SETSTATE,55,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,56,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,57,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,58,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,59,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 55
        
            ;Connect to Cam2
            invoke  SendMessage,hToolBar,TB_SETSTATE,54,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,56,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,57,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,58,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,59,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 56
        
            ;Connect to Cam3
            invoke  SendMessage,hToolBar,TB_SETSTATE,54,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,55,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,57,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,58,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,59,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 57
        
            ;Connect to Cam4
            invoke  SendMessage,hToolBar,TB_SETSTATE,54,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,55,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,56,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,58,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,59,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 58
        
            ;Connect to Cam5
            invoke  SendMessage,hToolBar,TB_SETSTATE,54,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,55,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,56,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,57,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,59,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 59
        
            ;Connect to Cam6
            invoke  SendMessage,hToolBar,TB_SETSTATE,54,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,55,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,56,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,57,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,58,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,67,TBSTATE_ENABLED
            invoke  SendMessage,hToolBar,TB_SETSTATE,68,TBSTATE_ENABLED

            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 67
        
        ;Start Capture Image Sequence to AVI file (RemMon12.avi)
        
            invoke  SendMessage,hWndc, WM_CAP_SET_CALLBACK_STATUS, 0, addr statusp
        
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
            invoke  SendMessage,hWndc,WM_CAP_SET_SCALE,TRUE,0
            invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEWRATE,100,0  ;was 500,0
            invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEW,TRUE,0
            mov     Ovl_Enabled,FALSE
                
            invoke  SendMessage,hWndc,WM_CAP_GET_SEQUENCE_SETUP,sizeof CAP_PARAMS,addr CAP_PARAMS
            
                xor     eax,eax
                xor     ecx,ecx
                mov     eax,1000000  ;fps
                mov     cx,fps      ;1000000
                invoke  IntDiv,eax,ecx
                ;invoke  dwtoa,eax,ADDR buffer1
                ;invoke  SendMessage,hStatus,SB_SETTEXT,0,offset buffer1
            
                mov     CAP_PARAMS.dwRequestMicroSecPerFrame,eax ;66667
                mov     CAP_PARAMS.fMakeUserHitOKToCapture,TRUE
                
                .if     audio == FALSE
                
                        mov     CAP_PARAMS.fCaptureAudio,FALSE
                            
                .else
                
                        mov     CAP_PARAMS.fCaptureAudio,TRUE
                            
                .endif
            
            invoke  SendMessage,hWndc,WM_CAP_SET_SEQUENCE_SETUP,sizeof CAP_PARAMS,addr CAP_PARAMS
            invoke  SendMessage,hWndc,WM_CAP_FILE_SET_CAPTURE_FILE,0,addr filename
            invoke  SendMessage,hWndc,WM_CAP_SEQUENCE,0,0
            invoke  SendMessage,hWndc,WM_CAP_FILE_SAVEAS,0,addr filename
            
            invoke  SendMessage,hWndc, WM_CAP_SET_CALLBACK_STATUS, 0, 0
            
            invoke  SendMessage,hStatus,SB_SETTEXT,0,addr endcap
            
            invoke  SendMessage,hWndc,WM_CAP_SET_OVERLAY,TRUE,0
            
; #########################################################################

        .elseif wParam == 68
        
        ;Select Compressor for AVI Capture
        
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
            invoke  SendMessage,hWndc,WM_CAP_DLG_VIDEOCOMPRESSION,0,0
            
; #########################################################################

        .elseif wParam == 60
        
        ;Capture Single Frame
        
            invoke  CapProc
            invoke  PlaySound,offset wavecap_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 61
        
            .if GrabBmp == TRUE
            
                mov     GrabBmp,FALSE
                invoke  SendMessage,hWndc,WM_CAP_SET_OVERLAY,TRUE,0
                mov     Ovl_Enabled,TRUE

            .else
    
                mov GrabBmp,TRUE
                invoke  SendMessage,hWndc,WM_CAP_SET_SCALE,TRUE,0
                invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEWRATE,500,0
                invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEW,TRUE,0
                mov     Ovl_Enabled,FALSE

            .endif

	      invoke   PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 

; #########################################################################

        .elseif wParam == 62
        
            .if GrabJpg == TRUE
            
                mov     GrabJpg,FALSE
                invoke  SendMessage,hWndc,WM_CAP_SET_CALLBACK_FRAME,0,0
                mov     callbk,FALSE
                invoke  SendMessage,hWndc,WM_CAP_SET_OVERLAY,TRUE,0
                mov     Ovl_Enabled,TRUE

            .else
    
                mov GrabJpg,TRUE
                
                invoke  SendMessage,hWndc,WM_CAP_SET_SCALE,TRUE,0
                invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEWRATE,1000,0
                invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEW,TRUE,0
                mov     Ovl_Enabled,FALSE
                invoke  SendMessage,hWndc,WM_CAP_SET_CALLBACK_FRAME,0,ADDR FrameCallback
                mov     callbk,TRUE
                
            .endif

                invoke   PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC
                
; #########################################################################

        .elseif wParam == 63
        
            invoke  Topmost
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 64

            invoke  SendMessage,hWndc, WM_CAP_DLG_VIDEODISPLAY, 0, 0
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
; #########################################################################

        .elseif wParam == 65
        
        
            .if     audio == FALSE
            
            mov     audio,TRUE
            
            invoke  SendMessage,hWndc,WM_CAP_GET_AUDIOFORMAT,sizeof waveformat,addr waveformat
        
            mov     waveformat.wFormatTag,WAVE_FORMAT_PCM
            mov     waveformat.nChannels,1
            mov     waveformat.nSamplesPerSec,8000
            mov     eax,waveformat.nSamplesPerSec
            mul     waveformat.nBlockAlign
            mov     waveformat.nAvgBytesPerSec,eax
            mov     waveformat.wBitsPerSample,8
        
            invoke  SendMessage,hWndc,WM_CAP_SET_AUDIOFORMAT,sizeof waveformat,addr waveformat
            
            .if eax == FALSE
        
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC
            
            .endif
            
            .else
            
            mov     audio,FALSE
            
            .endif
            
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC
            
; #########################################################################

        .elseif wParam == 66
        
            ;invoke  ShowWindow,hWndc,SW_MAXIMIZE ;<---- this give an error - it freezes the display!
            invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC 
            
        .endif
        
; #########################################################################

        .if     wParam == 2900  ;About
        
          invoke About
          
        .elseif  wParam == 2000 ;Browse For Folder
        
        szText  tstring,"Choose the Folder For Data"
        szText  bstring,"Select a Folder"
        invoke  BrowseForFolder,hWnd,ADDR buffer1,ADDR tstring,ADDR bstring
                .if     buffer1[0] != 0
        
                ;The user made a choice... Process it!
                
                .endif
                
        .elseif wParam == 2001
        
                invoke  SendMessage,hWnd,WM_COMMAND,50,NULL
        
        .elseif wParam == 2002
        
                invoke  SendMessage,hWnd,WM_COMMAND,51,NULL
        
        .elseif wParam == 2003
        
        .elseif wParam == 2004
        
        .elseif wParam == 2005
        
        .elseif wParam == 2010  ;End Program
        
                invoke  SendMessage,hWnd,WM_SYSCOMMAND,SC_CLOSE,NULL
            
        .elseif wParam == 2020  ;Choose Text color
        
                invoke  ColorDialog,hWnd,hInstance,0
        
        .elseif wParam == 2030  ;Printer Dialog
        
                invoke  PrintDialog,hWnd,ADDR pd,PD_SHOWHELP
        
        .elseif wParam == 2040  ;Choose Font
        
                invoke  FontDialog,hWnd,ADDR lfnt,CF_BOTH ;or CF_FIXEDPITCHONLY
        
        .elseif wParam == 2050
        
        .endif

; #########################################################################

        .if lParam==0
        
            invoke  Shell_NotifyIcon,NIM_DELETE,addr note
            
                mov eax,wParam
            
                    .if ax == IDM_RESTORE
                
                        invoke  ShowWindow,hWnd,SW_RESTORE
                    
                    .else
                
                        ;invoke  DestroyWindow,hWnd
                    
                    .endif

        .endif
        
; #########################################################################

    .elseif uMsg == WM_SYSCOLORCHANGE
    
        invoke  Do_ToolBar,hWin
        invoke  Do_Status,hWin
            
; #########################################################################
    .elseif uMsg == WM_CREATE

        invoke  Do_ToolBar,hWin
        invoke  Do_Status,hWin
                
        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset LocalAdd_

        push    0               ;timerproc = null
        push    250             ;every 250 msec
        push    ID_TIMER1       ;id of timer
        push    [hWin]          ;handle
        call    SetTimer        ;set the timer
        
                
        invoke  capCreateCaptureWindowA,ADDR capName,
                WS_VISIBLE  or WS_THICKFRAME,
                CW_USEDEFAULT,CW_USEDEFAULT,320,240,0,NULL
        
        mov     hWndc,eax
        
      invoke CreateWindowEx, WS_EX_STATICEDGE, addr ListViewClassName, \
             NULL, LVS_REPORT+WS_BORDER+WS_CHILD+WS_VISIBLE, \
             0,0,0,0, \
             hWin, NULL, hInstance, NULL
             
      mov   hList,eax

        invoke InsertColumn
      
        RGB 255,255,255
        invoke SendMessage,hList,LVM_SETTEXTCOLOR,0,eax
        RGB 128,128,128
        invoke SendMessage,hList,LVM_SETBKCOLOR,0,eax   ;COLOR_BTNFACE+1
        RGB 128,128,128
        invoke SendMessage,hList,LVM_SETTEXTBKCOLOR,0,eax
        
      invoke CreateWindowEx, NULL, addr TrackBarCtrl, 0, \
             WS_CHILD+WS_VISIBLE+SBS_VERT, 0,0, \
             0,0, hWin, ID_TRACKBAR, hInstance,NULL
             
      mov   hTrackBar, eax
      
            invoke CreateWindowEx, NULL, addr TrackBarCtrl, 0, \
            WS_CHILD+WS_VISIBLE+SBS_VERT, 0,0, \
            0,0, hWin, ID_TRACKBAR1, hInstance,NULL
             
      mov   hTrackBar1, eax
      
      invoke CreateWindowEx, NULL, addr TrackBarCtrl, 0, \
             WS_CHILD+WS_VISIBLE+SBS_VERT, 0,0, \
             0,0, hWin, ID_TRACKBAR2, hInstance,NULL
             
      mov   hTrackBar2, eax
      
            invoke  SetScrollRange, hTrackBar,SB_CTL,1,100,FALSE ;Jpeg quality (1-100)
            invoke  SetScrollPos, hTrackBar, SB_CTL,0,FALSE
            invoke  MoveWindow, hTrackBar, 460,28,15,90,TRUE
                   
            invoke  SetScrollRange, hTrackBar1,SB_CTL,1,60,FALSE ;Timer control (1 to 60 s)
            invoke  SetScrollPos, hTrackBar1, SB_CTL,0,FALSE
            invoke  MoveWindow, hTrackBar1, 480,28,15,90,TRUE
            
            invoke  SetScrollRange, hTrackBar2,SB_CTL,1,30,FALSE ;frames/second (1-30)
            invoke  SetScrollPos, hTrackBar2, SB_CTL,0,FALSE
            invoke  MoveWindow, hTrackBar2, 500,28,15,90,TRUE
            
            xor     eax,eax    
            mov     ax,jpgq
            push    eax
            invoke  dwtoa,eax,ADDR T1_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,1,offset T1_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar,SB_CTL,eax,TRUE
            
            xor     eax,eax    
            mov     ax,tmr_
            push    eax
            invoke  dwtoa,eax,ADDR tmr_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,2,offset tmr_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar1,SB_CTL,eax,TRUE
            
            xor     eax,eax    
            mov     ax,fps
            push    eax
            invoke  dwtoa,eax,ADDR fps_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,3,offset fps_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar2,SB_CTL,eax,TRUE
            
; #########################################################################
;
; Just to Remember :
;
; Use of function SendMessage:
;
; SendMessage,handler,MESSAGE,Wparam,Lparam
;
; #########################################################################

        
    invoke  SendMessage,hWndc,WM_CAP_DRIVER_CONNECT,0,0
      
    invoke  SendMessage,hWndc,WM_CAP_SET_SCALE,TRUE,0
      
    invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEWRATE,1000,0

    invoke  SendMessage,hWndc,WM_CAP_SET_PREVIEW,TRUE,0

    invoke  SendMessage,hWndc,WM_CAP_SET_OVERLAY,TRUE,0

    mov     Ovl_Enabled,eax

    .elseif uMsg == WM_SIZE

        .if wParam == SIZE_MINIMIZED

            mov     note.cbSize,sizeof NOTIFYICONDATA
            push    hWnd
            pop     note.hwnd
            mov     note.uID,IDI_TRAY
            mov     note.uFlags,NIF_ICON+NIF_MESSAGE+NIF_TIP
            mov     note.uCallbackMessage,WM_SHELLNOTIFY
            push    hIcon
            pop     eax
            mov     note.hIcon,eax
            invoke  lstrcpy,addr note.szTip,addr szDisplayName
            invoke  ShowWindow,hWnd,SW_HIDE
            invoke  Shell_NotifyIcon,NIM_ADD,addr note

        .endif
        
    		mov eax,lParam
		mov edx,eax
		and eax,0ffffh
		shr edx,16
		invoke MoveWindow,hList, 2, 28,455,90,TRUE

            invoke MoveWindow,hStatus,0,0,0,0,TRUE


; #########################################################################

    .elseif uMsg == WM_PAINT
        
        invoke  BeginPaint,hWin,ADDR Ps
        mov     hDC, eax
        invoke  Paint_Proc,hWin,hDC
        invoke  EndPaint,hWin,ADDR Ps
        return  0
        
; ########################################################################

    .elseif uMsg == WM_CLOSE

        invoke  KillTimer,hWin,ID_TIMER1                
        invoke  closesocket,sock
        invoke  WSACleanup
        invoke  FreeLibrary,LibAddr
        invoke  DestroyWindow,hList
        invoke  DestroyWindow,hWnd
        invoke  DestroyWindow,hWndc

; #########################################################################

    .elseif uMsg == WM_NOTIFY

        mov     ebx,[lParam]
        
            .if dword ptr [ebx+8] == TTN_NEEDTEXT
                
                mov eax,dword ptr [ebx+4]

                    .if eax == IDM_Overlay
                        mov dword ptr [ebx+12],offset Overlay_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Overlay_
                    .endif
                        
                    .if eax == IDM_Preview
                        mov dword ptr [ebx+12],offset Preview_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Preview_
                    .endif
                        
                    .if eax == IDM_Format
                        mov dword ptr [ebx+12],offset Format_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Format_
                    .endif
                        
                    .if eax == IDM_Source
                        mov dword ptr [ebx+12],offset Source_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Source_
                    .endif

                    .if eax == IDM_Driver1
                        mov dword ptr [ebx+12],offset Camera1
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera1
                    .endif

                    .if eax == IDM_Driver2
                        mov dword ptr [ebx+12],offset Camera2
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera2
                    .endif

                    .if eax == IDM_Driver3
                        mov dword ptr [ebx+12],offset Camera3
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera3
                    .endif
                    
                    .if eax == IDM_Driver4
                        mov dword ptr [ebx+12],offset Camera4
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera4
                    .endif
                        
                    .if eax == IDM_Printer
                        mov dword ptr [ebx+12],offset Camera5
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera5
                    .endif
                        
                    .if eax == IDM_Footer
                        mov dword ptr [ebx+12],offset Camera6
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Camera6
                    .endif
                        
                    .if eax == IDM_Bmp
                        mov dword ptr [ebx+12],offset Bmp_cap_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Bmp_cap_
                    .endif

                    .if eax == IDMBmp
                        mov dword ptr [ebx+12],offset BMP_tmr
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset BMP_tmr
                    .endif
                        
                    .if eax == IDMJpg
                        mov dword ptr [ebx+12],offset JPG_tmr
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset JPG_tmr
                    .endif
                       
                    .if eax == IDM_Hide
                        mov dword ptr [ebx+12],offset Hide_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Hide_
                    .endif

                    .if eax == IDM_Display
                        mov dword ptr [ebx+12],offset Display_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Display_
                    .endif

                    .if eax == IDM_Call
                        mov dword ptr [ebx+12],offset Call_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Call_
                      .endif

                    .if eax == IDM_Hook
                        mov dword ptr [ebx+12],offset Hook_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Hook_
                        
                    .endif
                    
                    .if eax == IDM_Auto
                        mov dword ptr [ebx+12],offset Comp_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Comp_
                    .endif
                    
                    .if eax == IDM_Quad
                        mov dword ptr [ebx+12],offset Capt_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Capt_
                    .endif
                    
                    .if eax == ID_TRACKBAR
                        mov dword ptr [ebx+12],offset Capt_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Capt_
                    .endif
                    
                    .if eax == ID_TRACKBAR1
                        mov dword ptr [ebx+12],offset Capt_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Capt_
                    .endif
                    
                    .if eax == ID_TRACKBAR2
                        mov dword ptr [ebx+12],offset Capt_
                        invoke  SendMessage,hStatus,SB_SETTEXT,0,offset Capt_
                    .endif
                    
                .endif
                
; #########################################################################
   
    .ELSEIF uMsg == WM_MOUSEMOVE
    
; #########################################################################

    .ELSEIF uMsg == WM_LBUTTONDOWN 
        
; #########################################################################

    .ELSEIF uMsg == WM_LBUTTONUP
    
; #########################################################################

    .elseif uMsg == WM_VSCROLL
            
        mov     eax,lParam
        
        .if eax == hTrackBar
      
            mov         eax,wParam
            and         eax,0FFFFh
        
                .if         eax == SB_LINEDOWN
        
                    inc     jpgq
                    mov     ax,jpgq
                    cmp     ax,101
                    jb      ljp1
                    mov     jpgq,100
ljp1:
                   
                .endif
        
                .if         eax == SB_LINEUP
        
                    dec     jpgq
                    mov     ax,jpgq
                    cmp     ax,0
                    ja      lpj2
                    mov     jpgq,1
lpj2:
                   
                .endif
                                
                
            xor     eax,eax    
            mov     ax,jpgq
            push    eax
            invoke  dwtoa,eax,ADDR T1_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,1,offset T1_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar,SB_CTL,eax,TRUE
            
        
        .endif    
            
        .if eax == hTrackBar1
      
            mov         eax,wParam
            and         eax,0FFFFh
        
                .if         eax == SB_LINEDOWN
        
                    inc     tmr_
                    mov     ax,tmr_
                    cmp     ax,61
                    jb      ljp3
                    mov     tmr_,60
ljp3:
                   
                .endif
        
                .if         eax == SB_LINEUP
        
                    dec     tmr_
                    mov     ax,tmr_
                    cmp     ax,0
                    ja      lpj4
                    mov     tmr_,1
lpj4:
                   
                .endif
                                
                
            xor     eax,eax    
            mov     ax,tmr_
            push    eax
            invoke  dwtoa,eax,ADDR tmr_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,2,offset tmr_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar1,SB_CTL,eax,TRUE
            
        
        .endif
        
           
        .if eax == hTrackBar2
      
            mov         eax,wParam
            and         eax,0FFFFh
        
                .if         eax == SB_LINEDOWN
        
                    inc     fps
                    mov     ax,fps
                    cmp     ax,31
                    jb      ljp5
                    mov     fps,30
ljp5:
                   
                .endif
        
                .if         eax == SB_LINEUP
        
                    dec     fps
                    mov     ax,fps
                    cmp     ax,0
                    ja      lpj6
                    mov     fps,1
lpj6:
                   
                .endif
                                
                
            xor     eax,eax    
            mov     ax,fps
            push    eax
            invoke  dwtoa,eax,ADDR fps_buf
            invoke  SendMessage,hStatus,SB_SETTEXT,3,offset fps_buf
            pop     eax
            invoke  SetScrollPos,hTrackBar2,SB_CTL,eax,TRUE
            
        
        .endif
        
        
; #########################################################################

    .elseif uMsg==WM_TIMER
    
        ;invoke  CreateThread,0,0,addr timer_a,0,0,addr ThreadId
        ;invoke  CloseHandle,eax

        inc [tmr]

        .if [tmr]==1

            push    hIcon4
            pop     eax
            mov     note.hIcon,eax
            invoke  Shell_NotifyIcon,NIM_MODIFY,addr note
            ;invoke  SendMessage,hStatus,SB_SETICON,2,hIcon4    ;just testing...
            
        .endif

        .if [tmr]==2

            push    hIcon2
            pop     eax
            mov     note.hIcon,eax
            invoke  Shell_NotifyIcon,NIM_MODIFY,addr note
            
        .endif
        
        .if [tmr]==3

            push    hIcon1
            pop     eax
            mov     note.hIcon,eax
            invoke  Shell_NotifyIcon,NIM_MODIFY,addr note
            
        .endif
        

        .if [tmr]==4 

            mov     [tmr],0       
            call    fmtime

                .if GrabBmp == TRUE
            
                    call    CapProc

                .endif
                
                .if GrabJpg == TRUE
            
                    ;call    CapJpg

                .endif
                
            push    hIcon3
            pop     eax
            mov     note.hIcon,eax
            invoke  Shell_NotifyIcon,NIM_MODIFY,addr note
            
        .endif
        
        invoke  szMid,ADDR Title_cap,ADDR Title_buf,1,107
        invoke  szMid,ADDR Title_cap,ADDR Title_buf1,0,1
        invoke  szMid,ADDR Title_buf,ADDR Title_cap,0,108
        invoke  SetWindowText,hWnd,ADDR Title_cap
        

; #########################################################################

    .elseif uMsg == WM_DESTROY  ; End of Program call it
    
        invoke  PostQuitMessage,NULL
        invoke  DestroyWindow,hWndc
        return  0 

; #########################################################################

    .elseif uMsg == WM_SHELLNOTIFY

        .if wParam==IDI_TRAY
            
            .if lParam == WM_RBUTTONDOWN
            
				invoke GetCursorPos,addr pt
				invoke SetForegroundWindow,hWnd

                       invoke GetSubMenu,PopUpMenu,1
                        
				invoke TrackPopupMenu,eax,TPM_RIGHTALIGN or TPM_RIGHTBUTTON,pt.x,pt.y,NULL,hWnd,NULL
				invoke PostMessage,hWnd,WM_NULL,0,0
                
                        ;invoke  CapProc
                    
            .elseif lParam == WM_LBUTTONDBLCLK
            
                ;invoke GetMenuDefaultItem,PopUpMenu,FALSE,GMDI_GOINTOPOPUPS
                ;invoke SendMessage,hWnd,WM_COMMAND,eax,0
                invoke  SendMessage,hWnd,WM_COMMAND,IDM_RESTORE,0
                    
            .endif
                
        .endif
            
    .endif

    invoke  DefWindowProc,hWin,uMsg,wParam,lParam

    ret

WndProc endp

; ########################################################################

Paint_Proc proc hWin:DWORD, hDC:DWORD

    LOCAL   btn_hi   :DWORD
    LOCAL   btn_lo   :DWORD
    LOCAL   Rct      :RECT

    invoke  GetSysColor,COLOR_BTNHIGHLIGHT
    
        mov btn_hi, eax

    invoke  GetSysColor,COLOR_BTNSHADOW
    
        mov btn_lo, eax

    return  0

Paint_Proc endp

; ########################################################################

OvlProc proc hwdc:DWORD


    .if Ovl_Enabled==FALSE
            
        invoke  SendMessage,hwdc,WM_CAP_SET_SCALE,TRUE,0
        invoke  SendMessage,hwdc,WM_CAP_SET_PREVIEWRATE,500,0
        invoke  SendMessage,hwdc,WM_CAP_SET_PREVIEW,TRUE,0

    .else

        invoke  SendMessage,hwdc,WM_CAP_SET_OVERLAY,TRUE,0
                
    .endif

    return  0

OvlProc endp

; ########################################################################

CapProc proc

    invoke  SendMessage,hWndc,WM_CAP_GRAB_FRAME_NOSTOP,0,0      
                                                            
    invoke  SendMessage,hWndc,WM_CAP_FILE_SAVEDIB,0,ADDR FilePath

    invoke  OvlProc,hWndc

    return  0
        
CapProc endp

; ##########################################################################

CapJpg proc



CapJpg endp

; ##########################################################################

Topmost proc

    .if Top_most == TRUE

        invoke  SetWindowPos,hWndc,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOSIZE

            mov Top_most,FALSE

    .else
    
        invoke  SetWindowPos,hWndc,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOSIZE

            mov Top_most,TRUE

    .endif

    return  0

Topmost endp

; ##########################################################################

Do_Status   proc hParent:DWORD

    LOCAL   sbParts[6] :DWORD
                              
    invoke  CreateStatusWindow,WS_CHILD or WS_BORDER or WS_VISIBLE or SBT_TOOLTIPS,NULL,
        hParent, ID_STATUSBAR
    
        mov hStatus, eax
      
; -------------------------------------
; sbParts is a DWORD array of 3 members
; -------------------------------------

        mov [sbParts +  0],    300   ; pixels from left
        mov [sbParts +  4],    330
        mov [sbParts +  8],    360
        mov [sbParts + 12],    390
        mov [sbParts + 16],    460
        mov [sbParts + 20],    -1

    invoke  SendMessage,hStatus,SB_SETPARTS ,6,ADDR sbParts
    
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,0,ADDR Tool_txt1
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,1,ADDR Tool_txt2
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,2,ADDR Tool_txt3
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,3,ADDR Tool_txt4
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,4,ADDR Tool_txt5
    ;invoke  SendMessage,hStatus,SB_SETTIPTEXT,5,ADDR Tool_txt6
        
    ret

Do_Status   endp

; ##########################################################################

Do_ToolBar proc hWin :DWORD

; ---------------------------------------
; This proc works by using macros so that 
; the code is easier to read and modify
; ---------------------------------------

    LOCAL   bSize :DWORD
    LOCAL   tbab  :TBADDBITMAP
    LOCAL   tbb   :TBBUTTON

; ------------------
; The toolbar bitmap
; ~~~~~~~~~~~~~~~~~~
; You must supply a bitmap for the toolbar that has the 
; correct number of the required images, each of the same
; size and in the following strip bitmap form.
    
;  -------------------------------------
;  |  1  |  2  |  3  |  4  |  5  |  6  |
;  -------------------------------------

    invoke  LoadBitmap,hInstance,750
    mov     hTbBmp,eax

; --------------------------------------------------
; Set toolbar button dimensions here, width & height
; --------------------------------------------------

    Create_Tool_Bar 16, 16

    TBextraData     ; additional data for TBBUTTON structure

; -----------------------------------
; Add toolbar buttons and spaces here
; Syntax for the macro TBbutton is
; TBbutton bmpID number, WM_COMMAND ID number
; WM_COMMAND ID numbers start at 50
; -----------------------------------

    TBbutton    0,  50,   TBSTYLE_BUTTON
    TBbutton    1,  51,   TBSTYLE_BUTTON
    TBbutton    2,  52,   TBSTYLE_BUTTON
    TBbutton    3,  53,   TBSTYLE_BUTTON
    TBbutton    14, 64,   TBSTYLE_BUTTON
    TBblank
    TBbutton    4,  54,   TBSTYLE_CHECK
    TBbutton    5,  55,   TBSTYLE_CHECK
    TBbutton    6,  56,   TBSTYLE_CHECK
    TBbutton    7,  57,   TBSTYLE_CHECK
    TBbutton    8,  58,   TBSTYLE_CHECK
    TBbutton    9,  59,   TBSTYLE_CHECK
    TBblank
    TBbutton    19, 65,   TBSTYLE_CHECK
    TBbutton    18, 68,   TBSTYLE_BUTTON
    TBbutton    17, 67,   TBSTYLE_BUTTON
    TBbutton    10, 60,   TBSTYLE_BUTTON
    TBbutton    11, 61,   TBSTYLE_CHECK
    TBbutton    13, 62,   TBSTYLE_CHECK
    TBbutton    12, 63,   TBSTYLE_CHECK
    TBblank
    TBbutton    16, 66,   TBSTYLE_BUTTON
    
    ret

Do_ToolBar endp

; ########################################################################

SetBmpColor proc hBitmap:DWORD

    LOCAL   mDC       :DWORD
    LOCAL   hBrush    :DWORD
    LOCAL   hOldBmp   :DWORD
    LOCAL   hReturn   :DWORD
    LOCAL   hOldBrush :DWORD

    invoke  CreateCompatibleDC,NULL
    
        mov mDC,eax
        
    invoke  SelectObject,mDC,hBitmap
    
        mov hOldBmp,eax
    
    invoke  GetSysColor,COLOR_BTNFACE
    invoke  CreateSolidBrush,eax
    
        mov hBrush,eax
    
    invoke  SelectObject,mDC,hBrush
    
        mov hOldBrush,eax
    
    invoke  GetPixel,mDC,1,1
    invoke  ExtFloodFill,mDC,1,1,eax,FLOODFILLSURFACE
    invoke  SelectObject,mDC,hOldBrush
    invoke  DeleteObject,hBrush
    invoke  SelectObject,mDC,hBitmap
    
        mov hReturn,eax
    
    invoke  DeleteDC,mDC
    
        mov eax,hReturn

    ret

SetBmpColor endp

; #########################################################################


;*******************************************************************
;*  CVDEC                                                          *
;*  ebx = source integer                                           *
;*  edx = dest address                                             *
;*  destroys eax,ecx,esi,edi                                       *
;*******************************************************************

cvdec   proc

;
; ebx = source
; edx = dest
; ecx = even # bytes to convert
;

    LOCAL   tempbuf:TBYTE
         
        push    eax
        push    ecx
        push    esi
        push    edi
         
        fild    word ptr[ebx]   ;integer load
        fbstp   tempbuf         ;convert to bcd
        lea     ebx,tempbuf     ;address of the above conversion
        shr     ecx,1
        dec     ecx
        mov     esi,ecx
        xor     edi,edi
cvloop: mov     al,[ebx+esi]
        mov     cl,al
        and     al,0fh
        shr     cl,4
        or      al,30h
        or      cl,30h
        mov     [edx+edi],cl
        inc     edi
        mov     [edx+edi],al
        inc     edi
        dec     esi
        jns     cvloop
         
        pop     edi
        pop     esi
        pop     ecx
        pop     eax
         
        ret
cvdec   endp

; #########################################################################

;*******************************************************************
;*  Format the time and send it to the status bar                  *
;*******************************************************************

fmtime  proc

        cmp     [hStatus],0    ;valid statusbar?
        
            jz  ftimex          ;no, then exit
            
        invoke  GetDateFormat,NULL,0,NULL,ADDR date_format,ADDR Date,40
        invoke  SendMessage,hStatus,SB_SETTEXT,4,offset Date
            
        push    offset time         ;get the local
        call    GetLocalTime        ;time from win32
        mov     ax,[time.wHour]     ;get hour
        mov     [time.wHour],ax     ;save it
        lea     ebx,time.wHour      ;integer load the hour
        lea     edx,tmsghour        ;dest
        mov     ecx,2               ;#bytes
        call    cvdec               ;convert to displayable ascii decimal
        
        mov     ah,[tmsghour]
        mov     [FilePath],ah
        mov     [JpegPath],ah
        mov     al,[tmsghour+1]
        mov     [FilePath+1],al
        mov     [JpegPath+1],al
        
        lea     ebx,time.wMinute    ;integer load the minute
        lea     edx,tmsgmin         ;dest
        mov     ecx,2               ;#bytes
        call    cvdec               ;convert to displayable ascii decimal
        
        mov     ah,[tmsgmin]
        mov     [File_2],ah
        mov     [Jpeg_2],ah
        mov     al,[tmsgmin+1]
        mov     [File_2+1],al
        mov     [Jpeg_2+1],al
        
        lea     ebx,time.wSecond    ;integer load the Second
        lea     edx,tmsgsec         ;dest
        mov     ecx,2               ;#bytes
        call    cvdec               ;convert to displayable ascii decimal
        
        mov     ah,[tmsgsec]
        mov     [File_3],ah
        mov     [Jpeg_3],ah
        mov     al,[tmsgsec+1]
        mov     [File_3+1],al
        mov     [Jpeg_3+1],al
        
        push    offset tmsg
        push    5
        push    SB_SETTEXT
        push    hStatus
        call    SendMessage         ;Display time in statusbar (section 4)
        
        
ftimex: ret

fmtime  endp

; #########################################################################

FrameCallback proc hWn:DWORD, lpVHdr:DWORD

        mov     image,FALSE     ;this is a flag to tell threads that
                                ;the image is not ready

        invoke  SetWindowPos,hWndc,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOSIZE
        
        invoke  MemCopy,lpVHdr,addr VideoHeader,sizeof VideoHeader
        
        invoke  MemCopy,VideoHeader.lpData,addr imgbuf,VideoHeader.dwBytesUsed
        
        
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     ecx,3
        ;mov     eax,CapStatus.uiImageWidth
        ;invoke  IntMul,eax,ecx
        ;push    eax
            ;push    240
            ;push    960
        ;mov     eax,offset imgbuf
        ;push    eax
        ;call    VertFlipBuf
        
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
            ;push    240
            ;push    320
        ;push    offset imgbuf
        
        ;call    RGBToBGR
                
        ;RGB     255,255,255
        ;push    eax
        ;push    DT_WORD_ELLIPSIS
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
            ;push    240
            ;push    320
        ;push    223
        ;push    10
        ;push    20
        ;push    offset fontname
        ;push    offset Date
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
            ;push    240
            ;push    320
        ;mov     eax,offset imgbuf
        ;push    eax
        
        ;call    DrawTextOnRGBEx
        
        ;RGB     255,255,255
        ;push    eax
        ;push    DT_WORD_ELLIPSIS
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
            ;push    240
            ;push    320
        ;push    223
        ;push    245
        ;push    20
        ;push    offset fontname
        ;push    offset tmsg
        ;mov     eax,CapStatus.uiImageHeight
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
            ;push    240
            ;push    320
        ;mov     eax,offset imgbuf
        ;push    eax
        
        ;call    DrawTextOnRGBEx
        
        
        .if     GrabJpg == TRUE
        
            invoke  SendMessage,hWndc,WM_CAP_GET_STATUS,sizeof CapStatus,addr CapStatus

            .if     eax == FALSE
        
                invoke  PlaySound,offset wavefil_,hInstance,SND_RESOURCE or SND_SYNC
                 
            .endif
            
        push    offset JpegPath
        call    OpenFileDest
        mov     hWnd1,eax
        
        push    NULL
        push    24
        push    0
        xor     eax,eax
        mov     ax,jpgq
        push    eax
        mov     eax,CapStatus.uiImageHeight
        
                invoke  dwtoa,eax,ADDR buffer1
                invoke  SendMessage,hStatus,SB_SETTEXT,0,offset buffer1
                
        ;push    eax
        ;mov     eax,CapStatus.uiImageWidth
        ;push    eax
        push    240
        push    320
        mov     eax,offset imgbuf
        push    eax
        push    hWnd1
        
        call    RGBToJPG
        
        push    hWnd1
        call    CloseDest
        
        .endif
        
        
        invoke  SetWindowPos,hWndc,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOSIZE
        
        
        ; ####################################

        ret
        
FrameCallback endp

; #########################################################################

timer_a proc

        ret
        
        ;invoke  ExitThread,NULL
        
timer_a endp

; #########################################################################

statusp proc lwn:DWORD,iID:DWORD,ipstrStatusText:DWORD

        invoke  SendMessage,hStatus,SB_SETTEXT,0,ipstrStatusText
        
        ret

statusp endp

; #########################################################################

About proc

    szText AboutMsg,"Remote Monitoring System Ver. 1.12",13,10,\
    "Copyright  Sergio A.S. de Aguiar 2000"
    invoke ShellAbout,hWnd,ADDR szDisplayName,ADDR AboutMsg,hIcon
    
    ret

About endp

; #########################################################################


; #########################################################################

sockerror proc perr:DWORD

    .if perr   == 0

        mov errad,offset sockerr0

    .elseif perr == WSAEINTR
    
        mov errad,offset sockerr1

    .elseif perr == WSAEBADF
    
        mov errad,offset sockerr2

    .elseif perr == WSAEACCES
    
        mov errad,offset sockerr3

    .elseif perr == WSAEFAULT
    
        mov errad,offset sockerr4

    .elseif perr == WSAEINVAL
    
        mov errad,offset sockerr5
        
    .elseif perr == WSAEMFILE
    
        mov errad,offset sockerr6
        
    .elseif perr == WSAEWOULDBLOCK
    
        mov errad,offset sockerr7
        
    .elseif perr == WSAEINPROGRESS
    
        mov errad,offset sockerr8
        
    .elseif perr == WSAEALREADY
    
        mov errad,offset sockerr9
        
    .elseif perr == WSAENOTSOCK
    
        mov errad,offset sockerr10
        
    .elseif perr == WSAEDESTADDRREQ
    
        mov errad,offset sockerr11
        
    .elseif perr == WSAEMSGSIZE
    
        mov errad,offset sockerr12
        
    .elseif perr == WSAEPROTOTYPE
    
        mov errad,offset sockerr13
        
    .elseif perr == WSAENOPROTOOPT
    
        mov errad,offset sockerr14

    .elseif perr == WSAEPROTONOSUPPORT
    
        mov errad,offset sockerr15
        
    .elseif perr == WSAESOCKTNOSUPPORT
    
        mov errad,offset sockerr16

    .elseif perr == WSAEOPNOTSUPP
    
        mov errad,offset sockerr17
        
    .elseif perr == WSAEPFNOSUPPORT
    
        mov errad,offset sockerr18

    .elseif perr == WSAEAFNOSUPPORT
    
        mov errad,offset sockerr19
        
    .elseif perr == WSAEADDRINUSE
    
        mov errad,offset sockerr20

    .elseif perr == WSAEADDRNOTAVAIL
    
        mov errad,offset sockerr21
        
    .elseif perr == WSAENETDOWN
    
        mov errad,offset sockerr22

    .elseif perr == WSAENETUNREACH
    
        mov errad,offset sockerr23
        
    .elseif perr == WSAENETRESET
    
        mov errad,offset sockerr24

    .elseif perr == WSAECONNABORTED
    
        mov errad,offset sockerr25
        
    .elseif perr == WSAECONNRESET
    
        mov errad,offset sockerr26

    .elseif perr == WSAENOBUFS
    
        mov errad,offset sockerr27
        
    .elseif perr == WSAEISCONN
    
        mov errad,offset sockerr28

    .elseif perr == WSAENOTCONN
    
        mov errad,offset sockerr29
        
    .elseif perr == WSAESHUTDOWN
    
        mov errad,offset sockerr30

    .elseif perr == WSAETOOMANYREFS
    
        mov errad,offset sockerr31
        
    .elseif perr == WSAETIMEDOUT
    
        mov errad,offset sockerr32

    .elseif perr == WSAECONNREFUSED
    
        mov errad,offset sockerr33
        
    .elseif perr == WSAELOOP
    
        mov errad,offset sockerr34
        
    .elseif perr == WSAENAMETOOLONG
    
        mov errad,offset sockerr35

    .elseif perr == WSAEHOSTDOWN
    
        mov errad,offset sockerr36
        
    .elseif perr == WSAEHOSTUNREACH
    
        mov errad,offset sockerr37
        
    .elseif perr == WSAENOTEMPTY
    
        mov errad,offset sockerr38

    .elseif perr == WSAEPROCLIM
    
        mov errad,offset sockerr39
        
    .elseif perr == WSAEUSERS
    
        mov errad,offset sockerr40

    .elseif perr == WSAEDQUOT
    
        mov errad,offset sockerr41
        
    .elseif perr == WSAESTALE
    
        mov errad,offset sockerr42

    .elseif perr == WSAEREMOTE
    
        mov errad,offset sockerr43
        
    .elseif perr == WSASYSNOTREADY
    
        mov errad,offset sockerr44

    .elseif perr == WSAVERNOTSUPPORTED
    
        mov errad,offset sockerr45
        
    .elseif perr == WSANOTINITIALISED
    
        mov errad,offset sockerr46

    .elseif perr == WSAHOST_NOT_FOUND
    
        mov errad,offset sockerr47
        
    .elseif perr == WSATRY_AGAIN
    
        mov errad,offset sockerr48

    .elseif perr == WSANO_RECOVERY
    
        mov errad,offset sockerr49
        
    .elseif perr == WSANO_DATA
    
        mov errad,offset sockerr50

    .else 

        mov errad,offset sockerr51
        
    .endif 

    invoke  MessageBox,hWnd,errad,ADDR szDisplayName,MB_OK


sockerror   endp

; #########################################################################

;Those are the structures of data that will be sent to client to make the
;livestream work

;start = "HTTP/1.0 200 OK" & Chr$(10)
;header = "Content-type: multipart/x-mixed-replace;boundary=ThisRandomString" & Chr$(10)
;RANDOMSTRING = Chr$(10) & "--ThisRandomString" & Chr$(10)
;ENDSTRING = Chr$(10) & "--ThisRandomString--" & Chr$(10)
;CTSTRING = "Content-Type: image/jpeg" & Chr$(10)
;LENSTRING = "Content-Length: "
;CTRLSTRING = "Pragma: no-cache" & Chr$(10)
;EXPIRES = "Expires: Fri, 01 Jan 1983 00:00:00 GMT" & Chr$(10) & Chr$(10)

; #########################################################################
;In first place, we send the html page

;HttpSock(I).SendData Pagina

; #########################################################################
;Now, the first thing is to send the start and the header to the client

;Wsck(I).SendData start
;Wsck(I).SendData header

; #########################################################################
;Now, for each read request, we send a chunk of data with the image at the
;end of it

;If Wsck(X).State = sckConnected Then
                    
;    Wsck(X).SendData RANDOMSTRING
                        
;    Wsck(X).SendData CTSTRING
                        
;    Wsck(X).SendData LENSTRING & UBound(B) + 1 & Chr$(10)
                        
;    Wsck(X).SendData CTRLSTRING
                        
;    Wsck(X).SendData EXPIRES
                        
;    Wsck(X).SendData B()
                        
;    DoEvents
                
;End If

; #########################################################################
;This is the page that will be sent to the client

;Pagina = "<head>" & vbCrLf
;Pagina = Pagina & "<meta http-equiv=""Content-Type"" & vbcrlf"
;Pagina = Pagina & "content=""text/html; charset=iso-8859-1"">" & vbCrLf
;Pagina = Pagina & "<meta name=""GENERATOR"" content=""Made by ssaguiar"">" & vbCrLf
;Pagina = Pagina & "<title>Remote Monitoring System</title>" & vbCrLf
;Pagina = Pagina & "</head>" & vbCrLf & vbCrLf
;Pagina = Pagina & "<body bgcolor=""#000000"" text=""#C0C0C0"" link=""#FF0000"" vlink=""808080""" & vbCrLf
;Pagina = Pagina & "alink=""#FF8040"">" & vbCrLf
;Pagina = Pagina & "&nbsp;" & vbCrLf
;Pagina = Pagina & "&nbsp;" & vbCrLf
;Pagina = Pagina & "<center><font color=""#FFFFFF""><font size=+2>" & Trim$(Config.Text5.Text) & "</font></center>" & vbCrLf
;Pagina = Pagina & "&nbsp;" & vbCrLf
;Pagina = Pagina & "&nbsp;" & vbCrLf
;Pagina = Pagina & "<center>" & vbCrLf
;Pagina = Pagina & "<IMG SRC= http://" & Wsck(0).LocalIP & ":" & stream_port & " width=320 height=240>" & vbCrLf
;Pagina = Pagina & "</center>" & vbCrLf
;Pagina = Pagina & "</body>" & vbCrLf
;Pagina = Pagina & "</html>"



    end start
