; Tab Control example in Win32Asm by Latigo
; latigo@ciudad.com.ar
; 3/2000

.386			
.MODEL	FLAT, STDCALL

include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\comctl32.inc

includelib kernel32.lib
includelib user32.lib
includelib comctl32.lib


.CONST
IDC_TAB1  EQU  1011				; The Tab Control identifier


.DATA

MainDlgName	DB "IDD_DIALOG1",0		; lpTemplateName for the main dlg
Child1Name 	DB "IDD_CHILD1",0		; lpTemplateName for the first child
Child2Name	DB "IDD_CHILD2",0		; lpTemplateName for the second child
TabTitle1	DB "First Tab",0				
TabTitle2	DB "Second Tab",0		; Pretty much speak for themselves dont they?

.DATA?

hInstance 		HINSTANCE 	?	; App instance handle
hwndTab			HANDLE		?	; Handle for the Tab Control

Handles LABEL DWORD				; We'll use this as a reference to locate the handles
Child1hWnd		HANDLE		?	; Handle for the first child dialog 
Child2hWnd		HANDLE		?	; Handle for child dialog number 2

ItemStruct  	TC_ITEM 		<?>	; Structure used by the Tab Control
WhichTabChosen	DWORD			?	; Sort of flag which will prove to be VERY usefull :)

.CODE

start:

	; All this should be known stuff so im not explaining it

	WinMain PROTO hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdShow:SDWORD

	INVOKE GetModuleHandle, NULL
	MOV    hInstance,EAX
	INVOKE WinMain, hInstance,NULL,SW_SHOWDEFAULT
	INVOKE ExitProcess,EAX

WinMain proc hInst:HINSTANCE,hPrevInst:HINSTANCE,CmdShow:SDWORD

	MOV EAX, OFFSET DlgProc
	INVOKE DialogBoxParam, hInst, OFFSET MainDlgName,NULL,EAX,NULL
	RET

WinMain endp

DlgProc proc hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	MOV   EAX,uMsg

	CMP EAX, WM_CLOSE
	JZ _close
        
        CMP EAX,WM_INITDIALOG
        JZ _initdialog 
     
        CMP EAX,WM_COMMAND
        JZ _command   
  
        CMP EAX,WM_NOTIFY
	JZ _notify

        xor EAX,EAX
        RET

	_notify:                              
	MOV EAX,lParam				; lParam is a pointer to a NMHDR Struct
	MOV EAX, (NMHDR PTR [eax]).code		; is the code member a TCN_SELCHANGE?
	CMP EAX, TCN_SELCHANGE			; 
        JZ ChangingTab				; Yeah, jump!
	RET					; No! go back

	ChangingTab:
	MOV EBX,WhichTabChosen			; Which is the currently selected tab?
	MOV EAX,[Handles+EBX*4]			; Put in EAX its handle
	INVOKE ShowWindow,EAX,SW_HIDE		; Hide it damn it!
	INVOKE SendMessage,hwndTab,TCM_GETCURSEL,0,0												; Ok which one is BEING chosen right now?
	MOV WhichTabChosen,EAX			; Lets keep it in our little variable
	MOV EBX,[Handles+EAX*4]			; Now lets retrieve the chosen one's handle
 	INVOKE ShowWindow,EBX,SW_SHOWDEFAULT	; and now lets show it :)
	RET

    _close: 
    INVOKE ExitProcess,0
	RET   
        
	_initdialog:
	INVOKE InitCommonControls		; we've got to justify comctl32.dll!

	INVOKE GetDlgItem,hWnd,IDC_TAB1		; We get the handle to the Tab Control
	MOV hwndTab,EAX			        ; Lets keep it in hwndTab
	
	; Here we add the tabs to the tab control
	; Filling the TC_ITEM Struct

	MOV ItemStruct.imask,TCIF_TEXT			; Text? image? what do you want?
	MOV ItemStruct.lpReserved1,0			; Reserved
	MOV ItemStruct.lpReserved2,0 			; Reserved
	MOV ItemStruct.pszText,OFFSET TabTitle1 	; pointer to string containing tab text 
	MOV ItemStruct.cchTextMax,sizeof TabTitle1	; size of pszText
  	MOV ItemStruct.iImage,0				; index to tab control's image 
 	MOV ItemStruct.lParam,0				; Extra info
	INVOKE SendMessage,hwndTab,TCM_INSERTITEM,0,OFFSET ItemStruct

	; Now we add the second Tab title
	MOV ItemStruct.pszText,OFFSET TabTitle2
	MOV ItemStruct.cchTextMax,sizeof TabTitle2
	INVOKE SendMessage,hwndTab,TCM_INSERTITEM,1,OFFSET ItemStruct

	; We now create the dialogs that will fit in the tab control
	; This is the first CHILD dialogbox
	MOV EAX,OFFSET ChildDlgProc
	INVOKE CreateDialogParam,hInstance,OFFSET Child1Name,hwndTab,EAX,0
	MOV Child1hWnd,EAX

	; You guessed, this is the second one :)
	MOV EAX,OFFSET ChildDlgProc
	INVOKE CreateDialogParam,hInstance,OFFSET Child2Name,hwndTab,EAX,0
	MOV Child2hWnd,EAX

	MOV WhichTabChosen,0 				

	; lets initialize our variable with 0, since we will start showing the
	; first child dialogbox and its index is 0.

	INVOKE ShowWindow,Child1hWnd,SW_SHOWDEFAULT
	; Here we show the recently created child dialog box

    RET

    _command:
    MOV EAX,wParam
	RET

DlgProc endp

; Just a little 'prok' for the little child dialogboxes
ChildDlgProc  PROC SmallhWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	MOV EAX,uMsg
	XOR EAX,EAX
	RET

ChildDlgProc	ENDP

; Hey thats it ! easy huh? 
; Bye amigo!  farewell :)
END start
