.386
.model flat, stdcall  ;32 bit memory model
option casemap :none  ;case sensitive

include volga.inc

.const

	IDC_TAB1						equ 1001
	IDC_BTN1						equ 1002
	IDC_BTN2						equ 1003
	IDC_BTN3						equ 1004
	IDC_EDT1						equ 1005

.data

	first	db "One",0
	second	db "Two",0
	third	db "Tree",0

.data?

	hwndTAB	HANDLE	?				; handle of TAB Control
	pNMHDR	NMHDR <?>				; NMHDR structure variable
	tabIndex DWORD ?				; TAB index NO. We will use for hiding-showing edit and button controls
	hwndEdit1 HANDLE ?				; handle of Edit control
	hwndPush HANDLE ?	 			; handle of Button control which is on the Tab control
	TabCtrlItem TC_ITEM <?>			; TC_ITEM structure. For adding tab controls


.code

start:

	invoke GetModuleHandle,NULL
	mov		hInstance,eax

    invoke InitCommonControls
	invoke DialogBoxParam,hInstance,IDD_DIALOG1,NULL,addr DlgProc,NULL
	invoke ExitProcess,0

;########################################################################

DlgProc proc hWin:HWND,uMsg:UINT,wParam:WPARAM,lParam:LPARAM

	mov		eax,uMsg
	.if eax==WM_INITDIALOG
		invoke GetDlgItem,hWin,IDC_TAB1										; Get the handle of TabControl
		mov hwndTAB, eax
		mov TabCtrlItem.imask,TCIF_TEXT										; Will be use TEXT header
		mov TabCtrlItem.pszText,offset first								; 1. text header
		invoke SendMessage,hwndTAB,TCM_INSERTITEM,0,offset TabCtrlItem		; add 1. Tab
		mov TabCtrlItem.pszText,offset second								; 2. text header
		invoke SendMessage,hwndTAB,TCM_INSERTITEM,1,offset TabCtrlItem		; add 2. TAB
		mov TabCtrlItem.pszText,offset third								; 3. text header
		invoke SendMessage,hwndTAB,TCM_INSERTITEM,2,offset TabCtrlItem		; add 3. TAB	(and so on, how many do you wish?)
		invoke GetDlgItem,hWin,IDC_EDT1										; Get the handle of EditControl      (for show-hide)
		mov hwndEdit1, eax
		invoke GetDlgItem,hWin,IDC_BTN3										; Get the handle of ButtonControl    (for show-hide)
		mov hwndPush, eax
		mov eax,TRUE														; Initialisation finished then return TRUE
		ret
	.elseif eax==WM_NOTIFY													; we need WM_NOTIFY for learning if switching TABs
		mov eax, wParam														; wParam is control ID, lParam is points to NMHDR structure
			.if eax==IDC_TAB1												; we interesting only TabControl notification
				mov eax,lParam
				mov eax, (NMHDR ptr [eax]).code								; eax has "code" member of the structure
				.if eax ==TCN_SELCHANGE										; is this notification tabs changing?
					invoke SendMessage,hwndTAB,TCM_GETCURSEL,0,0			; then learn the TAB index.
					mov tabIndex, eax										; store to "tabIndex"
					.if tabIndex==0											; is it 1. TAB
						invoke ShowWindow,hwndPush,SW_SHOW					; show Button, 
						invoke ShowWindow,hwndEdit1,SW_HIDE					; hide Edit
					.elseif tabIndex==1										; is it 2. TAB
						invoke ShowWindow,hwndPush,SW_HIDE					; as above
						invoke ShowWindow,hwndEdit1,SW_SHOW					; as above	
					.elseif tabIndex==2										; 3. TAB?
						invoke ShowWindow,hwndPush,SW_HIDE					; ...
						invoke ShowWindow,hwndEdit1,SW_HIDE					; ...	
					.endif
				.endif
			.endif					
	.elseif eax==WM_COMMAND													; I created this code easily mostly via excellent "asm RAD"
		mov		eax,wParam													; RadAsm v1.1.0.6 (Hi, KetilO). For whom doesn't know
		mov		edx,eax														; "win32asmboard.cjb.net" try this. Also this entire
		shr		edx,16														; WM_COMMAND part also remaining part
		and		eax,0FFFFh													; created via "Dialog to Window".
		.if edx==BN_CLICKED													; Also code, dialog created via "DialogApp template"
			.if eax==IDC_BTN1
			; // ToDo: Command1
				mov eax, FALSE
				ret
			.elseif eax==IDC_BTN2
				invoke EndDialog,hWin,0
			.elseif eax==IDC_BTN3
			; // ToDo: Command3
				mov eax, FALSE
				ret			
			.endif
			invoke EndDialog,hWin,0												; I like quitting on ESC key :) May comment.
		.endif
	.elseif eax==WM_CLOSE
		invoke EndDialog,hWin,0
	.else
		mov		eax,FALSE
		ret
	.endif
	mov		eax,TRUE
	ret

DlgProc endp

end start
