; *************************************************************************
;                          - Time ShutDown v1.0 -
;
;                   Coded by [G-MaX]/Mamtasoft (C) 2002
;                        Member of eBOLA vIRUS cREW
;                         g-max@ebolaviruscrew.net
;                 Original Code Written on July 10, 2002
;
;         Program to shutdown your computer at a specified time.
;           Program works on Win9x and WinNT/2k type Platforms.
;
; *************************************************************************
;
;             Compile this source with Microsoft MASM32 v6.14:
;
;                   rc.exe /i\masm32\include TimeSD.rc
;             ml.exe /c /coff /Cp /I\masm32\include TimeSD.asm
;  link.exe /SUBSYSTEM:WINDOWS /LIBPATH:\masm32\lib TimeSD.obj TimeSD.res
;
; *************************************************************************


.386
.model FLAT, STDCALL

includelib USER32.LIB
includelib KERNEL32.LIB
includelib GDI32.LIB
includelib ADVAPI32.LIB
includelib SHELL32.LIB

include    USER32.INC
include    KERNEL32.INC
include    GDI32.INC
include    ADVAPI32.INC
include    SHELL32.INC

include    WINDOWS.INC

;=================
; Structures
;=================

OSVINFO STRUCT
  dwOSVersionInfoSize   DWORD      ?
  dwMajorVersion        DWORD      ?
  dwMinorVersion        DWORD      ?
  dwBuildNumber         DWORD      ?
  dwPlatformId          DWORD      ?
  szCSDVersion          BYTE 128 dup (?)
OSVINFO ENDS

LUIDCUST STRUCT
  usedpart              DWORD      ?
  ignorehigh32bitpart   DWORD      ?
LUIDCUST ENDS

TOKEN_PRIVS STRUCT
  privilegecount        DWORD      ?
  theluid               LUIDCUST   <>
  attributes            DWORD      ?
TOKEN_PRIVS ENDS

SYSTEMTIME STRUCT
  wYear                 WORD      ?
  wMonth                WORD      ?
  wDayOfWeek            WORD      ?
  wDay                  WORD      ?
  wHour                 WORD      ?
  wMinute               WORD      ?
  wSecond               WORD      ?
  wMilliseconds         WORD      ?
SYSTEMTIME ENDS


;=================


WinMain         PROTO :HINSTANCE, :HINSTANCE, :LPSTR, :SDWORD
WndProc         PROTO :DWORD, :DWORD, :DWORD, :DWORD
ConfigProc      PROTO :DWORD, :DWORD, :DWORD, :DWORD
ChkReg          PROTO
SetRegVal       PROTO
KillRegVal      PROTO
SetTimeToReg    PROTO
GetTimeFromReg  PROTO
GetCurrentTime  PROTO
GetTimeFromDlg  PROTO
IsWinNt         PROTO
AdjustToken     PROTO



.const

IDI_ICON        equ     500
IDC_HOURS       equ     1000
IDC_MINUTES     equ     1001
IDC_SPINH       equ     1002
IDC_SPINM       equ     1003
IDC_PRGNAME     equ     1004
IDC_AUTORUN     equ     1005
IDM_TRAYMENU    equ     1200
IDM_CONFIG      equ     1201
IDM_EXIT        equ     1202
IDC_CANCEL      equ     3003
IDC_APPLY       equ     3004
IDC_STATIC      equ     -1

PROGRAMNAME     equ     "Time ShutDown v1.0"

WM_CUSTOMCHKBOX equ     299           ; Custom Message to Set CheckBox
WM_TRAYICON     equ     WM_USER+400   ; For Tray Icon Calls
WM_TIMESD       equ     WM_USER+500   ; For Initial Hide State

MAX_HOUR        equ     23
MAX_MIN         equ     59

CRLF            equ     0dh, 0ah

RKEY_ALL_ACCESS equ     000F003Fh     ; Security access flag for registry keys
                                      ; If I use KEY_ALL_ACCESS defined in Windows.inc
                                      ; on Windows NT platform, RegCreateKeyEx return
                                      ; error 5L (ERROR_ACCESS_DENIED).

;=================
; Macros
;=================

  szText MACRO Name, Text:VARARG
    LOCAL lbl
      jmp lbl
        Name db Text,0
      lbl:
    ENDM

  literal MACRO quoted_text:VARARG
    LOCAL local_text
    .data
      local_text db quoted_text,0
    .code
    EXITM <local_text>
  ENDM

  SADD MACRO quoted_text:VARARG
    EXITM <ADDR literal(quoted_text)>
  ENDM

;=================

.data

DlgName         db "MAINDIALOG", 0
ConfigDlgName   db "CONFIGDIALOG", 0

AppName         db "eVC - ", PROGRAMNAME, 0

FirstRunMsg     db "This is the first time you use"
                db CRLF
                db "Time ShutDown on this system."
                db CRLF, CRLF
                db "Configure it before use...", 0

AutoRunValue    db "Time ShutDown",0       ; Registry Value/Key
AutoRunSectn    db "Software\Microsoft\Windows\CurrentVersion\Run",0 ;Registry Section

RegSettingSectn db "Software\Time ShutDown", 0 ;Registry section where time setting are stored
RegHoursValue   db "Hour", 0     ;Registry value to save hours
RegMinValue     db "Minute", 0   ;Registry value to save minutes


; -----------------------------------------------------------------------------

.data?

        ConfigDialog  dd ?   ; Config Dialog In View Flag
        hWnd          dd ?   ; Main Window Handle
        hInstance     dd ?   ; Instance Handle
        hConfigDlg    dd ?   ; Config Dialog Handle
        hIcon         dd ?   ; Program Icon Handle
        hTimer        dd ?   ; Timer Handle
        hMenu         dd ?   ; Popup Menu Handle
        lpIconData    dd ?   ; ICONDATA Pointer
        lpPntApi      dd ?   ; POINT Pointer
        wKey          dd ?   ; Key Location for Registry Key

        HourSetting   dw ?   ; Hold the hours specified by user and stored in the registry
        MinSetting    dw ?   ; Hold the minutes specified by user and stored in the registry

        CurrentHour   dw ?   ; Current hour retrieved by GetLocalTime
        CurrentMin    dw ?   ; Current minute retrieved by GetLocalTime


.code

Start:

    invoke  GetModuleHandleA, NULL
    mov     hInstance, eax

    invoke  WinMain, hInstance, NULL, NULL, SW_SHOWDEFAULT
    invoke  ExitProcess, eax



WinMain     PROC hInst: HINSTANCE, hPrevInst: HINSTANCE, CmdLine: LPSTR, CmdShow: SDWORD

      LOCAL tta:NOTIFYICONDATA     ; Tray Icon Info
      LOCAL pta:POINT              ; Popup Menu Info

      ; First See if program is already running...

      invoke FindWindow,0,SADD("Time ShutDown Program")
      .if eax != 0
        invoke MessageBox,0,SADD("Time ShutDown Already Running!"),\
                   SADD("Time ShutDown"),MB_ICONEXCLAMATION
        xor eax, eax    ; Return Zero
        ret
      .endif

      ; Set the Global wKey value.  Win/NT will default to CURRENT_USER
      ; and Win9x platforms will default to LOCAL_MACHINE.

      ; ALL Platforms to use HKLM, Un-comment below to change...

      ;invoke IsWinNt
      ;.if eax == 0
         mov eax, HKEY_LOCAL_MACHINE
         mov wKey, eax
      ;.else
      ;   mov eax, HKEY_CURRENT_USER
      ;   mov wKey, eax
      ;.endif

      invoke LoadIcon,hInst, IDI_ICON    ; Program icon ID
      mov hIcon, eax

      lea eax, tta                 ; Address of Structure into eax
      mov lpIconData, eax          ; pointer to structure
      lea eax, pta                 ; Address of Structure into eax
      mov lpPntApi, eax            ; pointer to structure


      invoke DialogBoxParam,hInstance,ADDR DlgName,HWND_DESKTOP,ADDR WndProc,NULL

      .if hIcon != 0
         invoke DeleteObject,hIcon ; Free up resources used
      .endif

      xor eax, eax                 ; return nothing
      ret

WinMain ENDP

; *************************************************************************
; Main Dialog proceedure

WndProc proc hWin   :DWORD,
             uMsg   :DWORD,
             wParam :DWORD,
             lParam :DWORD

    LOCAL wParamL   :DWORD    ; wParam Low Word
    LOCAL wParamH   :DWORD    ; wParam High Word
    LOCAL lParamL   :DWORD    ; lParam Low Word
    LOCAL iWork     :DWORD    ; Work Variable
    LOCAL x         :DWORD    ; Menu x coord.
    LOCAL y         :DWORD    ; Menu y coord.

    mov eax, wParam           ; wParam to eax
    and eax, 0000FFFFh        ; strip off the low word
    mov wParamL, eax          ; save it to wParamL
    mov eax, wParam           ; wParam to eax
    shr eax, 16               ; get hiword
    mov wParamH, eax          ; save it to wParamH
    mov eax, lParam           ; lParam to eax
    and eax, 0000FFFFh        ; stip off the low word
    mov lParamL, eax          ; save it to lParamL

    .if uMsg == WM_COMMAND

       .if wParamL == IDM_EXIT
           szText CloseMsg,"Terminate Time ShutDown ?"
           szText CloseCap,"Time ShutDown"
           invoke MessageBox,hWin,ADDR CloseMsg,ADDR CloseCap, MB_YESNO Or MB_DEFBUTTON2
           mov iWork, eax
           .if iWork == IDYES
              .if ConfigDialog == 1      ; Check if Config Dialog is visible
                  invoke SendMessage, hConfigDlg, WM_COMMAND, IDC_CANCEL, 0 ; If yes close it
              .endif
              invoke EndDialog,hWin,0
           .endif

        .elseif wParamL == IDM_CONFIG
           .if ConfigDialog == 0
             mov eax, 1              ; Show that we're in View
             mov ConfigDialog, eax    ; Set the Flag
             invoke DialogBoxParam,hInstance,ADDR ConfigDlgName,HWND_DESKTOP,ADDR ConfigProc,NULL
           .else
             invoke MessageBeep,MB_ICONEXCLAMATION
           .endif
        .endif

    .elseif uMsg == WM_TIMER

                invoke GetCurrentTime

                mov ax, HourSetting
                .if ax == CurrentHour
                    mov ax, MinSetting
                    .if ax == CurrentMin

                        invoke IsWinNt               ; see if we're on an NT platform
                        .if eax == 1                 ; a return of 1 means NT platform.
                            invoke AdjustToken       ; Get rights to restart on NT platforms
                            invoke ExitWindowsEx, EWX_SHUTDOWN + EWX_POWEROFF + EWX_FORCE, NULL  ; Restart the machine
                        .else
                            invoke ExitWindowsEx, EWX_SHUTDOWN + EWX_POWEROFF, NULL  ; Restart the machine
                        .endif
                        invoke ExitProcess,0                           ; shutdown this process API Call
                    .endif
                .endif

    .elseif uMsg == WM_TIMESD

        invoke ShowWindow,hWin,SW_HIDE

    .elseif uMsg == WM_INITDIALOG

        invoke GetTimeFromReg                        ; Get time values from registry
        .if eax == 0                                 ; If values not yet set
            invoke MessageBox,0, ADDR FirstRunMsg,\
                       SADD("Time ShutDown"),MB_ICONEXCLAMATION  ; display a msg
            invoke PostMessage, hWin, WM_COMMAND, IDM_CONFIG, 0  ; and open Config Dialog

        .endif

        .if hIcon != 0
           invoke SendMessage,hWin,WM_SETICON,ICON_BIG,hIcon
        .endif

        invoke LoadMenu,hInstance,IDM_TRAYMENU   ; load the menu from the resource
        mov iWork, eax                           ; save the handle in iWork
        invoke GetSubMenu,iWork,NULL             ; get the submenu handle for it
        mov hMenu, eax                           ; save it in hMenu

        mov eax, lpIconData

        szText ToolTip,"Time ShutDown"  ; Set our desired tool tip

        ASSUME eax:PTR NOTIFYICONDATA

        mov [eax].cbSize, 88
        mov edx, hWin
        mov [eax].hwnd, edx
        mov edx, hInstance
        mov [eax].uID, edx
        mov [eax].uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP
        mov [eax].uCallbackMessage, WM_TRAYICON
        mov edx, hIcon
        mov [eax].hIcon, edx
        mov [eax].szTip, 0
        invoke lstrcpy, ADDR [eax].szTip, ADDR ToolTip

        ASSUME eax:nothing

        invoke Shell_NotifyIcon,NIM_ADD,lpIconData

        invoke SetTimer,hWin,410,10000, ADDR WndProc   ; Poll every 10 secs
        mov hTimer, eax                              ; Save timer handle

        invoke PostMessage,hWin,WM_TIMESD,0,0

    .elseif uMsg == WM_TRAYICON
        .if lParamL == WM_RBUTTONDOWN
           invoke IsWindowVisible,hWin
           .if eax == 0
              invoke SetForegroundWindow,hWin
              invoke GetCursorPos,lpPntApi
              mov eax, lpPntApi
              mov ecx, (POINT PTR [eax]).x
              mov x, ecx
              mov ecx, (POINT PTR [eax]).y
              mov y, ecx
              invoke TrackPopupMenu,hMenu,0,x,y,0,hWin,NULL
              invoke PostMessage,hWin,WM_NULL,0,0
           .endif
        .elseif lParamL == WM_LBUTTONDBLCLK
           invoke SetForegroundWindow,hWin
           invoke PostMessage,hWin,WM_COMMAND,IDM_CONFIG,0
        .endif
    .elseif uMsg == WM_SIZE

    .elseif uMsg == WM_PAINT

    .elseif uMsg == WM_CLOSE
        invoke EndDialog,hWin,0

    .elseif uMsg == WM_DESTROY

        .if hTimer != 0
           invoke KillTimer,hWin,hTimer
        .endif

        invoke Shell_NotifyIcon,NIM_DELETE,lpIconData

    .elseif uMsg == WM_SYSCOMMAND

        .if wParamL == SC_CLOSE

           invoke SetWindowPos,hWin,HWND_NOTOPMOST,0,0,0,0,SWP_NOSIZE Or SWP_NOMOVE
           invoke ShowWindow,hWin,SW_HIDE

        .elseif wParamL == SC_MINIMIZE

        .endif

    .endif

    xor eax, eax   ; Insure that default proc grabs it from here...

    ret

WndProc endp

; *************************************************************************
; Config Window Dialog Proceedure

ConfigProc proc hWin :DWORD, uMsg :DWORD, wParam :DWORD, lParam :DWORD

    LOCAL wParamL:DWORD
    LOCAL wParamH:DWORD
    LOCAL iWork:DWORD
    LOCAL utstr[64]:BYTE

    mov eax, hWin          ; Save the dialog box hinstance
    mov hConfigDlg, eax    ; in a global var

    mov eax, wParam        ; wParam to eax
    shr eax, 16            ; strip off di hi word
    mov wParamH, eax       ; save it to wParamH

    mov eax, wParam        ; wParam to eax
    and eax, 0000FFFFh     ; strip off the low word
    mov wParamL, eax       ; save it to wParamL

    .if uMsg == WM_COMMAND

        .if wParamL == IDC_APPLY      ; Command IDC_APPLY (APPLY BUTTON)

           .if wParamH == BN_CLICKED

              invoke GetDlgItem,hWin,IDC_AUTORUN        ; get handle to checkbox
              mov iWork, eax                            ; save it in iWork
              invoke SendMessage,iWork,BM_GETCHECK,0,0  ; See if its checked
              mov iWork, eax


              .if iWork == 0              ; No check in checkbox so remove
                 invoke ChkReg            ; the registry value if it is set
                 .if eax != 0
                    invoke KillRegVal
                 .endif
              .else                       ; Checkbox is checked so add the
                 invoke ChkReg            ; registry value if it is not
                 .if eax == 0             ; already there...
                    invoke SetRegVal
                 .endif
              .endif

              invoke GetTimeFromDlg       ; Get time selected by user
              .if eax != 0                ; If time values are valid
                  invoke SetTimeToReg     ; save to registry

                  invoke EndDialog,hWin,0 ; close the window
                  xor eax, eax            ; zero eax
                  mov ConfigDialog, eax   ; set Dialog Show Flag to FALSE (0)
              .endif

           .endif

         .elseif wParamL == IDC_CANCEL

           .if wParamH == BN_CLICKED
               invoke EndDialog,hWin,0     ; close the window
               xor eax, eax                ; zero eax
               mov ConfigDialog, eax       ; set Dialog Show Flag to FALSE (0)
           .endif

         .elseif wParamL == IDC_MINUTES

           .if wParamH == EN_KILLFOCUS

           .endif

         .elseif wParamL == WM_CUSTOMCHKBOX       ; Custom Message to Set CheckBox

           invoke ChkReg                          ; See if Value in Reg is set
           .if eax != 0                           ; if so then set the checkbox
              invoke GetDlgItem,hWin,IDC_AUTORUN  ; to show a check in it.
              mov iWork, eax
              invoke SendMessage,iWork,BM_SETCHECK,1,0
           .endif

        .endif

    .elseif uMsg == WM_INITDIALOG

        ;invoke GetTimeFromReg

        invoke SendDlgItemMessage, hConfigDlg, IDC_SPINH, \
                                   UDM_SETRANGE, 0, MAX_HOUR  ;Set the range of hours up-down spin
        invoke SendDlgItemMessage, hConfigDlg, IDC_SPINM, \
                                   UDM_SETRANGE, 0, MAX_MIN   ;Set the range of minutes up-down spin

        invoke SendDlgItemMessage, hConfigDlg, IDC_SPINH, \
                                   UDM_SETPOS, 0, HourSetting ;Set Hour value in the text box

        invoke SendDlgItemMessage, hConfigDlg, IDC_SPINM, \
                                   UDM_SETPOS, 0, MinSetting  ;Set Min value in the text box

        invoke PostMessage,hWin,WM_COMMAND,WM_CUSTOMCHKBOX,0  ;Custom msg for checkbox

    .elseif uMsg == WM_CLOSE
        invoke EndDialog,hWin,0
        xor eax, eax
        mov ConfigDialog, eax
    .endif

    xor eax, eax   ; Insure that default proc grabs it from here...

    ret

ConfigProc endp

; *************************************************************************
; Check the Registry to see of we have a specified value set

ChkReg proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE  ; MUST BE 300 Minimum for NT!

    invoke RegCreateKeyEx,wKey, ADDR AutoRunSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,RKEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result

    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry (ChkReg)!"),\
           SADD("ERROR!"),16
       ret
    .endif

    mov eax, SizeOf zBuf
    mov rslt, eax         ; SizeOf zBuf in rslt

    invoke RegQueryValueEx,hReg, ADDR AutoRunValue,0,0,ADDR zBuf,ADDR rslt

    mov rslt, eax

    invoke RegCloseKey,hReg
    xor eax, eax

    .if rslt == ERROR_SUCCESS
       inc eax
    .endif

    ret

ChkReg endp

; *************************************************************************
; Set an AutoStart Value in the registry

SetRegVal proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE
    LOCAL Path[OFS_MAXPATHNAME]:BYTE

    invoke RegCreateKeyEx,wKey,ADDR AutoRunSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,RKEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result

    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry (SetRegVal)!"),\
           SADD("ERROR!"),16
       ret
    .endif

    invoke GetModuleFileName,0,ADDR Path,OFS_MAXPATHNAME

    invoke RegSetValueEx,hReg,ADDR AutoRunValue,0,REG_SZ,ADDR Path,SizeOf Path
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Registry Error Setting AutoRun!"),\
           SADD("ERROR!"),16
    .endif

    invoke RegCloseKey,hReg
    xor eax, eax
    ret

SetRegVal endp

; *************************************************************************
; Remove our AutoStart value from the registry

KillRegVal proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE

    invoke RegCreateKeyEx,wKey,ADDR AutoRunSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,RKEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result

    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry (KillRegVal)!"),\
           SADD("ERROR!"),16
       ret
    .endif

    invoke RegDeleteValue,hReg,ADDR AutoRunValue

    invoke RegCloseKey,hReg
    xor eax, eax
    ret

KillRegVal endp

; *************************************************************************
; Set the time values to registry

SetTimeToReg proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE
    LOCAL dwHour:DWORD
    LOCAL dwMin:DWORD

    invoke RegCreateKeyEx,wKey,ADDR RegSettingSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,RKEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result

    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry (SetTimeToReg)!"),\
           SADD("ERROR!"),16
       ret
    .endif

    xor eax, eax         ;These three line of code convert the WORD value
    mov ax, HourSetting  ;of the HourSetting var in a DWORD value
    mov dwHour, eax

    invoke RegSetValueEx,hReg,ADDR RegHoursValue,0,REG_DWORD, ADDR dwHour,SizeOf dwHour
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Registry Error Saving Hour!"),\
           SADD("ERROR!"),16
    .endif

    xor eax, eax         ;These three line of code convert the WORD value
    mov ax, MinSetting   ;of the MinSetting var in a DWORD value
    mov dwMin, eax

    invoke RegSetValueEx,hReg,ADDR RegMinValue,0,REG_DWORD, ADDR dwMin,SizeOf dwMin
    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Registry Error Saving Minute!"),\
           SADD("ERROR!"),16
    .endif

    invoke RegCloseKey,hReg

    xor eax, eax

    ret

SetTimeToReg endp

; *************************************************************************
; Set the time values to registry

GetTimeFromReg proc

    LOCAL hReg:DWORD
    LOCAL rslt:DWORD
    LOCAL Result:DWORD
    LOCAL zBuf[300]:BYTE  ; MUST BE 300 Minimum for NT!

    invoke RegCreateKeyEx,wKey, ADDR RegSettingSectn,0,ADDR zBuf,\
           REG_OPTION_NON_VOLATILE,RKEY_ALL_ACCESS,\
           0,ADDR hReg,ADDR Result

    .if eax != ERROR_SUCCESS
       invoke MessageBox,hWnd,SADD("Error Opening Registry (GetTimeFromReg)!"),\
           SADD("ERROR!"),16
       ret
    .endif

    mov eax, SizeOf Result
    mov rslt, eax         ; SizeOf Result in rslt

    invoke RegQueryValueEx,hReg, ADDR RegHoursValue,0,0,ADDR Result, ADDR rslt

    .if eax == ERROR_SUCCESS
        mov eax, Result
        mov HourSetting, ax

        mov eax, SizeOf Result
        mov rslt, eax         ; SizeOf Result in rslt

        invoke RegQueryValueEx,hReg, ADDR RegMinValue,0,0,ADDR Result, ADDR rslt

        .if eax == ERROR_SUCCESS
            mov eax, Result
            mov MinSetting, ax
            mov rslt, 1
        .else
            mov MinSetting, 0     ; If first run, Set Min value to zero
            mov rslt, 0
        .endif
    .else
        mov HourSetting, 0        ; If first run, Set Hour value to zero
        mov rslt, 0
    .endif

    invoke RegCloseKey,hReg
    xor eax, eax

    mov eax, rslt

    ret

GetTimeFromReg endp


; *************************************************************************
; Retrieve the current system time and save it in a global variable

GetCurrentTime proc
    LOCAL sts: SYSTEMTIME  ;System Time info struct
    LOCAL psts: DWORD      ;Pointer to st

    lea eax, sts
    mov psts, eax
    invoke GetLocalTime, psts

    mov eax, psts
    mov cx, (SYSTEMTIME PTR [eax]).wHour
    mov CurrentHour, cx         ; Save Hour in a global var
    mov cx, (SYSTEMTIME PTR [eax]).wMinute
    mov CurrentMin, cx          ; Save Minutes in a global var

    xor eax, eax

    ret

GetCurrentTime endp

; *************************************************************************
; Get the time values from config dialog. Return 1 for good values, 0 othrwise

GetTimeFromDlg proc

    LOCAL Translated: BOOL

    invoke GetDlgItemInt, hConfigDlg, IDC_HOURS, ADDR Translated, FALSE

    .if Translated == TRUE

       .if eax <= MAX_HOUR
           mov HourSetting, ax

           invoke GetDlgItemInt, hConfigDlg, IDC_MINUTES, ADDR Translated, FALSE

           .if Translated == TRUE

              .if eax <= MAX_MIN
                  mov MinSetting, ax
                  mov eax, 1
              .else
                  invoke MessageBox,hWnd,SADD("Minutes value out of range!"),\
                         SADD("ERROR!"),16
                  xor eax, eax
              .endif
           .else
              invoke MessageBox,hWnd,SADD("Invalid Minutes value!"),\
                     SADD("ERROR!"),16
              xor eax, eax
           .endif
       .else
           invoke MessageBox,hWnd,SADD("Hours value out of range!"),\
                  SADD("ERROR!"),16
           xor eax, eax
       .endif
    .else
       invoke MessageBox,hWnd,SADD("Invalid Hours value!"),\
              SADD("ERROR!"),16
       xor eax, eax
    .endif

    ret

GetTimeFromDlg endp

; *************************************************************************
; Return 1 if the OS is an NT Based Platform, othrwise return 0

IsWinNt proc

    LOCAL vi:OSVINFO     ; Version Info Struct
    LOCAL pvi:DWORD      ; Pointer To vi


    lea eax, vi                         ; vi's address into eax
    mov ecx, SizeOf vi                  ; sizeof vi struct into ecx
    mov (OSVINFO PTR [eax]).dwOSVersionInfoSize, ecx    ; copy size to element
    mov pvi, eax                        ; ptr to vi into pvi
    invoke GetVersionEx,pvi             ; get version API call
    cmp eax, 0                          ; See if we got an error
    je  IsWinNtError

    mov eax, pvi                        ; address back into eax
    mov ecx, (OSVINFO PTR [eax]).dwPlatformId  ; Platform ID into ecx
    cmp ecx, VER_PLATFORM_WIN32_NT      ; see if its an NT platform
    je  IsWinNtTrue

    mov eax, 0                          ; Return a Zero since its NOT NT
    ret

    IsWinNtTrue:
    mov eax, 1                          ; Return 1 since it IS NT
    ret

    IsWinNtError:
    mov eax, 2                          ; Return 2 indicating an Error

    ret

IsWinNt endp

; *************************************************************************
; For NT Type Platforms get the privilege for a Shutdown/Restart.

AdjustToken proc

    LOCAL hdlProcessHandle:DWORD
    LOCAL hdlTokenHandle:DWORD
    LOCAL tmpLuid:LUIDCUST
    LOCAL tkp:TOKEN_PRIVS
    LOCAL tkpNewButIgnored:TOKEN_PRIVS
    LOCAL lBufferNeeded:DWORD
    LOCAL tBuff[32]:BYTE
    LOCAL ptBuff:DWORD

    invoke GetCurrentProcess       ; get the current process handle
    mov hdlProcessHandle,eax       ; save it to hdlProcessHandle

    lea eax, tBuff                 ; address of temp buffer into eax
    mov ptBuff, eax                ; set pointer to temp buffer
    mov BYTE PTR [eax], 0          ; initialize the buffer

    invoke OpenProcessToken,hdlProcessHandle,40,ADDR hdlTokenHandle
    invoke LookupPrivilegeValue,ptBuff, SADD("SeShutdownPrivilege"), ADDR tmpLuid

    lea eax, tmpLuid               ; address of tmpLuid into eax

    ; Contents of tmpLuid into ecx:edx
    mov ecx, (LUIDCUST PTR [eax]).usedpart
    mov edx, (LUIDCUST PTR [eax]).ignorehigh32bitpart

    lea eax, tkp                   ; address of tkp into eax

    mov (TOKEN_PRIVS PTR [eax]).privilegecount, 1
    mov (TOKEN_PRIVS PTR [eax]).theluid.usedpart, ecx
    mov (TOKEN_PRIVS PTR [eax]).theluid.ignorehigh32bitpart, edx
    mov (TOKEN_PRIVS PTR [eax]).attributes, 2

    invoke AdjustTokenPrivileges,hdlTokenHandle,0,ADDR tkp,\
        SizeOf tkpNewButIgnored,ADDR tkpNewButIgnored,ADDR lBufferNeeded

    ret

AdjustToken endp

; *************************************************************************

end Start