;##########################################################################
    .386
    .model flat, stdcall
    option casemap :none

    include Header.asm

    WM_SHELLNOTIFY equ WM_USER + 1

.data
    WindowTitle     db "Tools", 0
    strSettings     db "&Settings", 0
    strExit         db "&Exit", 0
    strRestartMe    db "&Refresh", 0
    strHelp         db "&Help", 0
    HelpName        db "Help.chm", 0
    FileName        db "Settings.ini", 0
    strNotFound     db "The specified file can't be opened.", 0
    strRestart      db "You must refresh menus after you save changes to Settings.ini", 0
    SorryNT         db "WinNT and Win2K are not supported.", 0
    strOpen         db "open", 0

.data?
    hInstance       dd ?
    hWnd            dd ?
    hMenu           dd ?
    Notify          NOTIFYICONDATA <>
    Cursor          POINT <>
    hFile           dd ?
    hMenus          dd ?
    FileSize        dd ?
    NumBytes        dd ?
    LastPos         dd ?
    CurPos          dd ?
    hBuffer         dd ?
    Index           dd ?
    Me              dd ?
    GotIndex        db ?
    GotName         db ?
    GotParams       db ?
    GotShow         db ?
    hName           dd ?
    hParams         dd ?
    hDir            dd ?
    Show            db ?
    RetVal          db ?

.code
;##########################################################################
start:

    ;=============================
    ; CHECK FOR PREVIOUS INSTANCE
    ;=============================
    invoke SecondInstance, ADDR WindowTitle, ADDR WindowTitle
    .if eax != 0
        jmp quit
    .endif

    invoke GetModuleHandle, NULL
    mov hInstance, eax   
    invoke WinMain, hInstance, NULL, 0, SW_SHOWDEFAULT
quit:    
    invoke ExitProcess, 0
;==========================================================================
WinMain PROC    hInst   :DWORD,
                Msg     :DWORD,
                wParam  :DWORD,
                lParam  :DWORD

    LOCAL wMsg      :MSG

    ;=====================
    ; EXIT IF NT DETECTED
    ;=====================
    invoke IsNT
    .if eax == TRUE
        invoke MessageBox, NULL,
                           ADDR SorryNT,
                           NULL,
                           MB_OK or MB_ICONEXCLAMATION
        jmp quit
    .endif

    ;===================
    ; CREATE THE WINDOW
    ;===================
    invoke MakeWindow, ADDR WindowTitle,
                       ADDR WindowTitle,
                       WS_CAPTION or WS_SYSMENU,
                       0, 0, 0, 0,
                       ADDR WinProc,
                       hInst,
                       1,
                       NULL
    mov hWnd, eax

    ;======================
    ; CREATE THE TRAY ICON
    ;======================
    mov Notify.cbSize, sizeof NOTIFYICONDATA
    m2m Notify.hwnd, hWnd
    mov Notify.uID, 1
    mov Notify.uFlags, NIF_ICON or NIF_MESSAGE or NIF_TIP
    mov Notify.uCallbackMessage, WM_SHELLNOTIFY
    invoke LoadIcon, hInstance, 2
    mov Notify.hIcon, eax
    lea ebx, Notify.szTip
    lea eax, WindowTitle
    CopyMemory ebx, eax, 6
    invoke Shell_NotifyIcon, NIM_ADD, ADDR Notify

    ;=======================
    ; CREATE THE POPUP MENU
    ;=======================
    invoke CreatePopupMenu
    mov hMenu, eax

    ; Open file
    invoke CreateFile, ADDR FileName, 
                       GENERIC_READ,
                       FILE_SHARE_READ,
                       NULL,
                       OPEN_ALWAYS,
                       FILE_ATTRIBUTE_ARCHIVE,
                       NULL
    mov hFile, eax
    invoke GetFileSize, hFile, NULL
    mov FileSize, eax
    ; Allocate memory
    mov eax, FileSize
    add eax, 16
    invoke GlobalAlloc, GMEM_FIXED, eax
    mov hMenus, eax
    ; Read data
    invoke ReadFile, hFile, hMenus, FileSize, ADDR NumBytes, NULL
    m2m FileSize, NumBytes
    ;..........................................................Process data
    xor ebx, ebx
    mov LastPos, 0
    mov Index, 5
    .while TRUE
        EnterAgain:
        add hMenus, ebx
        get hMenus, 0
        sub hMenus, ebx
        .if al == 13
        OnceAgain:
            inc ebx
            mov CurPos, ebx
            sub ebx, LastPos
            push ebx
            add ebx, 16
            invoke GlobalAlloc, GMEM_FIXED, ebx
            mov hBuffer, eax            
            mov eax, hMenus
            add eax, LastPos
            pop ebx
            dec ebx
            CopyMemory hBuffer, eax, ebx
            mov ecx, hBuffer
            add ecx, ebx
            mov al, 0
            put ecx, 0
            inc ebx

            invoke LTrim, hBuffer
            inc hBuffer
            invoke LTrim, hBuffer
            dec hBuffer

            invoke lstrlen, hBuffer
            .if eax == 0
                mov al, ';'
                put hBuffer, 0
            .endif

            get hBuffer, 0
            inc Index
            .if al == '-'                         ;// SEPARATOR
                dec Index
                invoke AppendMenu, hMenu, MF_SEPARATOR, 0, NULL
            .elseif al == '%'                     ;// SUB MENU START
                dec Index
                invoke CreatePopupMenu
                push eax
                inc hBuffer
                invoke AppendMenu, hMenu, MF_POPUP or MF_STRING, eax, hBuffer
                pop eax
                push hMenu
                mov hMenu, eax
                dec hBuffer
                invoke GlobalFree, hBuffer
                add ebx, LastPos
                m2m LastPos, CurPos
                inc LastPos
                jmp EnterAgain
            .elseif al == "@"                     ;// SUB MENU END
                dec Index
                pop hMenu
            .elseif al == ">"                     ;// FILE TO OPEN
                dec Index
                ; Do Nothing
            .elseif al == "<"                     ;// PARAMETERS
                dec Index
                ; Do Nothing
            .elseif al == ":"                     ;// SHOW STATE
                dec Index
                ; Do Nothing
            .elseif al == ";"                     ;// COMMENT
                dec Index
                ; Do Nothing
            .else                                 ;// ITEM NAME
                invoke AppendMenu, hMenu, MF_STRING, Index, hBuffer
            .endif
            invoke GlobalFree, hBuffer
            add ebx, LastPos
            m2m LastPos, CurPos
            inc LastPos
        .else
            inc ebx
        .endif
        .break .if ebx > NumBytes
        .if ebx == NumBytes
            jmp OnceAgain
        .endif
    .endw
    ;......................................................................
    ; Free memory
    invoke GlobalFree, hMenus
    ; Close File
    invoke CloseHandle, hFile

    invoke AppendMenu, hMenu, MF_SEPARATOR, 0, NULL
    invoke AppendMenu, hMenu, MF_STRING, 3, ADDR strSettings
    invoke AppendMenu, hMenu, MF_STRING, 2, ADDR strRestartMe
    invoke AppendMenu, hMenu, MF_STRING, 4, ADDR strHelp
    invoke AppendMenu, hMenu, MF_STRING, 1, ADDR strExit
    invoke SetMenuDefaultItem, hMenu, 3, FALSE

    ;============================
    ; SET LOWEST THREAD PRIORITY
    ;============================
    invoke GetCurrentThread
    invoke SetThreadPriority, eax, THREAD_PRIORITY_LOWEST

    ;==============
    ; MESSAGE LOOP
    ;==============
    .while TRUE
        invoke PeekMessage, ADDR wMsg, NULL, 0, 0, PM_REMOVE
        .if eax != 0
            mov eax, wMsg.message
            .if eax == WM_QUIT
                xor eax, eax
                ret
            .endif
            invoke TranslateMessage, ADDR wMsg
            invoke DispatchMessage, ADDR wMsg
        .endif
    .endw

    xor eax, eax
    ret
WinMain ENDP
;==========================================================================

WinProc     PROC        hWindow         :DWORD,
                        Msg             :DWORD,
                        wParam          :DWORD,
                        lParam          :DWORD

    .if Msg == WM_SHELLNOTIFY
        .if lParam == WM_RBUTTONDOWN
            invoke GetCursorPos, ADDR Cursor
            invoke SetForegroundWindow, hWindow
            invoke TrackPopupMenu, hMenu,
                                   TPM_RIGHTALIGN,
                                   Cursor.x, Cursor.y,
                                   0,
                                   hWindow,
                                   NULL
            invoke PostMessage, hWnd, WM_MOUSEMOVE, 0, 0
        .endif
        .if lParam == WM_LBUTTONDBLCLK
            jmp RefreshMe
        .endif
    .elseif Msg == WM_COMMAND
        .if wParam == 1
            invoke DestroyWindow, hWindow
        .elseif wParam == 2
            ;=============
            ; RESTART APP
            ;=============
            invoke SetWindowText, hWindow, NULL
            invoke GlobalAlloc, GMEM_FIXED, 128
            mov Me, eax            
            invoke GetModuleFileName, NULL, Me, 128
            invoke ShellExecute, NULL,
                                 ADDR strOpen,
                                 Me,
                                 NULL,
                                 NULL,
                                 SW_HIDE
            invoke GlobalFree, Me
            jmp CloseMe
        .elseif wParam == 3
            RefreshMe:
            pushad
            ;===================
            ; OPEN SETTINGS.INI
            ;===================
            invoke MessageBox, hWindow,
                               ADDR strRestart,
                               ADDR WindowTitle,
                               MB_OK or MB_ICONINFORMATION or MB_SYSTEMMODAL
            invoke ShellExecute, NULL,
                                 ADDR strOpen,
                                 ADDR FileName,
                                 NULL,
                                 NULL,
                                 SW_SHOWDEFAULT
            popad
        .elseif wParam == 4
            invoke ShellExecute, NULL,
                                 ADDR strOpen,
                                 ADDR HelpName,
                                 NULL,
                                 NULL,
                                 SW_SHOWMAXIMIZED            
        .else
            invoke Execute, wParam
            .if eax == FALSE
                invoke MessageBox, NULL, ADDR strNotFound, NULL, MB_OK or MB_ICONWARNING
            .endif
        .endif
    .elseif Msg == WM_DESTROY
        ;=======================
        ; CLOSE THE APPLICATION
        ;=======================
        CloseMe:
        invoke Shell_NotifyIcon, NIM_DELETE, ADDR Notify
        invoke PostQuitMessage, 0
    .endif
    invoke DefWindowProc, hWindow, Msg, wParam, lParam
    ret
WinProc ENDP
;==========================================================================

Execute PROC srci :DWORD

    mov RetVal, FALSE
    mov Show, 0

    ; Open file
    invoke CreateFile, ADDR FileName, 
                       GENERIC_READ,
                       FILE_SHARE_READ,
                       NULL,
                       OPEN_ALWAYS,
                       FILE_ATTRIBUTE_ARCHIVE,
                       NULL
    mov hFile, eax
    invoke GetFileSize, hFile, NULL
    mov FileSize, eax
    ; Allocate memory
    add eax, 16
    invoke GlobalAlloc, GMEM_FIXED, eax
    mov hMenus, eax
    ; Read data
    invoke ReadFile, hFile, hMenus, FileSize, ADDR NumBytes, NULL
    m2m FileSize, NumBytes
    ;..........................................................Process data
    xor ebx, ebx
    mov LastPos, 0
    mov Index, 5
    .while TRUE
        add hMenus, ebx
        get hMenus, 0
        sub hMenus, ebx
        .if al == 13
        OnceAgain2:
            inc ebx
            mov CurPos, ebx
            sub ebx, LastPos
            push ebx
            add ebx, 16
            invoke GlobalAlloc, GMEM_FIXED, ebx
            mov hBuffer, eax            
            mov eax, hMenus
            add eax, LastPos
            pop ebx
            dec ebx
            CopyMemory hBuffer, eax, ebx
            mov ecx, hBuffer
            add ecx, ebx
            mov al, 0
            put ecx, 0
            inc ebx

            invoke LTrim, hBuffer
            inc hBuffer
            invoke LTrim, hBuffer
            dec hBuffer

            invoke lstrlen, hBuffer
            .if eax == 0
                mov al, ';'
                put hBuffer, 0
            .endif

            get hBuffer, 0
            inc Index
            .if al == '-'                         ;// SEPARATOR
                dec Index
                ; Do Nothing
            .elseif al == '%'                     ;// SUB MENU START
                dec Index
                ; Do Nothing
            .elseif al == "@"                     ;// SUB MENU END
                dec Index
                ; Do Nothing
            .elseif al == ">"                     ;// FILE TO OPEN
                pushad
                dec Index
                .if (GotIndex == TRUE) && (GotName != TRUE)
                    mov GotName, TRUE
                    invoke lstrlen, hBuffer
                    push eax
                    add eax, 16
                    invoke GlobalAlloc, GMEM_FIXED, eax
                    mov hName, eax
                    mov ebx, hBuffer
                    inc ebx
                    pop eax
                    dec eax
                    CopyMemory hName, ebx, eax
                    mov ebx, hName
                    add ebx, eax
                    mov al, 0
                    put ebx, 0
                .endif
                popad
            .elseif al == "<"                     ;// PARAMETERS
                pushad
                dec Index
                .if (GotName == TRUE) && (GotParams == FALSE)
                    mov GotParams, TRUE
                    invoke lstrlen, hBuffer
                    push eax
                    add eax, 16
                    invoke GlobalAlloc, GMEM_FIXED, eax
                    mov hParams, eax
                    mov ebx, hBuffer
                    inc ebx
                    pop eax
                    dec eax
                    CopyMemory hParams, ebx, eax
                    mov ebx, hParams
                    add ebx, eax
                    mov al, 0
                    put ebx, 0
                .endif
                popad
            .elseif al == ":"                     ;// SHOW STATE
                pushad
                dec Index
                .if (GotName == TRUE) && (GotShow == FALSE)
                    get hBuffer, 1
                    sub al, 48
                    mov Show, al
                    mov GotShow, TRUE
                .endif
                popad
            .elseif al == ";"                     ;// COMMENT
                dec Index
                ; Do Nothing
            .else                                 ;// ITEM NAME
                pushad
                .if (GotIndex == TRUE) && (GotName == TRUE)
                    jmp Exec
                    .break
                .endif
                mov eax, Index
                .if eax == srci
                    mov GotIndex, TRUE
                .endif
                popad
            .endif
            invoke GlobalFree, hBuffer
            add ebx, LastPos
            m2m LastPos, CurPos
            inc LastPos
        .else
            inc ebx
        .endif
        .if ebx > NumBytes
            .if GotName == TRUE
                jmp Exec
            .endif
            .break
        .endif
        .if ebx == NumBytes
            jmp OnceAgain2
        .endif
    .endw
    jmp SkipExec
    Exec:
    ;=====================
    ; OPENS SELECTED FILE
    ;=====================
    .if Show == 4
        mov Show, SW_HIDE
    .elseif Show == 2
        mov Show, SW_SHOWMAXIMIZED
    .elseif Show == 3
        mov Show, SW_SHOWMINIMIZED
    .else
        mov Show, SW_RESTORE
    .endif
    .if GotParams == FALSE
        mov hParams, NULL
        invoke lstrlen, hName
        mov ecx, eax
        @@:
        dec ecx
        get hName, ecx
        cmp al, '\'
        jnz @B
        mov eax, ecx
        inc eax
        push ecx
        add eax, 16
        invoke GlobalAlloc, GMEM_FIXED, eax
        mov hDir, eax
        pop ecx
        add ecx, 3
        CopyMemory hDir, hName, ecx
        sub ecx, 2
        mov al, 0
        put hDir, ecx
    .else
        invoke lstrlen, hParams
        mov ecx, eax
        @@:
        dec ecx
        get hParams, ecx
        cmp al, '\'
        jnz @B
        mov eax, ecx
        inc eax
        push ecx
        add eax, 16
        invoke GlobalAlloc, GMEM_FIXED, eax
        mov hDir, eax
        pop ecx
        add ecx, 3
        CopyMemory hDir, hParams, ecx
        sub ecx, 2
        mov al, 0
        put hDir, ecx
    .endif
    invoke ShellExecute, NULL,
                         ADDR strOpen,
                         hName,
                         hParams,
                         hDir,
                         Show
    .if eax > 32
        mov RetVal, TRUE
    .else
        mov RetVal, FALSE
    .endif

    mov GotIndex, FALSE
    mov GotName, FALSE
    mov GotParams, FALSE
    mov GotShow, FALSE
    ;......................................................................
    SkipExec:
    ; Free memory
    invoke GlobalFree, hMenus
    invoke GlobalFree, hParams
    invoke GlobalFree, hDir
    invoke GlobalFree, hName
    ; Close File
    invoke CloseHandle, hFile

    mov GotIndex, FALSE
    movzx eax, RetVal
    ret
Execute ENDP
;##########################################################################
end start