;TASM_DOS_EXE

.model tiny
.stack 64
.code

_start:
	mov	ah,9				; \                          
	mov	dx,(offset caption+100h)        ;   put caption on the screen
	int	21h                             ; /                          

	xor	di,di                           ; es:di = 0 on entry
	mov	es,di              		;
	mov	ax,1684h           		; function number
	mov	bx,0027h			; VXDLDR_DEVICE_ID
	int	2Fh				; get pmode API address
	mov	ax,es				; if es:di = 0, VXDLDR was
	or 	ax,di				; not loaded
	mov	cx,-1                           ; cx = FFFF for string ops
	jmp	$+6				; skip next dword
	dd	0				; LE header offset put by link
	jz	vxdldr_not_there		; 
	mov	word ptr [_VXDLDRCallAddr+100h],di	; es:di = ptr pmode API
	mov	word ptr [_VXDLDRCallAddr+100h+2],es	; 

	mov	es,ds:[2Ch]			; assembles to: mov es,[2Ch]
	xor	di,di                           ;
	xor	al,al                           ;
@@:	repne	scasb                           ; \
	scasb					;  \
	jnz	@@                              ;   search for executable name 
	inc	di				;   and put its offset on stack
	inc	di				;  /
	push	di				; /
	repne	scasb				; goto end of the name
	std                                     ; now search backwards...
	mov	al,'.'				; ...for the dot before file
	repne	scasb				; extension...
	inc	di				;
	mov	byte ptr es:[di],0		; ...and replace it with zero 
	push	di				; save offset of dot
	mov	al,'\'				; lets find '\'
	repne	scasb				; 
	
						; dx = ofs to null terminated
	lea	dx,[di+2]			; filename without extension
	mov	ax,2				; ax = 2 (Unload driver)
	mov	bx,-1				; bx = -1 --> ds:dx = drv name
	push	es				;
	pop	ds				; 
	db	09Ah				; call PTR16:PTR16
_VXDLDRCallAddr	dd 0                            ;
	pop	di				; restore offset of dot
	pop	dx				; restore name offset
	jnc	unloaded			;
	
	mov	ax,1				; ax = 1 (Load driver)
	mov	byte ptr [di],'.'		; restore extension dot
	call	dword ptr cs:[_VXDLDRCallAddr]  ; call VXDLOADER
	jnc	loaded				;
 
vxdldr_not_there:
	mov	dx,(offset error)
	jmp	exit

loaded:
 	mov	dx,(offset load_msg)
	jmp	exit

unloaded:
 	mov	dx,(offset unload_msg)

exit:
	push	cs
	pop	ds
 	mov	ah,9
 	int	21h
	mov	dx,(offset btm_line)
	int	21h	

	mov	ax,4C00h
	int	21h

caption		db 13,10,"ͻ"
		db 13,10,"  BuBu's VxD Stub-Loader v1.00.1023.  "
		db 13,10,"     (c) 2000 by BuBu.  Freeware.     "
		db 13,10,"ĺ",'$'
error		db 13,10,"    Error: Could not load driver.     ",'$'
load_msg	db 13,10,"     Driver successfully loaded.      ",'$'
unload_msg	db 13,10,"    Driver successfully unloaded.     ",'$'
btm_line	db 13,10,"ͼ",13,10,'$'

end	_start
