;
;  BlackBook    All Coded By Angelo Dureghello - Free Software
;   
;
;               HYSTORY
;               -------
;               
;               BlackBook  rev001     start  09-11-01
;                                     ready  14-11-01
;
;
;               BlackBook  rev002            15-11-01
;               --------------------------------------
;               * corrected important icon                    
;               * corretted useful  icon                     
;               * added ebx,esi,edi preservation                
;               
;
;               BlackBook  rev003            17-11-01
;               --------------------------------------
;               * corrected delete function                   
;
;
;               BlackBook  rev004            17-11-01
;               --------------------------------------
;               * gived more space to the list
;               * added size in k on about dlg
;               * changed icons graphics 
;               * corrected bad soting and damaging items
;
;
;               BlackBook  rev005            17-11-01
;               --------------------------------------
;               * added registers preservation for 2k compatibility
;               * no jump trough procedures
;               * protecting from LAST DELETION
;
; 
;
;                           oooo$$$$$$$$$$$$oooo
;                       oo$$$$$$$$$$$$$$$$$$$$$$$$o
;                    oo$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$o         o$   $$ o$
;    o $ oo        o$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$o       $$ $$ $$o$
; oo $ $ "$      o$$$$$$$$$    $$$$$$$$$$$$$    $$$$$$$$$o       $$$o$$o$
; "$$$$$$o$     o$$$$$$$$$      $$$$$$$$$$$      $$$$$$$$$$o    $$$$$$$$
;   $$$$$$$    $$$$$$$$$$$      $$$$$$$$$$$      $$$$$$$$$$$$$$$$$$$$$$$
;   $$$$$$$$$$$$$$$$$$$$$$$    $$$$$$$$$$$$$    $$$$$$$$$$$$$$  """$$$
;    "$$$""""$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$     "$$$
;     $$$   o$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$     "$$$o
;    o$$"   $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$       $$$o
;    $$$    $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$" "$$$$$$ooooo$$$$o
;   o$$$oooo$$$$$  $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$   o$$$$$$$$$$$$$$$$$
;   $$$$$$$$"$$$$   $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$     $$$$""""""""
;  """"       $$$$    "$$$$$$$$$$$$$$$$$$$$$$$$$$$$"      o$$$
;             "$$$o     """$$$$$$$$$$$$$$$$$$"$$"         $$$
;               $$$o          "$$""$$$$$$""""           o$$$
;                $$$$o                 oo             o$$$"
;                 "$$$$o      o$$$$$$o"$$$$o        o$$$$
;                   "$$$$$oo     ""$$$$o$$$$$o   o$$$$""
;                      ""$$$$$oooo  "$$$o$$$$$$$$$"""
;                         ""$$$$$$$oo $$$$$$$$$$
;                                 """"$$$ asm $$$
;                                     $$$$$$$$$$$$
;                                      $$$$$$$$$$"
;                                       "$$$""""

        .386
        .model flat,stdcall                                                 
        locals                                                
        jumps                                                  
                       
        include bbook.inc

        extrn   BeginPaint              :Proc
        extrn   CloseHandle             :Proc
        extrn   CreateFileA             :Proc
        extrn   CreateFontA             :Proc
        extrn   CreateWindowExA         :Proc
        extrn   DefWindowProcA          :Proc
        extrn   DeviceIoControl         :Proc
        extrn   DialogBoxParamA         :Proc
        extrn   DispatchMessageA        :Proc
        extrn   EndDialog               :Proc
        extrn   EndPaint                :Proc
        extrn   ExitProcess             :Proc
        extrn   GetClientRect           :Proc
        extrn   GetCommandLineA         :Proc
        extrn   GetFileSize             :Proc
        extrn   GetLastError            :Proc
        extrn   GetModuleHandleA        :Proc
        extrn   GetMessageA             :Proc
        extrn   GetVolumeInformationA   :Proc
        extrn   GlobalAlloc             :Proc
        extrn   ImageList_AddIcon       :Proc
        extrn   ImageList_Create        :Proc
        extrn   InitCommonControls      :Proc
        extrn   lstrcmpi                :Proc
        extrn   lstrcpy                 :Proc
        extrn   lstrlen                 :Proc
        extrn   LoadCursorA             :Proc
        extrn   LoadIconA               :Proc
        extrn   LoadMenuA               :Proc
        extrn   MessageBoxA             :Proc
        extrn   PostQuitMessage         :Proc
        extrn   ReadFile                :Proc
        extrn   RegisterClassExA        :Proc
        extrn   SelectObject            :Proc
        extrn   SendDlgItemMessageA     :Proc
        extrn   SendMessageA            :Proc
        extrn   SetTextColor            :Proc
        extrn   SetWindowLongA          :Proc
        extrn   SetBkColor              :proc
        extrn   SetFocus                :Proc
        extrn   ShowWindow              :Proc
        extrn   TextOutA                :Proc
        extrn   TranslateMessage        :Proc
        extrn   UpdateWindow            :Proc
        extrn   CallWindowProcA         :Proc
        extrn   WriteFile               :Proc

;       resources equates
IDR_MENU1               equ     100
IDD_ADDNEW              equ     200
IDD_MODIFY              equ     201
IDD_ABOUT               equ     202
IDI_BBOOK               equ     500
IDI_FRIENDS             equ     501
IDI_JOB                 equ     502
IDI_RELATIVE            equ     503
IDI_IMPORTANT           equ     504
IDI_USEFUL              equ     505

; menu commands
IDM_FILE                equ     5000
IDM_EXIT                equ     5001

IDM_ORDERING            equ     5100
IDM_TYPENAME            equ     5101
IDM_NAME                equ     5102

IDM_RECORDS             equ     5200
IDM_ADDNEW              equ     5201
IDM_MODIFY              equ     5202
IDM_DELETE              equ     5203

IDM_ABOUT               equ     5300
IDM_ABBBOOK             equ     5301

; dialog boxes commands
IDC_TYPE                equ     600
IDC_NAME                equ     601
IDC_HNUM                equ     602
IDC_CNUM                equ     603
IDC_JNUM                equ     604
IDC_FNUM                equ     605
IDC_ADDR                equ     606
IDC_MAIL                equ     607
IDB_AN_ADD              equ     700
IDB_AN_EXIT             equ     701
IDB_MO_UPD              equ     702
IDB_MO_EXIT             equ     703

; commands of main windows
ID_LISTVIEW             equ     2000

; RECORD REV.1  total dimension 161 bytes
TypeLength              equ      1
NameLength              equ      25
HomeLength              equ      20     
CellLength              equ      15  
JobLength               equ      20  
FaxnLength              equ      20    
AddrLength              equ      30
MailLength              equ      30

ILRECORD        STRUC

rType           db      TypeLength dup (?)
rName           db      NameLength dup (?)
rHomeNum        db      HomeLength dup (?)
rCellNum        db      CellLength dup (?)
rJobNum         db      JobLength  dup (?)
rFaxNum         db      FaxnLength dup (?)
rAddress        db      AddrLength dup (?)
rEmail          db      MailLength dup (?)
ILRECORD        ENDS

.const
; column definition ..
ColType         dd      20
ColName         dd      200
ColHomeNum      dd      100
ColCellNum      dd      100
ColJobNum       dd      100
ColFaxNum       dd      100
ColAddress      dd      150
ColEmail        dd      150

; for cycle RefreshMemory, to update with the record !
TLength         dd      TypeLength
NLength         dd      NameLength
HLength         dd      HomeLength
CLength         dd      CellLength
JLength         dd      JobLength
FLength         dd      FaxnLength
ALength         dd      AddrLength
MLength         dd      MailLength

; icon size definition
CX_SMALLICON    dd      16
CY_SMALLICON    dd      16

.data
; other strings ..
Caption         db      'BlackBook',0
ClassName       db      'BlackBook',0
FileName        db      'data.bbr',0
Temporary       db      30 dup (0),0

; classes
szListView      db      'SysListView32',0
ButtClass       db      'BUTTON',0 

; fonts
Font1           db      'Arial',0 

; window texts
About1          db      'BlackBook is Freeware !',0
About2          db      'any comments, send to: asm@ngi.it',0

; variables to initialize ..
TypeSortOrder   dd      0
NameSortOrder   dd      0

; list titles...
szColType       db      'C',11 dup (0)
szColName       db      'Name',8 dup (0)
szColHomeNum    db      'Home Number',0
szColCellNum    db      'Cell Number',0
szColJobNum     db      'Job Number',2 dup (0)
szColFaxNum     db      'Fax Number',2 dup (0)
szColAddress    db      'Address',5 dup (0)
szColEmail      db      'Email',6 dup (0)
szFriend        db      'Friend',0
szJob           db      'Job',0
szRelative      db      'Relative',0
szImportant     db      'Important person',0
szUseful        db      'Useful, Private',0
szButt_Exit     db      'Exit',0

ErrorCaption    db      'Error !',0
AttCaption      db      'Attention !',0
Message01       db      'First you must select an item on the list !',0
Message02       db      'Confirm the deletion of item   ', 30 dup (0)

.data?

hImageList      dd      ?
hInstance       dd      ?
hListView       dd      ?
hWnd            dd      ?
hFont1          dd      ?
hDC             dd      ?  
hFileX          dd      ?
hIconFriends    dd      ?
hIconJob        dd      ?
hIconImportant  dd      ?
hIconRelative   dd      ?
hIconUseful     dd      ?
FileSize        dd      ?
TotNumRec       dd      ?
BytesRead       dd      ?
StartFileMem    dd      ?
ByteWritten     dd      ?
FriendIdx       dd      ?
JobIdx          dd      ?
RelativeIdx     dd      ?
ImportantIdx    dd      ?
UsefulIdx       dd      ?
SelectedItem    dd      ?
CommandLine     dd      ?
ActualPosition  dd      ?
BytesToMove     dd      ?
ListLong        dd      ?

; structures declaration
msg             MSGSTRUCT               <?>                     ; The Message Struct
rcClient        RECT                    <?>                     ; Rect structure
wc              WNDCLASSEX              <?>                     ; The Windows Class Struct
lvcol           LV_COLUMN               <?>                     ; column structure
ps              PAINTSTRUCT             <?>                     ; paint structure
lvi             LV_ITEM                 <?>                     ; item structure
rec             ILRECORD                <?>


.code

Start:          call    GetModuleHandleA, NULL
                mov     hInstance,eax                           ; we've got application's Instance

                call    GetCommandLineA
                mov     CommandLine,eax  

                call    InitCommonControls
                
                ; registering window class ...
                mov     wc.cbSize,size WNDCLASSEX   
                mov     wc.style,NULL
                mov     wc.lpfnWndProc,offset WndProc           
                mov     wc.cbClsExtra,NULL
                mov     wc.cbWndExtra,NULL
                push    hInstance
                pop     wc.hInst      
                mov     wc.hbrBackground,7
                mov     wc.lpszMenuName,IDR_MENU1
                mov     wc.lpszClassName,offset ClassName
                call    LoadIconA, hInstance, IDI_BBOOK         
                mov     wc.hIcon,eax
                mov     wc.hIconSm,eax        
                call    LoadCursorA, NULL, IDC_ARROW               
                mov     wc.hCursor,eax
                call    RegisterClassExA, offset wc

                ; Creating The Main Window
                call    CreateWindowExA, NULL, offset ClassName, offset Caption, \
                         WS_OVERLAPPED or WS_CAPTION or WS_SYSMENU or WS_MINIMIZEBOX, \
                         60, 100, 572, 360, NULL, NULL, hInstance, NULL
                mov     hWnd,eax                                     
                call    ShowWindow, hWnd, SW_SHOWNORMAL        
                call    UpdateWindow, hWnd  
                call    SetFocus, hWnd                   

MessageLoop:    call    GetMessageA, offset msg, 0, 0, 0
                cmp     eax,0
                je      RetML
                call    TranslateMessage, offset msg
                call    DispatchMessageA, offset msg
RetML:          jmp     MessageLoop
                mov     eax,msg.msWPARAM
                call    ExitProcess,0    

;-------------------------------------------------------------------------------------------------
WndProc         proc    uses ebx edx edi esi, hW:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD 

                cmp     wmsg,WM_CREATE
                je      Create
                cmp     wmsg,WM_DESTROY                         
                je      Destroy
                cmp     wmsg,WM_PAINT
                je      Paint
                cmp     wmsg,WM_COMMAND
                je      Commands
                cmp     wmsg,WM_NOTIFY
                je      Notify
                cmp     wmsg,WM_KEYDOWN
                je      KeyDown
                     
                call    DefWindowProcA, hW, wmsg, wparam, lparam    
                mov     wmsg,eax
                ret     
;******************************************************************************************
Create:         
;******************************************************************************************
                call    Initialize
                call    OpenFileX
                call    FillTheList
                jmp     @000

;******************************************************************************************
Paint:          
;******************************************************************************************
                call    BeginPaint, hW, offset ps       
                mov     hDC,eax    
                call    SelectObject, hDC, hFont1
                call    SetTextColor, hDC, Yellow
                call    SetBkColor, hDC, Black

                ;       Texts
                call    TextOutA, hDC, 12, 15, offset About1, 23
                call    TextOutA, hDC, 12, 27, offset About2, 33
             
                call    EndPaint, hW, offset ps
                jmp     @000

;******************************************************************************************
Commands:       
;******************************************************************************************

@001:           cmp     wparam,IDM_EXIT
                jnz     @002
                call    ClosingFileX
                call    ExitProcess,0
                jmp     @000
@002:           cmp     wparam,IDM_TYPENAME
                jnz     @003
                call    SortCol0
                call    RefreshMemory
                jmp     @000
@003:           cmp     wparam,IDM_NAME
                jnz     @004
                call    SortCol1
                call    RefreshMemory
                jmp     @000
@004:           cmp     wparam,IDM_ADDNEW
                jnz     @005
                call    DialogBoxParamA, hInstance, IDD_ADDNEW, hW, offset AddNewDlg, 0
                jmp     @000
@005:           cmp     wparam,IDM_MODIFY
                jnz     @006
                call    DialogBoxParamA, hInstance, IDD_MODIFY, hW, offset ModifyDlg, 0
                jmp     @000
@006:           cmp     wparam,IDM_DELETE
                jnz     @007
                call    DeleteRecord
                jmp     @000
@007:           cmp     wparam,IDM_ABBBOOK
                jnz     @000
                call    DialogBoxParamA, hInstance, IDD_ABOUT, hW, offset AboutDlg, 0
                jmp     @000

;******************************************************************************************
Notify:         
;******************************************************************************************
                mov     edi,lparam
                assume  edi:ptr NMHDR 
                mov     eax,[edi].hwndFrom 
                cmp     eax,hListView
                jne     @000
                cmp     [edi].code,LVN_COLUMNCLICK 
                jne     @dbclk
                assume  edi:ptr NM_LISTVIEW

;       sorting column 1
@si1:           cmp     [edi].niSubItem,1       ; clicked on SECOND column (name)
                jne     @si0
                call    SortCol1
                call    RefreshMemory
                jmp     @000

;       sorting column 0
@si0:           cmp     [edi].niSubItem,0       ; clicked on FIRST column (type)
                jne     @000
                call    SortCol0
                call    RefreshMemory       
                jmp     @000

                assume  edi:ptr NMHDR 

@dbclk:         cmp     [edi].code,NM_DBLCLK
                jne     @000
                call    DialogBoxParamA, hInstance, IDD_MODIFY, hW, offset ModifyDlg, 0
                jmp     @000

;******************************************************************************************
Destroy:        
;******************************************************************************************
                call    ClosingFileX
                call    ExitProcess, 0
                jmp     @000

;******************************************************************************************
KeyDown:        
;******************************************************************************************
@KF1:           cmp     wparam,VK_F1
                jne     @KF2
                call    SortCol0
                call    RefreshMemory
                jmp     @000
@KF2:           cmp     wparam,VK_F2
                jne     @KF5
                call    SortCol1
                call    RefreshMemory
                jmp     @000
@KF5:           cmp     wparam,VK_F5
                jne     @KF6
                call    DialogBoxParamA, hInstance, IDD_ADDNEW, hW, offset AddNewDlg, 0
                jmp     @000
@KF6:           cmp     wparam,VK_F6
                jne     @KCanc
                call    DialogBoxParamA, hInstance, IDD_MODIFY, hW, offset ModifyDlg, 0
                jmp     @000
@KCanc:         cmp     wparam,VK_DELETE
                jne     @000
                call    DeleteRecord

@000:           xor     eax,eax
                ret    

WndProc         endp

; 
;
;                               
;                                                    
;                              
;                                                    
;                                  
;
; 

; 
;        Addnew Dialog Box
; 

AddNewDlg       proc    uses ebx esi edi, hAddNew:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

                cmp     wmsg,WM_INITDIALOG
                je      AN_Init
                  
                cmp     wmsg,WM_COMMAND
                je      AN_Command

                jmp     AN_D

AN_Init:        call    SendMessageA, hAddNew, WM_SETICON, ICON_SMALL, wc.hIcon

                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_ADDSTRING, 0, offset szFriend
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_ADDSTRING, 0, offset szJob
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_ADDSTRING, 0, offset szRelative
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_ADDSTRING, 0, offset szImportant
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_ADDSTRING, 0, offset szUseful
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_SETCURSEL, 0, NULL

                 ; set limits of edit boxes
                call    SendDlgItemMessageA, hAddNew, IDC_NAME, EM_SETLIMITTEXT, NameLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_HNUM, EM_SETLIMITTEXT, HomeLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_CNUM, EM_SETLIMITTEXT, CellLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_JNUM, EM_SETLIMITTEXT, JobLength,  0
                call    SendDlgItemMessageA, hAddNew, IDC_FNUM, EM_SETLIMITTEXT, FaxnLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_ADDR, EM_SETLIMITTEXT, AddrLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_MAIL, EM_SETLIMITTEXT, MailLength, 0
                
                mov     eax,TRUE
                jmp     AN_D

AN_Command:     cmp     word ptr [wparam],IDB_AN_EXIT
                jne     @ANc1
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     AN_R
@ANc1:          cmp     word ptr [wparam],IDCANCEL
                jne     @ANc2
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     AN_R
@ANc2:          cmp     word ptr [wparam],IDB_AN_ADD
                jne     @ANc3
                call    AngeloZeroMem, offset rec, SIZE ILRECORD
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_GETCURSEL, 0, 0
                mov     rec.rType,al
                call    SendDlgItemMessageA, hAddNew, IDC_NAME, WM_GETTEXT, NameLength, offset rec.rName
                call    SendDlgItemMessageA, hAddNew, IDC_HNUM, WM_GETTEXT, HomeLength, offset rec.rHomeNum
                call    SendDlgItemMessageA, hAddNew, IDC_CNUM, WM_GETTEXT, CellLength, offset rec.rCellNum
                call    SendDlgItemMessageA, hAddNew, IDC_JNUM, WM_GETTEXT, JobLength,  offset rec.rJobNum
                call    SendDlgItemMessageA, hAddNew, IDC_FNUM, WM_GETTEXT, FaxnLength, offset rec.rFaxNum
                call    SendDlgItemMessageA, hAddNew, IDC_ADDR, WM_GETTEXT, AddrLength, offset rec.rAddress
                call    SendDlgItemMessageA, hAddNew, IDC_MAIL, WM_GETTEXT, MailLength, offset rec.rEmail
                call    AddNewRecord
                call    FillTheList
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     AN_R
@ANc3:          mov     eax,TRUE
                jmp     AN_R
AN_D:           mov     eax,FALSE   
AN_R:           ret  
                   
AddNewDlg       endp

; 
;       Modify Dialog Box
; 

ModifyDlg       proc    uses ebx esi edi, hModify:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

                cmp     wmsg,WM_INITDIALOG
                je      MO_Init
                  
                cmp     wmsg,WM_COMMAND
                je      MO_Command

                jmp     MO_D

MO_Init:        call    SendMessageA, hModify, WM_SETICON, ICON_SMALL, wc.hIcon

                ; carico il combobox
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_ADDSTRING, 0, offset szFriend
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_ADDSTRING, 0, offset szJob
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_ADDSTRING, 0, offset szRelative
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_ADDSTRING, 0, offset szImportant
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_ADDSTRING, 0, offset szUseful

                ; set limits of edit boxes
                call    SendDlgItemMessageA, hAddNew, IDC_NAME, EM_SETLIMITTEXT, NameLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_HNUM, EM_SETLIMITTEXT, HomeLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_CNUM, EM_SETLIMITTEXT, CellLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_JNUM, EM_SETLIMITTEXT, JobLength,  0
                call    SendDlgItemMessageA, hAddNew, IDC_FNUM, EM_SETLIMITTEXT, FaxnLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_ADDR, EM_SETLIMITTEXT, AddrLength, 0
                call    SendDlgItemMessageA, hAddNew, IDC_MAIL, EM_SETLIMITTEXT, MailLength, 0

                ; what item was selected on the list ?
                call    SendMessageA, hListView, LVM_GETNEXTITEM, -1, LVNI_FOCUSED
                mov     SelectedItem,eax

                ; if no item of the list is selected ....
                cmp     eax,-1
                jne     ItemIsSel
                call    MessageBoxA, hModify, offset Message01, offset ErrorCaption, MB_ICONWARNING
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     MO_R

                ; pointing ...
ItemIsSel:      mov     esi,StartFileMem
                mov     eax,SelectedItem
                mov     ebx,SIZE ILRECORD
                mul     ebx
                add     esi,eax

                ; Type reading
                xor     eax,eax
                mov     al,[esi]
                call    SendDlgItemMessageA, hAddNew, IDC_TYPE, CB_SETCURSEL, eax, NULL

                ; Name reading
                add     esi,TypeLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, NameLength
                call    SendDlgItemMessageA, hAddNew, IDC_NAME, WM_SETTEXT, 30, offset Temporary

                ; Home Num reading
                add     esi,NameLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, HomeLength
                call    SendDlgItemMessageA, hAddNew, IDC_HNUM, WM_SETTEXT, 30, offset Temporary

                ; Cell Num reading
                add     esi,HomeLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, CellLength
                call    SendDlgItemMessageA, hAddNew, IDC_CNUM, WM_SETTEXT, 30, offset Temporary

                ; Job Num reading
                add     esi,CellLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, JobLength
                call    SendDlgItemMessageA, hAddNew, IDC_JNUM, WM_SETTEXT, 30, offset Temporary

                ; Fax Num reading
                add     esi,JobLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, FaxnLength
                call    SendDlgItemMessageA, hAddNew, IDC_FNUM, WM_SETTEXT, 30, offset Temporary

                ; Address reading
                add     esi,FaxnLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, AddrLength
                call    SendDlgItemMessageA, hAddNew, IDC_ADDR, WM_SETTEXT, 30, offset Temporary

                ; EMAIL reading
                add     esi,AddrLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, MailLength
                call    SendDlgItemMessageA, hAddNew, IDC_MAIL, WM_SETTEXT, 30, offset Temporary
                
                jmp     MO_D

MO_Command:     cmp     word ptr [wparam],IDB_MO_EXIT
                jne     @MOc1
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     MO_R
@MOc1:          cmp     word ptr [wparam],IDCANCEL
                jne     @MOc2
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     MO_R
@MOc2:          cmp     word ptr [wparam],IDB_MO_UPD
                jne     @MOc3
                call    AngeloZeroMem, offset rec, LENGTH rec
                call    SendDlgItemMessageA, hModify, IDC_TYPE, CB_GETCURSEL, 0, 0
                mov     rec.rType,al
                call    SendDlgItemMessageA, hModify, IDC_NAME, WM_GETTEXT, NameLength, offset rec.rName
                call    SendDlgItemMessageA, hModify, IDC_HNUM, WM_GETTEXT, HomeLength, offset rec.rHomeNum
                call    SendDlgItemMessageA, hModify, IDC_CNUM, WM_GETTEXT, CellLength, offset rec.rCellNum
                call    SendDlgItemMessageA, hModify, IDC_FNUM, WM_GETTEXT, FaxnLength, offset rec.rFaxNum
                call    SendDlgItemMessageA, hModify, IDC_ADDR, WM_GETTEXT, AddrLength, offset rec.rAddress
                call    SendDlgItemMessageA, hModify, IDC_MAIL, WM_GETTEXT, MailLength, offset rec.rEmail
                call    ModifyRecord
                call    FillTheList
                call    EndDialog, hAddNew, TRUE
                mov     eax,TRUE
                jmp     MO_R
@MOc3:          jmp     MO_D

MO_D:           mov     eax,FALSE   
MO_R:           ret  
                   
ModifyDlg       endp

; 
;       About Dialog Box
; 

AboutDlg        proc    uses ebx esi edi, hAbout:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

                cmp     wmsg,WM_INITDIALOG
                mov     eax,TRUE
                jz      Return  
                cmp     wmsg,WM_COMMAND
                jnz     Default
                cmp     word ptr [wparam],IDOK
                jz      AboutEnd
                cmp     word ptr [wparam],IDCANCEL
                jnz     Default
AboutEnd:       call    EndDialog, hAbout, TRUE
                mov     eax,TRUE
                jmp     Return
Default:        mov     eax,FALSE       
Return:         ret  
                   
AboutDlg        endp

; 
;               Initialize the window
; 

Initialize      Proc    uses ebx ecx edx esi edi

                ;       fonts
                call    CreateFontA, 12, 0, 0, 0, FW_BOLD, 0, 0, 0, 0, 0, 0, 0, 0, offset Font1
                mov     hFont1,eax

                ;       icon loading
                call    LoadIconA, hInstance, IDI_FRIENDS
                mov     hIconFriends,eax
                call    LoadIconA, hInstance, IDI_JOB
                mov     hIconJob,eax
                call    LoadIconA, hInstance, IDI_RELATIVE
                mov     hIconRelative,eax
                call    LoadIconA, hInstance, IDI_IMPORTANT
                mov     hIconImportant,eax
                call    LoadIconA, hInstance, IDI_USEFUL
                mov     hIconUseful,eax
             
                ;       creating partitions list and assigning it a style; creating the associated image list            
                call    CreateWindowExA, WS_EX_CLIENTEDGE, offset szListView, NULL, \
                         LVS_REPORT or WS_CHILD or WS_VISIBLE, \
                         12, 45, 544, 255, hW, ID_LISTVIEW, hInstance, NULL
                mov     hListView,eax 

                call    SendMessageA, hListView, LVM_SETTEXTCOLOR, 0, Yellow
                call    SendMessageA, hListView, LVM_SETBKCOLOR, 0, Black
                call    SendMessageA, hListView, LVM_SETTEXTBKCOLOR, 0, Black

                call    SendMessageA, hListView, LVM_SETEXTENDEDLISTVIEWSTYLE, 0, LVS_EX_FULLROWSELECT or \
                         LVS_EX_HEADERDRAGDROP or LVS_EX_SUBITEMIMAGES
             
                call    ImageList_Create, CX_SMALLICON, CY_SMALLICON, ILC_MASK, 2, 0
                mov     hImageList,eax
                call    ImageList_AddIcon, hImageList, hIconFriends
                mov     FriendIdx,eax
                call    ImageList_AddIcon, hImageList, hIconJob
                mov     JobIdx,eax
                call    ImageList_AddIcon, hImageList, hIconRelative
                mov     RelativeIdx,eax
                call    ImageList_AddIcon, hImageList, hIconImportant
                mov     ImportantIdx,eax
                call    ImageList_AddIcon, hImageList, hIconUseful
                mov     UsefulIdx,eax

                call    SendMessageA, hListView, LVM_SETIMAGELIST, LVSIL_SMALL, hImageList  

                ;       listview columns insertion ..               
                mov     ecx,8
                mov     ebx,offset ColType
                mov     edx,offset szColType
                mov     esi,0
CreateColumns:  mov     eax,[ebx]
                mov     lvcol.lx,eax
                mov     lvcol.pszText,offset edx 
                mov     lvcol.imask,LVCF_FMT or LVCF_TEXT or LVCF_WIDTH
                mov     lvcol.fmt,LVCFMT_LEFT
                push    ecx edx
                call    SendMessageA, hListView, LVM_INSERTCOLUMN, esi, offset lvcol
                pop     edx ecx
                inc     esi
                add     ebx,4
                add     edx,12
                dec     ecx
                cmp     ecx,0
                jne     CreateColumns

                call    SetWindowLongA, hListView, GWL_WNDPROC, offset ListProc
                mov     ListLong, eax

                ret

Initialize      endp  

; 
;           Open DATA file (FileX)
; 
OpenFileX       proc    uses ebx edx

                ; apro il file
                call    CreateFileA, offset FileName, GENERIC_READ or GENERIC_WRITE,\
                        0, 0, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0
                mov     hFileX,eax

                ; ricavo la grandezza del file e il numero dei record...
                call    GetFileSize, hFileX, offset FileSize
                xor     edx,edx
                mov     FileSize,eax
                mov     bx,SIZE ILRECORD
                div     bx
                mov     TotNumRec,eax        

                ; creo lo spazio in memoria per il file
                cmp     TotNumRec,300
                jg      AllocBig
                call    GlobalAlloc, GMEM_FIXED, 64000
                jmp     Normal
AllocBig:       call    GlobalAlloc, GMEM_FIXED, 128000
Normal:         mov     StartFileMem, eax

                ; copio tutto il file in memoria e chiudo il file
                call    ReadFile, hFileX, eax, FileSize, offset BytesRead, NULL
                call    CloseHandle, hFileX

                ret

OpenFileX       endp

; 
;          item insertion from MEMORY
; 
FillTheList     Proc    uses ebx esi edi

                call    SendMessageA, hListView, LVM_DELETEALLITEMS, 0, 0
                mov     edi,TotNumRec
                cmp     edi,0
                je      EFTL
                mov     esi,StartFileMem
                xor     ebx,ebx                

AddAnother:     mov     al,byte ptr [esi]

                cmp     al,0
                jg      IconJob
                push    FriendIdx
                pop     lvi.itImage 
                jmp     AddItm    
IconJob:        cmp     al,1
                jg      IconRelative
                push    JobIdx
                pop     lvi.itImage 
                jmp     AddItm  
IconRelative:   cmp     al,2
                jg      IconImportant
                push    RelativeIdx
                pop     lvi.itImage 
                jmp     AddItm
IconImportant:  cmp     al,3
                jg      IconUseful
                push    ImportantIdx
                pop     lvi.itImage  
                jmp     AddItm
IconUseful:     push    UsefulIdx
                pop     lvi.itImage  

AddItm:         mov     lvi.itItem,ebx
                mov     lvi.itSubItem,0
                mov     lvi.itlParam,ebx
                mov     lvi.itmask, LVIF_IMAGE or LVIF_PARAM   
                call    SendMessageA, hListView, LVM_INSERTITEM, 0, offset lvi 

                ; Nome
                add     esi,TypeLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, NameLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 
                
                ; Home Num
                add     esi,NameLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, HomeLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 

                ; Cell Num
                add     esi,HomeLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, CellLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 

                ; Job Num
                add     esi,CellLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, JobLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 

                ; Fax Num
                add     esi,JobLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, FaxnLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 

                ; Address
                add     esi,FaxnLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, AddrLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 

                ; EMail
                add     esi,AddrLength
                lea     eax,Temporary
                call    AngeloZeroMem, eax, 30
                call    AngeloCopyMem, esi, eax, MailLength
                mov     lvi.imask,LVIF_TEXT
                mov     lvi.itpszText,eax
                mov     lvi.itItem,ebx
                inc     lvi.itSubItem
                call    SendMessageA, hListView, LVM_SETITEM, 0, offset lvi 
       
                ; end of cycle
                add     esi,MailLength
                inc     ebx
                dec     edi
                cmp     edi,0
                jne     AddAnother

EFTL:           ret

FillTheList     endp

; 
;            Riempimento nuovo record
; 
AddNewRecord    proc    uses ebx ecx 
                
                mov     ecx,StartFileMem
                mov     eax,size ILRECORD
                mov     ebx,TotNumRec
                mul     ebx
                add     ecx,eax      
                call    AngeloCopyMem, offset rec, ecx, size ILRECORD       ; salva in memoria
                inc     TotNumRec
                ret

AddNewRecord    endp

; 
;            Modifica record
; 
ModifyRecord    proc    uses ebx ecx

                mov     ecx,StartFileMem
                mov     eax,size ILRECORD
                mov     ebx,SelectedItem
                mul     ebx
                add     ecx,eax      
                call    AngeloCopyMem, offset rec, ecx, size ILRECORD       ; salva in memoria
                ret

ModifyRecord    endp

; 
;            Eliminma record
; 
DeleteRecord    proc    uses ebx ecx

                call    SendMessageA, hListView, LVM_GETNEXTITEM, -1, LVNI_FOCUSED
                mov     SelectedItem,eax        ; zero based

                ; if no item of the list is selected ....
                cmp     eax,-1
                jne     ItemIsSelD
                call    MessageBoxA, 0, offset Message01, offset ErrorCaption, MB_ICONWARNING
                jmp     @rDR

ItemIsSelD:     mov     ecx,StartFileMem
                mov     eax,size ILRECORD
                mov     ebx,SelectedItem
                mul     ebx
                add     ecx,eax
                mov     ActualPosition,ecx
                inc     ecx
                call    AngeloZeroMem, offset Message02[30], 30
                call    AngeloCopyMem, ecx, offset Message02[30], NameLength
                call    MessageBoxA, 0, offset Message02, offset AttCaption, MB_ICONWARNING or MB_OKCANCEL
                cmp     eax,2
                je      @rDR

                ; Tot-Act-RecordSize = move quantity                
                mov     eax,TotNumRec
                dec     eax                     ; becouse must be 0 indexed
                sub     eax,SelectedItem
                mov     ebx,size ILRECORD
                mul     ebx
                
                mov     BytesToMove,eax

                mov     eax,ActualPosition
                add     eax,size ILRECORD
                
                call    AngeloCopyMem, eax, ActualPosition, BytesToMove                 
                dec     TotNumRec
                call    FillTheList

@rDR:           ret

DeleteRecord    endp

; 
;            Closing All operation
; 
ClosingFileX    proc    uses ebx

                call    CreateFileA, offset FileName, GENERIC_READ or GENERIC_WRITE,\
                        0, 0, TRUNCATE_EXISTING, FILE_ATTRIBUTE_NORMAL, 0
                mov     hFileX,eax
                mov     eax,TotNumRec
                mov     ebx,size ILRECORD
                mul     ebx
                mov     FileSize, eax
                call    WriteFile, hFileX, StartFileMem, FileSize, offset ByteWritten, NULL
                call    CloseHandle, hFileX
                ret

ClosingFileX    endp

; 
;            AngeloCopyMem    copia blocco di memoria
; 
AngeloCopyMem   proc    uses eax ecx esi edi, Sorgente: DWORD, Destinazione: DWORD, NBytes: DWORD
                
                mov     esi,Sorgente
                mov     edi,Destinazione
                mov     ecx,NBytes
Copying:        mov     al,byte ptr [esi]
                mov     byte ptr [edi],al
                inc     esi
                inc     edi
                dec     ecx
                cmp     ecx,0
                jg      Copying
                ret
                
AngeloCopyMem   endp

; 
;            AngeloZeroMem    azzera blocco di memoria
; 
AngeloZeroMem   proc    uses ecx edi, Destinazione: DWORD, NBytes: DWORD
                
                mov     edi,Destinazione
                mov     ecx,NBytes
ZCopying:       mov     byte ptr [edi],0
                inc     edi
                dec     ecx
                cmp     ecx,0
                jg      ZCopying
                ret

AngeloZeroMem   endp

; 
;            ListView subclassing
; 
ListProc        proc    uses ebx esi edi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

                cmp     wmsg,WM_KEYDOWN
                jne     @LPend

@LP1:           cmp     wparam,VK_F1
                jne     @LP2
                call    SortCol0
                call    RefreshMemory
                jmp     @LPend
@LP2:           cmp     wparam,VK_F2
                jne     @LP5
                call    SortCol1
                call    RefreshMemory
                jmp     @LPend
@LP5:           cmp     wparam,VK_F5
                jne     @LP6
                call    DialogBoxParamA, hInstance, IDD_ADDNEW, hW, offset AddNewDlg, 0
                jmp     @LPend
@LP6:           cmp     wparam,VK_F6
                jne     @LPdel
                call    DialogBoxParamA, hInstance, IDD_MODIFY, hW, offset ModifyDlg, 0
                jmp     @LPend
@LPdel:         cmp     wparam,VK_DELETE
                mov     eax,wparam
                jne     @LPend
                call    DeleteRecord

@LPend:         call    CallWindowProcA, ListLong, hwnd, wmsg, wparam, lparam

                ret

ListProc        endp

; 
;            Sort column 0
; 
SortCol0        proc    uses ebx esi edi

@from_mnu0:     cmp     TypeSortOrder,0         ; not yet sorted, go to 4 (ascending)
                je      @srt0a
                cmp     TypeSortOrder,4         ; if SortType is now 4 (descending) then set to 3
                jne     @srt0b
@srt0a:         call    SendMessageA, hListView, LVM_SORTITEMS, 3, offset CompareFunc 
                call    UpdatelParam 
                mov     TypeSortOrder,3 
                jmp     @esc0
@srt0b:         call    SendMessageA, hListView, LVM_SORTITEMS, 4, offset CompareFunc 
                call    UpdatelParam 
                mov     TypeSortOrder,4  
@esc0:          ret

SortCol0        endp

; 
;            Sort column 1
; 
SortCol1        proc    uses ebx esi edi

@from_mnu1:     cmp     NameSortOrder,0         ; not yet sorted, go to 2 (ascending)
                je      @srt1a
                cmp     NameSortOrder,2         ; if SortType is now 2 (descending) then set 1
                jne     @srt1b
@srt1a:         call    SendMessageA, hListView, LVM_SORTITEMS, 1, offset CompareFunc 
                call    UpdatelParam 
                mov     NameSortOrder,1
                jmp     @esc1
@srt1b:         call    SendMessageA, hListView, LVM_SORTITEMS, 2, offset CompareFunc 
                call    UpdatelParam 
                mov     NameSortOrder,2         
@esc1:          ret

SortCol1        endp

; 
;            Compare function
; 
CompareFunc     proc    uses ebx esi edi, lParam1:DWORD, lParam2:DWORD, SortType:DWORD 
                
                LOCAL   buffer[256]     :BYTE 
                LOCAL   buffer1[256]    :BYTE 

                lea     ebx,lvi
                lea     esi,buffer1
                lea     edi,buffer

                mov     lvi.itmask,LVIF_TEXT 
                lea     eax,buffer 
                mov     lvi.itpszText,eax 
                mov     lvi.itcchTextMax,256 

@Stype1:        cmp     SortType,1 
                jne     @Stype2
                mov     lvi.itSubItem,1 
                call    SendMessageA, hListView, LVM_GETITEMTEXT, lParam1, ebx  
                call    lstrcpy, esi, edi
                call    SendMessageA, hListView, LVM_GETITEMTEXT, lParam2, ebx
                call    lstrcmpi, esi, edi       
                jmp     @outCmp
@Stype2:        cmp     SortType,2 
                jne     @Stype3
                mov     lvi.itSubItem,1 
                call    SendMessageA, hListView, LVM_GETITEMTEXT, lParam1, ebx
                call    lstrcpy, esi, edi
                call    SendMessageA, hListView, LVM_GETITEMTEXT, lParam2, ebx 
                call    lstrcmpi, edi, esi
                jmp     @outCmp
@Stype3:        cmp     SortType,3 
                jne     @Stype4
                mov     lvi.itSubItem,0
                mov     eax,lParam1
                mov     lvi.itItem,eax
                mov     lvi.itmask,LVIF_IMAGE
                call    SendMessageA, hListView, LVM_GETITEM, 0, ebx
                mov     eax,lvi.itImage
                mov     edi,eax
                mov     lvi.itSubItem,0 
                mov     eax,lParam2
                mov     lvi.itItem,eax
                mov     lvi.itmask,LVIF_IMAGE
                call    SendMessageA, hListView, LVM_GETITEM, 0, ebx
                mov     eax,lvi.itImage
                sub     edi,eax 
                mov     eax,edi 
                jmp     @outCmp
@Stype4:        mov     lvi.itSubItem,0
                mov     eax,lParam1
                mov     lvi.itItem,eax
                mov     lvi.itmask,LVIF_IMAGE
                call    SendMessageA, hListView, LVM_GETITEM, 0, ebx
                mov     eax,lvi.itImage
                mov     edi,eax 
                mov     lvi.itSubItem,0
                mov     eax,lParam2
                mov     lvi.itItem,eax
                mov     lvi.itmask,LVIF_IMAGE
                call    SendMessageA, hListView, LVM_GETITEM, 0, ebx
                mov     eax,lvi.itImage
                sub     eax,edi 
@outCmp:        ret 
CompareFunc     endp 

; 
;           UpdatelParam function    ok
; 
UpdatelParam    proc    uses edi 

                call    SendMessageA, hListView, LVM_GETITEMCOUNT, 0, 0 
                mov     edi,eax 
                mov     lvi.itmask,LVIF_PARAM 
                mov     lvi.itSubItem,0
                mov     lvi.itItem,0 
UpdateIt:       push    lvi.itItem 
                pop     lvi.itlParam 
                lea     eax,lvi
                call    SendMessageA, hListView, LVM_SETITEM, 0, eax
                inc     lvi.itItem
                dec     edi 
                cmp     edi,0
                jg      UpdateIt
                ret 

UpdatelParam    endp 

; 
;           Refresh Memory function 
; 
RefreshMemory   proc    uses ebx, ecx, edi, esi

                mov     ebx,StartFileMem
                call    SendMessageA, hListView, LVM_GETITEMCOUNT, 0, 0 
                mov     edi,eax 

                lea     esi,TLength

                mov     lvi.itItem,0
                mov     lvi.itSubItem,0

NextItem:       mov     lvi.itmask,LVIF_IMAGE
                call    SendMessageA, hListView, LVM_GETITEM, 0, offset lvi
                call    AngeloCopyMem, offset lvi.itImage, ebx, dword ptr [esi]
                add     ebx,[esi]
                add     esi,4
                
                mov     lvi.itmask,LVIF_TEXT
                lea     eax,Temporary
                mov     lvi.itpszText,eax

                inc     lvi.itSubItem
NextSubItem:    call    AngeloZeroMem, offset Temporary, 30
                call    SendMessageA, hListView, LVM_GETITEMTEXT, lvi.itItem, offset lvi
                call    AngeloCopyMem, offset Temporary, ebx, dword ptr [esi]
                add     ebx,[esi]
                add     esi,4
                inc     lvi.itSubItem
                cmp     lvi.itSubItem,7
                jle     NextSubItem
                inc     lvi.itItem
                mov     lvi.itSubItem,0
                lea     esi,TLength
                cmp     lvi.itItem,edi
                jl      NextItem

                ret

RefreshMemory   endp

                end     Start                      