;   DiskParty.inc, include file for diskparty.asm

;               STRUCTURES

POINT STRUCT
  x  DWORD ?
  y  DWORD ?
POINT ENDS

LV_COLUMN       STRUC

imask                   dd      ?
fmt                     dd      ?
lx                      dd      ?
pszText                 dd      ?
cchTextMax              dd      ?
iSubItem                dd      ?
iImage                  dd      ?
iOrder                  dd      ?
LV_COLUMN       ENDS

MSGSTRUCT       STRUC

msHWND                  dd      ?
msMESSAGE               dd      ?
msWPARAM                dd      ?
msLPARAM                dd      ?
msTIME                  dd      ?
msPT                    dd      2 dup(?)
MSGSTRUCT       ENDS

WNDCLASSEX      STRUC

cbSize                  dd      ?
style                   dd      ?
lpfnWndProc             dd      ?
cbClsExtra              dd      ?
cbWndExtra              dd      ?
hInst                   dd      ?
hIcon                   dd      ?
hCursor                 dd      ?
hbrBackground           dd      ?
lpszMenuName            dd      ?
lpszClassName           dd      ?
hIconSm                 dd      ?
WNDCLASSEX      ENDS

RECT            STRUC

left                    dd      ?
top                     dd      ?
right                   dd      ?
bottom                  dd      ?
RECT            ENDS

PAINTSTRUCT     STRUC
  pshdc         DWORD      ?
  fErase        DWORD      ?
  rcPaint       RECT       <>
  fRestore      DWORD      ?
  fIncUpdate    DWORD      ?
  rgbReserved   BYTE 32 dup(?)

PAINTSTRUCT     ENDS

LV_ITEM         STRUC

itmask                  dd      ? 
itItem                  dd      ? 
itSubItem               dd      ? 
state                   dd      ? 
stateMask               dd      ? 
itpszText               dd      ? 
itcchTextMax            dd      ? 
itImage                 dd      ? 
itlParam                dd      ? 
itIndent                dd      ? 
LV_ITEM         ENDS 

_PARTITION_INFORMATION  STRUC

StartingOffset          dw      ?       
PartitionLength         dw      ?       
HiddenSectors           dd      ?
PartitionNumber         dd      ?
PartitionType           db      ?
BootIndicator           db      ?
RecognizedPartition     db      ?
RewritePartition        db      ?
_PARTITION_INFORMATION  ENDS

OVERLAPPED              STRUC

Internal                dd      ?       ; 
InternalHigh            dd      ?       ; 
TOffset                 dd      ?       ; 
OffsetHigh              dd      ?       ; 
hEvent                  dd      ?       ; 
OVERLAPPED              ENDS 

NMHDR STRUCT
    hwndFrom    DWORD ?
    idFrom      DWORD ?
    code        DWORD ?
NMHDR ends

NM_LISTVIEW STRUCT
  nhdr          NMHDR      <>
  niItem        DWORD      ?
  niSubItem     DWORD      ?
  nuNewState    DWORD      ?
  nuOldState    DWORD      ?
  nuChanged     DWORD      ?
  nptAction     POINT      <>
  nlParam       DWORD      ?
NM_LISTVIEW ENDS

;--------------------------------------------------------------------------------------------------------------

;       Various

NORM_IGNORECASE                 equ 1h
LOCALE_USER_DEFAULT             equ 0400h

RDW_INVALIDATE                       equ 1h
RDW_INTERNALPAINT                    equ 2h
RDW_ERASE                            equ 4h
RDW_VALIDATE                         equ 8h
RDW_NOINTERNALPAINT                  equ 10h
RDW_NOERASE                          equ 20h
RDW_NOCHILDREN                       equ 40h
RDW_ALLCHILDREN                      equ 80h
RDW_UPDATENOW                        equ 100h
RDW_ERASENOW                         equ 200h
RDW_FRAME                            equ 400h
RDW_NOFRAME                          equ 800h

NULL                            equ 0h
TRUE                            equ 1h
FALSE                           equ 0h
CLR_NONE                        equ 0FFFFFFFFh
CW_USEDEFAULT                   equ 80000000h
GENERIC_READ                    equ (80000000h)
GENERIC_WRITE                   equ (40000000h)
GENERIC_EXECUTE                 equ (20000000h)
GENERIC_ALL                     equ (10000000h)
CREATE_NEW                      equ 1
CREATE_ALWAYS                   equ 2
OPEN_EXISTING                   equ 3
OPEN_ALWAYS                     equ 4
FILE_ATTRIBUTE_READONLY         equ 1h
FILE_ATTRIBUTE_HIDDEN           equ 2h
FILE_ATTRIBUTE_SYSTEM           equ 4h
FILE_ATTRIBUTE_DIRECTORY        equ 10h
FILE_ATTRIBUTE_ARCHIVE          equ 20h
FILE_ATTRIBUTE_NORMAL           equ 80h
FILE_ATTRIBUTE_TEMPORARY        equ 100h
FILE_ATTRIBUTE_COMPRESSED       equ 800h
FILE_BEGIN                      equ 0
FILE_CURRENT                    equ 1
FILE_END                        equ 2
FILE_FLAG_WRITE_THROUGH         equ 80000000h
FILE_FLAG_OVERLAPPED            equ 40000000h
FILE_FLAG_NO_BUFFERING          equ 20000000h
FILE_FLAG_RANDOM_ACCESS         equ 10000000h
FILE_FLAG_SEQUENTIAL_SCAN       equ 8000000h
FILE_FLAG_DELETE_ON_CLOSE       equ 4000000h
FILE_FLAG_BACKUP_SEMANTICS      equ 2000000h
FILE_FLAG_POSIX_SEMANTICS       equ 1000000h
FILE_SHARE_READ                 equ 00000001h  
FILE_SHARE_WRITE                equ 00000002h  

;       Colors

Black                           equ 000000h
Blue                            equ 0FF0000h
Green                           equ 00FF00h
Cyan                            equ 0FFFF00h
Red                             equ 0000FFh
Magenta                         equ 0FF00FFh
Yellow                          equ 00FFFFh
White                           equ 0FFFFFFh
Gray                            equ 080808h
;       Image types

IMAGE_BITMAP                    equ 0
IMAGE_ICON                      equ 1
IMAGE_CURSOR                    equ 2
IMAGE_ENHMETAFILE               equ 3

ICON_SMALL                      equ 0
ICON_BIG                        equ 1

;       How to load image  

LR_DEFAULTCOLOR                 equ 0
LR_MONOCHROME                   equ 1
LR_COLOR                        equ 2
LR_COPYRETURNORG                equ 4
LR_COPYDELETEORG                equ 8
LR_LOADFROMFILE                 equ 10h
LR_LOADTRANSPARENT              equ 20h
LR_DEFAULTSIZE                  equ 40h
LR_VGACOLOR                     equ 80h
LR_LOADMAP3DCOLORS              equ 1000h
LR_CREATEDIBSECTION             equ 2000h
LR_COPYFROMRESOURCE             equ 4000h

;       List styles

LVS_ICON                        equ 0000h
LVS_REPORT                      equ 0001h
LVS_SMALLICON                   equ 0002h
LVS_LIST                        equ 0003h
LVS_TYPEMASK                    equ 0003h
LVS_SINGLESEL                   equ 0004h
LVS_SHOWSELALWAYS               equ 0008h
LVS_SORTASCENDING               equ 0010h
LVS_SORTDESCENDING              equ 0020h
LVS_SHAREIMAGELISTS             equ 0040h
LVS_NOLABELWRAP                 equ 0080h
LVS_AUTOARRANGE                 equ 0100h
LVS_EDITLABELS                  equ 0200h
LVS_NOSCROLL                    equ 2000h
LVS_TYPESTYLEMASK               equ 0FC00h
LVS_ALIGNTOP                    equ 0000h
LVS_ALIGNLEFT                   equ 0800h
LVS_ALIGNMASK                   equ 0c00h
LVS_OWNERDRAWFIXED              equ 0400h
LVS_NOCOLUMNHEADER              equ 4000h

GMEM_FIXED                           equ 0h
GMEM_MOVEABLE                        equ 2h
GMEM_NOCOMPACT                       equ 10h
GMEM_NODISCARD                       equ 20h
GMEM_ZEROINIT                        equ 40h
GMEM_MODIFY                          equ 80h
GMEM_DISCARDABLE                     equ 100h
GMEM_NOT_BANKED                      equ 1000h
GMEM_SHARE                           equ 2000h
GMEM_DDESHARE                        equ 2000h
GMEM_NOTIFY                          equ 4000h
GMEM_LOWER                           equ GMEM_NOT_BANKED
GMEM_VALID_FLAGS                     equ 7F72h
GMEM_INVALID_HANDLE                  equ 8000h
GMEM_DISCARDED                       equ 4000h
GMEM_LOCKCOUNT                       equ 0FFh

LVCF_FMT                        equ 0001h
LVCF_WIDTH                      equ 0002h
LVCF_TEXT                       equ 0004h
LVCF_SUBITEM                    equ 0008h
LVCFMT_LEFT                     equ 0000h
LVCFMT_RIGHT                    equ 0001h
LVCFMT_CENTER                   equ 0002h

ILC_MASK                        equ 0001h
ILC_COLOR                       equ 0000h
ILC_COLORDDB                    equ 00FEh
ILC_COLOR4                      equ 0004h
ILC_COLOR8                      equ 0008h
ILC_COLOR16                     equ 0010h
ILC_COLOR24                     equ 0018h
ILC_COLOR32                     equ 0020h
ILC_PALETTE                     equ 0800h

;       Icons and ID

IDI_APPLICATION                 equ 32512
IDI_HAND                        equ 32513
IDI_QUESTION                    equ 32514
IDI_EXCLAMATION                 equ 32515
IDI_ASTERISK                    equ 32516
IDI_WINLOGO                     equ 32517
IDI_WARNING                     equ IDI_EXCLAMATION
IDI_ERROR                       equ IDI_HAND
IDI_INFORMATION                 equ IDI_ASTERISK
IDOK                            equ 1
IDCANCEL                        equ 2
IDABORT                         equ 3
IDRETRY                         equ 4
IDIGNORE                        equ 5
IDYES                           equ 6
IDNO                            equ 7
IDCLOSE                         equ 8
IDHELP                          equ 9

TV_FIRST                        equ 1100h
LVM_FIRST                       equ 1000h

LVM_SETEXTENDEDLISTVIEWSTYLE    equ 4150
LVM_GETBKCOLOR                  equ LVM_FIRST + 0
LVM_SETBKCOLOR                  equ LVM_FIRST + 1
LVM_GETIMAGELIST                equ LVM_FIRST + 2
LVM_SETIMAGELIST                equ LVM_FIRST + 3
LVM_GETITEMCOUNT                equ LVM_FIRST + 4
LVM_INSERTITEM                  equ LVM_FIRST + 7
LVM_INSERTCOLUMN                equ LVM_FIRST + 27
TVM_SETIMAGELIST                equ TV_FIRST + 9
LVS_EX_SUBITEMIMAGES            equ 00000002h
LVS_EX_GRIDLINES                equ 00000001h
LVS_EX_HEADERDRAGDROP           equ 00000010h
LVS_EX_FULLROWSELECT            equ 00000032h

LVSIL_NORMAL                    equ 0
LVSIL_SMALL                     equ 1
LVSIL_STATE                     equ 2

LVIF_TEXT                       equ 0001h
LVIF_IMAGE                      equ 0002h
LVIF_PARAM                      equ 0004h
LVIF_STATE                      equ 0008h

SW_HIDE                              equ 0
SW_SHOWNORMAL                        equ 1
SW_NORMAL                            equ 1
SW_SHOWMINIMIZED                     equ 2
SW_SHOWMAXIMIZED                     equ 3
SW_MAXIMIZE                          equ 3
SW_SHOWNOACTIVATE                    equ 4
SW_SHOW                              equ 5
SW_MINIMIZE                          equ 6
SW_SHOWMINNOACTIVE                   equ 7
SW_SHOWNA                            equ 8
SW_RESTORE                           equ 9
SW_SHOWDEFAULT                       equ 10
SW_MAX                               equ 10

;       Windows Styles

WS_OVERLAPPED                        equ 0h
WS_POPUP                             equ 80000000h
WS_CHILD                             equ 40000000h
WS_MINIMIZE                          equ 20000000h
WS_VISIBLE                           equ 10000000h
WS_DISABLED                          equ 8000000h
WS_CLIPSIBLINGS                      equ 4000000h
WS_CLIPCHILDREN                      equ 2000000h
WS_MAXIMIZE                          equ 1000000h
WS_CAPTION                           equ 0C00000h
WS_BORDER                            equ 800000h
WS_DLGFRAME                          equ 400000h
WS_VSCROLL                           equ 200000h
WS_HSCROLL                           equ 100000h
WS_SYSMENU                           equ 80000h
WS_THICKFRAME                        equ 40000h
WS_GROUP                             equ 20000h
WS_TABSTOP                           equ 10000h
WS_MINIMIZEBOX                       equ 20000h
WS_MAXIMIZEBOX                       equ 10000h
WS_OVERLAPPEDWINDOW                  equ WS_OVERLAPPED OR WS_CAPTION OR WS_SYSMENU OR WS_THICKFRAME OR WS_MINIMIZEBOX
WS_EX_DLGMODALFRAME                  equ 1h
WS_EX_NOPARENTNOTIFY                 equ 4h
WS_EX_TOPMOST                        equ 8h
WS_EX_ACCEPTFILES                    equ 10h
WS_EX_TRANSPARENT                    equ 20h
WS_EX_MDICHILD                       equ 00000040h
WS_EX_TOOLWINDOW                     equ 00000080h
WS_EX_WINDOWEDGE                     equ 00000100h
WS_EX_CLIENTEDGE                     equ 00000200h
WS_EX_CONTEXTHELP                    equ 00000400h
WS_EX_RIGHT                          equ 00001000h
WS_EX_LEFT                           equ 00000000h
WS_EX_RTLREADING                     equ 00002000h
WS_EX_LTRREADING                     equ 00000000h
WS_EX_LEFTSCROLLBAR                  equ 00004000h
WS_EX_RIGHTSCROLLBAR                 equ 00000000h
WS_EX_CONTROLPARENT                  equ 00010000h
WS_EX_STATICEDGE                     equ 00020000h
WS_EX_APPWINDOW                      equ 00040000h
WS_EX_OVERLAPPEDWINDOW               equ WS_EX_WINDOWEDGE OR WS_EX_CLIENTEDGE
WS_EX_PALETTEWINDOW                  equ WS_EX_WINDOWEDGE OR WS_EX_TOOLWINDOW OR WS_EX_TOPMOST

;       Dialog Styles

DS_ABSALIGN                          equ 0001h
DS_SYSMODAL                          equ 0002h
DS_3DLOOK                            equ 0004h
DS_FIXEDSYS                          equ 0008h
DS_NOFAILCREATE                      equ 0010h
DS_LOCALEDIT                         equ 0020h
DS_SETFONT                           equ 0040h
DS_MODALFRAME                        equ 0080h
DS_NOIDLEMSG                         equ 0100h
DS_SETFOREGROUND                     equ 0200h
DS_CONTROL                           equ 0400h
DS_CENTER                            equ 0800h
DS_CENTERMOUSE                       equ 1000h
DS_CONTEXTHELP                       equ 2000h

BS_PUSHBUTTON                        equ 0h
BS_DEFPUSHBUTTON                     equ 1h
BS_CHECKBOX                          equ 2h
BS_AUTOCHECKBOX                      equ 3h
BS_RADIOBUTTON                       equ 4h
BS_3STATE                            equ 5h
BS_AUTO3STATE                        equ 6h
BS_GROUPBOX                          equ 7h
BS_USERBUTTON                        equ 8h
BS_AUTORADIOBUTTON                   equ 9h
BS_OWNERDRAW                         equ 0Bh
BS_LEFTTEXT                          equ 20h
BS_BITMAP                            equ 80h
BS_ICON                              equ 40h
BS_TEXT                                   equ 0
BS_ICON                                   equ 40h
BS_BITMAP                                 equ 80h
BS_LEFT                                   equ 100h
BS_RIGHT                                  equ 200h
BS_CENTER                                 equ 300h
BS_TOP                                    equ 400h
BS_BOTTOM                                 equ 800h
BS_VCENTER                                equ 0C00h
BS_PUSHLIKE                               equ 1000h
BS_MULTILINE                              equ 2000h
BS_NOTIFY                                 equ 4000h
BS_FLAT                                   equ 8000h
BS_RIGHTBUTTON                            equ BS_LEFTTEXT

;        Class Styles

CS_VREDRAW                      equ 1h
CS_HREDRAW                      equ 2h
CS_KEYCVTWINDOW                 equ 4h
CS_DBLCLKS                      equ 8h
CS_OWNDC                        equ 20h
CS_CLASSDC                      equ 40h
CS_PARENTDC                     equ 80h
CS_NOKEYCVT                     equ 100h
CS_NOCLOSE                      equ 200h
CS_SAVEBITS                     equ 800h
CS_BYTEALIGNCLIENT              equ 1000h
CS_BYTEALIGNWINDOW              equ 2000h
CS_PUBLICCLASS                  equ 4000h
CS_GLOBALCLASS                  equ CS_PUBLICCLASS

;       Edit Styles

ES_OEMCONVERT                   equ 400h
ES_READONLY                     equ 800h
ES_WANTRETURN                   equ 1000h
ES_NUMBER                       equ 2000h

;       Fonts styles

FW_DONTCARE                          equ 0
FW_THIN                              equ 100
FW_EXTRALIGHT                        equ 200
FW_LIGHT                             equ 300
FW_NORMAL                            equ 400
FW_MEDIUM                            equ 500
FW_SEMIBOLD                          equ 600
FW_BOLD                              equ 700
FW_EXTRABOLD                         equ 800
FW_HEAVY                             equ 900
FW_ULTRALIGHT                        equ FW_EXTRALIGHT
FW_REGULAR                           equ FW_NORMAL
FW_DEMIBOLD                          equ FW_SEMIBOLD
FW_ULTRABOLD                         equ FW_EXTRABOLD
FW_BLACK                             equ FW_HEAVY

;       Window Messages

TB_SETIMAGELIST                 equ WM_USER + 48
WM_USER                         equ 400h
WM_NULL                         equ 0h
WM_CREATE                       equ 1h
WM_DESTROY                      equ 2h
WM_MOVE                         equ 3h
WM_SIZE                         equ 5h
WM_ACTIVATE                     equ 6h
WA_INACTIVE                     equ 0
WA_ACTIVE                       equ 1
WA_CLICKACTIVE                  equ 2
WM_SETFOCUS                     equ 7h
WM_KILLFOCUS                    equ 08h
WM_ENABLE                       equ 0Bh
WM_SETTEXT                      equ 0Ch
WM_GETTEXT                      equ 0Dh
WM_GETTEXTLENGTH                equ 0Eh
WM_PAINT                        equ 0Fh
WM_CLOSE                        equ 10h
WM_QUERYENDSESSION              equ 11h
WM_QUIT                         equ 12h
WM_QUERYOPEN                    equ 13h
WM_ERASEBKGND                   equ 14h
WM_SYSCOLORCHANGE               equ 15h
WM_ENDSESSION                   equ 16h
WM_SHOWWINDOW                   equ 18h
WM_WININICHANGE                 equ 1Ah
WM_SETTINGCHANGE                equ WM_WININICHANGE
WM_DEVMODECHANGE                equ 1Bh
WM_ACTIVATEAPP                  equ 1Ch
WM_FONTCHANGE                   equ 1Dh
WM_TIMECHANGE                   equ 1Fh
WM_SETCURSOR                    equ 20h
WM_MOUSEACTIVATE                equ 21h
WM_CHILDACTIVATE                equ 22h
WM_QUEUESYNC                    equ 23h
WM_GETMINMAXINFO                equ 24h
WM_PAINTICON                    equ 26h
WM_ICONERASEBKGND               equ 27h
WM_NEXTDLGCTL                   equ 28h
WM_SPOOLERSTATUS                equ 2Ah
WM_DRAWITEM                     equ 2Bh
WM_MEASUREITEM                  equ 2Ch
WM_DELETEITEM                   equ 2Dh
WM_VKEYTOITEM                   equ 2Eh
WM_CHARTOITEM                   equ 2Fh
WM_SETFONT                      equ 30h
WM_GETFONT                      equ 31h
WM_SETHOTKEY                    equ 32h
WM_GETHOTKEY                    equ 33h
WM_QUERYDRAGICON                equ 37h
WM_COMPAREITEM                  equ 39h
WM_GETOBJECT                    equ 3Dh
WM_COMPACTING                   equ 41h
WM_OTHERWINDOWCREATED           equ 42h
WM_OTHERWINDOWDESTROYED         equ 43h
WM_COMMNOTIFY                   equ 44h
CN_RECEIVE                      equ 1h
CN_TRANSMIT                     equ 2h
CN_EVENT                        equ 4h
WM_WINDOWPOSCHANGING            equ 46h
WM_WINDOWPOSCHANGED             equ 47h
WM_POWER                        equ 48h
WM_COPYDATA                          equ 4Ah
WM_CANCELJOURNAL                     equ 4Bh
WM_NOTIFY                            equ 4Eh
WM_INPUTLANGCHANGEREQUEST            equ 50h
WM_INPUTLANGCHANGE                   equ 51h
WM_TCARD                             equ 52h
WM_HELP                              equ 53h
WM_USERCHANGED                       equ 54h
WM_NOTIFYFORMAT                      equ 55h
WM_CONTEXTMENU                       equ 7Bh
WM_STYLECHANGING                     equ 7Ch
WM_STYLECHANGED                      equ 7Dh
WM_DISPLAYCHANGE                     equ 7Eh
WM_GETICON                           equ 7Fh
WM_SETICON                           equ 80h
WM_NCCREATE                          equ 81h
WM_NCDESTROY                         equ 82h
WM_NCCALCSIZE                        equ 83h
WM_NCHITTEST                         equ 84h
WM_NCPAINT                           equ 85h
WM_NCACTIVATE                        equ 86h
WM_GETDLGCODE                        equ 87h
WM_SYNCPAINT                       equ 88h
WM_NCMOUSEMOVE                       equ 0A0h
WM_NCLBUTTONDOWN                     equ 0A1h
WM_NCLBUTTONUP                       equ 0A2h
WM_NCLBUTTONDBLCLK                   equ 0A3h
WM_NCRBUTTONDOWN                     equ 0A4h
WM_NCRBUTTONUP                       equ 0A5h
WM_NCRBUTTONDBLCLK                   equ 0A6h
WM_NCMBUTTONDOWN                     equ 0A7h
WM_NCMBUTTONUP                       equ 0A8h
WM_NCMBUTTONDBLCLK                   equ 0A9h
WM_KEYFIRST                          equ 100h
WM_KEYDOWN                           equ 100h
WM_KEYUP                             equ 101h
WM_CHAR                              equ 102h
WM_DEADCHAR                          equ 103h
WM_SYSKEYDOWN                        equ 104h
WM_SYSKEYUP                          equ 105h
WM_SYSCHAR                           equ 106h
WM_SYSDEADCHAR                       equ 107h
WM_KEYLAST                           equ 108h
WM_INITDIALOG                        equ 110h
WM_COMMAND                           equ 111h
WM_SYSCOMMAND                        equ 112h
WM_TIMER                             equ 113h
WM_HSCROLL                           equ 114h
WM_VSCROLL                           equ 115h
WM_INITMENU                          equ 116h
WM_INITMENUPOPUP                     equ 117h
WM_MENUSELECT                        equ 11Fh
WM_MENUCHAR                          equ 120h
WM_ENTERIDLE                         equ 121h
WM_CTLCOLORMSGBOX                    equ 132h
WM_CTLCOLOREDIT                      equ 133h
WM_CTLCOLORLISTBOX                   equ 134h
WM_CTLCOLORBTN                       equ 135h
WM_CTLCOLORDLG                       equ 136h
WM_CTLCOLORSCROLLBAR                 equ 137h
WM_CTLCOLORSTATIC                    equ 138h
WM_MOUSEFIRST                        equ 200h
WM_MOUSEMOVE                         equ 200h
WM_LBUTTONDOWN                       equ 201h
WM_LBUTTONUP                         equ 202h
WM_LBUTTONDBLCLK                     equ 203h
WM_RBUTTONDOWN                       equ 204h
WM_RBUTTONUP                         equ 205h
WM_RBUTTONDBLCLK                     equ 206h
WM_MBUTTONDOWN                       equ 207h
WM_MBUTTONUP                         equ 208h
WM_MBUTTONDBLCLK                     equ 209h
WM_MOUSELAST                         equ 209h
WM_PARENTNOTIFY                      equ 210h
WM_ENTERMENULOOP                     equ 211h
WM_EXITMENULOOP                      equ 212h
WM_MDICREATE                         equ 220h
WM_MDIDESTROY                        equ 221h
WM_MDIACTIVATE                       equ 222h
WM_MDIRESTORE                        equ 223h
WM_MDINEXT                           equ 224h
WM_MDIMAXIMIZE                       equ 225h
WM_MDITILE                           equ 226h
WM_MDICASCADE                        equ 227h
WM_MDIICONARRANGE                    equ 228h
WM_MDIGETACTIVE                      equ 229h
WM_MDISETMENU                        equ 230h
WM_DROPFILES                         equ 233h
WM_MDIREFRESHMENU                    equ 234h
WM_CUT                               equ 300h
WM_COPY                              equ 301h
WM_PASTE                             equ 302h
WM_CLEAR                             equ 303h
WM_UNDO                              equ 304h
WM_RENDERFORMAT                      equ 305h
WM_RENDERALLFORMATS                  equ 306h
WM_DESTROYCLIPBOARD                  equ 307h
WM_DRAWCLIPBOARD                     equ 308h
WM_PAINTCLIPBOARD                    equ 309h
WM_VSCROLLCLIPBOARD                  equ 30Ah
WM_SIZECLIPBOARD                     equ 30Bh
WM_ASKCBFORMATNAME                   equ 30Ch
WM_CHANGECBCHAIN                     equ 30Dh
WM_HSCROLLCLIPBOARD                  equ 30Eh
WM_QUERYNEWPALETTE                   equ 30Fh
WM_PALETTEISCHANGING                 equ 310h
WM_PALETTECHANGED                    equ 311h
WM_HOTKEY                            equ 312h
WM_PRINT                             equ 317h
WM_PRINTCLIENT                       equ 318h
WM_PENWINFIRST                       equ 380h
WM_PENWINLAST                        equ 38Fh

CB_GETEDITSEL                        equ 140h
CB_LIMITTEXT                         equ 141h
CB_SETEDITSEL                        equ 142h
CB_ADDSTRING                         equ 143h
CB_DELETESTRING                      equ 144h
CB_DIR                               equ 145h
CB_GETCOUNT                          equ 146h
CB_GETCURSEL                         equ 147h
CB_GETLBTEXT                         equ 148h
CB_GETLBTEXTLEN                      equ 149h
CB_INSERTSTRING                      equ 14Ah
CB_RESETCONTENT                      equ 14Bh
CB_FINDSTRING                        equ 14Ch
CB_SELECTSTRING                      equ 14Dh
CB_SETCURSEL                         equ 14Eh
CB_SHOWDROPDOWN                      equ 14Fh
CB_GETITEMDATA                       equ 150h
CB_SETITEMDATA                       equ 151h
CB_GETDROPPEDCONTROLRECT             equ 152h
CB_SETITEMHEIGHT                     equ 153h
CB_GETITEMHEIGHT                     equ 154h
CB_SETEXTENDEDUI                     equ 155h
CB_GETEXTENDEDUI                     equ 156h
CB_GETDROPPEDSTATE                   equ 157h
CB_FINDSTRINGEXACT                   equ 158h
CB_SETLOCALE                         equ 159h
CB_GETLOCALE                         equ 15Ah
CB_GETTOPINDEX                       equ 15Bh
CB_SETTOPINDEX                       equ 15Ch
CB_GETHORIZONTALEXTENT               equ 15Dh
CB_SETHORIZONTALEXTENT               equ 15Eh
CB_GETDROPPEDWIDTH                   equ 15Fh
CB_SETDROPPEDWIDTH                   equ 160h
CB_INITSTORAGE                       equ 161h
CB_MSGMAX                            equ 162h

CBS_SIMPLE                           equ 1h
CBS_DROPDOWN                         equ 2h
CBS_DROPDOWNLIST                     equ 3h
CBS_OWNERDRAWFIXED                   equ 10h
CBS_OWNERDRAWVARIABLE                equ 20h
CBS_AUTOHSCROLL                      equ 40h
CBS_OEMCONVERT                       equ 80h
CBS_SORT                             equ 100h
CBS_HASSTRINGS                       equ 200h
CBS_NOINTEGRALHEIGHT                 equ 400h
CBS_DISABLENOSCROLL                  equ 800h

; Error Codes ....

ERROR_SUCCESS                        equ 0
ERROR_INVALID_FUNCTION               equ 1
ERROR_FILE_NOT_FOUND                 equ 2
ERROR_PATH_NOT_FOUND                 equ 3
ERROR_TOO_MANY_OPEN_FILES            equ 4
ERROR_ACCESS_DENIED                  equ 5
ERROR_INVALID_HANDLE                 equ 6
ERROR_ARENA_TRASHED                  equ 7
ERROR_NOT_ENOUGH_MEMORY              equ 8
ERROR_INVALID_BLOCK                  equ 9
ERROR_BAD_ENVIRONMENT                equ 10
ERROR_BAD_FORMAT                     equ 11
ERROR_INVALID_ACCESS                 equ 12
ERROR_INVALID_DATA                   equ 13
ERROR_OUTOFMEMORY                    equ 14
ERROR_INVALID_DRIVE                  equ 15
ERROR_CURRENT_DIRECTORY              equ 16
ERROR_NOT_SAME_DEVICE                equ 17
ERROR_NO_MORE_FILES                  equ 18
ERROR_WRITE_PROTECT                  equ 19
ERROR_BAD_UNIT                       equ 20
ERROR_NOT_READY                      equ 21
ERROR_BAD_COMMAND                    equ 22
ERROR_CRC                            equ 23
ERROR_BAD_LENGTH                     equ 24
ERROR_SEEK                           equ 25
ERROR_NOT_DOS_DISK                   equ 26
ERROR_SECTOR_NOT_FOUND               equ 27
ERROR_OUT_OF_PAPER                   equ 28
ERROR_WRITE_FAULT                    equ 29
ERROR_READ_FAULT                     equ 30
ERROR_GEN_FAILURE                    equ 31
ERROR_SHARING_VIOLATION              equ 32
ERROR_LOCK_VIOLATION                 equ 33
ERROR_WRONG_DISK                     equ 34
ERROR_SHARING_BUFFER_EXCEEDED        equ 36
ERROR_HANDLE_EOF                     equ 38
ERROR_HANDLE_DISK_FULL               equ 39
ERROR_NOT_SUPPORTED                  equ 50
ERROR_REM_NOT_LIST                   equ 51
ERROR_DUP_NAME                       equ 52
ERROR_BAD_NETPATH                    equ 53
ERROR_NETWORK_BUSY                   equ 54
ERROR_DEV_NOT_EXIST                  equ 55
ERROR_TOO_MANY_CMDS                  equ 56
ERROR_ADAP_HDW_ERR                   equ 57
ERROR_BAD_NET_RESP                   equ 58
ERROR_UNEXP_NET_ERR                  equ 59
ERROR_BAD_REM_ADAP                   equ 60

; IoCtl Dos

VWIN32_DIOC_DOS_IOCTL                equ  1   ; INT 21H / AH := 44H automatically
VWIN32_DIOC_DOS_INT25                equ  2
VWIN32_DIOC_DOS_INT26                equ  3
VWIN32_DIOC_DOS_INT13                equ  4   ; YES, you can work with physical
VWIN32_DIOC_SIMCTRLC                 equ  5   ; sectors (MBR)
VWIN32_DIOC_DOS_DRIVEINFO            equ  6   

; message boxes

MB_OK                                equ 0h
MB_OKCANCEL                          equ 1h
MB_ABORTRETRYIGNORE                  equ 2h
MB_YESNOCANCEL                       equ 3h
MB_YESNO                             equ 4h
MB_RETRYCANCEL                       equ 5h
MB_ICONHAND                          equ 10h
MB_ICONQUESTION                      equ 20h
MB_ICONEXCLAMATION                   equ 30h
MB_ICONASTERISK                      equ 40h
MB_USERICON       equ 80h
MB_ICONERROR                         equ MB_ICONHAND
MB_ICONINFORMATION                   equ MB_ICONASTERISK
MB_ICONSTOP                          equ MB_ICONHAND
MB_ICONWARNING                       equ MB_ICONEXCLAMATION
MB_DEFBUTTON1                        equ 0h
MB_DEFBUTTON2                        equ 100h
MB_DEFBUTTON3                        equ 200h
MB_DEFBUTTON4                   equ 300h
MB_APPLMODAL                         equ 0h
MB_SYSTEMMODAL                       equ 1000h
MB_TASKMODAL                         equ 2000h
MB_HELP        equ 4000h
MB_NOFOCUS                           equ 8000h
MB_SETFOREGROUND                     equ 10000h
MB_DEFAULT_DESKTOP_ONLY              equ 20000h
MB_TYPEMASK                          equ 0Fh
MB_ICONMASK                          equ 0F0h
MB_DEFMASK                           equ 0F00h
MB_MODEMASK                          equ 3000h
MB_MISCMASK                          equ 0C000h
MB_TOPMOST                      equ 40000h
MB_RIGHT                        equ 80000h
MB_RTLREADING                   equ 100000h
MB_SERVICE_NOTIFICATION             equ 200000h

TRUNCATE_EXISTING                    equ 5

IDC_ARROW                            equ 32512
IDC_IBEAM                            equ 32513
IDC_WAIT                             equ 32514
IDC_CROSS                            equ 32515
IDC_UPARROW                          equ 32516
IDC_SIZE                             equ 32640
IDC_ICON                             equ 32641
IDC_SIZENWSE                         equ 32642
IDC_SIZENESW                         equ 32643
IDC_SIZEWE                           equ 32644
IDC_SIZENS                           equ 32645
IDC_SIZEALL                          equ 32646
IDC_NO                               equ 32648
IDC_HAND                             equ 32649
IDC_APPSTARTING                      equ 32650
IDC_HELP                             equ 3265

GWL_WNDPROC                          equ -4
GWL_HINSTANCE                        equ -6
GWL_HWNDPARENT                       equ -8
GWL_STYLE                            equ -16
GWL_EXSTYLE                          equ -20
GWL_USERDATA                         equ -21
GWL_ID                               equ -12

LVM_SETCOLUMNWIDTH  equ LVM_FIRST + 30
LVM_CREATEDRAGIMAGE             equ LVM_FIRST + 33
LVM_GETVIEWRECT equ LVM_FIRST + 34
LVM_GETTEXTCOLOR                equ LVM_FIRST + 35
LVM_SETTEXTCOLOR                equ LVM_FIRST + 36
LVM_GETTEXTBKCOLOR              equ LVM_FIRST + 37
LVM_SETTEXTBKCOLOR              equ LVM_FIRST + 38
LVM_GETTOPINDEX equ LVM_FIRST + 39
LVM_GETCOUNTPERPAGE             equ LVM_FIRST + 40
LVM_GETORIGIN   equ LVM_FIRST + 41
LVM_UPDATE      equ LVM_FIRST + 42
LVM_SETITEMSTATE                equ LVM_FIRST + 43
LVM_GETITEMSTATE                equ LVM_FIRST + 44
LVM_GETITEMTEXT equ LVM_FIRST + 45
LVM_GETITEMTEXTW                equ LVM_FIRST + 115
LVM_SETITEMTEXT equ LVM_FIRST + 46
LVM_SETITEMTEXTW                equ LVM_FIRST + 116
LVM_SETITEMCOUNT                equ LVM_FIRST + 47
LVM_SORTITEMS   equ LVM_FIRST + 48
LVM_SETITEMPOSITION32           equ LVM_FIRST + 49
LVM_GETSELECTEDCOUNT            equ LVM_FIRST + 50
LVM_GETITEMSPACING              equ LVM_FIRST + 51
LVM_GETISEARCHSTRING            equ LVM_FIRST + 52
LVM_GETISEARCHSTRINGW           equ LVM_FIRST + 117
LVM_GETITEM     equ LVM_FIRST + 5
LVM_GETITEMW    equ LVM_FIRST + 75
LVM_SETITEM     equ LVM_FIRST + 6
LVM_SETITEMW    equ LVM_FIRST + 76
LVM_INSERTITEM  equ LVM_FIRST + 7
LVM_INSERTITEMW equ LVM_FIRST + 77
LVM_DELETEITEM  equ LVM_FIRST + 8
LVM_DELETEALLITEMS              equ LVM_FIRST + 9
LVM_GETCALLBACKMASK             equ LVM_FIRST + 10
LVM_SETCALLBACKMASK             equ LVM_FIRST + 11
LVM_GETNEXTITEM                 equ LVM_FIRST + 12

LVNI_ALL        equ 0000h
LVNI_FOCUSED    equ 0001h
LVNI_SELECTED   equ 0002h
LVNI_CUT        equ 0004h
LVNI_DROPHILITED                equ 0008h
LVNI_ABOVE      equ 0100h
LVNI_BELOW      equ 0200h
LVNI_TOLEFT     equ 0400h
LVNI_TORIGHT    equ 0800h


LVN_FIRST                       equ 0-100
LVN_LAST                        equ 0-199
LVN_ITEMCHANGING                equ LVN_FIRST-0
LVN_ITEMCHANGED                 equ LVN_FIRST-1
LVN_INSERTITEM                  equ LVN_FIRST-2
LVN_DELETEITEM                  equ LVN_FIRST-3
LVN_DELETEALLITEMS              equ LVN_FIRST-4
LVN_BEGINLABELEDIT              equ LVN_FIRST-5
LVN_BEGINLABELEDITW             equ LVN_FIRST-75
LVN_ENDLABELEDIT                equ LVN_FIRST-6
LVN_ENDLABELEDITW               equ LVN_FIRST-76
LVN_COLUMNCLICK                 equ LVN_FIRST-8
LVN_BEGINDRAG                   equ LVN_FIRST-9
LVN_BEGINRDRAG                  equ LVN_FIRST-11
LVN_GETDISPINFO                 equ LVN_FIRST-50
LVN_GETDISPINFOW                equ LVN_FIRST-77
LVN_SETDISPINFO                 equ LVN_FIRST-51
LVN_SETDISPINFOW                equ LVN_FIRST-78


NM_FIRST            equ 0- 0
NM_LAST             equ 0-99
NM_OUTOFMEMORY      equ NM_FIRST-1
NM_CLICK            equ NM_FIRST-2
NM_DBLCLK           equ NM_FIRST-3
NM_RETURN           equ NM_FIRST-4
NM_RCLICK           equ NM_FIRST-5
NM_RDBLCLK          equ NM_FIRST-6
NM_SETFOCUS         equ NM_FIRST-7
NM_KILLFOCUS        equ NM_FIRST-8

VK_BACK                              equ 8h
VK_CANCEL                            equ 3h
VK_CAPITAL                           equ 14h
VK_CLEAR                             equ 0Ch
VK_CONTROL                           equ 11h
VK_DELETE                            equ 2Eh
VK_DOWN                              equ 28h
VK_END                               equ 23h
VK_ESCAPE                            equ 1Bh
VK_EXECUTE                           equ 2Bh
VK_HELP                              equ 2Fh
VK_HOME                              equ 24h
VK_INSERT                            equ 2Dh
VK_LBUTTON                           equ 1h
VK_LEFT                              equ 25h
VK_MBUTTON                           equ 4h
VK_MENU                              equ 12h
VK_NEXT                              equ 22h
VK_PAUSE                             equ 13h
VK_PGDN                              equ 22h
VK_PGUP                              equ 21h
VK_PRINT                             equ 2Ah
VK_PRIOR                             equ 21h
VK_RBUTTON                           equ 2h
VK_RETURN                            equ 0Dh
VK_RIGHT                             equ 27h
VK_SELECT                            equ 29h
VK_SHIFT                             equ 10h
VK_SNAPSHOT                          equ 2Ch
VK_SPACE                             equ 20h
VK_TAB                               equ 9h
VK_UP                                equ 26h
VK_NUMPAD0                           equ 60h
VK_NUMPAD1                           equ 61h
VK_NUMPAD2                           equ 62h
VK_NUMPAD3                           equ 63h
VK_NUMPAD4                           equ 64h
VK_NUMPAD5                           equ 65h
VK_NUMPAD6                           equ 66h
VK_NUMPAD7                           equ 67h
VK_NUMPAD8                           equ 68h
VK_NUMPAD9                           equ 69h
VK_MULTIPLY                          equ 6Ah
VK_ADD                               equ 6Bh
VK_SEPARATOR                         equ 6Ch
VK_SUBTRACT                          equ 6Dh
VK_DECIMAL                           equ 6Eh
VK_DIVIDE                            equ 6Fh
VK_F1                                equ 70h
VK_F2                                equ 71h
VK_F3                                equ 72h
VK_F4                                equ 73h
VK_F5                                equ 74h
VK_F6                                equ 75h
VK_F7                                equ 76h
VK_F8                                equ 77h
VK_F9                                equ 78h
VK_F10                               equ 79h
VK_F11                               equ 7Ah
VK_F12                               equ 7Bh
VK_F13                               equ 7Ch
VK_F14                               equ 7Dh
VK_F15                               equ 7Eh
VK_F16                               equ 7Fh
VK_F17                               equ 80h
VK_F18                               equ 81h
VK_F19                               equ 82h
VK_F20                               equ 83h
VK_F21                               equ 84h
VK_F22                               equ 85h
VK_F23                               equ 86h
VK_F24                               equ 87h
VK_NUMLOCK                           equ 90h
VK_SCROLL                            equ 91h
VK_LSHIFT                            equ 0A0h
VK_RSHIFT                            equ 0A1h
VK_LCONTROL                          equ 0A2h
VK_RCONTROL                          equ 0A3h
VK_LMENU                             equ 0A4h
VK_RMENU                             equ 0A5h
VK_ATTN                              equ 0F6h
VK_CRSEL                             equ 0F7h
VK_EXSEL                             equ 0F8h
VK_EREOF                             equ 0F9h
VK_PLAY                              equ 0FAh
VK_ZOOM                              equ 0FBh
VK_NONAME                            equ 0FCh
VK_PA1                               equ 0FDh
VK_OEM_CLEAR                         equ 0FEh
VK_0       equ 30h
VK_1       equ 31h
VK_2       equ 32h
VK_3       equ 33h
VK_4       equ 34h
VK_5       equ 35h
VK_6       equ 36h
VK_7       equ 37h
VK_8       equ 38h
VK_9       equ 39h
VK_A       equ 41h
VK_B       equ 42h
VK_C       equ 43h
VK_D       equ 44h
VK_E       equ 45h
VK_F       equ 46h
VK_G       equ 47h
VK_H       equ 48h
VK_I       equ 49h
VK_J       equ 4Ah
VK_K       equ 4Bh
VK_L       equ 4Ch
VK_M       equ 4Dh
VK_N       equ 4Eh
VK_O       equ 4Fh
VK_P       equ 50h
VK_Q       equ 51h
VK_R       equ 52h
VK_S       equ 53h
VK_T       equ 54h
VK_U       equ 55h
VK_V       equ 56h
VK_W       equ 57h
VK_X       equ 58h
VK_Y       equ 59h
VK_Z       equ 5Ah

EM_GETSEL                            equ 0B0h
EM_SETSEL                            equ 0B1h
EM_GETRECT                           equ 0B2h
EM_SETRECT                           equ 0B3h
EM_SETRECTNP                         equ 0B4h
EM_SCROLL                            equ 0B5h
EM_LINESCROLL                        equ 0B6h
EM_SCROLLCARET                       equ 0B7h
EM_GETMODIFY                         equ 0B8h
EM_SETMODIFY                         equ 0B9h
EM_GETLINECOUNT                      equ 0BAh
EM_LINEINDEX                         equ 0BBh
EM_SETHANDLE                         equ 0BCh
EM_GETHANDLE                         equ 0BDh
EM_GETTHUMB                          equ 0BEh
EM_LINELENGTH                        equ 0C1h
EM_REPLACESEL                        equ 0C2h
EM_GETLINE                           equ 0C4h
EM_LIMITTEXT                         equ 0C5h
EM_CANUNDO                           equ 0C6h
EM_UNDO                              equ 0C7h
EM_FMTLINES                          equ 0C8h
EM_LINEFROMCHAR                      equ 0C9h
EM_SETTABSTOPS                       equ 0CBh
EM_SETPASSWORDCHAR                   equ 0CCh
EM_EMPTYUNDOBUFFER                   equ 0CDh
EM_GETFIRSTVISIBLELINE               equ 0CEh
EM_SETREADONLY                       equ 0CFh
EM_SETWORDBREAKPROC                  equ 0D0h
EM_GETWORDBREAKPROC                  equ 0D1h
EM_GETPASSWORDCHAR                   equ 0D2h
EM_SETMARGINS                        equ 0D3h
EM_GETMARGINS                        equ 0D4h
EM_SETLIMITTEXT                      equ EM_LIMITTEXT
EM_GETLIMITTEXT                      equ 0D5h
EM_POSFROMCHAR                       equ 0D6h
EM_CHARFROMPOS                       equ 0D7h
EM_SETIMESTATUS                      equ 0D8h
EM_GETIMESTATUS                      equ 0D9h