/*
 * Utility to install and remove services
 */

#include <windows.h>
#include <stdio.h>

void ErrorHandler(char *s, DWORD err)
{
    printf( "%s\n", s );
    printf( "Error number: %ld\n", err );
    ExitProcess(err);
}

void InstallService( char* szName, char* szDesc, char* szPath )
{
   SC_HANDLE newService, scm;

   printf( "Starting...\n" );

   // open a connection to the SCM
   scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE);
   if( !scm )
      ErrorHandler("In OpenScManager", GetLastError());

   // Install the new service
   newService = CreateService( scm, szName, // eg "beep_srv"
                             szDesc,      // eg "Beep Service"
                             SERVICE_ALL_ACCESS,
                             SERVICE_WIN32_OWN_PROCESS,
                             SERVICE_DEMAND_START,
                             SERVICE_ERROR_NORMAL,
                             szPath,      // eg "c:\winnt\xxx.exe"
                             0, 0, 0, 0, 0);
   if( !newService )
      ErrorHandler("In CreateService", GetLastError());
   else
      printf( "Service installed\n" );

   // clean up
   CloseServiceHandle(newService);
   CloseServiceHandle(scm);
   printf( "Ending...\n" );

}

void RemoveService( char* s )
{
   SC_HANDLE service, scm;
   BOOL success;
   SERVICE_STATUS status;
   printf( "Starting...\n" );

   // Open a connection to the SCM
   scm = OpenSCManager(0, 0, SC_MANAGER_CREATE_SERVICE);
   if (!scm)
       ErrorHandler("In OpenScManager", GetLastError());

   // Get the service's handle
   service = OpenService( scm, s, SERVICE_ALL_ACCESS | DELETE);
   if (!service)
       ErrorHandler("In OpenService", GetLastError());

   // Stop the service if necessary
   success = QueryServiceStatus(service, &status);
   if (!success)
       ErrorHandler("In QueryServiceStatus", GetLastError());

   if (status.dwCurrentState != SERVICE_STOPPED)
   {
       printf( "Stopping service...\n" );
       success = ControlService(service, SERVICE_CONTROL_STOP,
                                &status);
       if (!success)
           ErrorHandler("In ControlService", GetLastError());

       Sleep(500);
   }

   // Remove the service
   success = DeleteService(service);
   if (success)
       printf( "Service removed\n" );
   else
       ErrorHandler("In DeleteService", GetLastError());

   // Clean up
   CloseServiceHandle(service);
   CloseServiceHandle(scm);
   printf( "Ending...\n" );
}


void Usage()
{
   printf( "To install:\n\t tool /I \"service name\" \"Service description\" \"path to exe\"\n" );
   printf( "To remove:\n\t tool /R \"service name\"\n" );
}


void main(int argc, char *argv[])
{

   if( argc == 1 )
   {
      Usage();
      return;
   }
   if ( argv[1][1] == 'I' || argv[1][1] == 'i' )
    {
      if( argc != 5 )
      {
         Usage();
         return;
      }
      InstallService( argv[2], argv[3], argv[4] );
    }
   else if( argv[1][1] == 'R' || argv[1][1] == 'r' )
   {
      if( argc != 3 )
      {
         Usage();
         return;
      }
      RemoveService( argv[2] );
   }

}
