.486
.model flat, stdcall
option casemap:none
include \masm32\include\windows.inc
include \masm32\include\kernel32.inc
include \masm32\include\user32.inc
include \masm32\include\comdlg32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\comdlg32.lib
include cfs.inc


DlgProc                 PROTO :DWORD,:DWORD,:DWORD,:DWORD
run_process             PROTO
get_api_from_iat        PROTO :DWORD,:DWORD
patch_iat               PROTO :DWORD,:DWORD
set_api_offset          PROTO :DWORD,:DWORD
get_hook_offset         PROTO :DWORD,:DWORD


.data
vxdnme          db  "\\.\CFS.VXD",0
kernel          db  "KERNEL32.dll",0
cfsrfError      db  "Error while reading from resource file.",0
vxdError        db  "Could not load cfs.vxd",0
procError       db  "Could not start process.",0
iatError        db  "Could not locate IAT.",0
filefilter_cfsrf  db  "CFS Resource files",0, "*.CRF",0,0
filestruc_cfsrf   OPENFILENAME {SIZEOF filestruc_cfsrf,0, 0, offset filefilter_cfsrf,0,0,0, \
                               offset cfsrfile, SIZEOF cfsrfile,0,0,0 ,0, OFN_EXPLORER or \
                               OFN_HIDEREADONLY}
cfsrfile    db  256 dup(?)

filefilter_proc db  "Executable files",0, "*.EXE",0,0
filestruc_proc  OPENFILENAME {SIZEOF filestruc_proc,0, 0, offset filefilter_proc,0,0,0, \
                               offset process, SIZEOF process,0,0,0 ,0, OFN_EXPLORER or \
                               OFN_HIDEREADONLY}
process             db  256 dup(?)

fffinfo             fff_pointer {}

cddrive             db  "c:\", 0
cdname              db  "CDROMDUMMY",0
NumberOfClusters    dd  5000h
SectorsPerCluster   dd  10h
BytesPerSector      dd  800h
SerialNumber        dd  0F499206Fh


GVI_apiname         db  "GetVolumeInformationA",0
GDFS_apiname        db  "GetDiskFreeSpaceA",0
CF_apiname          db  "CreateFileA",0
GDT_apiname         db  "GetDriveTypeA",0
FFF_apiname         db  "FindFirstFileA",0
GFA_apiname         db  "GetFileAttributesA",0
GLD_apiname         db  "GetLogicalDrives",0
GLDS_apiname        db  "GetLogicalDriveStringsA",0


.data?
vxdhndl     dd  ?
phndl       dd  ?
cfsrfhndl   dd  ?
dllhndl     dd  ?
hmodule     dd  ?
bytesw      dd  ?
bufferhndl  dd  ?
filesize    dd  ?
base        dd  ?
iat         dd  ?
virtualoffset   dd  ?

startup     STARTUPINFO {?}
pinfo       PROCESS_INFORMATION {?}

GVI_iat_offset  dd  ?
GVI_hook_offset dd  ?

GDFS_iat_offset dd  ?
GDFS_hook_offset    dd  ?

CF_iat_offset   dd  ?
CF_hook_offset  dd  ?

GDT_iat_offset  dd  ?
GDT_hook_offset dd  ?

FFF_iat_offset  dd  ?
FFF_hook_offset dd  ?

GFA_iat_offset  dd  ?
GFA_hook_offset dd  ?

GLD_iat_offset  dd  ?
GLD_hook_offset dd  ?

GLDS_iat_offset dd  ?
GLDS_hook_offset    dd  ?


.code
start:

    invoke GetModuleHandle,0
    mov hmodule, eax

    invoke	CreateFileA,addr vxdnme,0,0,0,0,FILE_FLAG_DELETE_ON_CLOSE,0
    cmp eax, -1
    jne @f
    invoke MessageBox, NULL, offset vxdError, NULL, MB_OK
    invoke ExitProcess, 0
    @@:
    mov vxdhndl, eax

    invoke DeviceIoControl, vxdhndl, DIOC_get_GVIoff, \
                            offset GVI_hook_offset, NULL, NULL, NULL, offset bytesw, NULL

    invoke LoadLibrary, offset kernel
    mov dllhndl, eax

    invoke set_api_offset, offset GVI_apiname, DIOC_set_GVIapi

    invoke set_api_offset, offset GDFS_apiname, DIOC_set_GDFSapi

    invoke set_api_offset, offset CF_apiname, DIOC_set_CFapi

    invoke set_api_offset, offset GDT_apiname, DIOC_set_GDTapi

    invoke set_api_offset, offset FFF_apiname, DIOC_set_FFFapi

    invoke set_api_offset, offset GFA_apiname, DIOC_set_GFAapi

    invoke set_api_offset, offset GLD_apiname, DIOC_set_GLDapi

    invoke set_api_offset, offset GLDS_apiname, DIOC_set_GLDSapi


    invoke FreeLibrary, dllhndl


    invoke get_hook_offset, offset GVI_hook_offset, DIOC_get_GVIoff

    invoke get_hook_offset, offset GDFS_hook_offset, DIOC_get_GDFSoff

    invoke get_hook_offset, offset CF_hook_offset, DIOC_get_CFoff

    invoke get_hook_offset, offset GDT_hook_offset, DIOC_get_GDToff

    invoke get_hook_offset, offset FFF_hook_offset, DIOC_get_FFFoff

    invoke get_hook_offset, offset GFA_hook_offset, DIOC_get_GFAoff

    invoke get_hook_offset, offset GLD_hook_offset, DIOC_get_GLDoff

    invoke get_hook_offset, offset GLDS_hook_offset, DIOC_get_GLDSoff


    xor     eax, eax
    mov     ax, ID_DIALOG

    invoke  DialogBoxParamA,hmodule,eax,0,addr DlgProc,0


    invoke CloseHandle, vxdhndl

invoke ExitProcess, 0



DlgProc Proc hWin: DWORD, uMsg: DWORD, wParam: DWORD, lParam: DWORD

        .IF uMsg==WM_CLOSE

            invoke EndDialog,hWin,0

        .elseif uMsg==WM_INITDIALOG

            invoke SetDlgItemText, hWin, 1002, offset cdname
            
            invoke SetDlgItemInt, hWin, 1004, NumberOfClusters, FALSE
            
            invoke SetDlgItemInt, hWin, 1005, SectorsPerCluster, FALSE
            
            invoke SetDlgItemInt, hWin, 1006, BytesPerSector, FALSE
            
            invoke SetDlgItemInt, hWin, 1007, SerialNumber, FALSE

            @@:
            inc byte ptr [cddrive]
            invoke GetDriveTypeA, offset cddrive
            cmp eax, 1
            jnz @b

            invoke SetDlgItemText, hWin, 1001, offset cddrive
            

        .elseif uMsg==WM_COMMAND

            .if wParam==1011

                invoke GetOpenFileName, offset filestruc_cfsrf
                test eax, eax
                jz no_cfsrf

                invoke CreateFileA, offset cfsrfile, GENERIC_READ, FILE_SHARE_READ or \
                                    FILE_SHARE_WRITE, NULL, OPEN_EXISTING, NULL, NULL
                                    
                mov cfsrfhndl, eax
                test eax, eax
                jz no_cfsrf

                invoke GetFileSize, cfsrfhndl, NULL
                mov filesize, eax


                invoke LocalAlloc, LMEM_FIXED, filesize
                mov bufferhndl, eax

                invoke ReadFile, cfsrfhndl, bufferhndl, filesize, offset bytesw, NULL

                invoke CloseHandle, cfsrfhndl

                mov esi, bufferhndl

                mov eax, dword ptr [esi]
                cmp eax, cfsrf_magicnumber
                je @f
                invoke LocalFree, bufferhndl
                invoke CloseHandle, cfsrfhndl
                jmp no_cfsrf
                @@:

                mov esi, dword ptr [esi+4h]
                add esi, bufferhndl

                mov al, byte ptr [esi+4h]
                mov byte ptr [cddrive], al
                add esi, 4
                invoke SetDlgItemText, hWin, 1001, esi
                sub esi, 4

                mov eax, dword ptr [esi+8h]
                mov SectorsPerCluster, eax
                invoke SetDlgItemInt, hWin, 1005, dword ptr [esi+8h], FALSE

                mov eax, dword ptr [esi+0Ch]
                mov BytesPerSector, eax
                invoke SetDlgItemInt, hWin, 1006, dword ptr [esi+0Ch], FALSE

                mov eax, dword ptr [esi+14h]
                mov NumberOfClusters, eax
                invoke SetDlgItemInt, hWin, 1004, dword ptr [esi+14h], FALSE
 
                push esi
                add esi, 18h
                mov edi, offset cdname
                mov ecx, 10
                rep movsb
                pop esi
                add esi, 18h
                invoke SetDlgItemText, hWin, 1002, esi
                sub esi, 18h

                mov eax, dword ptr [esi+23h]
                mov SerialNumber, eax
                invoke SetDlgItemInt, hWin, 1007, dword ptr [esi+23h], FALSE

                mov esi, dword ptr [esi]
                add esi, bufferhndl
                mov eax, dword ptr [esi]
                add esi, 4

                mov fffinfo.pointer, esi
                mov fffinfo.count, eax

                mov ebx, sizeof WIN32_FIND_DATA
                mul ebx
                mov fffinfo.bsize, eax

                invoke DeviceIoControl, vxdhndl, DIOC_set_fffinfo, offset fffinfo, NULL, \
                                        NULL, NULL, offset bytesw, NULL
                            
                invoke LocalFree, bufferhndl
                ret

                no_cfsrf:
                invoke MessageBox, NULL, offset cfsrfError, NULL, MB_OK
                invoke LocalFree, bufferhndl
                ret

            .elseif wParam==1003

                invoke GetDlgItemText, hWin, 1001, offset cddrive, 3
                
                invoke GetDlgItemText, hWin, 1002, offset cdname, 10
                
                invoke GetDlgItemInt, hWin, 1004, NULL, FALSE
                mov NumberOfClusters, eax
                
                invoke GetDlgItemInt, hWin, 1005, NULL, FALSE
                mov SectorsPerCluster, eax
                
                invoke GetDlgItemInt, hWin, 1006, NULL, FALSE
                mov BytesPerSector, eax
                
                invoke GetDlgItemInt, hWin, 1007, NULL, FALSE
                mov SerialNumber, eax
                
                invoke GetOpenFileName, offset filestruc_proc
                test eax, eax
                jz no_proc_to_open

                push edi
                invoke run_process
                pop edi
                test eax, eax
                jz no_proc_to_open
                ret
                
                no_proc_to_open:
                invoke MessageBox, NULL, offset procError, NULL, MB_OK
                ret

            .endif
        
        .endif

    ret
DlgProc endp

run_process proc

mov bufferhndl, -1

invoke DeviceIoControl, vxdhndl, DIOC_set_diskinfo, \
                        offset cddrive, NULL, NULL, NULL, offset bytesw, NULL

invoke CreateFile, offset process, GENERIC_READ, NULL, NULL, OPEN_EXISTING, NULL, NULL
cmp eax, -1
je run_process_error
mov phndl, eax

invoke GetFileSize, eax, NULL
mov filesize, eax

invoke LocalAlloc, LMEM_FIXED or LMEM_ZEROINIT, eax
mov bufferhndl, eax

invoke ReadFile, phndl, eax, filesize, offset bytesw, NULL

mov eax, bufferhndl
add eax, dword ptr [eax+3Ch]
cmp word ptr [eax], 'EP'
jnz run_process_error

mov ebx, dword ptr [eax+34h]
mov base, ebx


mov ebx, eax
add ebx, 0F8h
mov esi, dword ptr [eax+80h]
sub ebx, 28h
@@:
add ebx, 28h
mov edi, ebx
mov edx, dword ptr [edi+0Ch]
cmp edx, esi
jbe @b
sub ebx, 28h
mov ecx, dword ptr [ebx+14h]
sub ecx, dword ptr [ebx+0Ch]
mov virtualoffset, ecx

mov ebx, dword ptr [eax+80h]
add ebx, bufferhndl
add ebx, virtualoffset
sub ebx, 20
@@:
add ebx, 20
mov edi, dword ptr [ebx+12]
add edi, bufferhndl
add edi, virtualoffset
mov esi, offset kernel
mov ecx, sizeof kernel
repz cmpsb
jne @b
mov iat, ebx

invoke get_api_from_iat, offset GVI_apiname, sizeof GVI_apiname
mov GVI_iat_offset, eax

invoke get_api_from_iat, offset GDFS_apiname, sizeof GDFS_apiname
mov GDFS_iat_offset, eax

invoke get_api_from_iat, offset CF_apiname, sizeof CF_apiname
mov CF_iat_offset, eax

invoke get_api_from_iat, offset GDT_apiname, sizeof GDT_apiname
mov GDT_iat_offset, eax

invoke get_api_from_iat, offset FFF_apiname, sizeof FFF_apiname
mov FFF_iat_offset, eax

invoke get_api_from_iat, offset GFA_apiname, sizeof GFA_apiname
mov GFA_iat_offset, eax

invoke get_api_from_iat, offset GLD_apiname, sizeof GLD_apiname
mov GLD_iat_offset, eax

invoke get_api_from_iat, offset GLDS_apiname, sizeof GLDS_apiname
mov GLDS_iat_offset, eax

invoke CloseHandle, phndl
invoke LocalFree, bufferhndl


invoke CreateProcess, offset process, NULL, NULL, NULL, FALSE, CREATE_SUSPENDED, NULL, NULL, \
                      offset startup, offset pinfo
test eax, eax
jz run_process_error

invoke patch_iat, GVI_iat_offset, offset GVI_hook_offset

invoke patch_iat, GDFS_iat_offset, offset GDFS_hook_offset

invoke patch_iat, CF_iat_offset, offset CF_hook_offset

invoke patch_iat, GDT_iat_offset, offset GDT_hook_offset

invoke patch_iat, FFF_iat_offset, offset FFF_hook_offset

invoke patch_iat, GFA_iat_offset, offset GFA_hook_offset

invoke patch_iat, GLD_iat_offset, offset GLD_hook_offset

invoke patch_iat, GLDS_iat_offset, offset GLDS_hook_offset

invoke ResumeThread, pinfo.hThread
cmp eax, -1
je run_process_error

mov eax, 1
ret

run_process_error:
invoke LocalFree, bufferhndl
xor eax, eax
ret
run_process endp


get_api_from_iat proc fctn: DWORD, fctsize: DWORD

cmp fctn, 0
jz get_api_from_iat_error

cmp fctsize, 0
jz get_api_from_iat_error

mov ebx, iat
    test ebx, ebx
    jz get_api_from_iat_error
mov eax, -1
mov edx, dword ptr [ebx]
    test edx, edx
    jz get_api_from_iat_error
add edx, bufferhndl
add edx, virtualoffset
sub edx, 4
@@:
add edx, 4
inc eax
mov edi, dword ptr [edx]
    test edi, edi
    jz get_api_from_iat_error
add edi, bufferhndl
add edi, virtualoffset
add edi, 2
mov esi, fctn
mov ecx, fctsize
repz cmpsb
jne @b

mov ebx, iat
mov ebx, dword ptr [ebx+16]
    test ebx, ebx
    jz get_api_from_iat_error
shl eax, 2
add ebx, eax
add ebx, base
mov eax, ebx
ret

get_api_from_iat_error:
xor eax, eax
ret
get_api_from_iat endp


patch_iat proc proc iat_offset: DWORD, hook_offset: DWORD

cmp iat_offset, 0
je @f
invoke WriteProcessMemory, pinfo.hProcess, iat_offset, hook_offset, 4, offset bytesw
@@:
ret

patch_iat endp


set_api_offset proc api:DWORD, DIOCmsg:DWORD

invoke GetProcAddress, dllhndl, api

invoke DeviceIoControl, vxdhndl, DIOCmsg, \
                            eax, NULL, NULL, NULL, offset bytesw, NULL

ret
set_api_offset endp


get_hook_offset proc hook_offset:DWORD, DIOCmsg:DWORD

invoke DeviceIoControl, vxdhndl, DIOCmsg, \
                        hook_offset, NULL, NULL, NULL, offset bytesw, NULL

ret
get_hook_offset endp

end start
