;==================================================================================
; credits to [Basic], knabberknusperhaus@yahoo.de
;==================================================================================
.486p
include \masm32\include\vmm.inc 
include \masm32\include\vwin32.inc
include \masm32\include\shell.inc
include ..\cfs.inc

DECLARE_VIRTUAL_DEVICE CFS,1,0, CFS_Control,\ 
     UNDEFINED_DEVICE_ID, UNDEFINED_INIT_ORDER 

Begin_control_dispatch CFS

	Control_Dispatch Sys_Dynamic_Device_Init,OnDeviceInit
      Control_Dispatch Sys_Dynamic_Device_Exit,OnDeviceDestroy
	Control_Dispatch w32_DeviceIoControl,OnDeviceIoControl

End_control_dispatch CFS

Decision            PROTO
get_file_info       PROTO

;______________________________________________________________________
VxD_LOCKED_DATA_SEG
;______________________________________________________________________

GVI_api_offset  dd  0
GDFS_api_offset dd  0
CF_api_offset   dd  0
GDT_api_offset  dd  0
FFF_api_offset  dd  0
GFA_api_offset  dd  0
GLD_api_offset  dd  0
GLDS_api_offset dd  0

generalbuffer   dd  0

retoffset       dd  0
fileinfo        dd  0
currenthndl     dd  -2
fffinfo         fff_pointer {}

dummyfile       db  "c:\cfsdummy.$$$",0

cddrive         db  "D:\",0
volumename      db  "CDROMDUMMY",0
filesystemname  db  "CDFS",0

NumberOfClusters    dd  5000h
SectorsPerCluster   dd  10h
BytesPerSector      dd  800h
SerialNumber        dd  0F499206Fh

;______________________________________________________________________
VxD_LOCKED_DATA_ENDS
;______________________________________________________________________

;______________________________________________________________________
VxD_PAGEABLE_CODE_SEG 
;______________________________________________________________________


BeginProc OnDeviceDestroy

cmp fffinfo.pointer, 0
je @f
VMMCall _HeapFree, fffinfo.pointer, NULL
@@:

clc
ret
EndProc OnDeviceDestroy

BeginProc OnDeviceInit

clc
ret
EndProc OnDeviceInit

BeginProc OnDeviceIoControl 
assume esi:ptr DIOCParams 
.if [esi].dwIoControlCode==DIOC_Open 
    xor eax,eax 

    .elseif [esi].dwIoControlCode==DIOC_set_GVIapi
        mov esi,[esi].lpvInBuffer
        mov GVI_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GVIoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GVI_hook

    .elseif [esi].dwIoControlCode==DIOC_set_GDFSapi
        mov esi,[esi].lpvInBuffer
        mov GDFS_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GDFSoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GDFS_hook

    .elseif [esi].dwIoControlCode==DIOC_set_CFapi
        mov esi,[esi].lpvInBuffer
        mov CF_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_CFoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset CF_hook
        
    .elseif [esi].dwIoControlCode==DIOC_set_GDTapi
        mov esi,[esi].lpvInBuffer
        mov GDT_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GDToff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GDT_hook

    .elseif [esi].dwIoControlCode==DIOC_set_FFFapi
        mov esi,[esi].lpvInBuffer
        mov FFF_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_FFFoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset FFF_hook

    .elseif [esi].dwIoControlCode==DIOC_set_GFAapi
        mov esi,[esi].lpvInBuffer
        mov GFA_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GFAoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GFA_hook

    .elseif [esi].dwIoControlCode==DIOC_set_GLDapi
        mov esi,[esi].lpvInBuffer
        mov GLD_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GLDoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GLD_hook

    .elseif [esi].dwIoControlCode==DIOC_set_GLDSapi
        mov esi,[esi].lpvInBuffer
        mov GLDS_api_offset, esi

    .elseif [esi].dwIoControlCode==DIOC_get_GLDSoff
        mov esi,[esi].lpvInBuffer
        mov dword ptr [esi], offset GLDS_hook

    .elseif [esi].dwIoControlCode==DIOC_set_diskinfo
        mov esi,[esi].lpvInBuffer

        mov al, byte ptr [esi]
        cmp al, 'a'
        jb @f
        sub al, 20h
        @@:
        mov byte ptr [cddrive], al 

        push esi
        add esi, 4
        mov edi, offset volumename
        mov ecx, 10
        rep movsb
        pop esi

        mov eax, dword ptr [esi+15]
        mov NumberOfClusters, eax

        mov eax, dword ptr [esi+19]
        mov SectorsPerCluster, eax
        
        mov eax, dword ptr [esi+23]
        mov BytesPerSector, eax
        
        mov eax, dword ptr [esi+27]
        mov SerialNumber, eax

    .elseif [esi].dwIoControlCode==DIOC_set_fffinfo
        mov esi,[esi].lpvInBuffer
        
        mov eax,[esi].bsize
        mov fffinfo.bsize, eax

        mov eax,[esi].count
        mov fffinfo.count, eax

        cmp fffinfo.pointer, 0
        je @f
        VMMCall _HeapFree, fffinfo.pointer, NULL
        @@:

        VMMCall _HeapAllocate, fffinfo.bsize, HEAPZEROINIT
        mov fffinfo.pointer, eax

        mov esi, [esi].pointer
        mov edi, fffinfo.pointer
        mov ecx, fffinfo.bsize
        rep movsb

        
.endif
ret 
EndProc OnDeviceIoControl


GVI_hook proc

pushad
pushfd

invoke Decision
test eax, eax
jz GVI_no_hook

mov edi, dword ptr [esp+2Ch]
test edi, edi
jz @f
mov esi, offset volumename
mov ecx, dword ptr [esp+30h]
dec ecx
rep movsb
@@:

mov edi, dword ptr [esp+34h]
test edi, edi
jz @f
mov edx, SerialNumber
mov dword ptr [edi], edx
@@:

mov edi, dword ptr [esp+38h]
test edi, edi
jz @f
mov dword ptr [edi], lpMaximumComponentLength
@@:

mov edi, dword ptr [esp+3Ch]
test edi, edi
jz @f
mov dword ptr [edi], lpFileSystemFlags
@@:

mov edi, dword ptr [esp+40h]
test edi, edi
jz @f
mov esi, offset filesystemname
mov ecx, dword ptr [esp+44h]
dec ecx
rep movsb
@@:

popfd
popad
mov eax, 1
ret 32

GVI_no_hook:
popfd
popad
jmp GVI_api_offset

GVI_hook endp


GDFS_hook proc

pushad
pushfd

invoke Decision
test eax, eax
jz GDFS_no_hook

mov edi, dword ptr [esp+2Ch]
test edi, edi
jz @f
mov eax, SectorsPerCluster
mov dword ptr [edi], eax
@@:

mov edi, dword ptr [esp+30h]
test edi, edi
jz @f
mov eax, BytesPerSector
mov dword ptr [edi], eax
@@:

mov edi, dword ptr [esp+34h]
test edi, edi
jz @f
mov dword ptr [edi], 0
@@:

mov edi, dword ptr [esp+38h]
test edi, edi
jz @f
mov eax, NumberOfClusters
mov dword ptr [edi], eax
@@:

popfd
popad
mov eax, 1
ret 20

GDFS_no_hook:
popfd
popad
jmp GDFS_api_offset
GDFS_hook endp


CF_hook proc
pushad
pushfd

invoke Decision
test eax, eax
jz CF_no_hook

mov dword ptr [esp+28h], offset dummyfile
mov dword ptr [esp+30h], FILE_SHARE_READ
mov dword ptr [esp+38h], CREATE_ALWAYS

CF_no_hook:

popfd
popad
jmp CF_api_offset

CF_hook endp


GDT_hook proc

pushad
pushfd
invoke Decision
test eax, eax
jz GDT_no_hook

popfd
popad
mov eax, 5
ret 4

GDT_no_hook:
popfd
popad
jmp GDT_api_offset

GDT_hook endp

FFF_hook proc

pushad
pushfd

invoke Decision
test eax, eax
jz FFF_no_hook

jmp FFF_generic_return

push dword ptr [esp+28h]
invoke get_file_info
test eax, eax
jz FFF_generic_return

mov edi, eax
mov esi, ebx
mov ecx, 13Eh
rep movsb

popfd
popad
mov eax, -2
ret 8

FFF_generic_return:
popfd
popad
mov eax, -2
ret 8

FFF_no_hook:
popfd
popad
jmp FFF_api_offset
FFF_hook endp

GFA_hook proc

pushad
pushfd

invoke Decision
test eax, eax
jz GFA_no_hook

jmp GFA_hook_return_generic

push dword ptr [esp+28h]
invoke get_file_info
test eax, eax
jz GFA_hook_return_generic

popfd
popad

mov eax, fileinfo
mov eax, dword ptr [eax]
ret 4

GFA_hook_return_generic:
popfd
popad
mov eax, FILE_ATTRIBUTE_READONLY
ret 4

GFA_no_hook:
popfd
popad
jmp GFA_api_offset
GFA_hook endp

GLD_hook proc

call [GLD_api_offset]
mov cl, byte ptr [cddrive]
sub cl, 'A'
mov ebx, 1
rol ebx, cl
or eax, ebx
ret 

GLD_hook endp

GLDS_hook proc

push dword ptr [esp+8]
push dword ptr [esp+8]
call [GLDS_api_offset]

mov edi, dword ptr [esp+8]
@@:
inc edi
cmp word ptr [edi], 0
jne @b

inc edi
mov esi, offset cddrive
mov ecx, 3
rep movsb

ret 8

GLDS_hook endp



get_file_info proc

mov esi, fffinfo.pointer
test esi, esi
jz get_file_info_no_info

mov eax, fffinfo.count
dec eax
mov ebx, 13Eh
mul ebx
add esi, eax
add esi, 44

mov ecx, fffinfo.count
add esi, 13Eh


get_file_info_no_info:
xor eax, eax
ret 4

get_file_info endp


Decision proc

mov edi, dword ptr [esp+2Ch]
test edi, edi
jz decision_no_hook

mov al, byte ptr [edi]
cmp al, 'a'
jb @f
sub al, 20h
mov byte ptr [edi], al
@@:

mov esi, offset cddrive
mov ecx, 2
repz cmpsb
jne decision_no_hook

mov eax, 1
ret

decision_no_hook:
xor eax, eax
ret

Decision endp

;______________________________________________________________________
VxD_PAGEABLE_CODE_ENDS 
;______________________________________________________________________

end
