;;
;; cpIce, HLT based cooling VxD v1.12
;;
;; Copyright (c) 2000-2002 by Joergen Ibsen / Jibz
;; All Rights Reserved
;;

; This code was written with great help from Iczelion's VxD
; assembly tutorials

.586p

include vmm.inc
include vwin32.inc

CPICE_PERFORM_HLT    equ 1
CPICE_GET_STATE      equ 2
CPICE_START_CALLBACK equ 3
CPICE_STOP_CALLBACK  equ 4

DECLARE_VIRTUAL_DEVICE CPICE,1,12, CPICE_Control,\
	UNDEFINED_DEVICE_ID, UNDEFINED_INIT_ORDER

Begin_control_dispatch CPICE
	Control_Dispatch w32_DeviceIoControl, OnDeviceIoControl
	Control_Dispatch Device_Init, OnDeviceInit
	Control_Dispatch System_Exit, OnSystemExit
End_control_dispatch CPICE

VxD_PAGEABLE_DATA_SEG
	IdleCallbackRunning dd 0
VxD_PAGEABLE_DATA_ENDS

VxD_PAGEABLE_CODE_SEG

;; -- OnDeviceIoControl ---------------------------------------------

BeginProc OnDeviceIoControl
	assume esi:ptr DIOCParams

	.if [esi].dwIoControlCode==CPICE_PERFORM_HLT

		; perform single hlt operation
		xor eax,eax
		hlt
		ret

	.endif
	.if [esi].dwIoControlCode==CPICE_GET_STATE

		; return IdleCallbackRunning
		mov edx,[esi].cbOutBuffer
		cmp edx,4
		mov eax,1
		jb _end_ReturnState
		mov edx,[esi].lpvOutBuffer
		mov eax,IdleCallbackRunning
		mov [edx],eax
		mov edx,[esi].lpcbBytesReturned
		mov eax,4
		mov [edx],eax
		xor eax,eax ; also sets CF=0
	_end_ReturnState:
		ret

	.endif
	.if [esi].dwIoControlCode==CPICE_START_CALLBACK

		; install idle callback
		cmp IdleCallbackRunning,0
		jne _end_StartCallback_success
		mov esi,OFFSET32 HltIdleCallback
		VMMCall Call_When_Idle
		mov eax,1
		jc  _end_StartCallback
	_end_StartCallback_success:
		mov IdleCallbackRunning,1
		xor eax,eax ; also sets CF=0
	_end_StartCallback:
		ret

	.endif
	.if [esi].dwIoControlCode==CPICE_STOP_CALLBACK

		; remove idle callback
	StopCallback:
		cmp IdleCallbackRunning,1
		jne _end_StopCallback_success
		mov esi,OFFSET32 HltIdleCallback
		VMMCall Cancel_Call_When_Idle
		mov eax,1
		jc  _end_StopCallback
	_end_StopCallback_success:
		mov IdleCallbackRunning,0
		xor eax,eax ; also sets CF=0
	_end_StopCallback:
		ret

	.endif
	.if [esi].dwIoControlCode==DIOC_Open

		xor eax,eax
		ret

	.endif
	.if [esi].dwIoControlCode==DIOC_CloseHandle

		xor eax,eax ; also sets CF=0
		ret

	.endif

	ret
EndProc OnDeviceIoControl

;; -- OnDeviceInit --------------------------------------------------

BeginProc OnDeviceInit
	cmp IdleCallbackRunning, 0
	jne _end_OnDeviceInit_success
	; install idle callback
	mov esi, OFFSET32 HltIdleCallback
	VMMCall Call_When_Idle
	mov eax, 1
	jc  _end_OnDeviceInit
_end_OnDeviceInit_success:
	mov IdleCallbackRunning, 1
	xor eax,eax ; also sets CF=0
_end_OnDeviceInit:
	ret
EndProc OnDeviceInit

;; -- OnSystemExit --------------------------------------------------

BeginProc OnSystemExit
	cmp IdleCallbackRunning, 1
	jne _end_OnSystemExit
	; remove idle callback
	mov esi, OFFSET32 HltIdleCallback
	VMMCall Cancel_Call_When_Idle
	jc  _end_OnSystemExit
	mov IdleCallbackRunning, 0
_end_OnSystemExit:
	xor eax,eax ; also sets CF=0
	ret
EndProc OnSystemExit

;; -- HltIdleCallback -----------------------------------------------

BeginProc HltIdleCallback
	stc ; set carry to let other idle callbacks run
	hlt ; perform hlt operation
	ret
EndProc HltIdleCallback

VxD_PAGEABLE_CODE_ENDS

end
