;;
;; cpIce, HLT based CPU cooling v1.12 -- main program
;;
;; Copyright (c) 2000-2002 by Joergen Ibsen / Jibz
;; All Rights Reserved
;;

; This code was written with great help from Iczelion's win32
; assembly tutorials

; -- Version history (releases are marked with a '*') --
;
;   v1.12 *: Fixed the dialog procedure. Fixed Win95 compatibility.
;   v1.11 *: Added command line option to turn on thread usage.
;            Switched to using CLASH library to handle options.
;   v1.10  : Made a few adjustments to the code.
;   v1.09  : Added thread cooling.
;   v1.08 *: Made some adjustments and added a new about dialog.
;   v1.07  : Fixed a couple of small bugs.
;   v1.06  : Versioning info added to properties dialog
;            (thanks to Andrew Heebner).
;   v1.05 *: Check if other instance of cpIce.exe is running.
;   v1.04  : Detect and use static vxd if present.
;   v1.03 *: Added Win9x/ME check.
;   v1.02  : Added command line option to start with cooling on.
;   v1.01  : Rewrote to tray application.
;   v1.00  : Initial version. [December 4th 2000]

.586

.model flat,stdcall

option casemap:none

include windows.inc
include user32.inc
include kernel32.inc
include shell32.inc
include clash.inc
includelib user32.lib
includelib kernel32.lib
includelib shell32.lib
includelib clash.lib

	CPICE_PERFORM_HLT    equ 1
	CPICE_GET_STATE      equ 2
	CPICE_START_CALLBACK equ 3
	CPICE_STOP_CALLBACK  equ 4

	WM_SHELLNOTIFY equ WM_USER+5
	IDI_TRAY       equ 0
	IDI_MAINICON   equ 500
	IDI_COLDICON   equ 501
	IDI_HOTICON    equ 502
	IDM_COOLING    equ 1000
	IDM_THREAD     equ 1001
	IDM_ABOUT      equ 1002
	IDM_EXIT       equ 1010
	IDD_ABOUT      equ 2000
	IDC_PRGINFO    equ 2001

	UMIS_CHECK     equ 1
	UMIS_UNCHECK   equ 2
	UMIS_DISABLE   equ 3
	UMIS_ENABLE    equ 4

	WinMain             PROTO :HINSTANCE,:HINSTANCE,:LPSTR,:DWORD
	AboutDlgProc        PROTO :HWND,:UINT,:WPARAM,:LPARAM
	CoolingThreadProc   PROTO :LPVOID
	UpdateMenuItemState PROTO :DWORD,:DWORD

	MOVM MACRO MEM1,MEM2
		push   MEM2
		pop    MEM1
	ENDM

; -- data -----------------------------------------------------------

.data

	AppName       db "cpIce CPU cooler v1.12",0
	AppNameOn     db "cpIce CPU cooler  [ on ]",0
	AppNameOff    db "cpIce CPU cooler  [ off ]",0

	AboutMsgS     db "cpIce is currently using the static vxd.",0

	AboutMsgD     db "cpIce is currently using the dynamic vxd.",0

	ClassName     db "cpIceWinClass",0
	VxDNameS      db "\\.\CPICE",0
	VxDNameD      db "\\.\cpIce.vxd",0

	; error and warning messages
	RunError      db "ERROR : Another instance of cpIce is already running",0
	VxDError      db "ERROR : Unable to load 'cpIce.vxd'",0
	OSError       db "ERROR : Unable to get OS info",0
	OSWarn        db "WARNING : Only Win9x and ME operating systems are supported",13,10,13,10,\
	                 "Do you want to continue?",0
	ThreadError   db "ERROR : Unable to create thread",0

	; strings for popup menu
	CoolingString db "&Cooling",0
	ThreadString  db "Use &Thread",0
	AboutString   db "&About",0
	ExitString    db "E&xit",0

	CoolingOn     dd 0
	ThreadCool    dd 0
	UsingDynamic  dd 0

.data?

	hInstance     HINSTANCE ?
	hMutex        HANDLE ?
	CommandLine   LPSTR ?
	hVxD          HANDLE ?
	hThread       HANDLE ?
	osvinfo       OSVERSIONINFO <>
	note          NOTIFYICONDATA <>
	hPopupMenu    HMENU ?

	hMainIcon     HICON ?
	hColdIcon     HICON ?
	hHotIcon      HICON ?

	ThreadID      DWORD ?

	BytesReturned DWORD ?

; -- code -----------------------------------------------------------

.code

start:
	invoke GetModuleHandle, NULL
	mov    hInstance,eax

	; get command line
	invoke GetCommandLine
	mov    CommandLine,eax

	; parse command line
	invoke CL_ScanArgs, CommandLine

	; get OS info
	mov    osvinfo.dwOSVersionInfoSize,SIZEOF OSVERSIONINFO
	invoke GetVersionEx, addr osvinfo

	; if we could not get OS info, show error message and exit
	.if eax==0
		invoke MessageBox, NULL,addr OSError,addr AppName,MB_OK+MB_ICONERROR
		invoke ExitProcess, 1
	.endif

	; if not Win9x/ME, warn user and ask if he wants to continue
	.if osvinfo.dwPlatformId!=VER_PLATFORM_WIN32_WINDOWS
		invoke MessageBox, NULL,addr OSWarn,addr AppName,MB_YESNO+MB_ICONWARNING
		.if eax==IDNO
			invoke ExitProcess, 1
		.endif
	.endif

	; create mutex to check if another instance is running
	invoke CreateMutex, NULL,FALSE,addr ClassName
	mov    hMutex,eax

	invoke GetLastError
	.if eax!=ERROR_SUCCESS
		; make sure we close the mutex handle if we got one
		.if eax==ERROR_ALREADY_EXISTS
			invoke CloseHandle, hMutex
		.endif

		; show error message and exit
		invoke MessageBox, NULL,addr RunError,addr AppName,MB_OK+MB_ICONERROR
		invoke ExitProcess, 1
	.endif

	; attempt to open static vxd
	invoke CreateFile, addr VxDNameS,0,0,0,OPEN_EXISTING,0,0
	mov    hVxD,eax

	; if we could not open static vxd, attempt to load dynamic vxd
	.if eax==INVALID_HANDLE_VALUE

		mov    UsingDynamic, 1

		; attempt to load dynamic vxd
		invoke CreateFile, addr VxDNameD,0,0,0,OPEN_EXISTING,FILE_FLAG_DELETE_ON_CLOSE,0
		mov    hVxD,eax

		; if we could not load dynamic vxd, show error message and exit
		.if eax==INVALID_HANDLE_VALUE
			invoke MessageBox, NULL,addr VxDError,addr AppName,MB_OK+MB_ICONERROR
			invoke ExitProcess, 1
		.endif

	.endif

	; get cooling state of vxd, and store in CoolingOn
	invoke DeviceIoControl, hVxD,CPICE_GET_STATE,NULL,0,addr CoolingOn,4,addr BytesReturned,NULL

	; create suspended cooling thread and set idle-priority
	invoke CreateThread, NULL,0,addr CoolingThreadProc,0,CREATE_SUSPENDED,addr ThreadID
	mov    hThread,eax
	.if eax==0
		invoke MessageBox, NULL,addr ThreadError,addr AppName,MB_OK+MB_ICONERROR
		invoke ExitProcess, 1
	.endif
	invoke SetThreadPriority, hThread,THREAD_PRIORITY_IDLE

	; start main window (minimized)
	invoke WinMain, hInstance,NULL,CommandLine,SW_SHOWDEFAULT

	; stop cooling if dynamic vxd
	.if (UsingDynamic!=0) && (CoolingOn!=0) && (ThreadCool==0)
		invoke DeviceIoControl, hVxD,CPICE_STOP_CALLBACK,NULL,0,NULL,0,addr BytesReturned,NULL
	.endif

	; close cooling thread
	mov    ThreadCool, 0
	invoke ResumeThread, hThread
	invoke CloseHandle, hThread

	; close vxd handle (unloads the vxd if dynamic)
	invoke CloseHandle, hVxD

	; exit
	invoke ExitProcess, NULL

; -- procedures -----------------------------------------------------

WinMain proc hInst:HINSTANCE,
             hPrevInst:HINSTANCE,
             CmdLine:LPSTR,
             CmdShow:DWORD

	LOCAL  wc:WNDCLASSEX
	LOCAL  msg:MSG
	LOCAL  hwnd:HWND

	; load icons and store handles
	invoke LoadIcon, hInstance,IDI_MAINICON
	mov    hMainIcon,eax
	; we use LoadImage instead of LoadIcon for the 16x16 icons, because
	; windows by default scales the icon to 32x32 when loading the icon,
	; which makes it look garbled when it is scaled down to fit in the
	; system tray
	invoke LoadImage, hInstance,IDI_COLDICON,IMAGE_ICON,16,16,LR_DEFAULTCOLOR+LR_SHARED
	mov    hColdIcon,eax
	invoke LoadImage, hInstance,IDI_HOTICON,IMAGE_ICON,16,16,LR_DEFAULTCOLOR+LR_SHARED
	mov    hHotIcon,eax

	; setup window class structure
	mov    wc.cbSize,SIZEOF WNDCLASSEX
	mov    wc.style, CS_HREDRAW+CS_VREDRAW+CS_DBLCLKS
	mov    wc.lpfnWndProc, OFFSET WndProc
	mov    wc.cbClsExtra,NULL
	mov    wc.cbWndExtra,NULL
	MOVM   wc.hInstance,hInst
	mov    wc.hbrBackground,COLOR_APPWORKSPACE
	mov    wc.lpszMenuName,NULL
	mov    wc.lpszClassName,OFFSET ClassName
	MOVM   wc.hIcon,hMainIcon
	MOVM   wc.hIconSm,hColdIcon
	invoke LoadCursor, NULL,IDC_ARROW
	mov    wc.hCursor,eax

	; register window class
	invoke RegisterClassEx, addr wc

	; create window
	invoke CreateWindowEx, WS_EX_CLIENTEDGE,addr ClassName,addr AppName,\
		WS_OVERLAPPED+WS_CAPTION+WS_SYSMENU+WS_MINIMIZEBOX+WS_MAXIMIZEBOX,\
		CW_USEDEFAULT,CW_USEDEFAULT,350,200,NULL,NULL,hInst,NULL
	mov    hwnd,eax

	.if CoolingOn==0
		.if CL_switch['t'] || CL_switch['T']
			; put a message into message-queue to use thread
			invoke PostMessage, hwnd,WM_COMMAND,IDM_THREAD,0
		.endif
		.if CL_switch['c'] || CL_switch['C']
			; put a message into message-queue to start cooling
			invoke PostMessage, hwnd,WM_COMMAND,IDM_COOLING,0
		.endif
	.endif

	; main loop
	.while TRUE

		invoke GetMessage, addr msg,NULL,0,0

		.break .if (!eax)

		invoke TranslateMessage, addr msg
		invoke DispatchMessage, addr msg

	.endw

	mov    eax,msg.wParam
	ret

WinMain endp

WndProc proc hWnd:HWND,
             uMsg:UINT,
             wParam:WPARAM,
             lParam:LPARAM

	LOCAL  pt:POINT
	LOCAL  rect:RECT

	.if uMsg==WM_CREATE

		; create popup menu for tray icon
		invoke CreatePopupMenu
		mov    hPopupMenu,eax
		.if CoolingOn==0
			invoke AppendMenu, hPopupMenu,MF_STRING,IDM_COOLING,addr CoolingString
			invoke AppendMenu, hPopupMenu,MF_STRING,IDM_THREAD,addr ThreadString
		.else
			invoke AppendMenu, hPopupMenu,MF_STRING+MFS_CHECKED,IDM_COOLING,addr CoolingString
			invoke AppendMenu, hPopupMenu,MF_STRING+MFS_DISABLED,IDM_THREAD,addr ThreadString
		.endif
		invoke AppendMenu, hPopupMenu,MF_SEPARATOR,0,NULL
		invoke AppendMenu, hPopupMenu,MF_STRING,IDM_ABOUT,addr AboutString
		invoke AppendMenu, hPopupMenu,MF_STRING,IDM_EXIT,addr ExitString

		; create tray icon
		mov    note.cbSize,sizeof NOTIFYICONDATA
		push   hWnd
		pop    note.hwnd
		mov    note.uID,IDI_TRAY
		mov    note.uFlags,NIF_ICON+NIF_MESSAGE+NIF_TIP
		mov    note.uCallbackMessage,WM_SHELLNOTIFY
		.if CoolingOn==0
			MOVM   note.hIcon,hHotIcon
			invoke lstrcpy, addr note.szTip,addr AppNameOff
		.else
			MOVM   note.hIcon,hColdIcon
			invoke lstrcpy, addr note.szTip,addr AppNameOn
		.endif
		invoke Shell_NotifyIcon, NIM_ADD,addr note

	.elseif uMsg==WM_DESTROY

		invoke DestroyMenu, hPopupMenu
		invoke Shell_NotifyIcon, NIM_DELETE,addr note
		invoke PostQuitMessage, NULL

	.elseif uMsg==WM_COMMAND

		.if lParam==0

			mov    eax,wParam

			.if eax==IDM_ABOUT

				; show about dialog
				.if UsingDynamic==0
					invoke DialogBoxParam, hInstance,IDD_ABOUT,hWnd,addr AboutDlgProc,addr AboutMsgS
				.else
					invoke DialogBoxParam, hInstance,IDD_ABOUT,hWnd,addr AboutDlgProc,addr AboutMsgD
				.endif

			.elseif eax==IDM_COOLING

				.if CoolingOn==0

					; disable thread menu item
					invoke UpdateMenuItemState, IDM_THREAD,UMIS_DISABLE

					; start cooling
					mov    CoolingOn, 1
					.if ThreadCool
						invoke ResumeThread, hThread
					.else
						invoke DeviceIoControl, hVxD,CPICE_START_CALLBACK,NULL,0,NULL,0,addr BytesReturned,NULL
					.endif

					; check cooling menu item
					invoke UpdateMenuItemState, IDM_COOLING,UMIS_CHECK

					; change tooltip and icon
					MOVM   note.hIcon,hColdIcon
					invoke lstrcpy, addr note.szTip,addr AppNameOn
					invoke Shell_NotifyIcon, NIM_MODIFY,addr note

				.else

					; stop cooling
					mov    CoolingOn, 0
					.if ThreadCool
						invoke SuspendThread, hThread
					.else
						invoke DeviceIoControl, hVxD,CPICE_STOP_CALLBACK,NULL,0,NULL,0,addr BytesReturned,NULL
					.endif

					; enable thread menu item
					invoke UpdateMenuItemState, IDM_THREAD,UMIS_ENABLE

					; uncheck cooling menu item
					invoke UpdateMenuItemState, IDM_COOLING,UMIS_UNCHECK

					; change tooltip and icon
					MOVM   note.hIcon,hHotIcon
					invoke lstrcpy, addr note.szTip,addr AppNameOff
					invoke Shell_NotifyIcon, NIM_MODIFY,addr note

				.endif

			.elseif eax==IDM_THREAD

				.if ThreadCool==0

					mov    ThreadCool, 1

					; check thread menu item
					invoke UpdateMenuItemState, IDM_THREAD,UMIS_CHECK

				.else

					mov    ThreadCool, 0

					; uncheck thread menu item
					invoke UpdateMenuItemState, IDM_THREAD,UMIS_UNCHECK

				.endif

			.elseif eax==IDM_EXIT

				; calling DestroyWindow means we will get WM_DESTROY message
				invoke DestroyWindow, hWnd

			.endif

		.endif

	.elseif uMsg==WM_SHELLNOTIFY

		.if wParam==IDI_TRAY

			.if lParam==WM_RBUTTONDOWN

				invoke GetCursorPos, addr pt
				invoke SetForegroundWindow, hWnd
				invoke TrackPopupMenu, hPopupMenu,TPM_RIGHTALIGN+TPM_RIGHTBUTTON,pt.x,pt.y,NULL,hWnd,NULL
				invoke PostMessage, hWnd,WM_NULL,0,0

			.elseif lParam==WM_LBUTTONDBLCLK

				invoke SetForegroundWindow, hWnd
				invoke SendMessage, hWnd,WM_COMMAND,IDM_COOLING,0

			.endif

		.endif

	.else

		invoke DefWindowProc, hWnd,uMsg,wParam,lParam
		ret

	.endif

	xor    eax,eax
	ret

WndProc endp

AboutDlgProc proc hDlg   :HWND,
                  wMsg   :UINT,
                  wParam :WPARAM,
                  lParam :LPARAM

	LOCAL hStatic :HWND

	.if wMsg == WM_INITDIALOG

		; get handle of static for info
		invoke GetDlgItem, hDlg,IDC_PRGINFO
		mov hStatic,eax

		; set info text
		invoke SetWindowText, hStatic,lParam

	.elseif wMsg == WM_CLOSE

		invoke PostMessage, hDlg,WM_COMMAND,IDOK,0

	.elseif wMsg == WM_COMMAND

		.if wParam == IDOK

			; end the dialog
			invoke EndDialog, hDlg, wParam

		.endif

	.else

		mov eax,FALSE
		ret

	.endif

	mov eax,TRUE
	ret

AboutDlgProc endp

CoolingThreadProc proc param:LPVOID

	.while ThreadCool

		; perform single hlt operation
		invoke DeviceIoControl, hVxD,CPICE_PERFORM_HLT,NULL,0,NULL,0,addr BytesReturned,NULL

	.endw

	ret

CoolingThreadProc endp

UpdateMenuItemState proc menuitem :DWORD,
                         action   :DWORD

	LOCAL  miinfo:MENUITEMINFO

	mov    miinfo.cbSize,SIZE MENUITEMINFO
	mov    miinfo.fMask,MIIM_STATE
	invoke GetMenuItemInfo, hPopupMenu,menuitem,FALSE,addr miinfo

	.if eax!=0

		mov    miinfo.fMask,MIIM_STATE
		mov    eax,action

		.if eax == UMIS_CHECK
			; check
			or     miinfo.fState,MFS_CHECKED
		.elseif eax == UMIS_UNCHECK
			; uncheck
			and    miinfo.fState,NOT MFS_CHECKED
		.elseif eax == UMIS_DISABLE
			; disable
			or     miinfo.fState,MFS_DISABLED
		.elseif eax == UMIS_ENABLE
			; enable
			and    miinfo.fState,NOT MFS_DISABLED
		.endif

		invoke SetMenuItemInfo, hPopupMenu,menuitem,FALSE,addr miinfo

	.endif

	ret

UpdateMenuItemState endp

end start
