;
; wsock32 equates (struc follow this)------------------
;
AF_UNSPEC        	equ     0
AF_UNIX          	equ     1
AF_INET          	equ     2
AF_IMPLINK       	equ     3
AF_PUP          	equ     4
AF_CHAOS          	equ     5
AF_NS          		equ     6
AF_IPX          	equ     6
AF_ISO          	equ     7
AF_OSI          	equ    	AF_ISO
AF_ECMA          	equ     8
AF_DATAKIT          	equ     9
AF_CCITT          	equ     10
AF_SNA          	equ     11
AF_DECnet          	equ     12
AF_DLI          	equ     13
AF_LAT          	equ     14
AF_HYLINK          	equ     15
AF_APPLETALK          	equ   	16
AF_NETBIOS          	equ     17
AF_MAX          	equ     18
FD_READ          	equ     001h
FD_WRITE          	equ     002h
FD_OOB          	equ     004h
FD_ACCEPT          	equ     008h
FD_CONNECT          	equ    	010h
FD_CLOSE          	equ     020h
INADDR_ANY          equ       	000000000h
INADDR_LOOPBACK     equ        	07F000001h
INADDR_BROADCAST    equ       	0FFFFFFFFh
INADDR_NONE         equ		0FFFFFFFFh
INVALID_SOCKET              equ NOT 0
SOCK_STREAM		equ    	1
SOCK_DGRAM          	equ     2
SOCK_RAW          	equ     3
SOCK_RDM          	equ     4
SOCK_SEQPACKET          equ	5
SOCKET_ERROR                equ -1
WSADESCRIPTION_LEN          equ 256
WSASYS_STATUS_LEN           equ 128
WSABASEERR          equ             10000
WSAEINTR          equ               WSABASEERR+4
WSAEBADF          equ               WSABASEERR+9
WSAEACCES          equ              WSABASEERR+13
WSAEFAULT          equ              WSABASEERR+14
WSAEINVAL          equ              WSABASEERR+22
WSAEMFILE          equ              WSABASEERR+24
WSAEWOULDBLOCK          equ         WSABASEERR + 35
WSAEINPROGRESS          equ         WSABASEERR + 36
WSAEALREADY          equ            WSABASEERR + 37
WSAENOTSOCK          equ            WSABASEERR + 38
WSAEDESTADDRREQ          equ        WSABASEERR + 39
WSAEMSGSIZE          equ            WSABASEERR + 40
WSAEPROTOTYPE          equ          WSABASEERR + 41
WSAENOPROTOOPT          equ         WSABASEERR + 42
WSAEPROTONOSUPPORT          equ     WSABASEERR + 43
WSAESOCKTNOSUPPORT          equ     WSABASEERR + 44
WSAEOPNOTSUPP          equ          WSABASEERR + 45
WSAEPFNOSUPPORT          equ        WSABASEERR + 46
WSAEAFNOSUPPORT          equ        WSABASEERR + 47
WSAEADDRINUSE          equ          WSABASEERR + 48
WSAEADDRNOTAVAIL          equ       WSABASEERR + 49
WSAENETDOWN          equ            WSABASEERR + 50
WSAENETUNREACH          equ         WSABASEERR + 51
WSAENETRESET          equ           WSABASEERR + 52
WSAECONNABORTED          equ        WSABASEERR + 53
WSAECONNRESET          equ          WSABASEERR + 54
WSAENOBUFS          equ             WSABASEERR + 55
WSAEISCONN          equ             WSABASEERR + 56
WSAENOTCONN          equ            WSABASEERR + 57
WSAESHUTDOWN          equ           WSABASEERR + 58
WSAETOOMANYREFS          equ        WSABASEERR + 59
WSAETIMEDOUT          equ           WSABASEERR + 60
WSAECONNREFUSED          equ        WSABASEERR + 61
WSAELOOP          equ               WSABASEERR + 62
WSAENAMETOOLONG          equ        WSABASEERR + 63
WSAEHOSTDOWN          equ           WSABASEERR + 64
WSAEHOSTUNREACH          equ        WSABASEERR + 65
WSAENOTEMPTY          equ           WSABASEERR + 66
WSAEPROCLIM          equ            WSABASEERR + 67
WSAEUSERS          equ              WSABASEERR + 68
WSAEDQUOT          equ              WSABASEERR + 69
WSAESTALE          equ              WSABASEERR + 70
WSAEREMOTE          equ             WSABASEERR + 71
WSASYSNOTREADY          equ         WSABASEERR+91
WSAVERNOTSUPPORTED          equ     WSABASEERR+92
WSANOTINITIALISED          equ      WSABASEERR+93
WSAHOST_NOT_FOUND          equ      WSABASEERR + 1001

; ***************
TRUE		equ 1
FALSE		equ 0
NULL		equ 0
;
; Standard access rights
;
DELETE				equ 00010000h
READ_CONTROL			equ 00020000h
WRITE_DAC				equ 00040000h
WRITE_OWNER				equ 00080000h
SYNCHRONIZE				equ 00100000h

STANDARD_RIGHTS_REQUIRED	equ 000F0000h

STANDARD_RIGHTS_READ		equ READ_CONTROL
STANDARD_RIGHTS_WRITE		equ READ_CONTROL
STANDARD_RIGHTS_EXECUTE		equ READ_CONTROL

STANDARD_RIGHTS_ALL		equ 001F0000h

SPECIFIC_RIGHTS_ALL		equ 0000FFFFh
;
; Background Modes
;
TRANSPARENT	equ 1
OPAQUE	equ 2

;
; Colours + FONTS
;
Black                                equ 000000h
Blue                                 equ 0FF0000h
Green                                equ 00FF00h
Cyan                                 equ 0FFFF00h
Red                                  equ 0000FFh
Magenta                              equ 0FF00FFh
Yellow                               equ 00FFFFh
White                                equ 0FFFFFFh
Gray                                 equ 080808h
ANYSIZE_ARRAY                        equ 1
OUT_DEFAULT_PRECIS                   equ 0
OUT_STRING_PRECIS                    equ 1
OUT_CHARACTER_PRECIS                 equ 2
OUT_STROKE_PRECIS                    equ 3
OUT_TT_PRECIS                        equ 4
OUT_DEVICE_PRECIS                    equ 5
OUT_RASTER_PRECIS                    equ 6
OUT_TT_ONLY_PRECIS                   equ 7
OUT_OUTLINE_PRECIS                   equ 8
CLIP_DEFAULT_PRECIS                  equ 0
CLIP_CHARACTER_PRECIS                equ 1
CLIP_STROKE_PRECIS                   equ 2
CLIP_MASK                            equ 0Fh
CLIP_LH_ANGLES                       equ 16
CLIP_TT_ALWAYS                       equ 32
CLIP_EMBEDDED                        equ 128
DEFAULT_QUALITY                      equ 0
DRAFT_QUALITY                        equ 1
PROOF_QUALITY                        equ 2
DEFAULT_PITCH                        equ 0
FIXED_PITCH                          equ 1
VARIABLE_PITCH                       equ 2
ANSI_CHARSET                         equ 0
DEFAULT_CHARSET                      equ 1
SYMBOL_CHARSET                       equ 2
SHIFTJIS_CHARSET                     equ 128
HANGEUL_CHARSET                      equ 129
CHINESEBIG5_CHARSET                  equ 136
OEM_CHARSET                          equ 255
FF_DONTCARE                          equ 0
FF_ROMAN                             equ 16
FF_SWISS                             equ 32
FF_MODERN                            equ 48
FF_SCRIPT                            equ 64
FF_DECORATIVE                        equ 80
;
; Bitmaps
;
BI_RGB                               equ 0
BI_RLE8                              equ 1
BI_RLE4                              equ 2
BI_bitfields                         equ 3
;
; Button messages
;
BM_GETCHECK		equ 00F0h
BM_SETCHECK		equ 00F1h
BM_GETSTATE		equ 00F2h
BM_SETSTATE		equ 00F3h
BM_SETSTYLE		equ 00F4h
BM_CLICK		equ 00F5h
BM_GETIMAGE		equ 00F6h
BM_SETIMAGE		equ 00F7h
;
; Button notifications
;
BN_CLICKED		equ 0
BN_PAINT		equ 1
BN_HILITE		equ 2
BN_UNHILITE		equ 3
BN_DISABLE		equ 4
BN_DOUBLECLICKED	equ 5
BN_SETFOCUS		equ 6
BN_KILLFOCUS	equ 7

BN_PUSHED		equ BN_HILITE
BN_UNPUSHED		equ BN_UNHILITE
BN_DBLCLK		equ BN_DOUBLECLICKED
;
; Button styles
;
BS_PUSHBUTTON	equ 0000h
BS_DEFPUSHBUTTON	equ 0001h
BS_CHECKBOX		equ 0002h
BS_AUTOCHECKBOX	equ 0003h
BS_RADIOBUTTON	equ 0004h
BS_3STATE		equ 0005h
BS_AUTO3STATE	equ 0006h
BS_GROUPBOX		equ 0007h
BS_USERBUTTON	equ 0008h
BS_AUTORADIOBUTTON equ 0009h
BS_OWNERDRAW	equ 000Bh

BS_TEXT		equ 0000h
BS_LEFTTEXT		equ 0020h
BS_RIGHTBUTTON	equ BS_LEFTTEXT
BS_ICON		equ 0040h
BS_BITMAP		equ 0080h
BS_LEFT		equ 0100h
BS_RIGHT		equ 0200h
BS_CENTER		equ 0300h
BS_TOP		equ 0400h
BS_BOTTOM		equ 0800h
BS_VCENTER		equ 0C00h
BS_PUSHLIKE		equ 1000h
BS_MULTILINE	equ 2000h
BS_NOTIFY		equ 4000h
BS_FLAT		equ 8000h
;
; Button states
;
BST_UNCHECKED	equ 0h
BST_CHECKED		equ 1h
BST_INDETERMINATE	equ 2h
; get/set check state = 3h
BST_PUSHED		equ 4h	; get/set highlight state
BST_FOCUS		equ 8h	; get/set focus state
;
; Combo box messages and error return values
;
CB_OKAY	equ 0
CB_ERR	equ -1
CB_ERRSPACE	equ -2

CB_GETEDITSEL	equ 0140h
CB_LIMITTEXT	equ 0141h
CB_SETEDITSEL	equ 0142h
CB_ADDSTRING	equ 0143h
CB_DELETESTRING	equ 0144h
CB_DIR		equ 0145h
CB_GETCOUNT		equ 0146h
CB_GETCURSEL	equ 0147h
CB_GETLBTEXT	equ 0148h
CB_GETLBTEXTLEN	equ 0149h
CB_INSERTSTRING	equ 014Ah
CB_RESETCONTENT	equ 014Bh
CB_FINDSTRING	equ 014Ch
CB_SELECTSTRING	equ 014Dh
CB_SETCURSEL	equ 014Eh
CB_SHOWDROPDOWN	equ 014Fh
CB_GETITEMDATA	equ 0150h
CB_SETITEMDATA	equ 0151h
CB_GETDROPPEDCONTROLRECT equ 0152h
CB_SETITEMHEIGHT	equ 0153h
CB_GETITEMHEIGHT	equ 0154h
CB_SETEXTENDEDUI	equ 0155h
CB_GETEXTENDEDUI	equ 0156h
CB_GETDROPPEDSTATE equ 0157h
CB_FINDSTRINGEXACT equ 0158h
CB_SETLOCALE	equ 0159h
CB_GETLOCALE	equ 015Ah

CB_GETTOPINDEX	equ 015Bh
CB_SETTOPINDEX	equ 015Ch
CB_GETHORIZONTALEXTENT equ 015Dh
CB_SETHORIZONTALEXTENT equ 015Eh
CB_GETDROPPEDWIDTH equ 015Fh
CB_SETDROPPEDWIDTH equ 0160h
CB_INITSTORAGE	equ 0161h
CB_MSGMAX		equ 0162h	; pre 4.0 = 015Bh
;
; Combo box notifications
;
CBN_ERRSPACE	equ -1
CBN_SELCHANGE	equ 1
CBN_DBLCLK		equ 2
CBN_SETFOCUS	equ 3
CBN_KILLFOCUS	equ 4
CBN_EDITCHANGE	equ 5
CBN_EDITUPDATE	equ 6
CBN_DROPDOWN	equ 7
CBN_CLOSEUP		equ 8
CBN_SELENDOK	equ 9
CBN_SELENDCANCEL	equ 10
;
; Combo box styles
;
CBS_SIMPLE		equ 0001h
CBS_DROPDOWN	equ 0002h
CBS_DROPDOWNLIST	equ 0003h
CBS_OWNERDRAWFIXED    equ 0010h
CBS_OWNERDRAWVARIABLE equ 0020h
CBS_AUTOHSCROLL	equ 0040h
CBS_OEMCONVERT	equ 0080h
CBS_SORT		equ 0100h
CBS_HASSTRINGS	equ 0200h
CBS_NOINTEGRALHEIGHT equ 0400h
CBS_DISABLENOSCROLL  equ 0800h
CBS_UPPERCASE	equ 2000h
CBS_LOWERCASE	equ 4000h
;
; Rich Edit
;
CFM_BOLD               equ 00000001h
CFM_ITALIC             equ 00000002h
CFM_UNDERLINE          equ 00000004h
CFM_STRIKEOUT          equ 00000008h
CFM_PROTECTED          equ 00000010h
CFM_SIZE               equ 80000000h
CFM_COLOR              equ 40000000h
CFM_FACE               equ 20000000h
CFM_OFFSET             equ 10000000h
CFM_CHARSET            equ 08000000h
CFM_BACKCOLOR           equ 4000000h
CFM_LCID                equ 2000000h
CFM_UNDERLINETYPE       equ 800000h
CFM_WEIGHT              equ 400000h
CFM_SPACING             equ 200000h
CFM_KERNING             equ 100000h
CFM_STYLE               equ 80000h
CFM_ANIMATION           equ 40000h
CFM_REVAUTHOR           equ 8000h
CFM_SMALLCAPS           equ 40h
CFM_ALLCAPS             equ 80h
CFM_HIDDEN              equ 100h
CFM_OUTLINE             equ 200h
CFM_SHADOW              equ 400h
CFM_EMBOSS              equ 800h
CFM_IMPRINT             equ 1000h
CFM_DISABLED            equ 2000h
CFM_REVISED             equ 4000h
CFE_BOLD               equ 0001h
CFE_ITALIC             equ 0002h
CFE_UNDERLINE          equ 0004h
CFE_STRIKEOUT          equ 0008h
CFE_PROTECTED          equ 0010h
CFE_AUTOCOLOR          equ 40000000h
;
; System colors
;
COLOR_SCROLLBAR		equ 0
COLOR_BACKGROUND		equ 1
COLOR_ACTIVECAPTION	equ 2
COLOR_INACTIVECAPTION	equ 3
COLOR_MENU			equ 4
COLOR_WINDOW		equ 5
COLOR_WINDOWFRAME		equ 6
COLOR_MENUTEXT		equ 7
COLOR_WINDOWTEXT		equ 8
COLOR_CAPTIONTEXT		equ 9
COLOR_ACTIVEBORDER	equ 10
COLOR_INACTIVEBORDER	equ 11
COLOR_APPWORKSPACE	equ 12
COLOR_HIGHLIGHT		equ 13
COLOR_HIGHLIGHTTEXT	equ 14
COLOR_BTNFACE		equ 15
COLOR_BTNSHADOW		equ 16
COLOR_GRAYTEXT		equ 17
COLOR_BTNTEXT		equ 18
COLOR_INACTIVECAPTIONTEXT equ 19
COLOR_BTNHIGHLIGHT	equ 20

COLOR_DESKTOP		equ COLOR_BACKGROUND
COLOR_BTNHILIGHT		equ COLOR_BTNHIGHLIGHT
COLOR_3DFACE		equ COLOR_BTNFACE
COLOR_3DSHADOW		equ COLOR_BTNSHADOW
COLOR_3DHIGHLIGHT		equ COLOR_BTNHIGHLIGHT
COLOR_3DHILIGHT		equ COLOR_BTNHIGHLIGHT

COLOR_3DDKSHADOW		equ 21
COLOR_3DLIGHT		equ 22
COLOR_INFOTEXT		equ 23
COLOR_INFOBK		equ 24
;
; Window class styles
;
CS_VREDRAW		equ	0001h
CS_HREDRAW		equ	0002h
CS_KEYCVTWINDOW	equ	0004h
CS_DBLCLKS		equ	0008h
CS_OWNDC		equ	0020h
CS_CLASSDC		equ	0040h
CS_PARENTDC		equ	0080h
CS_NOKEYCVT		equ	0100h
CS_NOCLOSE		equ	0200h
CS_SAVEBITS		equ	0800h
CS_BYTEALIGNCLIENT equ	1000h
CS_BYTEALIGNWINDOW equ	2000h
CS_GLOBALCLASS	equ	4000h

CS_IME		equ	10000h
;
; CreateWindowEx parameter
;
CW_USEDEFAULT	equ 80000000h
;
; Dialog window class
;
WC_DIALOG		equ 8002h
;
; Extra window bytes needed for private dialog class
;
DLGWINDOWEXTRA	equ 30
;
; Bit blit pic stuff
;
DIB_RGB_COLORS                       equ 0
DIB_PAL_COLORS                       equ 1
DIB_PAL_INDICES                      equ 2
DIB_PAL_PHYSINDICES                  equ 2
DIB_PAL_LOGINDICES                   equ 4
;
; Dialog extra window bytes field offsets
;
DWL_MSGRESULT	equ 0
DWL_DLGPROC		equ 4
DWL_USER		equ 8
;
; Dialog box styles
;
DS_ABSALIGN		equ 0001h
DS_SYSMODAL		equ 0002h
DS_LOCALEDIT	equ 0020h  ; /* Edit items get Local storage. */
DS_SETFONT		equ 0040h  ; /* User specified font for Dlg controls */
DS_MODALFRAME	equ 0080h  ; /* Can be combined with WS_CAPTION  */
DS_NOIDLEMSG	equ 0100h  ; /* WM_ENTERIDLE message will not be sent */
DS_SETFOREGROUND	equ 0200h  ; /* not in win3.1 */
; Win4.0
DS_3DLOOK		equ 0004h
DS_FIXEDSYS		equ 0008h
DS_NOFAILCREATE	equ 0010h
DS_CONTROL		equ 0400h
DS_CENTER		equ 0800h
DS_CENTERMOUSE	equ 1000h
DS_CONTEXTHELP	equ 2000h
;
; DrawText parameters
;
DT_TOP          equ 0000H
DT_LEFT         equ 0000H
DT_CENTER       equ 0001H
DT_RIGHT        equ 0002H
DT_VCENTER      equ 0004H
DT_BOTTOM       equ 0008H
DT_WORDBREAK    equ 0010H
DT_SINGLELINE   equ 0020H
DT_EXPANDTABS   equ 0040H
DT_TABSTOP      equ 0080H
DT_NOCLIP       equ 0100H
DT_EXTERNALLEADING equ 0200H
DT_CALCRECT     equ 0400H
DT_NOPREFIX     equ 0800H
;DT_INTERNAL     equ 1000H
;
; Edit window EM_SETMARGIN parameters
;
EC_LEFTMARGIN	equ 0001h
EC_RIGHTMARGIN	equ 0002h
EC_USEFONTINFO	equ 0FFFFh
;
; Edit window messages
; Some of these are shared with the Rich Edit window
;
EM_GETSEL		equ 00B0h
EM_SETSEL		equ 00B1h
EM_GETRECT		equ 00B2h
EM_SETRECT		equ 00B3h
EM_SETRECTNP	equ 00B4h
EM_SCROLL		equ 00B5h
EM_LINESCROLL	equ 00B6h
EM_SCROLLCARET	equ 00B7h
EM_GETMODIFY	equ 00B8h
EM_SETMODIFY	equ 00B9h
EM_GETLINECOUNT	equ 00BAh
EM_LINEINDEX	equ 00BBh
EM_SETHANDLE	equ 00BCh
EM_GETHANDLE	equ 00BDh
EM_GETTHUMB		equ 00BEh
EM_LINELENGTH	equ 00C1h
EM_REPLACESEL	equ 00C2h
EM_GETLINE		equ 00C4h
EM_LIMITTEXT	equ 00C5h
EM_CANUNDO		equ 00C6h
EM_UNDO		equ 00C7h
EM_FMTLINES		equ 00C8h
EM_LINEFROMCHAR	equ 00C9h
EM_SETTABSTOPS	equ 00CBh
EM_SETPASSWORDCHAR equ 00CCh
EM_EMPTYUNDOBUFFER equ 00CDh
EM_GETFIRSTVISIBLELINE equ 00CEh
EM_SETREADONLY	equ 00CFh
EM_SETWORDBREAKPROC equ 00D0h
EM_GETWORDBREAKPROC equ 00D1h
EM_GETPASSWORDCHAR  equ 00D2h
EM_SETMARGINS	equ 00D3h
EM_GETMARGINS	equ 00D4h
EM_SETLIMITTEXT	equ EM_LIMITTEXT	; win40 Name change
EM_GETLIMITTEXT	equ 00D5h
EM_POSFROMCHAR	equ 00D6h
EM_CHARFROMPOS	equ 00D7h

EM_CANPASTE                 equ WM_USER + 50
EM_DISPLAYBAND              equ WM_USER + 51
EM_EXGETSEL                 equ WM_USER + 52
EM_EXLIMITTEXT              equ WM_USER + 53
EM_EXLINEFROMCHAR           equ WM_USER + 54
EM_EXSETSEL                 equ WM_USER + 55
EM_FINDTEXT                 equ WM_USER + 56
EM_FORMATRANGE              equ WM_USER + 57
EM_GETCHARFORMAT            equ WM_USER + 58
EM_GETEVENTMASK             equ WM_USER + 59
EM_GETOLEINTERFACE          equ WM_USER + 60
EM_GETPARAFORMAT            equ WM_USER + 61
EM_GETSELTEXT               equ WM_USER + 62
EM_HIDESELECTION            equ WM_USER + 63
EM_PASTESPECIAL             equ WM_USER + 64
EM_REQUESTRESIZE            equ WM_USER + 65
EM_SELECTIONTYPE            equ WM_USER + 66
EM_SETBKGNDCOLOR            equ WM_USER + 67
EM_SETCHARFORMAT            equ WM_USER + 68
EM_SETEVENTMASK             equ WM_USER + 69
EM_SETOLECALLBACK           equ WM_USER + 70
EM_SETPARAFORMAT            equ WM_USER + 71
EM_SETTARGETDEVICE          equ WM_USER + 72
EM_STREAMIN                 equ WM_USER + 73
EM_STREAMOUT                equ WM_USER + 74
EM_GETTEXTRANGE             equ WM_USER + 75
EM_FINDWORDBREAK            equ WM_USER + 76
EM_SETOPTIONS               equ WM_USER + 77
EM_GETOPTIONS               equ WM_USER + 78
EM_FINDTEXTEX               equ WM_USER + 79
EM_GETWORDBREAKPROCEX       equ WM_USER + 80
EM_SETWORDBREAKPROCEX       equ WM_USER + 81
EM_SETUNDOLIMIT             equ WM_USER + 82
EM_REDO                     equ WM_USER + 84
EM_CANREDO                  equ WM_USER + 85
EM_GETUNDONAME              equ WM_USER + 86
EM_GETREDONAME              equ WM_USER + 87
EM_STOPGROUPTYPING          equ WM_USER + 88
EM_SETTEXTMODE              equ WM_USER + 89
EM_GETTEXTMODE              equ WM_USER + 90
EM_AUTOURLDETECT            equ WM_USER + 91
EM_GETAUTOURLDETECT         equ WM_USER + 92
EM_SETPALETTE               equ WM_USER + 93
EM_GETTEXTEX                equ WM_USER + 94
EM_GETTEXTLENGTHEX          equ WM_USER + 95
EM_SHOWSCROLLBAR            equ WM_USER + 96

EM_SETPUNCTUATION           equ WM_USER + 100
EM_GETPUNCTUATION           equ WM_USER + 101
EM_SETWORDWRAPMODE          equ WM_USER + 102
EM_GETWORDWRAPMODE          equ WM_USER + 103
EM_SETIMECOLOR              equ WM_USER + 104
EM_GETIMECOLOR              equ WM_USER + 105
EM_SETIMEOPTIONS            equ WM_USER + 106
EM_GETIMEOPTIONS            equ WM_USER + 107
EM_CONVPOSITION             equ WM_USER + 108
EM_SETLANGOPTIONS           equ WM_USER + 120
EM_GETLANGOPTIONS           equ WM_USER + 121
EM_GETIMECOMPMODE           equ WM_USER + 122
EM_FINDTEXTW                equ WM_USER + 123
EM_FINDTEXTEXW              equ WM_USER + 124
EM_RECONVERSION             equ WM_USER + 125
EM_SETIMEMODEBIAS           equ WM_USER + 126  
EM_GETIMEMODEBIAS           equ WM_USER + 127
EM_SETBIDIOPTIONS           equ WM_USER + 200
EM_GETBIDIOPTIONS           equ WM_USER + 201
EM_SETTYPOGRAPHYOPTIONS     equ WM_USER + 202
EM_GETTYPOGRAPHYOPTIONS     equ WM_USER + 203
EM_SETEDITSTYLE             equ WM_USER + 204
EM_GETEDITSTYLE             equ WM_USER + 205

EM_OUTLINE                  equ WM_USER + 220
EM_GETSCROLLPOS             equ WM_USER + 221
EM_SETSCROLLPOS             equ WM_USER + 222
EM_SETFONTSIZE              equ WM_USER + 223
EM_GETZOOM                  equ WM_USER + 224
EM_SETZOOM                  equ WM_USER + 225
;
; Edit window notification codes
;
EN_SETFOCUS		equ 0100h
EN_KILLFOCUS	equ 0200h
EN_CHANGE		equ 0300h
EN_UPDATE		equ 0400h
EN_ERRSPACE		equ 0500h
EN_MAXTEXT		equ 0501h
EN_HSCROLL		equ 0601h
EN_VSCROLL		equ 0602h
;
; Error return messages (use with format message or read yourself)
;
ERROR_SUCCESS                        equ 0
ERROR_INVALID_FUNCTION               equ 1
ERROR_FILE_NOT_FOUND                 equ 2
ERROR_PATH_NOT_FOUND                 equ 3
ERROR_TOO_MANY_OPEN_FILES            equ 4
ERROR_ACCESS_DENIED                  equ 5
ERROR_INVALID_HANDLE                 equ 6
ERROR_ARENA_TRASHED                  equ 7
ERROR_NOT_ENOUGH_MEMORY              equ 8
ERROR_INVALID_BLOCK                  equ 9
ERROR_BAD_ENVIRONMENT                equ 10
ERROR_BAD_FORMAT                     equ 11
ERROR_INVALID_ACCESS                 equ 12
ERROR_INVALID_DATA                   equ 13
ERROR_OUTOFMEMORY                    equ 14
ERROR_INVALID_DRIVE                  equ 15
ERROR_CURRENT_DIRECTORY              equ 16
ERROR_NOT_SAME_DEVICE                equ 17
ERROR_NO_MORE_FILES                  equ 18
ERROR_WRITE_PROTECT                  equ 19
ERROR_BAD_UNIT                       equ 20
ERROR_NOT_READY                      equ 21
ERROR_BAD_COMMAND                    equ 22
ERROR_CRC                            equ 23
ERROR_BAD_LENGTH                     equ 24
ERROR_SEEK                           equ 25
ERROR_NOT_DOS_DISK                   equ 26
ERROR_SECTOR_NOT_FOUND               equ 27
ERROR_OUT_OF_PAPER                   equ 28
ERROR_WRITE_FAULT                    equ 29
ERROR_READ_FAULT                     equ 30
ERROR_GEN_FAILURE                    equ 31
ERROR_SHARING_VIOLATION              equ 32
ERROR_LOCK_VIOLATION                 equ 33
ERROR_WRONG_DISK                     equ 34
ERROR_SHARING_BUFFER_EXCEEDED        equ 36
ERROR_HANDLE_EOF                     equ 38
ERROR_HANDLE_DISK_FULL               equ 39
ERROR_NOT_SUPPORTED                  equ 50
ERROR_REM_NOT_LIST                   equ 51
ERROR_DUP_NAME                       equ 52
ERROR_BAD_NETPATH                    equ 53
ERROR_NETWORK_BUSY                   equ 54
ERROR_DEV_NOT_EXIST                  equ 55
ERROR_TOO_MANY_CMDS                  equ 56
ERROR_ADAP_HDW_ERR                   equ 57
ERROR_BAD_NET_RESP                   equ 58
ERROR_UNEXP_NET_ERR                  equ 59
ERROR_BAD_REM_ADAP                   equ 60
ERROR_PRINTQ_FULL                    equ 61
ERROR_NO_SPOOL_SPACE                 equ 62
ERROR_PRINT_CANCELLED                equ 63
ERROR_NETNAME_DELETED                equ 64
ERROR_NETWORK_ACCESS_DENIED          equ 65
ERROR_BAD_DEV_TYPE                   equ 66
ERROR_BAD_NET_NAME                   equ 67
ERROR_TOO_MANY_NAMES                 equ 68
ERROR_TOO_MANY_SESS                  equ 69
ERROR_SHARING_PAUSED                 equ 70
ERROR_REQ_NOT_ACCEP                  equ 71
ERROR_REDIR_PAUSED                   equ 72
ERROR_FILE_EXISTS                    equ 80
ERROR_CANNOT_MAKE                    equ 82
ERROR_FAIL_I24                       equ 83
ERROR_OUT_OF_STRUCTURES              equ 84
ERROR_ALREADY_ASSIGNED               equ 85
ERROR_INVALID_PASSWORD               equ 86
ERROR_INVALID_PARAMETER              equ 87
ERROR_NET_WRITE_FAULT                equ 88
ERROR_NO_PROC_SLOTS                  equ 89
ERROR_TOO_MANY_SEMAPHORES            equ 100
ERROR_EXCL_SEM_ALREADY_OWNED         equ 101
ERROR_SEM_IS_SET                     equ 102
ERROR_TOO_MANY_SEM_REQUESTS          equ 103
ERROR_INVALID_AT_INTERRUPT_TIME      equ 104
ERROR_SEM_OWNER_DIED                 equ 105
ERROR_SEM_USER_LIMIT                 equ 106
ERROR_DISK_CHANGE                    equ 107
ERROR_DRIVE_LOCKED                   equ 108
ERROR_BROKEN_PIPE                    equ 109
ERROR_OPEN_FAILED                    equ 110
ERROR_BUFFER_OVERFLOW                equ 111
ERROR_DISK_FULL                      equ 112
ERROR_NO_MORE_SEARCH_HANDLES         equ 113
ERROR_INVALID_TARGET_HANDLE          equ 114
ERROR_INVALID_CATEGORY               equ 117
ERROR_INVALID_VERIFY_SWITCH          equ 118
ERROR_BAD_DRIVER_LEVEL               equ 119
ERROR_CALL_NOT_IMPLEMENTED           equ 120
ERROR_SEM_TIMEOUT                    equ 121
ERROR_INSUFFICIENT_BUFFER            equ 122
ERROR_INVALID_NAME                   equ 123
ERROR_INVALID_LEVEL                  equ 124
ERROR_NO_VOLUME_LABEL                equ 125
ERROR_MOD_NOT_FOUND                  equ 126
ERROR_PROC_NOT_FOUND                 equ 127
ERROR_WAIT_NO_CHILDREN               equ 128
ERROR_CHILD_NOT_COMPLETE             equ 129
ERROR_DIRECT_ACCESS_HANDLE           equ 130
ERROR_NEGATIVE_SEEK                  equ 131
ERROR_SEEK_ON_DEVICE                 equ 132
ERROR_IS_JOIN_TARGET                 equ 133
ERROR_IS_JOINED                      equ 134
ERROR_IS_SUBSTED                     equ 135
ERROR_NOT_JOINED                     equ 136
ERROR_NOT_SUBSTED                    equ 137
ERROR_JOIN_TO_JOIN                   equ 138
ERROR_SUBST_TO_SUBST                 equ 139
ERROR_JOIN_TO_SUBST                  equ 140
ERROR_SUBST_TO_JOIN                  equ 141
ERROR_BUSY_DRIVE                     equ 142
ERROR_SAME_DRIVE                     equ 143
ERROR_DIR_NOT_ROOT                   equ 144
ERROR_DIR_NOT_EMPTY                  equ 145
ERROR_IS_SUBST_PATH                  equ 146
ERROR_IS_JOIN_PATH                   equ 147
ERROR_PATH_BUSY                      equ 148
ERROR_IS_SUBST_TARGET                equ 149
ERROR_SYSTEM_TRACE                   equ 150
ERROR_INVALID_EVENT_COUNT            equ 151
ERROR_TOO_MANY_MUXWAITERS            equ 152
ERROR_INVALID_LIST_FORMAT            equ 153
ERROR_LABEL_TOO_LONG                 equ 154
ERROR_TOO_MANY_TCBS                  equ 155
ERROR_SIGNAL_REFUSED                 equ 156
ERROR_DISCARDED                      equ 157
ERROR_NOT_LOCKED                     equ 158
ERROR_BAD_THREADID_ADDR              equ 159
ERROR_BAD_ARGUMENTS                  equ 160
ERROR_BAD_PATHNAME                   equ 161
ERROR_SIGNAL_PENDING                 equ 162
ERROR_MAX_THRDS_REACHED              equ 164
ERROR_LOCK_FAILED                    equ 167
ERROR_BUSY                           equ 170
ERROR_CANCEL_VIOLATION               equ 173
ERROR_ATOMIC_LOCKS_NOT_SUPPORTED     equ 174
ERROR_INVALID_SEGMENT_NUMBER         equ 180
ERROR_INVALID_ORDINAL                equ 182
ERROR_ALREADY_EXISTS                 equ 183
ERROR_INVALID_FLAG_NUMBER            equ 186
ERROR_SEM_NOT_FOUND                  equ 187
ERROR_INVALID_STARTING_CODESEG       equ 188
ERROR_INVALID_STACKSEG               equ 189
ERROR_INVALID_MODULETYPE             equ 190
ERROR_INVALID_EXE_SIGNATURE          equ 191
ERROR_EXE_MARKED_INVALID             equ 192
ERROR_BAD_EXE_FORMAT                 equ 193
ERROR_ITERATED_DATA_EXCEEDS_64k      equ 194
ERROR_INVALID_MINALLOCSIZE           equ 195
ERROR_DYNLINK_FROM_INVALID_RING      equ 196
ERROR_IOPL_NOT_ENABLED               equ 197
ERROR_INVALID_SEGDPL                 equ 198
ERROR_AUTODATASEG_EXCEEDS_64k        equ 199
ERROR_RING2SEG_MUST_BE_MOVABLE       equ 200
ERROR_RELOC_CHAIN_XEEDS_SEGLIM       equ 201
ERROR_INFLOOP_IN_RELOC_CHAIN         equ 202
ERROR_ENVVAR_NOT_FOUND               equ 203
ERROR_NO_SIGNAL_SENT                 equ 205
ERROR_FILENAME_EXCED_RANGE           equ 206
ERROR_RING2_STACK_IN_USE             equ 207
ERROR_META_EXPANSION_TOO_LONG        equ 208
ERROR_INVALID_SIGNAL_NUMBER          equ 209
ERROR_THREAD_1_INACTIVE              equ 210
ERROR_LOCKED                         equ 212
ERROR_TOO_MANY_MODULES               equ 214
ERROR_NESTING_NOT_ALLOWED            equ 215
ERROR_BAD_PIPE                       equ 230
ERROR_PIPE_BUSY                      equ 231
ERROR_NO_DATA                        equ 232
ERROR_PIPE_NOT_CONNECTED             equ 233
ERROR_MORE_DATA                      equ 234
ERROR_VC_DISCONNECTED                equ 240
ERROR_INVALID_EA_NAME                equ 254
ERROR_EA_LIST_INCONSISTENT           equ 255
ERROR_NO_MORE_ITEMS                  equ 259
ERROR_CANNOT_COPY                    equ 266
ERROR_DIRECTORY                      equ 267
ERROR_EAS_DIDNT_FIT                  equ 275
ERROR_EA_FILE_CORRUPT                equ 276
ERROR_EA_TABLE_FULL                  equ 277
ERROR_INVALID_EA_HANDLE              equ 278
ERROR_EAS_NOT_SUPPORTED              equ 282
ERROR_NOT_OWNER                      equ 288
ERROR_TOO_MANY_POSTS                 equ 298
ERROR_MR_MID_NOT_FOUND               equ 317
ERROR_INVALID_ADDRESS                equ 487
ERROR_ARITHMETIC_OVERFLOW            equ 534
ERROR_PIPE_CONNECTED                 equ 535
ERROR_PIPE_LISTENING                 equ 536
ERROR_EA_ACCESS_DENIED               equ 994
ERROR_OPERATION_ABORTED              equ 995
ERROR_IO_INCOMPLETE                  equ 996
ERROR_IO_PENDING                     equ 997
ERROR_NOACCESS                       equ 998
ERROR_SWAPERROR                      equ 999
ERROR_STACK_OVERFLOW                 equ 1001
ERROR_INVALID_MESSAGE                equ 1002
ERROR_CAN_NOT_COMPLETE               equ 1003
ERROR_INVALID_FLAGS                  equ 1004
ERROR_UNRECOGNIZED_VOLUME            equ 1005
ERROR_FILE_INVALID                   equ 1006
ERROR_FULLSCREEN_MODE                equ 1007
ERROR_NO_TOKEN                       equ 1008
ERROR_BADDB                          equ 1009
ERROR_BADKEY                         equ 1010
ERROR_CANTOPEN                       equ 1011
ERROR_CANTREAD                       equ 1012
ERROR_CANTWRITE                      equ 1013
ERROR_REGISTRY_RECOVERED             equ 1014
ERROR_REGISTRY_CORRUPT               equ 1015
ERROR_REGISTRY_IO_FAILED             equ 1016
ERROR_NOT_REGISTRY_FILE              equ 1017
ERROR_KEY_DELETED                    equ 1018
ERROR_NO_LOG_SPACE                   equ 1019
ERROR_KEY_HAS_CHILDREN               equ 1020
ERROR_CHILD_MUST_BE_VOLATILE         equ 1021
ERROR_NOTIFY_ENUM_DIR                equ 1022
ERROR_DEPENDENT_SERVICES_RUNNING     equ 1051
ERROR_INVALID_SERVICE_CONTROL        equ 1052
ERROR_SERVICE_REQUEST_TIMEOUT        equ 1053
ERROR_SERVICE_NO_THREAD              equ 1054
ERROR_SERVICE_DATABASE_LOCKED        equ 1055
ERROR_SERVICE_ALREADY_RUNNING        equ 1056
ERROR_INVALID_SERVICE_ACCOUNT        equ 1057
ERROR_SERVICE_DISABLED               equ 1058
ERROR_CIRCULAR_DEPENDENCY            equ 1059
ERROR_SERVICE_DOES_NOT_EXIST         equ 1060
ERROR_SERVICE_CANNOT_ACCEPT_CTRL     equ 1061
ERROR_SERVICE_NOT_ACTIVE             equ 1062
ERROR_FAILED_SERVICE_CONTROLLER_CONNECT              equ 1063
ERROR_EXCEPTION_IN_SERVICE           equ 1064
ERROR_DATABASE_DOES_NOT_EXIST        equ 1065
ERROR_SERVICE_SPECIFIC_ERROR         equ 1066
ERROR_PROCESS_ABORTED                equ 1067
ERROR_SERVICE_DEPENDENCY_FAIL        equ 1068
ERROR_SERVICE_LOGON_FAILED           equ 1069
ERROR_SERVICE_START_HANG             equ 1070
ERROR_INVALID_SERVICE_LOCK           equ 1071
ERROR_SERVICE_MARKED_FOR_DELETE      equ 1072
ERROR_SERVICE_EXISTS                 equ 1073
ERROR_ALREADY_RUNNING_LKG            equ 1074
ERROR_SERVICE_DEPENDENCY_DELETED     equ 1075
ERROR_BOOT_ALREADY_ACCEPTED          equ 1076
ERROR_SERVICE_NEVER_STARTED          equ 1077
ERROR_DUPLICATE_SERVICE_NAME         equ 1078
ERROR_END_OF_MEDIA                   equ 1100
ERROR_FILEMARK_DETECTED              equ 1101
ERROR_BEGINNING_OF_MEDIA             equ 1102
ERROR_SETMARK_DETECTED               equ 1103
ERROR_NO_DATA_DETECTED               equ 1104
ERROR_PARTITION_FAILURE              equ 1105
ERROR_INVALID_BLOCK_LENGTH           equ 1106
ERROR_DEVICE_NOT_PARTITIONED         equ 1107
ERROR_UNABLE_TO_LOCK_MEDIA           equ 1108
ERROR_UNABLE_TO_UNLOAD_MEDIA         equ 1109
ERROR_MEDIA_CHANGED                  equ 1110
ERROR_BUS_RESET                      equ 1111
ERROR_NO_MEDIA_IN_DRIVE              equ 1112
ERROR_NO_UNICODE_TRANSLATION         equ 1113
ERROR_DLL_INIT_FAILED                equ 1114
ERROR_SHUTDOWN_IN_PROGRESS           equ 1115
ERROR_NO_SHUTDOWN_IN_PROGRESS        equ 1116
ERROR_IO_DEVICE                      equ 1117
ERROR_SERIAL_NO_DEVICE               equ 1118
ERROR_IRQ_BUSY                       equ 1119
ERROR_MORE_WRITES                    equ 1120
ERROR_COUNTER_TIMEOUT                equ 1121
ERROR_FLOPPY_ID_MARK_NOT_FOUND       equ 1122
ERROR_FLOPPY_WRONG_CYLINDER          equ 1123
ERROR_FLOPPY_UNKNOWN_ERROR           equ 1124
ERROR_FLOPPY_BAD_REGISTERS           equ 1125
ERROR_DISK_RECALIBRATE_FAILED        equ 1126
ERROR_DISK_OPERATION_FAILED          equ 1127
ERROR_DISK_RESET_FAILED              equ 1128
ERROR_EOM_OVERFLOW                   equ 1129
ERROR_NOT_ENOUGH_SERVER_MEMORY       equ 1130
ERROR_POSSIBLE_DEADLOCK              equ 1131
ERROR_MAPPED_ALIGNMENT               equ 1132
ERROR_INVALID_PIXEL_FORMAT           equ 2000
ERROR_BAD_DRIVER                     equ 2001
ERROR_INVALID_WINDOW_STYLE           equ 2002
ERROR_METAFILE_NOT_SUPPORTED         equ 2003
ERROR_TRANSFORM_NOT_SUPPORTED        equ 2004
ERROR_CLIPPING_NOT_SUPPORTED         equ 2005
ERROR_UNKNOWN_PRINT_MONITOR          equ 3000
ERROR_PRINTER_DRIVER_IN_USE          equ 3001
ERROR_SPOOL_FILE_NOT_FOUND           equ 3002
ERROR_SPL_NO_STARTDOC                equ 3003
ERROR_SPL_NO_ADDJOB                  equ 3004
ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED              equ 3005
ERROR_PRINT_MONITOR_ALREADY_INSTALLED                equ 3006
ERROR_WINS_INTERNAL                  equ 4000
ERROR_CAN_NOT_DEL_LOCAL_WINS         equ 4001
ERROR_STATIC_INIT                    equ 4002
ERROR_INC_BACKUP                     equ 4003
ERROR_FULL_BACKUP                    equ 4004
ERROR_REC_NON_EXISTENT               equ 4005
ERROR_RPL_NOT_ALLOWED                equ 4006
;
; Edit window style
;
ES_LEFT			equ 0000h
ES_CENTER		equ 0001h
ES_RIGHT		equ 0002h
ES_MULTILINE		equ 0004h
ES_UPPERCASE		equ 0008h
ES_LOWERCASE		equ 0010h
ES_PASSWORD		equ 0020h
ES_AUTOVSCROLL		equ 0040h
ES_AUTOHSCROLL		equ 0080h
ES_NOHIDESEL		equ 0100h
ES_OEMCONVERT		equ 0400h
ES_READONLY		equ 0800h
ES_WANTRETURN		equ 1000h
ES_NUMBER		equ 2000h

ES_SAVESEL                  equ 00008000h
ES_SUNKEN                   equ 00004000h
ES_DISABLENOSCROLL          equ 00002000h
ES_SELECTIONBAR             equ 01000000h
ES_EX_NOCALLOLEINIT         equ 01000000h
ES_VERTICAL                 equ 00400000h
ES_NOIME                    equ 00080000h
ES_SELFIME                  equ 00040000h

; Exit windows params - not sure on shutdown
EWX_LOGOFF    		equ 0
EWX_SHUTDOWN  		equ 1
EWX_REBOOT    		equ 2
EWX_FORCE     		equ 4
EWX_POWEROFF  		equ 8
;
; SEH param
;
ExceptionContinueExecution              equ 0
ExceptionContinueSearch                 equ 1
ExceptionNestedException                equ 2
ExceptionCollidedUnwind                 equ 3

EXCEPTION_EXECUTE_HANDLER               equ 1
EXCEPTION_CONTINUE_SEARCH               equ  0
EXCEPTION_CONTINUE_EXECUTION            equ -1
;
; File constants
;
INVALID_HANDLE_VALUE	equ	-1

CREATE_NEW		equ 1
CREATE_ALWAYS		equ 2
OPEN_EXISTING		equ 3
OPEN_ALWAYS		equ 4
TRUNCATE_EXISTING	equ 5

GENERIC_READ	equ 80000000h
GENERIC_WRITE	equ 40000000h
GENERIC_EXECUTE	equ 20000000h
GENERIC_ALL	equ 10000000h

FILE_ATTRIBUTE_READONLY		equ 00000001h
FILE_ATTRIBUTE_HIDDEN		equ 00000002h
FILE_ATTRIBUTE_SYSTEM		equ 00000004h
FILE_ATTRIBUTE_DIRECTORY	equ 00000010h
FILE_ATTRIBUTE_ARCHIVE		equ 00000020h
FILE_ATTRIBUTE_NORMAL		equ 00000080h
FILE_ATTRIBUTE_TEMPORARY	equ 00000100h
FILE_ATTRIBUTE_COMPRESSED	equ 00000800h

FILE_BEGIN 				equ 0
FILE_CURRENT                 	equ 1
FILE_END           		equ 2

FILE_FLAG_WRITE_THROUGH		equ 80000000h
FILE_FLAG_OVERLAPPED		equ 40000000h
FILE_FLAG_NO_BUFFERING		equ 20000000h
FILE_FLAG_RANDOM_ACCESS		equ 10000000h
FILE_FLAG_SEQUENTIAL_SCAN	equ 08000000h
FILE_FLAG_DELETE_ON_CLOSE	equ 04000000h
FILE_FLAG_BACKUP_SEMANTICS	equ 02000000h
FILE_FLAG_POSIX_SEMANTICS	equ 01000000h

FILE_SHARE_READ			equ 00000001h
FILE_SHARE_WRITE		equ 00000002h
;
;
;
FILE_READ_DATA			equ 0001h	; file & pipe
FILE_LIST_DIRECTORY		equ 0001h	; directory
FILE_WRITE_DATA			equ 0002h	; file & pipe
FILE_ADD_FILE			equ 0002h	; directory
FILE_APPEND_DATA			equ 0004h	; file
FILE_ADD_SUBDIRECTORY		equ 0004h	; directory
FILE_CREATE_PIPE_INSTANCE	equ 0004h	; named pipe
FILE_READ_EA			equ 0008h	; file & directory
FILE_READ_PROPERTIES		equ FILE_READ_EA
FILE_WRITE_EA			equ 0010h	; file & directory
FILE_WRITE_PROPERTIES		equ FILE_WRITE_EA
FILE_EXECUTE			equ 0020h	; file
FILE_TRAVERSE			equ 0020h	; directory
FILE_DELETE_CHILD			equ 0040h	; directory
FILE_READ_ATTRIBUTES		equ 0080h	; all
FILE_WRITE_ATTRIBUTES		equ 0100h	; all
FILE_ALL_ACCESS	equ STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 0x1FFh
FILE_GENERIC_READ		equ STANDARD_RIGHTS_READ or FILE_READ_DATA or \
			FILE_READ_ATTRIBUTES or FILE_READ_EA or SYNCHRONIZE
FILE_GENERIC_WRITE	equ STANDARD_RIGHTS_WRITE or FILE_WRITE_DATA or \
	FILE_WRITE_ATTRIBUTES or FILE_WRITE_EA or FILE_APPEND_DATA or SYNCHRONIZE
FILE_GENERIC_EXECUTE	equ STANDARD_RIGHTS_EXECUTE or FILE_READ_ATTRIBUTES or \
			FILE_EXECUTE or SYNCHRONIZE
FILE_NOTIFY_CHANGE_FILE_NAME	equ 00000001h
FILE_NOTIFY_CHANGE_DIR_NAME	equ 00000002h
FILE_NOTIFY_CHANGE_ATTRIBUTES	equ 00000004h
FILE_NOTIFY_CHANGE_SIZE		equ 00000008h
FILE_NOTIFY_CHANGE_LAST_WRITE	equ 00000010h
FILE_NOTIFY_CHANGE_SECURITY	equ 00000100h
MAILSLOT_NO_MESSAGE		equ -1
MAILSLOT_WAIT_FOREVER		equ -1
FILE_CASE_SENSITIVE_SEARCH	equ 00000001h
FILE_CASE_PRESERVED_NAMES	equ 00000002h
FILE_UNICODE_ON_DISK		equ 00000004h
FILE_PERSISTENT_ACLS		equ 00000008h
FILE_FILE_COMPRESSION		equ 00000010h
FILE_VOLUME_IS_COMPRESSED	equ 00008000h
IO_COMPLETION_MODIFY_STATE	equ 0002h
IO_COMPLETION_ALL_ACCESS	equ STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or 03h
DUPLICATE_CLOSE_SOURCE		equ 00000001h
DUPLICATE_SAME_ACCESS		equ 00000002h
;
; File Mapping
;
FILE_MAP_COPY                        equ SECTION_QUERY
FILE_MAP_WRITE                       equ SECTION_MAP_WRITE
FILE_MAP_READ                        equ SECTION_MAP_READ
FILE_MAP_ALL_ACCESS                  equ SECTION_ALL_ACCESS
;
; For format message
;
FORMAT_MESSAGE_ALLOCATE_BUFFER       equ 100h
FORMAT_MESSAGE_IGNORE_INSERTS        equ 200h
FORMAT_MESSAGE_FROM_STRING           equ 400h
FORMAT_MESSAGE_FROM_HMODULE          equ 800h
FORMAT_MESSAGE_FROM_SYSTEM           equ 1000h
FORMAT_MESSAGE_ARGUMENT_ARRAY        equ 2000h
FORMAT_MESSAGE_MAX_WIDTH_MASK        equ 0FFh
;
; Class field offsets for GetClassLong()
;
GCL_MENUNAME	equ -8
GCL_HBRBACKGROUND	equ -10
GCL_HCURSOR		equ -12
GCL_HICON		equ -14
GCL_HMODULE		equ -16
GCL_CBWNDEXTRA	equ -18
GCL_CBCLSEXTRA	equ -20
GCL_WNDPROC		equ -24
GCL_STYLE		equ -26

GCW_ATOM		equ -32

GCL_HICONSM		equ -34	; Win 4.0

;
; Global Alloc Var
;
GMEM_FIXED                           equ 0h
GMEM_MOVEABLE                        equ 2h
GMEM_NOCOMPACT                       equ 10h
GMEM_NODISCARD                       equ 20h
GMEM_ZEROINIT                        equ 40h
GMEM_MODIFY                          equ 80h
GMEM_DISCARDABLE                     equ 100h
GMEM_NOT_BANKED                      equ 1000h
GMEM_SHARE                           equ 2000h
GMEM_DDESHARE                        equ 2000h
GMEM_NOTIFY                          equ 4000h
GMEM_LOWER                           equ GMEM_NOT_BANKED
GMEM_VALID_FLAGS                     equ 7F72h
GMEM_INVALID_HANDLE                  equ 8000h
GMEM_DISCARDED                       equ 4000h
GMEM_LOCKCOUNT                       equ 0FFh

;
; Window field offsets for GetWindowLong()
;
GWL_WNDPROC		equ -4
GWL_HINSTANCE	equ -6
GWL_HWNDPARENT	equ -8
GWL_STYLE		equ -16
GWL_EXSTYLE		equ -20
GWL_USERDATA	equ -21
GWL_ID		equ -12
;
; Mem settings
;
HEAP_NO_SERIALIZE 		equ 00000001h      
HEAP_GROWABLE 			equ 00000002h      
HEAP_GENERATE_EXCEPTIONS 	equ 00000004h      
HEAP_ZERO_MEMORY 			equ 00000008h      
HEAP_REALLOC_IN_PLACE_ONLY 	equ 00000010h      
HEAP_TAIL_CHECKING_ENABLED 	equ 00000020h      
HEAP_FREE_CHECKING_ENABLED 	equ 00000040h      
HEAP_DISABLE_COALESCE_ON_FREE equ 00000080h      
HEAP_CREATE_ALIGN_16 		equ 00010000h      
HEAP_CREATE_ENABLE_TRACING 	equ 00020000h      
HEAP_MAXIMUM_TAG 			equ 0FFFh              
HEAP_PSEUDO_TAG_FLAG 		equ 8000h              
HEAP_TAG_SHIFT 			equ 18                  
;
; Registry Values
;
HKEY_CLASSES_ROOT                    equ 80000000h
HKEY_CURRENT_USER                    equ 80000001h
HKEY_LOCAL_MACHINE                   equ 80000002h
HKEY_USERS                           equ 80000003h
HKEY_PERFORMANCE_DATA                equ 80000004h
HKEY_CURRENT_CONFIG                  equ 80000005h
HKEY_DYN_DATA                        equ 80000006h
;
; Hotkey
;
HKM_SETHOTKEY   equ WM_USER+1
HKM_GETHOTKEY   equ WM_USER+2
HKM_SETRULES    equ WM_USER+3
;
; for sendmessage to all do something
;
HWND_BROADCAST			equ 0FFFFh
HWND_TOP                             equ 0
HWND_BOTTOM                          equ 1
HWND_TOPMOST                         equ -1
HWND_NOTOPMOST                       equ -2

ICON_SMALL 				equ 0
ICON_BIG 				equ 1
;
; Stock cursors
;
IDC_ARROW		equ 32512
IDC_IBEAM		equ 32513
IDC_WAIT		equ 32514
IDC_CROSS		equ 32515
IDC_UPARROW		equ 32516
IDC_SIZE		equ 32640
IDC_ICON		equ 32641
IDC_SIZENWSE		equ 32642
IDC_SIZENWSW		equ 32643
IDC_SIZEWE		equ 32644
IDC_SIZENS		equ 32645
IDC_SIZEALL		equ 32646
IDC_NO			equ 32648
IDC_APPSTARTING		equ 32650
IDC_HELP		equ 32651

; ===================
; dialog command id's
; ===================
;
IDOK				equ	1
IDCANCEL			equ	2
IDABORT				equ	3
IDRETRY				equ	4
IDIGNORE			equ	5
IDYES				equ	6
IDNO				equ	7
IDCLOSE				equ	8
IDHELP				equ	9

;
; Stock icons
;
IDI_APPLICATION		equ 32512
IDI_HAND		equ 32513
IDI_QUESTION		equ 32514
IDI_EXCLAMATION		equ 32515
IDI_ASTERISK		equ 32516
IDI_WINLOGO		equ 32517
; new
IDI_ERROR		equ IDI_HAND
IDI_WARNING		equ IDI_EXCLAMATION
IDI_INFORMATION	equ IDI_ASTERISK

;
; Menu item (command) IDs
;
IDM_EXIT 		equ 101
IDM_HELP 		equ 901
IDM_ABOUT 		equ 902
;
; PE Hdr
;
IMAGE_DIRECTORY_ENTRY_EXPORT                equ  0
IMAGE_DIRECTORY_ENTRY_IMPORT                equ  1
IMAGE_DIRECTORY_ENTRY_RESOURCE              equ  2
IMAGE_DIRECTORY_ENTRY_EXCEPTION             equ  3
IMAGE_DIRECTORY_ENTRY_SECURITY              equ  4
IMAGE_DIRECTORY_ENTRY_BASERELOC             equ  5
IMAGE_DIRECTORY_ENTRY_DEBUG 		equ  6
IMAGE_DIRECTORY_ENTRY_COPYRIGHT             equ  7
IMAGE_DIRECTORY_ENTRY_GLOBALPTR             equ  8
IMAGE_DIRECTORY_ENTRY_TLS   		equ  9
IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG           equ 10
IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT          equ 11
IMAGE_DIRECTORY_ENTRY_IAT   		equ 12
IMAGE_NUMBEROF_DIRECTORY_ENTRIES            equ 16
IMAGE_SIZEOF_SHORT_NAME 		equ 8
;
; Image types to go with SendDlgItemMsg & BM_SETIMAGE
;
IMAGE_BITMAP                equ 0
IMAGE_ICON                  equ 1
IMAGE_CURSOR                equ 2
IMAGE_ENHMETAFILE           equ 3
;
; PE HDR Info
;
IMAGE_DOS_SIGNATURE equ 5A4Dh      
IMAGE_OS2_SIGNATURE equ 454Eh      
IMAGE_OS2_SIGNATURE_LE equ 454Ch      
IMAGE_VXD_SIGNATURE equ 454Ch      
IMAGE_NT_SIGNATURE equ 00004550h  
;
; wininet.h
;
INTERNET_INVALID_PORT_NUMBER            equ 0 
INTERNET_DEFAULT_FTP_PORT               equ 21 
INTERNET_DEFAULT_GOPHER_PORT            equ 70 
INTERNET_DEFAULT_HTTP_PORT              equ 80 
INTERNET_DEFAULT_HTTPS_PORT             equ 443 
INTERNET_DEFAULT_SOCKS_PORT             equ 1080 
INTERNET_MAX_HOST_NAME_LENGTH           equ 256
INTERNET_MAX_USER_NAME_LENGTH           equ 128
INTERNET_MAX_PASSWORD_LENGTH            equ 128
INTERNET_MAX_PORT_NUMBER_LENGTH         equ 5 
INTERNET_MAX_PORT_NUMBER_VALUE          equ 65535 
INTERNET_MAX_PATH_LENGTH                equ 2048
INTERNET_MAX_SCHEME_LENGTH              equ 32 
INTERNET_MAX_URL_LENGTH                 equ INTERNET_MAX_SCHEME_LENGTH + 3 + INTERNET_MAX_PATH_LENGTH
INTERNET_KEEP_ALIVE_UNKNOWN             equ 0ffffffffh
INTERNET_KEEP_ALIVE_ENABLED             equ 1
INTERNET_KEEP_ALIVE_DISABLED            equ 0
INTERNET_REQFLAG_FROM_CACHE             equ 1 
INTERNET_REQFLAG_ASYNC                  equ 2 
INTERNET_REQFLAG_VIA_PROXY              equ 4 
INTERNET_REQFLAG_NO_HEADERS             equ 8 
INTERNET_REQFLAG_PASSIVE                equ 10h 
INTERNET_REQFLAG_CACHE_WRITE_DISABLED   equ 40h 
INTERNET_FLAG_RELOAD                    equ 80000000h 
INTERNET_FLAG_RAW_DATA                  equ 40000000h 
INTERNET_FLAG_EXISTING_CONNECT          equ 20000000h 
INTERNET_FLAG_ASYNC                     equ 10000000h 
INTERNET_FLAG_PASSIVE                   equ 8000000h 
INTERNET_FLAG_NO_CACHE_WRITE            equ 4000000h 
INTERNET_FLAG_DONT_CACHE equ INTERNET_FLAG_NO_CACHE_WRITE
INTERNET_FLAG_MAKE_PERSISTENT           equ 2000000h 
INTERNET_FLAG_FROM_CACHE                equ 1000000h 
INTERNET_FLAG_OFFLINE                   equ INTERNET_FLAG_FROM_CACHE
INTERNET_FLAG_SECURE                    equ 800000h 
INTERNET_FLAG_KEEP_CONNECTION           equ 400000h 
INTERNET_FLAG_NO_AUTO_REDIRECT          equ 200000h 
INTERNET_FLAG_READ_PREFETCH             equ 100000h 
INTERNET_FLAG_NO_COOKIES                equ 80000h 
INTERNET_FLAG_NO_AUTH                   equ 40000h 
INTERNET_FLAG_CACHE_IF_NET_FAIL         equ 10000h 
INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP   equ 8000h 
INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS  equ 4000h 
INTERNET_FLAG_IGNORE_CERT_DATE_INVALID  equ 2000h 
INTERNET_FLAG_IGNORE_CERT_CN_INVALID    equ 1000h 
INTERNET_FLAG_RESYNCHRONIZE             equ 800h 
INTERNET_FLAG_HYPERLINK                 equ 400h 
INTERNET_FLAG_NO_UI                     equ 200h 
INTERNET_FLAG_PRAGMA_NOCACHE            equ 100h 
INTERNET_FLAG_CACHE_ASYNC               equ 80h 
INTERNET_FLAG_FORMS_SUBMIT              equ 40h 
INTERNET_FLAG_NEED_FILE                 equ 10h 
INTERNET_FLAG_MUST_CACHE_REQUEST    equ INTERNET_FLAG_NEED_FILE
INTERNET_FLAG_TRANSFER_ASCII        equ FTP_TRANSFER_TYPE_ASCII 
INTERNET_FLAG_TRANSFER_BINARY       equ FTP_TRANSFER_TYPE_BINARY 
SECURITY_INTERNET_MASK              equ INTERNET_FLAG_IGNORE_CERT_CN_INVALID + INTERNET_FLAG_IGNORE_CERT_DATE_INVALID + INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS + INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP 
INTERNET_ERROR_MASK_INSERT_CDROM    equ 1
;INTERNET_OPTIONS_MASK               equ not INTERNET_FLAGS_MASK
WININET_API_FLAG_ASYNC equ 1 
WININET_API_FLAG_SYNC equ 4 
WININET_API_FLAG_USE_CONTEXT    equ 8 
INTERNET_NO_CALLBACK            equ 0
INTERNET_RFC1123_FORMAT         equ 0
INTERNET_RFC1123_BUFSIZE        equ 30
ICU_ESCAPE      equ 80000000h 
ICU_USERNAME    equ 40000000h 
ICU_NO_ENCODE   equ 20000000h 
ICU_DECODE      equ 10000000h 
ICU_NO_META     equ 8000000h 
ICU_ENCODE_SPACES_ONLY      equ 4000000h 
ICU_BROWSER_MODE            equ 2000000h 
INTERNET_OPEN_TYPE_PRECONFIG equ 0 
INTERNET_OPEN_TYPE_DIRECT   equ 1 
INTERNET_OPEN_TYPE_PROXY    equ 3 
INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY equ 4 
PRE_CONFIG_INTERNET_ACCESS  equ INTERNET_OPEN_TYPE_PRECONFIG
LOCAL_INTERNET_ACCESS       equ INTERNET_OPEN_TYPE_DIRECT
CERN_PROXY_INTERNET_ACCESS  equ INTERNET_OPEN_TYPE_PROXY
INTERNET_SERVICE_URL    equ 0
INTERNET_SERVICE_FTP    equ 1
INTERNET_SERVICE_GOPHER equ 2
INTERNET_SERVICE_HTTP   equ 3
IRF_ASYNC               equ WININET_API_FLAG_ASYNC
IRF_SYNC                equ WININET_API_FLAG_SYNC
IRF_USE_CONTEXT         equ WININET_API_FLAG_USE_CONTEXT
IRF_NO_WAIT             equ 8
ISO_GLOBAL              equ 1 
ISO_REGISTRY            equ 2 
ISO_VALID_FLAGS                         equ (ISO_GLOBAL + ISO_REGISTRY)
INTERNET_OPTION_CALLBACK                equ 1
INTERNET_OPTION_CONNECT_TIMEOUT         equ 2
INTERNET_OPTION_CONNECT_RETRIES         equ 3
INTERNET_OPTION_CONNECT_BACKOFF         equ 4
INTERNET_OPTION_SEND_TIMEOUT            equ 5
INTERNET_OPTION_CONTROL_SEND_TIMEOUT    equ INTERNET_OPTION_SEND_TIMEOUT
INTERNET_OPTION_RECEIVE_TIMEOUT         equ 6
INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT equ INTERNET_OPTION_RECEIVE_TIMEOUT
INTERNET_OPTION_DATA_SEND_TIMEOUT       equ 7
INTERNET_OPTION_DATA_RECEIVE_TIMEOUT    equ 8
INTERNET_OPTION_HANDLE_TYPE             equ 9
INTERNET_OPTION_LISTEN_TIMEOUT          equ 11
INTERNET_OPTION_READ_BUFFER_SIZE        equ 12
INTERNET_OPTION_WRITE_BUFFER_SIZE       equ 13
INTERNET_OPTION_ASYNC_ID                equ 15
INTERNET_OPTION_ASYNC_PRIORITY          equ 16
INTERNET_OPTION_PARENT_HANDLE           equ 21
INTERNET_OPTION_KEEP_CONNECTION         equ 22
INTERNET_OPTION_REQUEST_FLAGS           equ 23
INTERNET_OPTION_EXTENDED_ERROR          equ 24
INTERNET_OPTION_OFFLINE_MODE            equ 26
INTERNET_OPTION_CACHE_STREAM_HANDLE     equ 27
INTERNET_OPTION_USERNAME                equ 28
INTERNET_OPTION_PASSWORD                equ 29
INTERNET_OPTION_ASYNC                   equ 30
INTERNET_OPTION_SECURITY_FLAGS          equ 31
INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT equ 32
INTERNET_OPTION_DATAFILE_NAME           equ 33
INTERNET_OPTION_URL                     equ 34
INTERNET_OPTION_SECURITY_CERTIFICATE    equ 35
INTERNET_OPTION_SECURITY_KEY_BITNESS    equ 36
INTERNET_OPTION_REFRESH                 equ 37
INTERNET_OPTION_PROXY                   equ 38
INTERNET_OPTION_SETTINGS_CHANGED        equ 39
INTERNET_OPTION_VERSION                 equ 40
INTERNET_OPTION_USER_AGENT              equ 41
INTERNET_OPTION_END_BROWSER_SESSION     equ 42
INTERNET_OPTION_PROXY_USERNAME          equ 43
INTERNET_OPTION_PROXY_PASSWORD          equ 44
INTERNET_OPTION_CONTEXT_VALUE           equ 45
INTERNET_OPTION_CONNECT_LIMIT           equ 46
INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT equ 47
INTERNET_OPTION_POLICY                  equ 48
INTERNET_OPTION_DISCONNECTED_TIMEOUT    equ 49
INTERNET_OPTION_CONNECTED_STATE         equ 50
INTERNET_OPTION_IDLE_STATE              equ 51
INTERNET_OPTION_OFFLINE_SEMANTICS       equ 52
INTERNET_OPTION_SECONDARY_CACHE_KEY     equ 53
INTERNET_OPTION_CALLBACK_FILTER         equ 54
INTERNET_OPTION_CONNECT_TIME            equ 55
INTERNET_OPTION_SEND_THROUGHPUT         equ 56
INTERNET_OPTION_RECEIVE_THROUGHPUT      equ 57
INTERNET_OPTION_REQUEST_PRIORITY        equ 58
INTERNET_OPTION_HTTP_VERSION            equ 59
INTERNET_OPTION_RESET_URLCACHE_SESSION  equ 60
INTERNET_OPTION_ERROR_MASK              equ 62
INTERNET_FIRST_OPTION                   equ INTERNET_OPTION_CALLBACK
INTERNET_LAST_OPTION                    equ INTERNET_OPTION_ERROR_MASK
INTERNET_PRIORITY_FOREGROUND            equ 1000
INTERNET_HANDLE_TYPE_INTERNET           equ 1
INTERNET_HANDLE_TYPE_CONNECT_FTP        equ 2
INTERNET_HANDLE_TYPE_CONNECT_GOPHER     equ 3
INTERNET_HANDLE_TYPE_CONNECT_HTTP       equ 4
INTERNET_HANDLE_TYPE_FTP_FIND           equ 5
INTERNET_HANDLE_TYPE_FTP_FIND_HTML      equ 6
INTERNET_HANDLE_TYPE_FTP_FILE           equ 7
INTERNET_HANDLE_TYPE_FTP_FILE_HTML      equ 8
INTERNET_HANDLE_TYPE_GOPHER_FIND        equ 9
INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML   equ 10
INTERNET_HANDLE_TYPE_GOPHER_FILE        equ 11
INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML   equ 12
INTERNET_HANDLE_TYPE_HTTP_REQUEST       equ 13
SECURITY_FLAG_SECURE            equ 1 
SECURITY_FLAG_STRENGTH_WEAK     equ 10000000h
SECURITY_FLAG_STRENGTH_MEDIUM   equ 40000000h
SECURITY_FLAG_STRENGTH_STRONG   equ 20000000h
SECURITY_FLAG_UNKNOWNBIT        equ 80000000h
SECURITY_FLAG_NORMALBITNESS     equ SECURITY_FLAG_STRENGTH_WEAK
SECURITY_FLAG_SSL       equ 2
SECURITY_FLAG_SSL3      equ 4
SECURITY_FLAG_PCT       equ 8
SECURITY_FLAG_PCT4      equ 10h
SECURITY_FLAG_IETFSSL4  equ 20h
SECURITY_FLAG_40BIT     equ SECURITY_FLAG_STRENGTH_WEAK
SECURITY_FLAG_128BIT    equ SECURITY_FLAG_STRENGTH_STRONG
SECURITY_FLAG_56BIT     equ SECURITY_FLAG_STRENGTH_MEDIUM
SECURITY_FLAG_IGNORE_REVOCATION         equ 80h
SECURITY_FLAG_IGNORE_UNKNOWN_CA         equ 100h
SECURITY_FLAG_IGNORE_WRONG_USAGE        equ 200h
SECURITY_FLAG_IGNORE_CERT_CN_INVALID    equ INTERNET_FLAG_IGNORE_CERT_CN_INVALID
SECURITY_FLAG_IGNORE_CERT_DATE_INVALID  equ INTERNET_FLAG_IGNORE_CERT_DATE_INVALID
SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS  equ INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS
SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP   equ INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP
SECURITY_SET_MASK equ (SECURITY_FLAG_IGNORE_REVOCATION +\
    SECURITY_FLAG_IGNORE_UNKNOWN_CA +\
    SECURITY_FLAG_IGNORE_CERT_CN_INVALID +\
    SECURITY_FLAG_IGNORE_CERT_DATE_INVALID +\
    SECURITY_FLAG_IGNORE_WRONG_USAGE)

INTERNET_STATUS_RESOLVING_NAME          equ 10
INTERNET_STATUS_NAME_RESOLVED           equ 11
INTERNET_STATUS_CONNECTING_TO_SERVER    equ 20
INTERNET_STATUS_CONNECTED_TO_SERVER     equ 21
INTERNET_STATUS_SENDING_REQUEST         equ 30
INTERNET_STATUS_REQUEST_SENT            equ 31
INTERNET_STATUS_RECEIVING_RESPONSE      equ 40
INTERNET_STATUS_RESPONSE_RECEIVED       equ 41
INTERNET_STATUS_CTL_RESPONSE_RECEIVED   equ 42
INTERNET_STATUS_PREFETCH                equ 43
INTERNET_STATUS_CLOSING_CONNECTION      equ 50
INTERNET_STATUS_CONNECTION_CLOSED       equ 51
INTERNET_STATUS_HANDLE_CREATED          equ 60
INTERNET_STATUS_HANDLE_CLOSING          equ 70
INTERNET_STATUS_REQUEST_COMPLETE        equ 100
INTERNET_STATUS_REDIRECT                equ 110
INTERNET_STATUS_INTERMEDIATE_RESPONSE   equ 120
INTERNET_STATUS_STATE_CHANGE            equ 200
INTERNET_STATE_CONNECTED                equ 1 
INTERNET_STATE_DISCONNECTED             equ 2 
INTERNET_STATE_DISCONNECTED_BY_USER     equ 10h 
INTERNET_STATE_IDLE                     equ 100h 
INTERNET_STATE_BUSY                     equ 200h 
INTERNET_INVALID_STATUS_CALLBACK equ 0ffffffffh
FTP_TRANSFER_TYPE_UNKNOWN       equ 0
FTP_TRANSFER_TYPE_ASCII         equ 1
FTP_TRANSFER_TYPE_BINARY        equ 2
FTP_TRANSFER_TYPE_MASK          equ (FTP_TRANSFER_TYPE_ASCII + FTP_TRANSFER_TYPE_BINARY)
MAX_GOPHER_DISPLAY_TEXT         equ 128
MAX_GOPHER_SELECTOR_TEXT        equ 256
MAX_GOPHER_HOST_NAME            equ INTERNET_MAX_HOST_NAME_LENGTH
MAX_GOPHER_LOCATOR_LENGTH       equ 1+ MAX_GOPHER_DISPLAY_TEXT+ 1 + MAX_GOPHER_SELECTOR_TEXT+ 1+ MAX_GOPHER_HOST_NAME+ 1+ INTERNET_MAX_PORT_NUMBER_LENGTH+ 1+ 1+ 2
GOPHER_TYPE_TEXT_FILE           equ 1
GOPHER_TYPE_DIRECTORY           equ 2
GOPHER_TYPE_CSO                 equ 4
GOPHER_TYPE_ERROR               equ 8
GOPHER_TYPE_MAC_BINHEX          equ 10h
GOPHER_TYPE_DOS_ARCHIVE         equ 20h
GOPHER_TYPE_UNIX_UUENCODED      equ 40h
GOPHER_TYPE_INDEX_SERVER        equ 80h
GOPHER_TYPE_TELNET              equ 100h
GOPHER_TYPE_BINARY              equ 200h
GOPHER_TYPE_REDUNDANT           equ 400h
GOPHER_TYPE_TN3270              equ 800h
GOPHER_TYPE_GIF                 equ 1000h
GOPHER_TYPE_IMAGE               equ 2000h
GOPHER_TYPE_BITMAP              equ 4000h
GOPHER_TYPE_MOVIE               equ 8000h
GOPHER_TYPE_SOUND               equ 10000h
GOPHER_TYPE_HTML                equ 20000h
GOPHER_TYPE_PDF                 equ 40000h
GOPHER_TYPE_CALENDAR            equ 80000h
GOPHER_TYPE_INLINE              equ 100000h
GOPHER_TYPE_UNKNOWN             equ 20000000h
GOPHER_TYPE_ASK                 equ 40000000h
GOPHER_TYPE_GOPHER_PLUS         equ 80000000h
GOPHER_TEMP                     equ GOPHER_TYPE_TEXT_FILE+GOPHER_TYPE_MAC_BINHEX+GOPHER_TYPE_DOS_ARCHIVE+GOPHER_TYPE_UNIX_UUENCODED+GOPHER_TYPE_BINARY
GOPHER_TYPE_FILE_MASK           equ GOPHER_TEMP+ GOPHER_TYPE_GIF+ GOPHER_TYPE_IMAGE+ GOPHER_TYPE_BITMAP+GOPHER_TYPE_MOVIE+GOPHER_TYPE_SOUND+ GOPHER_TYPE_HTML+GOPHER_TYPE_PDF+GOPHER_TYPE_CALENDAR+GOPHER_TYPE_INLINE
MAX_GOPHER_CATEGORY_NAME        equ 128 
MAX_GOPHER_ATTRIBUTE_NAME       equ 128 
MIN_GOPHER_ATTRIBUTE_LENGTH     equ 256 
GOPHER_INFO_CATEGORY            equ "+INFO"
GOPHER_ADMIN_CATEGORY           equ "+ADMIN"
GOPHER_VIEWS_CATEGORY           equ "+VIEWS"
GOPHER_ABSTRACT_CATEGORY        equ "+ABSTRACT"
GOPHER_VERONICA_CATEGORY        equ "+VERONICA"
GOPHER_ADMIN_ATTRIBUTE          equ "Admin"
GOPHER_MOD_DATE_ATTRIBUTE       equ "Mod-Date"
GOPHER_TTL_ATTRIBUTE            equ "TTL"
GOPHER_SCORE_ATTRIBUTE          equ "Score"
GOPHER_RANGE_ATTRIBUTE          equ "Score-range"
GOPHER_SITE_ATTRIBUTE           equ "Site"
GOPHER_ORG_ATTRIBUTE            equ "Org"
GOPHER_LOCATION_ATTRIBUTE       equ "Loc"
GOPHER_GEOG_ATTRIBUTE           equ "Geog"
GOPHER_TIMEZONE_ATTRIBUTE       equ "TZ"
GOPHER_PROVIDER_ATTRIBUTE       equ "Provider"
GOPHER_VERSION_ATTRIBUTE        equ "Version"
GOPHER_ABSTRACT_ATTRIBUTE       equ "Abstract"
GOPHER_VIEW_ATTRIBUTE           equ "View"
GOPHER_TREEWALK_ATTRIBUTE       equ "treewalk"
GOPHER_ATTRIBUTE_ID_BASE        equ 0abcccc00h
GOPHER_CATEGORY_ID_ALL          equ (GOPHER_ATTRIBUTE_ID_BASE + 1)
GOPHER_CATEGORY_ID_INFO         equ (GOPHER_ATTRIBUTE_ID_BASE + 2)
GOPHER_CATEGORY_ID_ADMIN        equ (GOPHER_ATTRIBUTE_ID_BASE + 3)
GOPHER_CATEGORY_ID_VIEWS        equ (GOPHER_ATTRIBUTE_ID_BASE + 4)
GOPHER_CATEGORY_ID_ABSTRACT     equ (GOPHER_ATTRIBUTE_ID_BASE + 5)
GOPHER_CATEGORY_ID_VERONICA     equ (GOPHER_ATTRIBUTE_ID_BASE + 6)
GOPHER_CATEGORY_ID_ASK          equ (GOPHER_ATTRIBUTE_ID_BASE + 7)
GOPHER_CATEGORY_ID_UNKNOWN      equ (GOPHER_ATTRIBUTE_ID_BASE + 8)
GOPHER_ATTRIBUTE_ID_ALL         equ (GOPHER_ATTRIBUTE_ID_BASE + 9)
GOPHER_ATTRIBUTE_ID_ADMIN       equ (GOPHER_ATTRIBUTE_ID_BASE + 10)
GOPHER_ATTRIBUTE_ID_MOD_DATE    equ (GOPHER_ATTRIBUTE_ID_BASE + 11)
GOPHER_ATTRIBUTE_ID_TTL         equ (GOPHER_ATTRIBUTE_ID_BASE + 12)
GOPHER_ATTRIBUTE_ID_SCORE       equ (GOPHER_ATTRIBUTE_ID_BASE + 13)
GOPHER_ATTRIBUTE_ID_RANGE       equ (GOPHER_ATTRIBUTE_ID_BASE + 14)
GOPHER_ATTRIBUTE_ID_SITE        equ (GOPHER_ATTRIBUTE_ID_BASE + 15)
GOPHER_ATTRIBUTE_ID_ORG         equ (GOPHER_ATTRIBUTE_ID_BASE + 16)
GOPHER_ATTRIBUTE_ID_LOCATION    equ (GOPHER_ATTRIBUTE_ID_BASE + 17)
GOPHER_ATTRIBUTE_ID_GEOG        equ (GOPHER_ATTRIBUTE_ID_BASE + 18)
GOPHER_ATTRIBUTE_ID_TIMEZONE    equ (GOPHER_ATTRIBUTE_ID_BASE + 19)
GOPHER_ATTRIBUTE_ID_PROVIDER    equ (GOPHER_ATTRIBUTE_ID_BASE + 20)
GOPHER_ATTRIBUTE_ID_VERSION     equ (GOPHER_ATTRIBUTE_ID_BASE + 21)
GOPHER_ATTRIBUTE_ID_ABSTRACT    equ (GOPHER_ATTRIBUTE_ID_BASE + 22)
GOPHER_ATTRIBUTE_ID_VIEW        equ (GOPHER_ATTRIBUTE_ID_BASE + 23)
GOPHER_ATTRIBUTE_ID_TREEWALK    equ (GOPHER_ATTRIBUTE_ID_BASE + 24)
GOPHER_ATTRIBUTE_ID_UNKNOWN     equ (GOPHER_ATTRIBUTE_ID_BASE + 25)
HTTP_MAJOR_VERSION              equ 1
HTTP_MINOR_VERSION              equ 0
HTTP_VERSION                    equ "HTTP/1.0"
HTTP_QUERY_MIME_VERSION         equ 0
HTTP_QUERY_CONTENT_TYPE         equ 1
HTTP_QUERY_CONTENT_TRANSFER_ENCODING equ 2
HTTP_QUERY_CONTENT_ID           equ 3
HTTP_QUERY_CONTENT_DESCRIPTION  equ 4
HTTP_QUERY_CONTENT_LENGTH       equ 5
HTTP_QUERY_CONTENT_LANGUAGE     equ 6
HTTP_QUERY_ALLOW                equ 7
HTTP_QUERY_PUBLIC               equ 8
HTTP_QUERY_DATE                 equ 9
HTTP_QUERY_EXPIRES              equ 10
HTTP_QUERY_LAST_MODIFIED        equ 11
HTTP_QUERY_MESSAGE_ID           equ 12
HTTP_QUERY_URI                  equ 13
HTTP_QUERY_DERIVED_FROM         equ 14
HTTP_QUERY_COST                 equ 15
HTTP_QUERY_LINK                 equ 16
HTTP_QUERY_PRAGMA               equ 17
HTTP_QUERY_VERSION              equ 18 
HTTP_QUERY_STATUS_CODE          equ 19 
HTTP_QUERY_STATUS_TEXT          equ 20 
HTTP_QUERY_RAW_HEADERS          equ 21 
HTTP_QUERY_RAW_HEADERS_CRLF     equ 22 
HTTP_QUERY_CONNECTION           equ 23
HTTP_QUERY_ACCEPT               equ 24
HTTP_QUERY_ACCEPT_CHARSET       equ 25
HTTP_QUERY_ACCEPT_ENCODING      equ 26
HTTP_QUERY_ACCEPT_LANGUAGE      equ 27
HTTP_QUERY_AUTHORIZATION        equ 28
HTTP_QUERY_CONTENT_ENCODING     equ 29
HTTP_QUERY_FORWARDED            equ 30
HTTP_QUERY_FROM                 equ 31
HTTP_QUERY_IF_MODIFIED_SINCE    equ 32
HTTP_QUERY_LOCATION             equ 33
HTTP_QUERY_ORIG_URI             equ 34
HTTP_QUERY_REFERER              equ 35
HTTP_QUERY_RETRY_AFTER          equ 36
HTTP_QUERY_SERVER               equ 37
HTTP_QUERY_TITLE                equ 38
HTTP_QUERY_USER_AGENT           equ 39
HTTP_QUERY_WWW_AUTHENTICATE     equ 40
HTTP_QUERY_PROXY_AUTHENTICATE   equ 41
HTTP_QUERY_ACCEPT_RANGES        equ 42
HTTP_QUERY_SET_COOKIE           equ 43
HTTP_QUERY_COOKIE               equ 44
HTTP_QUERY_REQUEST_METHOD       equ 45 
HTTP_QUERY_REFRESH              equ 46
HTTP_QUERY_CONTENT_DISPOSITION  equ 47
HTTP_QUERY_AGE                  equ 48
HTTP_QUERY_CACHE_CONTROL    equ 49
HTTP_QUERY_CONTENT_BASE     equ 50
HTTP_QUERY_CONTENT_LOCATION equ 51
HTTP_QUERY_CONTENT_MD5      equ 52
HTTP_QUERY_CONTENT_RANGE    equ 53
HTTP_QUERY_ETAG             equ 54
HTTP_QUERY_HOST             equ 55
HTTP_QUERY_IF_MATCH         equ 56
HTTP_QUERY_IF_NONE_MATCH    equ 57
HTTP_QUERY_IF_RANGE         equ 58
HTTP_QUERY_IF_UNMODIFIED_SINCE equ 59
HTTP_QUERY_MAX_FORWARDS     equ 60
HTTP_QUERY_PROXY_AUTHORIZATION equ 61
HTTP_QUERY_RANGE            equ 62
HTTP_QUERY_TRANSFER_ENCODING equ 63
HTTP_QUERY_UPGRADE          equ 64
HTTP_QUERY_VARY             equ 65
HTTP_QUERY_VIA              equ 66
HTTP_QUERY_WARNING          equ 67
HTTP_QUERY_MAX              equ 67
HTTP_QUERY_CUSTOM           equ 65535
HTTP_QUERY_FLAG_REQUEST_HEADERS equ 80000000h
HTTP_QUERY_FLAG_SYSTEMTIME  equ 40000000h
HTTP_QUERY_FLAG_NUMBER      equ 20000000h
HTTP_QUERY_FLAG_COALESCE    equ 10000000h
HTTP_QUERY_MODIFIER_FLAGS_MASK equ (HTTP_QUERY_FLAG_REQUEST_HEADERS \
 + HTTP_QUERY_FLAG_SYSTEMTIME \
 + HTTP_QUERY_FLAG_NUMBER \
 + HTTP_QUERY_FLAG_COALESCE \
 )
HTTP_QUERY_HEADER_MASK      equ not HTTP_QUERY_MODIFIER_FLAGS_MASK
HTTP_STATUS_CONTINUE        equ 100 
HTTP_STATUS_SWITCH_PROTOCOLS equ 101 
HTTP_STATUS_OK              equ 200 
HTTP_STATUS_CREATED         equ 201 
HTTP_STATUS_ACCEPTED        equ 202 
HTTP_STATUS_PARTIAL         equ 203 
HTTP_STATUS_NO_CONTENT      equ 204 
HTTP_STATUS_RESET_CONTENT   equ 205 
HTTP_STATUS_PARTIAL_CONTENT equ 206 
HTTP_STATUS_AMBIGUOUS       equ 300 
HTTP_STATUS_MOVED           equ 301 
HTTP_STATUS_REDIRECT        equ 302 
HTTP_STATUS_REDIRECT_METHOD equ 303 
HTTP_STATUS_NOT_MODIFIED    equ 304 
HTTP_STATUS_USE_PROXY       equ 305 
HTTP_STATUS_REDIRECT_KEEP_VERB equ 307 
HTTP_STATUS_BAD_REQUEST     equ 400 
HTTP_STATUS_DENIED          equ 401 
HTTP_STATUS_PAYMENT_REQ     equ 402 
HTTP_STATUS_FORBIDDEN       equ 403 
HTTP_STATUS_NOT_FOUND       equ 404 
HTTP_STATUS_BAD_METHOD      equ 405 
HTTP_STATUS_NONE_ACCEPTABLE equ 406 
HTTP_STATUS_PROXY_AUTH_REQ  equ 407 
HTTP_STATUS_REQUEST_TIMEOUT equ 408 
HTTP_STATUS_CONFLICT        equ 409 
HTTP_STATUS_GONE            equ 410 
HTTP_STATUS_LENGTH_REQUIRED equ 411 
HTTP_STATUS_PRECOND_FAILED  equ 412 
HTTP_STATUS_REQUEST_TOO_LARGE equ 413 
HTTP_STATUS_URI_TOO_LONG    equ 414 
HTTP_STATUS_UNSUPPORTED_MEDIA equ 415 
HTTP_STATUS_SERVER_ERROR    equ 500 
HTTP_STATUS_NOT_SUPPORTED   equ 501 
HTTP_STATUS_BAD_GATEWAY     equ 502 
HTTP_STATUS_SERVICE_UNAVAIL equ 503 
HTTP_STATUS_GATEWAY_TIMEOUT equ 504 
HTTP_STATUS_VERSION_NOT_SUP equ 505 
HTTP_STATUS_FIRST           equ HTTP_STATUS_CONTINUE
HTTP_STATUS_LAST            equ HTTP_STATUS_VERSION_NOT_SUP
HTTP_ADDREQ_INDEX_MASK      equ 0FFFFh
HTTP_ADDREQ_FLAGS_MASK      equ 0FFFF0000h
HTTP_ADDREQ_FLAG_ADD_IF_NEW equ 10000000h
HTTP_ADDREQ_FLAG_ADD        equ 20000000h
HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA equ 40000000h
HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON equ 1000000h
HTTP_ADDREQ_FLAG_COALESCE   equ HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA
HTTP_ADDREQ_FLAG_REPLACE    equ 80000000h
HSR_ASYNC       equ WININET_API_FLAG_ASYNC 
HSR_SYNC        equ WININET_API_FLAG_SYNC 
HSR_USE_CONTEXT equ WININET_API_FLAG_USE_CONTEXT 
HSR_INITIATE    equ 8 
HSR_DOWNLOAD    equ 10h 
HSR_CHUNKED     equ 20h 
FLAGS_ERROR_UI_FILTER_FOR_ERRORS            equ 1
FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS         equ 2
FLAGS_ERROR_UI_FLAGS_GENERATE_DATA          equ 4
FLAGS_ERROR_UI_FLAGS_NO_UI                  equ 8
FLAGS_ERROR_UI_SERIALIZE_DIALOGS            equ 10h
INTERNET_ERROR_BASE                         equ 12000
ERROR_INTERNET_OUT_OF_HANDLES               equ (INTERNET_ERROR_BASE + 1)
ERROR_INTERNET_TIMEOUT                      equ (INTERNET_ERROR_BASE + 2)
ERROR_INTERNET_EXTENDED_ERROR               equ (INTERNET_ERROR_BASE + 3)
ERROR_INTERNET_INTERNAL_ERROR               equ (INTERNET_ERROR_BASE + 4)
ERROR_INTERNET_INVALID_URL                  equ (INTERNET_ERROR_BASE + 5)
ERROR_INTERNET_UNRECOGNIZED_SCHEME          equ (INTERNET_ERROR_BASE + 6)
ERROR_INTERNET_NAME_NOT_RESOLVED            equ (INTERNET_ERROR_BASE + 7)
ERROR_INTERNET_PROTOCOL_NOT_FOUND           equ (INTERNET_ERROR_BASE + 8)
ERROR_INTERNET_INVALID_OPTION               equ (INTERNET_ERROR_BASE + 9)
ERROR_INTERNET_BAD_OPTION_LENGTH            equ (INTERNET_ERROR_BASE + 10)
ERROR_INTERNET_OPTION_NOT_SETTABLE          equ (INTERNET_ERROR_BASE + 11)
ERROR_INTERNET_SHUTDOWN                     equ (INTERNET_ERROR_BASE + 12)
ERROR_INTERNET_INCORRECT_USER_NAME          equ (INTERNET_ERROR_BASE + 13)
ERROR_INTERNET_INCORRECT_PASSWORD           equ (INTERNET_ERROR_BASE + 14)
ERROR_INTERNET_LOGIN_FAILURE                equ (INTERNET_ERROR_BASE + 15)
ERROR_INTERNET_INVALID_OPERATION            equ (INTERNET_ERROR_BASE + 16)
ERROR_INTERNET_OPERATION_CANCELLED          equ (INTERNET_ERROR_BASE + 17)
ERROR_INTERNET_INCORRECT_HANDLE_TYPE        equ (INTERNET_ERROR_BASE + 18)
ERROR_INTERNET_INCORRECT_HANDLE_STATE       equ (INTERNET_ERROR_BASE + 19)
ERROR_INTERNET_NOT_PROXY_REQUEST            equ (INTERNET_ERROR_BASE + 20)
ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND     equ (INTERNET_ERROR_BASE + 21)
ERROR_INTERNET_BAD_REGISTRY_PARAMETER       equ (INTERNET_ERROR_BASE + 22)
ERROR_INTERNET_NO_DIRECT_ACCESS             equ (INTERNET_ERROR_BASE + 23)
ERROR_INTERNET_NO_CONTEXT                   equ (INTERNET_ERROR_BASE + 24)
ERROR_INTERNET_NO_CALLBACK                  equ (INTERNET_ERROR_BASE + 25)
ERROR_INTERNET_REQUEST_PENDING              equ (INTERNET_ERROR_BASE + 26)
ERROR_INTERNET_INCORRECT_FORMAT             equ (INTERNET_ERROR_BASE + 27)
ERROR_INTERNET_ITEM_NOT_FOUND               equ (INTERNET_ERROR_BASE + 28)
ERROR_INTERNET_CANNOT_CONNECT               equ (INTERNET_ERROR_BASE + 29)
ERROR_INTERNET_CONNECTION_ABORTED           equ (INTERNET_ERROR_BASE + 30)
ERROR_INTERNET_CONNECTION_RESET             equ (INTERNET_ERROR_BASE + 31)
ERROR_INTERNET_FORCE_RETRY                  equ (INTERNET_ERROR_BASE + 32)
ERROR_INTERNET_INVALID_PROXY_REQUEST        equ (INTERNET_ERROR_BASE + 33)
ERROR_INTERNET_NEED_UI                      equ (INTERNET_ERROR_BASE + 34)
ERROR_INTERNET_HANDLE_EXISTS                equ (INTERNET_ERROR_BASE + 36)
ERROR_INTERNET_SEC_CERT_DATE_INVALID        equ (INTERNET_ERROR_BASE + 37)
ERROR_INTERNET_SEC_CERT_CN_INVALID          equ (INTERNET_ERROR_BASE + 38)
ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR       equ (INTERNET_ERROR_BASE + 39)
ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR       equ (INTERNET_ERROR_BASE + 40)
ERROR_INTERNET_MIXED_SECURITY               equ (INTERNET_ERROR_BASE + 41)
ERROR_INTERNET_CHG_POST_IS_NON_SECURE       equ (INTERNET_ERROR_BASE + 42)
ERROR_INTERNET_POST_IS_NON_SECURE           equ (INTERNET_ERROR_BASE + 43)
ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED      equ (INTERNET_ERROR_BASE + 44)
ERROR_INTERNET_INVALID_CA                   equ (INTERNET_ERROR_BASE + 45)
ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP        equ (INTERNET_ERROR_BASE + 46)
ERROR_INTERNET_ASYNC_THREAD_FAILED          equ (INTERNET_ERROR_BASE + 47)
ERROR_INTERNET_REDIRECT_SCHEME_CHANGE       equ (INTERNET_ERROR_BASE + 48)
ERROR_INTERNET_DIALOG_PENDING               equ (INTERNET_ERROR_BASE + 49)
ERROR_INTERNET_RETRY_DIALOG                 equ (INTERNET_ERROR_BASE + 50)
ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR      equ (INTERNET_ERROR_BASE + 52)
ERROR_INTERNET_INSERT_CDROM                 equ (INTERNET_ERROR_BASE + 53)
ERROR_FTP_TRANSFER_IN_PROGRESS              equ (INTERNET_ERROR_BASE + 110)
ERROR_FTP_DROPPED                           equ (INTERNET_ERROR_BASE + 111)
ERROR_FTP_NO_PASSIVE_MODE                   equ (INTERNET_ERROR_BASE + 112)
ERROR_GOPHER_PROTOCOL_ERROR                 equ (INTERNET_ERROR_BASE + 130)
ERROR_GOPHER_NOT_FILE                       equ (INTERNET_ERROR_BASE + 131)
ERROR_GOPHER_DATA_ERROR                     equ (INTERNET_ERROR_BASE + 132)
ERROR_GOPHER_END_OF_DATA                    equ (INTERNET_ERROR_BASE + 133)
ERROR_GOPHER_INVALID_LOCATOR                equ (INTERNET_ERROR_BASE + 134)
ERROR_GOPHER_INCORRECT_LOCATOR_TYPE         equ (INTERNET_ERROR_BASE + 135)
ERROR_GOPHER_NOT_GOPHER_PLUS                equ (INTERNET_ERROR_BASE + 136)
ERROR_GOPHER_ATTRIBUTE_NOT_FOUND            equ (INTERNET_ERROR_BASE + 137)
ERROR_GOPHER_UNKNOWN_LOCATOR                equ (INTERNET_ERROR_BASE + 138)
ERROR_HTTP_HEADER_NOT_FOUND                 equ (INTERNET_ERROR_BASE + 150)
ERROR_HTTP_DOWNLEVEL_SERVER                 equ (INTERNET_ERROR_BASE + 151)
ERROR_HTTP_INVALID_SERVER_RESPONSE          equ (INTERNET_ERROR_BASE + 152)
ERROR_HTTP_INVALID_HEADER                   equ (INTERNET_ERROR_BASE + 153)
ERROR_HTTP_INVALID_QUERY_REQUEST            equ (INTERNET_ERROR_BASE + 154)
ERROR_HTTP_HEADER_ALREADY_EXISTS            equ (INTERNET_ERROR_BASE + 155)
ERROR_HTTP_REDIRECT_FAILED                  equ (INTERNET_ERROR_BASE + 156)
ERROR_HTTP_NOT_REDIRECTED                   equ (INTERNET_ERROR_BASE + 160)
ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION        equ (INTERNET_ERROR_BASE + 161)
ERROR_HTTP_COOKIE_DECLINED                  equ (INTERNET_ERROR_BASE + 162)
ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION      equ (INTERNET_ERROR_BASE + 168)
ERROR_INTERNET_SECURITY_CHANNEL_ERROR       equ (INTERNET_ERROR_BASE + 157)
ERROR_INTERNET_UNABLE_TO_CACHE_FILE         equ (INTERNET_ERROR_BASE + 158)
ERROR_INTERNET_TCPIP_NOT_INSTALLED          equ (INTERNET_ERROR_BASE + 159)
ERROR_INTERNET_DISCONNECTED                 equ (INTERNET_ERROR_BASE + 163)
ERROR_INTERNET_SERVER_UNREACHABLE           equ (INTERNET_ERROR_BASE + 164)
ERROR_INTERNET_PROXY_SERVER_UNREACHABLE     equ (INTERNET_ERROR_BASE + 165)
ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT        equ (INTERNET_ERROR_BASE + 166)
ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT    equ (INTERNET_ERROR_BASE + 167)
ERROR_INTERNET_SEC_INVALID_CERT             equ (INTERNET_ERROR_BASE + 169)
ERROR_INTERNET_SEC_CERT_REVOKED             equ (INTERNET_ERROR_BASE + 170)
ERROR_INTERNET_FAILED_DUETOSECURITYCHECK    equ (INTERNET_ERROR_BASE + 171)
INTERNET_ERROR_LAST                         equ ERROR_INTERNET_FAILED_DUETOSECURITYCHECK
NORMAL_CACHE_ENTRY          equ 1
COOKIE_CACHE_ENTRY          equ 100000h
URLHISTORY_CACHE_ENTRY      equ 200000h
TRACK_OFFLINE_CACHE_ENTRY   equ 10h
TRACK_ONLINE_CACHE_ENTRY    equ 20h
STICKY_CACHE_ENTRY          equ 4
SPARSE_CACHE_ENTRY          equ 10000h
URLCACHE_FIND_DEFAULT_FILTER equ NORMAL_CACHE_ENTRY \
 + COOKIE_CACHE_ENTRY \
 + URLHISTORY_CACHE_ENTRY \
 + TRACK_OFFLINE_CACHE_ENTRY \
 + TRACK_ONLINE_CACHE_ENTRY \
 + STICKY_CACHE_ENTRY
CACHE_ENTRY_ATTRIBUTE_FC    equ 4
CACHE_ENTRY_HITRATE_FC      equ 10h
CACHE_ENTRY_MODTIME_FC      equ 40h
CACHE_ENTRY_EXPTIME_FC      equ 80h
CACHE_ENTRY_ACCTIME_FC      equ 100h
CACHE_ENTRY_SYNCTIME_FC     equ 200h
CACHE_ENTRY_HEADERINFO_FC   equ 400h
CACHE_ENTRY_EXEMPT_DELTA_FC equ 800h
INTERNET_DIAL_UNATTENDED    equ 8000h
INTERENT_GOONLINE_REFRESH   equ 1
INTERENT_GOONLINE_MASK      equ 1
INTERNET_AUTODIAL_FORCE_ONLINE          equ 1
INTERNET_AUTODIAL_FORCE_UNATTENDED      equ 2
INTERNET_AUTODIAL_FAILIFSECURITYCHECK   equ 4
INTERNET_AUTODIAL_FLAGS_MASK equ (INTERNET_AUTODIAL_FORCE_ONLINE + INTERNET_AUTODIAL_FORCE_UNATTENDED + INTERNET_AUTODIAL_FAILIFSECURITYCHECK)
INTERNET_CONNECTION_MODEM   equ 1
INTERNET_CONNECTION_LAN     equ 2
INTERNET_CONNECTION_PROXY   equ 4
INTERNET_CONNECTION_MODEM_BUSY          equ 8
INTERNET_CUSTOMDIAL_CONNECT             equ 0
INTERNET_CUSTOMDIAL_UNATTENDED          equ 1
INTERNET_CUSTOMDIAL_DISCONNECT          equ 2
INTERNET_CUSTOMDIAL_SHOWOFFLINE         equ 4
INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED equ 1
INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE   equ 2
INTERNET_CUSTOMDIAL_CAN_HANGUP          equ 4
INTERNET_DIALSTATE_DISCONNECTED         equ 1
ISO_FORCE_DISCONNECTED  equ 1
INTERNET_SCHEME_PARTIAL equ -2
INTERNET_SCHEME_UNKNOWN equ -1
INTERNET_SCHEME_DEFAULT equ 0
INTERNET_SCHEME_FTP     equ 1
INTERNET_SCHEME_GOPHER  equ 2
INTERNET_SCHEME_HTTP    equ 3
INTERNET_SCHEME_HTTPS   equ 4
INTERNET_SCHEME_FILE    equ 5
INTERNET_SCHEME_NEWS    equ 6
INTERNET_SCHEME_MAILTO  equ 7
INTERNET_SCHEME_SOCKS   equ 8
INTERNET_SCHEME_FIRST   equ INTERNET_SCHEME_FTP equ 9
INTERNET_SCHEME_LAST    equ INTERNET_SCHEME_SOCKS equ 10
;
;Device IO Control
;
IOCTL_DISK_EJECT_MEDIA	equ 74808h
;
; Extra registry data
;
KEY_QUERY_VALUE                      equ 1h
KEY_SET_VALUE                        equ 2h
KEY_CREATE_SUB_KEY                   equ 4h
KEY_ENUMERATE_SUB_KEYS               equ 8h
KEY_NOTIFY                           equ 10h
KEY_CREATE_LINK                      equ 20h
KEY_READ                             equ STANDARD_RIGHTS_READ OR KEY_QUERY_VALUE OR KEY_ENUMERATE_SUB_KEYS OR KEY_NOTIFY AND NOT SYNCHRONIZE
KEY_WRITE                            equ STANDARD_RIGHTS_WRITE OR KEY_SET_VALUE OR KEY_CREATE_SUB_KEY AND NOT SYNCHRONIZE
KEY_EXECUTE                          equ KEY_READ
KEY_ALL_ACCESS                       equ STANDARD_RIGHTS_ALL OR KEY_QUERY_VALUE OR KEY_SET_VALUE OR KEY_CREATE_SUB_KEY OR KEY_ENUMERATE_SUB_KEYS OR KEY_NOTIFY OR KEY_CREATE_LINK AND NOT SYNCHRONIZE
;
; List Box dialog code
;
LB_CTLCODE	equ 0
;
; List Box return values
;
LB_OKAY	equ 0
LB_ERR	equ -1
LB_ERRSPACE	equ -2
;
; List Box messages
;
LB_ADDSTRING		equ 0180h
LB_INSERTSTRING		equ 0181h
LB_DELETESTRING		equ 0182h
LB_SELITEMRANGEEX		equ 0183h
LB_RESETCONTENT		equ 0184h
LB_SETSEL			equ 0185h
LB_SETCURSEL		equ 0186h
LB_GETSEL			equ 0187h
LB_GETCURSEL		equ 0188h
LB_GETTEXT			equ 0189h
LB_GETTEXTLEN		equ 018Ah
LB_GETCOUNT			equ 018Bh
LB_SELECTSTRING		equ 018Ch
LB_DIR			equ 018Dh
LB_GETTOPINDEX		equ 018Eh
LB_FINDSTRING		equ 018Fh
LB_GETSELCOUNT		equ 0190h
LB_GETSELITEMS		equ 0191h
LB_SETTABSTOPS		equ 0192h
LB_GETHORIZONTALEXTENT	equ 0193h
LB_SETHORIZONTALEXTENT	equ 0194h
LB_SETCOLUMNWIDTH		equ 0195h
LB_ADDFILE			equ 0196h
LB_SETTOPINDEX		equ 0197h
LB_GETITEMRECT		equ 0198h
LB_GETITEMDATA		equ 0199h
LB_SETITEMDATA		equ 019Ah
LB_SELITEMRANGE		equ 019Bh
LB_SETANCHORINDEX		equ 019Ch
LB_GETANCHORINDEX		equ 019Dh
LB_SETCARETINDEX		equ 019Eh
LB_GETCARETINDEX		equ 019Fh
LB_SETITEMHEIGHT		equ 01A0h
LB_GETITEMHEIGHT		equ 01A1h
LB_FINDSTRINGEXACT	equ 01A2h
LB_SETLOCALE		equ 01A5h
LB_GETLOCALE		equ 01A6h
LB_SETCOUNT			equ 01A7h
LB_INITSTORAGE		equ 01A8h
LB_ITEMFROMPOINT		equ 01A9h
LB_MSGMAX			equ 01B0h	; pre 4.0 = 01A8h
;
; List Box notification codes
;
LBN_ERRSPACE	equ -2
LBN_SELCHANGE	equ 1
LBN_DBLCLK		equ 2
LBN_SELCANCEL	equ 3
LBN_SETFOCUS	equ 4
LBN_KILLFOCUS	equ 5
;
; List Box styles
;
LBS_NOTIFY			equ 0001h
LBS_SORT			equ 0002h
LBS_NOREDRAW		equ 0004h
LBS_MULTIPLESEL		equ 0008h
LBS_OWNERDRAWFIXED	equ 0010h
LBS_OWNERDRAWVARIABLE	equ 0020h
LBS_HASSTRINGS		equ 0040h
LBS_USETABSTOPS		equ 0080h
LBS_NOINTEGRALHEIGHT	equ 0100h
LBS_MULTICOLUMN		equ 0200h
LBS_WANTKEYBOARDINPUT	equ 0400h
LBS_EXTENDEDSEL		equ 0800h
LBS_DISABLENOSCROLL	equ 1000h
LBS_NODATA			equ 2000h
LBS_NOSEL			equ 4000h
LBS_STANDARD		equ LBS_NOTIFY or LBS_SORT or WS_VSCROLL or WS_BORDER
;
; Rich Edit
;
LF_FACESIZE                          equ 32
LF_FULLFACESIZE                      equ 64
;
; Multi column boxes info
;
LVCF_FMT        		equ 0001h
LVCF_WIDTH      		equ 0002h
LVCF_TEXT       		equ 0004h
LVCF_SUBITEM    		equ 0008h
LVCFMT_LEFT     		equ 0000h
LVCFMT_RIGHT    		equ 0001h
LVCFMT_CENTER   		equ 0002h
LVCFMT_JUSTIFYMASK 	equ 0003h

LVIF_TEXT       		equ 0001h
LVIF_IMAGE      		equ 0002h
LVIF_PARAM      		equ 0004h
LVIF_STATE      		equ 0008h

LVIS_FOCUSED    		equ 0001h
LVIS_SELECTED   		equ 0002h
LVIS_CUT        		equ 0004h
LVIS_DROPHILITED                equ 0008h
LVIS_OVERLAYMASK                equ 0F00h
LVIS_STATEIMAGEMASK             equ 0F000h

LVN_FIRST        	equ 0-100
LVN_LAST         	equ 0-199
LVM_FIRST        		equ 1000h
LVM_INSERTCOLUMN		equ LVM_FIRST + 27
LVM_INSERTCOLUMNW 	equ LVM_FIRST + 97
LVM_DELETECOLUMN 		equ LVM_FIRST + 28
LVM_GETCOLUMNWIDTH	equ LVM_FIRST + 29
LVM_GETITEM     		equ LVM_FIRST + 5
LVM_GETITEMW    		equ LVM_FIRST + 75
LVM_SETITEM     		equ LVM_FIRST + 6
LVM_SETITEMW    		equ LVM_FIRST + 76
LVM_INSERTITEM  		equ LVM_FIRST + 7
LVM_INSERTITEMW 		equ LVM_FIRST + 77
LVM_DELETEITEM  		equ LVM_FIRST + 8
LVM_DELETEALLITEMS  	equ LVM_FIRST + 9
LVM_GETCALLBACKMASK  	equ LVM_FIRST + 10
LVM_SETCALLBACKMASK   	equ LVM_FIRST + 11
LVNI_ALL        	equ 0000h
LVNI_FOCUSED    	equ 0001h
LVNI_SELECTED   	equ 0002h
LVNI_CUT        	equ 0004h
LVNI_DROPHILITED                equ 0008h
LVNI_ABOVE      	equ 0100h
LVNI_BELOW      	equ 0200h
LVNI_TOLEFT     	equ 0400h
LVNI_TORIGHT    	equ 0800h
LVM_GETNEXTITEM 	equ LVM_FIRST + 12
LVFI_PARAM      	equ 0001h
LVFI_STRING     	equ 0002h
LVFI_PARTIAL    	equ 0008h
LVFI_WRAP       	equ 0020h
LVFI_NEARESTXY  	equ 0040h
LVM_FINDITEM    	equ LVM_FIRST + 83
LVIR_BOUNDS     	equ 0
LVIR_ICON       	equ 1
LVIR_LABEL      	equ 2
LVIR_SELECTBOUNDS               equ 3
LVM_GETITEMRECT 	equ LVM_FIRST + 14
LVM_SETITEMPOSITION             equ LVM_FIRST + 15
LVM_GETITEMPOSITION             equ LVM_FIRST + 16
LVM_GETSTRINGWIDTH              equ LVM_FIRST + 17
LVM_GETSTRINGWIDTHW             equ LVM_FIRST + 87
LVHT_NOWHERE    	equ 0001h
LVHT_ONITEMICON 	equ 0002h
LVHT_ONITEMLABEL                equ 0004h
LVHT_ONITEMSTATEICON            equ 0008h
LVHT_ONITEM     	equ LVHT_ONITEMICON OR LVHT_ONITEMLABEL OR LVHT_ONITEMSTATEICON
LVHT_ABOVE      	equ 0008h
LVHT_BELOW      	equ 0010h
LVHT_TORIGHT    	equ 0020h
LVHT_TOLEFT     	equ 0040h
LVM_HITTEST     	equ LVM_FIRST + 18
LVM_ENSUREVISIBLE               equ LVM_FIRST + 19
LVM_SCROLL      	equ LVM_FIRST + 20
LVM_REDRAWITEMS 	equ LVM_FIRST + 21
LVA_DEFAULT     	equ 0000h
LVA_ALIGNLEFT   	equ 0001h
LVA_ALIGNTOP    	equ 0002h
LVA_SNAPTOGRID  	equ 0005h
LVM_ARRANGE     	equ LVM_FIRST + 22
LVM_EDITLABEL   	equ LVM_FIRST + 23
LVM_EDITLABELW  	equ LVM_FIRST + 118
LVM_GETEDITCONTROL              equ LVM_FIRST + 24
LVCF_FMT        	equ 0001h
LVCF_WIDTH      	equ 0002h
LVCF_TEXT       	equ 0004h
LVCF_SUBITEM    	equ 0008h
LVCFMT_LEFT     	equ 0000h
LVCFMT_RIGHT    	equ 0001h
LVCFMT_CENTER   	equ 0002h
LVCFMT_JUSTIFYMASK              equ 0003h
LVM_GETCOLUMN   	equ LVM_FIRST + 25
LVM_GETCOLUMNW  	equ LVM_FIRST + 95
LVM_SETCOLUMN   	equ LVM_FIRST + 26
LVM_SETCOLUMNW  	equ LVM_FIRST + 96
LVM_INSERTCOLUMN                equ LVM_FIRST + 27
LVM_INSERTCOLUMNW               equ LVM_FIRST + 97
LVM_DELETECOLUMN                equ LVM_FIRST + 28
LVM_GETCOLUMNWIDTH              equ LVM_FIRST + 29
LVSCW_AUTOSIZE      	equ -1
LVSCW_AUTOSIZE_USEHEADER            equ -2
LVM_SETCOLUMNWIDTH  	equ LVM_FIRST + 30
LVM_CREATEDRAGIMAGE             equ LVM_FIRST + 33
LVM_GETVIEWRECT 	equ LVM_FIRST + 34
LVM_GETTEXTCOLOR                equ LVM_FIRST + 35
LVM_SETTEXTCOLOR                equ LVM_FIRST + 36
LVM_GETTEXTBKCOLOR              equ LVM_FIRST + 37
LVM_SETTEXTBKCOLOR              equ LVM_FIRST + 38
LVM_GETTOPINDEX 	equ LVM_FIRST + 39
LVM_GETCOUNTPERPAGE             equ LVM_FIRST + 40
LVM_GETORIGIN   	equ LVM_FIRST + 41
LVM_UPDATE      	equ LVM_FIRST + 42
LVM_SETITEMSTATE                equ LVM_FIRST + 43
LVM_GETITEMSTATE                equ LVM_FIRST + 44
LVM_GETITEMTEXT 	equ LVM_FIRST + 45
LVM_GETITEMTEXTW                equ LVM_FIRST + 115
LVM_SETITEMTEXT 	equ LVM_FIRST + 46
LVM_SETITEMTEXTW                equ LVM_FIRST + 116
LVM_SETITEMCOUNT                equ LVM_FIRST + 47
LVM_SORTITEMS   	equ LVM_FIRST + 48
LVM_SETITEMPOSITION32           equ LVM_FIRST + 49
LVM_GETSELECTEDCOUNT            equ LVM_FIRST + 50
LVM_GETITEMSPACING              equ LVM_FIRST + 51
LVM_GETISEARCHSTRING            equ LVM_FIRST + 52
LVM_GETISEARCHSTRINGW           equ LVM_FIRST + 117
LVN_ITEMCHANGING                equ LVN_FIRST-0
LVN_ITEMCHANGED 	equ LVN_FIRST-1
LVN_INSERTITEM  	equ LVN_FIRST-2
LVN_DELETEITEM  	equ LVN_FIRST-3
LVN_DELETEALLITEMS              equ LVN_FIRST-4
LVN_BEGINLABELEDIT              equ LVN_FIRST-5
LVN_BEGINLABELEDITW             equ LVN_FIRST-75
LVN_ENDLABELEDIT                equ LVN_FIRST-6
LVN_ENDLABELEDITW               equ LVN_FIRST-76
LVN_COLUMNCLICK 	equ LVN_FIRST-8
LVN_BEGINDRAG   	equ LVN_FIRST-9
LVN_BEGINRDRAG  	equ LVN_FIRST-11
LVN_GETDISPINFO 	equ LVN_FIRST-50
LVN_GETDISPINFOW                equ LVN_FIRST-77
LVN_SETDISPINFO 	equ LVN_FIRST-51
LVN_SETDISPINFOW                equ LVN_FIRST-78
LVIF_DI_SETITEM 	equ 1000h
LVM_SETIMAGELIST                equ LVM_FIRST + 3
LVM_GETITEMCOUNT                equ LVM_FIRST + 4
LVM_GETBKCOLOR  	equ LVM_FIRST + 0
LVM_SETBKCOLOR  	equ LVM_FIRST + 1

MAX_PATH			equ 260
MAXIMUM_SUPPORTED_EXTENSION	equ 512
;
; Message Box constants
;
MB_OK				equ 00000000h
MB_OKCANCEL			equ 00000001h
MB_ABORTRETRYIGNORE	equ 00000002h
MB_YESNOCANCEL		equ 00000003h
MB_YESNO			equ 00000004h
MB_RETRYCANCEL		equ 00000005h

MB_ICONHAND			equ 00000010h
MB_ICONQUESTION		equ 00000020h
MB_ICONEXCLAMATION	equ 00000030h
MB_ICONASTERISK		equ 00000040h

MB_ICONWARNING		equ MB_ICONEXCLAMATION	; 4.0
MB_ICONERROR		equ MB_ICONHAND	; 4.0

MB_ICONINFORMATION	equ MB_ICONASTERISK
MB_ICONSTOP			equ MB_ICONHAND

MB_DEFBUTTON1		equ 00000000h
MB_DEFBUTTON2		equ 00000100h
MB_DEFBUTTON3		equ 00000200h
MB_DEFBUTTON4		equ 00000300h	; 4.0

MB_APPLMODAL		equ 00000000h
MB_SYSTEMMODAL		equ 00001000h
MB_TASKMODAL		equ 00002000h
MB_HELP			equ 00004000h	; 4.0 Help Button
MB_RIGHT			equ 00080000h	; 4.0
MB_RTLREADING		equ 00100000h	; 4.0

MB_NOFOCUS			equ 00008000h
MB_SETFOREGROUND		equ 00010000h
MB_DEFAULT_DESKTOP_ONLY	equ 00020000h
MB_SERVICE_NOTIFICATION	equ 00040000h

MB_TYPEMASK			equ 0000000Fh
MB_USERICON			equ 00000080h	; 4.0
MB_ICONMASK			equ 000000F0h
MB_DEFMASK			equ 00000F00h
MB_MODEMASK			equ 00003000h
MB_MISCMASK			equ 0000C000h

;
; VirtualAlloc
;
MEM_COMMIT                equ 1000h
MEM_RESERVE               equ 2000h
MEM_DECOMMIT              equ 4000h
MEM_RELEASE               equ 8000h
MEM_FREE                  equ 10000h
MEM_PRIVATE               equ 20000h
MEM_MAPPED                equ 40000h
MEM_RESET                 equ 80000h     
MEM_TOP_DOWN              equ 100000h

;
; Menu flags
; win40  -- A lot of MF_* flags have been renamed as MFT_* and MFS_* flags
;
; Menu flags for Add/Check/EnableMenuItem()
MF_INSERT		equ 0000h
MF_CHANGE		equ 0080h
MF_APPEND		equ 0100h
MF_DELETE		equ 0200h
MF_REMOVE		equ 1000h

MF_BYCOMMAND	equ 0000h
MF_BYPOSITION	equ 0400h

MF_SEPARATOR	equ 0800h

MF_ENABLED		equ 0000h
MF_GRAYED		equ 0001h
MF_DISABLED		equ 0002h

MF_UNCHECKED	equ 0000h
MF_CHECKED		equ 0008h
MF_USECHECKBITMAPS equ 0200h

MF_STRING		equ 0000h
MF_BITMAP		equ 0004h
MF_OWNERDRAW		equ 0100h

; used to be 10h... not sure why different
MF_POPUP		equ 0001h
MF_MENUBARBREAK		equ 0020h
MF_MENUBREAK		equ 0040h

MF_UNHILITE		equ 0000h
MF_HILITE		equ 0080h

MF_DEFAULT		equ 1000h
MF_SYSMENU		equ 2000h
MF_HELP			equ 4000h
MF_RIGHTJUSTIFY		equ 4000h

MF_MOUSESELECT		equ 8000h
MF_END			equ 0080h  ; Obsolete -- only used by old RES files

MFT_STRING		equ MF_STRING
MFT_BITMAP		equ MF_BITMAP
MFT_MENUBARBREAK	equ MF_MENUBARBREAK
MFT_MENUBREAK		equ MF_MENUBREAK
MFT_OWNERDRAW		equ MF_OWNERDRAW
MFT_RADIOCHECK		equ 0200h
MFT_SEPARATOR		equ MF_SEPARATOR
MFT_RIGHTORDER		equ 2000h
MFT_RIGHTJUSTIFY	equ MF_RIGHTJUSTIFY

; Menu flags for Add/Check/EnableMenuItem()
MFS_GRAYED          	equ 0003h
MFS_DISABLED        	equ MFS_GRAYED
MFS_CHECKED         equ MF_CHECKED
MFS_HILITE          equ MF_HILITE
MFS_ENABLED         equ MF_ENABLED
MFS_UNCHECKED       equ MF_UNCHECKED
MFS_UNHILITE        equ MF_UNHILITE
MFS_DEFAULT         equ MF_DEFAULT
;
; Menu state items
;
MIIM_STATE 				equ 1
MIIM_ID 				equ 2
MIIM_SUBMENU 			equ 4
MIIM_CHECKMARKS 			equ 8
MIIM_TYPE 				equ 10h
MIIM_DATA 				equ 20h
MIIM_STRING 			equ 40h
MIIM_BITMAP 			equ 80h
MIIM_FTYPE 				equ 100h
;
; for wm_lbuttonup messages
;
MK_LBUTTON                           equ 1h
MK_RBUTTON                           equ 2h
MK_SHIFT                             equ 4h
MK_CONTROL                           equ 8h
MK_MBUTTON                           equ 10h
;
; popup
;
NIM_ADD                              equ 0h
NIM_MODIFY                           equ 1h
NIM_DELETE                           equ 2h
NIF_MESSAGE                          equ 1h
NIF_ICON                             equ 2h
NIF_TIP                              equ 4h
;
; Predefined WM_NOTIFY codes
;
NM_OUTOFMEMORY	equ -1
NM_CLICK		equ -2
NM_DBLCLICK		equ -3
NM_RETURN		equ -4
NM_RCLICK		equ -5
NM_RDBLCLK		equ -6
NM_SETFOCUS		equ -7
NM_KILLFOCUS	equ -8
;
; Thread ID
;
NORMAL_PRIORITY_CLASS      	equ 20h
IDLE_PRIORITY_CLASS            	equ 40h
HIGH_PRIORITY_CLASS            	equ 80h
REALTIME_PRIORITY_CLASS        	equ 100h
;
; Open file attributes
;
OFN_ALLOWMULTISELECT    equ 00000200h
OFN_CREATEPROMPT        equ 00002000h
OFN_ENABLEHOOK          equ 00000020h
OFN_ENABLETEMPLATE      equ 00000040h
OFN_ENABLETEMPLATEHANDLE                equ 00000080h
OFN_EXPLORER            equ 00080000h
OFN_EXTENSIONDIFFERENT  equ 00000400h
OFN_FILEMUSTEXIST       equ 00001000h
OFN_HIDEREADONLY        equ 00000004h
OFN_LONGNAMES           equ 00200000h
OFN_NOCHANGEDIR         equ 00000008h
OFN_NODEREFERENCELINKS  equ 00100000h
OFN_NOLONGNAMES         equ 00040000h
OFN_NONETWORKBUTTON     equ 00020000h
OFN_NOREADONLYRETURN    equ 00008000h
OFN_NOTESTFILECREATE    equ 00010000h
OFN_NOVALIDATE          equ 00000100h
OFN_OVERWRITEPROMPT     equ 00000002h
OFN_PATHMUSTEXIST       equ 00000800h
OFN_READONLY            equ 00000001h
OFN_SHAREAWARE          equ 00004000h
OFN_SHOWHELP            equ 00000010h
OFN_SHAREFALLTHROUGH    equ 2
OFN_SHARENOWARN         equ 1
OFN_SHAREWARN           equ 0
;
; VirtualAlloc
;
PAGE_NOACCESS             equ 1
PAGE_READONLY             equ 2
PAGE_READWRITE            equ 4
PAGE_WRITECOPY            equ 8
PAGE_EXECUTE              equ 10h
PAGE_EXECUTE_READ         equ 20h
PAGE_EXECUTE_READWRITE    equ 40h
PAGE_EXECUTE_WRITECOPY    equ 80h
PAGE_GUARD                equ 100h
PAGE_NOCACHE              equ 200h
;
; for progress bar etc.
;
PBM_SETRANGE    equ WM_USER+1
PBM_SETPOS      equ WM_USER+2
PBM_DELTAPOS    equ WM_USER+3
PBM_SETSTEP     equ WM_USER+4
PBM_STEPIT      equ WM_USER+5
;
; Registry setting for create key etc.
;
REG_OPTION_RESERVED                  equ 0
REG_OPTION_NON_VOLATILE              equ 0
REG_OPTION_VOLATILE                  equ 1
REG_OPTION_CREATE_LINK               equ 2
REG_OPTION_BACKUP_RESTORE            equ 4
REG_NONE                             equ 0
REG_SZ                               equ 1
REG_EXPAND_SZ                        equ 2
REG_BINARY                           equ 3
REG_DWORD                            equ 4
REG_DWORD_LITTLE_ENDIAN              equ 4
REG_DWORD_BIG_ENDIAN                 equ 5
REG_LINK                             equ 6
REG_MULTI_SZ                         equ 7
REG_RESOURCE_LIST                    equ 8
REG_FULL_RESOURCE_DESCRIPTOR         equ 9
REG_RESOURCE_REQUIREMENTS_LIST       equ 10
REG_CREATED_NEW_KEY                  equ 1h
REG_OPENED_EXISTING_KEY              equ 2h
REG_WHOLE_HIVE_VOLATILE              equ 1h
REG_REFRESH_HIVE                     equ 2h
REG_NOTIFY_CHANGE_NAME               equ 1h
REG_NOTIFY_CHANGE_ATTRIBUTES         equ 2h
REG_NOTIFY_CHANGE_LAST_SET           equ 4h
REG_NOTIFY_CHANGE_SECURITY           equ 8h
REG_LEGAL_CHANGE_FILTER              equ REG_NOTIFY_CHANGE_NAME OR REG_NOTIFY_CHANGE_ATTRIBUTES OR REG_NOTIFY_CHANGE_LAST_SET OR REG_NOTIFY_CHANGE_SECURITY
REG_LEGAL_OPTION                     equ REG_OPTION_RESERVED OR REG_OPTION_NON_VOLATILE OR REG_OPTION_VOLATILE OR REG_OPTION_CREATE_LINK OR REG_OPTION_BACKUP_RESTORE
;
; .rc/.res file stuff
;
RT_CURSOR                            equ 1
RT_BITMAP                            equ 2
RT_ICON                              equ 3
RT_MENU                              equ 4
RT_DIALOG                            equ 5
RT_STRING                            equ 6
RT_FONTDIR                           equ 7
RT_FONT                              equ 8
RT_ACCELERATOR                       equ 9
RT_RCDATA                            equ 10
;
; RedrawWindow() flags
;
RDW_INVALIDATE		equ 0001h
RDW_INTERNALPAINT		equ 0002h
RDW_ERASE			equ 0004h

RDW_VALIDATE		equ 0008h
RDW_NOINTERNALPAINT	equ 0010h
RDW_NOERASE			equ 0020h

RDW_NOCHILDREN		equ 0040h
RDW_ALLCHILDREN		equ 0080h

RDW_UPDATENOW		equ 0100h
RDW_ERASENOW		equ 0200h

RDW_FRAME			equ 0400h
RDW_NOFRAME			equ 0800h
;
; Rich Edit
;
SCF_DEFAULT             equ 0
SCF_SELECTION           equ 1
SCF_WORD                equ 2
SCF_ALL                 equ 4
SCF_SCF_USEUIRULES      equ 8
;
; Scroll Bar constants
;
SB_HORZ	equ 0
SB_VERT	equ 1
SB_CTL	equ 2
SB_BOTH	equ 3
;
; Scroll Bar commands
;
SB_LINEUP		equ 0
SB_LINELEFT		equ 0
SB_LINEDOWN		equ 1
SB_LINERIGHT	equ 1
SB_PAGEUP		equ 2
SB_PAGELEFT		equ 2
SB_PAGEDOWN		equ 3
SB_PAGERIGHT	equ 3
SB_THUMBPOSITION	equ 4
SB_THUMBTRACK	equ 5
SB_TOP		equ 6
SB_LEFT		equ 6
SB_BOTTOM		equ 7
SB_RIGHT		equ 7
SB_ENDSCROLL	equ 8
;
; Status Bar MSG
;
SB_SETTEXT      	equ WM_USER+1
SB_SETTEXTW     	equ WM_USER+11
SB_GETTEXT      	equ WM_USER+2
SB_GETTEXTW     	equ WM_USER+13
SB_GETTEXTLENGTH  equ WM_USER+3
SB_GETTEXTLENGTHW equ WM_USER+12
SB_SETPARTS      	equ WM_USER+4
SB_GETPARTS      	equ WM_USER+6
SB_GETBORDERS    	equ WM_USER+7
SB_SETMINHEIGHT  	equ WM_USER+8
SB_SIMPLE        	equ WM_USER+9
SB_GETRECT       	equ WM_USER+10
;
; Scroll Bar messages
;
SBM_SETPOS			equ 00E0h ; not in win3.1
SBM_GETPOS			equ 00E1h ; not in win3.1
SBM_SETRANGE		equ 00E2h ; not in win3.1
SBM_SETRANGEREDRAW	equ 00E6h ; not in win3.1
SBM_GETRANGE		equ 00E3h ; not in win3.1
SBM_ENABLE_ARROWS		equ 00E4h ; not in win3.1
SBM_SETSCROLLINFO		equ 00E9h
SBM_GETSCROLLINFO		equ 00EAh
;
; Scroll Bar styles
;
SBS_HORZ			equ 0000h
SBS_VERT			equ 0001h
SBS_TOPALIGN		equ 0002h
SBS_LEFTALIGN		equ 0002h
SBS_BOTTOMALIGN		equ 0004h
SBS_RIGHTALIGN		equ 0004h
SBS_SIZEBOXTOPLEFTALIGN	equ 0002h
SBS_SIZEBOXBOTTOMRIGHTALIGN equ 0004h
SBS_SIZEBOX			equ 0008h
SBS_SIZEGRIP		equ 0010h
;
; Used with sendcommand /wm_syscommand
;
SC_SIZE                              equ 0F000h
SC_MOVE                              equ 0F010h
SC_MINIMIZE                          equ 0F020h
SC_MAXIMIZE                          equ 0F030h
SC_NEXTWINDOW                        equ 0F040h
SC_PREVWINDOW                        equ 0F050h
SC_CLOSE                             equ 0F060h
SC_VSCROLL                           equ 0F070h
SC_HSCROLL                           equ 0F080h
SC_MOUSEMENU                         equ 0F090h
SC_KEYMENU                           equ 0F100h
SC_ARRANGE                           equ 0F110h
SC_RESTORE                           equ 0F120h
SC_TASKLIST                          equ 0F130h
SC_SCREENSAVE                        equ 0F140h
SC_HOTKEY                            equ 0F150h
SC_ICON                              equ SC_MINIMIZE
SC_ZOOM                              equ SC_MAXIMIZE
SC_DEFAULT      				  equ 0F160h
SC_MONITORPOWER 				  equ 0F170h
SC_CONTEXTHELP  				  equ 0F180h
SC_SEPARATOR    				  equ 0F00Fh
;
; Privalege Token settings
;
SE_OWNER_DEFAULTED equ (0001h)
SE_GROUP_DEFAULTED equ (0002h)
SE_DACL_PRESENT equ (0004h)
SE_DACL_DEFAULTED equ (0008h)
SE_SACL_PRESENT equ (0010h)
SE_SACL_DEFAULTED equ (0020h)
SE_DACL_AUTO_INHERIT_REQ equ (0100h)
SE_SACL_AUTO_INHERIT_REQ equ (0200h)
SE_DACL_AUTO_INHERITED equ (0400h)
SE_SACL_AUTO_INHERITED equ (0800h)
SE_DACL_PROTECTED equ (1000h)
SE_SACL_PROTECTED equ (2000h)
SE_SELF_RELATIVE equ (8000h)
ACCESS_OBJECT_GUID equ 0
ACCESS_PROPERTY_SET_GUID equ 1
ACCESS_PROPERTY_GUID equ 2
ACCESS_MAX_LEVEL equ 4
AUDIT_ALLOW_NO_PRIVILEGE equ 1h
SE_PRIVILEGE_ENABLED_BY_DEFAULT equ (00000001h)
SE_PRIVILEGE_ENABLED equ (00000002h)
SE_PRIVILEGE_USED_FOR_ACCESS equ (80000000h)
PRIVILEGE_SET_ALL_NECESSARY equ (1)
SE_CREATE_TOKEN_NAME equ "SeCreateTokenPrivilege"
SE_ASSIGNPRIMARYTOKEN_NAME equ "SeAssignPrimaryTokenPrivilege"
SE_LOCK_MEMORY_NAME equ "SeLockMemoryPrivilege"
SE_INCREASE_QUOTA_NAME equ ("SeIncreaseQuotaPrivilege")
SE_UNSOLICITED_INPUT_NAME equ ("SeUnsolicitedInputPrivilege")
SE_MACHINE_ACCOUNT_NAME equ ("SeMachineAccountPrivilege")
SE_TCB_NAME equ ("SeTcbPrivilege")
SE_SECURITY_NAME equ ("SeSecurityPrivilege")
SE_TAKE_OWNERSHIP_NAME equ ("SeTakeOwnershipPrivilege")
SE_LOAD_DRIVER_NAME equ ("SeLoadDriverPrivilege")
SE_SYSTEM_PROFILE_NAME equ ("SeSystemProfilePrivilege")
SE_SYSTEMTIME_NAME equ ("SeSystemtimePrivilege")
SE_PROF_SINGLE_PROCESS_NAME equ ("SeProfileSingleProcessPrivilege")
SE_INC_BASE_PRIORITY_NAME equ ("SeIncreaseBasePriorityPrivilege")
SE_CREATE_PAGEFILE_NAME equ ("SeCreatePagefilePrivilege")
SE_CREATE_PERMANENT_NAME equ ("SeCreatePermanentPrivilege")
SE_BACKUP_NAME equ ("SeBackupPrivilege")
SE_RESTORE_NAME equ ("SeRestorePrivilege")
SE_SHUTDOWN_NAME equ ("SeShutdownPrivilege")
SE_DEBUG_NAME equ ("SeDebugPrivilege")
SE_AUDIT_NAME equ ("SeAuditPrivilege")
SE_SYSTEM_ENVIRONMENT_NAME equ ("SeSystemEnvironmentPrivilege")
SE_CHANGE_NOTIFY_NAME equ ("SeChangeNotifyPrivilege")
SE_REMOTE_SHUTDOWN_NAME equ ("SeRemoteShutdownPrivilege")
TOKEN_ASSIGN_PRIMARY equ (0001h)
TOKEN_DUPLICATE equ (0002h)
TOKEN_IMPERSONATE equ (0004h)
TOKEN_QUERY equ (0008h)
TOKEN_QUERY_SOURCE equ (0010h)
TOKEN_ADJUST_PRIVILEGES equ (0020h)
TOKEN_ADJUST_GROUPS equ (0040h)
TOKEN_ADJUST_DEFAULT equ (0080h)
TOKEN_ADJUST_SESSIONID equ (0100h)
TOKEN_ALL_ACCESS equ (STANDARD_RIGHTS_REQUIRED+TOKEN_ASSIGN_PRIMARY+TOKEN_DUPLICATE+ \
                          TOKEN_IMPERSONATE+TOKEN_QUERY+TOKEN_QUERY_SOURCE+ \
                          TOKEN_ADJUST_PRIVILEGES+TOKEN_ADJUST_GROUPS+TOKEN_ADJUST_SESSIONID+ \
                          TOKEN_ADJUST_DEFAULT)
TOKEN_READ equ (STANDARD_RIGHTS_READ+TOKEN_QUERY)
TOKEN_WRITE equ (STANDARD_RIGHTS_WRITE+TOKEN_ADJUST_PRIVILEGES+TOKEN_ADJUST_GROUPS+TOKEN_ADJUST_DEFAULT)
TOKEN_EXECUTE equ (STANDARD_RIGHTS_EXECUTE)
TOKEN_SOURCE_LENGTH equ 8
;
; File Mapping
;
SECTION_QUERY                        equ 1h
SECTION_MAP_WRITE                    equ 2h
SECTION_MAP_READ                     equ 4h
SECTION_MAP_EXECUTE                  equ 8h
SECTION_EXTEND_SIZE                  equ 10h
SECTION_ALL_ACCESS                   equ STANDARD_RIGHTS_REQUIRED OR SECTION_QUERY OR SECTION_MAP_WRITE OR SECTION_MAP_READ OR SECTION_MAP_EXECUTE OR SECTION_EXTEND_SIZE
;
; Set Error Mode Options
;
SEM_FAILCRITICALERRORS               equ 1h
SEM_NOGPFAULTERRORBOX                equ 2h
SEM_NOOPENFILEERRORBOX               equ 8000h
;
; Scroll Bar Info flags
;
SIF_RANGE			equ 0001h
SIF_PAGE			equ 0002h
SIF_POS			equ 0004h
SIF_DISABLENOSCROLL	equ 0008h
SIF_TRACKPOS		equ 0010h
SIF_ALL	equ SIF_RANGE or SIF_PAGE or SIF_POS or SIF_TRACKPOS
;
; Shel notify and Windows size
;
SIZE_RESTORED                        equ 0
SIZE_MINIMIZED                       equ 1
SIZE_MAXIMIZED                       equ 2
SIZE_MAXSHOW                         equ 3
SIZE_MAXHIDE                         equ 4
SIZENORMAL                           equ SIZE_RESTORED
SIZEICONIC                           equ SIZE_MINIMIZED
SIZEFULLSCREEN                       equ SIZE_MAXIMIZED
SIZEZOOMSHOW                         equ SIZE_MAXSHOW
SIZEZOOMHIDE                         equ SIZE_MAXHIDE
;
; ========================
; GetSystemMetrics() codes
; ========================
;
SM_CXSCREEN			equ	 0
SM_CYSCREEN			equ	 1
SM_CXVSCROLL			equ	 2
SM_CYHSCROLL			equ	 3
SM_CYCAPTION			equ	 4
SM_CXBORDER			equ	 5
SM_CYBORDER			equ	 6
SM_CXDLGFRAME			equ	 7
SM_CYDLGFRAME			equ	 8
SM_CYVTHUMB			equ	 9
SM_CXHTHUMB			equ	10
SM_CXICON			equ	11
SM_CYICON			equ	12
SM_CXCURSOR			equ	13
SM_CYCURSOR			equ	14
SM_CYMENU			equ	15
SM_CXFULLSCREEN			equ	16
SM_CYFULLSCREEN			equ	17
SM_CYKANJIWINDOW		equ	18
SM_MOUSEPRESENT			equ	19
SM_CYVSCROLL			equ	20
SM_CXHSCROLL			equ	21
SM_DEBUG			equ	22
SM_SWAPBUTTON			equ	23
SM_RESERVED1			equ	24
SM_RESERVED2			equ	25
SM_RESERVED3			equ	26
SM_RESERVED4			equ	27
SM_CXMIN			equ	28
SM_CYMIN			equ	29
SM_CXSIZE			equ	30
SM_CYSIZE			equ	31
SM_CXFRAME			equ	32
SM_CYFRAME			equ	33
SM_CXMINTRACK			equ	34
SM_CYMINTRACK			equ	35
SM_CXDOUBLECLK			equ	36
SM_CYDOUBLECLK			equ	37
SM_CXICONSPACING		equ	38
SM_CYICONSPACING		equ	39
SM_MENUDROPALIGNMENT		equ	40
SM_PENWINDOWS			equ	41
SM_DBCSENABLED			equ	42
SM_CMOUSEBUTTONS		equ	43
SM_SECURE			equ	44
SM_CXEDGE			equ	45
SM_CYEDGE			equ	46
SM_CXMINSPACING			equ	47
SM_CYMINSPACING			equ	48
SM_CXSMICON			equ	49
SM_CYSMICON			equ	50
SM_CYSMCAPTION			equ	51
SM_CXSMSIZE			equ	52
SM_CYSMSIZE			equ	53
SM_CXMENUSIZE			equ	54
SM_CYMENUSIZE			equ	55
SM_ARRANGE			equ	56
SM_CXMINIMIZED			equ	57
SM_CYMINIMIZED			equ	58
SM_CXMAXTRACK			equ	59
SM_CYMAXTRACK			equ	60
SM_CXMAXIMIZED			equ	61
SM_CYMAXIMIZED			equ	62
SM_NETWORK			equ	63
SM_CLEANBOOT			equ	67
SM_CXDRAG			equ	68
SM_CYDRAG			equ	69
SM_SHOWSOUNDS			equ	70
SM_CXMENUCHECK			equ	71
SM_CYMENUCHECK			equ	72
SM_SLOWMACHINE			equ	73
SM_MIDEASTENABLED		equ	74
SM_CXFIXEDFRAME			equ	SM_CXDLGFRAME
SM_CYFIXEDFRAME			equ	SM_CYDLGFRAME
SM_CXSIZEFRAME			equ	SM_CXFRAME
SM_CYSIZEFRAME			equ	SM_CYFRAME
;
; Static window styles
;
SS_LEFT		equ 0000h
SS_CENTER		equ 0001h
SS_RIGHT		equ 0002h
SS_ICON		equ 0003h
SS_BLACKRECT	equ 0004h
SS_GRAYRECT		equ 0005h
SS_WHITERECT	equ 0006h
SS_BLACKFRAME	equ 0007h
SS_GRAYFRAME	equ 0008h
SS_WHITEFRAME	equ 0009h
SS_USERITEM		equ 000Ah
SS_SIMPLE		equ 000Bh
SS_LEFTNOWORDWRAP	equ 000Ch
SS_BITMAP		equ 000Eh
SS_OWNERDRAW	equ 000Dh
SS_ENHMETAFILE	equ 000Fh
SS_ETCHEDHORZ	equ 0010h
SS_ETCHEDVERT	equ 0011h
SS_ETCHEDFRAME	equ 0012h
SS_TYPEMASK		equ 001Fh
SS_NOPREFIX		equ 0080h	; Don't do "&" character translation
SS_NOTIFY		equ 0100h
SS_CENTERIMAGE	equ 0200h
SS_RIGHTJUST	equ 0400h
SS_REALSIZEIMAGE	equ 0800h
SS_SUNKEN		equ 1000h
;
; File rights etc
;
READ_CONTROL                         equ 20000h
STANDARD_RIGHTS_READ                 equ READ_CONTROL
STANDARD_RIGHTS_WRITE                equ READ_CONTROL
STANDARD_RIGHTS_EXECUTE              equ READ_CONTROL
STANDARD_RIGHTS_REQUIRED             equ 0F0000h
STANDARD_RIGHTS_ALL                  equ 1F0000h
SPECIFIC_RIGHTS_ALL                  equ 0FFFFh
;
; Standard I/O
;
STD_INPUT_HANDLE	equ -10
STD_OUTPUT_HANDLE	equ -11
STD_ERROR_HANDLE	equ -12
;
; Static window messages
;
STM_SETICON		equ 0170h
STM_GETICON		equ 0171h
STM_SETIMAGE	equ 0172h
STM_GETIMAGE	equ 0173h
STM_MSGMAX		equ 0174h
;
; Static window notifications
;
STN_CLICKED		equ 0
STN_DBLCLK		equ 1
STN_ENABLE		equ 2
STN_DISABLE		equ 3
;
; ShowWindow commands
;
SW_HIDE		equ 0
SW_SHOWNORMAL	equ 1	; preferred for 1st show
SW_NORMAL		equ 1
SW_SHOWMINIMIZED	equ 2	; activate minimized window
SW_SHOWMAXIMIZED	equ 3
SW_MAXIMIZE		equ 3
SW_SHOWNOACTIVATE	equ 4	; most recent state
SW_SHOW		equ 5	; current state
SW_MINIMIZE		equ 6	; activate next "top" window
SW_SHOWMINNOACTIVE equ 7
SW_SHOWNA		equ 8	; current state
SW_RESTORE		equ 9	; preferred for restoring from minimize
SW_SHOWDEFAULT	equ 10
SW_MAX		equ 10
;
; Windows resizing commands
;
SWP_NOSIZE              equ 1h
SWP_NOMOVE              equ 2h
SWP_NOZORDER            equ 4h
SWP_NOREDRAW            equ 8h
SWP_NOACTIVATE          equ 10h
SWP_FRAMECHANGED        equ 20h
SWP_SHOWWINDOW          equ 40h
SWP_HIDEWINDOW          equ 80h
SWP_NOCOPYBITS          equ 100h
SWP_NOOWNERZORDER       equ 200h
SWP_DRAWFRAME           equ SWP_FRAMECHANGED
SWP_NOREPOSITION        equ SWP_NOOWNERZORDER
SWP_DEFERERASE      	equ 2000h
SWP_ASYNCWINDOWPOS  	equ 4000h
;
;	Token
;
TCM_FIRST        	equ 1300h
TCM_GETIMAGELIST 	equ TCM_FIRST + 2
TCM_SETIMAGELIST	equ TCM_FIRST + 3
TCM_GETITEMCOUNT 	equ TCM_FIRST + 4
TCIF_TEXT        	equ 0001h
TCIF_IMAGE       	equ 0002h
TCIF_RTLREADING  	equ 0004h
TCIF_PARAM       	equ 0008h
TCM_GETITEM      	equ TCM_FIRST + 5
TCM_SETITEM     	equ TCM_FIRST + 6
TCM_SETITEMW    	equ TCM_FIRST + 61
TCM_INSERTITEM  	equ TCM_FIRST + 7
TCM_INSERTITEMW 	equ TCM_FIRST + 62
TCM_DELETEITEM   	equ TCM_FIRST + 8
TCM_DELETEALLITEMS	equ TCM_FIRST + 9
TCM_GETITEMRECT  	equ TCM_FIRST + 10
TCM_GETCURSEL    	equ TCM_FIRST + 11
TCM_SETCURSEL    	equ TCM_FIRST + 12
;
;
TPM_LEFTBUTTON                       equ 0h
TPM_RIGHTBUTTON                      equ 2h
TPM_LEFTALIGN                        equ 0h
TPM_CENTERALIGN                      equ 4h
TPM_RIGHTALIGN                       equ 8h
TPM_TOPALIGN        			  equ 0
TPM_VCENTERALIGN    			  equ 10h
TPM_BOTTOMALIGN     			  equ 20h
TPM_HORIZONTAL      			  equ 0
TPM_VERTICAL        			  equ 40h
TPM_NONOTIFY        			  equ 80h
TPM_RETURNCMD       			  equ 100h
TPM_RECURSE         			  equ 1
;
; OS Version Info
;
VER_PLATFORM_WIN32s                  equ 0
VER_PLATFORM_WIN32_WINDOWS           equ 1
VER_PLATFORM_WIN32_NT                equ 2
;
; VWin32
;
VWIN32_DIOC_DOS_DRIVEINFO 	equ 6  
VWIN32_DIOC_DOS_INT13		equ 4  
VWIN32_DIOC_DOS_INT25		equ 2  
VWIN32_DIOC_DOS_INT26		equ 3  
VWIN32_DIOC_DOS_IOCTL		equ 1 
;
; Window messages
;
WM_NULL		equ 0000h
WM_CREATE		equ 0001h
WM_DESTROY		equ 0002h
WM_MOVE		equ 0003h
WM_SIZE		equ 0005h
WM_ACTIVATE		equ 0006h
WM_SETFOCUS		equ 0007h
WM_KILLFOCUS	equ 0008h
WM_ENABLE		equ 000Ah
WM_SETREDRAW	equ 000Bh
WM_SETTEXT		equ 000Ch
WM_GETTEXT		equ 000Dh
WM_GETTEXTLENGTH	equ 000Eh
WM_PAINT		equ 000Fh
WM_CLOSE		equ 0010h
WM_QUERYENDSESSION equ 0011h
WM_QUIT		equ 0012h
WM_QUERYOPEN	equ 0013h
WM_ERASEBKGND	equ 0014h
WM_SYSCOLORCHANGE	equ 0015h
WM_ENDSESSION	equ 0016h
WM_SHOWWINDOW	equ 0018h
WM_WININICHANGE	equ 001Ah
WM_SETTINGCHANGE	equ WM_WININICHANGE
WM_DEVMODECHANGE	equ 001Bh
WM_ACTIVATEAPP	equ 001Ch
WM_FONTCHANGE	equ 001Dh
WM_TIMECHANGE	equ 001Eh
WM_CANCELMODE	equ 001Fh
WM_SETCURSOR	equ 0020h
WM_MOUSEACTIVATE	equ 0021h
WM_CHILDACTIVATE	equ 0022h
WM_QUEUESYNC	equ 0023h
WM_GETMINMAXINFO	equ 0024h
WM_PAINTICON	equ 0026h
WM_ICONERASEBKGND	equ 0027h
WM_NEXTDLGCTL	equ 0028h
WM_SPOOLERSTATUS	equ 002Ah
WM_DRAWITEM		equ 002Bh
WM_MEASUREITEM	equ 002Ch
WM_DELETEITEM	equ 002Dh
WM_VKEYTOITEM	equ 002Eh
WM_CHARTOITEM	equ 002Fh
WM_SETFONT		equ 0030h
WM_GETFONT		equ 0031h
WM_SETHOTKEY	equ 0032h
WM_GETHOTKEY	equ 0033h
WM_QUERYDRAGICON	equ 0037h
WM_COMPAREITEM	equ 0039h
WM_COMPACTING	equ 0041h
WM_COMMNOTIFY	equ 0044h	; not supported
WM_WINDOWPOSCHANGING equ 0046h
WM_WINDOWPOSCHANGED  equ 0047h
WM_POWER		equ 0048h
WM_COPYDATA		equ 004Ah
WM_CANCELJOURNAL	equ 004Bh
WM_NOTIFY		equ 004Eh
WM_INPUTLANGCHANGEREQUEST equ 0050h
WM_INPUTLANGCHANGE        equ 0051h
WM_TCARD		equ 0052h
WM_HELP		equ 0053h
WM_USERCHANGED	equ 0054h
WM_NOTIFYFORMAT	equ 0055h
WM_CONTEXTMENU	equ 007Bh
WM_STYLECHANGING	equ 007Ch
WM_STYLECHANGED	equ 007Dh
WM_DISPLAYCHANGE	equ 007Eh
WM_GETICON		equ 007Fh
WM_SETICON		equ 0080h
WM_NCCREATE		equ 0081h
WM_NCDESTROY	equ 0082h
WM_NCCALCSIZE	equ 0083h
WM_NCHITTEST	equ 0084h
WM_NCPAINT		equ 0085h
WM_NCACTIVATE	equ 0086h
WM_GETDLGCODE	equ 0087h
WM_NCMOUSEMOVE	equ 00A0h
WM_NCLBUTTONDOWN	equ 00A1h
WM_NCLBUTTONUP	equ 00A2h
WM_NCLBUTTONDBLCLK equ 00A3h
WM_NCRBUTTONDOWN	equ 00A4h
WM_NCRBUTTONUP	equ 00A5h
WM_NCRBUTTONDBLCLK equ 00A6h
WM_NCMBUTTONDOWN	equ 00A7h
WM_NCMBUTTONUP	equ 00A8h
WM_NCMBUTTONDBLCLK equ 00A9h

WM_KEYFIRST		equ 0100h
WM_KEYDOWN		equ 0100h
WM_KEYUP		equ 0101h
WM_CHAR		equ 0102h
WM_DEADCHAR		equ 0103h
WM_SYSKEYDOWN	equ 0104h
WM_SYSKEYUP		equ 0105h
WM_SYSCHAR		equ 0106h
WM_SYSDEADCHAR	equ 0107h
WM_KEYLAST		equ 0108h
WM_IME_STARTCOMPOSITION equ 010Dh
WM_IME_ENDCOMPOSITION   equ 010Eh
WM_IME_COMPOSITION      equ 010Fh
WM_IME_KEYLAST		equ 010Fh
WM_INITDIALOG	equ 0110h
WM_COMMAND		equ 0111h
WM_SYSCOMMAND	equ 0112h
WM_TIMER		equ 0113h
WM_HSCROLL		equ 0114h
WM_VSCROLL		equ 0115h
WM_INITMENU		equ 0116h
WM_INITMENUPOPUP	equ 0117h
WM_MENUSELECT	equ 011Fh
WM_MENUCHAR		equ 0120h
WM_ENTERIDLE	equ 0121h
WM_CTLCOLORMSGBOX	equ 0132h
WM_CTLCOLOREDIT	equ 0133h
WM_CTLCOLORLISTBOX equ 0134h
WM_CTLCOLORBTN	equ 0135h
WM_CTLCOLORDLG	equ 0136h
WM_CTLCOLORSCROLLBAR equ 0137h
WM_CTLCOLORSTATIC	equ 0138h

WM_MOUSEFIRST	equ 0200h
WM_MOUSEMOVE	equ 0200h
WM_LBUTTONDOWN	equ 0201h
WM_LBUTTONUP	equ 0202h
WM_LBUTTONDBLCLK	equ 0203h
WM_RBUTTONDOWN	equ 0204h
WM_RBUTTONUP	equ 0205h
WM_RBUTTONDBLCLK	equ 0206h
WM_MBUTTONDOWN	equ 0207h
WM_MBUTTONUP	equ 0208h
WM_MBUTTONDBLCLK	equ 0209h
WM_MOUSELAST	equ 0209h
WM_PARENTNOTIFY	equ 0210h
WM_ENTERMENULOOP	equ 0211h
WM_EXITMENULOOP	equ 0212h
WM_NEXTMENU		equ 0213h
WM_SIZING		equ 0214h
WM_CAPTURECHANGED	equ 0215h
WM_MOVING		equ 0216h
WM_POWERBROADCAST	equ 0218h
WM_DEVICECHANGE	equ 0219h
WM_MDICREATE	equ 0220h
WM_MDIDESTROY	equ 0221h
WM_MDIACTIVATE	equ 0222h
WM_MDIRESTORE	equ 0223h
WM_MDINEXT		equ 0224h
WM_MDIMAXIMIZE	equ 0225h
WM_MDITILE		equ 0226h
WM_MDICASCADE	equ 0227h
WM_MDIICONARRANGE	equ 0228h
WM_MDIGETACTIVE	equ 0229h
WM_MDISETMENU	equ 0230h
WM_ENTERSIZEMOVE	equ 0231h
WM_EXITSIZEMOVE	equ 0232h
WM_DROPFILES	equ 0233h
WM_MDIREFRESHMENU	equ 0234h
WM_IME_SETCONTEXT	equ 0281h
WM_IME_NOTIFY	equ 0282h
WM_IME_CONTROL	equ 0283h
WM_IME_COMPOSITIONFULL equ 0284h
WM_IME_SELECT	equ 0285h
WM_IME_CHAR		equ 0286h
WM_IME_KEYDOWN	equ 0290h
WM_IME_KEYUP	equ 0291h

WM_CUT		equ 0300h
WM_COPY		equ 0301h
WM_PASTE		equ 0302h
WM_CLEAR		equ 0303h
WM_UNDO		equ 0304h
WM_RENDERFORMAT	equ 0305h
WM_RENDERALLFORMATS equ 0306h
WM_DESTROYCLIPBOARD equ 0307h
WM_DRAWCLIPBOARD	equ 0308h
WM_PAINTCLIPBOARD	equ 0309h
WM_VSCROLLCLIPBOARD equ 030Ah
WM_SIZECLIPBOARD	equ 030Bh
WM_ASKCBFORMATNAME equ 030Ch
WM_CHANGECBCHAIN	equ 030Dh
WM_HSCROLLCLIPBOARD  equ 030Eh
WM_QUERYNEWPALETTE   equ 030Fh
WM_PALETTEISCHANGING equ 0310h
WM_PALETTECHANGED	equ 0311h
WM_HOTKEY		equ 0312h
WM_PRINT		equ 0317h
WM_PRINTCLIENT	equ 0318h

WM_HANDHELDFIRST	equ 0358h
WM_HANDHELDLAST	equ 035Fh
WM_AFXFIRST		equ 0360h
WM_AFXLAST		equ 037Fh
WM_PENWINFIRST	equ 0380h
WM_PENWINLAST	equ 038Fh

WM_USER		equ 0400h
WM_APP		equ 8000h
WM_SHELLNOTIFY 	equ WM_USER+5
;
; Window styles
;
WS_OVERLAPPED	equ (0000h shl 16)
WS_POPUP		equ (8000h shl 16)
WS_CHILD		equ (4000h shl 16)

WS_MINIMIZE		equ (2000h shl 16)
WS_VISIBLE		equ (1000h shl 16)
WS_DISABLED		equ (0800h shl 16)
WS_CLIPSIBLINGS	equ (0400h shl 16)
WS_CLIPCHILDREN	equ (0200h shl 16)
WS_MAXIMIZE		equ (0100h shl 16)

WS_CAPTION		equ (00C0h shl 16)
WS_BORDER		equ (0080h shl 16)
WS_DLGFRAME		equ (0040h shl 16)

WS_VSCROLL		equ (0020h shl 16)
WS_HSCROLL		equ (0010h shl 16)
WS_SYSMENU		equ (0008h shl 16)
WS_THICKFRAME	equ (0004h shl 16)

WS_GROUP		equ (0002h shl 16)
WS_TABSTOP		equ (0001h shl 16)

WS_MINIMIZEBOX	equ (0002h shl 16)
WS_MAXIMIZEBOX	equ (0001h shl 16)

WS_TILED		equ WS_OVERLAPPED
WS_ICONIC		equ WS_MINIMIZE
WS_SIZEBOX		equ WS_THICKFRAME
WS_TILEDWINDOW	equ WS_OVERLAPPEDWINDOW

WS_OVERLAPPEDWINDOW  equ WS_OVERLAPPED or WS_CAPTION or WS_THICKFRAME or \
                         WS_SYSMENU or WS_MINIMIZEBOX or WS_MAXIMIZEBOX
WS_POPUPWINDOW	equ WS_POPUP or WS_BORDER or WS_SYSMENU
WS_CHILDWINDOW	equ WS_CHILD
;
; Extended window styles
;
WS_EX_DLGMODALFRAME	equ 0001h
WS_EX_NOPARENTNOTIFY	equ 0004h
WS_EX_TOPMOST		equ 0008h
WS_EX_ACCEPTFILES		equ 0010h
WS_EX_TRANSPARENT		equ 0020h

WS_EX_MDICHILD		equ 0040h
WS_EX_TOOLWINDOW		equ 0080h
WS_EX_WINDOWEDGE		equ 0100h
WS_EX_CLIENTEDGE		equ 0200h
WS_EX_CONTEXTHELP		equ 0400h

WS_EX_LEFT			equ 0 ; left alignment
WS_EX_RIGHT			equ 1000h
WS_EX_LTRREADING		equ 0 ; left-to-right reading
WS_EX_RTLREADING		equ 2000h
WS_EX_RIGHTSCROLLBAR	equ 0 ; scrollbar on right or bottom
WS_EX_LEFTSCROLLBAR	equ 4000h

WS_EX_CONTROLPARENT	equ 10000h
WS_EX_STATICEDGE		equ 20000h
WS_EX_APPWINDOW		equ 40000h

WS_EX_OVERLAPPEDWINDOW	equ WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE
WS_EX_PALETTEWINDOW	equ WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or \
				    WS_EX_TOPMOST
;
; Stock GDI objects
;
BLACK                                equ 000000h
BLUE                                 equ 0FF0000h
GREEN                                equ 00FF00h
CYAN                                 equ 0FFFF00h
RED                                  equ 0000FFh
MAGENTA                              equ 0FF00FFh
YELLOW                               equ 00FFFFh
WHITE                                equ 0FFFFFFh
GRAY                                 equ 080808h
WHITE_BRUSH         equ  0
LTGRAY_BRUSH        equ  1
GRAY_BRUSH          equ  2
DKGRAY_BRUSH        equ  3
BLACK_BRUSH         equ  4
NULL_BRUSH          equ  5
HOLLOW_BRUSH        equ  5
WHITE_PEN           equ  6
BLACK_PEN           equ  7
NULL_PEN            equ  8
DOT_MARKER          equ  9
OEM_FIXED_FONT      equ 10
ANSI_FIXED_FONT     equ 11
ANSI_VAR_FONT       equ 12
SYSTEM_FONT         equ 13
DEVICE_DEFAULT_FONT equ 14
DEFAULT_PALETTE     equ 15
SYSTEM_FIXED_FONT   equ 16
;
; GDI Raster Ops
;
; Ternary
;
SRCCPY   equ 00CC0020h

; STRUC defines -------------------------------------------
POINT STRUC
	ptX 	dd ?
	ptY 	dd ?
POINT ENDS
;
; RichEdit 2
;
CHARFORMAT2	STRUCT
	cbSize			DWORD		?
	;_wPad1			WORD		?	;  <-----------
	dwMask			DWORD		?
	dwEffects		DWORD		?
	yHeight			DWORD		?
	yOffset			DWORD		?
	crTextColor		DWORD		?
	bCharSet		BYTE		?
	bPitchAndFamily		BYTE		?
	szFaceName		BYTE LF_FACESIZE dup (?)
	;_wPad2			WORD		?	;  <----------- MAYBE REMOVE THIS ???
	wWeight			WORD		?
	sSpacing		DWORD		?
	crBackColor		DWORD		?
	lcid			WORD		?
	dwReserved		DWORD		?
	sStyle			DWORD		?
	wKerning		WORD		?
	bUnderlineType		BYTE		?
	bAnimation		BYTE		?
	bRevAuthor		BYTE		?
	bReserved1		BYTE		?
CHARFORMAT2	ENDS
;
; SEH
;
FLOATING_SAVE_AREA STRUCT
  ControlWord   DWORD      ?
  StatusWord    DWORD      ?
  TagWord       DWORD      ?
  ErrorOffset   DWORD      ?
  ErrorSelector DWORD      ?
  DataOffset    DWORD      ?
  DataSelector  DWORD      ?
  RegisterArea  BYTE	80 dup(?)
  Cr0NpxState   DWORD      ?
FLOATING_SAVE_AREA ENDS

CONTEXT STRUC
  ContextFlags  DWORD      ?
  iDr0          DWORD      ?
  iDr1          DWORD      ?
  iDr2          DWORD      ?
  iDr3          DWORD      ?
  iDr6          DWORD      ?
  iDr7          DWORD      ?
  FloatSave     FLOATING_SAVE_AREA <>
  regGs         DWORD      ?
  regFs         DWORD      ?
  regEs         DWORD      ?
  regDs         DWORD      ?
  regEdi        DWORD      ?
  regEsi        DWORD      ?
  regEbx        DWORD      ?
  regEdx        DWORD      ?
  regEcx        DWORD      ?
  regEax        DWORD      ?
  regEbp        DWORD      ?
  regEip        DWORD      ?
  regCs         DWORD      ?
  regFlag       DWORD      ?
  regEsp        DWORD      ?
  regSs         DWORD      ?
  ExtendedRegisters db MAXIMUM_SUPPORTED_EXTENSION dup(?)
CONTEXT ENDS

IMAGE_EXPORT_DIRECTORY STRUCT
  Characteristics2          DWORD      ?		; NB Char2 NOT Char
  TimeDateStamp             DWORD      ?
  MajorVersion              WORD       ?
  MinorVersion              WORD       ?
  nName                     DWORD      ?
  nBase                     DWORD      ?
  NumberOfFunctions         DWORD      ?
  NumberOfNames             DWORD      ?
  AddressOfFunctions        DWORD      ?
  AddressOfNames            DWORD      ?
  AddressOfNameOrdinals     DWORD      ?
IMAGE_EXPORT_DIRECTORY ENDS
;
; CreateWindowExA/W argument list
;
CREATEARGS STRUC
cwargExstyle	dd ?	; dwExStyle
cwargClass		dd ?	; lpszClass, class name
cwargName		dd ?	; lpszName, window name (caption)
cwargStyle		dd ?	; style
cwargX		dd ?	; x
cwargY		dd ?	; y
cwargCx		dd ?	; cx, width
cwargCy		dd ?	; cy, height
cwargParent		dd ?	; hwndParent
cwargMenu		dd ?	; hMenu
cwargInstance	dd ?	; hInstance
cwargParm		dd ?	; lpCreateParams
CREATEARGS ENDS

;
; Structures not used elsewhere
;
CREATESTRUCT STRUC
csParm	dd ?	; lpCreateParams
csInstance	dd ?	; hInstance
csMenu	dd ?	; hMenu
csParent	dd ?	; hwndParent
csCy		dd ?	; cy, height
csCx		dd ?	; cx, width
csY		dd ?	; y
csX		dd ?	; x
csStyle		dd ?	; style
csName		dd ?	; lpszName, window name (caption)
csClass		dd ?	; lpszClass, class name
csExstyle	dd ?	; dwExStyle
CREATESTRUCT ENDS
;
; VWin32
;
DIOC_REGISTERS struc
	reg_EBX		DWORD ?
	reg_EDX		DWORD ?
	reg_ECX		DWORD ?
	reg_EAX		DWORD ?
	reg_EDI		DWORD ?
	reg_ESI		DWORD ?
	reg_Flags	DWORD ?
DIOC_REGISTERS ends
;
; PE FILE
;
IMAGE_DATA_DIRECTORY STRUC
  VirtualAddress    DWORD      ?
  isize             DWORD      ?
IMAGE_DATA_DIRECTORY ENDS

IMAGE_OPTIONAL_HEADER32 STRUC
  Magic                         WORD       ?
  MajorLinkerVersion            BYTE       ?
  MinorLinkerVersion            BYTE       ?
  SizeOfCode                    DWORD      ?
  SizeOfInitializedData         DWORD      ?
  SizeOfUninitializedData       DWORD      ?
  AddressOfEntryPoint           DWORD      ?
  BaseOfCode                    DWORD      ?
  BaseOfData                    DWORD      ?
  ImageBase                     DWORD      ?
  SectionAlignment              DWORD      ?
  FileAlignment                 DWORD      ?
  MajorOperatingSystemVersion   WORD       ?
  MinorOperatingSystemVersion   WORD       ?
  MajorImageVersion             WORD       ?
  MinorImageVersion             WORD       ?
  MajorSubsystemVersion         WORD       ?
  MinorSubsystemVersion         WORD       ?
  Win32VersionValue             DWORD      ?
  SizeOfImage                   DWORD      ?
  SizeOfHeaders                 DWORD      ?
  CheckSum                      DWORD      ?
  Subsystem                     WORD       ?
  DllCharacteristics            WORD       ?
  SizeOfStackReserve            DWORD      ?
  SizeOfStackCommit             DWORD      ?
  SizeOfHeapReserve             DWORD      ?
  SizeOfHeapCommit              DWORD      ?
  LoaderFlags                   DWORD      ?
  NumberOfRvaAndSizes           DWORD      ?
  DataDirectory                 IMAGE_DATA_DIRECTORY IMAGE_NUMBEROF_DIRECTORY_ENTRIES dup(<>)
IMAGE_OPTIONAL_HEADER32 ENDS

IMAGE_FILE_HEADER STRUC
  Machine               WORD    ?
  NumberOfSections      WORD    ?
  TimeDateStamp         DWORD   ?
  PointerToSymbolTable  DWORD   ?
  NumberOfSymbols       DWORD   ?
  SizeOfOptionalHeader  WORD    ?
  Characteristics       WORD    ?
IMAGE_FILE_HEADER ENDS

IMAGE_NT_HEADERS STRUC
  Signature         DWORD                   ?
  FileHeader        IMAGE_FILE_HEADER       <>
  OptionalHeader    IMAGE_OPTIONAL_HEADER32 <>
IMAGE_NT_HEADERS ENDS

LV_COLUMN STRUC
  imask2	DWORD ?
  fmt           DWORD ?
  lx            DWORD ?
  pszText2	DWORD ?
  cchTextMax2	DWORD ?
  iSubItem2	DWORD ?
  iImage2	DWORD ?
  iOrder        DWORD ?
LV_COLUMN ENDS

LV_ITEM STRUC
  imask         DWORD	?
  iItem         DWORD	?
  iSubItem      DWORD	?
  state         DWORD	?
  stateMask     DWORD	?
  pszText       DWORD	?
  cchTextMax    DWORD	?
  iImage        DWORD	?
  lParam        DWORD	?
  iIndent       DWORD	?
LV_ITEM ENDS

LUID STRUC
	LowPart		DWORD ?
	HighPart	DWORD ?
LUID ENDS

LUID_AND_ATTRIBUTES STRUC
	Luid		LUID <>
	Attributes 	dd ?
LUID_AND_ATTRIBUTES ENDS

MENUITEMINFO STRUC
  cbSize        DWORD      ?
  fMask         DWORD      ?
  fType         DWORD      ?
  fState        DWORD      ?
  wID           DWORD      ?
  hSubMenu      DWORD      ?
  hbmpChecked   DWORD      ?
  hbmpUnchecked DWORD      ?
  dwItemData    DWORD      ?
  dwTypeData    DWORD      ?
  cch           DWORD      ?
MENUITEMINFO ENDS

;
;  Message structure
;
MSGSTRUCT       struc
	msHWND          dd      ?
	msMESSAGE       dd      ?
	msWPARAM        dd      ?
	msLPARAM        dd      ?
	msTIME          dd      ?
	msPT            POINT <?>
MSGSTRUCT       ends
; -- original --
;MSG STRUC
;msgWnd     dd ?		; hwnd
;msgMessage dd ?		; message
;msgWparam  dd ?		; wParam
;msgLparam  dd ?		; lParam
;msgTime    dd ?		; time
;msgPt      POINT ?	; pt
;MSG ENDS

NOTIFYICONDATA STRUC
  cbSize            DWORD      ?
  hWnd              DWORD      ?
  uID               DWORD      ?
  uFlags            DWORD      ?
  uCallbackMessage  DWORD      ?
  hIcon             DWORD      ?
  szTip             BYTE 64 dup (?)
NOTIFYICONDATA ENDS

NMHDR STRUC
    hwndFrom    DWORD ?
    idFrom      DWORD ?
    code        DWORD ?
NMHDR ends

NMHEADER STRUC
nmhFromWnd    DD ?    ; handle of control that sent WM_NOTIFY
nmhFromID     DD ?    ; ID of control that sent WM_NOTIFY
nmhNotifyCode DD ?    ; NM or user defined code
NMHEADER ENDS

OPENFILENAME STRUC
  lStructSize        DWORD      ?
  hWndOwner          DWORD      ?
  hInstance          DWORD      ?
  lpstrFilter        DWORD      ?
  lpstrCustomFilter  DWORD      ?
  nMaxCustFilter     DWORD      ?
  nFilterIndex       DWORD      ?
  lpstrFile          DWORD      ?
  nMaxFile           DWORD      ?
  lpstrFileTitle     DWORD      ?
  nMaxFileTitle      DWORD      ?
  lpstrInitialDir    DWORD      ?
  lpstrTitle         DWORD      ?
  Flags              DWORD      ?
  nFileOffset         WORD      ?
  nFileExtension      WORD      ?
  lpstrDefExt        DWORD      ?
  lCustData          DWORD      ?
  lpfnHook           DWORD      ?
  lpTemplateName     DWORD      ?
OPENFILENAME ENDS

OFNHookProcOldStyle STRUC
	hdlg		dword ?
	uiMsg		dword ?
	wParam		dword ?
	lParam2		dword ?
OFNHookProcOldStyle ENDS

OSVERSIONINFO STRUC
  dwOSVersionInfoSize   DWORD      ?
  dwMajorVersion        DWORD      ?
  dwMinorVersion        DWORD      ?
  dwBuildNumber         DWORD      ?
  dwPlatformId          DWORD      ?
  szCSDVersion          BYTE 128 dup (?)
OSVERSIONINFO ENDS

PAINTSTRUCT STRUC
psDC        dd ?			; hdc
psErase     dd ?			; fErase
psRect      dd ?			; rcPaint
; the following reserved by Windows
psRestore   dd ?			; fRestore
psIncUpdate dd ?			; fIncUpdate
psRGB       db 16 dup(?)		; rgbReserved
PAINTSTRUCT ENDS

RECT STRUC
rcLeft   dd ?
rcTop    dd ?
rcRight  dd ?
rcBottom dd ?
RECT ENDS

SYSTEMTIME STRUC
  wYear             WORD      ?
  wMonth            WORD      ?
  wDayOfWeek        WORD      ?
  wDay              WORD      ?
  wHour             WORD      ?
  wMinute           WORD      ?
  wSecond           WORD      ?
  wMilliseconds     WORD      ?
SYSTEMTIME ENDS

TC_ITEM STRUC
  imask             	DWORD      ?
  lpReserved1       	DWORD      ?
  lpReserved2       	DWORD      ?
  pszTextTC		DWORD      ?
  cchTextMaxTC        	DWORD      ?
  iImageTC            	DWORD      ?
  lParamTC            	DWORD      ?
TC_ITEM ENDS

TOKEN_PRIVILEGES STRUC
  PrivilegeCount    DWORD      ?
  Privileges        LUID_AND_ATTRIBUTES ANYSIZE_ARRAY dup(<>)
TOKEN_PRIVILEGES ENDS

WNDCLASS struc
        clsStyle        dd      ?       ; class style
        clsLpfnWndProc  dd      ?
        clsCbClsExtra   dd      ?
        clsCbWndExtra   dd      ?
        clsHInstance    dd      ?       ; instance handle
        clsHIcon        dd      ?       ; class icon handle
        clsHCursor      dd      ?       ; class cursor handle
        clsHbrBackground dd     ?       ; class background brush
        clsLpszMenuName dd      ?       ; menu name
        clsLpszClassName dd     ?       ; far ptr to class name
WNDCLASS ends
; -- original --
;WNDCLASS STRUC
;wcStyle           dd ?    ; style
;wcWndProc         dd ?    ; lpfnWndProc
;wcClsExtra        dd ?    ; cbClsExtra
;wcWndExtra        dd ?    ; cbWndExtra
;wcInstance        dd ?    ; hInstance
;wcIcon            dd ?    ; hIcon
;wcCursor          dd ?    ; hCursor
;wcBackgroundBrush dd ?    ; hbrBackground
;wcMenuName        dd ?    ; lpszMenuName
;wcClassName       dd ?    ; lpszClassName
;WNDCLASS ENDS

WNDCLASSEX STRUC
wcxSize		 dd ?	   ; cbSize
wcxStyle           dd ?    ; style
wcxWndProc         dd ?    ; lpfnWndProc
wcxClsExtra        dd ?    ; cbClsExtra
wcxWndExtra        dd ?    ; cbWndExtra
wcxInstance        dd ?    ; hInstance
wcxIcon            dd ?    ; hIcon
wcxCursor          dd ?    ; hCursor
wcxBackgroundBrush dd ?    ; hbrBackground
wcxMenuName        dd ?    ; lpszMenuName
wcxClassName       dd ?    ; lpszClassName
wcxSmallIcon	 dd ?	   ; hIconSm
WNDCLASSEX ENDS

S_UN_B struct
  s_b1 BYTE ?
  s_b2 BYTE ?
  s_b3 BYTE ?
  s_b4 BYTE ?
S_UN_B ends

S_UN_W struct 
  s_w1 WORD ?
  s_w2 WORD ?
S_UN_W ends

ADDRESS_UNION union 
   S_un_b S_UN_B <>
   S_un_w S_UN_W <>
   S_addr DWORD ?
ADDRESS_UNION ends

in_addr struct
  S_un ADDRESS_UNION <>
in_addr ends

WSADATA struct
  wVersion      WORD      	?
  wHighVersion  WORD      	?
  szDescription BYTE 	WSADESCRIPTION_LEN +1 dup (?)
  szSystemStatus BYTE 	WSASYS_STATUS_LEN +1 dup (?)
  iMaxSockets   WORD      	?
  iMaxUdpDg     WORD      	?
  lpVendorInfo  DWORD		?
WSADATA ends

hostent STRUCT
  h_name      DWORD      ?
  h_alias     DWORD      ?
  h_addr      WORD       ?
  h_len       WORD       ?
  h_list      DWORD      ?
hostent ENDS

sockaddr STRUCT
  sa_family     WORD      ?
  sa_data       BYTE 14 dup(?)
sockaddr ENDS

; Selection of API function names when there are two versions.
;
; For the three core Win95 DLL's 
; KERNEL32, USER32, and GDI32

; Kernel32

ifdef UNICODE

AddAtom	equ AddAtomW
BeginUpdateResource	equ BeginUpdateResourceW
BuildCommDCB	equ BuildCommDCBW
BuildCommDCBAndTimeouts	equ BuildCommDCBAndTimeoutsW
CallNamedPipe	equ CallNamedPipeW
CommConfigDialog	equ CommConfigDialogW
CompareString	equ CompareStringW
CopyFile	equ CopyFileW
CreateDirectory	equ CreateDirectoryW
CreateDirectoryEx	equ CreateDirectoryExW
CreateEvent	equ CreateEventW
CreateFile	equ CreateFileW
CreateFileMapping	equ CreateFileMappingW
CreateMailslot	equ CreateMailslotW
CreateMutex	equ CreateMutexW
CreateNamedPipe	equ CreateNamedPipeW
CreateProcess	equ CreateProcessW
CreateSemaphore	equ CreateSemaphoreW
DefineDosDevice	equ DefineDosDeviceW
DeleteFile	equ DeleteFileW
EndUpdateResource	equ EndUpdateResourceW
EnumCalendarInfo	equ EnumCalendarInfoW
EnumDateFormats	equ EnumDateFormatsW
EnumResourceLanguages	equ EnumResourceLanguagesW
EnumResourceNames	equ EnumResourceNamesW
EnumResourceTypes	equ EnumResourceTypesW
EnumSystemCodePages	equ EnumSystemCodePagesW
EnumSystemLocales	equ EnumSystemLocalesW
EnumTimeFormats	equ EnumTimeFormatsW
ExpandEnvironmentStrings	equ ExpandEnvironmentStringsW
FatalAppExit	equ FatalAppExitW
FillConsoleOutputCharacter	equ FillConsoleOutputCharacterW
FindAtom	equ FindAtomW
FindFirstChangeNotification	equ FindFirstChangeNotificationW
FindFirstFile	equ FindFirstFileW
FindNextFile	equ FindNextFileW
FindResourceEx	equ FindResourceExW
FindResource	equ FindResourceW
FoldString		equ FoldStringW
FormatMessage	equ FormatMessageW
FreeEnvironmentStrings	equ FreeEnvironmentStringsW
GetAtomName	equ GetAtomNameW
GetBinaryType	equ GetBinaryTypeW
GetCommandLine	equ GetCommandLineW
GetCompressedFileSize	equ GetCompressedFileSizeW
GetComputerName	equ GetComputerNameW
GetConsoleTitle	equ GetConsoleTitleW
GetCurrencyFormat	equ GetCurrencyFormatW
GetCurrentDirectory	equ GetCurrentDirectoryW
GetDateFormat	equ GetDateFormatW
GetDefaultCommConfig	equ GetDefaultCommConfigW
GetDiskFreeSpace	equ GetDiskFreeSpaceW
GetDriveType	equ GetDriveTypeW
GetEnvironmentStrings	equ GetEnvironmentStringsW
GetEnvironmentVariable	equ GetEnvironmentVariableW
GetFileAttributes	equ GetFileAttributesW
GetFullPathName	equ GetFullPathNameW
GetLocaleInfo	equ GetLocaleInfoW
GetLogicalDriveStrings	equ GetLogicalDriveStringsW
GetModuleFileName	equ GetModuleFileNameW
GetModuleHandle	equ GetModuleHandleW
GetNamedPipeHandleState	equ GetNamedPipeHandleStateW
GetNumberFormat	equ GetNumberFormatW
GetPrivateProfileInt	equ GetPrivateProfileIntW
GetPrivateProfileSectionNames	equ GetPrivateProfileSectionNamesW
GetPrivateProfileSection	equ GetPrivateProfileSectionW
GetPrivateProfileString	equ GetPrivateProfileStringW
GetPrivateProfileStruct	equ GetPrivateProfileStructW
GetProfileInt	equ GetProfileIntW
GetProfileSection	equ GetProfileSectionW
GetProfileString	equ GetProfileStringW
GetShortPathName	equ GetShortPathNameW
GetStartupInfo	equ GetStartupInfoW
GetStringTypeEx	equ GetStringTypeExW
GetStringType	equ GetStringTypeW
GetSystemDirectory	equ GetSystemDirectoryW
GetTempFileName	equ GetTempFileNameW
GetTempPath	equ GetTempPathW
GetTimeFormat	equ GetTimeFormatW
GetVersionEx	equ GetVersionExW
GetVolumeInformation	equ GetVolumeInformationW
GetWindowsDirectory	equ GetWindowsDirectoryW
GlobalAddAtom	equ GlobalAddAtomW
GlobalFindAtom	equ GlobalFindAtomW
GlobalGetAtomName	equ GlobalGetAtomNameW
IsBadStringPtr	equ IsBadStringPtrW
LCMapString	equ LCMapStringW
LoadLibraryEx	equ LoadLibraryExW
LoadLibrary	equ LoadLibraryW
MoveFileEx	equ MoveFileExW
MoveFile	equ MoveFileW
OpenEvent	equ OpenEventW
OpenFileMapping	equ OpenFileMappingW
OpenMutex	equ OpenMutexW
OpenSemaphore	equ OpenSemaphoreW
OutputDebugString	equ OutputDebugStringW
PeekConsoleInput	equ PeekConsoleInputW
QueryDosDevice	equ QueryDosDeviceW
ReadConsoleInput	equ ReadConsoleInputW
ReadConsoleOutputCharacter	equ ReadConsoleOutputCharacterW
ReadConsoleOutput	equ ReadConsoleOutputW
ReadConsole	equ ReadConsoleW
RemoveDirectory	equ RemoveDirectoryW
ScrollConsoleScreenBuffer	equ ScrollConsoleScreenBufferW
SearchPath	equ SearchPathW
SetComputerName	equ SetComputerNameW
SetConsoleTitle	equ SetConsoleTitleW
SetCurrentDirectory	equ SetCurrentDirectoryW
SetDefaultCommConfig	equ SetDefaultCommConfigW
SetEnvironmentVariable	equ SetEnvironmentVariableW
SetFileAttributes	equ SetFileAttributesW
SetLocaleInfo	equ SetLocaleInfoW
SetVolumeLabel	equ SetVolumeLabelW
UpdateResource	equ UpdateResourceW
VerLanguageName	equ VerLanguageNameW
WaitNamedPipe	equ WaitNamedPipeW
WriteConsoleInput	equ WriteConsoleInputW
WriteConsoleOutputCharacter	equ WriteConsoleOutputCharacterW
WriteConsoleOutput	equ WriteConsoleOutputW
WriteConsole	equ WriteConsoleW
WritePrivateProfileSection	equ WritePrivateProfileSectionW
WritePrivateProfileString	equ WritePrivateProfileStringW
WritePrivateProfileStruct	equ WritePrivateProfileStructW
WriteProfileSection	equ WriteProfileSectionW
WriteProfileString	equ WriteProfileStringW
lstrcat	equ lstrcatW
lstrcmp	equ lstrcmpW
lstrcmpi	equ lstrcmpiW
lstrcpy	equ lstrcpyW
lstrcpyn	equ lstrcpynW
lstrlen	equ lstrlenW

else

AddAtom	equ AddAtomA
BeginUpdateResource	equ BeginUpdateResourceA
BuildCommDCB	equ BuildCommDCBA
BuildCommDCBAndTimeouts	equ BuildCommDCBAndTimeoutsA
CallNamedPipe	equ CallNamedPipeA
CommConfigDialog	equ CommConfigDialogA
CompareString	equ CompareStringA
CopyFile	equ CopyFileA
CreateDirectory	equ CreateDirectoryA
CreateDirectoryEx	equ CreateDirectoryExA
CreateEvent	equ CreateEventA
CreateFile	equ CreateFileA
CreateFileMapping	equ CreateFileMappingA
CreateMailslot	equ CreateMailslotA
CreateMutex	equ CreateMutexA
CreateNamedPipe	equ CreateNamedPipeA
CreateProcess	equ CreateProcessA
CreateSemaphore	equ CreateSemaphoreA
DefineDosDevice	equ DefineDosDeviceA
DeleteFile	equ DeleteFileA
EndUpdateResource	equ EndUpdateResourceA
EnumCalendarInfo	equ EnumCalendarInfoA
EnumDateFormats	equ EnumDateFormatsA
EnumResourceLanguages	equ EnumResourceLanguagesA
EnumResourceNames	equ EnumResourceNamesA
EnumResourceTypes	equ EnumResourceTypesA
EnumSystemCodePages	equ EnumSystemCodePagesA
EnumSystemLocales	equ EnumSystemLocalesA
EnumTimeFormats	equ EnumTimeFormatsA
ExpandEnvironmentStrings	equ ExpandEnvironmentStringsA
FatalAppExit	equ FatalAppExitA
FillConsoleOutputCharacter	equ FillConsoleOutputCharacterA
FindAtom	equ FindAtomA
FindFirstChangeNotification	equ FindFirstChangeNotificationA
FindFirstFile	equ FindFirstFileA
FindNextFile	equ FindNextFileA
FindResource	equ FindResourceA
FindResourceEx	equ FindResourceExA
FoldString	equ FoldStringA
FormatMessage	equ FormatMessageA
FreeEnvironmentStrings	equ FreeEnvironmentStringsA
GetAtomName	equ GetAtomNameA
GetBinaryType	equ GetBinaryTypeA
GetCommandLine	equ GetCommandLineA
GetCompressedFileSize	equ GetCompressedFileSizeA
GetComputerName	equ GetComputerNameA
GetConsoleTitle	equ GetConsoleTitleA
GetCurrencyFormat	equ GetCurrencyFormatA
GetCurrentDirectory	equ GetCurrentDirectoryA
GetDateFormat	equ GetDateFormatA
GetDefaultCommConfig	equ GetDefaultCommConfigA
GetDiskFreeSpace	equ GetDiskFreeSpaceA
GetDriveType	equ GetDriveTypeA
GetEnvironmentStrings	equ GetEnvironmentStringsA
GetEnvironmentVariable	equ GetEnvironmentVariableA
GetFileAttributes	equ GetFileAttributesA
GetFullPathName	equ GetFullPathNameA
GetLocaleInfo	equ GetLocaleInfoA
GetLogicalDriveStrings	equ GetLogicalDriveStringsA
GetModuleFileName	equ GetModuleFileNameA
GetModuleHandle	equ GetModuleHandleA
GetNamedPipeHandleState	equ GetNamedPipeHandleStateA
GetNumberFormat	equ GetNumberFormatA
GetPrivateProfileInt	equ GetPrivateProfileIntA
GetPrivateProfileSection	equ GetPrivateProfileSectionA
GetPrivateProfileSectionNames	equ GetPrivateProfileSectionNamesA
GetPrivateProfileString	equ GetPrivateProfileStringA
GetPrivateProfileStruct	equ GetPrivateProfileStructA
GetProfileInt	equ GetProfileIntA
GetProfileSection	equ GetProfileSectionA
GetProfileString	equ GetProfileStringA
GetShortPathName	equ GetShortPathNameA
GetStartupInfo	equ GetStartupInfoA
GetStringType	equ GetStringTypeA
GetStringTypeEx	equ GetStringTypeExA
GetSystemDirectory	equ GetSystemDirectoryA
GetTempFileName	equ GetTempFileNameA
GetTempPath	equ GetTempPathA
GetTimeFormat	equ GetTimeFormatA
GetVersionEx	equ GetVersionExA
GetVolumeInformation	equ GetVolumeInformationA
GetWindowsDirectory	equ GetWindowsDirectoryA
GlobalAddAtom	equ GlobalAddAtomA
GlobalFindAtom	equ GlobalFindAtomA
GlobalGetAtomName	equ GlobalGetAtomNameA
IsBadStringPtr	equ IsBadStringPtrA
LCMapString	equ LCMapStringA
LoadLibrary	equ LoadLibraryA
LoadLibraryEx	equ LoadLibraryExA
MoveFile	equ MoveFileA
MoveFileEx	equ MoveFileExA
OpenEvent	equ OpenEventA
OpenFileMapping	equ OpenFileMappingA
OpenMutex	equ OpenMutexA
OpenSemaphore	equ OpenSemaphoreA
OutputDebugString	equ OutputDebugStringA
PeekConsoleInput	equ PeekConsoleInputA
QueryDosDevice	equ QueryDosDeviceA
ReadConsole	equ ReadConsoleA
ReadConsoleInput	equ ReadConsoleInputA
ReadConsoleOutput	equ ReadConsoleOutputA
ReadConsoleOutputCharacter	equ ReadConsoleOutputCharacterA
RemoveDirectory	equ RemoveDirectoryA
ScrollConsoleScreenBuffer	equ ScrollConsoleScreenBufferA
SearchPath	equ SearchPathA
SetComputerName	equ SetComputerNameA
SetConsoleTitle	equ SetConsoleTitleA
SetCurrentDirectory	equ SetCurrentDirectoryA
SetDefaultCommConfig	equ SetDefaultCommConfigA
SetEnvironmentVariable	equ SetEnvironmentVariableA
SetFileAttributes	equ SetFileAttributesA
SetLocaleInfo	equ SetLocaleInfoA
SetVolumeLabel	equ SetVolumeLabelA
UpdateResource	equ UpdateResourceA
VerLanguageName	equ VerLanguageNameA
WaitNamedPipe	equ WaitNamedPipeA
WriteConsole	equ WriteConsoleA
WriteConsoleInput	equ WriteConsoleInputA
WriteConsoleOutput	equ WriteConsoleOutputA
WriteConsoleOutputCharacter	equ WriteConsoleOutputCharacterA
WritePrivateProfileSection	equ WritePrivateProfileSectionA
WritePrivateProfileString	equ WritePrivateProfileStringA
WritePrivateProfileStruct	equ WritePrivateProfileStructA
WriteProfileSection	equ WriteProfileSectionA
WriteProfileString	equ WriteProfileStringA
lstrcat	equ lstrcatA
lstrcmp	equ lstrcmpA
lstrcmpi	equ lstrcmpiA
lstrcpy	equ lstrcpyA
lstrcpyn	equ lstrcpynA
lstrlen	equ lstrlenA

endif

; User32

ifdef UNICODE

AppendMenu	equ AppendMenuW
CallMsgFilter	equ CallMsgFilterW
CallWindowProc	equ CallWindowProcW
ChangeDisplaySettings	equ ChangeDisplaySettingsW
ChangeMenu	equ ChangeMenuW
CharLowerBuff	equ CharLowerBuffW
CharLower	equ CharLowerW
CharNextEx	equ CharNextExW
CharNext	equ CharNextW
CharPrevEx	equ CharPrevExW
CharPrev	equ CharPrevW
CharToOemBuff	equ CharToOemBuffW
CharToOem	equ CharToOemW
CharUpperBuff	equ CharUpperBuffW
CharUpper	equ CharUpperW
CopyAcceleratorTable	equ CopyAcceleratorTableW
CreateAcceleratorTable	equ CreateAcceleratorTableW
CreateDesktop	equ CreateDesktopW
CreateDialogIndirectParam	equ CreateDialogIndirectParamW
CreateDialogParam	equ CreateDialogParamW
CreateMDIWindow	equ CreateMDIWindowW
CreateWindowEx	equ CreateWindowExW
CreateWindowStation	equ CreateWindowStationW
DdeCreateStringHandle	equ DdeCreateStringHandleW
DdeInitialize	equ DdeInitializeW
DdeQueryString	equ DdeQueryStringW
DefDlgProc	equ DefDlgProcW
DefFrameProc	equ DefFrameProcW
DefMDIChildProc	equ DefMDIChildProcW
DefWindowProc	equ DefWindowProcW
DialogBoxIndirectParam	equ DialogBoxIndirectParamW
DialogBoxParam	equ DialogBoxParamW
DispatchMessage	equ DispatchMessageW
DlgDirListComboBox	equ DlgDirListComboBoxW
DlgDirList	equ DlgDirListW
DlgDirSelectComboBoxEx	equ DlgDirSelectComboBoxExW
DlgDirSelectEx	equ DlgDirSelectExW
DrawCaptionTemp	equ DrawCaptionTempW
DrawState	equ DrawStateW
DrawTextEx	equ DrawTextExW
DrawText	equ DrawTextW
EnumDesktops	equ EnumDesktopsW
EnumDisplaySettings	equ EnumDisplaySettingsW
EnumPropsEx	equ EnumPropsExW
EnumProps	equ EnumPropsW
EnumWindowStations	equ EnumWindowStationsW
FindWindowEx	equ FindWindowExW
FindWindow	equ FindWindowW
GetClassInfoEx	equ GetClassInfoExW
GetClassIngo	equ GetClassInfoW
GetClassLong	equ GetClassLongW
GetClassName	equ GetClassNameW
GetClipboardFormatName	equ GetClipboardFormatNameW
GetDlgItemText	equ GetDlgItemTextW
GetKeyNameText	equ GetKeyNameTextW
GetKeyboardLayoutName	equ GetKeyboardLayoutNameW
GetMenuItemInfo	equ GetMenuItemInfoW
GetMenuString	equ GetMenuStringW
GetMessage	equ GetMessageW
GetProp	equ GetPropW
GetTabbedTextExtent	equ GetTabbedTextExtentW
GetUserObjectInformation	equ GetUserObjectInformationW
GetWindowLong	equ GetWindowLongW
GetWindowTextLength	equ GetWindowTextLengthW
GetWindowText	equ GetWindowTextW
GrayString	equ GrayStringW
InsertMenuItem	equ InsertMenuItemW
InsertMenu	equ InsertMenuW
IsCharAlphaNumeric	equ IsCharAlphaNumericW
IsCharAlpha	equ IsCharAlphaW
IsCharLower	equ IsCharLowerW
IsCharUpper	equ IsCharUpperW
IsDialogMessage	equ IsDialogMessageW
LoadAccelerators	equ LoadAcceleratorsW
LoadBitmap	equ LoadBitmapW
LoadCursorFromFile	equ LoadCursorFromFileW
LoadCursor	equ LoadCursorW
LoadIcon	equ LoadIconW
LoadImage	equ LoadImageW
LoadKeyboardLayout	equ LoadKeyboardLayoutW
LoadMenuIndirect	equ LoadMenuIndirectW
LoadMenu	equ LoadMenuW
LoadString	equ LoadStringW
MapVirtualKeyEx	equ MapVirtualKeyExW
MapVirtualKey	equ MapVirtualKeyW
MessageBoxEx	equ MessageBoxExW
MessageBoxIndirect	equ MessageBoxIndirectW
MessageBox	equ MessageBoxW
ModifyMenu	equ ModifyMenuW
OemToCharBuff	equ OemToCharBuffW
OemToChar	equ OemToCharW
OpenDesktop	equ OpenDesktopW
OpenWindowStation	equ OpenWindowStationW
PeekMessage	equ PeekMessageW
PostMessage	equ PostMessageW
PostThreadMessage	equ PostThreadMessageW
RegisterClassEx	equ RegisterClassExW
RegisterClass	equ RegisterClassW
RegisterClipboardFormat	equ RegisterClipboardFormatW
RegisterWindowMessage	equ RegisterWindowMessageW
RemoveProp	equ RemovePropW
SendDlgItemMessage	equ SendDlgItemMessageW
SendMessageCallback	equ SendMessageCallbackW
SendMessageTimeout	equ SendMessageTimeoutW
SendMessage	equ SendMessageW
SendNotifyMessage	equ SendNotifyMessageW
SetClassLong	equ SetClassLongW
SetDlgItemText	equ SetDlgItemTextW
SetMenuItemInfo	equ SetMenuItemInfoW
SetProp	equ SetPropW
SetUserObjectInformation	equ SetUserObjectInformationW
SetWindowLong	equ SetWindowLongW
SetWindowText	equ SetWindowTextW
SetWindowsHookEx	equ SetWindowsHookExW
SetWindowsHook	equ SetWindowsHookW
SystemParametersInfo	equ SystemParametersInfoW
TabbedTextOut	equ TabbedTextOutW
TranslateAccelerator	equ TranslateAcceleratorW
UnregisterClass	equ UnregisterClassW
VkKeyScanEx	equ VkKeyScanExW
VkKeyScan	equ VkKeyScanW
WinHelp	equ WinHelpW
wsprintf	equ wsprintfW
wvsprintf	equ wvsprintfW

else

AppendMenu	equ AppendMenuA
CallMsgFilter	equ CallMsgFilterA
CallWindowProc	equ CallWindowProcA
ChangeDisplaySettings	equ ChangeDisplaySettingsA
ChangeMenu	equ ChangeMenuA
CharLower	equ CharLowerA
CharLowerBuff	equ CharLowerBuffA
CharNext	equ CharNextA
CharNextEx	equ CharNextExA
CharPrev	equ CharPrevA
CharPrevEx	equ CharPrevExA
CharToOem	equ CharToOemA
CharToOemBuff	equ CharToOemBuffA
CharUpper	equ CharUpperA
CharUpperBuff	equ CharUpperBuffA
CopyAcceleratorTable	equ CopyAcceleratorTableA
CreateAcceleratorTable	equ CreateAcceleratorTableA
CreateDesktop	equ CreateDesktopA
CreateDialogIndirectParam	equ CreateDialogIndirectParamA
CreateDialogParam	equ CreateDialogParamA
CreateMDIWindow	equ CreateMDIWindowA
CreateWindowEx	equ CreateWindowExA
CreateWindowStation	equ CreateWindowStationA
DdeCreateStringHandle	equ DdeCreateStringHandleA
DdeInitialize	equ DdeInitializeA
DdeQueryString	equ DdeQueryStringA
DefDlgProc	equ DefDlgProcA
DefFrameProc	equ DefFrameProcA
DefMDIChildProc	equ DefMDIChildProcA
DefWindowProc	equ DefWindowProcA
DialogBoxIndirectParam	equ DialogBoxIndirectParamA
DialogBoxParam	equ DialogBoxParamA
DispatchMessage	equ DispatchMessageA
DlgDirList	equ DlgDirListA
DlgDirListComboBox	equ DlgDirListComboBoxA
DlgDirSelectComboBoxEx	equ DlgDirSelectComboBoxExA
DlgDirSelectEx	equ DlgDirSelectExA
DrawCaptionTemp	equ DrawCaptionTempA
DrawState	equ DrawStateA
DrawText	equ DrawTextA
DrawTextEx	equ DrawTextExA
EnumDesktops	equ EnumDesktopsA
EnumDisplaySettings	equ EnumDisplaySettingsA
EnumProps	equ EnumPropsA
EnumPropsEx	equ EnumPropsExA
EnumWindowStations	equ EnumWindowStationsA
FindWindow	equ FindWindowA
FindWindowEx	equ FindWindowExA
GetClassInfo	equ GetClassInfoA
GetClassInfoEx	equ GetClassInfoExA
GetClassLong	equ GetClassLongA
GetClassName	equ GetClassNameA
GetClipboardFormatName	equ GetClipboardFormatNameA
GetDlgItemText	equ GetDlgItemTextA
GetKeyNameText	equ GetKeyNameTextA
GetKeyboardLayoutName	equ GetKeyboardLayoutNameA
GetMenuItemInfo	equ GetMenuItemInfoA
GetMenuString	equ GetMenuStringA
GetMessage	equ GetMessageA
GetProp	equ GetPropA
GetTabbedTextExtent	equ GetTabbedTextExtentA
GetUserObjectInformation	equ GetUserObjectInformationA
GetWindowLong	equ GetWindowLongA
GetWindowText	equ GetWindowTextA
GetWindowTextLength	equ GetWindowTextLengthA
GrayString	equ GrayStringA
InsertMenu	equ InsertMenuA
InsertMenuItem	equ InsertMenuItemA
IsCharAlpha	equ IsCharAlphaA
IsCharAlphaNumeric	equ IsCharAlphaNumericA
IsCharLower	equ IsCharLowerA
IsCharUpper	equ IsCharUpperA
IsDialogMessage	equ IsDialogMessageA
LoadAccelerators	equ LoadAcceleratorsA
LoadBitmap	equ LoadBitmapA
LoadCursor	equ LoadCursorA
LoadCursorFromFile	equ LoadCursorFromFileA
LoadIcon	equ LoadIconA
LoadImage	equ LoadImageA
LoadKeyboardLayout	equ LoadKeyboardLayoutA
LoadMenu	equ LoadMenuA
LoadMenuIndirect	equ LoadMenuIndirectA
LoadString	equ LoadStringA
MapVirtualKey	equ MapVirtualKeyA
MapVirtualKeyEx	equ MapVirtualKeyExA
MessageBox	equ MessageBoxA
MessageBoxEx	equ MessageBoxExA
MessageBoxIndirect	equ MessageBoxIndirectA
ModifyMenu	equ ModifyMenuA
OemToChar	equ OemToCharA
OemToCharBuff	equ OemToCharBuffA
OpenDesktop	equ OpenDesktopA
OpenWindowStation	equ OpenWindowStationA
PeekMessage	equ PeekMessageA
PostMessage	equ PostMessageA
PostThreadMessage	equ PostThreadMessageA
RegisterClass	equ RegisterClassA
RegisterClassEx	equ RegisterClassExA
RegisterClipboardFormat	equ RegisterClipboardFormatA
RegisterWindowMessage	equ RegisterWindowMessageA
RemoveProp	equ RemovePropA
SendDlgItemMessage	equ SendDlgItemMessageA
SendMessage	equ SendMessageA
SendMessageCallback	equ SendMessageCallbackA
SendMessageTimeout	equ SendMessageTimeoutA
SendNotifyMessage	equ SendNotifyMessageA
SetClassLong	equ SetClassLongA
SetDlgItemText	equ SetDlgItemTextA
SetMenuItemInfo	equ SetMenuItemInfoA
SetProp	equ SetPropA
SetUserObjectInformation	equ SetUserObjectInformationA
SetWindowLong	equ SetWindowLongA
SetWindowText	equ SetWindowTextA
SetWindowsHook	equ SetWindowsHookA
SetWindowsHookEx	equ SetWindowsHookExA
SystemParametersInfo	equ SystemParametersInfoA
TabbedTextOut	equ TabbedTextOutA
TranslateAccelerator	equ TranslateAcceleratorA
UnregisterClass	equ UnregisterClassA
VkKeyScan		equ VkKeyScanA
VkKeyScanEx		equ VkKeyScanExA
WinHelp		equ WinHelpA
wsprintf		equ wsprintfA
wvsprintf		equ wvsprintfA

endif

wsprintfA	PROCDESC	WINAPI	:DWORD, :DWORD, :DWORD

; GDI32

ifdef UNICODE

AddFontResource	equ AddFontResourceW
CopyEnhMetaFile	equ CopyEnhMetaFileW
CopyMetaFile	equ CopyMetaFileW
CreateColorSpace	equ CreateColorSpaceW
CreateDC	equ CreateDCW
CreateEnhMetaFile	equ CreateEnhMetaFileW
CreateFontIndirect	equ CreateFontIndirectW
CreateFont	equ CreateFontW
CreateIC	equ CreateICW
CreateMetaFile	equ CreateMetaFileW
CreateScalableFontResource	equ CreateScalableFontResourceW
DeviceCapabilitiesEx	equ DeviceCapabilitiesExW
EnumFontFamiliesEx	equ EnumFontFamiliesExW
EnumFontFamilies	equ EnumFontFamiliesW
EnumFonts	equ EnumFontsW
EnumICMProfiles	equ EnumICMProfilesW
ExtTextOut	equ ExtTextOutW
GetCharABCWidthsFloat	equ GetCharABCWidthsFloatW
GetCharABCWidths	equ GetCharABCWidthsW
GetCharWidth32	equ GetCharWidth32W
GetCharWidthFloat	equ GetCharWidthFloatW
GetCharWidth	equ GetCharWidthW
GetCharacterPlacement	equ GetCharacterPlacementW
GetEnhMetaFileDescription	equ GetEnhMetaFileDescriptionW
GetEnhMetaFile	equ GetEnhMetaFileW
GetGlyphOutline	equ GetGlyphOutlineW
GetICMProfile	equ GetICMProfileW
GetKerningPairs	equ GetKerningPairsW
GetLogColorSpace	equ GetLogColorSpaceW
GetMetaFile	equ GetMetaFileW
GetObject	equ GetObjectW
GetOutlineTextMetrics	equ GetOutlineTextMetricsW
GetTextExtentExPoint	equ GetTextExtentExPointW
GetTextExtentPoint32	equ GetTextExtentPoint32W
GetTextExtentPoint	equ GetTextExtentPointW
GetTextFace	equ GetTextFaceW
GetTextMetrics	equ GetTextMetricsW
PolyTextOut	equ PolyTextOutW
RemoveFontResource	equ RemoveFontResourceW
ResetDC	equ ResetDCW
SetICMProfile	equ SetICMProfileW
StartDoc	equ StartDocW
TextOut	equ TextOutW
UpdateICMRegKey	equ UpdateICMRegKeyW

else

AddFontResource	equ AddFontResourceA
CopyEnhMetaFile	equ CopyEnhMetaFileA
CopyMetaFile	equ CopyMetaFileA
CreateColorSpace	equ CreateColorSpaceA
CreateDC	equ CreateDCA
CreateEnhMetaFile	equ CreateEnhMetaFileA
CreateFont	equ CreateFontA
CreateFontIndirect	equ CreateFontIndirectA
CreateIC	equ CreateICA
CreateMetaFile	equ CreateMetaFileA
CreateScalableFontResource	equ CreateScalableFontResourceA
DeviceCapabilitiesEx	equ DeviceCapabilitiesExA
EnumFontFamilies	equ EnumFontFamiliesA
EnumFontFamilies	equ EnumFontFamiliesExA
EnumFonts	equ EnumFontsA
EnumICMProfiles	equ EnumICMProfilesA
ExtTextOut	equ ExtTextOutA
GetCharABCWidths	equ GetCharABCWidthsA
GetCharABCWidthsFloat	equ GetCharABCWidthsFloatA
GetCharWidth32	equ GetCharWidth32A
GetCharWidth	equ GetCharWidthA
GetCharWidthFloat	equ GetCharWidthFloatA
GetCharacterPlacement	equ GetCharacterPlacementA
GetEnhMetaFile	equ GetEnhMetaFileA
GetEnhMetaFileDescription	equ GetEnhMetaFileDescriptionA
GetGlyphOutline	equ GetGlyphOutlineA
GetICMProfile	equ GetICMProfileA
GetKerningPairs	equ GetKerningPairsA
GetLogColorSpace	equ GetLogColorSpaceA
GetMetaFile	equ GetMetaFileA
GetObject	equ GetObjectA
GetOutlineTextMetrics	equ GetOutlineTextMetricsA
GetTextExtentExPoint	equ GetTextExtentExPointA
GetTextExtentPoint32	equ GetTextExtentPoint32A
GetTextExtentPoint	equ GetTextExtentPointA
GetTextFace	equ GetTextFaceA
GetTextMetrics	equ GetTextMetricsA
PolyTextOut	equ PolyTextOutA
RemoveFontResource	equ RemoveFontResourceA
ResetDC	equ ResetDCA
SetICMProfile	equ SetICMProfileA
StartDoc	equ StartDocA
TextOut	equ TextOutA
UpdateICMRegKey	equ UpdateICMRegKeyA

endif

; ***** End of include
