comment %
	Simple program that ejects disks/cds from all drives in the system if they
	are present. For more info on the calls see the http://msdn.microsoft.com
	and search for IOCTL or eject media
	James Joyce Dec01 http://james.ezylink.net.au
	%

.486
locals
jumps

.model flat, stdcall

include \tasm\win32.inc
include \tasm\extrn.inc

.data
regin 		DIOC_REGISTERS <0>
regout 		DIOC_REGISTERS <0>
reg_size	equ 1Ch

ovi		OSVERSIONINFO <>

about		db "Eject Demo 1.0",0
isNT		db 0
current_drive	db 0

disk		db "A:",0
bufferNT	db "\\.\\"
bufferNTa	db "A:",0		; NT/2k
buffer9x	db "\\.\vwin32",0	; 9x

modhand		dd 0	;The module handle for the application
hDevice		dd 0
buff		dd 0
uPrevErrorMode	dd 0

var1 		dd 0
var2 		dd 0
var3 		dd 0
var4 		dd 0

win_dim         RECT <?>

.const
IDD_DLG	 	equ 100	; Main dialog id
ID_ICON		equ 100

.code
main:
	call	InitCommonControls

	call	GetModuleHandleA, 0
	mov	[modhand], eax

	call	FindWindowA, 0, offset about
	cmp	eax,0
	jne	end		; don't run again if already running

	call	DialogBoxParamA, [modhand], IDD_DLG, 0, offset dialogproc, 0
end:
	call 	ExitProcess, 0
	ret

;----------------------------------------------------------------------------
dialogproc proc hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
;----------------------------------------------------------------------------
	cmp     [wmsg], WM_COMMAND
        je      button
        cmp     [wmsg], WM_CLOSE
        je      exitprog
	cmp	[wmsg], WM_INITDIALOG
	je	dialoginit

	xor	eax, eax
	ret

;----------------------------------------------------------------------------
dialoginit:
;----------------------------------------------------------------------------
	call    SetWindowText, [hwnd], offset about

	call	LoadIcon, modhand, ID_ICON
	push	eax
	call	SendMessage, [hwnd], WM_SETICON, ICON_SMALL, eax
	pop	eax
	call	SendMessage, [hwnd], WM_SETICON, ICON_BIG, eax	

	call	centre_win, hwnd

	mov	ovi.dwOSVersionInfoSize, SIZE ovi
	call	GetVersionEx, offset ovi
	.if ovi.dwPlatformId == VER_PLATFORM_WIN32_NT
		mov	isNT, 1
	.endif

	ret

; -------------------------------------
button:
; -------------------------------------
	mov	current_drive, 0
	mov	esi, offset disk
	mov	byte ptr [esi], "A"	; simple way to get "A"->"Z" as a string
	mov	esi, offset bufferNTa
	mov	byte ptr [esi], "A"

	mov	ecx, 25			; drives A-Z...
check_drv_loop:
	push	ecx

	inc	current_drive
	call	GetDriveType, offset disk
	.if eax!=2 && eax!=5		; Removable (2) CDROM (5)
		jmp	loop_end	
	.endif
	.if isNT==1			; under NT/2K/XP so use IOCTL
		call	SetErrorMode, SEM_FAILCRITICALERRORS
		mov	uPrevErrorMode, eax
		call	GetDiskFreeSpace, offset disk, offset var1, offset var2, offset var3,\
			offset var4	; simple way to chk disk/cd present
		.if eax!=0
			call	CreateFileA, offset bufferNT, GENERIC_READ, FILE_SHARE_READ|\
				FILE_SHARE_WRITE | FILE_SHARE_DELETE, NULL, OPEN_EXISTING,\
				0, NULL
		.else
			jmp	loop_end	
		.endif
	.else				; under 9x so use vwin32
		xor	eax, eax
		mov	al, current_drive
		mov	regin.reg_EAX, 440Dh		; IOCTL for block devices
		mov	regin.reg_EBX, eax		; zero-based drive
		mov	regin.reg_ECX, 0849h		; Eject Removable Media
		mov	regin.reg_EDX, 0
		mov	regin.reg_Flags, 1		; assume error carry flag
		call	GetDiskFreeSpace, offset disk, offset var1, offset var2, offset var3,\
			offset var4
		.if eax!=0
			call	CreateFileA, offset buffer9x, 0, 0, NULL, 0,\
				FILE_FLAG_DELETE_ON_CLOSE, NULL
		.else
			jmp	loop_end	
		.endif
	.endif
	mov	hDevice, eax

	.if isNT==1
		call	DeviceIoControl, hDevice, IOCTL_DISK_EJECT_MEDIA,\
			NULL, 0, NULL, 0, offset buff, NULL
		call	SetErrorMode, uPrevErrorMode
	.else
		call	DeviceIoControl, hDevice, VWIN32_DIOC_DOS_IOCTL,\
			offset regin, reg_size, offset regout, reg_size,\
			offset buff, NULL
	.endif
	.if eax!=0			; IT WORKED !
		call	MessageBoxA, 0, offset disk, offset about, MB_OK
	.endif

loop_end:
	call	CloseHandle, hDevice

	mov	esi, offset disk
	inc	byte ptr [esi]		; just inc it to get the next drive letter..
	mov	esi, offset bufferNTa
	inc	byte ptr [esi]

	pop	ecx
	loop	check_drv_loop

	ret

;----------------------------------------------
exitprog:
;----------------------------------------------
	call	EndDialog, [hwnd], 0
	ret

dialogproc    endp

; -------------------------------------------------------------------
centre_win proc window:DWORD	; edx=wdt, ecx=hgt @ return
; -------------------------------------------------------------------
        local   width:DWORD
        local   height:DWORD

        call    GetWindowRect, [window], offset win_dim
        mov     edx, win_dim.rcRight
        sub     edx, win_dim.rcLeft
	mov     ecx, win_dim.rcBottom
        sub     ecx, win_dim.rcTop         ; save for later
	mov     width, edx
        mov     height, ecx
	call    GetSystemMetrics, SM_CXSCREEN   ; width
	mov	ecx, width 
	sub     eax, ecx
	shr     eax,1
        mov     width, eax
	call    GetSystemMetrics, SM_CYSCREEN   ; height
	mov	ecx, height
	sub	eax, ecx
	shr     eax, 1
	mov	height, eax		; width, height
	call    SetWindowPos, [window], 0, width, height, 0,0, SWP_NOZORDER+\
                SWP_NOSIZE

	ret

endp centre_win

end main
