.386
.model flat,STDCALL

include W32.INC ; Some useful structures definitions. Available in
                ; Barry Kauler's Book companion disk.

UNICODE = 0     ; ANSI character set defined

extrn CreateFileMappingA:PROC
extrn MapViewOfFile:PROC
extrn UnmapViewOfFile:PROC
extrn OpenFileMappingA:PROC
extrn GetDlgItemTextA:PROC
extrn OpenFileMappingA:PROC

.data

IDD_DIALOG1  equ                   101
IDI_ICON1    equ                   102
IDC_BUTTON1  equ                   1000
IDC_BUTTON2  equ                   1001
IDC_EDIT1    equ                   1002
IDC_STATIC   equ                   -1

rect		RECT <?>
ps              PAINTSTRUCT <?>
hInstance	dd ?
hwnd		dd ?
height          dd ?
width           dd ?
s_height        dd ?
s_width         dd ?
szFileName      db 'shared.dat',0
szObjectName    db 'mmfobject',0
szRetData       db 1000h dup (0)
szDataSize      dd ?
szNewInst       db 'Open a new instance now!',0
.code

start:
	
	
        call GetModuleHandle, 0
        mov hInstance, eax

        call DialogBoxParam, hInstance, IDD_DIALOG1, 0, offset DlgProc, 0
        call ExitProcess, 0

        DlgProc PROC hWP:HWND, message:UINT, wparam:WPARAM, lparam:LPARAM
	
        LOCAL hDW:HWND
        LOCAL hwndChild:HWND
        LOCAL hFile:HANDLE
        LOCAL hFileMapping:HANDLE
        LOCAL lpMappedObject:POINTER

        .IF message==WM_PAINT

        call      paint

        .ELSEIF message==WM_COMMAND

        call      command

        .ELSEIF message==WM_INITDIALOG

        call      initdlg

        .ELSEIF message==WM_DESTROY

        call      destroy

        .ELSE

        xor eax, eax
        ret

        .ENDIF

	xor eax, eax
        ret 

paint:

        call BeginPaint, hWP, offset ps
 
        call EndPaint, hWP, offset ps
	
        mov eax, 0
	
        ret
	
command:

        cmp wparam, IDC_BUTTON1
        jz map
        cmp wparam, IDC_BUTTON2
        jz retrieve
        cmp wparam, IDCANCEL
        jz destroy

        mov eax, 0
        ret

map:
        call GetDlgItemTextA, hWP, IDC_EDIT1, offset szRetData, 40h
        lea     edi, [szRetData]
        xor     eax, eax
        or      ecx, -1
        repnz   scasb
        not     ecx
        sub     edi, ecx
        mov     szDataSize, ecx
        cmp     [szRetData], 0
        jnz     _map
        xor eax, eax
        ret

_map:

        call CreateFileMappingA, INVALID_HANDLE_VALUE, 0, PAGE_READWRITE, \
        0, 1000h, offset szObjectName
        mov     hFileMapping, eax

        call MapViewOfFile, hFileMapping, FILE_MAP_ALL_ACCESS, 0, 0, 1000h
        mov lpMappedObject, eax

        call GetDlgItem, hWP, IDC_BUTTON2
        mov hwndChild, eax
        call EnableWindow, hwndChild, TRUE

        xor      ecx, ecx
        mov      ecx, szDataSize
        lea      esi, [szRetData]
        mov      edi, lpMappedObject
        rep      movsb

        call GetDlgItem, hWP, IDC_BUTTON1
        mov hwndChild, eax
        call EnableWindow, hwndChild, FALSE
        call SetDlgItemTextA, hWP, IDC_EDIT1, offset szNewInst


        ret

retrieve:

        call OpenFileMappingA, FILE_MAP_ALL_ACCESS, TRUE, offset szObjectName
        mov     hFileMapping, eax
        call MapViewOfFile, hFileMapping, FILE_MAP_ALL_ACCESS, 0, 0, 1000h
        mov     lpMappedObject, eax
        call SetDlgItemTextA, hWP, IDC_EDIT1, lpMappedObject
        ret
        
initdlg:

        call OpenFileMappingA, FILE_MAP_ALL_ACCESS, TRUE, offset szObjectName
        cmp     eax, NULL
        jnz     another_instance
 
        call GetDlgItem, hWP, IDC_BUTTON2
        mov hwndChild, eax
        
        call EnableWindow, hwndChild, FALSE
        jmp Sk_Button

another_instance:

        call GetDlgItem, hWP, IDC_BUTTON1
        mov hwndChild, eax
        
        call EnableWindow, hwndChild, FALSE

Sk_Button:


        call GetSystemMetrics, SM_CXFULLSCREEN
        mov s_width, eax

        call GetSystemMetrics, SM_CYFULLSCREEN
        mov s_height, eax
        
        call GetWindowRect, hWP, offset rect

        mov eax, rect.rc_bottom
        sub eax, rect.rc_top
        mov height, eax

        mov eax, rect.rc_right
        sub eax, rect.rc_left
        mov width, eax

        mov eax, s_width
        sub eax, width
        shr eax, 01h
        mov s_width, eax

        mov eax, s_height
        sub eax, height
        shr eax, 01h
        mov s_height, eax

        call MoveWindow, hWP, s_width, s_height, width, height, FALSE

        ret

destroy:

        call UnmapViewOfFile, lpMappedObject
        call CloseHandle, hFileMapping
        call EndDialog, hWP, 0

        ret
	
        DlgProc endp
                	
	ends
	end	start
